#include "cstring.h"
#include <stdlib.h>
#include <math.h>

void itoa (long n, char *str)
{
	long i=::abs(n), j=0;
	if (n<0) str[j++] = '-'; else if (n==0) str[j++] = '0';
	while (i > 0)
	{
		int r = i % 10;
		char c;
		switch (r)
		{
			case 0 : c='0'; break;
			case 1 : c='1'; break;
			case 2 : c='2'; break;
			case 3 : c='3'; break;
			case 4 : c='4'; break;
			case 5 : c='5'; break;
			case 6 : c='6'; break;
			case 7 : c='7'; break;
			case 8 : c='8'; break;
			case 9 : c='9'; break;
		}
		str[j++] = c;
		i /= 10;
	}
	for (int i=((n<0)?1:0), k=--j; i<k; k--, i++) { char c = str[i]; str[i] = str[k]; str[k] = c; }
	str[j+1] = '\0';
}

void uitoa (unsigned long n, char *str)
{
	unsigned long i=n, j=0;
	if (n==0) str[j++] = '0';
	while (i > 0)
	{
		int r = i % 10;
		char c;
		switch (r)
		{
			case 0 : c='0'; break;
			case 1 : c='1'; break;
			case 2 : c='2'; break;
			case 3 : c='3'; break;
			case 4 : c='4'; break;
			case 5 : c='5'; break;
			case 6 : c='6'; break;
			case 7 : c='7'; break;
			case 8 : c='8'; break;
			case 9 : c='9'; break;
		}
		str[j++] = c;
		i /= 10;
	}
	for (int i=((n<0)?1:0), k=--j; i<k; k--, i++) { char c = str[i]; str[i] = str[k]; str[k] = c; }
	str[j+1] = '\0';
}

char * ftoa (double f, double sigfigs=1.0)
{
	char a[81];
	int prec, width, front, fit;

	front = (f==0)? 1 : (int)log10(fabs(f))+1;
	if (sigfigs < 1.0 && sigfigs >= 0.0)  // fit number to tolerance
	{
		double rem = fabs(f) - int(f);
		prec=0;
		int num = (int)rem;
		while (rem*pow(10,prec) - num > sigfigs) num = int(rem*pow(10,++prec));
		width = front;
		::sprintf (a, "%#*.*f", width, prec, f);
	}
	else
	{
		if (sigfigs < 2.0) sigfigs = 2.0;
		if (front > (int)sigfigs)
		{
			::sprintf (a, "%#.*e", (int)sigfigs-1, f);
		}
		else
		{
			prec = (int)sigfigs - front;
			if (f==0.0) width = 2;
			else width = front + prec + 1;
			::sprintf (a, "%#*.*f", width, prec, f);
		}
	}
	return ::strdup (a);
}

CString::CString (const char *inString)
	:String	 ((inString == NULL) ? NULL : inString, (inString == NULL) ? 0 : strlen(inString)+1)
{ 
	if (String.GetLength() == 0) String += '\0';
}

CString::CString (const char inChar)
{
	String += inChar;
	String += '\0';
}

CString::CString (const CString &inString)
	:String  (inString.String)
{ }

CString::CString (const long inLong)
	:String  ()
{ 
	char str[15];
	::itoa (inLong, str);
	operator += (CString(str));
}

CString::CString (const unsigned long inLong)
	:String  ()
{ 
	char str[15];
	::uitoa (inLong, str);
	operator += (CString(str));
}

CString::CString (const double inDouble)
	:String	 ()
{
	char *str = ::ftoa (inDouble);
	operator += (CString(str));
	free (str);
}

CString::~CString ()
{ }

size_t CString::GetLength () const 
{
	return String.GetLength()-1;
}

char * CString::Get (const size_t inIndex) const
{
	return String.Get (inIndex);
}

CString & CString::FGets (const size_t inMax, FILE * inFile)
{
	char *input = new char [inMax];
	::fgets (input, inMax, inFile);
	operator = (input);
	delete [] input;
	return *this;
}

void CString::Insert (const char inChar, const size_t inIndex)
{
	String.Insert (inChar, inIndex);
}

void CString::Insert (const CString &inString, const size_t inIndex)
{
	String.Insert (inString.String-'\0', inIndex);
}

void CString::Delete (const char inChar)
{
	String.Delete (inChar);
	if (*String[String.GetLength()-1] != '\0') String += '\0';
}

void CString::Delete (const CString &inString)
{
	String.Delete (inString.String-'\0');
}

void CString::Delete (const size_t inStart, const size_t inLength)
{
	String.Delete (inStart, inLength);
	if (*String[String.GetLength()-1] != '\0') String += '\0';
}

bool CString::Find (const char inChar, const size_t inStart, size_t *outIndex) const
{
	return String.Find (inChar, inStart, outIndex);
}

bool CString::Find (const CString &inString, const size_t inStart, size_t *outIndex) const
{
	return String.Find (inString.String-'\0', inStart, outIndex);
}

CStrings CString::Cut (const CString &inDelimitor, const bool inAbsorb) const
{
	CStrings outStrings; CString This (*this); size_t outIndex=0;
	while (This.Find (inDelimitor, 0, &outIndex))
	{
		if (!inAbsorb) 
		{
			outStrings += This;
			outStrings[outStrings.GetLength()-1] -> 
				Delete (outIndex, outStrings[outStrings.GetLength()-1] -> GetLength() - outIndex);
		}
		else if (outIndex > 0)
		{
			outStrings += This;
			outStrings[outStrings.GetLength()-1] -> 
				Delete (outIndex, outStrings[outStrings.GetLength()-1] -> GetLength() - outIndex);
		}
		This.String.Delete (0, outIndex+inDelimitor.GetLength());
	}
	outStrings += This;
	return outStrings;
}

void CString::Substitute (const CString &inOld, const CString &inNew)
{
	size_t outIndex=0;
	while (Find (inOld, 0, &outIndex))
	{
		Delete (outIndex, inOld.GetLength());
		Insert (inNew, outIndex);
	}
}

CStrings CString::GetLines (const bool inAbsorb) const
{
	return Cut (CString("\n"), inAbsorb);
}

void CString::Sort ()
{
	String -= '\0';
	String.Sort ();
	String += '\0';
}

long CString::ToLong (const unsigned int inBase) const
{
	return ::strtol (String.Get(), NULL, inBase);
}

unsigned long CString::ToULong (const unsigned int inBase) const
{
	return ::strtoul (String.Get(), NULL, inBase);
}

double CString::ToDouble () const
{
	return ::strtod (String.Get(), NULL);
}

Bool CString::ToBool () const
{
	if (*this == CString("true" )) return true;
	if (*this == CString("false")) return false;
	return ToULong();
}

CString & CString::ToLower ()
{
	for (size_t i=String.GetLength(); i>0; i--) *String[i-1] = ::tolower(*String[i-1]);
	return *this;
}

CString & CString::ToUpper ()
{
	for (size_t i=String.GetLength(); i>0; i--) *String[i-1] = ::toupper(*String[i-1]);
	return *this;
}

char * CString::operator [] (const size_t inIndex) const
{
	return String[inIndex];
}

bool CString::operator == (const CString &inString) const
{
	return strcmp (String.Get(), inString.String.Get()) == 0;
}

bool CString::operator != (const CString &inString) const
{
	return strcmp (String.Get(), inString.String.Get()) != 0;
}

bool CString::operator < (const CString &inString) const
{
	return strcmp (String.Get(), inString.String.Get()) < 0;
}

bool CString::operator <= (const CString &inString) const
{
	return strcmp (String.Get(), inString.String.Get()) <= 0;
}

bool CString::operator > (const CString &inString) const
{
	return strcmp (String.Get(), inString.String.Get()) > 0;
}

bool CString::operator >= (const CString &inString) const
{
	return strcmp (String.Get(), inString.String.Get()) >= 0;
}

CString & CString::operator = (const CString &inString)
{
	String = inString.String;
	return *this;
}

CString & CString::operator += (const char inChar)
{
	if (inChar != '\0')
	{
		String -= '\0';
		String += inChar;
		String += '\0';
	}
	return *this;
}

CString & CString::operator += (const CString &inString)
{
	String -= '\0';
	String += inString.String;
	return *this;
}

CString & CString::operator -= (const char inChar)
{
	if (inChar != '\0') String -= inChar;
	return *this;
}

CString & CString::operator -= (const CString &inString)
{
	String -= (inString.String - '\0');
	return *this;
}

CString CString::operator + (const char inChar) const
{
	return CString (*this) += inChar;
}

CString CString::operator + (const CString &inString) const
{
	return CString (*this) += inString;
}

CString CString::operator - (const char inChar) const
{
	return CString (*this) -= inChar;
}

CString CString::operator - (const CString &inString) const
{
	return CString (*this) -= inString;
}

CString operator + (const char *inChar, const CString &inString)
{
	return CString (inChar) += inString;
}

CString operator - (const char *inChar, const CString &inString)
{
	return CString (inChar) -= inString;
}

CString operator + (const char inChar, const CString &inString)
{
	return CString(inChar) += inString;
}

