/*******************************************************************************************************************************************
 cclass.h
 Absolute abstract class definition. Instance's metaclass association introduction. Every metaclassed class defines at least the following 
 functions :
 
 - a function that dynamically tests the instance definition
	Bool ClassIs (const CMetaClass *) const;
 - a virtual function that returns the correct instance associated metaclass. Those functionnalities are given the cmetaclass.h defined
   macro SECTION_GENERIC_METACLASS, SECTION_CAPSULE_METACLASS and SECTION_DYNAMIC_METACLASS
 	virtual const CMetaClass * GetMetaClass () const;
 - a static function that returns a default instance of the metaclassed class only if it is a dynamic one, it has got a default constructor
   and the metaclass is able to access it i.e. only if the metaclass type is SECTION_DYNAMIC_METACLASS. You should not use directly this
   function. It is only defined for the CMetaClass "CClass * CMetaClass::ClassInstanciate ()" attribute.
   	static CClass * Instanciate ();
*******************************************************************************************************************************************/

#ifndef __CCLASS_H__
#define __CCLASS_H__

#include "cmetaclass.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// CClass class
//------------------------------------------------------------------------------------------------------------------------------------------
class CClass
{
	// instanciation section
	public :

		CClass			();
		virtual ~CClass		() =0;

	// dynamic definition test
	public :

		// instance definition dynamic test
		Bool			ClassIs		(const CMetaClass *) const;

		// generic description
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_GENERIC_METACLASS ('clss', CClass, NULL);

#endif
