/* binary.c generated by valac 0.14.2, the Vala compiler
 * generated from binary.vala, do not modify */

/*
 * Authored by Frederik 'playya' Sdun <Frederik.Sdun@googlemail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define FSO_FRAMEWORK_TYPE_BIN_BUILDER (fso_framework_bin_builder_get_type ())
#define FSO_FRAMEWORK_BIN_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BIN_BUILDER, FsoFrameworkBinBuilder))
#define FSO_FRAMEWORK_BIN_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BIN_BUILDER, FsoFrameworkBinBuilderClass))
#define FSO_FRAMEWORK_IS_BIN_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BIN_BUILDER))
#define FSO_FRAMEWORK_IS_BIN_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BIN_BUILDER))
#define FSO_FRAMEWORK_BIN_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BIN_BUILDER, FsoFrameworkBinBuilderClass))

typedef struct _FsoFrameworkBinBuilder FsoFrameworkBinBuilder;
typedef struct _FsoFrameworkBinBuilderClass FsoFrameworkBinBuilderClass;
typedef struct _FsoFrameworkBinBuilderPrivate FsoFrameworkBinBuilderPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FSO_FRAMEWORK_TYPE_BIN_READER (fso_framework_bin_reader_get_type ())
#define FSO_FRAMEWORK_BIN_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BIN_READER, FsoFrameworkBinReader))
#define FSO_FRAMEWORK_BIN_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BIN_READER, FsoFrameworkBinReaderClass))
#define FSO_FRAMEWORK_IS_BIN_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BIN_READER))
#define FSO_FRAMEWORK_IS_BIN_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BIN_READER))
#define FSO_FRAMEWORK_BIN_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BIN_READER, FsoFrameworkBinReaderClass))

typedef struct _FsoFrameworkBinReader FsoFrameworkBinReader;
typedef struct _FsoFrameworkBinReaderClass FsoFrameworkBinReaderClass;
typedef struct _FsoFrameworkBinReaderPrivate FsoFrameworkBinReaderPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FsoFrameworkBinBuilder {
	GObject parent_instance;
	FsoFrameworkBinBuilderPrivate * priv;
	GList* _data;
};

struct _FsoFrameworkBinBuilderClass {
	GObjectClass parent_class;
};

struct _FsoFrameworkBinBuilderPrivate {
	GDataStreamByteOrder _endianess;
	guint _alignment;
	guint8 _alignment_byte;
};

struct _FsoFrameworkBinReader {
	GObject parent_instance;
	FsoFrameworkBinReaderPrivate * priv;
	GDataStreamByteOrder endianess;
};

struct _FsoFrameworkBinReaderClass {
	GObjectClass parent_class;
};

struct _FsoFrameworkBinReaderPrivate {
	guint8* data;
	gint data_length1;
	gint _data_size_;
	gint _alignment;
};

typedef enum  {
	FSO_FRAMEWORK_BIN_READER_ERROR_OUT_OF_RANGE,
	FSO_FRAMEWORK_BIN_READER_ERROR_CHECKSUM_IN_DATA,
	FSO_FRAMEWORK_BIN_READER_ERROR_ILLEGAL_PARAMETER
} FsoFrameworkBinReaderError;
#define FSO_FRAMEWORK_BIN_READER_ERROR fso_framework_bin_reader_error_quark ()

static gpointer fso_framework_bin_builder_parent_class = NULL;
static gpointer fso_framework_bin_reader_parent_class = NULL;

GType fso_framework_bin_builder_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_BIN_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_BIN_BUILDER, FsoFrameworkBinBuilderPrivate))
enum  {
	FSO_FRAMEWORK_BIN_BUILDER_DUMMY_PROPERTY,
	FSO_FRAMEWORK_BIN_BUILDER_LENGTH,
	FSO_FRAMEWORK_BIN_BUILDER_ENDIANESS,
	FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT,
	FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT_BYTE,
	FSO_FRAMEWORK_BIN_BUILDER_PACKED
};
guint8 fso_framework_bin_builder_nth_byte (guint64 val, guint byte);
FsoFrameworkBinBuilder* fso_framework_bin_builder_new (gint alignment, guint8 alignment_byte, GDataStreamByteOrder e);
FsoFrameworkBinBuilder* fso_framework_bin_builder_construct (GType object_type, gint alignment, guint8 alignment_byte, GDataStreamByteOrder e);
void fso_framework_bin_builder_set_endianess (FsoFrameworkBinBuilder* self, GDataStreamByteOrder value);
void fso_framework_bin_builder_set_alignment (FsoFrameworkBinBuilder* self, guint value);
void fso_framework_bin_builder_set_alignment_byte (FsoFrameworkBinBuilder* self, guint8 value);
void fso_framework_bin_builder_append_string (FsoFrameworkBinBuilder* self, const gchar* s, gboolean include_null_byte, gint pad_to, guint8 padding);
void fso_framework_bin_builder_append_pad (FsoFrameworkBinBuilder* self, glong length, guint8 byte);
void fso_framework_bin_builder_append_align (FsoFrameworkBinBuilder* self);
void fso_framework_bin_builder_append_data (FsoFrameworkBinBuilder* self, guint8* d, int d_length1, gint pad_to, guint8 padding);
void fso_framework_bin_builder_append_uint8 (FsoFrameworkBinBuilder* self, guint8 c);
void fso_framework_bin_builder_append_int8 (FsoFrameworkBinBuilder* self, gint8 c);
void fso_framework_bin_builder_append_uint16 (FsoFrameworkBinBuilder* self, guint16 v);
guint16 fso_framework_bin_builder_uint16_convert (FsoFrameworkBinBuilder* self, guint16 val);
void fso_framework_bin_builder_append_int16 (FsoFrameworkBinBuilder* self, gint16 v);
void fso_framework_bin_builder_append_uint32 (FsoFrameworkBinBuilder* self, guint32 v);
guint32 fso_framework_bin_builder_uint32_convert (FsoFrameworkBinBuilder* self, guint32 val);
void fso_framework_bin_builder_append_int32 (FsoFrameworkBinBuilder* self, gint32 v);
void fso_framework_bin_builder_append_uint64 (FsoFrameworkBinBuilder* self, guint64 v);
guint64 fso_framework_bin_builder_uint64_convert (FsoFrameworkBinBuilder* self, guint64 val);
void fso_framework_bin_builder_append_int64 (FsoFrameworkBinBuilder* self, gint64 v);
void fso_framework_bin_builder_append_custom (FsoFrameworkBinBuilder* self, guint64 val, gint size);
guint fso_framework_bin_builder_get_alignment (FsoFrameworkBinBuilder* self);
guint8 fso_framework_bin_builder_get_alignment_byte (FsoFrameworkBinBuilder* self);
void fso_framework_bin_builder_append_crc16 (FsoFrameworkBinBuilder* self, gint start, gint end);
guint16 fso_framework_checksum_crc16 (guint8* data, int data_length1);
guint8* fso_framework_bin_builder_get_data (FsoFrameworkBinBuilder* self, int* result_length1);
void fso_framework_bin_builder_append_bitfield (FsoFrameworkBinBuilder* self, gint position, guint64 value, gint offset, gint bit_length, gint byte_length);
GList* fso_framework_bin_builder_get_at (FsoFrameworkBinBuilder* self, gint position, guint assure_nth);
guint fso_framework_bin_builder_get_length (FsoFrameworkBinBuilder* self);
void fso_framework_bin_builder_set_bit (guint8* data, gint bit, gboolean value);
void fso_framework_bin_builder_set_uint8 (FsoFrameworkBinBuilder* self, guint8 val, gint position);
void fso_framework_bin_builder_set_uint16 (FsoFrameworkBinBuilder* self, guint16 val, gint position);
void fso_framework_bin_builder_set_uint32 (FsoFrameworkBinBuilder* self, guint32 val, gint position);
void fso_framework_bin_builder_set_uint64 (FsoFrameworkBinBuilder* self, guint64 val, gint position);
void fso_framework_bin_builder_set_string (FsoFrameworkBinBuilder* self, const gchar* s, gint position, gboolean include_null_byte, guint pad_to, guint8 padding);
void fso_framework_bin_builder_set_data (FsoFrameworkBinBuilder* self, guint8* d, int d_length1, gint position, guint pad_to, guint8 padding);
void fso_framework_bin_builder_set_align (FsoFrameworkBinBuilder* self, gint pos);
void fso_framework_bin_builder_set_crc16 (FsoFrameworkBinBuilder* self, gint pos, gint start, gint end);
void fso_framework_bin_builder_insert_uint8 (FsoFrameworkBinBuilder* self, guint8 val, gint position);
void fso_framework_bin_builder_insert_uint16 (FsoFrameworkBinBuilder* self, guint16 val, gint position);
void fso_framework_bin_builder_insert_uint32 (FsoFrameworkBinBuilder* self, guint32 val, gint position);
void fso_framework_bin_builder_insert_uint64 (FsoFrameworkBinBuilder* self, guint64 val, gint position);
void fso_framework_bin_builder_insert_string (FsoFrameworkBinBuilder* self, const gchar* str, gint position);
void fso_framework_bin_builder_insert_data (FsoFrameworkBinBuilder* self, guint8* data, int data_length1, gint position);
void fso_framework_bin_builder_insert_crc16 (FsoFrameworkBinBuilder* self, gint pos, gint start, gint end);
void fso_framework_bin_builder_reset (FsoFrameworkBinBuilder* self);
GDataStreamByteOrder fso_framework_bin_builder_get_endianess (FsoFrameworkBinBuilder* self);
gboolean fso_framework_bin_builder_get_packed (FsoFrameworkBinBuilder* self);
static GObject * fso_framework_bin_builder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void fso_framework_bin_builder_finalize (GObject* obj);
static void _vala_fso_framework_bin_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_fso_framework_bin_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType fso_framework_bin_reader_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_BIN_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_BIN_READER, FsoFrameworkBinReaderPrivate))
enum  {
	FSO_FRAMEWORK_BIN_READER_DUMMY_PROPERTY,
	FSO_FRAMEWORK_BIN_READER_ALIGNMENT,
	FSO_FRAMEWORK_BIN_READER_PACKED
};
FsoFrameworkBinReader* fso_framework_bin_reader_new (guint8* d, int d_length1, gint alignment, GDataStreamByteOrder e);
FsoFrameworkBinReader* fso_framework_bin_reader_construct (GType object_type, guint8* d, int d_length1, gint alignment, GDataStreamByteOrder e);
static guint8* _vala_array_dup1 (guint8* self, int length);
void fso_framework_bin_reader_set_alignment (FsoFrameworkBinReader* self, gint value);
FsoFrameworkBinReader* fso_framework_bin_reader_new_void_pointer (void* d, guint len, gint alignment, GDataStreamByteOrder e);
FsoFrameworkBinReader* fso_framework_bin_reader_construct_void_pointer (GType object_type, void* d, guint len, gint alignment, GDataStreamByteOrder e);
GQuark fso_framework_bin_reader_error_quark (void);
guint8 fso_framework_bin_reader_get_uint8 (FsoFrameworkBinReader* self, gint pos, GError** error);
static gint fso_framework_bin_reader_offset (FsoFrameworkBinReader* self, gsize type_size);
static gint fso_framework_bin_reader_absolute_position (FsoFrameworkBinReader* self, gint pos, gint num_bytes, GError** error);
guint16 fso_framework_bin_reader_get_uint16 (FsoFrameworkBinReader* self, gint pos, GError** error);
guint16 fso_framework_bin_reader_uint16_convert (FsoFrameworkBinReader* self, guint16 val);
guint32 fso_framework_bin_reader_get_uint32 (FsoFrameworkBinReader* self, gint pos, GError** error);
guint32 fso_framework_bin_reader_uint32_convert (FsoFrameworkBinReader* self, guint32 val);
guint64 fso_framework_bin_reader_get_uint64 (FsoFrameworkBinReader* self, gint pos, GError** error);
guint64 fso_framework_bin_reader_uint64_convert (FsoFrameworkBinReader* self, guint64 val);
gchar* fso_framework_bin_reader_get_string (FsoFrameworkBinReader* self, gint pos, gint length, GError** error);
guint8* fso_framework_bin_reader_get_data (FsoFrameworkBinReader* self, gint pos, gint length, int* result_length1, GError** error);
static guint8* _vala_array_dup2 (guint8* self, int length);
gboolean fso_framework_bin_reader_crc16_verify (FsoFrameworkBinReader* self, gint crc_position, gint start, gint end, GError** error);
gboolean fso_framework_checksum_crc16_verify (guint8* data, int data_length1, guint16 expected);
guint64 fso_framework_bin_reader_get_bits (FsoFrameworkBinReader* self, gint position, gint offset, gint length, GError** error);
guint8 fso_framework_bin_reader_get_bit (guint8 data, gint bit);
gint fso_framework_bin_reader_get_alignment (FsoFrameworkBinReader* self);
gboolean fso_framework_bin_reader_get_packed (FsoFrameworkBinReader* self);
static void fso_framework_bin_reader_finalize (GObject* obj);
static void _vala_fso_framework_bin_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_fso_framework_bin_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


guint8 fso_framework_bin_builder_nth_byte (guint64 val, guint byte) {
	guint8 result = 0U;
	guint _tmp0_;
	guint64 _tmp6_;
	guint _tmp7_;
	_tmp0_ = byte;
	if (((gulong) _tmp0_) > sizeof (guint64)) {
		guint _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = byte;
		_tmp2_ = g_strdup_printf ("%u", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("byte value out of range: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_critical ("binary.vala:33: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		result = (guint8) 0;
		return result;
	}
	_tmp6_ = val;
	_tmp7_ = byte;
	result = (guint8) ((_tmp6_ >> (_tmp7_ * 8)) & 0xFF);
	return result;
}


FsoFrameworkBinBuilder* fso_framework_bin_builder_construct (GType object_type, gint alignment, guint8 alignment_byte, GDataStreamByteOrder e) {
	FsoFrameworkBinBuilder * self = NULL;
	GDataStreamByteOrder _tmp0_;
	gint _tmp1_;
	guint8 _tmp2_;
	self = (FsoFrameworkBinBuilder*) g_object_new (object_type, NULL);
	_tmp0_ = e;
	fso_framework_bin_builder_set_endianess (self, _tmp0_);
	_tmp1_ = alignment;
	fso_framework_bin_builder_set_alignment (self, (guint) _tmp1_);
	_tmp2_ = alignment_byte;
	fso_framework_bin_builder_set_alignment_byte (self, _tmp2_);
	return self;
}


FsoFrameworkBinBuilder* fso_framework_bin_builder_new (gint alignment, guint8 alignment_byte, GDataStreamByteOrder e) {
	return fso_framework_bin_builder_construct (FSO_FRAMEWORK_TYPE_BIN_BUILDER, alignment, alignment_byte, e);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void fso_framework_bin_builder_append_string (FsoFrameworkBinBuilder* self, const gchar* s, gboolean include_null_byte, gint pad_to, guint8 padding) {
	const gchar* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	guint8 _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	self->_data = g_list_reverse (self->_data);
	_tmp0_ = s;
	_tmp1_ = string_get_data (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	{
		guint8* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp2_;
		i_collection_length1 = _tmp2__length1;
		for (i_it = 0; i_it < _tmp2__length1; i_it = i_it + 1) {
			guint8 i = 0U;
			i = i_collection[i_it];
			{
				guint8 _tmp3_;
				_tmp3_ = i;
				self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp3_));
			}
		}
	}
	_tmp4_ = include_null_byte;
	if (_tmp4_) {
		self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER ((guint8) '\0'));
	}
	self->_data = g_list_reverse (self->_data);
	_tmp6_ = include_null_byte;
	if (_tmp6_) {
		_tmp5_ = 1;
	} else {
		_tmp5_ = 0;
	}
	_tmp7_ = pad_to;
	_tmp8_ = s;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp5_;
	_tmp12_ = padding;
	fso_framework_bin_builder_append_pad (self, (glong) ((_tmp7_ - _tmp10_) - _tmp11_), _tmp12_);
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_data (FsoFrameworkBinBuilder* self, guint8* d, int d_length1, gint pad_to, guint8 padding) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8 _tmp4_;
	g_return_if_fail (self != NULL);
	self->_data = g_list_reverse (self->_data);
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	{
		guint8* e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp0_;
		e_collection_length1 = _tmp0__length1;
		for (e_it = 0; e_it < _tmp0__length1; e_it = e_it + 1) {
			guint8 e = 0U;
			e = e_collection[e_it];
			{
				guint8 _tmp1_;
				_tmp1_ = e;
				self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp1_));
			}
		}
	}
	self->_data = g_list_reverse (self->_data);
	_tmp2_ = pad_to;
	_tmp3_ = d;
	_tmp3__length1 = d_length1;
	_tmp4_ = padding;
	fso_framework_bin_builder_append_pad (self, (glong) (_tmp2_ - _tmp3__length1), _tmp4_);
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_uint8 (FsoFrameworkBinBuilder* self, guint8 c) {
	guint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = c;
	self->_data = g_list_append (self->_data, GUINT_TO_POINTER (_tmp0_));
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_int8 (FsoFrameworkBinBuilder* self, gint8 c) {
	gint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = c;
	self->_data = g_list_append (self->_data, GUINT_TO_POINTER ((guint8) _tmp0_));
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_uint16 (FsoFrameworkBinBuilder* self, guint16 v) {
	guint16 _tmp0_;
	guint16 _tmp1_ = 0U;
	guint16 _tmp2_;
	guint8 _tmp3_ = 0U;
	guint16 _tmp4_;
	guint8 _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = v;
	_tmp1_ = fso_framework_bin_builder_uint16_convert (self, _tmp0_);
	v = _tmp1_;
	_tmp2_ = v;
	_tmp3_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp2_, (guint) 1);
	self->_data = g_list_append (self->_data, GUINT_TO_POINTER (_tmp3_));
	_tmp4_ = v;
	_tmp5_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp4_, (guint) 0);
	self->_data = g_list_append (self->_data, GUINT_TO_POINTER (_tmp5_));
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_int16 (FsoFrameworkBinBuilder* self, gint16 v) {
	gint16 _tmp0_;
	guint16 _tmp1_ = 0U;
	guint16 uv;
	guint8 _tmp2_ = 0U;
	guint8 _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = v;
	_tmp1_ = fso_framework_bin_builder_uint16_convert (self, (guint16) _tmp0_);
	uv = _tmp1_;
	_tmp2_ = fso_framework_bin_builder_nth_byte ((guint64) uv, (guint) 1);
	self->_data = g_list_append (self->_data, GUINT_TO_POINTER (_tmp2_));
	_tmp3_ = fso_framework_bin_builder_nth_byte ((guint64) uv, (guint) 0);
	self->_data = g_list_append (self->_data, GUINT_TO_POINTER (_tmp3_));
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_uint32 (FsoFrameworkBinBuilder* self, guint32 v) {
	guint32 _tmp0_;
	guint32 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = v;
	_tmp1_ = fso_framework_bin_builder_uint32_convert (self, _tmp0_);
	v = _tmp1_;
	self->_data = g_list_reverse (self->_data);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				guint32 _tmp6_;
				gint _tmp7_;
				guint8 _tmp8_ = 0U;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < 4)) {
					break;
				}
				_tmp6_ = v;
				_tmp7_ = i;
				_tmp8_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp6_, (guint) _tmp7_);
				self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp8_));
			}
		}
	}
	self->_data = g_list_reverse (self->_data);
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_int32 (FsoFrameworkBinBuilder* self, gint32 v) {
	gint32 _tmp0_;
	guint32 _tmp1_ = 0U;
	guint32 uv;
	g_return_if_fail (self != NULL);
	_tmp0_ = v;
	_tmp1_ = fso_framework_bin_builder_uint32_convert (self, (guint32) _tmp0_);
	uv = _tmp1_;
	self->_data = g_list_reverse (self->_data);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				guint32 _tmp6_;
				gint _tmp7_;
				guint8 _tmp8_ = 0U;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < 4)) {
					break;
				}
				_tmp6_ = uv;
				_tmp7_ = i;
				_tmp8_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp6_, (guint) _tmp7_);
				self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp8_));
			}
		}
	}
	self->_data = g_list_reverse (self->_data);
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_uint64 (FsoFrameworkBinBuilder* self, guint64 v) {
	guint64 _tmp0_;
	guint64 _tmp1_ = 0ULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = v;
	_tmp1_ = fso_framework_bin_builder_uint64_convert (self, _tmp0_);
	v = _tmp1_;
	self->_data = g_list_reverse (self->_data);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				guint64 _tmp6_;
				gint _tmp7_;
				guint8 _tmp8_ = 0U;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < 8)) {
					break;
				}
				_tmp6_ = v;
				_tmp7_ = i;
				_tmp8_ = fso_framework_bin_builder_nth_byte (_tmp6_, (guint) _tmp7_);
				self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp8_));
			}
		}
	}
	self->_data = g_list_reverse (self->_data);
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_int64 (FsoFrameworkBinBuilder* self, gint64 v) {
	gint64 _tmp0_;
	guint64 _tmp1_ = 0ULL;
	guint64 uv;
	g_return_if_fail (self != NULL);
	_tmp0_ = v;
	_tmp1_ = fso_framework_bin_builder_uint64_convert (self, (guint64) _tmp0_);
	uv = _tmp1_;
	self->_data = g_list_reverse (self->_data);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				guint64 _tmp6_;
				gint _tmp7_;
				guint8 _tmp8_ = 0U;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < 8)) {
					break;
				}
				_tmp6_ = uv;
				_tmp7_ = i;
				_tmp8_ = fso_framework_bin_builder_nth_byte (_tmp6_, (guint) _tmp7_);
				self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp8_));
			}
		}
	}
	self->_data = g_list_reverse (self->_data);
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_custom (FsoFrameworkBinBuilder* self, guint64 val, gint size) {
	g_return_if_fail (self != NULL);
	{
		gint _tmp0_;
		gint i;
		_tmp0_ = size;
		i = _tmp0_ - 1;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				guint64 _tmp5_;
				gint _tmp6_;
				guint8 _tmp7_ = 0U;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ >= 0)) {
					break;
				}
				_tmp5_ = val;
				_tmp6_ = i;
				_tmp7_ = fso_framework_bin_builder_nth_byte (_tmp5_, (guint) _tmp6_);
				self->_data = g_list_append (self->_data, GUINT_TO_POINTER (_tmp7_));
			}
		}
	}
	fso_framework_bin_builder_append_align (self);
}


void fso_framework_bin_builder_append_pad (FsoFrameworkBinBuilder* self, glong length, guint8 byte) {
	glong _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = length;
	if (_tmp0_ > ((glong) 0)) {
		self->_data = g_list_reverse (self->_data);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp2_;
					gint _tmp4_;
					glong _tmp5_;
					guint8 _tmp6_;
					_tmp2_ = _tmp1_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = length;
					if (!(((glong) _tmp4_) < _tmp5_)) {
						break;
					}
					_tmp6_ = byte;
					self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp6_));
				}
			}
		}
		self->_data = g_list_reverse (self->_data);
	}
}


void fso_framework_bin_builder_append_align (FsoFrameworkBinBuilder* self) {
	guint _tmp0_;
	guint _tmp1_;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	guint _tmp4_;
	guint align_bytes;
	guint _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_alignment;
	if (_tmp0_ == ((guint) 0)) {
		return;
	}
	_tmp1_ = self->priv->_alignment;
	_tmp2_ = self->_data;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = self->priv->_alignment;
	align_bytes = _tmp1_ - (_tmp3_ % _tmp4_);
	_tmp5_ = align_bytes;
	_tmp6_ = self->priv->_alignment;
	if (_tmp5_ != _tmp6_) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
				while (TRUE) {
					gboolean _tmp8_;
					gint _tmp10_;
					guint _tmp11_;
					guint8 _tmp12_;
					_tmp8_ = _tmp7_;
					if (!_tmp8_) {
						gint _tmp9_;
						_tmp9_ = i;
						i = _tmp9_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp10_ = i;
					_tmp11_ = align_bytes;
					if (!(((guint) _tmp10_) < _tmp11_)) {
						break;
					}
					_tmp12_ = self->priv->_alignment_byte;
					self->_data = g_list_append (self->_data, GUINT_TO_POINTER (_tmp12_));
				}
			}
		}
	}
}


void fso_framework_bin_builder_append_crc16 (FsoFrameworkBinBuilder* self, gint start, gint end) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint _tmp3_;
	guint16 _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_bin_builder_get_data (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = start;
	_tmp3_ = end;
	_tmp4_ = fso_framework_checksum_crc16 (_tmp1_ + _tmp2_, _tmp3_ - _tmp2_);
	fso_framework_bin_builder_append_uint16 (self, _tmp4_);
}


void fso_framework_bin_builder_append_bitfield (FsoFrameworkBinBuilder* self, gint position, guint64 value, gint offset, gint bit_length, gint byte_length) {
	gint x;
	gint _tmp0_;
	gint _tmp1_;
	GList* _tmp2_ = NULL;
	GList* l;
	g_return_if_fail (self != NULL);
	x = 0;
	_tmp0_ = position;
	_tmp1_ = byte_length;
	_tmp2_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) _tmp1_);
	l = _tmp2_;
	{
		gint _tmp3_;
		gint i;
		_tmp3_ = offset;
		i = _tmp3_;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gint _tmp8_;
				guint _tmp9_;
				guint _tmp10_;
				gboolean _tmp11_ = FALSE;
				guint64 _tmp12_;
				gint _tmp13_;
				gboolean _tmp14_;
				gboolean v;
				GList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				GList* _tmp18_ = NULL;
				gint _tmp19_;
				gboolean _tmp20_;
				gint _tmp21_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = offset;
				_tmp9_ = fso_framework_bin_builder_get_length (self);
				_tmp10_ = _tmp9_;
				if (!(((guint) _tmp7_) < (_tmp8_ + _tmp10_))) {
					break;
				}
				_tmp12_ = value;
				_tmp13_ = x;
				if ((_tmp12_ & (1 << _tmp13_)) == ((guint64) 0)) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = FALSE;
				}
				_tmp14_ = _tmp11_;
				v = _tmp14_;
				_tmp15_ = l;
				_tmp16_ = position;
				_tmp17_ = offset;
				_tmp18_ = g_list_nth (_tmp15_, (guint) (_tmp16_ + (_tmp17_ / 8)));
				_tmp19_ = offset;
				_tmp20_ = v;
				fso_framework_bin_builder_set_bit (&_tmp18_->data, _tmp19_ % 8, _tmp20_);
				_tmp21_ = x;
				x = _tmp21_ + 1;
			}
		}
	}
}


void fso_framework_bin_builder_set_uint8 (FsoFrameworkBinBuilder* self, guint8 val, gint position) {
	GList* l;
	gint _tmp0_;
	gint _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	guint8 _tmp5_;
	g_return_if_fail (self != NULL);
	l = NULL;
	_tmp0_ = position;
	if (_tmp0_ < 0) {
		guint8 _tmp1_;
		_tmp1_ = val;
		self->_data = g_list_prepend (self->_data, GUINT_TO_POINTER (_tmp1_));
		return;
	}
	_tmp2_ = position;
	_tmp3_ = fso_framework_bin_builder_get_at (self, _tmp2_, (guint) 1);
	l = _tmp3_;
	_tmp4_ = l;
	_tmp5_ = val;
	_tmp4_->data = GUINT_TO_POINTER (_tmp5_);
}


void fso_framework_bin_builder_set_uint16 (FsoFrameworkBinBuilder* self, guint16 val, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	gint i;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 2);
	l = _tmp1_;
	i = 0;
	{
		gboolean _tmp2_;
		i = 1;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_;
			gint _tmp5_;
			GList* _tmp6_;
			guint16 _tmp7_;
			gint _tmp8_;
			guint8 _tmp9_ = 0U;
			GList* _tmp10_;
			GList* _tmp11_;
			_tmp3_ = _tmp2_;
			if (!_tmp3_) {
				gint _tmp4_;
				_tmp4_ = i;
				i = _tmp4_ + 1;
			}
			_tmp2_ = FALSE;
			_tmp5_ = i;
			if (!(_tmp5_ <= 2)) {
				break;
			}
			_tmp6_ = l;
			_tmp7_ = val;
			_tmp8_ = i;
			_tmp9_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp7_, (guint) (2 - _tmp8_));
			_tmp6_->data = GUINT_TO_POINTER (_tmp9_);
			_tmp10_ = l;
			_tmp11_ = _tmp10_->next;
			l = _tmp11_;
		}
	}
}


void fso_framework_bin_builder_set_uint32 (FsoFrameworkBinBuilder* self, guint32 val, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	gint i;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 4);
	l = _tmp1_;
	i = 0;
	{
		gboolean _tmp2_;
		i = 1;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_;
			gboolean _tmp5_ = FALSE;
			gint _tmp6_;
			gboolean _tmp8_;
			GList* _tmp9_;
			guint32 _tmp10_;
			gint _tmp11_;
			guint8 _tmp12_ = 0U;
			GList* _tmp13_;
			GList* _tmp14_;
			_tmp3_ = _tmp2_;
			if (!_tmp3_) {
				gint _tmp4_;
				_tmp4_ = i;
				i = _tmp4_ + 1;
			}
			_tmp2_ = FALSE;
			_tmp6_ = i;
			if (_tmp6_ <= 4) {
				GList* _tmp7_;
				_tmp7_ = l;
				_tmp5_ = _tmp7_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp8_ = _tmp5_;
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = l;
			_tmp10_ = val;
			_tmp11_ = i;
			_tmp12_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp10_, (guint) (4 - _tmp11_));
			_tmp9_->data = GUINT_TO_POINTER (_tmp12_);
			_tmp13_ = l;
			_tmp14_ = _tmp13_->next;
			l = _tmp14_;
		}
	}
}


void fso_framework_bin_builder_set_uint64 (FsoFrameworkBinBuilder* self, guint64 val, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	gint i;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 8);
	l = _tmp1_;
	i = 0;
	{
		gboolean _tmp2_;
		i = 1;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_;
			gboolean _tmp5_ = FALSE;
			gint _tmp6_;
			gboolean _tmp8_;
			GList* _tmp9_;
			guint64 _tmp10_;
			gint _tmp11_;
			guint8 _tmp12_ = 0U;
			GList* _tmp13_;
			GList* _tmp14_;
			_tmp3_ = _tmp2_;
			if (!_tmp3_) {
				gint _tmp4_;
				_tmp4_ = i;
				i = _tmp4_ + 1;
			}
			_tmp2_ = FALSE;
			_tmp6_ = i;
			if (_tmp6_ <= 8) {
				GList* _tmp7_;
				_tmp7_ = l;
				_tmp5_ = _tmp7_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp8_ = _tmp5_;
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = l;
			_tmp10_ = val;
			_tmp11_ = i;
			_tmp12_ = fso_framework_bin_builder_nth_byte (_tmp10_, (guint) (8 - _tmp11_));
			_tmp9_->data = GUINT_TO_POINTER (_tmp12_);
			_tmp13_ = l;
			_tmp14_ = _tmp13_->next;
			l = _tmp14_;
		}
	}
}


void fso_framework_bin_builder_set_string (FsoFrameworkBinBuilder* self, const gchar* s, gint position, gboolean include_null_byte, guint pad_to, guint8 padding) {
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint string_len;
	gint _tmp3_;
	guint _tmp7_ = 0U;
	guint _tmp8_;
	gint _tmp14_;
	guint _tmp15_;
	GList* _tmp16_ = NULL;
	GList* l;
	const gchar* _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	guint8* _tmp19_;
	gint _tmp19__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	string_len = _tmp2_;
	_tmp3_ = position;
	if (_tmp3_ < 0) {
		gint _tmp4_;
		GList* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp4_ = position;
		_tmp5_ = self->_data;
		_tmp6_ = g_list_length (_tmp5_);
		position = _tmp4_ + ((gint) _tmp6_);
	}
	_tmp8_ = pad_to;
	if (_tmp8_ == ((guint) 0)) {
		gint _tmp9_ = 0;
		gboolean _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp10_ = include_null_byte;
		if (_tmp10_) {
			_tmp9_ = 1;
		} else {
			_tmp9_ = 0;
		}
		_tmp11_ = string_len;
		_tmp12_ = _tmp9_;
		_tmp7_ = (guint) (_tmp11_ + _tmp12_);
	} else {
		guint _tmp13_;
		_tmp13_ = pad_to;
		_tmp7_ = _tmp13_;
	}
	_tmp14_ = position;
	_tmp15_ = _tmp7_;
	_tmp16_ = fso_framework_bin_builder_get_at (self, _tmp14_, (guint) _tmp15_);
	l = _tmp16_;
	_tmp17_ = s;
	_tmp18_ = string_get_data (_tmp17_, &_tmp18__length1);
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	{
		guint8* e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp19_;
		e_collection_length1 = _tmp19__length1;
		for (e_it = 0; e_it < _tmp19__length1; e_it = e_it + 1) {
			guint8 e = 0U;
			e = e_collection[e_it];
			{
				GList* _tmp20_;
				guint8 _tmp21_;
				GList* _tmp22_;
				GList* _tmp23_;
				_tmp20_ = l;
				_tmp21_ = e;
				_tmp20_->data = GUINT_TO_POINTER (_tmp21_);
				_tmp22_ = l;
				_tmp23_ = _tmp22_->next;
				l = _tmp23_;
			}
		}
	}
	{
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint i;
		_tmp24_ = s;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		i = (gint) _tmp26_;
		{
			gboolean _tmp27_;
			_tmp27_ = TRUE;
			while (TRUE) {
				gboolean _tmp28_;
				gint _tmp30_;
				guint _tmp31_;
				GList* _tmp32_;
				guint8 _tmp33_;
				GList* _tmp34_;
				GList* _tmp35_;
				_tmp28_ = _tmp27_;
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = i;
					i = _tmp29_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp30_ = i;
				_tmp31_ = pad_to;
				if (!(((guint) _tmp30_) < _tmp31_)) {
					break;
				}
				_tmp32_ = l;
				_tmp33_ = padding;
				_tmp32_->data = GUINT_TO_POINTER (_tmp33_);
				_tmp34_ = l;
				_tmp35_ = _tmp34_->next;
				l = _tmp35_;
			}
		}
	}
}


void fso_framework_bin_builder_set_data (FsoFrameworkBinBuilder* self, guint8* d, int d_length1, gint position, guint pad_to, guint8 padding) {
	gint _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	GList* _tmp3_ = NULL;
	GList* l;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_data (self, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) _tmp2__length1);
	l = _tmp3_;
	_tmp4_ = d;
	_tmp4__length1 = d_length1;
	{
		guint8* e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp4_;
		e_collection_length1 = _tmp4__length1;
		for (e_it = 0; e_it < _tmp4__length1; e_it = e_it + 1) {
			guint8 e = 0U;
			e = e_collection[e_it];
			{
				GList* _tmp5_;
				guint8 _tmp6_;
				GList* _tmp7_;
				GList* _tmp8_;
				_tmp5_ = l;
				_tmp6_ = e;
				_tmp5_->data = GUINT_TO_POINTER (_tmp6_);
				_tmp7_ = l;
				_tmp8_ = _tmp7_->next;
				l = _tmp8_;
			}
		}
	}
}


void fso_framework_bin_builder_set_align (FsoFrameworkBinBuilder* self, gint pos) {
	gint _tmp0_;
	guint _tmp4_;
	gint _tmp5_;
	guint _tmp6_;
	guint nr_bytes;
	gboolean _tmp7_ = FALSE;
	guint _tmp8_;
	gboolean _tmp11_;
	gint _tmp12_;
	guint _tmp13_;
	GList* _tmp14_ = NULL;
	GList* l;
	g_return_if_fail (self != NULL);
	_tmp0_ = pos;
	if (_tmp0_ < 0) {
		gint _tmp1_;
		GList* _tmp2_;
		guint _tmp3_ = 0U;
		_tmp1_ = pos;
		_tmp2_ = self->_data;
		_tmp3_ = g_list_length (_tmp2_);
		pos = _tmp1_ + ((gint) _tmp3_);
	}
	_tmp4_ = self->priv->_alignment;
	_tmp5_ = pos;
	_tmp6_ = self->priv->_alignment;
	nr_bytes = _tmp4_ - (_tmp5_ % _tmp6_);
	_tmp8_ = nr_bytes;
	if (_tmp8_ == ((guint) 0)) {
		_tmp7_ = TRUE;
	} else {
		guint _tmp9_;
		guint _tmp10_;
		_tmp9_ = nr_bytes;
		_tmp10_ = self->priv->_alignment;
		_tmp7_ = _tmp9_ == _tmp10_;
	}
	_tmp11_ = _tmp7_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = pos;
	_tmp13_ = nr_bytes;
	_tmp14_ = fso_framework_bin_builder_get_at (self, _tmp12_, _tmp13_);
	l = _tmp14_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_;
				gint _tmp18_;
				guint _tmp19_;
				GList* _tmp20_;
				guint8 _tmp21_;
				GList* _tmp22_;
				GList* _tmp23_;
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = nr_bytes;
				if (!(((guint) _tmp18_) < _tmp19_)) {
					break;
				}
				_tmp20_ = l;
				_tmp21_ = self->priv->_alignment_byte;
				_tmp20_->data = GUINT_TO_POINTER (_tmp21_);
				_tmp22_ = l;
				_tmp23_ = _tmp22_->next;
				l = _tmp23_;
			}
		}
	}
}


void fso_framework_bin_builder_set_crc16 (FsoFrameworkBinBuilder* self, gint pos, gint start, gint end) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint _tmp3_;
	guint16 _tmp4_ = 0U;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_bin_builder_get_data (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = start;
	_tmp3_ = end;
	_tmp4_ = fso_framework_checksum_crc16 (_tmp1_ + _tmp2_, _tmp3_ - _tmp2_);
	_tmp5_ = pos;
	fso_framework_bin_builder_set_uint16 (self, _tmp4_, _tmp5_);
}


void fso_framework_bin_builder_insert_uint8 (FsoFrameworkBinBuilder* self, guint8 val, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	guint8 _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 1);
	l = _tmp1_;
	_tmp2_ = val;
	_tmp3_ = position;
	l = g_list_insert (l, GUINT_TO_POINTER ((guint16) _tmp2_), _tmp3_);
}


void fso_framework_bin_builder_insert_uint16 (FsoFrameworkBinBuilder* self, guint16 val, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	guint16 _tmp2_;
	guint16 _tmp3_ = 0U;
	guint16 _tmp4_;
	guint8 _tmp5_ = 0U;
	guint16 _tmp6_;
	guint8 _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 1);
	l = _tmp1_;
	_tmp2_ = val;
	_tmp3_ = fso_framework_bin_builder_uint16_convert (self, _tmp2_);
	val = _tmp3_;
	_tmp4_ = val;
	_tmp5_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp4_, (guint) 0);
	l = g_list_insert (l, GUINT_TO_POINTER (_tmp5_), 0);
	_tmp6_ = val;
	_tmp7_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp6_, (guint) 1);
	l = g_list_insert (l, GUINT_TO_POINTER (_tmp7_), 1);
}


void fso_framework_bin_builder_insert_uint32 (FsoFrameworkBinBuilder* self, guint32 val, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	guint32 _tmp2_;
	guint32 _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 1);
	l = _tmp1_;
	_tmp2_ = val;
	_tmp3_ = fso_framework_bin_builder_uint32_convert (self, _tmp2_);
	val = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				guint32 _tmp8_;
				gint _tmp9_;
				guint8 _tmp10_ = 0U;
				gint _tmp11_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < 4)) {
					break;
				}
				_tmp8_ = val;
				_tmp9_ = i;
				_tmp10_ = fso_framework_bin_builder_nth_byte ((guint64) _tmp8_, (guint) _tmp9_);
				_tmp11_ = i;
				l = g_list_insert (l, GUINT_TO_POINTER (_tmp10_), _tmp11_);
			}
		}
	}
}


void fso_framework_bin_builder_insert_uint64 (FsoFrameworkBinBuilder* self, guint64 val, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	guint64 _tmp2_;
	guint64 _tmp3_ = 0ULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 1);
	l = _tmp1_;
	_tmp2_ = val;
	_tmp3_ = fso_framework_bin_builder_uint64_convert (self, _tmp2_);
	val = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				guint64 _tmp8_;
				gint _tmp9_;
				guint8 _tmp10_ = 0U;
				gint _tmp11_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < 8)) {
					break;
				}
				_tmp8_ = val;
				_tmp9_ = i;
				_tmp10_ = fso_framework_bin_builder_nth_byte (_tmp8_, (guint) _tmp9_);
				_tmp11_ = i;
				l = g_list_insert (l, GUINT_TO_POINTER (_tmp10_), _tmp11_);
			}
		}
	}
}


void fso_framework_bin_builder_insert_string (FsoFrameworkBinBuilder* self, const gchar* str, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	gint i;
	const gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 1);
	l = _tmp1_;
	i = 0;
	_tmp2_ = str;
	_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	{
		guint8* s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp4_;
		s_collection_length1 = _tmp4__length1;
		for (s_it = 0; s_it < _tmp4__length1; s_it = s_it + 1) {
			guint8 s = 0U;
			s = s_collection[s_it];
			{
				guint8 _tmp5_;
				gint _tmp6_;
				_tmp5_ = s;
				_tmp6_ = i;
				i = _tmp6_ + 1;
				l = g_list_insert (l, GUINT_TO_POINTER (_tmp5_), _tmp6_);
			}
		}
	}
}


void fso_framework_bin_builder_insert_data (FsoFrameworkBinBuilder* self, guint8* data, int data_length1, gint position) {
	gint _tmp0_;
	GList* _tmp1_ = NULL;
	GList* l;
	gint i;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = position;
	_tmp1_ = fso_framework_bin_builder_get_at (self, _tmp0_, (guint) 1);
	l = _tmp1_;
	i = 0;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	{
		guint8* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp2_;
		d_collection_length1 = _tmp2__length1;
		for (d_it = 0; d_it < _tmp2__length1; d_it = d_it + 1) {
			guint8 d = 0U;
			d = d_collection[d_it];
			{
				guint8 _tmp3_;
				gint _tmp4_;
				_tmp3_ = d;
				_tmp4_ = i;
				i = _tmp4_ + 1;
				l = g_list_insert (l, GUINT_TO_POINTER (_tmp3_), _tmp4_);
			}
		}
	}
}


void fso_framework_bin_builder_insert_crc16 (FsoFrameworkBinBuilder* self, gint pos, gint start, gint end) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint _tmp3_;
	guint16 _tmp4_ = 0U;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_bin_builder_get_data (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = start;
	_tmp3_ = end;
	_tmp4_ = fso_framework_checksum_crc16 (_tmp1_ + _tmp2_, _tmp3_ - _tmp2_);
	_tmp5_ = pos;
	fso_framework_bin_builder_insert_uint16 (self, _tmp4_, _tmp5_);
}


void fso_framework_bin_builder_reset (FsoFrameworkBinBuilder* self) {
	g_return_if_fail (self != NULL);
	_g_list_free0 (self->_data);
	self->_data = NULL;
}


guint16 fso_framework_bin_builder_uint16_convert (FsoFrameworkBinBuilder* self, guint16 val) {
	guint16 result = 0U;
	GDataStreamByteOrder _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_endianess;
	if (_tmp0_ == G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN) {
		guint16 _tmp1_;
		guint16 _tmp2_ = 0U;
		_tmp1_ = val;
		_tmp2_ = GUINT16_TO_BE (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GDataStreamByteOrder _tmp3_;
		_tmp3_ = self->priv->_endianess;
		if (_tmp3_ == G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
			guint16 _tmp4_;
			guint16 _tmp5_ = 0U;
			_tmp4_ = val;
			_tmp5_ = GUINT16_TO_LE (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			guint16 _tmp6_;
			_tmp6_ = val;
			result = _tmp6_;
			return result;
		}
	}
}


guint32 fso_framework_bin_builder_uint32_convert (FsoFrameworkBinBuilder* self, guint32 val) {
	guint32 result = 0U;
	GDataStreamByteOrder _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_endianess;
	if (_tmp0_ == G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN) {
		guint32 _tmp1_;
		guint32 _tmp2_ = 0U;
		_tmp1_ = val;
		_tmp2_ = GUINT32_TO_BE (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GDataStreamByteOrder _tmp3_;
		_tmp3_ = self->priv->_endianess;
		if (_tmp3_ == G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
			guint32 _tmp4_;
			guint32 _tmp5_ = 0U;
			_tmp4_ = val;
			_tmp5_ = GUINT32_TO_LE (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			guint32 _tmp6_;
			_tmp6_ = val;
			result = _tmp6_;
			return result;
		}
	}
}


guint64 fso_framework_bin_builder_uint64_convert (FsoFrameworkBinBuilder* self, guint64 val) {
	guint64 result = 0ULL;
	GDataStreamByteOrder _tmp0_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->priv->_endianess;
	if (_tmp0_ == G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN) {
		guint64 _tmp1_;
		guint64 _tmp2_ = 0ULL;
		_tmp1_ = val;
		_tmp2_ = GUINT64_TO_BE (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GDataStreamByteOrder _tmp3_;
		_tmp3_ = self->priv->_endianess;
		if (_tmp3_ == G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
			guint64 _tmp4_;
			guint64 _tmp5_ = 0ULL;
			_tmp4_ = val;
			_tmp5_ = GUINT64_TO_LE (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			guint64 _tmp6_;
			_tmp6_ = val;
			result = _tmp6_;
			return result;
		}
	}
}


GList* fso_framework_bin_builder_get_at (FsoFrameworkBinBuilder* self, gint position, guint assure_nth) {
	GList* result = NULL;
	gint _tmp0_;
	GList* _tmp13_;
	gint _tmp14_;
	GList* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = position;
	if (_tmp0_ < 0) {
		gint _tmp1_;
		GList* _tmp2_;
		guint _tmp3_ = 0U;
		_tmp1_ = position;
		_tmp2_ = self->_data;
		_tmp3_ = g_list_length (_tmp2_);
		position = _tmp1_ + ((gint) _tmp3_);
	} else {
		gint _tmp4_;
		guint _tmp5_;
		GList* _tmp6_;
		guint _tmp7_ = 0U;
		_tmp4_ = position;
		_tmp5_ = assure_nth;
		_tmp6_ = self->_data;
		_tmp7_ = g_list_length (_tmp6_);
		if ((_tmp4_ + _tmp5_) > _tmp7_) {
			gint _tmp8_;
			GList* _tmp9_;
			guint _tmp10_ = 0U;
			guint _tmp11_;
			guint8 _tmp12_;
			_tmp8_ = position;
			_tmp9_ = self->_data;
			_tmp10_ = g_list_length (_tmp9_);
			_tmp11_ = assure_nth;
			_tmp12_ = self->priv->_alignment_byte;
			fso_framework_bin_builder_append_pad (self, (glong) ((_tmp8_ - _tmp10_) + _tmp11_), _tmp12_);
		}
	}
	_tmp13_ = self->_data;
	_tmp14_ = position;
	_tmp15_ = g_list_nth (_tmp13_, (guint) _tmp14_);
	result = _tmp15_;
	return result;
}


void fso_framework_bin_builder_set_bit (guint8* data, gint bit, gboolean value) {
	gint _tmp0_;
	guint8 _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	_tmp0_ = bit;
	bit = (8 - _tmp0_) - 1;
	_tmp1_ = *data;
	_tmp2_ = value;
	_tmp3_ = bit;
	*data = _tmp1_ | (((guint8) _tmp2_) << _tmp3_);
}


guint8* fso_framework_bin_builder_get_data (FsoFrameworkBinBuilder* self, int* result_length1) {
	guint8* result;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	guint8* _tmp2_ = NULL;
	guint8* _result_;
	gint _result__length1;
	gint __result__size_;
	gint i;
	GList* _tmp3_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_data;
	_tmp1_ = g_list_length (_tmp0_);
	_tmp2_ = g_new0 (guint8, _tmp1_);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_;
	__result__size_ = _result__length1;
	i = 0;
	_tmp3_ = self->_data;
	{
		GList* e_collection = NULL;
		GList* e_it = NULL;
		e_collection = _tmp3_;
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
			guint8 e = 0U;
			e = GPOINTER_TO_UINT (e_it->data);
			{
				guint8* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				guint8 _tmp6_;
				guint8 _tmp7_;
				_tmp4_ = _result_;
				_tmp4__length1 = _result__length1;
				_tmp5_ = i;
				i = _tmp5_ + 1;
				_tmp6_ = e;
				_tmp4_[_tmp5_] = _tmp6_;
				_tmp7_ = _tmp4_[_tmp5_];
			}
		}
	}
	_tmp8_ = _result_;
	_tmp8__length1 = _result__length1;
	_tmp9_ = _tmp8_ + 0;
	_tmp9__length1 = (-1) - 0;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	_result_ = (g_free (_result_), NULL);
	return result;
}


guint fso_framework_bin_builder_get_length (FsoFrameworkBinBuilder* self) {
	guint result;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->_data;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_;
	return result;
}


GDataStreamByteOrder fso_framework_bin_builder_get_endianess (FsoFrameworkBinBuilder* self) {
	GDataStreamByteOrder result;
	GDataStreamByteOrder _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_endianess;
	result = _tmp0_;
	return result;
}


void fso_framework_bin_builder_set_endianess (FsoFrameworkBinBuilder* self, GDataStreamByteOrder value) {
	GDataStreamByteOrder _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_endianess = _tmp0_;
	g_object_notify ((GObject *) self, "endianess");
}


guint fso_framework_bin_builder_get_alignment (FsoFrameworkBinBuilder* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_alignment;
	result = _tmp0_;
	return result;
}


void fso_framework_bin_builder_set_alignment (FsoFrameworkBinBuilder* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_alignment = _tmp0_;
	g_object_notify ((GObject *) self, "alignment");
}


guint8 fso_framework_bin_builder_get_alignment_byte (FsoFrameworkBinBuilder* self) {
	guint8 result;
	guint8 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_alignment_byte;
	result = _tmp0_;
	return result;
}


void fso_framework_bin_builder_set_alignment_byte (FsoFrameworkBinBuilder* self, guint8 value) {
	guint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_alignment_byte = _tmp0_;
	g_object_notify ((GObject *) self, "alignment-byte");
}


gboolean fso_framework_bin_builder_get_packed (FsoFrameworkBinBuilder* self) {
	gboolean result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_alignment;
	result = _tmp0_ == ((guint) 0);
	return result;
}


static GObject * fso_framework_bin_builder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FsoFrameworkBinBuilder * self;
	parent_class = G_OBJECT_CLASS (fso_framework_bin_builder_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = FSO_FRAMEWORK_BIN_BUILDER (obj);
	_g_list_free0 (self->_data);
	self->_data = NULL;
	return obj;
}


static void fso_framework_bin_builder_class_init (FsoFrameworkBinBuilderClass * klass) {
	fso_framework_bin_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkBinBuilderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_fso_framework_bin_builder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_fso_framework_bin_builder_set_property;
	G_OBJECT_CLASS (klass)->constructor = fso_framework_bin_builder_constructor;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_bin_builder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_BIN_BUILDER_LENGTH, g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_BIN_BUILDER_ENDIANESS, g_param_spec_enum ("endianess", "endianess", "endianess", G_TYPE_DATA_STREAM_BYTE_ORDER, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT, g_param_spec_uint ("alignment", "alignment", "alignment", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT_BYTE, g_param_spec_uchar ("alignment-byte", "alignment-byte", "alignment-byte", 0, G_MAXUINT8, (guint8) '\0', G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_BIN_BUILDER_PACKED, g_param_spec_boolean ("packed", "packed", "packed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void fso_framework_bin_builder_instance_init (FsoFrameworkBinBuilder * self) {
	self->priv = FSO_FRAMEWORK_BIN_BUILDER_GET_PRIVATE (self);
	self->priv->_alignment = (guint) 0;
	self->priv->_alignment_byte = (guint8) '\0';
}


static void fso_framework_bin_builder_finalize (GObject* obj) {
	FsoFrameworkBinBuilder * self;
	self = FSO_FRAMEWORK_BIN_BUILDER (obj);
	_g_list_free0 (self->_data);
	G_OBJECT_CLASS (fso_framework_bin_builder_parent_class)->finalize (obj);
}


GType fso_framework_bin_builder_get_type (void) {
	static volatile gsize fso_framework_bin_builder_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_bin_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkBinBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_bin_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkBinBuilder), 0, (GInstanceInitFunc) fso_framework_bin_builder_instance_init, NULL };
		GType fso_framework_bin_builder_type_id;
		fso_framework_bin_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkBinBuilder", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_bin_builder_type_id__volatile, fso_framework_bin_builder_type_id);
	}
	return fso_framework_bin_builder_type_id__volatile;
}


static void _vala_fso_framework_bin_builder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FsoFrameworkBinBuilder * self;
	self = FSO_FRAMEWORK_BIN_BUILDER (object);
	switch (property_id) {
		case FSO_FRAMEWORK_BIN_BUILDER_LENGTH:
		g_value_set_uint (value, fso_framework_bin_builder_get_length (self));
		break;
		case FSO_FRAMEWORK_BIN_BUILDER_ENDIANESS:
		g_value_set_enum (value, fso_framework_bin_builder_get_endianess (self));
		break;
		case FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT:
		g_value_set_uint (value, fso_framework_bin_builder_get_alignment (self));
		break;
		case FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT_BYTE:
		g_value_set_uchar (value, fso_framework_bin_builder_get_alignment_byte (self));
		break;
		case FSO_FRAMEWORK_BIN_BUILDER_PACKED:
		g_value_set_boolean (value, fso_framework_bin_builder_get_packed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_fso_framework_bin_builder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FsoFrameworkBinBuilder * self;
	self = FSO_FRAMEWORK_BIN_BUILDER (object);
	switch (property_id) {
		case FSO_FRAMEWORK_BIN_BUILDER_ENDIANESS:
		fso_framework_bin_builder_set_endianess (self, g_value_get_enum (value));
		break;
		case FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT:
		fso_framework_bin_builder_set_alignment (self, g_value_get_uint (value));
		break;
		case FSO_FRAMEWORK_BIN_BUILDER_ALIGNMENT_BYTE:
		fso_framework_bin_builder_set_alignment_byte (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


FsoFrameworkBinReader* fso_framework_bin_reader_construct (GType object_type, guint8* d, int d_length1, gint alignment, GDataStreamByteOrder e) {
	FsoFrameworkBinReader * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GDataStreamByteOrder _tmp3_;
	self = (FsoFrameworkBinReader*) g_object_new (object_type, NULL);
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->data = (g_free (self->priv->data), NULL);
	self->priv->data = _tmp1_;
	self->priv->data_length1 = _tmp1__length1;
	self->priv->_data_size_ = self->priv->data_length1;
	_tmp2_ = alignment;
	fso_framework_bin_reader_set_alignment (self, _tmp2_);
	_tmp3_ = e;
	self->endianess = _tmp3_;
	return self;
}


FsoFrameworkBinReader* fso_framework_bin_reader_new (guint8* d, int d_length1, gint alignment, GDataStreamByteOrder e) {
	return fso_framework_bin_reader_construct (FSO_FRAMEWORK_TYPE_BIN_READER, d, d_length1, alignment, e);
}


FsoFrameworkBinReader* fso_framework_bin_reader_construct_void_pointer (GType object_type, void* d, guint len, gint alignment, GDataStreamByteOrder e) {
	FsoFrameworkBinReader * self = NULL;
	guint _tmp0_;
	guint8* _tmp1_ = NULL;
	guint8* _tmp2_;
	gint _tmp2__length1;
	void* _tmp3_;
	guint _tmp4_;
	gint _tmp5_;
	GDataStreamByteOrder _tmp6_;
	self = (FsoFrameworkBinReader*) g_object_new (object_type, NULL);
	_tmp0_ = len;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	self->priv->data = (g_free (self->priv->data), NULL);
	self->priv->data = _tmp1_;
	self->priv->data_length1 = _tmp0_;
	self->priv->_data_size_ = self->priv->data_length1;
	_tmp2_ = self->priv->data;
	_tmp2__length1 = self->priv->data_length1;
	_tmp3_ = d;
	_tmp4_ = len;
	memcpy (_tmp2_, _tmp3_, (gsize) _tmp4_);
	_tmp5_ = alignment;
	fso_framework_bin_reader_set_alignment (self, _tmp5_);
	_tmp6_ = e;
	self->endianess = _tmp6_;
	return self;
}


FsoFrameworkBinReader* fso_framework_bin_reader_new_void_pointer (void* d, guint len, gint alignment, GDataStreamByteOrder e) {
	return fso_framework_bin_reader_construct_void_pointer (FSO_FRAMEWORK_TYPE_BIN_READER, d, len, alignment, e);
}


guint8 fso_framework_bin_reader_get_uint8 (FsoFrameworkBinReader* self, gint pos, GError** error) {
	guint8 result = 0U;
	gint _tmp0_ = 0;
	gint off;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	guint8 _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = fso_framework_bin_reader_offset (self, (gsize) sizeof (guint8));
	off = _tmp0_;
	_tmp1_ = pos;
	_tmp2_ = fso_framework_bin_reader_absolute_position (self, _tmp1_, off + ((gint) sizeof (guint8)), &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	pos = _tmp3_;
	_tmp4_ = self->priv->data;
	_tmp4__length1 = self->priv->data_length1;
	_tmp5_ = pos;
	_tmp6_ = _tmp4_[_tmp5_ + off];
	result = _tmp6_;
	return result;
}


guint16 fso_framework_bin_reader_get_uint16 (FsoFrameworkBinReader* self, gint pos, GError** error) {
	guint16 result = 0U;
	guint16 _result_;
	gint _tmp0_ = 0;
	gint off;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	guint8 _tmp6_;
	guint16 _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	guint8 _tmp10_;
	guint16 _tmp11_;
	guint16 _tmp12_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_result_ = (guint16) 0;
	_tmp0_ = fso_framework_bin_reader_offset (self, (gsize) sizeof (guint16));
	off = _tmp0_;
	_tmp1_ = pos;
	_tmp2_ = fso_framework_bin_reader_absolute_position (self, _tmp1_, off + ((gint) sizeof (guint16)), &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	pos = _tmp3_;
	_tmp4_ = self->priv->data;
	_tmp4__length1 = self->priv->data_length1;
	_tmp5_ = pos;
	_tmp6_ = _tmp4_[_tmp5_ + off];
	_result_ = (guint16) (((guint16) _tmp6_) << 8);
	_tmp7_ = _result_;
	_tmp8_ = self->priv->data;
	_tmp8__length1 = self->priv->data_length1;
	_tmp9_ = pos;
	_tmp10_ = _tmp8_[(_tmp9_ + off) + 1];
	_result_ = _tmp7_ | ((guint16) _tmp10_);
	_tmp11_ = _result_;
	_tmp12_ = fso_framework_bin_reader_uint16_convert (self, _tmp11_);
	result = _tmp12_;
	return result;
}


guint32 fso_framework_bin_reader_get_uint32 (FsoFrameworkBinReader* self, gint pos, GError** error) {
	guint32 result = 0U;
	guint32 _result_;
	gint _tmp0_ = 0;
	gint off;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	guint8 _tmp6_;
	guint32 _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	guint8 _tmp10_;
	guint32 _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	guint8 _tmp14_;
	guint32 _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	guint8 _tmp18_;
	guint32 _tmp19_;
	guint32 _tmp20_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_result_ = (guint32) 0;
	_tmp0_ = fso_framework_bin_reader_offset (self, (gsize) sizeof (guint32));
	off = _tmp0_;
	_tmp1_ = pos;
	_tmp2_ = fso_framework_bin_reader_absolute_position (self, _tmp1_, off + ((gint) sizeof (guint32)), &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	pos = _tmp3_;
	_tmp4_ = self->priv->data;
	_tmp4__length1 = self->priv->data_length1;
	_tmp5_ = pos;
	_tmp6_ = _tmp4_[_tmp5_ + off];
	_result_ = ((guint32) _tmp6_) << 24;
	_tmp7_ = _result_;
	_tmp8_ = self->priv->data;
	_tmp8__length1 = self->priv->data_length1;
	_tmp9_ = pos;
	_tmp10_ = _tmp8_[(_tmp9_ + off) + 1];
	_result_ = _tmp7_ | (((guint32) _tmp10_) << 16);
	_tmp11_ = _result_;
	_tmp12_ = self->priv->data;
	_tmp12__length1 = self->priv->data_length1;
	_tmp13_ = pos;
	_tmp14_ = _tmp12_[(_tmp13_ + off) + 2];
	_result_ = _tmp11_ | (((guint32) _tmp14_) << 8);
	_tmp15_ = _result_;
	_tmp16_ = self->priv->data;
	_tmp16__length1 = self->priv->data_length1;
	_tmp17_ = pos;
	_tmp18_ = _tmp16_[(_tmp17_ + off) + 3];
	_result_ = _tmp15_ | ((guint32) _tmp18_);
	_tmp19_ = _result_;
	_tmp20_ = fso_framework_bin_reader_uint32_convert (self, _tmp19_);
	result = _tmp20_;
	return result;
}


guint64 fso_framework_bin_reader_get_uint64 (FsoFrameworkBinReader* self, gint pos, GError** error) {
	guint64 result = 0ULL;
	guint64 _result_;
	gint _tmp0_ = 0;
	gint off;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	guint8 _tmp6_;
	guint64 _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	guint8 _tmp10_;
	guint64 _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	guint8 _tmp14_;
	guint64 _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	guint8 _tmp18_;
	guint64 _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	guint8 _tmp22_;
	guint64 _tmp23_;
	guint8* _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_;
	guint8 _tmp26_;
	guint64 _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	guint8 _tmp30_;
	guint64 _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	gint _tmp33_;
	guint8 _tmp34_;
	guint64 _tmp35_;
	guint64 _tmp36_ = 0ULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0ULL);
	_result_ = (guint64) 0;
	_tmp0_ = fso_framework_bin_reader_offset (self, (gsize) sizeof (guint64));
	off = _tmp0_;
	_tmp1_ = pos;
	_tmp2_ = fso_framework_bin_reader_absolute_position (self, _tmp1_, off + ((gint) sizeof (guint64)), &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0ULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0ULL;
		}
	}
	pos = _tmp3_;
	_tmp4_ = self->priv->data;
	_tmp4__length1 = self->priv->data_length1;
	_tmp5_ = pos;
	_tmp6_ = _tmp4_[_tmp5_ + off];
	_result_ = ((guint64) _tmp6_) << 56;
	_tmp7_ = _result_;
	_tmp8_ = self->priv->data;
	_tmp8__length1 = self->priv->data_length1;
	_tmp9_ = pos;
	_tmp10_ = _tmp8_[(_tmp9_ + off) + 1];
	_result_ = _tmp7_ | (((guint64) _tmp10_) << 48);
	_tmp11_ = _result_;
	_tmp12_ = self->priv->data;
	_tmp12__length1 = self->priv->data_length1;
	_tmp13_ = pos;
	_tmp14_ = _tmp12_[(_tmp13_ + off) + 2];
	_result_ = _tmp11_ | (((guint64) _tmp14_) << 40);
	_tmp15_ = _result_;
	_tmp16_ = self->priv->data;
	_tmp16__length1 = self->priv->data_length1;
	_tmp17_ = pos;
	_tmp18_ = _tmp16_[(_tmp17_ + off) + 3];
	_result_ = _tmp15_ | (((guint64) _tmp18_) << 32);
	_tmp19_ = _result_;
	_tmp20_ = self->priv->data;
	_tmp20__length1 = self->priv->data_length1;
	_tmp21_ = pos;
	_tmp22_ = _tmp20_[(_tmp21_ + off) + 4];
	_result_ = _tmp19_ | (((guint64) _tmp22_) << 24);
	_tmp23_ = _result_;
	_tmp24_ = self->priv->data;
	_tmp24__length1 = self->priv->data_length1;
	_tmp25_ = pos;
	_tmp26_ = _tmp24_[(_tmp25_ + off) + 5];
	_result_ = _tmp23_ | (((guint64) _tmp26_) << 16);
	_tmp27_ = _result_;
	_tmp28_ = self->priv->data;
	_tmp28__length1 = self->priv->data_length1;
	_tmp29_ = pos;
	_tmp30_ = _tmp28_[(_tmp29_ + off) + 6];
	_result_ = _tmp27_ | (((guint64) _tmp30_) << 8);
	_tmp31_ = _result_;
	_tmp32_ = self->priv->data;
	_tmp32__length1 = self->priv->data_length1;
	_tmp33_ = pos;
	_tmp34_ = _tmp32_[(_tmp33_ + off) + 7];
	_result_ = _tmp31_ | ((guint64) _tmp34_);
	_tmp35_ = _result_;
	_tmp36_ = fso_framework_bin_reader_uint64_convert (self, _tmp35_);
	result = _tmp36_;
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


gchar* fso_framework_bin_reader_get_string (FsoFrameworkBinReader* self, gint pos, gint length, GError** error) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _result_;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pos;
	_tmp1_ = fso_framework_bin_reader_absolute_position (self, _tmp0_, 0, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	pos = _tmp2_;
	_tmp3_ = self->priv->data;
	_tmp3__length1 = self->priv->data_length1;
	_tmp4_ = pos;
	_tmp5_ = string_offset ((const gchar*) _tmp3_, (glong) _tmp4_);
	_result_ = _tmp5_;
	_tmp6_ = length;
	if (_tmp6_ >= 0) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp7_ = _result_;
		_tmp8_ = length;
		_tmp9_ = g_strndup (_tmp7_, (gsize) _tmp8_);
		result = _tmp9_;
		return result;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp10_ = _result_;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


guint8* fso_framework_bin_reader_get_data (FsoFrameworkBinReader* self, gint pos, gint length, int* result_length1, GError** error) {
	guint8* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pos;
	_tmp1_ = length;
	_tmp2_ = fso_framework_bin_reader_absolute_position (self, _tmp0_, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	pos = _tmp3_;
	_tmp4_ = self->priv->data;
	_tmp4__length1 = self->priv->data_length1;
	_tmp5_ = pos;
	_tmp6_ = pos;
	_tmp7_ = length;
	_tmp8_ = ((_tmp4_ + _tmp5_) != NULL) ? _vala_array_dup2 (_tmp4_ + _tmp5_, (_tmp6_ + _tmp7_) - _tmp5_) : ((gpointer) (_tmp4_ + _tmp5_));
	_tmp8__length1 = (_tmp6_ + _tmp7_) - _tmp5_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}


gboolean fso_framework_bin_reader_crc16_verify (FsoFrameworkBinReader* self, gint crc_position, gint start, gint end, GError** error) {
	gboolean result = FALSE;
	guint16 sum;
	guint8* _tmp0_ = NULL;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_;
	guint8* _tmp46_;
	gint _tmp46__length1;
	guint16 _tmp47_;
	gboolean _tmp48_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	sum = (guint16) 0;
	_tmp0_ = g_new0 (guint8, 0);
	data = _tmp0_;
	data_length1 = 0;
	_data_size_ = data_length1;
	_tmp2_ = crc_position;
	_tmp3_ = start;
	if (_tmp2_ > _tmp3_) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = crc_position;
		_tmp5_ = end;
		_tmp1_ = _tmp4_ < _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		gint _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		GError* _tmp18_;
		GError* _tmp19_;
		_tmp7_ = crc_position;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = start;
		_tmp11_ = g_strdup_printf ("%i", _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = end;
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat ("Checksum at ", _tmp9_, " is within data range [", _tmp12_, ":", _tmp15_, "]", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_error_new_literal (FSO_FRAMEWORK_BIN_READER_ERROR, FSO_FRAMEWORK_BIN_READER_ERROR_CHECKSUM_IN_DATA, _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp19_;
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			data = (g_free (data), NULL);
			return FALSE;
		} else {
			data = (g_free (data), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	{
		gint _tmp20_;
		guint16 _tmp21_ = 0U;
		guint16 _tmp22_;
		_tmp20_ = crc_position;
		_tmp21_ = fso_framework_bin_reader_get_uint16 (self, _tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		sum = _tmp22_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		guint8* _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		GError* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = crc_position;
		_tmp24_ = g_strdup_printf ("%i", _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = data;
		_tmp26__length1 = data_length1;
		_tmp27_ = g_strdup_printf ("%i", _tmp26__length1);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat ("CRC position[", _tmp25_, "] is out of range ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_error_new_literal (FSO_FRAMEWORK_BIN_READER_ERROR, FSO_FRAMEWORK_BIN_READER_ERROR_OUT_OF_RANGE, _tmp30_);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp25_);
		_inner_error_ = _tmp32_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			data = (g_free (data), NULL);
			return FALSE;
		} else {
			data = (g_free (data), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	{
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _tmp36_ = 0;
		guint8* _tmp37_ = NULL;
		guint8* _tmp38_;
		gint _tmp38__length1;
		gint __tmp38__size_;
		_tmp33_ = start;
		_tmp34_ = end;
		_tmp35_ = start;
		_tmp37_ = fso_framework_bin_reader_get_data (self, _tmp33_, _tmp34_ - _tmp35_, &_tmp36_, &_inner_error_);
		_tmp38_ = _tmp37_;
		_tmp38__length1 = _tmp36_;
		__tmp38__size_ = _tmp38__length1;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		data = (g_free (data), NULL);
		data = _tmp38_;
		data_length1 = _tmp38__length1;
		_data_size_ = data_length1;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		guint8* _tmp39_;
		gint _tmp39__length1;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		GError* _tmp44_;
		GError* _tmp45_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp39_ = data;
		_tmp39__length1 = data_length1;
		_tmp40_ = g_strdup_printf ("%i", _tmp39__length1);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strconcat ("Data out of range [", _tmp41_, "]", NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_error_new_literal (FSO_FRAMEWORK_BIN_READER_ERROR, FSO_FRAMEWORK_BIN_READER_ERROR_OUT_OF_RANGE, _tmp43_);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_inner_error_ = _tmp45_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			data = (g_free (data), NULL);
			return FALSE;
		} else {
			data = (g_free (data), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp46_ = data;
	_tmp46__length1 = data_length1;
	_tmp47_ = sum;
	_tmp48_ = fso_framework_checksum_crc16_verify (_tmp46_, _tmp46__length1, _tmp47_);
	result = _tmp48_;
	data = (g_free (data), NULL);
	return result;
}


guint64 fso_framework_bin_reader_get_bits (FsoFrameworkBinReader* self, gint position, gint offset, gint length, GError** error) {
	guint64 result = 0ULL;
	guint64 _result_;
	gint _tmp0_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_ = 0;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0ULL);
	_result_ = (guint64) 0;
	_tmp0_ = length;
	if (_tmp0_ > 64) {
		gint _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp1_ = length;
		_tmp2_ = g_strdup_printf ("%i", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("length[", _tmp3_, "] is > 64", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new_literal (FSO_FRAMEWORK_BIN_READER_ERROR, FSO_FRAMEWORK_BIN_READER_ERROR_ILLEGAL_PARAMETER, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0ULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0ULL;
		}
	}
	_tmp8_ = position;
	_tmp9_ = offset;
	_tmp10_ = length;
	_tmp11_ = fso_framework_bin_reader_absolute_position (self, _tmp8_, (_tmp9_ / 8) + (_tmp10_ / 8), &_inner_error_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0ULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0ULL;
		}
	}
	position = _tmp12_;
	{
		gint _tmp13_;
		gint _tmp14_;
		gint i;
		_tmp13_ = position;
		_tmp14_ = offset;
		i = (_tmp13_ * 8) + _tmp14_;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_;
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				guint64 _tmp22_;
				guint64 _tmp23_;
				guint8* _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				guint8 _tmp26_;
				gint _tmp27_;
				guint8 _tmp28_ = 0U;
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = position;
				_tmp20_ = offset;
				_tmp21_ = length;
				if (!(_tmp18_ < (((_tmp19_ * 8) + _tmp20_) + _tmp21_))) {
					break;
				}
				_tmp22_ = _result_;
				_result_ = _tmp22_ << 1;
				_tmp23_ = _result_;
				_tmp24_ = self->priv->data;
				_tmp24__length1 = self->priv->data_length1;
				_tmp25_ = i;
				_tmp26_ = _tmp24_[_tmp25_ / 8];
				_tmp27_ = i;
				_tmp28_ = fso_framework_bin_reader_get_bit (_tmp26_, _tmp27_ % 8);
				_result_ = _tmp23_ | _tmp28_;
			}
		}
	}
	result = _result_;
	return result;
}


guint16 fso_framework_bin_reader_uint16_convert (FsoFrameworkBinReader* self, guint16 val) {
	guint16 result = 0U;
	GDataStreamByteOrder _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->endianess;
	if (_tmp0_ == G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN) {
		guint16 _tmp1_;
		guint16 _tmp2_ = 0U;
		_tmp1_ = val;
		_tmp2_ = GUINT16_FROM_BE (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GDataStreamByteOrder _tmp3_;
		_tmp3_ = self->endianess;
		if (_tmp3_ == G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
			guint16 _tmp4_;
			guint16 _tmp5_ = 0U;
			_tmp4_ = val;
			_tmp5_ = GUINT16_FROM_LE (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			guint16 _tmp6_;
			_tmp6_ = val;
			result = _tmp6_;
			return result;
		}
	}
}


guint32 fso_framework_bin_reader_uint32_convert (FsoFrameworkBinReader* self, guint32 val) {
	guint32 result = 0U;
	GDataStreamByteOrder _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->endianess;
	if (_tmp0_ == G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN) {
		guint32 _tmp1_;
		guint32 _tmp2_ = 0U;
		_tmp1_ = val;
		_tmp2_ = GUINT32_FROM_BE (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GDataStreamByteOrder _tmp3_;
		_tmp3_ = self->endianess;
		if (_tmp3_ == G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
			guint32 _tmp4_;
			guint32 _tmp5_ = 0U;
			_tmp4_ = val;
			_tmp5_ = GUINT32_FROM_LE (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			guint32 _tmp6_;
			_tmp6_ = val;
			result = _tmp6_;
			return result;
		}
	}
}


guint64 fso_framework_bin_reader_uint64_convert (FsoFrameworkBinReader* self, guint64 val) {
	guint64 result = 0ULL;
	GDataStreamByteOrder _tmp0_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->endianess;
	if (_tmp0_ == G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN) {
		guint64 _tmp1_;
		guint64 _tmp2_ = 0ULL;
		_tmp1_ = val;
		_tmp2_ = GUINT64_FROM_BE (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GDataStreamByteOrder _tmp3_;
		_tmp3_ = self->endianess;
		if (_tmp3_ == G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
			guint64 _tmp4_;
			guint64 _tmp5_ = 0ULL;
			_tmp4_ = val;
			_tmp5_ = GUINT64_FROM_LE (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			guint64 _tmp6_;
			_tmp6_ = val;
			result = _tmp6_;
			return result;
		}
	}
}


static gint fso_framework_bin_reader_absolute_position (FsoFrameworkBinReader* self, gint pos, gint num_bytes, GError** error) {
	gint result = 0;
	gint _tmp0_;
	gint _result_;
	gint _tmp1_;
	gint _tmp4_;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = pos;
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ < 0) {
		gint _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = _result_;
		_tmp3_ = self->priv->data;
		_tmp3__length1 = self->priv->data_length1;
		_result_ = _tmp2_ + _tmp3__length1;
	}
	_tmp4_ = self->priv->_alignment;
	if (_tmp4_ != 0) {
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = _result_;
		_tmp6_ = _result_;
		_tmp7_ = self->priv->_alignment;
		_result_ = _tmp5_ - (_tmp6_ % _tmp7_);
	}
	_tmp9_ = _result_;
	if (_tmp9_ < 0) {
		_tmp8_ = TRUE;
	} else {
		gint _tmp10_;
		gint _tmp11_;
		guint8* _tmp12_;
		gint _tmp12__length1;
		_tmp10_ = _result_;
		_tmp11_ = num_bytes;
		_tmp12_ = self->priv->data;
		_tmp12__length1 = self->priv->data_length1;
		_tmp8_ = (_tmp10_ + _tmp11_) > _tmp12__length1;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		guint8* _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		_tmp14_ = pos;
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->data;
		_tmp17__length1 = self->priv->data_length1;
		_tmp18_ = g_strdup_printf ("%i", _tmp17__length1);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp16_, " with is out of range for ", _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (FSO_FRAMEWORK_BIN_READER_ERROR, FSO_FRAMEWORK_BIN_READER_ERROR_OUT_OF_RANGE, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == FSO_FRAMEWORK_BIN_READER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _result_;
	return result;
}


static gint fso_framework_bin_reader_offset (FsoFrameworkBinReader* self, gsize type_size) {
	gint result = 0;
	gint _result_;
	gboolean _tmp0_ = FALSE;
	GDataStreamByteOrder _tmp1_;
	gboolean _tmp4_;
	gint _tmp8_ = 0;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp12_;
	g_return_val_if_fail (self != NULL, 0);
	_result_ = 0;
	_tmp1_ = self->endianess;
	if (_tmp1_ == G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = fso_framework_bin_reader_get_packed (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gint _tmp5_;
		gsize _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->_alignment;
		_tmp6_ = type_size;
		_tmp7_ = self->priv->_alignment;
		_result_ = _tmp5_ - (((gint) _tmp6_) % _tmp7_);
	}
	_tmp9_ = _result_;
	_tmp10_ = self->priv->_alignment;
	if (_tmp9_ == _tmp10_) {
		_tmp8_ = 0;
	} else {
		gint _tmp11_;
		_tmp11_ = _result_;
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = _tmp8_;
	result = _tmp12_;
	return result;
}


guint8 fso_framework_bin_reader_get_bit (guint8 data, gint bit) {
	guint8 result = 0U;
	gint _tmp0_;
	guint8 _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = bit;
	bit = (8 - _tmp0_) - 1;
	_tmp1_ = data;
	_tmp2_ = bit;
	_tmp3_ = bit;
	result = ((guint8) ((_tmp1_ & (1 << _tmp2_)) >> _tmp3_)) & 0x1;
	return result;
}


gint fso_framework_bin_reader_get_alignment (FsoFrameworkBinReader* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_alignment;
	result = _tmp0_;
	return result;
}


void fso_framework_bin_reader_set_alignment (FsoFrameworkBinReader* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_alignment = _tmp0_;
	g_object_notify ((GObject *) self, "alignment");
}


gboolean fso_framework_bin_reader_get_packed (FsoFrameworkBinReader* self) {
	gboolean result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_alignment;
	result = _tmp0_ == 0;
	return result;
}


static void fso_framework_bin_reader_class_init (FsoFrameworkBinReaderClass * klass) {
	fso_framework_bin_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkBinReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_fso_framework_bin_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_fso_framework_bin_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_bin_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_BIN_READER_ALIGNMENT, g_param_spec_int ("alignment", "alignment", "alignment", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FSO_FRAMEWORK_BIN_READER_PACKED, g_param_spec_boolean ("packed", "packed", "packed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void fso_framework_bin_reader_instance_init (FsoFrameworkBinReader * self) {
	self->priv = FSO_FRAMEWORK_BIN_READER_GET_PRIVATE (self);
	self->priv->_alignment = 0;
}


static void fso_framework_bin_reader_finalize (GObject* obj) {
	FsoFrameworkBinReader * self;
	self = FSO_FRAMEWORK_BIN_READER (obj);
	self->priv->data = (g_free (self->priv->data), NULL);
	G_OBJECT_CLASS (fso_framework_bin_reader_parent_class)->finalize (obj);
}


GType fso_framework_bin_reader_get_type (void) {
	static volatile gsize fso_framework_bin_reader_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_bin_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkBinReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_bin_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkBinReader), 0, (GInstanceInitFunc) fso_framework_bin_reader_instance_init, NULL };
		GType fso_framework_bin_reader_type_id;
		fso_framework_bin_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkBinReader", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_bin_reader_type_id__volatile, fso_framework_bin_reader_type_id);
	}
	return fso_framework_bin_reader_type_id__volatile;
}


static void _vala_fso_framework_bin_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FsoFrameworkBinReader * self;
	self = FSO_FRAMEWORK_BIN_READER (object);
	switch (property_id) {
		case FSO_FRAMEWORK_BIN_READER_ALIGNMENT:
		g_value_set_int (value, fso_framework_bin_reader_get_alignment (self));
		break;
		case FSO_FRAMEWORK_BIN_READER_PACKED:
		g_value_set_boolean (value, fso_framework_bin_reader_get_packed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_fso_framework_bin_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FsoFrameworkBinReader * self;
	self = FSO_FRAMEWORK_BIN_READER (object);
	switch (property_id) {
		case FSO_FRAMEWORK_BIN_READER_ALIGNMENT:
		fso_framework_bin_reader_set_alignment (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GQuark fso_framework_bin_reader_error_quark (void) {
	return g_quark_from_static_string ("fso_framework_bin_reader_error-quark");
}



