/***************************************************************************
                          cbase64.cpp  -  description
                             -------------------
    begin                : Tue Jul 09 2002
    copyright            : (C) 2002-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cbase64.h"

#include <stdio.h>
#include <stdlib.h>

#include "cbytearray.h"

// original from mutt

const signed char CBase64::Index_64[128] = {
-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,62, 63,-1,-1,-1,
52,53,54,55, 56,57,58,59, 60,61,-1,-1, -1,-1,-1,-1,
-1, 0, 1, 2,  3, 4, 5, 6,  7, 8, 9,10, 11,12,13,14,
15,16,17,18, 19,20,21,22, 23,24,25,-1, -1,-1,-1,-1,
-1,26,27,28, 29,30,31,32, 33,34,35,36, 37,38,39,40,
41,42,43,44, 45,46,47,48, 49,50,51,-1, -1,-1,-1,-1,
};

const char CBase64::B64Chars[64] = {
'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',
'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',
't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
'8', '9', '+', ','
};

#define base64val(c) Index_64[(unsigned int)(c)]
#define base64chars(c) B64Chars[(unsigned int)((c)&0x3F)]

/** */
CBase64::CBase64()
{
}

/** */
CBase64::~CBase64()
{
}

/** */
CString CBase64::Encode( CString string )
{
	CString outs;
	CByteArray in,out;

	in.Append(string.Data(),string.Length());

	Encode(&out,&in);

	outs.Set((const char*)out.Data(),out.Size());

	return outs;
}

/* raw bytes to null-terminated base 64 string */
void CBase64::Encode(  CByteArray * dst, CByteArray * src )
{
	unsigned char c;
	unsigned char *current = src->Data();
	size_t len = src->Size();

	while (len >= 3)
	{
		c = base64chars(current[0] >> 2);
		dst->Append( &c, 1);
		c = base64chars(((current[0] & 0x03) << 4) | (current[1] >> 4));
		dst->Append( &c, 1);
		c = base64chars(((current[1] & 0x0f) << 2) | (current[2] >> 6));
		dst->Append( &c, 1);
		c = base64chars(current[2] & 0x3f);
		dst->Append( &c, 1);
		len     -= 3;
		current += 3;
	}

	/* clean up remainder */
	if (len > 0)
	{
		c = base64chars(current[0] >> 2);
		dst->Append(&c,1);
		if ( len > 1 )
		{
			c = base64chars(((current[0] & 0x03) << 4) | (current[1] >> 4));
			dst->Append(&c,1);
			c = base64chars((current[1] & 0x0f) << 2);
			dst->Append(&c,1);
			c = '=';
			dst->Append(&c,1);
		}
		else
		{
			c = base64chars((current[0] & 0x03) << 4);
			dst->Append(&c,1);
			c = '=';
			dst->Append(&c,1);
			c = '=';
			dst->Append(&c,1);
		}
	}
}

/** */
unsigned long CBase64::Decode( CByteArray * dst, CString * string )
{
	CByteArray in;

	in.Append(string->Data(),string->Length());

	return Decode(dst,&in);
}

/* Convert '\0'-terminated base 64 string to raw bytes.
 * Returns length of returned buffer, or -1 on error */
unsigned long CBase64::Decode( CByteArray * dst, CByteArray * src )
{
	unsigned char *current,*result;
	unsigned char c;
	int ch;
	unsigned long i=0,j=0;

	if ( (!dst) || (!src) )
		return -1;

	if ( (src->Size() % 4) != 0 )
		return -1;

	dst->SetSize(0);

	current = src->Data();
	result  = dst->Data();

	for(i=0;i<src->Size();i++)
	{
		ch = (current[i]&0x7F);

		if (ch == '=') break;

		if (ch == ' ') ch = '+'; 

		ch = Index_64[ch];

		if (ch < 0) return -1;

		switch(i % 4)
		{
			case 0:
				c = (unsigned char)((ch << 2) & 0xFF);
				dst->Append(&c,1);
				break;
			case 1:
				dst->Data()[j] |= ((ch >> 4) & 0xFF);
				j++;
				if(current[i+1]!='=')
				{
					c = (unsigned char)((ch << 4) & 0xFF);
					dst->Append(&c,1);
				}
				break;
			case 2:
				dst->Data()[j] |= ((ch >> 2) & 0x0f);
				j++;
				if(current[i+1]!='=')
				{
					c = (unsigned char)((ch << 6) & 0xFF);
					dst->Append(&c,1);
				}
				break;
			case 3:
				dst->Data()[j] |= ch;
				j++;
				break;
		}
	}

	return j;
}
