/***************************************************************************
                          cdcproto.h  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDCPROTO_H
#define CDCPROTO_H

/**
  *@author Mathias Küster
  *
  * This builds various NMDC protocol strings and sends them.
  *
  * There are various legacy commands here, worst is
  * dclib's own chunked Get, also GetZBlock and UGetBlock are no
  * longer supported, ADCGET by filename is no longer
  * supported, and the escaping for the filename with that is not
  * the same as the current ADC protocol.
  */

#include <dclib/dcos.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/cmutex.h>
#include <dclib/core/ciconv.h>
#include <dclib/core/types.h>

class CMessageSearchFile;
class CMessageMyInfo;

class CDCProto : public CConnection {
public: 
	/** */
	CDCProto( CString remoteEncoding = CString() );
	/** */
	virtual ~CDCProto();

	/** chat message */
	int SendChat( CString sNick, CString s );
	/** send version info */
	int SendVersion();
	/** send myinfo */
	int SendMyInfo( CMessageMyInfo * myinfo );
	/** send key */
	int SendKey( CString s );
	/** send validate nick */
	int SendValidateNick( CString sNick );
	/** send send */
	int SendSend();
	/** send my nick and lock */
	int SendMyNick( CString sNick, const CString & ref );
	/** send get */
	int SendGet( CString file, ulonglong pos, ulonglong size = 0 );
	/** send GetZBlock */
	int SendGetZBlock( CString file, ulonglong pos, ulonglong size = (ulonglong)-1 );
	/** send UGetBlock */
	int SendUGetBlock( CString file, ulonglong pos, ulonglong size = (ulonglong)-1 );
	/** send UGetZBlock */
	int SendUGetZBlock( CString file, ulonglong pos, ulonglong size = (ulonglong)-1 );
	/** send direction */
	int SendDirection( eDirection Direction, int level );
	/** send private message */
	virtual int SendPrivateMessage( CString sNick, CString sTo, CString sMsg, CString sFromNick = CString() );
	/** send request nick list */
	virtual int RequestNickList();
	/** send rev connect to me */
	int SendRevConnectToMe( CString sNick, CString sDstNick );
	/** send error */
	int SendError( CString message );
	/** */
	int SendFileLength( ulonglong len );
	/** */
	int SendListLen( ulonglong len );
	/** */
	int SendGetListLen();
	/** */
	int SendConnectToMe( CString sDstNick, CString host, bool encrypt = false );
	/** */
	int SendCanceled();
	/** send string */
	int SendString( CString message, bool encode = true );
	/** send password */
	int SendPass( CString pass );
	/** operator kick */
	int SendKick( CString nick );
	/** operator force move a user */
	int SendOpForceMove( CString nick, CString host, CString message );
	/** */
	int SendMaxedOut();
	/** */
	int SendGetInfo( CString sNick, CString sMyNick );
	/** */
	int SendSupports( CString s );
	/** */
	int SendSearch( CMessageSearchFile * msg );
	/** $Sending numBytes| */
	int SendSending( ulonglong length );
	/** */
	int SendADCGet( eADCType type, CString tth, ulonglong pos, long long size, bool zlib = false, CString file = CString() );
	/** */
	int SendADCSnd( eADCType type, CString tth, ulonglong pos, long long size, bool zlib = false, CString file = CString() );

private:
	/** */
	CMutex DCProtoMutex;
	/** CIconv object for doing text encoding from local to remote */
	CIconv * m_pLocalToRemote;
	/** CIconv object for doing local to UTF-8 for certain commands */
	CIconv * m_pLocalToUTF8;
};

#endif
