/*--------------------------------------------------------------------------+
$Id: SimulinkAnnotation.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model;

import java.util.Set;

/**
 * Class for Simulink annotations, which are basically comments in the Simulink
 * model.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: AE6DD6532AC951E53A760D5369AECC61
 */
public class SimulinkAnnotation extends SimulinkElementBase {
	/** Create annotation. */
	public SimulinkAnnotation() {
		super();
	}

	/** Create annotation from other annotation (for deep cloning). */
	private SimulinkAnnotation(SimulinkAnnotation other) {
		super(other);
	}

	/**
	 * Get annotation default parameter.
	 */
	@Override
	/* package */String getDefaultParameter(String name) {
		return getModel().getAnnotationDefaultParameter(name);
	}

	/**
	 * Get annotation default parameter names.
	 */
	@Override
	/* package */Set<String> getDefaultParameterNames() {
		return getModel().getAnnotationDefaultParameterNames();
	}

	/** Deep clone annotation. */
	public SimulinkAnnotation deepClone() {
		return new SimulinkAnnotation(this);
	}

}