/*--------------------------------------------------------------------------+
$Id: IVisitor.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.visitor;

import edu.tum.cs.commons.error.NeverThrownRuntimeException;

/**
 * Generic visitor interface.
 * 
 * @param <E>
 *            the type being visited.
 * @param <X>
 *            type of exception thrown by the visitor. Use
 *            {@link NeverThrownRuntimeException} if no exceptions are thrown.
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 32AA0FF6E7D138496111366F2424488E
 */
public interface IVisitor<E, X extends Exception> {

	/** Visit element. */
	public void visit(E element) throws X;
}