#!/bin/bash
defaultcgroup=""

if [ -f /etc/cgrules.conf ]
then
    read user ctrl defaultcgroup <<< \
	`grep -m1 '^\*[[:space:]]\+' /etc/cgrules.conf`
    if [[ -n $defaultcgroup && $defaultcgroup = "*" ]]
    then
	log_warning_msg "/etc/cgrules.conf incorrect"
	log_warning_msg "Overriding it"
	defaultcgroup=
    fi
fi

if [ -z $defaultcgroup ]
then
    defaultcgroup=sysdefault/
fi

#
# Find all mounted subsystems and create comma-separated list
# of controllers.
#
controllers=`lssubsys 2>/dev/null | tr '\n' ',' | sed s/.$//`

#
# Create the default group, ignore errors when the default group
# already exists.
#
cgcreate -f 664 -d 775 -g $controllers:$defaultcgroup 2>/dev/null

#
# special rule for cpusets
#
if echo $controllers | grep -q -w cpuset; then
	cpus=`cgget -nv -r cpuset.cpus /`
	cgset -r cpuset.cpus=$cpus $defaultcgroup
	mems=`cgget -nv -r cpuset.mems /`
	cgset -r cpuset.mems=$mems $defaultcgroup
fi

#
# Classify everything to default cgroup. Ignore errors, some processes
# may exit after ps is run and before cgclassify moves them.
#
cgclassify -g $controllers:$defaultcgroup `ps --no-headers -eL o tid` \
	 2>/dev/null || :

exit 0
