=begin

= cgikit.el

* ((<Japanese|URL:./>))
* ((<screenshot|URL:http://www.rubyist.net/~rubikitch/computer/cgikit-el/cgikit-el.jpg>))
* ((<URL:http://www.rubyist.net/~rubikitch/archive/cgikit-el-0.2.3.tar.gz>))


((<CGIKit|URL:http://www.spice-of-life.net/download/cgikit/index.html>))
is a very useful CGI programming framework.  Ordinally when one makes
a CGI program in Ruby, one uses cgi.rb.  Development efficiency goes
up by using the framework which became independent in cgi.rb called
CGIKit sharply.  However, it is necessary to treat much files
simultaneously in CGIKit. Three, a template (*.html), binding
(*.ckd), and a code (*.rb), are united, and one component is
treated. They are not arranged, unless it edits simultaneously, since
it is related closely. Then, in order to make the development
efficiency by CGIKit raise in the Emacs environment, cgikit.el was
written by easy EmacsLisp.

== Features
* Open three files (*.html, *.ckd, and *.rb) at once by specifying a component directory.
* Specify a name and open the file of another component.
* Insert the initial template of a component-related file.
* Jump to the window of the file of each component relation.
* Movement between cgikit tags.
* Jump to binding which corresponds from the element name of a cgikit tag.
* Jump to the cgikit tag which corresponds from binding.
* Movement between binding.
* Display attributes which an element has.
* ((<Embedded ckd>)).

== Install
(1) cgikit.el is copied to the directory along which load-path passed.
(2) Bytecompile it.
(3) In .emacs append the following.
      (load "cgikit")
      (load "cgikit-help-en.el")
(4) If you want to use a shortening name, append the following.
      (cgikit-invade-global-namespace)

== Usage
=== Fiest, open a component directory
The directory which stored the component first is opened.
  C-c C-d
When you enable shortening name, you can do this.
  M-x ckf

Since a directory name is heard, the directory of a component to edit is specified.
Then, 3 part of screens are carried out and they become the following composition.

  +--------------------+
  |    template        |
  |                    |
  +--------------------+
  | code       | bind  |
  |            |       |
  +--------------------+

Moreover, at the time of new component creation, a directory is newly
made and an initial template is inserted.

=== Open another component directory
If it will be in 3 division state, it can also open another component easily. You type
  M-x cgikit-find-directory
or
  M-x ckc
If (current-buffer) is CGIKit-coponent-related, you may type
  C-c C-f


If a component name is inputted with a complement, it will be in 3 division state in the component.


=== Jump to a component-related window.
In 3 division state, you can jump to each window.
Since these commands are no keybinding -- a required person -- pleasing.
  M-x cgikit-switch-to-html-window
  M-x cgikit-switch-to-rb-window
  M-x cgikit-switch-to-ckd-window

=== Movement and the link between element binding
In a template file and a binding file, you can move cursor or can link to a corresponding place.
Binding not existing is newly created.

* M-p: Move to previous cgikit tag or binding.
* M-n: Move to next cgikit tag or binding.
* M-e: Jumps to binding which corresponds from a cgikit tag, and vice versa

=== Help
==== Display attributes which an element has
When pushing M-c in a binding buffer,  the attributes which the element has is displayed.
It is convenient when you do not understand which attribute an element has.

==== Display explanation of an element
Similarly, a push on M-h displays explanation of the element.
It returns to the original screen by the space key.


=== Embedded ckd

The present CGIKit component forces us to treat three files of html/ckd/rb simultaneously.
Although it dissociates finely apparently and is well visible, when actually developing or reading a CGIKit component, there is a quite hard thing.
Because, I think that it is because the information about an element is distributing.


In order to solve this problem, while ckd was embedded at rb and rb was saved, I think cgikit.el generate ckd automatically.

* Since it is not necessary to treat a ckd file directly, the file which should be treated decreases to two from three!
  A buffer change becomes quite easy.
* Since binding and the code are written to the same place, the information about an element is known at a glance.

Although it is likely to be confused apparently, since font-lock colors a source code at Emacs, an embedded ckd and a code are made ((*clearly distinction*)).

==== How to write
Embedded ckd uses that ruby disregards the portion from
  =begin
to
  =end
like RD.


Embedded ckd begins from
  =begin ckd
(ckd is lower case)and finishes it as
  =end

For example, 
  =begin ckd
  name : CKString {
    value = name;
  }
  =end
    attr_accessor :name
  
  =begin ckd
  comment : CKString {
    value = comment;
    escape=false;
  }
  =end
    def comment
      display_comment @comment
    end
  

==== Enable embedded ckd
In order to  enable embedded ckd
  (setq cgikit-embedded-ckd t)
is written to .emacs.

Although embedded ckd is enabled by the default, please write it to the lowermost part of the component ((*.rb file*)) as
  # Local Variables:
  # cgikit-embedded-ckd: nil
  # End:
by the specific component to repeal.

On the contrary, although repealed by the default, when you want to enable by the specific component, please write it as following.
  # Local Variables:
  # cgikit-embedded-ckd: t
  # End:




== Customize

=== Change of screen composition
Screen composition when opening a file It is defined as the
cgikit-find-files-1 function.  The man that another screen composition
is good newly needs to write a function (ex. my-cgikit-find-files),
and needs to specify the function symbol to cgikit-find-files-function
variable.

== History

:[2004/04/15]Ver 0.2.3
  * for cgikit-1.2.0

:[2003/12/30]Ver 0.2.2
  * patch (((<[cgikit:0474]|URL:http://www.freeml.com/message/cgikit@freeml.com/0000474;jsessionid=y7ozzg4i81>)))

:[2003/11/04]Ver 0.2.1
  * for cgikit-1.1.0

:[2003/10/30]Ver 0.2.0
  * embedded ckd
  * small bug fix
  * new keybinding


=end
