#!/bin/sh

set -e

PERL5LIB="$DESTDIR/usr/share/perl5/"
ROOT=$PWD

export PERL5LIB

echo "=========================================================================="
echo "Make $1"
echo "PERL5LIB = $PERL5LIB"
echo "DESTDIR = $DESTDIR"
echo "=========================================================================="

#--- unpacking tar.gz in proper folders
if [ "$1" = "unpack" ]; then
	test -d build-area || mkdir build-area
	
	cd tarballs
	for dir in *
	do
		if [ -d $dir ]; then
			cd $dir
			for file in *.tar.gz
			do
				test -d ../../build-area/$dir || mkdir ../../build-area/$dir
				tar -C ../../build-area/$dir -xzf $file
			done
			cd ..
		fi
	done
	cd ..

        # special hack for broken CSRF
        # See #593102
        perl debian/fixcsrf.pl
fi

if [ "$1" = patch -o "$1" = unpatch ]; then
	if [ "$1" = patch ]; then
		action=push
	else
		action=pop
	fi
	
	for dir in build-area/*
	do
		[ -d $dir ] || continue
		cd $dir
		for module in *
		do
			name=$(echo $module | sed 's,-[^-]*$,,')
			[ -d $ROOT/debian/patches/$name ] || continue
			echo "Applying patches for $name:"
			cd $module
			[ -h patches ] || ln -s ../../../debian/patches/$name patches
			QUILT_PATCHES=patches quilt --quiltrc /dev/null $action -a || test $? = 2
			cd ..
		done
		cd ../..
	done
fi

if [ "$1" = "build" ]; then
	
	cd build-area
	for dir in *
	do
		if [ -d $dir ]; then
			cd $dir
			for module in *
			do
				cd ../..
				set -e
				d=build-area/$dir/$module
				dh_auto_configure -D $d
				dh_auto_build -D $d
				http_proxy= dh_auto_test -D $d
				dh_auto_install -D $d
				set +e
				cd build-area/$dir
			done
			cd ..
		fi
	done
	cd ..
fi
