/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2006,2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-camera.h"
#include "s-cell-renderer.h"
#include "s-circle.h"
#include "s-item.h"
#include "s-item-view.h"
#include "s-line.h"
#include "s-printer.h"
#include "s-text.h"
#include "s-unit.h"
#include "s-view.h"
#include "s-view-png.h"
#include "s-view-widget.h"

#include <glib/gi18n.h>
#include <gtk/gtkmain.h>

static gboolean no_fork = FALSE;

static GOptionEntry entries[] = {
	{"no-fork", 0, 0, G_OPTION_ARG_NONE, &no_fork, "Don't fork individual tests", NULL},
	{NULL}
};

int
main(int argc, char** argv)
{
	GOptionContext* context;
	SRunner* r;
	int      failed = 0;

	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, entries, NULL); // FIXME: use the domain from libccc
	g_option_context_add_group (context, gtk_get_option_group (TRUE));
	g_option_context_parse (context, &argc, &argv, NULL); // FIXME: check GError
	g_option_context_free (context);
	context = NULL;

	r = srunner_create (suite_camera ());
	srunner_add_suite (r, suite_cell_renderer ());
	srunner_add_suite (r, suite_circle ());
	srunner_add_suite (r, suite_item ());
	srunner_add_suite (r, suite_item_view ());
	srunner_add_suite (r, suite_line ());
	srunner_add_suite (r, suite_item ());
	srunner_add_suite (r, suite_printer ());
	srunner_add_suite (r, suite_text_item ());
	srunner_add_suite (r, suite_unit ());
	srunner_add_suite (r, suite_view ());
	srunner_add_suite (r, suite_view_png ());
	srunner_add_suite (r, suite_view_widget ());
	srunner_set_fork_status(r, /*no_fork ?*/ CK_NOFORK /*: CK_FORK*/);
	srunner_run_all(r, CK_NORMAL);
	failed = srunner_ntests_failed(r);
	srunner_free(r);

	return failed != 0;
}

