#!/usr/bin/env ruby

require 'audiooutput'

audioOutput = AudioOutput.new

driver_type = AudioOutput::driver_info(AudioOutput::default_driver_id)["type"]

case driver_type

  when AudioOutput::AO_TYPE_LIVE

    if !audioOutput.open_live \
      AudioOutput::default_driver_id, 16, 44100, 2, 0

      $stderr.print "Can't open_live\n"
      exit 1
    end

  when AudioOutput::AO_TYPE_FILE

    if !audioOutput.open_file \
      AudioOutput::default_driver_id, "out.raw", true, 16, 44100, 2, 0
      $stderr.print "Can't open_file\n"
      exit 1
    end

  else
    $stderr.print "Don't know about driver type #{driver_type}\n"
    exit 1

end

audioOutput.play(STDIN.read)
