// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using Gtk;
using System;
using System.Threading;
using System.Collections.Generic;

using Anculus.Core;
using Anculus.Gui;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class DispatchGtkTest
	{
		private delegate void Execute ();
		
		private Gtk.Window _window;
		private Gtk.Label _label;
		
		private TimeSpan _syncDispatchValue;

		[Test]
		public void SyncDispatch ()
		{
			_syncDispatchValue = TimeSpan.Zero;
			
			ThreadPool.QueueUserWorkItem (delegate (object state) {
				InternalSyncDispatch ();
			});
			
			Thread.Sleep (7000);
			Assert.Greater (_syncDispatchValue.TotalSeconds, 2);
		}
		
		private void InternalSyncDispatch ()
		{
			Init (delegate () {
				Dispatch.Initialize (new GtkGuiDispatcher ());

				ThreadPool.QueueUserWorkItem (delegate (object state) {
					DateTime start = DateTime.Now;
					
					Dispatch.GuiSyncDispatch (delegate () {
						Thread.Sleep (2500);
						_syncDispatchValue = DateTime.Now.Subtract (start);
						_label.Text = "SyncDispatch";
					});
				});
			});
		}
		
		[Test]
		public void AsyncDispatch ()
		{
			Init (delegate () {
				Dispatch.Initialize (new GtkGuiDispatcher ());

				ThreadPool.QueueUserWorkItem (delegate (object state) {
					Dispatch.GuiDispatch (delegate () {
						_label.Text = "AsyncDispatch";
					});
				});
			});
		}
		
		private void Init (Execute exec)
		{
			Application.Init ();
			
			_window = new Window ("Anculus Unit Test");
			_window.DestroyEvent += delegate (object sender, DestroyEventArgs args) {
				Application.Quit ();
			};
			
			_label = new Label ();
			_window.SetDefaultSize (200, 100);
			_window.WindowPosition = WindowPosition.Center;
			_window.Add (_label);
			_window.ShowAll ();
			
			ThreadPool.QueueUserWorkItem (delegate (object state) {
				Thread.Sleep (5000);
				
				Application.Invoke (delegate (object sender, EventArgs e) {
					_window.Destroy ();
					Application.Quit ();
				});
			});
			
			exec ();
			
			Application.Run ();
		}
	}
}
