// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class SortQuickSortTest
	{
		[Test]
		public void SortArray ()
		{
			QuickSorter sorter = new QuickSorter ();
			
			string[] arr = new string[] {"a", "z", "e", "r", "t", "y", "u", "i", "o", "p", "b"};
			sorter.Sort (arr);
			
			Assert.AreEqual ("a", arr[0]);
			Assert.AreEqual ("b", arr[1]);
			Assert.AreEqual ("e", arr[2]);
			Assert.AreEqual ("i", arr[3]);
			Assert.AreEqual ("o", arr[4]);
			Assert.AreEqual ("p", arr[5]);
			Assert.AreEqual ("r", arr[6]);
			Assert.AreEqual ("t", arr[7]);
			Assert.AreEqual ("u", arr[8]);
			Assert.AreEqual ("y", arr[9]);
			Assert.AreEqual ("z", arr[10]);
		}
		
		[Test]
		public void SortList ()
		{
			QuickSorter sorter = new QuickSorter ();
			
			List<int> lst = new List<int> ();
			lst.AddRange (new int[] {1, 11, 4, 2, 9, 78, 34, 12, 36, 18});

			sorter.Sort (lst);
			
			Assert.AreEqual (1, lst[0]);
			Assert.AreEqual (2, lst[1]);
			Assert.AreEqual (4, lst[2]);
			Assert.AreEqual (9, lst[3]);
			Assert.AreEqual (11, lst[4]);
			Assert.AreEqual (12, lst[5]);
			Assert.AreEqual (18, lst[6]);
			Assert.AreEqual (34, lst[7]);
			Assert.AreEqual (36, lst[8]);
			Assert.AreEqual (78, lst[9]);
		}
		
		[Test]
		public void SortListReverse ()
		{
			QuickSorter sorter = new QuickSorter ();
			
			List<int> lst = new List<int> ();
			lst.AddRange (new int[] {1, 11, 4, 2, 9, 78, 34, 12, 36, 18});

			sorter.Sort (lst, SortOrder.Descending);
			
			Assert.AreEqual (1, lst[9]);
			Assert.AreEqual (2, lst[8]);
			Assert.AreEqual (4, lst[7]);
			Assert.AreEqual (9, lst[6]);
			Assert.AreEqual (11, lst[5]);
			Assert.AreEqual (12, lst[4]);
			Assert.AreEqual (18, lst[3]);
			Assert.AreEqual (34, lst[2]);
			Assert.AreEqual (36, lst[1]);
			Assert.AreEqual (78, lst[0]);
		}
		
		[Test]
		public void SortAndInsertArray ()
		{
			QuickSorter sorter = new QuickSorter ();
			SortedInserter inserter = new SortedInserter ();
			
			string[] arr = new string[] {"b", "q", "d"};
			sorter.Sort (arr);
			
			inserter.Insert<string> (ref arr, "a");
			inserter.Insert<string> (ref arr, "z");
			inserter.Insert<string> (ref arr, "g");

			Assert.AreEqual ("a", arr[0]);
			Assert.AreEqual ("b", arr[1]);
			Assert.AreEqual ("d", arr[2]);
			Assert.AreEqual ("g", arr[3]);
			Assert.AreEqual ("q", arr[4]);
			Assert.AreEqual ("z", arr[5]);
		}
		
		[Test]
		public void SortAndInsertArrayReverse ()
		{
			QuickSorter sorter = new QuickSorter ();
			SortedInserter inserter = new SortedInserter ();
			
			string[] arr = new string[] {"b", "q", "d"};
			sorter.Sort (arr, SortOrder.Descending);
			
			inserter.Insert<string> (ref arr, SortOrder.Descending, "a");
			inserter.Insert<string> (ref arr, SortOrder.Descending, "z");
			inserter.Insert<string> (ref arr, SortOrder.Descending, "g");

			Assert.AreEqual ("a", arr[5]);
			Assert.AreEqual ("b", arr[4]);
			Assert.AreEqual ("d", arr[3]);
			Assert.AreEqual ("g", arr[2]);
			Assert.AreEqual ("q", arr[1]);
			Assert.AreEqual ("z", arr[0]);
		}
		
		[Test]
		public void SortAndInsertArray2 ()
		{
			string[] arr = new string[] {"b", "q", "d"};
			Sort.QuickSort<string> (arr);
			
			Insert.SortedInsert<string> (ref arr, "a");
			Insert.SortedInsert<string> (ref arr, "z");
			Insert.SortedInsert<string> (ref arr, "g");

			Assert.AreEqual ("a", arr[0]);
			Assert.AreEqual ("b", arr[1]);
			Assert.AreEqual ("d", arr[2]);
			Assert.AreEqual ("g", arr[3]);
			Assert.AreEqual ("q", arr[4]);
			Assert.AreEqual ("z", arr[5]);
		}
	}
}
