// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class SortBinarySearchTest
	{
		private static IndexedName[] _array = new IndexedName [] {
			new IndexedName (0, "z"),
			new IndexedName (1, "y"),
			new IndexedName (2, "x"),
			new IndexedName (3, "w"),
			new IndexedName (4, "v"),
			new IndexedName (5, "u"),
			new IndexedName (6, "t"),
			new IndexedName (7, "s"),
			new IndexedName (8, "r")
		};
		private static IndexedName[] _array1Element = new IndexedName [] {
			new IndexedName (0, "z")
		};
		private static IndexedName[] _array2Elements = new IndexedName [] {
			new IndexedName (0, "z"),
			new IndexedName (1, "y")
		};
		private static IndexedName[] _emptyArray = new IndexedName [] { };
		
		private static IndexedNameComparer _comparer = new IndexedNameComparer ();
		
		[Test]
		public void SearchEmpty ()
		{
			IndexedName result = Sort.BinarySearch<IndexedName, int> (_emptyArray, _comparer, 0);
			Assert.IsNull (result);
		}
		
		[Test]
		public void Search1ElementArray ()
		{
			IndexedName result = Sort.BinarySearch<IndexedName, int> (_array1Element, _comparer, 0);
			Assert.IsNotNull (result);
		}
		
		[Test]
		public void Search2ElementArray ()
		{
			IndexedName result = Sort.BinarySearch<IndexedName, int> (_array2Elements, _comparer, 0);
			Assert.IsNotNull (result);
			result = Sort.BinarySearch<IndexedName, int> (_array2Elements, _comparer, 1);
			Assert.IsNotNull (result);
		}
		
		[Test]
		public void SearchFirst ()
		{
			int index = Sort.BinarySearchIndex<IndexedName, int> (_array, _comparer, 0);
			Assert.AreEqual (0, index);
		}
		
		[Test]
		public void SearchMid ()
		{
			int index = Sort.BinarySearchIndex<IndexedName, int> (_array, _comparer, 4);
			Assert.AreEqual (4, index);
		}
		
		[Test]
		public void SearchLast ()
		{
			int index = Sort.BinarySearchIndex<IndexedName, int> (_array, _comparer, 8);
			Assert.AreEqual (8, index);
		}
		
		[Test]
		public void SearchNegativeNonExisting ()
		{
			int index = Sort.BinarySearchIndex<IndexedName, int> (_array, _comparer, -1);
			Assert.Less (index, 0);
		}
		
		[Test]
		public void SearchPositiveNonExisting ()
		{
			IndexedName result = Sort.BinarySearch<IndexedName, int> (_array, _comparer, 20);
			Assert.IsNull (result);
		}
		
		private class IndexedName
		{
			public int Index;
			public string Name;
			
			public IndexedName (int index, string name)
			{
				Index = index;
				Name = name;
			}
		}
		
		private class IndexedNameComparer : IPropertyComparer<IndexedName, int>, IComparer<IndexedName>
		{
			public int Compare (IndexedName name, int index)
			{
				return name.Index.CompareTo (index);
			}
			
			public int Compare (IndexedName name1, IndexedName name2)
			{
				return name1.Index.CompareTo (name2.Index);
			}
		}
	}
}
