// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

using Anculus.Core;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class SearchAhoCorasickTest
	{
		[Test]
		public void SearchAllSingleKeyword ()
		{
			AhoCorasickSearchAlgorithm ac = new AhoCorasickSearchAlgorithm ();
			SearchResult[] results = ac.SearchAll (SearchTest.ShortText, "behaviour");
			
			Assert.AreEqual (1, results.Length);
			Assert.AreEqual (19, results[0].Index);
		}
		
		[Test]
		[ExpectedException (typeof (ArgumentException))]
		public void SearchAllEmptyKeyword ()
		{
			AhoCorasickSearchAlgorithm ac = new AhoCorasickSearchAlgorithm ();
			ac.SearchAll (SearchTest.ShortText, "");
		}
		
		[Test]
		public void SearchAllFromPosition ()
		{
			AhoCorasickSearchAlgorithm ac = new AhoCorasickSearchAlgorithm ();
			SearchResult[] results = null;
			
			results = ac.SearchAll (SearchTest.ShortText, "in");
			Assert.AreEqual (7, results.Length);
			
			results = ac.SearchAll (SearchTest.ShortText, 90, "in");
			Assert.AreEqual (5, results.Length);
			
			results = ac.SearchAll (SearchTest.ShortText, 90, 2, "in");
			Assert.AreEqual (2, results.Length);
		}
		
		[Test]
		[ExpectedException (typeof (ArgumentOutOfRangeException))]
		public void SearchAllFromInvalidPosition ()
		{
			AhoCorasickSearchAlgorithm ac = new AhoCorasickSearchAlgorithm ();
			ac.SearchAll (SearchTest.ShortText, 923, "rodents");
		}
		
		[Test]
		public void SearchAllUnicode ()
		{
			AhoCorasickSearchAlgorithm ac = new AhoCorasickSearchAlgorithm ();
			SearchResult[] results = ac.SearchAll (SearchTest.ShortUnicodeText, "忘");
			
			Assert.AreEqual (1, results.Length);
			Assert.AreEqual (2, results[0].Index);
		}
	}
}
