// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Threading;
using System.Globalization;
using System.Collections.Generic;

using Anculus.Core;
using Anculus.Core.Extended;

using NUnit.Framework;

namespace Anculus.UnitTests
{
	[TestFixture]
	public class ManagedGettextTest
	{
		[SetUp]
		public void Setup ()
		{
			Thread.CurrentThread.CurrentCulture = CultureInfo.GetCultureInfo ("nl-BE");
			
			ManagedGettextBackend backend = new ManagedGettextBackend ("test", ".");
			Translation.Backend = backend;
		}

		[Test]
		public void TranslateSingular ()
		{
			string s = Translation.GetString ("Sample");
			Assert.AreEqual ("Voorbeeld", s);
		}
		
		[Test]
		public void TranslateSimplePlural ()
		{
			string s = Translation.GetString ("I have one apple.");
			Assert.AreEqual ("Ik heb een appel.", s);
			
			string p = Translation.GetPluralString ("I have one apple.", "I have {0} apples.", 3, 3);
			Assert.AreEqual ("Ik heb 3 appels.", p);
		}
		
		[Test]
		public void TranslateNonExisting ()
		{
			string undef = "This sentence isn't defined in the po file";
			
			string s = Translation.GetString (undef);
			Assert.AreEqual (undef, s);
		}
	}
}
