#import "LynkeosFfmpegMovie.h"


@implementation LynkeosFfmpegMovie


+ (NSArray*) movieUnfilteredFileTypes{

  NSMutableArray* array;
  
  array = [NSMutableArray new];
  
  [array addObject:[NSString stringWithCString: "avi"]];
  [array addObject:[NSString stringWithCString: "mpeg"]];
  [array addObject:[NSString stringWithCString: "mpg"]];
  return array;
}



- (id)initWithURL:(NSURL *)url byReference:(BOOL)byRef
{
  char* cs;
  int error;
  cs = [[url path] cString];
  //cs = [s cString];
  currentFrame = 0;

  error = ffmpegLoadMovie(cs,&movie);
  if(error){
    return nil;
  }

  return self;
}

- (TimeValue)getNextFrameTime
{
  if(ffmpegNextFrame(&movie)){
    currentFrame++;
  }
  else{
    [self resetMovie];
    return -1;
  }
  return currentFrame;
}


- (NSSize) imageSize
{
  return NSMakeSize(movie.pCodecCtx->width, movie.pCodecCtx->height);
}


- (void) resetMovie{
  ffmpegMovieBackToStart(&movie);
  currentFrame =  0;
}

- (NSImage*) getImageAt:(TimeValue)time
{
  NSMutableData* data;

  if(time < currentFrame){
    [self resetMovie];
  }
  while(time > currentFrame){
    [self getNextFrameTime];
  }

  //Now currentFrame is the good one ....
  data = [NSMutableData new];
  [self loadImageDataIn: data];
  [data autorelease];

  return( [[[NSImage alloc] initWithData: data] autorelease] );
}

-(void) loadImageDataIn:(NSMutableData*)data{
  char* header;
  NSSize size;
  int nbBytes;
  int height;
  int width;
  int y;

  ffmpegConvertCurrentFrame(&movie);

  [data setLength: 0];
  
  size = [self imageSize];
  height = size. height;
  width = size. width;
  // create header
  nbBytes = asprintf(&header, "P6\n%d %d\n255\n", width, height);
  [data appendBytes:header length:nbBytes];

  nbBytes = width*3;
  for(y=0; y<height; y++){
    [data appendBytes: (movie.pConvertedFrame->data[0]+y*movie.pConvertedFrame->linesize[0]) length: nbBytes];
  }
  
  free(header);
}


@end
