# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2010 Leszek Lesner leszek@zevenos.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

#from desktopcouch.records.server import CouchDatabase
#from desktopcouch.records.record import Record
import gtk, os, sys

from lxkeymap.helpers import get_builder

import gettext
from gettext import gettext as _
gettext.textdomain('lxkeymap')

class PreferencesLxkeymapDialog(gtk.Dialog):
    __gtype_name__ = "PreferencesLxkeymapDialog"
    preferences = {}

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated PreferencesLxkeymapDialog object.
        """
        builder = get_builder('PreferencesLxkeymapDialog')
        new_object = builder.get_object("preferences_lxkeymap_dialog")
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called while initializing this instance in __new__

        finish_initalizing should be called after parsing the ui definition
        and creating a PreferencesLxkeymapDialog object with it in order to
        finish initializing the start of the new PerferencesLxkeymapDialog
        instance.
        
        Put your initialization code in here and leave __init__ undefined.
        """



    def ok(self, widget, data=None):
        """The user has elected to save the changes.

        Called before the dialog returns gtk.RESONSE_OK from run().
        """

        # Make any updates to self._preferences here. e.g.
        #self._preferences["preference1"] = "value2"
        #self._save_preferences()

    def cancel(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns gtk.RESPONSE_CANCEL for run()
        """
        # Restore any changes to self._preferences here.
        pass

if __name__ == "__main__":
    dialog = PreferencesLxkeymapDialog()
    dialog.show()
    gtk.main()
