#!/usr/bin/env php 
<?php
/*
    LWAT, LDAP Webbased Administration Tool
    Copyright (C) 2007  Finn-Arne Johansen <faj@bzz.no>, BzzWare AS, Norway

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

$script = $argv[0] ; 
while (is_link ($script))
    $script = readlink($argv[0]) ; 

$dir = dirname(dirname(realpath($script))) ; 
if (is_dir ($dir . '/lib'))
    $includedir = $dir . '/lib' ; 
else
    $includedir = $dir . '/web' ; 

require_once ($includedir . '/functions.php') ; 

loadConfig () ; 

for ($i = 1 ; $i < $argc ; $i++) {
    switch (strtolower($argv[$i])) {
        case "--template": 
            $i++ ; 
            $template = $argv[$i] ; 
            break ; 
        case "--cn": 
            $i++ ; 
            $cn = $argv[$i] ; 
            break ; 
        case "--username": 
            $i++ ; 
            $username = $argv[$i] ; 
            break ; 
        case "--userpw": 
            $i++ ; 
            $userpw = $argv[$i] ; 
            break ; 
        case "--groups": 
            $i++ ; 
            $groups = $argv[$i] ; 
            break ;
        case "--admin": 
            $i++ ; 
            $admin = $argv[$i] ; 
            break ; 
    }
}

if (empty($template))
    printf (_("You need to specify a user template\n")); 

if (empty($cn))
    printf (_("You need to specify a cn (fullname)\n")); 

if (empty ($template) || empty ($cn))
    exit  ; 

if (empty($userpw))
    $userpw = pwgen () ; 

if (empty($admin))
    $admin = "admin" ; 

$adminpw = $_ENV["LWAT_ADMINPW"] ; 
while (ob_end_flush ()) ; 

if (empty ($adminpw)) {
    printf (_("You need to enter a password user %s to connect to ldap:\n"),
            $admin) ; 
    $fp = popen ("read -s; echo \$REPLY", "r") ;
    $adminpw = trim(fgets ($fp)); 
    pclose ($fp) ; 
}

$ldap=ldap_connect ($ldaphost); 
ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
@ldap_start_tls($ldap) ; 
$loginbase = $base ; 
$filter = '(|(&(objectClass=posixAccount)(uid=' . $admin . '))(&(objectClass=simpleSecurityObject)(cn=' . $admin . ')))' ; 
$want = array ("dn") ; 
$authenticated = false ; 
while (!empty ($loginbase) && !$authenticated) {
    $result = @ldap_search($ldap, $loginbase, $filter, $want);
    $entries = @ldap_get_entries ($ldap, $result); 
    $admindn = htmlspecialchars($entries[0]['dn']) ; 
    $bind = @ldap_bind ($ldap, $admindn, $adminpw); 
    if ($bind) {
	$authenticated = true ; 
    } else {
	$loginbase = ldap_explode_dn ($loginbase,0) ;
	array_splice ($loginbase, 0,2) ; 
	$loginbase = implode (",", $loginbase) ; 
    }
}

if (empty($username))
    $username = get_username ($ldap, $cn) ; 

ldapAddUser ($ldap, $cn, $template, $username, $userpw, $groups) ;
printf ("Added user %s\nusername: %s\nPassword: %s\nMember of: %s\n", 
        $cn, $username, $userpw, $groups) ; 
?>
