<?php
/*
# Copyright 2006, CRIM, Stephane Bond
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'dbFunctions.php';
	
	/**
	*
	* Find the security rules for an ip
	* 
	* @package MILLE-CONFIGURATOR
	*/
	class SecurityRulesFinder {

		/**
		* ip address of the computer
		* @access private
		* @var int
		*/
		var $ip;
		/**
		* nodeid
		* @access private
		* @var string
		*/
		var $nodeid;
		/**
		* authorizedIps
		* @access private
		* @var string
		*/
		var $authorizedIps;
		/**
		* authorizedKeys
		* @access private
		* @var string
		*/
		var $authorizedKeys;
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $lastError;
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $isError;
		

		/**
		* The constructor of a SecurityRulesFinder
		*
		* Initialised in by :
		* <ul>
		* <li> IP of the computer
		* </ul>
		* 
		* Example of valid initialisation :
		*
		* <code>
		*   $finder=new SecurityRulesFinder("10.1.0.9");
		* </code>
		*
		* @access public
		*/
		function SecurityRulesFinder($ipaddr) {
			$this->notFound = false;
			$this->ip = $ipaddr;

			$node = new Node($this->ip);
			$this->nodeid=$node->getID();
			$parentId=$node->getParentID();
			
			$columns="S.ip, N.mac, S.username, S.termaccess, S.publickey";
			$from ="nodes N INNER JOIN status S ON S.id = N.id ";
			$where="N.id_parent=".$parentId." AND S.termaccess>0";
			
			$result=$this->getFromDB($columns,$where,$from,true,true);
			if (!empty($result)) {
				foreach ($result as $res) {
					if ($res["termaccess"] > 1) {
						$this->authorizedIps[] = $res["ip"];
						if ($res["termaccess"] > 1 && !empty($res["publickey"])) {
							$this->authorizedKeys[] = $res["publickey"];
						}
					}
				}
			}
		}
		
		/**
		* Return true if not found
		*
		* @access public
		* @return int
		*/
		function notFound() {
			return $this->notFound;
		}
		
		/**
		* Get the autorized ips
		*
		* @access public
		* @return array
		*/
		function getAuthorizedIps() {
			return $this->authorizedIps;
		}
		
		/**
		* Get the autorized keys
		*
		* @access public
		* @return array
		*/
		function getAuthorizedKeys() {
			return $this->authorizedKeys;
		} 
		
		/**
		* Get the node ID
		*
		* @access public
		* @return int
		*/
		function getNodeID() {
			return $this->nodeid;
		}

		/**
		* Return yes if the object exists
		* To be used just after the construction
		*
		* @access public
		* @return float
		*/
		function isError() {
			return $this->isError;
		}

		/**
		* Get the last error
		*
		* @access public
		* @return float
		*/
		function lastError() {
			return $this->lastError;
		}

		
		/**
		* GetFromDB
		*
		* @access private
		* @return array
		*/
		function getFromDB($column,$where,$from="attributes",$isFatal=true,$multiple = false) {
			$query='SELECT '.$column.' FROM '.$from.' WHERE '.$where;
			if ($multiple) {
				$result = select($query.";");
			}
			else {
				$result = singleResultSelect($query);
			}
			if (!$result) {	
				$this->lastError = getMessage('not_found').$query; 
				$this->notFound = true; 
				if ($isFatal) 
					$this->isError = true; return NULL; 
			}
			elseif (!is_array($result)) { 
				$this->lastError = getMessage('db_error').$result." : ".$query; 
				if ($isFatal) $this->isError = true; return NULL;
			}
			return $result;
		}
		
	} // class SecurityRulesFinder
?>
