// $Id: profileparms.cpp,v 1.26 2006/04/28 22:57:21 hvengel Exp $
//  Little cms - profiler construction set
//Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//

#include "profileparms.h"
#include <lcmsprf.h>

#include <wwfloatspinbox.h>

static PROFILERDATA sys;

// static QAssistantClient* help;

QString sm = ProfileParms::tr("(%g) Smoothness:"),
        avdev = ProfileParms::tr("(%g) Avg. Deviation:");
   
QString parms_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}
   
ProfileParms::ProfileParms(QWidget *parent )
    : ProfileParmsBase(parent, "", 0, Qt::WStyle_SysMenu | Qt::WStyle_MinMax )
{  // char Buffer[256];
    passSys a;
    a.get(&sys);
    avgDevFloatSpinBox -> setPrecision(7);
    avgDevFloatSpinBox -> setMinValue(0.00001);
    avgDevFloatSpinBox -> setLineStep(0.00001);
    avgDevFloatSpinBox -> setMaxValue(0.025);
    avgDevFloatSpinBox -> setValue(0.005);
    
    smoothSpinBox -> setMinValue(0.5);
    smoothSpinBox -> setLineStep(0.01);
    smoothSpinBox -> setMaxValue(2.5);
    smoothSpinBox -> setValue(1.0);
    LaSpinBox -> setMinValue(14.0);
    LaSpinBox -> setLineStep(0.01);
    LaSpinBox -> setMaxValue(40.0);
    LaSpinBox -> setValue(20.0);
    YbSpinBox -> setMinValue(14.0);
    YbSpinBox -> setLineStep(0.01);
    YbSpinBox -> setMaxValue(40.0);
    YbSpinBox -> setValue(20.0);
    
    ValuesToControls(); 
}

ProfileParms::~ProfileParms()
{
    dialogSize ds;
        
    ds.put(5, this -> height(), this -> width());
}


void ProfileParms::ValuesToControls()
{
    // char buff[128];          
    CAMRadio        -> setChecked(sys.hdr.lUseCIECAM97s);
    VonKriesRadio   -> setChecked(!sys.hdr.lUseCIECAM97s);

    // CheckBoxLocalExtrapolate ->setChecked(sys.lLocalConvergenceExtrapolation);

    switch (sys.hdr.CLUTPoints) 
    {
            case 10: RB10 -> setChecked(TRUE); break;       
            case 20: RB20 -> setChecked(TRUE); break;
            case 33: RB33 -> setChecked(TRUE); break;

            default:  RB16 -> setChecked(TRUE); 
    }

    switch (sys.hdr.ProfileVerbosityLevel) 
    { 
        case 0: MinimumTagsRadio -> setChecked(TRUE); break;      
        case 1: NormalTagsRadio  -> setChecked(TRUE); break;  
        case 2:
        default: VerboseTagsRadio -> setChecked(TRUE); break;  
    }
   
    smoothSpinBox -> setValue((double)sys.RsplSmoothness);
    avgDevFloatSpinBox -> setValue((double)sys.AvgDev);
    YbSpinBox -> setValue(sys.hdr.device.Yb);
    LaSpinBox -> setValue(sys.hdr.device.La);
    SurroundCombo -> setCurrentItem(sys.hdr.device.surround);
    slotChangeStrategy();
}

void ProfileParms::ControlsToValues()
{
    sys.hdr.lUseCIECAM97s   = CAMRadio -> isChecked();
    sys.hdr.device.surround = SurroundCombo -> currentItem();
    
    sys.RsplSmoothness = smoothSpinBox -> value();
    sys.AvgDev = avgDevFloatSpinBox -> value();
    sys.hdr.device.Yb = YbSpinBox -> value();
    sys.hdr.device.La = LaSpinBox -> value();
        
    if (RB10 -> isChecked())
        sys.hdr.CLUTPoints = 10;
    else 
    if (RB33 -> isChecked())
        sys.hdr.CLUTPoints = 33;
    else
    if (RB20 -> isChecked())
        sys.hdr.CLUTPoints = 20;
    else
        sys.hdr.CLUTPoints = 16;

    // sys.lLocalConvergenceExtrapolation = CheckBoxLocalExtrapolate -> isChecked();
    sys.hdr.ProfileVerbosityLevel = 0;

    if (NormalTagsRadio -> isChecked())
	sys.hdr.ProfileVerbosityLevel = 1;
    else
        if (VerboseTagsRadio -> isChecked())
		sys.hdr.ProfileVerbosityLevel = 2;  
}


void ProfileParms::slotChangeStrategy()
{
    SurroundCombo -> setEnabled(CAMRadio -> isChecked());
    LabelSurround -> setEnabled(CAMRadio -> isChecked());
        
    LabelLa       -> setEnabled(CAMRadio -> isChecked());     
    LabelYb       -> setEnabled(CAMRadio -> isChecked()); 
    LaSpinBox       -> setEnabled(CAMRadio -> isChecked());     
    YbSpinBox       -> setEnabled(CAMRadio -> isChecked()); 
}

void ProfileParms::slotOK()
{
    passSys a;
    dialogSize ds;
        
    ds.put(5, this -> height(), this -> width());
    ControlsToValues();
    a.put(sys);
}

void ProfileParms::slotHelpButton()
{
     QString path = QDir::currentDirPath() + "/help/profile-parms.html";
     getHelp()->openAssistant ();
     getHelp()->showPage(path);
}

