from qt import *
import fcntl, os, errno, shutil, kdefx, backtick, re, md5

class LUtils:
	def downsizeImage(srcPath, dstPath, inSize=QSize(240,180), quality=100):
		size = QSize(inSize)
		img = QImage(srcPath)
		# align size to image
		if img.width() > img.height() and size.width() < size.height() or img.width() < img.height() and size.width > size.height():
			size.transpose()
		
		if img.width() > size.width() or img.height() > size.height() or quality != 100:
			ratio = min(size.width()/float(img.width()), size.height()/float(img.height()))
			w = int(img.width()*ratio)
			h = int(img.height()*ratio)
			t = img.smoothScale(w,h)
			t.save(dstPath, "JPEG", quality)
		else:
			shutil.copy2(srcPath, dstPath)
		return (img.width(), img.height())
	downsizeImage = staticmethod(downsizeImage)
	
	def downsizeImageNoWrite(img, inSize=QSize(240,180)):
		size = QSize(inSize)
		if img.width() > img.height() and size.width() < size.height() or img.width() < img.height() and size.width > size.height():
			size.transpose()
		
		if img.width() > size.width() or img.height() > size.height():
			ratio = min(size.width()/float(img.width()), size.height()/float(img.height()))
			w = int(img.width()*ratio)
			h = int(img.height()*ratio)
			t = img.smoothScale(w,h)
			img = t
		return img
	downsizeImageNoWrite = staticmethod(downsizeImageNoWrite)
		
	
	def resizeImage(srcPath, dstPath, size=QSize(352,240), quality=100):
		img = QImage(srcPath)
		# align size to image
		ratio = min(size.width()/float(img.width()), size.height()/float(img.height()))
		w = int(img.width()*ratio)
		h = int(img.height()*ratio)
		t = img.smoothScale(w,h)			
		if w != size.width() or h != size.height():
			i = QPixmap(size)
			painter = QPainter(i)
			painter.setBackgroundColor(QColor(0,0,0))
			r,b1,b2 = LUtils.mapRectAndBackground(i.rect(), t.rect())
			painter.eraseRect(b1)
			painter.eraseRect(b2)
			painter.drawImage(r.x(), r.y(), t)
			t = i.convertToImage()
		t.save(dstPath, "JPEG", quality)
			
		return (img.width(), img.height(), t)
	resizeImage = staticmethod(resizeImage)
	
	def blendImages(image1, image2, alpha, path):
		img = image1.copy()
		kdefx.KImageEffect.blend(image2, img,  alpha)
		img.save(path, "JPEG", 100)
	blendImages = staticmethod(blendImages)

	def getBoundingRects(a, b):
		r1 = QRect(a.left(), a.top(), a.width(), b.top()-a.top())
		r2 = QRect(a.left(), b.top(), b.left()-a.left(), b.height())
		r3 = QRect(b.right()+1, b.top(), a.right()-b.right(), b.height())
		r4 = QRect(a.left(), b.bottom()+1, a.width(), a.bottom()-b.bottom())
		return (r1,r2,r3,r4)
	getBoundingRects = staticmethod(getBoundingRects)

	def mapRect(ro, ri): #create a new rect that maps ri to the inside of ro
		if ri.width() == 0 or ri.height() == 0:
			ratio = 1.0
		else:
			ratio = min(ro.width()/float(ri.width()), ro.height()/float(ri.height()))
		w = ri.width()*ratio
		h = ri.height()*ratio
		x = ro.x() + (ro.width() - w) / 2
		y = ro.y() + (ro.height() - h) / 2
		return QRect(x,y,w,h)
	mapRect = staticmethod(mapRect)
	
	def mapRectAndBackground(ro, ri): #create a new rect that maps ri to the inside of ro
		ratio = min(ro.width()/float(ri.width()), ro.height()/float(ri.height()))
		w = ri.width()*ratio
		h = ri.height()*ratio
		x = ro.x() + (ro.width() - w) / 2
		y = ro.y() + (ro.height() - h) / 2
		if w == ro.width():
			b1 = QRect(ro.x(), ro.y(), ro.width(), y)
			b2 = QRect(ro.x(), ro.y()+y+h ,ro.width() , ro.height()-y-h)
		else:
			b1 = QRect(ro.x(), ro.y(), x, ro.height())
			b2 = QRect(ro.x()+x+w, ro.y(), ro.width()-x-w, ro.height())
		return QRect(x,y,w,h), b1, b2
	mapRectAndBackground = staticmethod(mapRectAndBackground)

	def bound(a, b, c):
		# return value b between a and c
		if (b < a): return a
		elif (b > c): return c
		return b
	bound = staticmethod(bound)
	
	def centerRect(r, p, b):
		# center's rect(r) on the point(p), bound by the rect(b)
		if r.width() > b.width():
			x = b.width() / 2
		else:
			w = r.width() / 2
			x = LUtils.bound(b.left() + w, p.x(), b.right() - w)
	
		if r.height() > b.height():
			y = b.height() / 2
		else:
			h = r.height() / 2
			y = LUtils.bound(b.top() + h, p.y(), b.bottom() - h)
			
		r.moveCenter(QPoint(x,y))
		return r
	centerRect = staticmethod(centerRect)
	
	def alignRectToPoint(p1, r, p2, b):
		# position r so that p2 appears at point P1[in r coords]  bound by the rect(b)
		if r.width() > b.width():
			x = (b.width() - r.width()) / 2
		else:
			w = r.width() / 2
			x = LUtils.bound(0, p2.x()-p1.x(), b.right() - r.width())
	
		if r.height() > b.height():
			y = (b.height() - r.height()) / 2
		else:
			h = r.height() / 2
			y = LUtils.bound(0, p2.y()-p1.y(), b.bottom() - r.height())
			
		r.moveTopLeft(QPoint(x,y))
		return r
	alignRectToPoint = staticmethod(alignRectToPoint)

	def ensureDirectory(path):
		try:
			os.makedirs(path,0777)
		except OSError, err:
			if err.errno != errno.EEXIST or not os.path.isdir(path):
				raise
	ensureDirectory = staticmethod(ensureDirectory)
	
	def fileExists(path):
		try:
			fd = os.open(path, os.O_RDWR)
		except OSError:
			return False
		os.close(fd)
		return True
	fileExists = staticmethod(fileExists)
	
	def removeFile(path):
		if LUtils.fileExists(path):
			try:
				os.remove(path)
				return True
			except OSError:
				return False
		return False
	removeFile = staticmethod(removeFile)

	def humanByteOutput( size):
		if size > 1024 * 1024:
			return str("%0.1f MB"%(size/float(1024*1024)))
		if size > 1024:
			return str("%0.1f KB"%(size/float(1024)))
	humanByteOutput = staticmethod(humanByteOutput)
	
	def datePath(time_t):
		dt = QDateTime()
		dt.setTime_t(time_t)
		path = os.path.join(str(dt.date().year()),"%02d"%(dt.date().month()),"%02d"%(dt.date().day()))
		return path
	datePath = staticmethod(datePath)
	
	def isListChild(parent, child):
		if len(child) < len(parent):
			return False
		return parent[0:len(parent)]==child[0:len(parent)]
	isListChild = staticmethod(isListChild)
	
	def findUniqueFilename(dir, filename):
		(a,b) = os.path.splitext(filename)
		newName = a + b
		check = str(os.path.join(dir, newName))
		i = 1
		while (LUtils.fileExists(check)):
			newName = a + str(i) + b
			check = os.path.join(dir, newName)
			i = i + 1
		return newName
	findUniqueFilename = staticmethod(findUniqueFilename)
	
	def buildFilename(filename):
		
		if filename[-4:].lower() == ".jpg" or filename[-5:].lower() == ".jpeg":
			return filename
		else:
			return filename+".jpg"
	buildFilename = staticmethod(buildFilename)
	
	
	def safeCopy(src, dst):
		try:
			shutil.copy2(src, dst)
		except:
			pass
	safeCopy = staticmethod(safeCopy)
	
	def safeToInt(s):
		try:
			return int(str(s))
		except:
			return 0
	safeToInt = staticmethod(safeToInt)
	
	def hasOpenGL():
		try:
			text = backtick.backtick("glxinfo | grep \"direct rendering\"")
			regex = re.compile(r"Yes")
			mc = regex.search(text)
			if mc:
				return True
		except RuntimeError:
			pass
		return False
	hasOpenGL = staticmethod(hasOpenGL)
	
	def md5(path):
		try: 
			f = open(path, "rb")
			data = f.read(1024*8)
			m = md5.new()
			m.update(data)
			print "md5",m.hexdigest(),path
			return m.hexdigest()
		except RuntimeError:
			pass
		return False
	md5 = staticmethod(md5)
	
	
def _setApp(app):
	global _app
	_app = app
	
def _getApp():
	global _app
	return _app

class LWaitCursor:
	setApp = staticmethod(_setApp)
	getApp = staticmethod(_getApp)

	def __init__(self):
		LWaitCursor.getApp().setOverrideCursor(QCursor(Qt.WaitCursor))
	
	def __del__(self):
		LWaitCursor.getApp().restoreOverrideCursor()
		
class LSettings:
	libraryPath = str(os.path.join(os.path.expanduser('~'),'My Documents','My Photos','Lphoto Library'))
	
	def validFileTypes():
		return ["jpg"] + [x.lower() for x in QImage.inputFormats()]
	validFileTypes = staticmethod(validFileTypes)

def lock(file,flags = fcntl.LOCK_EX):
        fcntl.flock(file.fileno(),flags)

def unlock(file):
        fcntl.flock(file.fileno(),fcntl.LOCK_UN)
                                                       

if __name__ == "__main__":
	print LUtils.md5("/root/Desktop/dcim/100olymp/p1010029.jpg")
