""" XSL Template Script

	Template modules need to support the construct function
	Builds and HTML page from a photo list and an XSL template and copies other resouce files to 
	destination path.
"""
import os, shutil, qtxml

def construct(templateDir, exportDir, photos, title):
	""" construct called by LPhoto
	templateDir: path to template and associated resources
	exportDir: path to destination directory.  images should already exist there, with subdir "thumbs" containing thumbnails
	photos: list of dictionaries containing attributes for each photo
	title: title for photo ablum
	"""
	
	xmlArray=["<Data>",
			  "\t<Title title='%s'/>"%(title),
			  "\t<Prefix prefix='images/' thumbnail='T' extension='.jpg'/>"
			 ]
	for p in photos:
		path,filename = os.path.split(p['ImagePath'])
		name,ext = os.path.splitext(filename)
		xmlArray.append("\t<Image id='%s'/>"%(name))
		oldthumb = os.path.join(exportDir, "thumbs", filename)
		newthumb = os.path.join(exportDir, "images", name+"T"+ext)
		print oldthumb, newthumb, name
		shutil.move(oldthumb, newthumb)
		
	xmlArray.append("<Data/>")
	
	xmlString = "\n".join(xmlArray)
	
	tmpPath = os.path.join(exportDir, "photos.xml")
	ouf = open(tmpPath, mode="w")
	ouf.write(xmlString)
	ouf.close()

	__copyTreeAll(os.path.join(templateDir, "resources"), os.path.join(exportDir))

def __copyTreeAll(src, dst):
    names = os.listdir(src)
    if not os.path.isdir(dst):
        os.mkdir(dst)
    for name in names:
        srcname = os.path.join(src, name)
        dstname = os.path.join(dst, name)
        if os.path.isdir(srcname):
            __copyTreeAll(srcname, dstname)
        else:
            shutil.copy2(srcname, dstname)

if __name__=="__main__":
	print "Lphoto XSL template script"


	


