from qt import *
from dragobjects import *
##~ from kdeui import *
from kdeemul import *
from utils import *
from importsession import *
from photo import *
import paths
import time
import copy

_ds_tr = None
_ds_right = None
_ds_br = None
_ds_bottom = None
_ds_bl = None

def _ensureImages():
	global _ds_tr, _ds_right, _ds_br, _ds_bottom, _ds_bl
	if _ds_tr==None:
		_ds_tr = QPixmap(paths.art("shadowupperright.png"))
		_ds_right = QPixmap(paths.art("shadowmiddleright.png"))
		_ds_br = QPixmap(paths.art("shadowlowerright.png"))
		_ds_bottom = QPixmap(paths.art("shadowlowermiddle.png"))
		_ds_bl = QPixmap(paths.art("shadowlowerleft.png"))

_star = None
def star():
	global _star
	if _star==None:
		_star = QPixmap(paths.art("labelstar.png"))
	return _star

class LThumbnail:
	def __init__(self, view, key, dict):
		self.view = view
##		self.xOffset = 0
##		self.yOffset = 0
##		self.xTextOffset = 0
		self.bSelect = False
		self.bNewPixmap = True
		self.r = QRect(0,0,0,0)
		self.key = key
		self.dict = dict
		self.thumbImage = None
		self.refreshThumb()
		
	def setImageRect(self, r):
	#	if r != self.r:
		self.r = r
		self.bNewPixmap = True

	def refreshThumb(self):
		if self.thumbImage:
			self.thumbImage = None
		if self.dict == None:
			return
		# load values from dict
		self.caption = QString(self.dict['Caption'])
		self.rating = self.dict['Rating']
		self.date = self.dict['Date']
		self.ar = self.dict['AspectRatio']
		self.path = self.dict['ThumbPath']
		self.bNewPixmap = True

	def buildDragPixmap(self):
		if not self.thumbImage:
			self.thumbImage = QImage(self.path)
			
		if self.thumbImage:
			ar = self.dict['AspectRatio']
			if ar > 1.0:
				w = 80
				h = int(w / ar)
			else:
				h = 80
				w = int(h * ar)
			i = self.thumbImage.scale(w,h)
			pm = QPixmap()
			pm.convertFromImage(i)
##~ 			pio = KPixmapIO()
##~ 			return pio.convertToPixmap(i)	
			return pm
			
	def buildPixmap(self, r):
		if not self.thumbImage:
			self.thumbImage = QImage(self.path)
		i = self.thumbImage.scale(self.r.width(), self.r.height())
		#pio = KPixmapIO()
		self.scaledPixmap = QPixmap()
		self.scaledPixmap.convertFromImage(i)
		#self.scaledPixmap = pio.convertToPixmap(i)
		self.bNewPixmap = False
		
	def paintText(self, p, fm, bCaption, bRating):
		pt = QPoint(self.r.left(), self.r.bottom())
		w = self.r.width()
		p.setPen(QPen(QColor(0,0,0)))
		if bCaption:
			pt.setY(pt.y() + fm.height())
			if fm.width(self.caption) < w:
				p.drawText(pt, self.caption)
			else:
				l = self.caption.length()-1
				s = str(self.caption.left(l)) + "..."
				while fm.width(s) > w and l > 0:
					l = l - 1
					s = str(self.caption.left(l)) + "..."
				p.drawText(pt, s)
		if bRating and self.rating:
			pt.setX(self.r.left()) #+ (w-(self.rating*13))/2)
			for i in xrange(0, self.rating):
				p.drawPixmap(QPoint(pt.x() + i *13, pt.y() + 5),star())
			
	def paintDropShadow(self, p, r):
		global _ds_tr, _ds_right, _ds_br, _ds_bottom, _ds_bl
		#paint corners
		p.drawPixmap(r.right()+1, r.top(), _ds_tr)
		p.drawPixmap(r.right()-4, r.bottom()+1, _ds_br)
		p.drawPixmap(r.left(), r.bottom()+1, _ds_bl)
		#paint sidesupperright
		p.drawTiledPixmap(QRect(r.right()+1, r.top()+6, 3, r.height() - 6), _ds_right)
		p.drawTiledPixmap(QRect(r.left()+6, r.bottom()+1, r.width() - 11, 5), _ds_bottom)
		
	def paintItem(self, p, fm, bCaption, bRating):
		if self.bNewPixmap:
			self.buildPixmap(self.r)
		p.drawPixmap(self.r.x(), self.r.y(), self.scaledPixmap)
		r = QRect(self.r)
		r.addCoords(-1,-1,1,1)
		p.setPen(QPen(QColor(84,84,84)))
		p.drawRect(r)
		self.paintDropShadow(p, r)
		self.paintText(p, fm, bCaption, bRating)
		if self.bSelect:
			pen = QPen(QColor(0x41,0x8c,0xe5),2)
			p.setPen(pen)
			r = QRect(self.r)
			r.addCoords(-4,-4,5,5)
			p.drawRect(r)
		
	def selected(self, b):
		if b != self.bSelect:
			self.bSelect = b
			self.view.updateRect(self.r)
		
	def isSelected(self):
		return self.bSelect

class LOrganizeViewport(QWidget):
	def __init__(self, parent):
		_ensureImages()
		QWidget.__init__(self, parent)
		self.setBackgroundMode(Qt.NoBackground)
		self.os = QPixmap(self.size())
		self.setAcceptDrops(True)
		self.setMouseTracking(True)
		self.setFocusPolicy(QWidget.StrongFocus)

	def paintEvent(self, pe):
		# copy offscreen to screen
		p = QPainter(self)
		self.os.fill()
		self.parent().viewportPaint(self.os)
		p.drawPixmap(0,0,self.os)

	def resizeEvent(self, re):
		self.os.resize(self.size())
		self.parent().viewportResize()
		self.update()
		
	def dragEnterEvent(self, event):
		self.parent().dragEnterEvent(event)
		
	def dragMoveEvent(self, event):
		self.parent().dragMoveEvent(event)
		
	def dragLeaveEvent(self, event):
		self.parent().dragLeaveEvent(event)
		
	def dropEvent(self, event):
		self.parent().dropEvent(event)

def cmpRating(a,b):
	if a.rating < b.rating:
		return 1
	elif a.rating > b.rating:
		return -1
	else:
		return 0
		
def cmpCaption(a,b):
	if a.caption > b.caption:
		return 1
	elif a.caption < b.caption:
		return -1
	else:
		return 0

def cmpDate(a,b):
	if a.date > b.date:
		return 1
	elif a.date < b.date:
		return -1
	else:
		return 0

class LOrganizeView(QWidget):
	def __init__(self, parent):
		QWidget.__init__(self, parent)
		gl = QGridLayout(self, 1, 1)
		self.viewport = LOrganizeViewport(self)
		gl.addWidget(self.viewport, 0, 0)
		self.scrollBar = QScrollBar(QScrollBar.Vertical, self)
		gl.addWidget(self.scrollBar, 0, 1)
		self.scale = 1.0
		self.thumbSize = 100
		self.currentItem = None
		self.itemsSel = []
		self.album = None
		self.layoutDirty = True
		self.items = None
		QObject.connect(self.scrollBar, SIGNAL("valueChanged(int)"), self.slotScrolled)
		self.viewTitle = True
		self.viewRating = True
		self.insertBeforeIndex = None
		self.insertRectHint = None
		self.setAcceptDrops(True)
		self.popup = QPopupMenu()
		self.albumPath = None
		self.setMouseTracking(True)
		self.hoverTimer = QTimer()
		self.hoverTime = 750
		self.tooltip = None
		QObject.connect( self.hoverTimer, SIGNAL("timeout()"), self.hoverFunc )
		self.setFocusPolicy(QWidget.StrongFocus)
		self.hoverPt = QPoint()
		self.selectStart = QPoint()
		self.selectRect = None
		self.shiftSelItem = None

	def setLibrary(self, lib):
		self.lib = lib
		QObject.connect(lib, PYSIGNAL("updateAlbums"), self.slotUpdateAlbums)
		QObject.connect(lib, PYSIGNAL("setCaption"), self.slotRefreshCaption)
		QObject.connect(lib, PYSIGNAL("setRating"), self.slotRefreshRating)
		QObject.connect(lib, PYSIGNAL("importPhoto"), self.slotAddPhotoToEnd)
		QObject.connect(lib, PYSIGNAL("moveAlbum"), self.slotMoveAlbum)
		
		QObject.connect(Photo.updateEvents, PYSIGNAL("photoUpdate"), self.slotUpdateImage)


	def initPopupMenu(self, ac):
		ac.action("file_print").plug(self.popup)
		ac.action("exportSelection").plug(self.popup)
		
		self.popup.insertSeparator()
##~ 		ac.action("email").plug(self.popup)
		ac.action("duplicate").plug(self.popup)
		ac.action("rotateClockwise").plug(self.popup)
		ac.action("rotateCounterClockwise").plug(self.popup)
		ac.action("moveToTrash").plug(self.popup)
		ac.action("revert").plug(self.popup)

	def __refreshThumbnails(self):
		# get new list
		if not self.album:
			return False
		# for each in list, check if it's already loaded, 
		self.items = [LThumbnail(self, key, self.lib.getImage(key)) for key in self.album['KeyList']]
		self.sortKeys()
		#if loaded, copy from existing list
		# else intialize item
		#restore selection
		
	def sortKeys(self):
		if self.album["Sort"] == "Caption":
			self.items.sort(cmpCaption)
		elif self.album["Sort"] == "Date":
			self.items.sort(cmpDate)
		elif self.album["Sort"] == "Rating":
			self.items.sort(cmpRating)
		self.layoutDirty = True
	
	def __fixOffsets(self, items, xtra, maxHeight, th):
		w = xtra/(len(items)+1)
		dw = w
		for item in items:
			dh = (maxHeight - item.r.height())/2
			item.r.moveBy(dw,dh)
			dw = w + dw
			
	def __ensureVisibleItem(self, item, vMax=None):
		#update scrollbar values to ensure that current item is visible
		self.scrollBar.blockSignals(True)
		vh = self.viewport.height()		
		ov = self.scrollBar.value()
		if vMax == None:
			vMax = self.scrollBar.maxValue()
		if vMax > 0:
			self.scrollBar.setMinValue(0)
			self.scrollBar.setMaxValue(vMax)
			self.scrollBar.setPageStep(vh)
			self.scrollBar.setLineStep(50)
			self.scrollBar.setEnabled(True)
			
			if item:
				r = item.r
				st = self.scrollBar.value()
				if r.bottom() > st + vh - 30:
					st = r.bottom() - vh + 30
				if r.top() < st + 10:
					st =  r.top() - 10
				self.scrollBar.setValue(st)
		else:
			self.scrollBar.setEnabled(False)
			self.scrollBar.setValue(0)
			self.scrollBar.setMaxValue(0)
			self.scrollBar.setPageStep(0)
		self.scrollBar.blockSignals(False)
		return ov != self.scrollBar.value()
			
	def __ensureVisible(self, vMax=None):
		return self.__ensureVisibleItem(self.currentItem, vMax)
		#update scrollbar values to ensure that current item is visible
##		self.scrollBar.blockSignals(True)
##		vh = self.viewport.height()		
##		ov = self.scrollBar.value()
##		if vMax == None:
##			vMax = self.scrollBar.maxValue()
##		if vMax > 0:
##			self.scrollBar.setMinValue(0)
##			self.scrollBar.setMaxValue(vMax)
##			self.scrollBar.setPageStep(vh)
##			self.scrollBar.setLineStep(50)
##			self.scrollBar.setEnabled(True)
##			
##			if self.currentItem:
##				r = self.currentItem.r
##				st = self.scrollBar.value()
##				if r.bottom() > st + vh - 30:
##					st = r.bottom() - vh + 30
##				if r.top() < st + 10:
##					st =  r.top() - 10
##				self.scrollBar.setValue(st)
##		else:
##			self.scrollBar.setEnabled(False)
##			self.scrollBar.setValue(0)
##			self.scrollBar.setMaxValue(0)
##			self.scrollBar.setPageStep(0)
##		self.scrollBar.blockSignals(False)
##		return ov != self.scrollBar.value()
		
	def __computeLayout(self):
		self.layoutDirty = False
		ts = self.thumbSize
		wRow = self.viewport.width()-10
		x = 10
		y = 10
		xSpace = 14
		yMult = 1
		if self.viewTitle: yMult = yMult + 1
		if self.viewRating: yMult = yMult + 1
		yFont = QFontMetrics(self.font()).height()
		ySpace= yMult*yFont
		hMax = 0
		row = []
		if self.items:
			for item in self.items:
				ar = item.ar #dict['AspectRatio']
				if ar >= 1.0:
					w = ts
					h = int(w / ar)
				else:
					h = ts
					w = int(h * ar)
				if x > wRow - w:
					# end of row cleanup
					if len(row):
						self.__fixOffsets(row, wRow-x+xSpace, hMax,yFont)
					y = y + hMax+ySpace
					x = 10
					hMax = 0
					row = []
					# end of row cleanup
				item.setImageRect(QRect(x,y,w,h))
				hMax = max(h, hMax)
				x = x + w + xSpace
				row.append(item)
		if len(row):#fix up the last row	
			self.__fixOffsets(row, (wRow-x+xSpace)/4, hMax, yFont)
		self.offscreenSize = y + hMax + ySpace
		vMax = self.offscreenSize - self.viewport.height()

		self.__ensureVisible(vMax)

	def viewportResize(self):
		self.layoutDirty = True
		
	def viewportPaint(self, surface):
		if self.layoutDirty:
			self.__computeLayout()
		i = 0;
		sr = surface.rect()
		painter = QPainter(surface)
		offset = self.scrollBar.value()
		painter.translate(0,-offset)
		fm = QFontMetrics(self.viewport.font())
		sr.moveTop(offset)
		if self.items:
			[i.paintItem(painter, fm, self.viewTitle, self.viewRating)
				for i in self.items 
				if i.r.intersects(sr) ]
		if self.insertRectHint:
			painter.setPen(QPen(QColor(0,0,0)))
			painter.drawRect(self.insertRectHint)
		elif self.selectRect:
			painter.setPen(QPen(QColor(0,0,0), 1, Qt.DotLine))
			painter.setPen
			painter.drawRect(self.selectRect)
			
			
		
	def slotUpdateAlbums(self, albumNames):
		for album in albumNames:
			if album == self.album['AlbumName']:
				self.__refreshThumbnails()
				
	def selectKey(self, key):
		for item in self.items:
			if item.key == key:
				self.selectSingleItem(item)
				break
				
	def __getPrevItem(self):
		if not self.items:
			return None
		if self.currentItem:
			i = self.items.index(self.currentItem)
		else:
			i = len(self.items)
		if i == 0:
			i = len(self.items)
		return self.items[i-1]

	def slotPrevItem(self):
		item = self.__getPrevItem()
		if item:
			self.selectSingleItem(item)
			
	def __getNextItem(self):
		if not self.items:
			return None
		if self.currentItem:
			i = self.items
			i = self.items.index(self.currentItem) + 1
		else:
			i = 0
			
		if i == len(self.items):
			i = 0
		return self.items[i]

	def slotNextItem(self):
		item = self.__getNextItem()
		if item:
			self.selectSingleItem(item)
		
	def slotNewAlbumFromSelection(self):
		keys = self.getCurrentSelection()
		self.lib.slotNewAlbumWithKeys(keys)
	
	def slotSetThumbScale(self, size):
		self.scale = size / 100.0
		self.thumbSize = size
		self.layoutDirty = True
		self.viewport.update()

	def slotScrolled(self, value):
		self.viewport.update()
		
	def currentKey(self):
		if self.currentItem:
			return self.currentItem.key
			
	def setCurrentItem(self, item):
		if item:
			key = item.key
		else:
			key = None
		self.emit(PYSIGNAL("currentChanged"),(key, None))
		self.currentItem = item
		
	def mapToViewport(self, p):
		return QPoint(p.x(), p.y() + self.scrollBar.value())

##	def getIndexFromPoint(self, p):
##		for i in xrange(len(self.items)):
##			if self.items[i].r.contains(p):
##				return i
##		return None
##			
##	def getItemFromPoint(self, p):
##		i = self.getIndexFromPoint(p)
##		if i != None:
##			return self.items[i]
##		else:
##			return None
			
	def getItemFromPoint(self, p):
		for i in self.items:
			if i.r.contains(p):
				return i
		return None
		
	def getItemsFromRect(self, r):
		return [i for i in self.items if i.r.intersect(r)]
			
	def __findInsertIndex(self, p):
		p = self.mapToViewport(p)
		for i in xrange(len(self.items)):
			if self.items[i].r.bottom() > p.y() and self.items[i].r.top() <= p.y():
				# found an item in row
				p.setY(self.items[i].r.center().y())
				# find first item in row
				start = 0
				for j in xrange(i, -1, -1):
					r = self.items[j].r
					if (r.bottom() < p.y() or r.top() >=p.y()):
						start = j+1
						break
				# find center to right of point in this row		
				for k in xrange(start, len(self.items)):
					r = self.items[k].r
					if not(r.bottom() > p.y() and r.top() <= p.y()) or r.center().x() > p.x():
						return k
				# if we get to the end with out finding an item, add to the end
				return len(self.items)
		return None
		
	def emitSelectionStats(self):
		self.emit(PYSIGNAL("selectionStats"), (len(self.items), len(self.itemsSel)))

	def selectItem(self, i, b): # change the selection state of a single item, no emit update in here
		if (i.isSelected() != b):
			i.selected(b)
			try:
				if b:
					self.itemsSel.append(i)
				else:
					self.itemsSel.remove(i)
			except ValueError:
				print "selectionError",b and "True" or "False"
				pass

	def selectNone(self):
		[ self.selectItem(i, False) for i in self.itemsSel[:] ]
		self.shiftSelItem = None
		self.emitSelectionStats()
		
	def selectAnItem(self, i, b): # modifies a single item with the selection
		self.selectItem(i, b)
		self.emitSelectionStats()		

	def selectSingleItem(self, item): # selects a single item, unselecting everything else
		[ self.selectItem(i, False) for i in self.itemsSel[:] ]
		self.setCurrentItem(item)
		self.shiftSelItem = self.currentItem
		self.selectAnItem(item, True)
		
	def selectRange(self, a, b):
		last = None
		for item in self.items:
			if last:
				self.selectItem(item, True)
			else:
				if item == a:
					self.selectItem(item, True)
					last = b
				elif item == b:
					self.selectItem(item, True)
					last = a
				else:
					self.selectItem(item, False)
			if item == last:
				last = None
		self.emitSelectionStats()
				
	def selectAll(self):
		[ self.selectItem(i, True) for i in self.items ]
		self.emitSelectionStats()

	def getSelCount(self):
		return (len(self.items), len(self.itemsSel))
		
	def getCurrentSelection(self):
		if self.itemsSel:
			return [i.key for i in self.itemsSel]
		else:
			return []
	
	def getWorkingSet(self):
		if self.itemsSel:
			return [i.key for i in self.itemsSel]
		else:
			return [i.key for i in self.items]

	def getSlideshowWorkingSet(self):
		if self.itemsSel and len(self.itemsSel) > 1:
			return [i.key for i in self.itemsSel]
		else:
			return [i.key for i in self.items]

	def mousePressEvent(self, me):
		# find item under mouse event
		p = self.mapToViewport(me.pos())
		item = self.getItemFromPoint(p)
		self.setCurrentItem(item)
		self.hoverStopFunc()
		if self.tooltip:
			self.tooltip.close()
			self.tooltip = None
		if item:
			if me.button() == Qt.LeftButton or me.button() == Qt.RightButton:
				if me.stateAfter() & Qt.ControlButton: # control click toggles selection
					self.selectAnItem(item, not(item.isSelected()))
					self.shiftSelItem = self.currentItem
				elif me.stateAfter() & Qt.ShiftButton:
					# select items between currentItem and shift start select
					if self.shiftSelItem == None:
						self.shiftSelItem = self.currentItem
					self.selectRange(self.currentItem, self.shiftSelItem)
				elif not(item.isSelected()):
					self.selectSingleItem(item)
					self.shiftSelItem = self.currentItem
		else: # if click on empty area, select none
			print "press"
			self.selectStart = p
			if me.stateAfter() & Qt.ShiftButton:
				pass
			elif me.stateAfter() & Qt.ControlButton:
				pass
			else:
				self.selectNone()
				
	def __endDragSelect(self):
		if self.selectRect:
			r = self.selectRect
			self.selectRect = None
			self.updateRect(r)
			self.origSelection = None	
				
	def mouseReleaseEvent(self, me):
		self.__endDragSelect()

	def contextMenuEvent(self, e):
		self.__endDragSelect()
		e.accept()
		e.consume()
		self.popup.exec_loop(e.globalPos())
		

	def mouseDoubleClickEvent(self, me):
		self.hoverStopFunc()
		if self.tooltip:
			self.tooltip.close()
			self.tooltip = None
		for item in self.items:
			if item.r.contains(QPoint(me.x(), me.y()+self.scrollBar.value())):
				self.emit(PYSIGNAL("doubleClicked"),(None, None))
				break
				
	def dragObject(self):
		keys = []
		if self.currentItem and not self.selectRect:
			keys.append(self.currentItem.key)
			# iterate through items to find selection set
			for item in self.items:
				if item.isSelected() and item != self.currentItem:
					keys.append(item.key)
			cur = QCursor.pos()
			drag = LPhotoKeysDrag(keys, self.albumPath, self.viewport)
			p = self.currentItem.buildDragPixmap()
			b = self.setBitmapMask(p)
			drag.setPixmap(p, QPoint(-12,-12))
			return drag
	
	def mouseMoveEvent(self, me):
		if me.state() & Qt.LeftButton or me.state() & Qt.RightButton:
			self.hoverStopFunc()
			do = self.dragObject()
			if do:
				do.drag()
			else:
				# nothing is selected, start selectionDrag
				self.selectionDrag(me.pos())
		elif me.pos() != self.hoverPt:
			self.hoverStopFunc()
			# else start popup timer
			self.hoverTimer.start(self.hoverTime)
		
	def hoverFunc(self):
		# check mouse position, if over picture, show fullsize thumb
		self.hoverStopFunc()
		if self.scale < 1.5:
			viewPoint = self.mapFromGlobal(QCursor.pos())
			self.hoverPt = QPoint(viewPoint)
			if self.rect().contains(viewPoint):
				hotItem =self.getItemFromPoint(self.mapToViewport(viewPoint))
				if hotItem and hotItem.thumbImage and hotItem.r:
					r = QRect(hotItem.r)
					r.moveBy(0,-self.scrollBar.value())
					self.tooltip = LPictTooltip(self, hotItem.thumbImage, r)
			
	def hoverStopFunc(self):
		self.hoverTimer.stop()
		self.hoverPt = QPoint()
		if self.tooltip:
			self.tooltip.close()
			self.tooltip = None
			
	def selectionDrag(self, pt):
		pt.setY(pt.y() + self.scrollBar.value())
		if self.selectRect:
			r = self.selectRect
			self.selectRect = QRect(self.selectStart, pt).normalize()
			ur = self.selectRect.unite(r)
			
			all = self.getItemsFromRect(ur)
			
			update = False
			
			for i in all: # break items up into newly selected and no longer selected
				if i.r.intersect(self.selectRect):
					if not i.r.intersect(r):
						self.selectItem(i, True)
						update = True;
				elif i not in self.origSelection:
					self.selectItem(i, False)
					update = True
			if update:
				self.emitSelectionStats()
				
			if not self.currentItem and len(self.itemsSel):
				self.setCurrentItem(self.itemsSel[-1])
						
		else: # special case of no selection Rect yet
			self.selectRect = QRect(self.selectStart, pt).normalize()
			self.origSelection = self.itemsSel[:]
			[ self.selectItem(i, True) for i in self.getItemsFromRect(self.selectRect) ]
			ur = self.selectRect
			self.emitSelectionStats()
			
		self.updateRect(ur)
			
	def setBitmapMask(self, p):
		bytes = p.width() / 8;
		if p.width() % 8:
			bytes = bytes + 1
		r1=""
		r2=""
		s=""
		for i in range(bytes):
			r1 = r1 + '\x55'
			r2 = r2 + '\xaa'
		r2 = r1 + r2

		for i in range(p.height()/2):
			s = s + r2
		if p.height() % 8:
			s = s + r1

		b = QBitmap(p.width(), p.height(), s)
		p.setMask(b)
		
	def slotUpdateAlbums(self, albumPaths):
		for path in albumPaths:
			if path == self.albumPath:
				self.__refreshThumbnails()
				self.viewport.update()
				return
				
	def setAlbumPath(self, path):
		wc = LWaitCursor()
		album = self.lib.getAlbum(path)
		if album:
			self.albumPath = path
			self.album = album
			self.currentItem = None
			self.__refreshThumbnails()
			self.viewport.update()
			self.selectNone()
			self.emit(PYSIGNAL("selectionStats"),(len(self.items), 0))
				
	def updateRect(self, r):
		ur = QRect(r)
		ur.addCoords(-5, -self.scrollBar.value()-5, 5, 40)
		self.viewport.update(ur)
		
	def slotDateSwap(self):
		for item in self.itemsSel:
			self.lib.dateSwap(item.key)
			
	def slotDuplicate(self):
		for item in self.itemsSel:
			self.lib.slotDuplicate(item.key, self.albumPath)
		
	def slotTrash(self):
		self.lib.trashKeyList(self.albumPath, self.getCurrentSelection())
		self.selectNone()
		
	def slotRevert(self):
		for item in self.itemsSel:
			self.lib.revertImage(item.key)

	def slotRotateSelection(self):
		for item in self.itemsSel:
			self.lib.rotateImage(item.key)
		
	def slotRotateCCSelection(self):
		for item in self.itemsSel:
			self.lib.rotateCCImage(item.key)

	def slotUpdateImage(self, key, hint):
		if hint & PhotoEvents.pixel:
			[i.refreshThumb() for i in self.items if i.key == key]
		if hint & PhotoEvents.size:
			self.layoutDirty = True
		self.viewport.update()
				
	def slotRefreshCaption(self, key):
		for item in self.items:
			if item.key == key:
				item.refreshThumb()
				if self.album['Sort'] == "Caption":
					self.sortKeys()
					self.viewport.update()
				else:
					self.updateRect(item.r)
				break
				
	def slotRefreshRating(self, key):
		for i in [i for i in self.items if i.key == key]:
			i.refreshThumb()
			if self.album['Sort'] == "Rating":
				self.sortKeys()
				self.viewport.update()
			else:
				r = QRect(i.r)
				r.setWidth(max(r.width(), 65)) # make sure rect covers 5 stars
				self.updateRect(r)
			break

	def slotAddPhotoToEnd(self, albumList, key):
		for album in albumList:
			if album == self.album['AlbumName']:
				dict = self.lib.getImage(key)
				item = LThumbnail(self, key, dict)
				self.items.append(item)
				self.layoutDirty = True
				self.viewport.update()
				self.emit(PYSIGNAL("selectionStats"), (len(self.items), len(self.itemsSel)))
	
	def slotViewTitle(self):
		self.viewTitle = not(self.viewTitle)
		self.layoutDirty = True
		self.viewport.update()
		self.emit(PYSIGNAL("updateUI"), (None, None))
		
	def slotViewRating(self):
		self.viewRating = not(self.viewRating)
		self.layoutDirty = True
		self.viewport.update()
		self.emit(PYSIGNAL("updateUI"), (None, None))
		
	def slotArrangeByTitle(self):
		self.album['Sort']="Caption"
		self.sortKeys()
		self.viewport.update()
		self.emit(PYSIGNAL("updateUI"), (None, None))
		
	def slotArrangeByDate(self):
		self.album['Sort']="Date"
		self.sortKeys()
		self.viewport.update()
		self.emit(PYSIGNAL("updateUI"), (None, None))
		
	def slotArrangeByRating(self):
		self.album['Sort']="Rating"
		self.sortKeys()
		self.viewport.update()
		self.emit(PYSIGNAL("updateUI"), (None, None))

	def slotArrangeManually(self):
		self.album['Sort']="Manual"
		self.__refreshThumbnails()  # need to reload the key list from the library
		self.viewport.update()
		self.emit(PYSIGNAL("updateUI"), (None, None))

	def __computeInsertRect(self, index):
		#compute the insert hint rect from the insertBefore Index
		if index == 0:
			r2 = self.items[index].r
			return QRect(r2.left()-8, r2.top()-5, 2, r2.height()+10)
		elif index == len(self.items):
			r2 = self.items[index-1].r
			return QRect(r2.right()+6, r2.top()-5, 2, r2.height()+10)
		#elif index > 0 and index < len (self.items):
		else:
			r1 = self.items[index-1].r
			r2 = self.items[index].r
			
			if r1.bottom() > r2.top():
				# rects in the same row
				return QRect(r1.right()+(r2.left()-r1.right())/2, r2.top()-5, 2, r2.height()+10)
			else:
				# rect is at start of row
				return QRect(r2.left()-8, r2.top()-5, 2, r2.height()+10)

	def dragEnterEvent(self, event):
		self.dragMoveEvent(event)
		
	def dragMoveEvent(self, event):
		if self.album['W'] and LPhotoKeysDrag.canDecode(event):
			i = self.__findInsertIndex(event.pos())
			if i != None:
				if i != self.insertBeforeIndex:
					self.insertBeforeIndex = i
					if self.insertRectHint:
						self.updateRect(self.insertRectHint)
					self.insertRectHint = self.__computeInsertRect(i)
					self.updateRect(self.insertRectHint)
				event.accept()
				return
		elif QUriDrag.canDecode(event) and self.albumPath:
			event.accept()
			return

		event.ignore()
		if self.insertRectHint:
			self.updateRect(self.insertRectHint)
			self.insertRectHint = None
		self.insertBeforeIndex = None
		
	def dragLeaveEvent(self, event):
		# erase selection
		if self.insertRectHint:
			self.updateRect(self.insertRectHint)
			self.insertRectHint = None
		self.insertBeforeIndex = None
		
	def dropEvent(self, event):
		if self.insertRectHint:
			self.updateRect(self.insertRectHint)
			self.insertRectHint = None
		self.insertBeforeIndex = None
		if self.album['W'] and LPhotoKeysDrag.canDecode(event):
			i = self.__findInsertIndex(event.pos())
			if i != None and (i == len(self.items) or not(self.items[i].isSelected())):
				keys = LPhotoKeysDrag.getKeys(event)
				if i < len(self.items):
					key = self.items[i].key
				else:
					key = None
				oldkeys = [item.key for item in self.items]
				if self.album['Sort']!="Manual":
					self.album['Sort']="Manual"
					self.lib.reorderAlbumKeys(self.albumPath, None, oldkeys)
					self.emit(PYSIGNAL("updateUI"), (None, None))
				self.lib.reorderAlbumKeys(self.albumPath, key, keys)
				self.__refreshThumbnails()  # need to reload the key list from the library
				self.viewport.update()
		elif QUriDrag.canDecode(event) and self.albumPath:
			files = QStringList()
			QUriDrag.decodeLocalFiles(event, files)
			source = LDragImport(files, self.albumPath)
			self.emit(PYSIGNAL("dragImport"), (source, None))
				
	def getAlbum(self):
		if self.album:
			return self.album
	
	def wheelEvent(self, we):
		self.hoverStopFunc()
		if (we.delta() < 0):
			self.scrollBar.addLine()
		elif (we.delta() > 0):
			self.scrollBar.subtractLine()
			
	def slotMoveAlbum(self, dstPath, srcPath):
		if self.albumPath == srcPath:
			self.albumPath = dstPath

	def keyPressEvent(self, e):
		self.hoverStopFunc()
		if e.state() == Qt.NoButton:
			if e.key() == Qt.Key_Right:
				self.slotNextItem()
				if self.__ensureVisible():
					self.viewport.update()
			elif e.key() == Qt.Key_Left:
				self.slotPrevItem()
				if self.__ensureVisible():
					self.viewport.update()
			elif e.key() == Qt.Key_Up:
				pass
			elif e.key() == Qt.Key_Down:
				pass
			elif e.key() == Qt.Key_Home:
				self.scrollBar.setValue(self.scrollBar.minValue())
			elif e.key() == Qt.Key_End:
				self.scrollBar.setValue(self.scrollBar.maxValue())
			elif e.key() == Qt.Key_PageUp:
				self.scrollBar.subtractPage()
			elif e.key() == Qt.Key_PageDown:
				self.scrollBar.addPage()
			elif e.key() == Qt.Key_Return or e.key() == Qt.Key_Enter:
				self.emit(PYSIGNAL("doubleClicked"),(None, None))
			elif e.key() == Qt.Key_Delete:
				self.slotTrash()
			
		elif e.state() == Qt.ControlButton:
			if e.key() == Qt.Key_Up:
				self.scrollBar.subtractLine()
			elif e.key() == Qt.Key_Down:
				self.scrollBar.addLine()
			if e.key() == Qt.Key_Left:
				self.scrollBar.subtractLine()
			elif e.key() == Qt.Key_Right:
				self.scrollBar.addLine()
				
		elif e.state() == Qt.ShiftButton:
			if e.key() == Qt.Key_Left:
				item = self.__getPrevItem()
				if item:
					self.setCurrentItem(item)
					self.selectRange(self.currentItem, self.shiftSelItem)
				if self.__ensureVisible():
					self.viewport.update()
			elif e.key() == Qt.Key_Right:
				item = self.__getNextItem()
				if item:
					self.setCurrentItem(item)
					self.selectRange(self.currentItem, self.shiftSelItem)
				if self.__ensureVisible():
					self.viewport.update()
			


class LPictTooltip(QWidget):
	def __init__(self, parent, image, rect):
		QWidget.__init__(self, parent,None, Qt.WDestructiveClose|Qt.WRepaintNoErase|Qt.WResizeNoErase)
		self.image = image
		r = LUtils.centerRect(image.rect(),rect.center(),parent.rect())
##~ 		r.moveCenter(rect.center())
		self.setGeometry(r)
		self.show()
		self.hotRect = QRect(self.mapFromParent(rect.topLeft()), self.mapFromParent(rect.bottomRight()))
		self.pt = None
		self.setMouseTracking(True)
		
	def mouseMoveEvent(self, me):
		self.parent().hoverStopFunc()
			
	def paintEvent(self, paintEvent):
		painter = QPainter(self)
		painter.drawImage(0, 0, self.image)
		painter.setPen(QPen(QColor(84,84,84)))
		painter.drawRect(self.rect())
		
	def keyPressEvent(self, e):
		self.parent().hoverStopFunc()
