/****************************************************************************/
/* Provides functionality to test the complete LogCentral system            */
/*                                                                          */
/*  Author(s):                                                              */
/*    - Georg Hoesch (hoesch@in.tum.de)                                     */
/*    - Cyrille Pontvieux (cyrille.pontvieux@edu.univ-fcomte.fr)            */
/*                                                                          */
/*  This file is part of DIET .                                             */
/*                                                                          */
/*  Copyright (C) 2000-2003 ENS Lyon, LIFC, INSA, INRIA and SysFera (2000)  */
/*                                                                          */
/*  - Frederic.Desprez@ens-lyon.fr (Project Manager)                        */
/*  - Eddy.Caron@ens-lyon.fr (Technical Manager)                            */
/*  - Tech@sysfera.com (Maintainer and Technical Support)                   */
/*                                                                          */
/*  This software is a computer program whose purpose is to provide an      */
/*  distributed logging services.                                           */
/*                                                                          */
/*                                                                          */
/*  This software is governed by the CeCILL license under French law and    */
/*  abiding by the rules of distribution of free software.  You can  use,   */
/*  modify and/ or redistribute the software under the terms of the CeCILL  */
/*  license as circulated by CEA, CNRS and INRIA at the following URL       */
/*  "http://www.cecill.info".                                               */
/*                                                                          */
/*  As a counterpart to the access to the source code and  rights to copy,  */
/*  modify and redistribute granted by the license, users are provided      */
/*  only with a limited warranty  and the software's author,  the holder    */
/*  of the economic rights,  and the successive licensors  have only        */
/*  limited liability.                                                      */
/*                                                                          */
/*  In this respect, the user's attention is drawn to the risks             */
/*  associated with loading,  using,  modifying and/or developing or        */
/*  reproducing the software by the user in light of its specific status    */
/*  of free software, that may mean  that it is complicated to              */
/*  manipulate, and  that  also therefore means  that it is reserved for    */
/*  developers and experienced professionals having in-depth computer       */
/*  knowledge. Users are therefore encouraged to load and test the          */
/*  software's suitability as regards their requirements in conditions      */
/*  enabling the security of their systems and/or data to be ensured and,   */
/*  more generally, to use and operate it in the same conditions as         */
/*  regards security.                                                       */
/*                                                                          */
/*  The fact that you are presently reading this means that you have had    */
/*  knowledge of the CeCILL license and that you accept its terms.          */
/*                                                                          */
/****************************************************************************/
/* $Id$
 * $Log$
 * Revision 1.2  2008/07/17 01:03:12  rbolze
 * make some change to avoid gcc warning
 *
 * Revision 1.1  2004/01/09 11:07:12  ghoesch
 * Restructured the whole LogService source tree.
 * Added autotools make process. Cleaned up code.
 * Removed some testers. Ready to release.
 *
 ****************************************************************************/

#ifndef _PASSIVETOOL_HH_
#define _PASSIVETOOL_HH_

#include "ToolMsgReceiver_impl.hh"
#include "LogTypes.hh"
#include "LogTool.hh"

/**
 * Encapsulates all tool operations. Each operation has an expected
 * result. Any other result will be treated as error. A message will
 * be printed and the function will set the provided bool to false.
 * Results of methods that will be called by the Monitor are stored and
 * can be verified with the same mechanism from the main programm.
 */
class PassiveTool {
public:
  PassiveTool();
  ~PassiveTool();

  void
  activate(PortableServer::POA_var poa, LogCentralTool_var aLCTref);

  void
  checkConnect(const char* toolName, int retValExpected, bool* success);

  void
  checkDisconnect(bool* success);

  void
  checkDisconnect(const char* toolName, int retValExpected, bool* success);

  void
  checkAddFilter(filter_t filter, bool* success);

  void
  checkAddFilter(const char* toolName, filter_t filter, int retValExpected,
                 bool* success);

  void
  checkRemoveFilter(const char* filterName, bool* success);

  void
  checkRemoveFilter(const char* toolName,const char* filterName, int retValExpected,
                    bool* success);

  void
  checkFlushAllFilters(bool* success);

  void
  checkFlushAllFilters(const char* toolName, int retValExpected, bool* success);

  void
  setExpectedMsgBuf(log_msg_buf_t expectedMsgBuf);

  void
  addExpectedMsg(const char* componentName,const char* msg,const char* tag);

  void
  addExpectedMsg(log_msg_t msg);

  void
  checkMsgBuf(bool* success);

private:
  CORBA::String_var toolName;
  ToolMsgReceiver_impl* myTMR;
  PortableServer::ObjectId_var myTMRid;
  ToolMsgReceiver_var aTMRref;

  LogCentralTool_var aLCTref;

  log_msg_buf_t expectedMsgBuf;
  log_msg_buf_t receivedMsgBuf;
};

#endif
