/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of Intel Corp. nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

#ifndef __LME_CONNECTION_H__
#define __LME_CONNECTION_H__

#ifdef _LINUX
#include "HECILinux.h"
#else
#include "HECIWin.h"
#endif

#include <map>
#include "Thread.h"
#include "Semaphore.h"
#include "Event.h"


using namespace std;

typedef void (*HECICallback) (void *, unsigned char *buffer, int len, int *status);

class LMEConnection {
public:
	LMEConnection(bool verbose = false);
	~LMEConnection();

	bool Init(HECICallback cb, void *param);
	bool IsInitialized();
	bool OpenConnection(struct sockaddr_in addr, unsigned short mePort, int *connID, bool remote = false);
	void CloseConnection(int connID, int status);
	int SendMessage(int connID, unsigned char *buffer, int len);
//	int ReceiveMessage(unsigned char *buffer, int len);
	void RequestIPFQDN();
#ifdef _REMOTE_SUPPORT
	void RequestEntDNSSuffixList();
	void SendEnterpriseAccessStatus(bool access, unsigned long localIp);
#endif
	void Deinit();
	HECI& GetHECI();

	enum INIT_STATES {
		INIT_STATE_DISCONNECTED = 0,
		INIT_STATE_CONNECTING,
		INIT_STATE_CONNECTED,
		INIT_STATE_DISCONNECTING,
	};

private:
	static const GUID _guid;

	static void _rxThreadFunc(void *param);

	void _doRX();
	int _receiveMessage(unsigned char *buffer, int len);
	int _sendMessage(unsigned char *buffer, int len);

	struct Connection {
		Event *event;
		int connID;
		UINT8 status;
	};

	//typedef list<Connection> ConnList;
	typedef map<int, Connection> ConnMap;
	INIT_STATES _initState;
	unsigned char _reqID;
	ConnMap _pendingConnections;
	Thread *_rxThread;
	HECICallback _cb;
	void *_cbParam;
	Semaphore _mapLock;
	Semaphore _initLock;
	//Semaphore _sendMessageLock;
#ifdef _LINUX
	HECILinux _internalHECI;
#else
	HECIWin _internalHECI;
#endif
	HECI* _heci;
};

#endif
