let version = "1.0.0-beta3"
let svn_snapshot = false
let conf = Dtools.Conf.void "Liquidsoap configuration"
let var_script = ref "default"
let substs = ref
    [
      "<script>", (fun () -> !var_script);
      "<pid>", (fun () -> string_of_int (Unix.getpid ()));
      "<home>", (fun () -> try Sys.getenv "HOME" with Not_found -> "<home>");
    ]
let add_subst r s = substs := (r, fun () -> s) :: !substs
let subst_vars s =
  List.fold_left
    (fun v (r, s) -> Str.global_replace (Str.regexp r) (s ()) v)
     s !substs
let env_has key = try ignore (Sys.getenv key) ; true with Not_found -> false
let big_endian = false
let findlib_path = ["/usr/local/lib/ocaml/3.12.0";"/usr/lib/ocaml";"/usr/lib/ocaml/METAS"]
let dynlink = true
let load_dynlinks = Dyntools.load_dynlinks
let load_plugins_dir = Dyntools.load_plugins_dir
let magic_cookie = Magic.create ~flags:[Magic.Mime; Magic.Symlink] []
let file_mime = Some (Magic.file magic_cookie)
let data_mime = Some (Magic.buffer magic_cookie)
module C = CamomileLibrary.Default.Camomile.CharEncoding

exception Unknown_encoding of string

let enc_of_name s =
  try C.of_name s with
    | Not_found -> raise (Unknown_encoding s)

let conf_tag =
  Dtools.Conf.void ~p:(conf#plug "tag") "Settings related to metadata tags"
let conf_encoding =
  (* The ["foo";"bla"] may be stripped by configure here.. We avoided it by chance because
   * the configure script takes conf_tag#plug as the begining of a comment.
   * Don't forget this when modifying this inclusion later... *)
  Dtools.Conf.list ~p:(conf_tag#plug "encodings") ~d:["UTF-8";"ISO-8859-1"]
    "List of encodings to try for automatic encoding detection"

let custom_encoding = ref None

let get_encoding () =
  match !custom_encoding with
    | Some e -> e
    | None ->
        let encs = conf_encoding#get in
        let e = C.automatic "LIQ-TAGS" (List.map enc_of_name encs) C.utf8 in
          custom_encoding := Some e ;
          e

let camolog = Dtools.Log.make ["camomile"]

exception Input_encoding of string
exception Output_encoding of string

let recode_tag ?in_enc ?out_enc s =
  try
    let in_enc =
      try
       match in_enc with
         | Some e -> enc_of_name e
         | None -> get_encoding ()
      with Unknown_encoding s ->
             raise (Input_encoding s)
    in
    let out_enc =
      try
       match out_enc with
         | Some e -> enc_of_name e
         | None -> C.utf8
      with Unknown_encoding s ->
             raise (Output_encoding s)
    in
      try C.recode_string ~in_enc ~out_enc s with e ->
        let in_enc =
          if in_enc == get_encoding () then
            Printf.sprintf "auto(%s)" (String.concat "," conf_encoding#get)
          else
            C.name_of in_enc
        in
        camolog#f 3 "Failed to convert %S from %s to %s (%s)!"
          s in_enc (C.name_of out_enc) (Utils.error_message e) ;
        s
  with
    | Unknown_encoding e ->
          camolog#f 3 "Failed to convert %S: unknown encoding %s"
              s e ; s
    | Input_encoding e ->
          camolog#f 3 "Failed to convert %S: unknown input encoding %s"
              s e ; s
    | Output_encoding e ->
          camolog#f 3 "Failed to convert %S: unknown output encoding %s"
              s e ; s
    | e ->
          camolog#f 3 "Failed to convert %S: unknown error %s"
              s (Utils.error_message e) ; s

let recode_tag =
  if env_has "LIQ_DISABLE_CAMOMILE" then
    fun ?in_enc ?out_enc s -> s
  else
    recode_tag
let requests_max_id = 50
let requests_table_size = 50
let libs_versions = " graphics=[distributed with Ocaml] pcre=6.2.2 dtools=0.2.2 duppy=0.4.1 duppy.syntax=0.4.1 cry=0.2.1 mm=0.1.0 xmlplaylist=0.1.3 lastfm=0.3.0 ogg=0.4.2 vorbis=0.6.0 speex=0.2.0 mad=0.4.2 flac=0.1.0 flac.ogg=0.1.0 dynlink=[distributed with Ocaml] lame=0.3.0 voaacenc=0.1.0 theora=0.3.0 schroedinger=0.1.0 gavl=0.1.4 bjack=0.1.3 alsa=0.2.1 ao=0.2.0 samplerate=0.1.1 taglib=0.1.4 magic=0.7.3 camomile=0.7.1 faad=0.3.0 soundtouch=0.1.6 portaudio=0.2.0 pulseaudio=0.1.1 ladspa=0.1.3 dssi=0.1.0 sdl=0.8.0 camlimages=4.0.0 lo=0.1.0 json-wheel=1.0.6"
let tts_program = "/usr/local/lib/liquidsoap/1.0.0-beta3/liquidtts"
let rundir = "/usr/local/var/run/liquidsoap"
let logdir = "/usr/local/var/log/liquidsoap"
let libs_dir = "/usr/local/lib/liquidsoap/1.0.0-beta3"
let plugins_dir = "/usr/local/lib/liquidsoap/1.0.0-beta3/plugins"
let () = add_subst "<sysrundir>" "/usr/local/var/run/liquidsoap"
let () = add_subst "<syslogdir>" "/usr/local/var/log/liquidsoap"
let display_types = ref false
(* Enable backtrace printing if possible, does nothing on ocaml<3.11 *)
let record_backtrace _ = ()
open Printexc
let () = record_backtrace true
