/***************************************************************************
                          Macros.cpp  -  description
                             -------------------
    begin                : Sam Mai 10 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "macros.h"
#include "parameter.h"
#include "ctxbuffer.h"
#include <qdatetime.h>
#include <qmessagebox.h>
#include "constants.h"
#include <qfile.h>
extern Parameter settings;

Macros::Macros()
{
  
Words.reserve(9);
Words.push_back(QString("@CALLSIGN@"));
Words.push_back(QString("@DATE@"));  
Words.push_back(QString("@Replace by filename@"));
Words.push_back(QString("@RX@"));
Words.push_back(QString("@THEIRCALL@"));
Words.push_back(QString("@THEIRNAME@"));
Words.push_back(QString("@TIMELOCAL@"));
Words.push_back(QString("@TIMEUTC@"));
Words.push_back(QString("@TX@"));
NumberofMacros=0;
}
Macros::~Macros(){
}
void Macros::insert(QString Name,QString Definition, QString Acc, int position)
{
if ( (unsigned int) position <= MacroNames.size() )
  { 
    MacroNames.insert(MacroNames.begin()+position-1,Name);
    MacroText.insert(MacroText.begin()+position-1,Definition);
    Accelerator.insert(Accelerator.begin()+position-1,Acc);
  }
else
  {
    MacroNames.push_back(Name);
    MacroText.push_back(Definition);
    Accelerator.push_back(Acc);
  }
NumberofMacros++;    
}
void Macros::executeMacro(int MacroNumber,CTxBuffer *TxBuffer)
{
QString Macro=MacroText[MacroNumber];
QString Token;

int anzahl=Macro.contains('@',true)/2;
if (anzahl > 0 )
 {
 int indexbis,indexvon=0;
 for (int i=0; i < anzahl; i++)
   {
     indexbis = Macro.find('@',indexvon,true);
     indexvon=indexbis;
     indexbis = Macro.find('@',indexvon+1,true);
     Token = Macro.mid(indexvon,indexbis-indexvon+1);
     if ( Token == Words[0] )         // callsign
      {
        Macro.replace(indexvon,Words[0].length(),settings.callsign);
      
       }
     else  
     if ( Token == Words[1] )         // Date
      { QDate t=QDate::currentDate();
        Macro.replace(indexvon,Words[1].length(),t.toString(QString("d.MM.yyyy")));
        
       }
     else         
     if ( Token == Words[3] )         // RX
      {
        Macro.remove(indexvon,4);
      if (settings.Status == ON )
        {
         TxBuffer->insert(Macro,indexvon);
         emit StartRx();
        }
      return;
       }
     else 
     if ( Token == Words[4] )        // Remote callsign
      {
        Macro.replace(indexvon,Words[4].length(),settings.QslData->RemoteCallsign);
 
       }
     else  
     if ( Token == Words[5] )        // Remote op's name
      {
//        Macro.replace(indexvon,Words[5].length(),settings.QsoData->TheirName);
       
       }
     else  
     if ( Token == Words[6] )        // Time Local
      {
        QDateTime t;
        t=QDateTime::currentDateTime();

        Macro.replace(indexvon,Words[6].length(),t.toString("h:mm"));
      
       }
     else  
     if ( Token == Words[7] )        // Time UTC
      {
        QDateTime t;
        t=QDateTime::currentDateTime();
        t=t.addSecs(settings.timeoffset*3600);
        
        Macro.replace(indexvon,Words[7].length(),t.toString("h:mm"));
       
       }
     else  
     if ( Token == Words[8] )        // TX
      {
       if (settings.Status == UNDEF )
        {
    QMessageBox::warning(0,"Warning","Please listen before transmitting",
      QMessageBox::Ok,NoButton,NoButton);

         return;
        }
        Macro.remove(indexvon,4);
        if (settings.Status == OFF)
          emit StartTx();
       
      }
      else                                // Must be File
       {
        Macro.remove(indexvon,Token.length());
        if (indexvon > 0 )
          {
            TxBuffer->insert(Macro,indexvon);
            Macro.remove(0,indexvon);
            indexvon=0;
           } 
        Token=Token.mid(1,Token.length()-2); 
        QFile MacroFile(Token);
        if ( MacroFile.open(IO_ReadOnly) )
         {
          QTextStream line(&MacroFile);
          while ( !line.eof() )
            {
             QString Txstring = line.readLine()+"\n";
             TxBuffer->insert(Txstring,Txstring.length()); 
            }
           MacroFile.close();   
         }
        else
        QMessageBox::warning(0,"Warning","File " + Token +" not found ",
          QMessageBox::Ok,NoButton,NoButton);
            
       }                                
    }
    
        
 } 
TxBuffer->insert(Macro,Macro.length());

}

void Macros::deleteMacro(int number)
{
if (number < 0 || number >= NumberofMacros )
 return;

MacroNames.erase(MacroNames.begin()+number);
MacroText.erase(MacroText.begin()+number);
Accelerator.erase(Accelerator.begin()+number);

if (NumberofMacros > 0)
 NumberofMacros--;
}

QString Macros::getMacroName(int number)
{
if (number < 0 || number >= NumberofMacros )
 return QString("");
return MacroNames[number];  
}
int Macros::count()
{
return NumberofMacros;
}
QString Macros::getDefinition(int number)
{
if (number < 0 || number >= NumberofMacros )
 return QString("");
return MacroText[number];  
}
QString Macros::getAccelerator(int number)
{
 if (number < 0 || number >= NumberofMacros )
 return QString("");
return Accelerator[number];  
}
int Macros::Keywordcount()
{
return Words.size();
}
QString Macros::getKeyword(int number)
{
 if (number < 0 || number >= NumberofMacros )
 return QString("");
return Words[number];  
}
void Macros::setDefinition(QString s,int position)
{
MacroText.at(position)=s;
}
void Macros::setAccelerator(QString s,int position)
{
Accelerator.at(position)=s;
}
void Macros::setMacroName(QString s,int MacroNumber)
{
MacroNames.at(MacroNumber)=s;
}
