/***************************************************************************
                          fskdemodulator.h  -  description
                             -------------------
    begin                : Fre Jan 31 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatley, AE4JY            *              
 ***************************************************************************/

#ifndef FSKDEMODULATOR_H
#define FSKDEMODULATOR_H

#include <cdemodulator.h>
#include <complex>

using namespace std;
#include "constants.h"

/**Base Class for FSK Demodulation like RTTY and MFSK
  *@author Volker Schroer
  */

class FSKDemodulator : public CDemodulator  {
public: 
	FSKDemodulator(int NxFrequencies);
	~FSKDemodulator();
bool Init(double,int);
protected:
int NumberofTones;

float Baudrate;
unsigned int SymbolLength;
void mixer(double *);
int lpDownSample();
void setFilter(double,int,int);
double *mixerfreqinc;
double SampleRate;
complex<double> *FilterOutput[16];
//complex<double> FilterOutput[16][200];

private: 	//Private Variables
double *mixerfreq;
complex<double> *mixedfreqs[16];
complex<double> *FilterBuffer[16];
//complex<double> FilterBuffer[16][705];
complex<double> *SaveFilterBufferPtr[16];
//complex<double> *FilterBufferPtr;
double *lpcoefs;
//Downsampling Rate;
int DownRate,RestSamples;
int FilterLength;
};

#endif
