#include "srv_def.h"
#if HAVE_LIBPAM
#include <security/pam_appl.h>
#include <string.h>
#include <stdlib.h>
#include "global_vars.h"

static struct pam_conv pamconv;
// password of the user currently beeing authenticated.
static const char *pamauth_passwd;

static int pam_callback(int num_msg, const struct pam_message **msg, struct pam_response **resp, void *appdata_ptr)
{
    int i;
    struct pam_response *rsp = NULL;
    
    if ( !(rsp = malloc(sizeof(struct pam_response)*num_msg)) )
    {
	*resp = NULL;
	return(PAM_CONV_ERR);
    }
    for (i=0;i<num_msg; i++)
    {
	switch(	msg[i]->msg_style )
	{
	    case PAM_PROMPT_ECHO_OFF:
		rsp[i].resp = strdup(pamauth_passwd);
		break;
	    case PAM_PROMPT_ECHO_ON:
	    case PAM_TEXT_INFO:
		rsp[i].resp = strdup("!!");
		break;
	    default:
	    	;
	}
	rsp[i].resp_retcode = PAM_SUCCESS;
    }
    *resp = rsp;
    return(PAM_SUCCESS);
}

int vrfy_user(const char *name, const char *pass)
{
    pam_handle_t *pamh=NULL;
    int ret, success = -1;

    pamconv.conv = &pam_callback;
    pamauth_passwd = pass;
    
    if ( (ret = pam_start(LCS_PAM_SERVICE, name, &pamconv, &pamh)) != PAM_SUCCESS )
    {
	syslog(LOG_ERR, "pam_start(...) failed! Unable to authenticate %s", name);
	return(-2);
    }
    if ( ret == PAM_SUCCESS ) ret = pam_authenticate(pamh, 0);
    if ( ret == PAM_SUCCESS ) ret = pam_acct_mgmt(pamh, 0);
    if ( ret == PAM_SUCCESS ) success = 0; // OK, authentication successful
    pam_end(pamh, ret);
    return ( success );
}

#ifdef SHUTDOWN_OK
int shutdown_allowed(struct client_t*who)
{
    pam_handle_t *pamh=NULL;
    int ret, success = -1;
    pamconv.conv = &pam_callback;

    if ( !who ) return(-1);
    
    pamauth_passwd = who->passwd;
    if ( (ret = pam_start(LCS_PAM_SHUTDOWN_SERVICE, who->name, &pamconv, &pamh)) != PAM_SUCCESS )
    {
	syslog(LOG_ERR, "pam_start(...) failed! Unable to check %s to allow shutdown", who->name);
	return(-2);
    }
    if ( ret == PAM_SUCCESS ) ret = pam_authenticate(pamh, 0);
    if ( ret == PAM_SUCCESS ) ret = pam_acct_mgmt(pamh, 0);
    if ( ret == PAM_SUCCESS ) success = 0; // OK, authentication successful
    else syslog(LOG_INFO, "Shutdown authentication for %s failed.", who->name);
    pam_end(pamh, ret);
    return ( success );
}
#endif //SHUTDOWN_OK

#endif // HAVE_LIBPAM
