#ifndef _LCS_LISTS
#define _LCS_LISTS

struct list_hdr_t {
    void *prev;
    void *next;
    int id; // in LineControl Server this is the clients IP in net-byte-order	    
};

struct list_anchor_t {
    struct list_hdr_t *first;
    struct list_hdr_t *last;
    int count;
};

void list_init(struct list_anchor_t *list);
struct list_hdr_t *ll_list_add(struct list_anchor_t *list, int size);
void  list_del(struct list_anchor_t *list, struct list_hdr_t *item);
void  list_flush(struct list_anchor_t *list);
int   list_count(struct list_anchor_t *list);
struct list_hdr_t *list_find(struct list_anchor_t *list, int hash);
int   list_del_id(struct list_anchor_t *list, int id);
void *list_secure(struct list_anchor_t *list, struct list_hdr_t *item);

#endif  /* _LCS_LISTS */
