#include <sys/types.h>
#include <unistd.h>
#include <syslog.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "global_vars.h"

// SIGCHLD should be catched or set to SIG_IGN to avoid zombies.

int exec_dont_care(char *filen)
// won't care about the termination of the fork()ed prozess.
{
    pid_t pid;
    if ( (pid = fork()) == -1 )
    {
		return(-1); // failed to fork()
    }
    if ( pid ) return(0); // the linecontrol server process returns
	segf_indicator = 1501;
    // restore signal handlers
    signal(SIGTERM, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGSEGV, SIG_DFL);
    // fork again
    if ( (pid = fork()) == -1 )
    {
		exit(-1); // failed to fork()
    }
    // parent terminates
    if ( pid ) exit(0);
	segf_indicator = 1502;
    // child becomes process group leader
    setsid(); // child: become own process group leader
//    if ( !pid ) // child loads filen
    {
		char *idx;
		segf_indicator = 1503;
		idx = filen + strlen(filen);
		segf_indicator = 1504;
		while ( (*idx != '/') && (idx > filen) ) idx--;
		segf_indicator = 1505;
		if ( *idx == '/' ) idx++;
		segf_indicator = 1506;
		execlp(filen, idx, NULL, NULL);
		// returns only on error
		segf_indicator = 1507;
		syslog(LOG_ERR, "unable to execlp %s", filen);
		exit(-1); // don't return to caller... it will be the wrong prozess.
    }
}

int exec_dont_care_param(char *filen, char *param)
// won't care about the termination of the fork()ed prozess.
// how the hell can I do the same as execlp does with
// its NULL terminated arguments???
{
    pid_t pid;
    
    if ( (pid = fork()) == -1 )
    {
	return(-1); // failed to fork()
    }
    if ( pid ) return(0); // the linecontrol server process returns
	segf_indicator = 1508;
    // restore signal handlers
    signal(SIGTERM, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGSEGV, SIG_DFL);
    // fork again
    if ( (pid = fork()) == -1 )
    {
		exit(-1); // failed to fork()
    }
    // parent terminates
    if ( pid ) exit(0);
    // child becomes process group leader
	segf_indicator = 1509;
    setsid(); // child: become own process group leader
    {
		char *idx;
		segf_indicator = 1510;
		idx = filen + strlen(filen);
		while ( (*idx != '/') && (idx > filen) ) idx--;
		segf_indicator = 1511;
		if ( *idx == '/' ) idx++;
		segf_indicator = 1512;
		execlp(filen, idx, param, NULL);
		// returns only on error
		segf_indicator = 1513;
		syslog(LOG_ERR, "unable to execlp %s", filen);
		exit(-1); // don't return to caller... it will be the wrong prozess.
    }
    return(0);
}

int parse_cmdline(char *cmdline, int *argc, char *argv[])
// cmdline is like "/sbin/ifup ppp0" or like "/sbin/ppp-up"
// parse_cmdline stores the number of command line arguments in argc
// and each argument in argv[]. argv[0] is the command to be executed,
// argv[1]..argv[argc-1] are the parameters.
// argv[argc] is set to NULL
// parse_cmdline allocates memory for the strings in argv[] using malloc[]
// this memory should be freed by the caller
// Returns argc.
// FIXME: possible overflow if there are more arguments than
// allocated in the provided argv[]
// FIXME: no environment variables are taken into account
// FIXME: also no checking for quotations
{
    char *idx = cmdline;

    *argc = 0;

segf_indicator = 1401;
    while (*idx) {
        char *prev = idx;
        int len = 0;
        while ( (*idx != ' ') && *idx ) { idx++; len++; }
        argv[*argc] = malloc(len+1);
        strncpy(argv[*argc], prev, len);
        argv[*argc][len] = 0;
        (*argc)++;
        if (*idx) idx++;
    }
    argv[*argc] = NULL;
segf_indicator = 1402;

    return *argc;
}

int exec_dont_care_cmdline(char *cmdline) 
{
    pid_t pid;
    int argc;
    char *argv[20];

	segf_indicator = 1600;
    parse_cmdline(cmdline, &argc, argv);
	segf_indicator = 1601;

    if ( (pid = fork()) == -1 )
    {
        return(-1); // failed to fork()
    }
    if ( pid ) {
        int i;
		segf_indicator = 1602;
        for (i=0; i<argc; i++) free(argv[i]); // first free arguments for server
		segf_indicator = 1603;
        return(0); // the linecontrol server process returns
    }
    // restore signal handlers
    signal(SIGTERM, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGSEGV, SIG_DFL);
    // fork again
    if ( (pid = fork()) == -1 )
    {
        exit(-1); // failed to fork()
    }
    // parent terminates
    if ( pid ) exit(0);
    // child becomes process group leader
    setsid(); // child: become own process group leader
    {
		segf_indicator = 1604;
        execvp(argv[0], argv);
		segf_indicator = 1605;
        // returns only on error
        syslog(LOG_ERR, "unable to execvp %s", argv[0]);
		segf_indicator = 1606;
        exit(-1); // don't return to caller... it will be the wrong prozess.
    }
    return(0); // parent returns to caller
}

