CDECK  ID>, QCDCOM.
 
CDECK  ID>, QCDCOM.
 
C------------------------QCDNUM COMMON BLOCKS---------------------
 
CDECK  ID>, QCDNUM.

CDECK  ID>, QNINIT.

C     =================
      SUBROUTINE QNINIT
C     =================

C---  QNINIT: initialisation.
C---  Called by user.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*8 CHVERS,CHDATE
      COMMON/QCVERS/ CHVERS,CHDATE
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

      CHARACTER*7 TSNAM
      COMMON/QCTRCE/ TSNAM(0:19)
      COMMON/QCTRCI/ NTCAL(0:19),ITADR
c
c common added by MRW 18/3/05 to make silent mode for LHAPDF
c
      common/lhasilent/lhasilent
c 
 
      CHVERS = '16.12   '
      CHDATE = '12-08-98'
 
      LDOUBL = .TRUE.
      if(lhasilent.eq.0) then
      WRITE(6,'(/////)')
      WRITE(6,
     &'(8X,''+-----------------------------------------------+'')')
      WRITE(6,
     &'(8X,''|                                               |'')')
c      LDOUBL = .TRUE.
      WRITE(6,
     &'(8X,''| You are using the double precision version of |'')')
      WRITE(6,
     &'(8X,''|                                               |'')')
      WRITE(6,
     &'(8X,''|              Q C D N U M '',A8,
     &     ''             |'')') CHVERS
      WRITE(6,
     &'(8X,''|                                               |'')')
      WRITE(6,
     &'(8X,''|         Author  : Michiel Botje               |'')')
      WRITE(6,
     &'(8X,''|         Email   : h24@nikhef.nl               |'')')
      WRITE(6,
     &'(8X,''|                                               |'')')
      WRITE(6,
     &'(8X,''|         Date    : '',A8,
     &     ''                    |'')') CHDATE
      WRITE(6,
     &'(8X,''|         Max NX  : '',I3,
     &     ''                         |'')') MXX-1
      WRITE(6,
     &'(8X,''|         Max NQ2 : '',I3,
     &     ''                         |'')') MQ2-1
      WRITE(6,
     &'(8X,''|                                               |'')')
      WRITE(6,
     &'(8X,''+-----------------------------------------------+'')')
      WRITE(6,'(/////)')
      endif
 
      IORD   = 2
      IOLAST = -999
      Q0ALFA = 50.
      ALPHA0 = 0.180
      QALAST = -999.
      ASLAST = -999.
      SCAX0  = 0.20
      SCAQ0  = 1.D10
 
      PI     = 3.14159265359
      PROTON = 0.9382796
      EUTRON = 0.9395731
      UCLEON = (PROTON + EUTRON) / 2.
      UDSCBT(1) = 0.005
      UDSCBT(2) = 0.01
      UDSCBT(3) = 0.3
      UDSCBT(4) = 1.5
      UDSCBT(5) = 5.0
      UDSCBT(6) = 188.
      CBMSTF(4) = UDSCBT(4)
      CBMSTF(5) = UDSCBT(4)
      CBMSTF(6) = UDSCBT(5)
      CBMSTF(7) = UDSCBT(5)
      CHARGE(4) = 4./9.
      CHARGE(5) = 4./9.
      CHARGE(6) = 1./9.
      CHARGE(7) = 1./9.
      AAM2H     = 1.
      BBM2H     = 0.
      AAM2L     = 1.
      BBM2L     = 0.
      AAAR2     = 1.
      BBBR2     = 0.
      FL_FAC    = 0.
      C1S3   = 1./3.
      C2S3   = 2./3.
      C4S3   = 4./3.
      C5S3   = 5./3.
      C8S3   = 8./3.
      C14S3  = 14./3.
      C16S3  = 16./3.
      C20S3  = 20./3.
      C28S3  = 28./3.
      C38S3  = 38./3.
      C40S3  = 40./3.
      C44S3  = 44./3.
      C52S3  = 52./3.
      C136S3 = 136./3.
      C11S6  = 11./6.
      C2S9   = 2./9.
      C4S9   = 4./9.
      C10S9  = 10./9.
      C14S9  = 14./9.
      C16S9  = 16./9.
      C40S9  = 40./9.
      C44S9  = 44./9.
      C62S9  = 62./9.
      C112S9 = 112./9.
      C182S9 = 182./9.
      C11S12 = 11./12.
      C35S18 = 35./18.
      C11S3  = 11./3.
      C22S3  = 22./3.
      C61S12 = 61./12.
      C215S1 = 215./12.
      C29S12 = 29./12.
      CPI2S3 = PI**2/3.
      CPIA   = 67./18. - CPI2S3/2.
      CPIB   = 4.*CPI2S3
      CPIC   = 17./18. + 3.5*CPI2S3
      CPID   = 367./36. - CPI2S3
      CPIE   = 5. - CPI2S3
      CPIF   = CPI2S3 - 218./9.

      CCA    = 3.
      CCF    = (CCA*CCA-1.)/(2.*CCA)
      CTF    = 0.5
      CATF   = CCA*CTF
      CFTF   = CCF*CTF
 
      DO I = 1,10
        T_SPENT(I) = 0.
        E_CALLS(I) = 0.
        N_CALLS(I) = 0
      ENDDO
      LTIME  = .FALSE.

      LBMARK = .FALSE.
      LW1ANA = .TRUE.
      LW1NUM = .FALSE.
      LW2NUM = .TRUE.
      LW2STF = .TRUE.
      LWF2C  = .FALSE.
      LWF2B  = .FALSE.
      LWFLC  = .FALSE.
      LWFLB  = .FALSE.
      LIMCK  = .TRUE.
      LPLUS  = .TRUE.
      LALFOK = .FALSE.
      LDQ2OK = .FALSE.
      LWT1OK = .FALSE.
      LWT2OK = .FALSE.
      LWTFOK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
      LCLOWQ = .TRUE.
      LASOLD = .FALSE.
      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)
      CALL QNFALS(LE_DONE,MXX)
      CALL QNINUL(IQL_LAST,10)
      CALL QNINUL(IQ0_LAST,10)
      CALL QNINUL(IQH_LAST,10)
 
      ITADR = 0
      DO I = 0,19
        TSNAM(I) = '       '
        NTCAL(I) = 0
      ENDDO

      NXX    = 0
      NQ2    = 0
      NGRVER = 0
      NDFAST = 30
      XMICUT = -1.
      QMICUT = -1.
      QMACUT = -1.
      RS2CUT = -1.
      QMINAS = 0.
      THRS34 = -1.D10
      THRS45 =  1.D10
 
      CALL VZERO (WGTFF1,MXX*(MXX+1)/2)
      CALL VZERO (WGTFG1,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTGF1,MXX*(MXX+1)/2)
      CALL VZERO (WGTGG1,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTPP2,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTPM2,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTNS2,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTFF2,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTFG2,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTGF2,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTGG2,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTC2Q,MXX*(MXX+1)/2)
      CALL VZERO (WGTC2G,MXX*(MXX+1)*3/2)
      CALL VZERO (YNTC2Q,MXX)
      CALL VZERO (WGTCLQ,MXX*(MXX+1)/2)
      CALL VZERO (WGTCLG,MXX*(MXX+1)*3/2)
      CALL VZERO (WGTC3Q,MXX*(MXX+1)/2)

      CALL QNVNUL(PWGT,11*31*3)
      CALL QNINUL(NFMAP,MQ2)
      CALL QNINUL(MARKFF,MXX*MQ2)
      CALL QNINUL(MARKFH,MXX*MQ2)
      CALL QNINUL(MARKQQ,MQ2)
      CALL QNINUL(IDFAST,7*30)
      CALL QNINUL(IFCNT,3*5)  

      CALL QNVNUL(PDFQCD,MXX*MQ2*11)
      DO ID = 1,NDFMAX
        DO IX = 1,MXX
          DO IQ = 1,MQ2
            FSTORE(IX,IQ,30+ID) = -501.
          ENDDO
        ENDDO
      ENDDO

      PNAM(0)   = 'GLUON'
      PNAM(1)   = 'SINGL'
      LNFP(0,3) = .TRUE.
      LNFP(0,4) = .TRUE.
      LNFP(0,5) = .TRUE.
      LNFP(1,3) = .TRUE.
      LNFP(1,4) = .TRUE.
      LNFP(1,5) = .TRUE.
      DO 10 I = 2,30
        PNAM(I)   = 'FREE '
        LNFP(I,3) = .FALSE.
        LNFP(I,4) = .FALSE.
        LNFP(I,5) = .FALSE.
  10  CONTINUE
      PWGT(0,0,3) = 1.
      PWGT(0,0,4) = 1.
      PWGT(0,0,5) = 1.
      PWGT(1,1,3) = 1.
      PWGT(1,1,4) = 1.
      PWGT(1,1,5) = 1.
      STFNAM(1)   = 'F2   '
      STFNAM(2)   = 'FL   '
      STFNAM(3)   = 'XF3  '
      STFNAM(4)   = 'F2C  '
      STFNAM(5)   = 'FLC  '
      STFNAM(6)   = 'F2B  '
      STFNAM(7)   = 'FLB  '

      CALL QTRACE('QNINIT ',0)
 
      RETURN
      END
 
CDECK  ID>, QTRACE.

C     ===============================
      SUBROUTINE QTRACE(SRNAM,IPRINT)
C     ===============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      CHARACTER*7 SRNAM

      CHARACTER*7 TSNAM
      COMMON/QCTRCE/ TSNAM(0:19)
      COMMON/QCTRCI/ NTCAL(0:19),ITADR
 

      IF(IPRINT.EQ.0) THEN

        IF(SRNAM.EQ.TSNAM(ITADR)) THEN
          NTCAL(ITADR) = NTCAL(ITADR) + 1
        ELSE
          ITADR = MOD(ITADR+1,20)
          TSNAM(ITADR) = SRNAM
          NTCAL(ITADR) = 1
        ENDIF

      ELSE

        WRITE(6,'(/'' ----------------------------'')')

        K = -20
        DO I = ITADR+1,ITADR+19
          J = MOD(I,20)
          K = K+1
          WRITE(6,'(I4,2X,A7,''  #calls = '',I5)')
     +    K,TSNAM(J),NTCAL(J)
        ENDDO
        K = 0
        WRITE(6,'(I4,2X,A7,''  #calls = '',I5,''  <--- error'')')
     +  K,TSNAM(ITADR),NTCAL(ITADR)

        WRITE(6,'( '' ----------------------------'')')

      ENDIF

      RETURN
      END
 
CDECK  ID>, QNDUMP.

C     ======================
      SUBROUTINE QNDUMP(LUN)
C     ======================

C---  QNDUMP: write weight tables to LUN.
C---  Called by user.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

      CHARACTER*8 CHVERS,CHDATE
      COMMON/QCVERS/ CHVERS,CHDATE
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)


      REAL
     +WH_C0KG,WH_C1KG,WH_C1BKG,
     +WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ

      COMMON/QCHWGT/
     +WH_C0KG(0:MXX,MQ2,4:7),
     +WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),
     +WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),
     +WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)


      DIMENSION STOREM(6)

      CALL QTRACE('QNDUMP ',0)

      STOREM(1) = CBMSTF(4)
      STOREM(2) = CBMSTF(6)
      STOREM(3) = 0.
      STOREM(4) = 0.
      STOREM(5) = 0.
      STOREM(6) = 0.

      WRITE(LUN) MXX,MQ2
      WRITE(LUN) CHVERS,CHDATE
      WRITE(LUN) STOREM
      WRITE(LUN) LWT1OK,LWT2OK,LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,
     +           LPLUS
      WRITE(LUN) XXTAB,Q2TAB,
     +           NXX,NQ2,IQF2C,IQF2B,IQFLC,IQFLB
      IF(LWT1OK) THEN
      WRITE(LUN) WGTFF1,WGTFG1,WGTGF1,WGTGG1
      ENDIF
      IF(LWT2OK) THEN
      WRITE(LUN) WGTPP2,WGTPM2,WGTNS2,WGTFF2,WGTFG2,WGTGF2,WGTGG2
      ENDIF
      IF(LWTFOK) THEN
      WRITE(LUN) WGTC2Q,WGTC2G,YNTC2Q,WGTCLQ,WGTCLG,WGTC3Q
      ENDIF
      IF(LWFCOK.OR.LWLCOK.OR.LWFBOK.OR.LWLBOK) THEN
      WRITE(LUN) WH_C0KG,WH_C1KG,WH_C1BKG,
     +           WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ
      ENDIF
 
      RETURN
      END
 
CDECK  ID>, QNREAD.

C     =================================
      SUBROUTINE QNREAD(LUN,ISTOP,IERR)
C     =================================

C---  QNDUMP: read weight tables from LUN.
C---  Called by user.
C---  Input  integer LUN
C---         integer ISTOP = 0 read the file
C---                 ISTOP = 1 read only when ierr = 0
C---                 ISTOP = 2 stop the program when ierr .ne. 0
C---  Output integer IERR  = 0 all ok
C---                       = 1 xgrid on file .ne. that in QCDNUM
C---                       = 2 file contains heavy quark weight tables and
C---                           qgrid on file .ne. that in QCDNUM
C---                       = 3 file contains charm weight tables and
C---                           c mass on the file .ne. that in QCDNUM
C---                       = 4 file contains bottom weight tables and
C---                           b mass on the file .ne. that in QCDNUM
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

      CHARACTER*8 CHVERS,CHDATE
      COMMON/QCVERS/ CHVERS,CHDATE
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)


      REAL
     +WH_C0KG,WH_C1KG,WH_C1BKG,
     +WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ

      COMMON/QCHWGT/
     +WH_C0KG(0:MXX,MQ2,4:7),
     +WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),
     +WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),
     +WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CHARACTER*8 RHVERS,RHDATE
      LOGICAL     RWT1OK,RWT2OK,RWTFOK,RWFCOK
      LOGICAL     RWLCOK,RWFBOK,RWLBOK,RPLUS
      LOGICAL     LREADX,LREADQ,LREADB,LREADC
      DIMENSION   RMASS(6)
      DIMENSION   RXTAB(MXX),RQTAB(MQ2)
      DIMENSION   IRF2C(MQ2),IRF2B(MQ2),IRFLC(MQ2),IRFLB(MQ2)
c
c common added 18/3/05 by MRW
      common/lhasilent/lhasilent

      CALL QTRACE('QNREAD ',0)

      REWIND LUN

C--   Setup the weight adresses
C--   (Usually done in QNFILW, but this routine might not be called)
      DO IX0 = 1,MXX
        DO IX = IX0,MXX
          IWADR(IX,IX0) = IWTAD(IX,IX0)
        ENDDO
      ENDDO

C--   Read header information
      READ(LUN,ERR=500) KXX,KQ2
      IF(KXX.NE.MXX.OR.KQ2.NE.MQ2) THEN
        WRITE(6,'(/'' QNREAD: nxmax, nqmax on file  '',2I5,
     +            /''         nxmax, nqmax in QCDNUM'',2I5,
     +            /''         Incompatible ---> STOP'')') 
     +                        KXX,KQ2,MXX,MQ2
        STOP
      ENDIF
      READ(LUN,ERR=500) RHVERS,RHDATE
      READ(RHVERS(1:2),'(I2)') IV

C--   If ISTOP > 0 : stop when fileversion = QCDNUM15 or lower
C--   If ISTOP = 0 : read up to the weight tables
      IF(IV.LE.15.AND.ISTOP.NE.0) THEN
        WRITE(6,'(/'' QNREAD: file was written with QCDNUM'',A8,
     +             '' Incompatible ---> STOP'')')
     +   RHVERS
        STOP   
      ENDIF
      if(lhasilent.eq.0) 
     + WRITE(6,'(/'' QNREAD: file was written with QCDNUM'',A8)')
     + RHVERS

      READ(LUN,ERR=500) RMASS  
      READ(LUN,ERR=500) RWT1OK,RWT2OK,RWTFOK,RWFCOK,RWLCOK,RWFBOK,
     +                  RWLBOK,RPLUS
      READ(LUN,ERR=500) RXTAB,RQTAB,
     +                  NRX,NRQ,IRF2C,IRF2B,IRFLC,IRFLB

      IERR   = 0
      LREADX = .FALSE.
      LREADQ = .FALSE.
      LREADC = .FALSE.
      LREADB = .FALSE.

C--   Check xgrid (if there is one already defined)  
      IF(NXX.NE.0)     THEN
        IF(NXX.NE.NRX) THEN
          IERR = 1
        ELSE
          DO IX = 1,NXX
            IF(RXTAB(IX).NE.XXTAB(IX)) IERR = 1
          ENDDO
        ENDIF
      ENDIF

C--   What to do when xgrid is different
      IF(IERR.EQ.1) THEN
        IF(ISTOP.EQ.1) THEN
          WRITE(6,'(/
     +    '' QNREAD: X grid in memory different from that on file'',
     +    '' ---> abandon reading'')')
          RETURN
        ENDIF
        IF(ISTOP.EQ.2) THEN
          WRITE(6,'(/
     +    '' QNREAD: X grid in memory different from that on file'',
     +    '' ---> STOP'')')
          STOP
        ENDIF
      ENDIF

      IF(IERR.EQ.1.OR.NXX.LE.0) LREADX = .TRUE.

C--   Check Q2 grid if there is one already defined and if there are
C--   heavy quark weight tables on the file
      IF(NQ2.NE.0.AND.(RWFCOK.OR.RWLCOK.OR.RWFBOK.OR.RWLBOK)) THEN
        IF(NQ2.NE.NRQ) THEN
          IERR = 2
        ELSE
          DO IQ = 1,NQ2
            IF(RQTAB(IQ).NE.Q2TAB(IQ)) IERR = 2
          ENDDO
        ENDIF
      ENDIF

C--   What to do when qgrid is different
      IF(IERR.EQ.2) THEN
        IF(ISTOP.EQ.1) THEN
          WRITE(6,'(/
     +    '' QNREAD: Q2 grid in memory different from that on file'',
     +    '' ---> abandon reading'')')
          RETURN
        ENDIF
        IF(ISTOP.EQ.2) THEN
          WRITE(6,'(/
     +    '' QNREAD: Q2 grid in memory different from that on file'',
     +    '' ---> STOP'')')
          STOP
        ENDIF
      ENDIF

      IF(IERR.EQ.2.OR.NQ2.LE.0) LREADQ = .TRUE.

C--   Check charm mass if there are charm weight tables on the file
      IF(RWFCOK.OR.RWLCOK) THEN
        IF(IV.LE.15) THEN
          IF(RMASS(4).NE.CBMSTF(4)) IERR = 3
        ELSE
          IF(RMASS(1).NE.CBMSTF(4)) IERR = 3
        ENDIF
      ENDIF

C--   What to do when charm mass is different
      IF(IERR.EQ.3) THEN
        IF(ISTOP.EQ.1) THEN
          WRITE(6,'(/
     +    '' QNREAD: Charm mass in memory different from that on file'',
     +    '' ---> abandon reading'')')
          RETURN
        ENDIF
        IF(ISTOP.EQ.2) THEN
          WRITE(6,'(/
     +    '' QNREAD: Charm mass in memory different from that on'',
     +    '' file ---> STOP'')')
          STOP
        ENDIF
        LREADC = .TRUE.
      ENDIF

C--   Check bottom mass if there are bottom weight tables on the file
      IF(RWFBOK.OR.RWLBOK) THEN
        IF(IV.LE.15) THEN
          IF(RMASS(5).NE.CBMSTF(6)) IERR = 4
        ELSE
          IF(RMASS(2).NE.CBMSTF(6)) IERR = 4
        ENDIF
      ENDIF

C--   What to do when bottom mass is different
      IF(IERR.EQ.4) THEN
        IF(ISTOP.EQ.1) THEN
          WRITE(6,'(/
     +    '' QNREAD: Bottom mass in memory different from that on'',
     +    '' file ---> abandon reading'')')
          RETURN
        ENDIF
        IF(ISTOP.EQ.2) THEN
          WRITE(6,'(/
     +    '' QNREAD: Bottom mass in memory different from that on'',
     +    '' file ---> STOP'')')
          STOP
        ENDIF
        LREADB = .TRUE.
      ENDIF

C--   ok..... continue.......
      LPLUS  = RPLUS
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

      IF(LREADX) THEN
C--     Copy xgrid to qcdnum common block
        NXX = NRX
        DO IX = 1,NXX+1
          XXTAB(IX) = RXTAB(IX)
        ENDDO
        WRITE(6,'(/
     +    '' QNREAD: xgrid table read in (original overwritten)'')')
C--     Invalidate all weight tables since the grid has changed 
        LWT1OK = .FALSE.
        LWT2OK = .FALSE.
        LWTFOK = .FALSE.
        LWFCOK = .FALSE.
        LWLCOK = .FALSE.
        LWFBOK = .FALSE.
        LWLBOK = .FALSE.
        LMARK  = .FALSE.
        NGRVER = NGRVER+1
C--     Invalidate all evolutions      
        CALL QNFALS(LEVDONE,MXX*10)
C---    Update IFAILC
        CALL GRSETC
C---    Update NFMAP
        CALL QNSETT
C---    Update heavy quark xgrid
        CALL GXHDEF
      ENDIF

      IF(LREADQ) THEN
C--     Copy q2 grid to common block
        NQ2 = NRQ
        DO IQ = 1,NQ2
          Q2TAB(IQ) = RQTAB(IQ)
        ENDDO
        WRITE(6,'(/
     +    '' QNREAD: qgrid table read in (original overwritten)'')')
C--     Invalidate hq weight tables since the grid has changed
        LALFOK = .FALSE.
        LDQ2OK = .FALSE.
        LWFCOK = .FALSE.
        LWLCOK = .FALSE.
        LWFBOK = .FALSE.
        LWLBOK = .FALSE.
        LMARK  = .FALSE.
        NGRVER = NGRVER + 1
C--     Invalidate all evolutions      
        CALL QNFALS(LEVDONE,MXX*10)
C---    Update IFAILC
        CALL GRSETC
C---    Update NFMAP
        CALL QNSETT
      ENDIF

      IF(LREADC) THEN
        IF(IV.LE.15) THEN
          UDSCBT(4) = RMASS(4)
          CBMSTF(4) = RMASS(4)
          CBMSTF(5) = RMASS(4)
        ELSE
          CBMSTF(4) = RMASS(1)
          CBMSTF(5) = RMASS(1)
        ENDIF
        WRITE(6,'(/
     +    '' QNREAD: charm mass read in (original overwritten)'')')
C--     Invalidate charm weight tables since charm mass has changed
        LWFCOK = .FALSE.
        LWLCOK = .FALSE.
C--     Invalidate alpha_s table
        LALFOK = .FALSE.
      ENDIF

      IF(LREADB) THEN
        IF(IV.LE.15) THEN
          UDSCBT(5) = RMASS(5)
          CBMSTF(6) = RMASS(5)
          CBMSTF(7) = RMASS(5)
        ELSE
          CBMSTF(6) = RMASS(2)
          CBMSTF(7) = RMASS(2)
        ENDIF
        WRITE(6,'(/
     +    '' QNREAD: bottom mass read in (original overwritten)'')')
C--     Invalidate bottom weight tables since charm mass has changed
        LWFBOK = .FALSE.
        LWLBOK = .FALSE.
C--     Invalidate alpha_s table
        LALFOK = .FALSE.
      ENDIF

      IF(IV.LE.15) THEN
        WRITE(6,'(/'' QNREAD: file was written with QCDNUM'',A8)')
     +   RHVERS
        WRITE(6,'( '' ------> Abandon reading the weight tables'')')
        RETURN
      ENDIF

      IF(RWT1OK) THEN
        READ(LUN,ERR=500) WGTFF1,WGTFG1,WGTGF1,WGTGG1
        LWT1OK = .TRUE.
        if(lhasilent.eq.0) 
     +   WRITE(6,'(/'' QNREAD: LO weight tables read in'')')
      ENDIF

      IF(RWT2OK) THEN
        READ(LUN,ERR=500) WGTPP2,WGTPM2,WGTNS2,WGTFF2,WGTFG2,WGTGF2,
     +                    WGTGG2
        LWT2OK = .TRUE.
        if(lhasilent.eq.0) 
     +   WRITE(6,'(/'' QNREAD: NLO weight tables read in'')')
      ENDIF

      IF(RWTFOK) THEN
        READ(LUN,ERR=500) WGTC2Q,WGTC2G,YNTC2Q,WGTCLQ,WGTCLG,WGTC3Q
        LWTFOK = .TRUE.
        if(lhasilent.eq.0) 
     +   WRITE(6,'(/'' QNREAD: F2, FL weight tables read in'')')
      ENDIF

      IF(RWFCOK.OR.RWLCOK.OR.RWFBOK.OR.RWLBOK) THEN
        READ(LUN,ERR=500) WH_C0KG,WH_C1KG,WH_C1BKG,
     +                    WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ
        LWFCOK = RWFCOK
        LWLCOK = RWLCOK
        LWFBOK = RWFBOK
        LWLBOK = RWLBOK
        if(lhasilent.eq.0) then 
        IF(RWFCOK)
     +  WRITE(6,'(/'' QNREAD: F2C weight tables read in'')')
        IF(RWLCOK)
     +  WRITE(6,'(/'' QNREAD: FLC weight tables read in'')')
        IF(RWFBOK)
     +  WRITE(6,'(/'' QNREAD: F2B weight tables read in'')')
        IF(RWLBOK)
     +  WRITE(6,'(/'' QNREAD: FLB weight tables read in'')')
        endif
      ENDIF

      RETURN

 500  CONTINUE
      WRITE(6,'(/'' QNREAD: cannot read file on lun = '',I5,
     +           '' ---> STOP'')') LUN

      CALL QTRACE('QNREAD ',1)

      STOP
 
      END

CDECK  ID>, QNPRIN.
C
C     ======================
      SUBROUTINE QNPRIN(LUN)
C     ======================
 
C---  QNPRIN: print default + current setting of QCDNUM parameters.
C---  Called by QPRINT
C---  Input parameter: LUN. To be opened by user unless LUN = 6.

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      IF(RS2CUT.GE.0.) THEN
        RS2C = SQRT(RS2CUT)
      ELSE
        RS2C = RS2CUT
      ENDIF

      WRITE(LUN,'(//'' +-------+---+-------+--------------+'',
     + ''------------------------------------+'')')
      WRITE(LUN,'(  '' | var   |typ| deflt |     value    |'',
     + '' description                        |'')')
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',
     + ''------------------------------------+'')')
      WRITE(LUN,'('' | W1ANA | L |   T   | '',6X,L1,5X,
     + '' | Analytical LO weight calculation   |'')') LW1ANA
      WRITE(LUN,'('' | W1NUM | L |   F   | '',6X,L1,5X,
     + '' | Numerical  LO weight calculation   |'')') LW1NUM
      WRITE(LUN,'('' | W2NUM | L |   T   | '',6X,L1,5X,
     + '' | Numerical NLO weight calculation   |'')') LW2NUM
      WRITE(LUN,'('' | W2STF | L |   T   | '',6X,L1,5X,
     + '' | Structure function NLO weights     |'')') LW2STF
      WRITE(LUN,'('' | WTF2C | L |   F   | '',6X,L1,5X,
     + '' | F2_charm  weight calculation       |'')') LWF2C 
      WRITE(LUN,'('' | WTF2B | L |   F   | '',6X,L1,5X,
     + '' | F2_bottom weight calculation       |'')') LWF2B 
      WRITE(LUN,'('' | WTFLC | L |   F   | '',6X,L1,5X,
     + '' | FL_charm  weight calculation       |'')') LWFLC 
      WRITE(LUN,'('' | WTFLB | L |   F   | '',6X,L1,5X,
     + '' | FL_bottom weight calculation       |'')') LWFLB 
      WRITE(LUN,'('' | LIMCK | L |   T   | '',6X,L1,5X,
     + '' | Check x, Q2 limits and cuts        |'')') LIMCK 
      WRITE(LUN,'('' | CLOWQ | L |   T   | '',6X,L1,5X,
     + '' | Heavy F2,FL only for Q2 > 1.5 GeV2 |'')') LCLOWQ
      WRITE(LUN,'('' | ORDER | I |   2   | '',6X,I1,5X,
     + '' | LO (1) or NLO (2) calculations     |'')') IORD  
      WRITE(LUN,'('' | SCAX0 | R |  0.20 | '',E12.5,
     + '' | x-grid  scale from log --> linear  |'')') SCAX0
      WRITE(LUN,'('' | SCAQ0 | R | +inf  | '',E12.5,
     + '' | Q2-grid scale from log --> linear  |'')') SCAQ0
      WRITE(LUN,'('' | MCSTF | R |  1.5  | '',E12.5,
     + '' | C mass for F2c, FLc (GeV)          |'')') CBMSTF(4)
      WRITE(LUN,'('' | MBSTF | R |  5.0  | '',E12.5,
     + '' | B mass for F2b, FLb (GeV)          |'')') CBMSTF(6)
      WRITE(LUN,'('' | MCALF | R |  1.5  | '',E12.5,
     + '' | C mass for alpha_s evolution (GeV) |'')') UDSCBT(4)
      WRITE(LUN,'('' | MBALF | R |  5.0  | '',E12.5,
     + '' | B mass for alpha_s evolution (GeV) |'')') UDSCBT(5)
      WRITE(LUN,'('' | MTALF | R | 188.  | '',E12.5,
     + '' | T mass for alpha_s evolution (GeV) |'')') UDSCBT(6)
      WRITE(LUN,'('' | ALFAS | R | 0.180 | '',E12.5,
     + '' | Value of alpha_s                   |'')') ALPHA0   
      WRITE(LUN,'('' | ALFQ0 | R |  50.  | '',E12.5,
     + '' | Q2 where alpha_s is given (GeV2)   |'')') Q0ALFA   
      WRITE(LUN,'('' | AAAR2 | R |  1.0  | '',E12.5,
     + '' | R2 = A*M2 + B (ren. scale)         |'')') AAAR2
      WRITE(LUN,'('' | BBBR2 | R |  0.0  | '',E12.5,
     + '' | R2 = A*M2 + B (ren. scale)         |'')') BBBR2
      WRITE(LUN,'('' | AAM2L | R |  1.0  | '',E12.5,
     + '' | M2 = A*Q2 + B (light fact. scale)  |'')') AAM2L
      WRITE(LUN,'('' | BBM2L | R |  0.0  | '',E12.5,
     + '' | M2 = A*Q2 + B (light fact. scale)  |'')') BBM2L
      WRITE(LUN,'('' | AAM2H | R |  1.0  | '',E12.5,
     + '' | M2 = A*Q2 + B (heavy fact. scale)  |'')') AAM2H
      WRITE(LUN,'('' | BBM2H | R |  0.0  | '',E12.5,
     + '' | M2 = A*Q2 + B (heavy fact. scale)  |'')') BBM2H
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',
     + ''------------------------------------+'')')
      WRITE(LUN,'('' | TCHRM | R | -inf  | '',E12.5,
     + '' | Charm threshold  (GeV2)            |'')') THRS34
      WRITE(LUN,'('' | TBOTT | R | +inf  | '',E12.5,
     + '' | Bottom threshold (GeV2)            |'')') THRS45
      WRITE(LUN,'('' | XMINC | R |  0.0  | '',E12.5,
     + '' | Xmin cut  (.le.0 = no cut)         |'')') XMICUT
      WRITE(LUN,'('' | QMINC | R |  0.0  | '',E12.5,
     + '' | Qmin cut  (.le.0 = no cut)         |'')') QMICUT
      WRITE(LUN,'('' | QMAXC | R |  0.0  | '',E12.5,
     + '' | Qmax cut  (.le.0 = no cut)         |'')') QMACUT
      WRITE(LUN,'('' | ROOTS | R |  0.0  | '',E12.5,
     + '' | Roots cut (.le.0 = no cut)         |'')') RS2C
      WRITE(LUN,'('' | QMINA | R |  0.0  | '',E12.5,
     + '' | Lowest Q2 gridpoint above Lambda2  |'')') QMINAS
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',
     + ''------------------------------------+'')')
      WRITE(LUN,'('' | ASOLD | L |   F   | '',6X,L1,5X,
     + '' | Use old (incorrect) a_s evolution  |'')') LASOLD
      WRITE(LUN,'('' | BMARK | L |   F   | '',6X,L1,5X,
     + '' | Do not use: for tests only         |'')') LBMARK
      WRITE(LUN,'('' | FLFAC | R |  0.0  | '',E12.5,
     + '' | Hands off : for experts only       |'')') BBM2H
      WRITE(LUN,'(  '' +-------+---+-------+--------------+'',
     + ''------------------------------------+'')')

      RETURN
      END

CDECK  ID>, QNVERS.
C
C     ==============================================
      SUBROUTINE QNVERS(VERSION,LDOUBLE,NXMAX,NQMAX)
C     ==============================================

C---  QNVERS: return version number, dp flag and max # of gridpoints.
C---  Called by user.
C---  Output variables: VERSION (character*8)
C---                    LDOUBLE (logical)
C---                    NXMAX, NQMAX (integer); set by parameter
C---                    statement in common block QCNXQM.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      CHARACTER*8 VERSION
      LOGICAL     LDOUBLE
 
      CHARACTER*8 CHVERS,CHDATE
      COMMON/QCVERS/ CHVERS,CHDATE
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)


      CALL QTRACE('QNVERS ',0)
 
      VERSION = CHVERS
      LDOUBLE = LDOUBL
      NXMAX   = MXX-1
      NQMAX   = MQ2-1
 
      RETURN
      END
 
CDECK  ID>, QPRINT.
 
C     ==========================
      SUBROUTINE QPRINT(LUN,OPT)
C     ==========================

C---  QPRINT: steering routine to print various QCDNUM info on
C--           logical unit number LUN (to be opened by the user).
C---  Called by user.
C---  Input integer LUN  :  locical unit number.
C---        character OPT: 'A' (All)        print all info.
C---                       'B' (Booklist)   print pdf definitions.
C---                       'P' (Parameters) Parameter/option list.
C---                       'S' (Statistics) # STF function calls.
C---                       'T' (Timelog)    timelog.
C---                       'X' (Xq2grid)    grid,thresholds,cuts.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT
      CHARACTER*1   OPT1
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)


      CALL QTRACE('QPRINT ',0)
 
      IF(LENOCC_LHA(OPT).LT.1) GOTO 500
      OPT1 = OPT(1:1)
      CALL CLTOU_LHA(OPT1)
 
      IF(OPT1.EQ.'T') THEN !
        CALL QPTIME(LUN)
      ELSEIF(OPT1.EQ.'P') THEN
        CALL QNPRIN(LUN)
      ELSEIF(OPT1.EQ.'B') THEN
        CALL QNLIST(LUN)
      ELSEIF(OPT1.EQ.'S') THEN
        CALL QNSTAT(LUN)
      ELSEIF(OPT1.EQ.'X') THEN
        CALL QPGRID(LUN)
      ELSEIF(OPT1.EQ.'A') THEN
        CALL QNPRIN(LUN)
        CALL QNLIST(LUN)
        CALL QPGRID(LUN)
        CALL QNSTAT(LUN)
        CALL QPTIME(LUN)
      ELSE
        GOTO 500
      ENDIF

      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QPRINT ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input LUN :'',I5   )') LUN
      WRITE(6,'( ''       OPT :'',A    )') OPT
      WRITE(6,'(/'' Option should be A, B, P, S, T or X'')')

      STOP

      END
 
CDECK  ID>, QNTIME.
 
C     ======================
      SUBROUTINE QNTIME(OPT)
C     ======================

C---  QNTIME: start/halt/continue the timelog.
C---  Called by user and by QPTIME.
C---  Input variable: 'Start'    initialise and start the timelog.
C---                  'Hold'     stop logging.     
C---                  'Cont'     continue logging.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT
      CHARACTER*1   OPT1
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)


      CALL QTRACE('QNTIME ',0)
 
      IF(LENOCC_LHA(OPT).LT.1) GOTO 500
      OPT1 = OPT(1:1)
      CALL CLTOU_LHA(OPT1)
 
      IF(OPT1.EQ.'S') THEN
 
        DO I = 1,10
          T_SPENT(I) = 0.
          E_CALLS(I) = 0.
          N_CALLS(I) = 0
        ENDDO
        LTIME = .TRUE.
 
        N_CALLS(1) = N_CALLS(1)+1
        CALL TIMEX_LHA(T_START(1))
 
      ELSEIF(OPT1.EQ.'H') THEN

        LTIME = .FALSE.
        CALL TIMEX_LHA(T_END(1))
        T_SPENT(1) = T_SPENT(1)+T_END(1)-T_START(1)
        T_START(1) = T_END(1)

      ELSEIF(OPT1.EQ.'C') THEN

        IF(.NOT.LTIME) THEN
          LTIME = .TRUE.
          N_CALLS(1) = N_CALLS(1)+1
          CALL TIMEX_LHA(T_START(1))
        ENDIF

      ELSE
 
        GOTO 500
 
      ENDIF
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNTIME ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input OPT :'',A    )') OPT
      WRITE(6,'(/'' Option should be S, H or C         '')')

      CALL QTRACE('QNTIME ',1)

      STOP
 
      END
 
CDECK  ID>, QPTIME.
 
C     ======================
      SUBROUTINE QPTIME(LUN)
C     ======================

C---  QPTIME: start/print the timelog.
C---  Called by QPRINT.
C---  Input variable: LUN logical unit number 
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      CALL QNTIME('H')    

      N_TOT      = N_CALLS(3)+N_CALLS(4)+N_CALLS(5)
      E_TOT      = E_CALLS(3)+E_CALLS(4)+E_CALLS(5)
      T_TOT      = T_SPENT(3)+T_SPENT(4)+T_SPENT(5)
      T_REST     = T_SPENT(1)-T_TOT-T_SPENT(2)-T_SPENT(6)
      DUMMY      = 1.
      F_FAST     = 0.
      DO J = 1,5
        F_FAST   = F_FAST+IFCNT(1,J)
      ENDDO
      WRITE(LUN,
     +  '(//'' -------------------------------------------------'')')
      WRITE(LUN,
     +  '(  '' Routine     # calls   # evols   CPU sec  CPU/evol'')')
      WRITE(LUN,
     +  '(  '' -------------------------------------------------'')')
      WRITE(LUN,
     + '('' EVOLNM   '',I10,2F10.1,F10.2)') N_CALLS(3),
     +      E_CALLS(3),T_SPENT(3),T_SPENT(3)/MAX(E_CALLS(3),DUMMY)
      WRITE(LUN,
     + '('' EVOLNP   '',I10,2F10.1,F10.2)') N_CALLS(4),
     +      E_CALLS(4),T_SPENT(4),T_SPENT(4)/MAX(E_CALLS(4),DUMMY)
      WRITE(LUN,
     + '('' EVOLSG   '',I10,2F10.1,F10.2)') N_CALLS(5),
     +      E_CALLS(5),T_SPENT(5),T_SPENT(5)/MAX(E_CALLS(5),DUMMY)
      WRITE(LUN,
     +  '(  '' -------------------------------------------------'')')
      WRITE(LUN,
     + '('' AP total '',I10,2F10.1,F10.2)') N_TOT,
     +      E_TOT,T_TOT,T_TOT/MAX(E_TOT,DUMMY)
      WRITE(LUN,'('' '')')
      WRITE(LUN,
     + '('' STFAST   '',I10,   2F10.1)') N_CALLS(6),F_FAST,T_SPENT(6)
      WRITE(LUN,
     + '('' QNFILW   '',I10,10X,F10.1)') N_CALLS(2),T_SPENT(2)
      WRITE(LUN,
     + '('' Other    '',10X,10X,F10.1)') T_REST
      WRITE(LUN,
     +  '(  '' -------------------------------------------------'')')
      WRITE(LUN,
     + '('' Total    '',10X,10X,F10.1)') T_SPENT(1)
      WRITE(LUN,
     +  '(  '' -------------------------------------------------'')')


      RETURN
      END
 
CDECK  ID>, QNSTAT.
 
C     ======================
      SUBROUTINE QNSTAT(LUN)
C     ======================

C---  QNSTAT: print number of structure function calculations.
C---  Called by user.
C---  Input parameter: LUN to be opened by user unless LUN = 6.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)


      DIMENSION ITOT(5)
       
       DO J = 1,5
        ITOT(J) = 0
        DO I = -1,1
          ITOT(J) = ITOT(J)+IFCNT(I,J)
        ENDDO
      ENDDO
 
      WRITE(LUN,'(//'' ------------------------------'',
     +   ''--------------------------------------------'')')
      WRITE(LUN,'(  '' Structure function calls '',
     +   ''           F2       FL      xF3'',
     +                ''      F2h      FLh'')')
      WRITE(LUN,'(  '' ------------------------------'',
     +   ''--------------------------------------------'')')
      WRITE(LUN,
     + '('' Slow calculation             '',5I9)') (IFCNT( 0,J),J=1,5)
      WRITE(LUN,
     + '('' Fast calculation             '',5I9)') (IFCNT( 1,J),J=1,5)
      WRITE(LUN,
     + '('' Outside grid or cuts         '',5I9)') (IFCNT(-1,J),J=1,5)
      WRITE(LUN,'(  '' ------------------------------'',
     +   ''--------------------------------------------'')')
      WRITE(LUN,
     + '('' Total                        '',5I9)') (   ITOT(J),J=1,5)
      WRITE(LUN,'(  '' ------------------------------'',
     +   ''--------------------------------------------'')')

      RETURN
      END
 
CDECK  ID>, QNIVAL.
 
C     ================================
      SUBROUTINE QNIVAL(OPT,FLAG,IVAL)
C     ================================

C---  QNIVAL: set/get integer variable.
C---  Called by user or internally by s/r QNISET and QNIGET.
C---  Input parameters: 'OPT'   = 'Set' or 'Get'.
C---                    'FLAG'  = variable name to set or get.
C---                    'IVAL' (integer) input or output variable.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT
      CHARACTER*1   OPT1
      CHARACTER*(*) FLAG
      CHARACTER*5   FLAG5
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      IF(LENOCC_LHA(OPT).LT.1)  THEN
        IERR = 1
        GOTO 500
      ENDIF
      IF(LENOCC_LHA(FLAG).LT.5) THEN
        IERR = 2
        GOTO 500
      ENDIF
      OPT1   = OPT(1:1)
      FLAG5  = FLAG(1:5)
      CALL CLTOU_LHA(OPT1)
      CALL CLTOU_LHA(FLAG5)
 
C     ----------------------
      IF(OPT1.EQ.'S') THEN !
C     ----------------------
 
        IF    (FLAG5.EQ.'ORDER') THEN
          IF(IVAL.LE.0.OR.IVAL.GE.3) THEN
            IERR = 3
            GOTO 500
          ENDIF
          IORD   = IVAL
C--       Invalidate all evolutions      
          CALL QNFALS(LEVDONE,MXX*10)
          LALFOK = .FALSE.
        ELSE
          IERR = 2
          GOTO 500
        ENDIF
 
C     --------------------------
      ELSEIF(OPT1.EQ.'G') THEN !
C     --------------------------
 
        IF    (FLAG5.EQ.'ORDER') THEN
          IVAL = IORD
        ELSE
          IERR = 2
          GOTO 500
        ENDIF
 
C     ------
      ELSE !
C     ------
 
        IERR = 1
        GOTO 500
 
C     -------
      ENDIF !
C     -------
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNIVAL ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input OPT : '',A    )') OPT
      WRITE(6,'( ''       VAR : '',A    )') FLAG
      WRITE(6,'( ''       VAL : '',I10  )') IVAL
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' OPT should be either SET or GET '')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Variable VAR not found'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' IVAL out of allowed range'')')
      ENDIF

      CALL QTRACE('QNIVAL ',1)

      STOP

      END

CDECK  ID>, QNISET.
 
C     ============================
      SUBROUTINE QNISET(FLAG,IVAL)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) FLAG

      CALL QTRACE('QNISET ',0)

      CALL QNIVAL('SET',FLAG,IVAL)

      RETURN
      END

CDECK  ID>, QNIGET.
 
C     ============================
      SUBROUTINE QNIGET(FLAG,IVAL)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) FLAG

      CALL QTRACE('QNIGET ',0)

      CALL QNIVAL('GET',FLAG,IVAL)

      RETURN
      END
 
CDECK  ID>, QNRVAL.
 
C     ===============================
      SUBROUTINE QNRVAL(OPT,FLAG,VAL)
C     ===============================

C---  QNRVAL: set/get floating point variable.
C---  Called by user or internally by s/r QNRSET and QNRGET.
C---  Input parameters: 'OPT'   = 'Set' or 'Get'.
C---                    'FLAG'  = variable name to set or get.
C---                    'VAL' (real or d.p.) input or output variable.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT
      CHARACTER*1   OPT1
      CHARACTER*(*) FLAG
      CHARACTER*5   FLAG5
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      IF(LENOCC_LHA(OPT).LT.1)  THEN
        IERR = 1
        GOTO 500
      ENDIF
      IF(LENOCC_LHA(FLAG).LT.5) THEN
        IERR = 2
        GOTO 500
      ENDIF
      OPT1   = OPT(1:1)
      FLAG5  = FLAG(1:5)
      CALL CLTOU_LHA(OPT1)
      CALL CLTOU_LHA(FLAG5)
 
C     ----------------------
      IF(OPT1.EQ.'S') THEN !
C     ----------------------
 
        IF    (FLAG5.EQ.'AAM2H'.OR.FLAG5.EQ.'AATQ2') THEN
          IF(VAL.LE.0.) THEN
            IERR = 3
            GOTO 500
          ENDIF
          AAM2H  = VAL
          DO I = 1,30
            LFFCAL(4,I) = .FALSE.
            LFFCAL(5,I) = .FALSE.
            LFFCAL(6,I) = .FALSE.
            LFFCAL(7,I) = .FALSE.
          ENDDO
        ELSEIF(FLAG5.EQ.'BBM2H'.OR.FLAG5.EQ.'PLUSB') THEN
          BBM2H  = VAL
          DO I = 1,30
            LFFCAL(4,I) = .FALSE.
            LFFCAL(5,I) = .FALSE.
            LFFCAL(6,I) = .FALSE.
            LFFCAL(7,I) = .FALSE.
          ENDDO
        ELSEIF(FLAG5.EQ.'AAM2L') THEN
          IF(VAL.LE.0.) THEN
            IERR = 3
            GOTO 500
          ENDIF
          AAM2L  = VAL
          DO I = 1,30
            LFFCAL(1,I) = .FALSE.
            LFFCAL(2,I) = .FALSE.
            LFFCAL(3,I) = .FALSE.
          ENDDO
        ELSEIF(FLAG5.EQ.'BBM2L') THEN
          BBM2L  = VAL
          DO I = 1,30
            LFFCAL(1,I) = .FALSE.
            LFFCAL(2,I) = .FALSE.
            LFFCAL(3,I) = .FALSE.
          ENDDO
        ELSEIF(FLAG5.EQ.'AAAR2') THEN
          AAAR2  = VAL
C--       Invalidate all evolutions      
          CALL QNFALS(LEVDONE,MXX*10)
          LALFOK = .FALSE.
          DO I = 1,30
            DO J = 1,7
              LFFCAL(J,I)  = .FALSE.
            ENDDO
          ENDDO
        ELSEIF(FLAG5.EQ.'BBBR2') THEN
          BBBR2  = VAL
C--       Invalidate all evolutions      
          CALL QNFALS(LEVDONE,MXX*10)
          LALFOK = .FALSE.
          DO I = 1,30
            DO J = 1,7
              LFFCAL(J,I)  = .FALSE.
            ENDDO
          ENDDO
        ELSEIF(FLAG5.EQ.'FLFAC') THEN
          FL_FAC = VAL
          DO I = 1,30
            LFFCAL(2,I)  = .FALSE.
          ENDDO
        ELSEIF(FLAG5.EQ.'SCAX0') THEN
          IF(VAL.LE.0.) THEN
            IERR = 3
            GOTO 500
          ENDIF
          SCAX0     = VAL
        ELSEIF(FLAG5.EQ.'SCAQ0') THEN
          IF(VAL.LE.0.) THEN
            IERR = 3
            GOTO 500
          ENDIF
          SCAQ0     = VAL
        ELSE
          IF(VAL.LE.0.) THEN
            IERR = 3
            GOTO 500
          ENDIF
C--       Invalidate all evolutions      
          CALL QNFALS(LEVDONE,MXX*10)
          LALFOK = .FALSE.   !force alpha_s to be recalculated
          IF    (FLAG5.EQ.'UMASS') THEN
            UDSCBT(1) = VAL
          ELSEIF(FLAG5.EQ.'DMASS') THEN
            UDSCBT(2) = VAL
          ELSEIF(FLAG5.EQ.'SMASS') THEN
            UDSCBT(3) = VAL
          ELSEIF(FLAG5.EQ.'CMASS') THEN
            UDSCBT(4) = VAL
            CBMSTF(4) = VAL
            CBMSTF(5) = VAL
            LWFCOK = .FALSE.  !invalidate F2C weight tables
            LWLCOK = .FALSE.  !invalidate FLC weight tables
          ELSEIF(FLAG5.EQ.'MCSTF') THEN
            CBMSTF(4) = VAL
            CBMSTF(5) = VAL
            LWFCOK = .FALSE.
            LWLCOK = .FALSE.
          ELSEIF(FLAG5.EQ.'MCALF') THEN
            UDSCBT(4) = VAL
          ELSEIF(FLAG5.EQ.'BMASS') THEN
            UDSCBT(5) = VAL
            CBMSTF(6) = VAL
            CBMSTF(7) = VAL
            LWFBOK = .FALSE.  !invalidate F2B weight tables
            LWLBOK = .FALSE.  !invalidate FLB weight tables
          ELSEIF(FLAG5.EQ.'MBSTF') THEN
            CBMSTF(6) = VAL
            CBMSTF(7) = VAL
            LWFBOK = .FALSE.
            LWLBOK = .FALSE.
          ELSEIF(FLAG5.EQ.'MBALF') THEN
            UDSCBT(5) = VAL
          ELSEIF(FLAG5.EQ.'MTALF') THEN
            UDSCBT(6) = VAL
          ELSEIF(FLAG5.EQ.'TMASS') THEN
            UDSCBT(6) = VAL
          ELSEIF(FLAG5.EQ.'ALFAS') THEN
            ALPHA0    = VAL
          ELSEIF(FLAG5.EQ.'ALFQ0') THEN
            Q0ALFA    = VAL
          ELSE
            IERR = 2
            GOTO 500
          ENDIF
        ENDIF
 
C     --------------------------
      ELSEIF(OPT1.EQ.'G') THEN !
C     --------------------------
 
        IF    (FLAG5.EQ.'SCAX0') THEN
          VAL = SCAX0
        ELSEIF(FLAG5.EQ.'SCAQ0') THEN
          VAL = SCAQ0
        ELSEIF(FLAG5.EQ.'AAM2H'.OR.FLAG5.EQ.'AATQ2') THEN
          VAL = AAM2H
        ELSEIF(FLAG5.EQ.'BBM2H'.OR.FLAG5.EQ.'PLUSB') THEN
          VAL = BBM2H
        ELSEIF(FLAG5.EQ.'AAM2L') THEN
          VAL = AAM2L
        ELSEIF(FLAG5.EQ.'BBM2L') THEN
          VAL = BBM2L
        ELSEIF(FLAG5.EQ.'AAAR2') THEN
          VAL = AAAR2
        ELSEIF(FLAG5.EQ.'BBBR2') THEN
          VAL = BBBR2
        ELSEIF(FLAG5.EQ.'FLFAC') THEN
          VAL = FL_FAC
        ELSEIF(FLAG5.EQ.'UMASS') THEN
          VAL = UDSCBT(1)
        ELSEIF(FLAG5.EQ.'DMASS') THEN
          VAL = UDSCBT(2)
        ELSEIF(FLAG5.EQ.'SMASS') THEN
          VAL = UDSCBT(3)
        ELSEIF(FLAG5.EQ.'CMASS') THEN
          VAL = UDSCBT(4)
        ELSEIF(FLAG5.EQ.'BMASS') THEN
          VAL = UDSCBT(5)
        ELSEIF(FLAG5.EQ.'TMASS') THEN
          VAL = UDSCBT(6)
        ELSEIF(FLAG5.EQ.'MCSTF') THEN
          VAL = CBMSTF(4)
        ELSEIF(FLAG5.EQ.'MBSTF') THEN
          VAL = CBMSTF(6)
        ELSEIF(FLAG5.EQ.'MCALF') THEN
          VAL = UDSCBT(4)
        ELSEIF(FLAG5.EQ.'MBALF') THEN
          VAL = UDSCBT(5)
        ELSEIF(FLAG5.EQ.'MTALF') THEN
          VAL = UDSCBT(6)
        ELSEIF(FLAG5.EQ.'ALFAS') THEN
          VAL = ALPHA0
        ELSEIF(FLAG5.EQ.'ALFQ0') THEN
          VAL = Q0ALFA
        ELSEIF(FLAG5.EQ.'TCHRM') THEN
          VAL = THRS34
        ELSEIF(FLAG5.EQ.'TBOTT') THEN
          VAL = THRS45
        ELSEIF(FLAG5.EQ.'XMINC') THEN
          VAL = XMICUT
        ELSEIF(FLAG5.EQ.'QMINC') THEN
          VAL = QMICUT
        ELSEIF(FLAG5.EQ.'QMAXC') THEN
          VAL = QMACUT
        ELSEIF(FLAG5.EQ.'ROOTS') THEN
          IF(RS2CUT.GE.0.) THEN
            VAL = SQRT(RS2CUT)
          ELSE
            VAL = RS2CUT
          ENDIF
        ELSEIF(FLAG5.EQ.'QMINA') THEN
          VAL = QMINAS
        ELSE
          IERR = 2
          GOTO 500
        ENDIF
 
C     ------
      ELSE !
C     ------
 
        IERR = 1
        GOTO 500
 
C     -------	
      ENDIF !
C     -------	
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNRVAL ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input OPT : '',A    )') OPT
      WRITE(6,'( ''       VAR : '',A    )') FLAG
      WRITE(6,'( ''       VAL : '',E12.5)') RVAL
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' OPT should be either SET or GET '')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Variable VAR not found'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' VAL should be .gt. 0  '')')
      ENDIF

      CALL QTRACE('QNRVAL ',1)

      STOP

      END

CDECK  ID>, QNRSET.
 
C     ============================
      SUBROUTINE QNRSET(FLAG,RVAL)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) FLAG

      CALL QTRACE('QNRSET ',0)

      CALL QNRVAL('SET',FLAG,RVAL)

      RETURN
      END

CDECK  ID>, QNRGET.
 
C     ============================
      SUBROUTINE QNRGET(FLAG,RVAL)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) FLAG

      CALL QTRACE('QNRGET ',0)

      CALL QNRVAL('GET',FLAG,RVAL)

      RETURN
      END
 
CDECK  ID>, QNLVAL.
 
C     ================================
      SUBROUTINE QNLVAL(OPT,FLAG,LVAL)
C     ================================

C---  QNLVAL: set/get logical variable.
C---  Called by user or internally by s/r QNLSET and QNLGET.
C---  Input parameters: 'OPT'   = 'Set' or 'Get'.
C---                    'FLAG'  = variable name to set or get.
C---                    'VAL' (logical) input or output variable.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT
      CHARACTER*1   OPT1
      CHARACTER*(*) FLAG
      CHARACTER*5   FLAG5
      LOGICAL       LVAL
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      IF(LENOCC_LHA(OPT).LT.1)  THEN
        IERR = 1
        GOTO 500
      ENDIF
      IF(LENOCC_LHA(FLAG).LT.5) THEN
        IERR = 2
        GOTO 500
      ENDIF
      OPT1   = OPT(1:1)
      FLAG5  = FLAG(1:5)
      CALL CLTOU_LHA(OPT1)
      CALL CLTOU_LHA(FLAG5)
 
C     ----------------------
      IF(OPT1.EQ.'S') THEN !
C     ----------------------
 
        IF    (FLAG5.EQ.'W1ANA' ) THEN
          LW1ANA = LVAL
          IF(LW1ANA) LW1NUM = .FALSE.
        ELSEIF(FLAG5.EQ.'W1NUM' ) THEN
          LW1NUM = LVAL
          IF(LW1NUM) LW1ANA = .FALSE.
        ELSEIF(FLAG5.EQ.'W2NUM' ) THEN
          LW2NUM = LVAL
        ELSEIF(FLAG5.EQ.'W2STF' ) THEN
          LW2STF = LVAL
        ELSEIF(FLAG5.EQ.'WTF2C' ) THEN
          LWF2C  = LVAL
        ELSEIF(FLAG5.EQ.'WTFLC' ) THEN
          LWFLC  = LVAL
        ELSEIF(FLAG5.EQ.'WTF2B' ) THEN
          LWF2B  = LVAL
        ELSEIF(FLAG5.EQ.'WTFLB' ) THEN
          LWFLB  = LVAL
        ELSEIF(FLAG5.EQ.'BMARK' ) THEN
          LBMARK = LVAL
          LALFOK = .FALSE.
        ELSEIF(FLAG5.EQ.'LIMCK' ) THEN
          LIMCK  = LVAL
        ELSEIF(FLAG5.EQ.'CLOWQ' ) THEN
          LCLOWQ = LVAL
        ELSEIF(FLAG5.EQ.'ASOLD' ) THEN
          LASOLD = LVAL
          LALFOK = .FALSE.
        ELSE
          IERR = 2
          GOTO 500
        ENDIF
 
C     --------------------------
      ELSEIF(OPT1.EQ.'G') THEN !
C     --------------------------
 
        IF    (FLAG5.EQ.'W1ANA' ) THEN
          LVAL = LW1ANA
        ELSEIF(FLAG5.EQ.'W1NUM' ) THEN
          LVAL = LW1NUM
        ELSEIF(FLAG5.EQ.'W2NUM' ) THEN
          LVAL = LW2NUM
        ELSEIF(FLAG5.EQ.'W2STF' ) THEN
          LVAL = LW2STF
        ELSEIF(FLAG5.EQ.'WTF2C' ) THEN
          LVAL = LWF2C
        ELSEIF(FLAG5.EQ.'WTFLC' ) THEN
          LVAL = LWFLC
        ELSEIF(FLAG5.EQ.'WTF2B' ) THEN
          LVAL = LWF2B
        ELSEIF(FLAG5.EQ.'WTFLB' ) THEN
          LVAL = LWFLB
        ELSEIF(FLAG5.EQ.'BMARK' ) THEN
          LVAL = LBMARK
        ELSEIF(FLAG5.EQ.'LIMCK' ) THEN
          LVAL = LIMCK 
        ELSEIF(FLAG5.EQ.'CLOWQ' ) THEN
          LVAL = LCLOWQ 
        ELSEIF(FLAG5.EQ.'ASOLD' ) THEN
          LVAL = LASOLD 
        ELSE
          IERR = 2
          GOTO 500
        ENDIF
 
C     ------
      ELSE !
C     ------
 
        IERR = 1
        GOTO 500
 
C     -------	
      ENDIF !
C     -------	
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNLVAL ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input OPT : '',A    )') OPT
      WRITE(6,'( ''       VAR : '',A    )') FLAG
      WRITE(6,'( ''       VAL : '',L2   )') LVAL
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' OPT should be either SET or GET '')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Variable VAR not found'')')
      ENDIF

      CALL QTRACE('QNLVAL ',1)

      STOP

      END

CDECK  ID>, QNLSET.
 
C     ============================
      SUBROUTINE QNLSET(FLAG,LVAL)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) FLAG
      LOGICAL       LVAL

      CALL QTRACE('QNLSET ',0)

      CALL QNLVAL('SET',FLAG,LVAL)

      RETURN
      END

CDECK  ID>, QNLGET.
 
C     ============================
      SUBROUTINE QNLGET(FLAG,LVAL)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) FLAG
      LOGICAL       LVAL

      CALL QTRACE('QNLGET ',0)

      CALL QNLVAL('GET',FLAG,LVAL)

      RETURN
      END
 
CDECK  ID>, GRMXMQ.
 
C     ============================
      SUBROUTINE GRMXMQ(NXMA,NQMA)
C     ============================

C---  GRMXMQ: return max allowed number of x, Q2 gridpoints.
C---  Called by user.
C---  MXX and MQ2 are set by parameter statement in common QCNXQM.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      CALL QTRACE('GRMXMQ ',0)
 
      NXMA = MXX-1
      NQMA = MQ2-1
 
      RETURN
      END
 
CDECK  ID>, GRGIVE.
 
C     ========================================
      SUBROUTINE GRGIVE(NX,XMI,XMA,NQ,QMI,QMA)
C     ========================================

C---  GRGIVE: return current grid definition.
C---  Called by user.
C---  Output variables: NX  (integer) number of x gridpoints.
C---                    XMI (real or d.p.) lowest x value.
C---                    XMA (real or d.p.) highest x value = 1.
C---                    NQ  (integer) number of Q2 gridpoints.
C---                    QMI (real or d.p.) lowest Q2 value.
C---                    QMA (real or d.p.) highest Q2 value.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      CALL QTRACE('GRGIVE ',0)
 
      NX  = NXX
      XMI = XXTAB(1)
      XMA = XXTAB(NXX+1)
      NQ  = NQ2
      QMI = Q2TAB(1)
      QMA = Q2TAB(NQ2)
 
      RETURN
      END
 
CDECK  ID>, GRXNUL.
 
C     =================
      SUBROUTINE GRXNUL
C     =================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('GRXNUL ',0)
 
C---  Invalidate weight tables (validated by call to QNFILW)
      LWT1OK = .FALSE.
      LWT2OK = .FALSE.
      LWTFOK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)
 
C---  Set grid to zero
      CALL QNVNUL(XXTAB,MXX)
      CALL QNVNUL(XHTAB,MXX)
      CALL QNINUL(IHTAB,MXX)
      NXX    = 0
      NGRVER = 0

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT
 

      RETURN
      END
 
CDECK  ID>, GRXINP.
 
C     ============================
      SUBROUTINE GRXINP(XARRAY,NX)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      DIMENSION XARRAY(*)
 
      DATA EPSI /1.E-6/

      CALL QTRACE('GRXINP ',0)
 
      IF(NX.LE.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF((NX+NXX).GT.MXX-1) THEN
        IERR = 2
        GOTO 500
      ENDIF

C---  Invalidate weight tables (validated by call to QNFILW)
      LWT1OK = .FALSE.
      LWT2OK = .FALSE.
      LWTFOK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

C---  if this number changes, QCDNUM knows that the grid has changed
      NGRVER = NGRVER + 1
 
      IF(NXX.EQ.0) THEN
        DO 10 IX = 1,NX
          X = XARRAY(IX)
          IF(X.LE.0..OR.X.GT.1.) THEN
            IERR = 3
            GOTO 500
          ENDIF
          NXX    = NXX+1
          XXTAB(IX) = X
  10    CONTINUE
        IF(XXTAB(NXX).EQ.1.) THEN
          NXX = NXX-1
        ELSE
          XXTAB(NXX+1) = 1.
        ENDIF
        RETURN
      ENDIF
 
      IF(XXTAB(NXX).EQ.1.) THEN
        NXX = NXX-1
      ELSE
        XXTAB(NXX+1) = 1.
      ENDIF
 
      NXP = NXX+1
 
      DO 100 IX = 1,NX
 
        X = XARRAY(IX)
 
        IF(X.LE.0..OR.X.GT.1.) THEN
          IERR = 3
          GOTO 500
        ENDIF
 
*mb     IF(X.LT.XXTAB(1)-EPSI) THEN
        IF(X/XXTAB(1).LT.1.-EPSI) THEN
 
          DO 20 JX = NXP,1,-1
            XXTAB(JX+1) = XXTAB(JX)
  20      CONTINUE
          NXP    = NXP+1
          XXTAB(1)  = X
 
*mb     ELSEIF(X.GT.XXTAB(NXP)+EPSI) THEN
        ELSEIF(X/XXTAB(NXP).GT.1.+EPSI) THEN
 
          NXP    = NXP+1
          XXTAB(NXP) = X
 
        ELSE
 
          DO 30 I = 1,NXP
*mb         IF(XXTAB(I).LE.X+EPSI) IX0 = I
            IF(XXTAB(I)/X.LE.1.+EPSI) IX0 = I
  30      CONTINUE
 
*mb       IF(ABS(XXTAB(IX0)-X).LE.EPSI) THEN
          IF(ABS(XXTAB(IX0)/X-1.).LE.EPSI) THEN
            XXTAB(IX0) = X
          ELSE
            DO 40 JX = NXP,IX0+1,-1
              XXTAB(JX+1) = XXTAB(JX)
  40        CONTINUE
            NXP = NXP+1
            XXTAB(IX0+1) = X
          ENDIF
 
        ENDIF
 
 100  CONTINUE
 
      IF(XXTAB(NXP).EQ.1.) THEN
        NXX = NXP-1
      ELSE
        NXX = NXP
        XXTAB(NXX+1) = 1.
      ENDIF

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT

C---  Update heavy quark xgrid
      CALL GXHDEF
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r GRXINP ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input X  :'',E12.5)') X
      WRITE(6,'( ''       NX :'',I5   )') NX
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' NX must be .ge. 1'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Maximum number of gridpoints exceeded '')')
        WRITE(6,'(/'' # existing x  gridpoints ='',I5/
     +             '' # points to be added     ='',I5/
     +             '' maximum # points allowed ='',I5)')
     +                NXX, NX, MXX-1
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Value of X outside allowed range (0,1]'')')
      ENDIF

      CALL QTRACE('GRXINP ',1)

      STOP

      END
 
CDECK  ID>, GRXDEF.
 
C     ==========================
      SUBROUTINE GRXDEF(NX,XMIN)
C     ==========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('GRXDEF ',0)
 
      IF(NX.LE.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF(NX.GT.MXX-1) THEN
        IERR = 2
        GOTO 500
      ENDIF
 
      IF(XMIN.LE.0.OR.XMIN.GE.1.) THEN
        IERR = 3
        GOTO 500
      ENDIF

C---  Invalidate weight tables (validated by call to QNFILW)
      LWT1OK = .FALSE.
      LWT2OK = .FALSE.
      LWTFOK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

C---  if this number changes, QCDNUM knows that the grid has changed
      NGRVER = NGRVER + 1
 
      XMAX = 1.
      YMIN = SYFROMX(XMIN)
      YMAX = SYFROMX(XMAX)
      BW   = (YMAX-YMIN)/NX
      DO I = 1,NX
        YI = YMIN+(I-1)*BW
        XXTAB(I) = SXFROMY(YI)
      ENDDO
      XXTAB(1)    = XMIN
      XXTAB(NX+1) = 1.
      NXX         = NX

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT

C---  Update heavy quark xgrid
      CALL GXHDEF
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r GRXDEF ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NX    :'',I5   )') NX
      WRITE(6,'( ''       Xmin  :'',E12.5)') XMIN
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' NX must be .ge. 1'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' NX > max number of gridpoints'',
     +             '' allowed:'',I5)') MXX-1
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Xmin outside allowed range (0,1]'')')
      ENDIF

      CALL QTRACE('GRXDEF ',1)

      STOP

      END
 
CDECK  ID>, GRXLIM.
 
C     ==========================
      SUBROUTINE GRXLIM(NX,XMIN)
C     ==========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      DATA EPSI / 1.E-6 /

      CALL QTRACE('GRXLIM ',0)
 
      IF(NX.LE.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF(NX.GT.MXX-1) THEN
        IERR = 2
        GOTO 500
      ENDIF

C---  Invalidate weight tables (validated by call to QNFILW)
      LWT1OK = .FALSE.
      LWT2OK = .FALSE.
      LWTFOK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)
 
      IF(XMIN.LE.0.OR.XMIN.GE.1.) THEN
        IERR = 3
        GOTO 500
      ENDIF

C---  if this number changes, QCDNUM knows that the grid has changed
      NGRVER = NGRVER + 1
 
      IF(NXX.EQ.0) THEN
        XXTAB(1) = 1.
      ELSEIF(XXTAB(NXX).EQ.1.) THEN
        NXX = NXX-1
      ELSE
        XXTAB(NXX+1) = 1.
      ENDIF
 
      NXP = NXX+1
 
*mb   IF(XMIN.LT.XXTAB(1)-EPSI) THEN
      IF(XMIN/XXTAB(1).LT.1.-EPSI) THEN
        DO 20 IX = NXP,1,-1
          XXTAB(IX+1) = XXTAB(IX)
  20    CONTINUE
        NXP   = NXP+1
        XXTAB(1) = XMIN
      ENDIF
 
      IF(NX.GT.NXP-1) THEN
  30    CONTINUE
        GAPMAX = 0.
        DO 35 IX = 1,NXP-1
          GAP = SYFROMX(XXTAB(IX+1))-SYFROMX(XXTAB(IX))
          IF(GAP.GT.GAPMAX) THEN
            GAPMAX = GAP
            IX0    = IX
          ENDIF
  35    CONTINUE
        DO 40 IX = NXP,IX0+1,-1
          XXTAB(IX+1) = XXTAB(IX)
  40    CONTINUE
        NXP = NXP+1
        XXTAB(IX0+1) = 0.5*(XXTAB(IX0)+XXTAB(IX0+2))
        IF(NXP-1.LT.NX) GOTO 30
 
      ELSEIF(NX.LT.NXP-1) THEN
  50    CONTINUE
        GAPMIN = 999999.
        DO 55 IX = 2,NXP-1
          GAP = SYFROMX(XXTAB(IX+1))-SYFROMX(XXTAB(IX-1))
          IF(GAP.LE.GAPMIN) THEN
            GAPMIN = GAP
            IX0    = IX
          ENDIF
  55    CONTINUE
        DO 60 IX = IX0,NXP-1
          XXTAB(IX) = XXTAB(IX+1)
  60    CONTINUE
        XXTAB(NXP) = 0.
        NXP = NXP-1
        IF(NXP-1.GT.NX) GOTO 50
      ENDIF
 
      IF(XXTAB(NXP).EQ.1.) THEN
        NXX = NXP-1
      ELSE
        NXX = NXP
        XXTAB(NXX+1) = 1.
      ENDIF

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT

C---  Update heavy quark xgrid
      CALL GXHDEF
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r GRXLIM ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NX    :'',I5   )') NX
      WRITE(6,'( ''       Xmin  :'',E12.5)') XMIN
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' NX must be .ge. 1'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' NX > max number of gridpoints'',
     +             '' allowed:'',I5)') MXX-1
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Xmin outside allowed range (0,1]'')')
      ENDIF

      CALL QTRACE('GRXLIM ',1)

      STOP

      END
 
CDECK  ID>, GXHDEF.
 
C     =================
      SUBROUTINE GXHDEF
C     =================

C--   Create a purely logarithmic grid in x (XHTAB) for use 
C--   in the heavy quark structure function calculations.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      IF(NXX.EQ.0.OR.NXX.GE.MXX)           RETURN
      IF(XXTAB(1).LE.0..OR.XXTAB(1).GE.1.) RETURN

      XL1 = LOG(XXTAB(1))
      XL2 = 0.
      BW  = (XL2-XL1)/NXX

      DO IX = 1,NXX
        XL = XL1 + (IX-1)*BW
        XHTAB(IX) = EXP(XL)
        IHTAB(IX) = ABS(IXFROMX(XHTAB(IX)))
      ENDDO
      XHTAB(NXX+1) = 1.
      IHTAB(NXX+1) = NXX+1

      RETURN
      END
 

CDECK  ID>, SYFROMX.
 
C     ====================================
      DOUBLE PRECISION FUNCTION SYFROMX(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      IF(X.LE.SCAX0) THEN
        SYFROMX = LOG(X)
      ELSE
        SYFROMX = LOG(SCAX0) + (X-SCAX0)/SCAX0
      ENDIF
 
      RETURN
      END

CDECK  ID>, SXFROMY.
 
C     ====================================
      DOUBLE PRECISION FUNCTION SXFROMY(Y)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      IF(Y.LE.LOG(SCAX0)) THEN
        SXFROMY = EXP(Y)
      ELSE
        SXFROMY = (Y-LOG(SCAX0)+1.) * SCAX0
      ENDIF
 
      RETURN
      END
 
CDECK  ID>, GRXOUT.
 
C     =========================
      SUBROUTINE GRXOUT(XARRAY)
C     =========================

C---  Copy XXTAB to XARRAY which should have been dimensioned
C---  to at least NXX+1 by the user.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      DIMENSION XARRAY(*)

      CALL QTRACE('GRXOUT ',0)
 
      DO 10 IX = 1,NXX+1
        XARRAY(IX) = XXTAB(IX)
  10  CONTINUE
 
      RETURN
      END
 
CDECK  ID>, LOGXGR.
 
C     ===============================
      LOGICAL FUNCTION LOGXGR(IDUMMY)
C     ===============================

C---  Figure out if xgrid is purely logarithmic
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      REAL    RAT1,RAT
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      LOGXGR = .FALSE.

      IF(NXX.LE.0) RETURN

      RAT1   = XXTAB(2)/XXTAB(1)
      LOGXGR = .TRUE.
      DO IX = 1,NXX
        RAT = XXTAB(IX+1)/XXTAB(IX)
        IF(RAT.NE.RAT1) LOGXGR = .FALSE.
      ENDDO

      RETURN
      END
 
CDECK  ID>, GRQNUL.
 
C     =================
      SUBROUTINE GRQNUL
C     =================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('GRQNUL ',0)
 
C---  Invalidate weight tables (validated by call to QNFILW)
      LALFOK = .FALSE.
      LDQ2OK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)
 
C---  Set grid to zero
      CALL QNVNUL(Q2TAB,MQ2)
      NQ2    = 0
      NGRVER = 0

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT
 

      RETURN
      END
 
CDECK  ID>, GRQINP.
C
C     ============================
      SUBROUTINE GRQINP(QARRAY,NQ)
C     ============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      DIMENSION QARRAY(*)
 
      DATA EPSI /1.E-6/

      CALL QTRACE('GRQINP ',0)
 
      IF(NQ.LE.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF((NQ+NQ2).GT.MQ2-1) THEN
        IERR = 2
        GOTO 500
      ENDIF

C---  Invalidate weight tables (validated by call to QNFILW)
      LALFOK = .FALSE.
      LDQ2OK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

C---  if this number changes, QCDNUM knows that the grid has changed
      NGRVER = NGRVER + 1
 
      IF(NQ2.EQ.0) THEN
        DO 10 IQ = 1,NQ
          Q = QARRAY(IQ)
          IF(Q.LE.0.) THEN
            IERR = 3
            GOTO 500
          ENDIF
          NQ2    = NQ2+1
          Q2TAB(IQ) = Q
  10    CONTINUE
        RETURN
      ENDIF
 
      DO 100 IQ = 1,NQ
 
        Q = QARRAY(IQ)
 
        IF(Q.LE.0.) THEN
          IERR = 3
          GOTO 500
        ENDIF
 
*mb     IF(Q.LT.Q2TAB(1)-EPSI) THEN
        IF(Q/Q2TAB(1).LT.1.-EPSI) THEN
 
          DO 20 JQ = NQ2,1,-1
            Q2TAB(JQ+1) = Q2TAB(JQ)
  20      CONTINUE
          NQ2    = NQ2+1
          Q2TAB(1)  = Q
 
*mb     ELSEIF(Q.GT.Q2TAB(NQ2)+EPSI) THEN
        ELSEIF(Q/Q2TAB(NQ2).GT.1.+EPSI) THEN
 
          NQ2    = NQ2+1
          Q2TAB(NQ2) = Q
 
        ELSE
 
          DO 30 I = 1,NQ2
*mb         IF(Q2TAB(I).LE.Q+EPSI) IQ0 = I
            IF(Q2TAB(I)/Q.LE.1.+EPSI) IQ0 = I
  30      CONTINUE
 
*mb       IF(ABS(Q2TAB(IQ0)-Q).LE.EPSI) THEN
          IF(ABS(Q2TAB(IQ0)/Q-1.).LE.EPSI) THEN
            Q2TAB(IQ0) = Q
          ELSE
            DO 40 JQ = NQ2,IQ0+1,-1
              Q2TAB(JQ+1) = Q2TAB(JQ)
  40        CONTINUE
            NQ2 = NQ2+1
            Q2TAB(IQ0+1) = Q
          ENDIF
 
        ENDIF
 
 100  CONTINUE

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r GRQINP ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input Q2 :'',E12.5)') Q
      WRITE(6,'( ''       NQ :'',I5   )') NQ
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' NQ must be .ge. 1'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Maximum number of gridpoints exceeded '')')
        WRITE(6,'(/'' # existing Q2 gridpoints ='',I5/
     +             '' # points to be added     ='',I5/
     +             '' maximum # points allowed ='',I5)')
     +                NQ2, NQ, MQ2-1
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Value of Q2 outside allowed range > 0'')')
      ENDIF

      CALL QTRACE('GRQINP ',1)

      STOP

      END
 
CDECK  ID>, GRQDEF.
 
C     ===============================
      SUBROUTINE GRQDEF(NQ,QMIN,QMAX)
C     ===============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      CALL QTRACE('GRQDEF ',0)
 
      IF(NQ.LE.1) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF(NQ.GT.MQ2-1) THEN
        IERR = 2
        GOTO 500
      ENDIF
 
      IF(QMIN.LE.0.OR.QMAX.LE.0.OR.QMIN.GE.QMAX) THEN
        IERR = 3
        GOTO 500
      ENDIF

C---  Invalidate weight tables (validated by call to QNFILW)
      LALFOK = .FALSE.
      LDQ2OK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)
 
C---  if this number changes, QCDNUM knows that the grid has changed
      NGRVER = NGRVER + 1
 
      YMIN = SYFROMQ(QMIN)
      YMAX = SYFROMQ(QMAX)
      BW   = (YMAX-YMIN)/(NQ-1)
      DO I = 1,NQ
        YI = YMIN+(I-1)*BW
        Q2TAB(I) = SQFROMY(YI)
      ENDDO   
      Q2TAB(1)  = QMIN
      Q2TAB(NQ) = QMAX
      NQ2       = NQ

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r GRQDEF ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NQ    :'',I5   )') NQ
      WRITE(6,'( ''       Q2min :'',E12.5)') QMIN
      WRITE(6,'( ''       Q2max :'',E12.5)') QMAX
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' NQ must be .ge. 2'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' NQ > max number of gridpoints'',
     +             '' allowed:'',I5)') MQ2-1
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Qmin and/or Qmax .le. 0 or Qmin .ge. Qmax'')')
      ENDIF

      CALL QTRACE('GRQDEF ',1)

      STOP

      END
 
CDECK  ID>, GRQLIM.
 
C     ===============================
      SUBROUTINE GRQLIM(NQ,QMIN,QMAX)
C     ===============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      DATA EPSI /1.E-6/

      CALL QTRACE('GRQLIM ',0)
 
      IF(NQ.LE.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF(NQ.GT.MQ2-1) THEN
        IERR = 2
        GOTO 500
      ENDIF

C---  Invalidate weight tables (validated by call to QNFILW)
      LALFOK = .FALSE.
      LDQ2OK = .FALSE.
      LWFCOK = .FALSE.
      LWLCOK = .FALSE.
      LWFBOK = .FALSE.
      LWLBOK = .FALSE.
      LMARK  = .FALSE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)
 
C---  if this number changes, QCDNUM knows that the grid has changed
      NGRVER = NGRVER + 1
 
      IF(NQ2.EQ.0) THEN
 
        IF(QMIN.LE.0..OR.QMAX.LE.0..OR.QMIN.GE.QMAX) THEN
          IERR = 3
          GOTO 500
        ENDIF
 
        CALL GRQDEF(NQ,QMI,QMA)
 
      ELSE
 
        IF(QMIN.LE.0..OR.QMAX.LE.0..OR.QMIN.GE.QMAX) THEN
          IERR = 3
          GOTO 500
        ENDIF
 
*mb     IF(QMIN.LT.Q2TAB(1)-EPSI) THEN
        IF(QMIN/Q2TAB(1).LT.1.-EPSI) THEN
          DO 20 IQ = NQ2,1,-1
            Q2TAB(IQ+1) = Q2TAB(IQ)
  20      CONTINUE
          NQ2      = NQ2+1
          Q2TAB(1) = QMIN
        ENDIF
*mb     IF(QMAX.GT.Q2TAB(NQ2)+EPSI) THEN
        IF(QMAX/Q2TAB(NQ2).GT.1.+EPSI) THEN
          NQ2        = NQ2+1
          Q2TAB(NQ2) = QMAX
        ENDIF
 
        IF(NQ.GT.NQ2) THEN
  30      CONTINUE
          GAPMAX = 0.
          DO 35 IQ = 1,NQ2-1
            GAP = SYFROMQ(Q2TAB(IQ+1))-SYFROMQ(Q2TAB(IQ))
            IF(GAP.GT.GAPMAX) THEN
              GAPMAX = GAP
              IQ0    = IQ
            ENDIF
  35      CONTINUE
          DO 40 IQ = NQ2,IQ0+1,-1
            Q2TAB(IQ+1) = Q2TAB(IQ)
  40      CONTINUE
          NQ2 = NQ2+1
          Q2TAB(IQ0+1) = SQRT(Q2TAB(IQ0)*Q2TAB(IQ0+2))
          IF(NQ2.LT.NQ) GOTO 30
 
        ELSEIF(NQ.LT.NQ2) THEN
  50      CONTINUE
          GAPMIN = 999999.
          DO 55 IQ = 2,NQ2-1
            GAP = SYFROMQ(Q2TAB(IQ+1))-SYFROMQ(Q2TAB(IQ-1))
            IF(GAP.LE.GAPMIN) THEN
              GAPMIN = GAP
              IQ0    = IQ
            ENDIF
  55      CONTINUE
          DO 60 IQ = IQ0,NQ2-1
            Q2TAB(IQ) = Q2TAB(IQ+1)
  60      CONTINUE
          Q2TAB(NQ2) = 0.
          NQ2 = NQ2-1
          IF(NQ2.GT.NQ) GOTO 50
        ENDIF
 
      ENDIF

C---  Update IFAILC
      CALL GRSETC

C---  Update NFMAP
      CALL QNSETT
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r GRQLIM ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NQ    :'',I5   )') NQ
      WRITE(6,'( ''       Q2min :'',E12.5)') QMIN
      WRITE(6,'( ''       Q2max :'',E12.5)') QMAX
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' NQ must be .ge. 1'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' NQ > max number of gridpoints'',
     +             '' allowed:'',I5)') MQ2-1
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Qmin and/or Qmax .le. 0 or Qmin .ge. Qmax'')')
      ENDIF

      CALL QTRACE('GRQLIM ',1)

      STOP

      END

CDECK  ID>, SYFROMQ.
 
C     ====================================
      DOUBLE PRECISION FUNCTION SYFROMQ(Q)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      IF(Q.LE.SCAQ0) THEN
        SYFROMQ = LOG(Q)
      ELSE
        SYFROMQ = LOG(SCAQ0) + (Q-SCAQ0)/SCAQ0
      ENDIF
 
      RETURN
      END

CDECK  ID>, SQFROMY.
 
C     ====================================
      DOUBLE PRECISION FUNCTION SQFROMY(Y)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      IF(Y.LE.LOG(SCAQ0)) THEN
        SQFROMY = EXP(Y)
      ELSE
        SQFROMY = (Y-LOG(SCAQ0)+1.) * SCAQ0
      ENDIF
 
      RETURN
      END
 
 
CDECK  ID>, GRQOUT.
 
C     =========================
      SUBROUTINE GRQOUT(QARRAY)
C     =========================

C---  Copy Q2TAB to QARRAY which should have been dimensioned
C---  to at least NQ2 by the user.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      DIMENSION QARRAY(*)

      CALL QTRACE('GRQOUT ',0)
 
      DO 10 IQ = 1,NQ2
        QARRAY(IQ) = Q2TAB(IQ)
  10  CONTINUE
 
      RETURN
      END

CDECK  ID>, IXFROMX.
 
C     ===========================
      INTEGER FUNCTION IXFROMX(X)
C     ===========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C---  Returns gridindex IX given a value for X.
C---  If X is outside the current gridboundary then IXFROMX = 0.
C---  If X corresponds to gridindex IX  then IXFROMX = IX.
C---  If X lies above IX and below IX+1 then IXFROMX = -IX.

C---  NB: X and XXTAB are different only if |X-XXTAB| < epsi.
C---  NB: If since the previous call the grid did not change
C---      (i.e. NGRVER is the same) and if X did not change, then
C---      IXFROMX just returns the result of the previous call.
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      SAVE XLAST,IXLAST,NGLAST
 
      DATA XLAST  / 0. /
      DATA IXLAST / 0 /
      DATA NGLAST / 0 /
      DATA EPSI   /1.E-6/

*     CALL QTRACE('IXFROMX',0)
 
      IF(X.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN
        IXFROMX = IXLAST
        RETURN
      ENDIF
 
      IX      = 0
      IXLAST  = 0
      NGLAST  = NGRVER
      XLAST   = X
      IXFROMX = 0

      IF(X.GT.1..OR.NXX.LE.0)   RETURN
      IF(X/XXTAB(1).LT.1.-EPSI) RETURN

      DO 10 I = 1,NXX
*mb     IF(XXTAB(I).LE.X+EPSI) IX = I
        IF(XXTAB(I)/X.LE.1.+EPSI) IX = I
  10  CONTINUE
 
*mb   IF(ABS(XXTAB(IX)-X).LE.EPSI) THEN
      IF(ABS(XXTAB(IX)/X-1.).LE.EPSI) THEN
        IXFROMX = IX
        IXLAST  = IX
      ELSE
        IXFROMX = -IX
        IXLAST  = -IX
      ENDIF
 
      RETURN
      END

C------------------------------------------------

*-      REAL XR,X1,X2,XLAST
*- 
*-+SEQ,QCNXQM.
*-+SEQ,QCGRID.
*- 
*-      SAVE XLAST,IXLAST,NGLAST
*- 
*-      DATA XLAST  / 0. /
*-      DATA IXLAST / 0 /
*-      DATA NGLAST / 0 /
*-
*-*     CALL QTRACE('IXFROMX',0)
*- 
*-      XR = X
*-      IF(XR.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN
*-        IXFROMX = IXLAST
*-        RETURN
*-      ENDIF
*- 
*-      IX      = 0
*-      IXLAST  = 0
*-      NGLAST  = NGRVER
*-      XLAST   = X
*-      IXFROMX = 0
*-
*-      IF(XR.GT.1..OR.NXX.LE.0)   RETURN
*-      X1 = XXTAB(1)
*-      IF(XR.LT.X1)               RETURN
*-
*-      DO IX = 1,NXX
*-        X2 = XXTAB(IX+1)
*-        IF(X1.LE.XR.AND.XR.LT.X2) THEN
*-          IXFROMX = -IX
*-          IF(X1.EQ.XR) IXFROMX = IX
*-          IXLAST = IX
*-          RETURN
*-        ENDIF
*-        X1 = X2
*-      ENDDO
*- 
*-      RETURN
*-      END

CDECK  ID>, IHFROMH.
 
C     ===========================
      INTEGER FUNCTION IHFROMH(X)
C     ===========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C---  Returns gridindex IX of heavy quark grid given a value for X.
C---  If X is outside the current gridboundary then IHFROMH = 0.
C---  If X corresponds to gridindex IX  then IHFROMH = IX.
C---  If X lies above IX and below IX+1 then IHFROMH = -IX.

C---  NB: X and XHTAB are different only if |X-XHTAB| < epsi.
C---  NB: If since the previous call the grid did not change
C---      (i.e. NGRVER is the same) and if X did not change, then
C---      IHFROMH just returns the result of the previous call.
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      SAVE XLAST,IXLAST,NGLAST
 
      DATA XLAST  / 0. /
      DATA IXLAST / 0 /
      DATA NGLAST / 0 /
      DATA EPSI   /1.E-6/

*     CALL QTRACE('IHFROMH',0)
 
      IF(X.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN
        IHFROMH = IXLAST
        RETURN
      ENDIF
 
      IX      = 0
      IXLAST  = 0
      NGLAST  = NGRVER
      XLAST   = X
      IHFROMH = 0

      IF(X.GT.1..OR.NXX.LE.0)   RETURN
      IF(X/XHTAB(1).LT.1.-EPSI) RETURN

      DO 10 I = 1,NXX
*mb     IF(XHTAB(I).LE.X+EPSI) IX = I
        IF(XHTAB(I)/X.LE.1.+EPSI) IX = I
  10  CONTINUE
 
*mb   IF(ABS(XHTAB(IX)-X).LE.EPSI) THEN
      IF(ABS(XHTAB(IX)/X-1.).LE.EPSI) THEN
        IHFROMH = IX
        IXLAST  = IX
      ELSE
        IHFROMH = -IX
        IXLAST  = -IX
      ENDIF
 
      RETURN
      END

C------------------------------------------------

*-      REAL XR,X1,X2,XLAST
*- 
*-+SEQ,QCNXQM.
*-+SEQ,QCGRID.
*- 
*-      SAVE XLAST,IXLAST,NGLAST
*- 
*-      DATA XLAST  / 0. /
*-      DATA IXLAST / 0 /
*-      DATA NGLAST / 0 /
*-
*-*     CALL QTRACE('IXFROMX',0)
*- 
*-      XR = X
*-      IF(XR.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN
*-        IXFROMX = IXLAST
*-        RETURN
*-      ENDIF
*- 
*-      IX      = 0
*-      IXLAST  = 0
*-      NGLAST  = NGRVER
*-      XLAST   = X
*-      IXFROMX = 0
*-
*-      IF(XR.GT.1..OR.NXX.LE.0)   RETURN
*-      X1 = XHTAB(1)
*-      IF(XR.LT.X1)               RETURN
*-
*-      DO IX = 1,NXX
*-        X2 = XHTAB(IX+1)
*-        IF(X1.LE.XR.AND.XR.LT.X2) THEN
*-          IXFROMX = -IX
*-          IF(X1.EQ.XR) IXFROMX = IX
*-          IXLAST = IX
*-          RETURN
*-        ENDIF
*-        X1 = X2
*-      ENDDO
*- 
*-      RETURN
*-      END

CDECK  ID>, IXNEARX.
 
C     ===========================
      INTEGER FUNCTION IXNEARX(X)
C     ===========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C---  Returns closest gridindex IX given a value for X.
C---  If X is outside the current gridboundary then IXNEARX = 0.
C---  If X corresponds to gridindex IX  then IXNEARX = IX.
C---  If X lies above IX and below IX+1 then IXNEARX = -IX or -IX-1.

C---  NB: X and XXTAB are different only if |X-XXTAB| < epsi.
C---  NB: If since the previous call the grid did not change
C---      (i.e. NGRVER is the same) and if X did not change, then
C---      IXNEARX just returns the result of the previous call.
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      SAVE XLAST,IXLAST,NGLAST
 
      DATA XLAST  / 0. /
      DATA IXLAST / 0 /
      DATA NGLAST / 0 /
      DATA EPSI   /1.E-6/

*     CALL QTRACE('IXNEARX',0)
 
      IF(X.EQ.XLAST.AND.NGRVER.EQ.NGLAST) THEN
        IXNEARX = IXLAST
        RETURN
      ENDIF
 
      IX      = 0
      IXLAST  = 0
      NGLAST  = NGRVER
      XLAST   = X
      IXNEARX = 0

      IF(X.GT.1..OR.NXX.LE.0)   RETURN
      IF(X/XXTAB(1).LT.1.-EPSI) RETURN

      DO 10 I = 1,NXX
*mb     IF(XXTAB(I).LE.X+EPSI) IX = I
        IF(XXTAB(I)/X.LE.1.+EPSI) IX = I
  10  CONTINUE
 
*mb   IF(ABS(XXTAB(IX)-X).LE.EPSI) THEN
      IF(ABS(XXTAB(IX)/X-1.).LE.EPSI) THEN
        IXNEARX = IX
        IXLAST  = IX
      ELSE
        GAP     = SYFROMX(XXTAB(IX+1))-SYFROMX(XXTAB(IX))
        DEL     = SYFROMX(X)-SYFROMX(XXTAB(IX))
        IF(DEL/GAP.LE.0.5) THEN
          IXNEARX = -IX
        ELSE
          IXNEARX = -MIN(IX+1,NXX)
        ENDIF
        IXLAST  = IXNEARX
      ENDIF
 
      RETURN
      END

CDECK  ID>, IQFROMQ.
 
C     ===========================
      INTEGER FUNCTION IQFROMQ(Q)
C     ===========================

C---  Returns gridindex IQ given a value for Q.
C---  If Q is outside the current gridboundary then IQFROMQ = 0.
C---  If Q corresponds to gridindex IQ  then IQFROMQ = IQ.
C---  If Q lies above IQ and below IQ+1 then IQFROMQ = -IQ.

C---  NB: Q and Q2TAB are different only if |Q-Q2TAB| < epsi.
C---  NB: If since the previous call the grid did not change
C---      (i.e. NGRVER is the same) and if Q did not change, then
C---      IQFROMQ just returns the result of the previous call.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      SAVE QLAST,IQLAST,NGLAST
 
      DATA QLAST  / 0. /
      DATA IQLAST / 0 /
      DATA NGLAST / 0 /
      DATA EPSI   /1.E-6/

*     CALL QTRACE('IQFROMQ',0)
 
      IF(Q.EQ.QLAST.AND.NGRVER.EQ.NGLAST) THEN
        IQFROMQ = IQLAST
        RETURN
      ENDIF
 
      IQ      = 0
      IQLAST  = 0
      NGLAST  = NGRVER
      QLAST   = Q
      IQFROMQ = 0

      IF(NQ2.EQ.0)                RETURN
      IF(Q/Q2TAB(1).LT.1.-EPSI)   RETURN
      IF(Q/Q2TAB(NQ2).GT.1.+EPSI) RETURN

      DO 10 I = 1,NQ2
*mb   IF(Q2TAB(I).LE.Q+EPSI) IQ = I
      IF(Q2TAB(I)/Q.LE.1.+EPSI) IQ = I
  10  CONTINUE
 
*mb   IF(ABS(Q2TAB(IQ)-Q).LE.EPSI) THEN
      IF(ABS(Q2TAB(IQ)/Q-1.).LE.EPSI) THEN
        IQFROMQ = IQ
        IQLAST  = IQ
      ELSE
        IQFROMQ = -IQ
        IQLAST  = -IQ
      ENDIF
 
      RETURN
      END

C------------------------------------------------

*-      REAL QR,Q1,Q2,QLAST
*- 
*-+SEQ,QCNXQM.
*-+SEQ,QCGRID.
*- 
*-      SAVE QLAST,IQLAST,NGLAST
*- 
*-      DATA QLAST  / 0. /
*-      DATA IQLAST / 0 /
*-      DATA NGLAST / 0 /
*-
*-*     CALL QTRACE('IQFROMQ',0)
*- 
*-      QR = Q
*-      IF(QR.EQ.QLAST.AND.NGRVER.EQ.NGLAST) THEN
*-        IQFROMQ = IQLAST
*-        RETURN
*-      ENDIF
*- 
*-      IQ      = 0
*-      IQLAST  = 0
*-      NGLAST  = NGRVER
*-      QLAST   = Q
*-      IQFROMQ = 0
*-
*-
*-      IF(NQ2.LE.0)   RETURN
*-      Q1 = Q2TAB(1)
*-      IF(QR.LT.Q1)   RETURN
*-      Q2 = Q2TAB(NQ2)
*-      IF(QR.GT.Q2)   RETURN
*-      IF(QR.EQ.Q2)   THEN
*-        IQFROMQ = NQ2
*-        IQLAST  = NQ2
*-        RETURN
*-      ENDIF
*-
*-      DO IQ = 1,NQ2-1
*-        Q2 = Q2TAB(IQ+1)
*-        IF(Q1.LE.QR.AND.QR.LT.Q2) THEN
*-          IQFROMQ = -IQ
*-          IF(Q1.EQ.QR) IQFROMQ = IQ
*-          IQLAST = IQ
*-          RETURN
*-        ENDIF
*-        Q1 = Q2
*-      ENDDO
*- 
*-      RETURN
*-      END

CDECK  ID>, IQNEARQ.
 
C     ===========================
      INTEGER FUNCTION IQNEARQ(Q)
C     ===========================

C---  Returns closest gridindex IQ given a value for Q.
C---  If Q is outside the current gridboundary then IQNEARQ = 0.
C---  If Q corresponds to gridindex IQ  then IQNEARQ = IQ.
C---  If Q lies above IQ and below IQ+1 then IQNEARQ = -IQ or -IQ-1.

C---  NB: Q and Q2TAB are different only if |Q-Q2TAB| < epsi.
C---  NB: If since the previous call the grid did not change
C---      (i.e. NGRVER is the same) and if Q did not change, then
C---      IQNEARQ just returns the result of the previous call.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      SAVE QLAST,IQLAST,NGLAST
 
      DATA QLAST  / 0. /
      DATA IQLAST / 0 /
      DATA NGLAST / 0 /
      DATA EPSI   /1.E-6/

*     CALL QTRACE('IQNEARQ',0)
 
      IF(Q.EQ.QLAST.AND.NGRVER.EQ.NGLAST) THEN
        IQNEARQ = IQLAST
        RETURN
      ENDIF
 
      IQ      = 0
      IQLAST  = 0
      NGLAST  = NGRVER
      QLAST   = Q
      IQNEARQ = 0

      IF(NQ2.EQ.0)                RETURN
      IF(Q/Q2TAB(1).LT.1.-EPSI)   RETURN
      IF(Q/Q2TAB(NQ2).GT.1.+EPSI) RETURN

      DO 10 I = 1,NQ2
*mb   IF(Q2TAB(I).LE.Q+EPSI) IQ = I
      IF(Q2TAB(I)/Q.LE.1.+EPSI) IQ = I
  10  CONTINUE
 
*mb   IF(ABS(Q2TAB(IQ)-Q).LE.EPSI) THEN
      IF(ABS(Q2TAB(IQ)/Q-1.).LE.EPSI) THEN
        IQNEARQ = IQ
        IQLAST  = IQ
      ELSE
        GAP     = LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        DEL     = LOG(Q/Q2TAB(IQ))
        IF(DEL/GAP.LE.0.5) THEN
          IQNEARQ = -IQ
        ELSE
          IQNEARQ = -MIN(IQ+1,NQ2)
        ENDIF
        IQLAST  = IQNEARQ
      ENDIF
 
      RETURN
      END

CDECK  ID>, XFROMIX.
 
C     =====================================
      DOUBLE PRECISION FUNCTION XFROMIX(IX)
C     =====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C---  Returns x given the gridindex IX.
C---  If IX is out of range [1,NXX] then XFROMIX = 0.

 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

*     CALL QTRACE('XFROMIX',0)
 
      IF(IX.LE.0) THEN
        XFROMIX = 0.
      ELSEIF(IX.GT.NXX) THEN
        XFROMIX = 0.
      ELSE
        XFROMIX = XXTAB(IX)
      ENDIF
 
      RETURN
      END

CDECK  ID>, QFROMIQ.
C
C     =====================================
      DOUBLE PRECISION FUNCTION QFROMIQ(IQ)
C     =====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C---  Returns Q2 given the gridindex IQ.
C---  If IQ is out of range [1,NQ2] then QFROMIQ = 0.
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

*     CALL QTRACE('QFROMIQ',0)
 
      IF(IQ.LE.0) THEN
        QFROMIQ = 0.
      ELSEIF(IQ.GT.NQ2) THEN
        QFROMIQ = 0.
      ELSE
        QFROMIQ = Q2TAB(IQ)
      ENDIF
 
      RETURN
      END

CDECK  ID>, GRCUTS.
 
C     ====================================
      SUBROUTINE GRCUTS(XMI,QMI,QMA,ROOTS)
C     ====================================

C---  GRCUTS:  user input of cuts.
C---  Input :  Double precision XMI:  reject x  .lt. XMI
C---                            QMI:  reject Q2 .lt. QMI
C---                            QMA:  reject Q2 .gt. QMA
C---                          ROOTS:  reject Q2 .gt. x * roots**2
C---  Output:  XMICUT, QMICUT, QMACUT, RS2CUT in +seq,QCGRID.
C---  NB    :  No cut is applied when XMI etc .le. 0 (XMICUT etc = -1.)
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      CALL QTRACE('GRCUTS ',0)

      IF(XMI.LE.0..OR.XMI.GE.1.) THEN
        XMICUT = -1.
      ELSE
        XMICUT = XMI
      ENDIF

      IF(QMI.LE.0.) THEN
        QMICUT = -1.
      ELSE
        QMICUT = QMI
      ENDIF

      IF(QMA.LE.0.) THEN
        QMACUT = -0.5
      ELSE
        QMACUT = QMA
      ENDIF

      IF(ROOTS.LE.0.) THEN
        RS2CUT = -1.
      ELSE
        RS2CUT = ROOTS*ROOTS
      ENDIF

      IF(QMICUT.GE.QMACUT.AND.QMACUT.GT.0.) THEN

        WRITE(6,'(/'' ------------------------------------'')')
        WRITE(6,'( '' QCDNUM error in s/r GRCUTS ---> STOP'')')
        WRITE(6,'( '' ------------------------------------'')')
        WRITE(6,'( '' Input Xmin  :'',E12.5)') XMI
        WRITE(6,'( ''       Q2min :'',E12.5)') QMI
        WRITE(6,'( ''       Q2max :'',E12.5)') QMA
        WRITE(6,'( ''       rootS :'',E12.5)') ROOTS
        WRITE(6,'(/'' Value of Q2min .ge. Q2max'')')

        CALL QTRACE('GRCUTS ',1)

        STOP

      ENDIF

      CALL GRSETC

      RETURN
      END

CDECK  ID>, GRSETC.
 
C     =================
      SUBROUTINE GRSETC
C     =================

C---  Input:  XMIN, QMIN, QMAX, RS2CUT + grid-definitions, all this
C---          as stored in QCGRID.
C---  Output: integer array IFAILC(IX,IQ) (see below).
C---  Called  by GRCUTS (user input of cuts) and
C---          by all grid definition routines (update of IFAILC).

C---  Fill the array IFAILC(IX,IQ) such that
C---  IFAILC = 0    : gridpoint passes all cuts
C---  IFAILC = ijkl : i = 0/1 no/yes fail roots cut
C---                  j = 0/1 no/yes fail qmax cut
C---                  k = 0/1 no/yes fail qmin cut
C---                  l = 0/1 no/yes fail xmin cut

C---  For any  x,Q2 passing the cuts the four surrounding gridpoints
C---  will also be flagged as passing the cut. This then guarantees
C---  that parton distributions are available on the surrounding
C---  gridpoints for interpolation purposes.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      DO IX = 1,MXX
        DO IQ = 1,MQ2
          IFAILC(IX,IQ) = 11111
        ENDDO
      ENDDO
      IF(NXX.LE.0)  RETURN
      IF(NQ2.LE.0)  RETURN

      DO IQ = 1,NQ2
        DO IX = 1,NXX
          IXP1          = MIN(IX+1,NXX)
          IQP1          = MIN(IQ+1,NQ2)
          IQM1          = MAX(IQ-1,1)
          IFAILC(IX,IQ) = 0
          IF(XXTAB(IXP1).LE.XMICUT.AND.XMICUT.GT.0.)
     +       IFAILC(IX,IQ) = IFAILC(IX,IQ)+1
          IF(Q2TAB(IQP1).LE.QMICUT.AND.QMICUT.GT.0.)
     +       IFAILC(IX,IQ) = IFAILC(IX,IQ)+10
          IF(Q2TAB(IQM1).GE.QMACUT.AND.QMACUT.GT.0.)
     +       IFAILC(IX,IQ) = IFAILC(IX,IQ)+100
          IF(Q2TAB(IQM1).GE.XXTAB(IXP1)*RS2CUT.AND.RS2CUT.GT.0.)
     +       IFAILC(IX,IQ) = IFAILC(IX,IQ)+1000
          IF(Q2TAB(IQP1).LE.QMINAS.AND.QMINAS.GT.0.)
     +       IFAILC(IX,IQ) = IFAILC(IX,IQ)+10000

        ENDDO
      ENDDO

C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

      RETURN
      END

CDECK  ID>, IFAILXQ.
 
C     =============================
      INTEGER FUNCTION IFAILXQ(X,Q)
C     =============================

C---  User interface to ICUTXQ
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      CALL QTRACE('IFAILXQ',0)

      IFAILXQ = ICUTXQ(X,Q,0)

      RETURN
      END

CDECK  ID>, ICUTXQ.
 
C     ==================================
      INTEGER FUNCTION ICUTXQ(X,Q,IPRIN)
C     ==================================

C---  ICUTXQ = ijkl : i = 0/1  no/yes fail ROOTS cut
C---                  j = 0/1  no/yes fail QMAX cut
C---                  k = 0/1  no/yes fail QMIN cut
C---                  l = 0/1  no/yes fail XMIN cut

C---  Input integer IPRIN = 0/1 no/yes printout.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      CHARACTER*4 PASS(0:1)

      DATA PASS /'pass','fail'/

C--   No x-grid available
      IF(NXX.LE.0) THEN
        ICUTXQ = 11111
        RETURN
      ENDIF
C--   No Q2 grid available
      IF(NQ2.LE.0) THEN
        ICUTXQ = 11111
        RETURN
      ENDIF
C--   x > 1
      IF(X.GT.1.0) THEN
        ICUTXQ = 11111
        RETURN
      ENDIF

      I1 = 0
      I2 = 0
      I3 = 0
      I4 = 0
      I5 = 0

      IF((X.LT.XXTAB(1)).OR.(X.LT.XMICUT.AND.XMICUT.GT.0.))
     +    I1 = 1
      IF((Q.LT.Q2TAB(1)).OR.(Q.LT.QMICUT.AND.QMICUT.GT.0.))
     +    I2 = 1
      IF((Q.GT.Q2TAB(NQ2)).OR.(Q.GT.QMACUT.AND.QMACUT.GT.0.))
     +    I3 = 1
      IF(Q.GT.X*RS2CUT.AND.RS2CUT.GT.0.) 
     +    I4 = 1
      IF((Q.LT.Q2TAB(1)).OR.(Q.LT.QMINAS.AND.QMINAS.GT.0.))
     +    I5 = 1

      ICUTXQ = 10000*I5 + 1000*I4 + 100*I3 + 10*I2 + I1

      IF(IPRIN.EQ.1) THEN

        XMIPR = XMICUT
        IF(XMICUT.LE.0.) XMIPR = XXTAB(1)
        QMIPR = QMICUT
        IF(QMICUT.LE.0.) QMIPR = Q2TAB(1)
        QMAPR = QMACUT
        IF(QMACUT.LE.0.) QMAPR = Q2TAB(NQ2)
        WRITE(6,'('' '')')
        WRITE(6,'('' x  ='',E12.5,'' xmin        = '',E12.5,
     +            '' pass/fail = '',A4)') X, XMIPR, PASS(I1)
        WRITE(6,'('' Q2 ='',E12.5,'' Qmin        = '',E12.5,
     +            '' pass/fail = '',A4)') Q, QMIPR, PASS(I2)
        WRITE(6,'('' Q2 ='',E12.5,'' Qmax        = '',E12.5,
     +            '' pass/fail = '',A4)') Q, QMAPR, PASS(I3)
        WRITE(6,'('' s  ='',E12.5,'' Smax        = '',E12.5,
     +            '' pass/fail = '',A4)') Q/X, RS2CUT, PASS(I4)
        WRITE(6,'('' Q2 ='',E12.5,'' Qmin_alphas = '',E12.5,
     +            '' pass/fail = '',A4)') Q, QMINAS, PASS(I5)
        WRITE(6,'('' '')')

      ENDIF

      RETURN
      END

CDECK  ID>, IFAILIJ.
 
C     ===============================
      INTEGER FUNCTION IFAILIJ(IX,IQ)
C     ===============================

C---  User interface to ICUTIJ
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      CALL QTRACE('IFAILIJ',0)

      IFAILIJ = ICUTIJ(IX,IQ,0)

      RETURN
      END

CDECK  ID>, ICUTIJ.
 
C     ====================================
      INTEGER FUNCTION ICUTIJ(JX,JQ,IPRIN)
C     ====================================

C---  ICUTIJ = ijklm : i = 0/1  no/yes fail QMINA cut
C---                   j = 0/1  no/yes fail ROOTS cut
C---                   k = 0/1  no/yes fail QMAX  cut
C---                   l = 0/1  no/yes fail QMIN  cut
C---                   m = 0/1  no/yes fail XMIN  cut

C---  ijklm is taken from array IFAILC.
C---  IFAILC is set by s/r GRSETC

C---  Input integer IPRIN = 0/1 no/yes printout.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      CHARACTER*4 PASS(0:1)

      DATA PASS /'pass','fail'/

      ICUTIJ = 11111

C--   No x-grid available
      IF(NXX.LE.0) RETURN
C--   No Q2 grid available
      IF(NQ2.LE.0) RETURN

      IX     = ABS(JX)
      IQ     = ABS(JQ)
      IF(IX.GE.1.AND.IX.LE.NXX.AND.IQ.GE.1.AND.IQ.LE.NQ2)
     +  ICUTIJ = IFAILC(IX,IQ)

      IF(IPRIN.EQ.1) THEN

        IF(IX.GE.1.AND.IX.LE.NXX.AND.IQ.GE.1.AND.IQ.LE.NQ2) THEN
          X  =  XXTAB(IX)
          Q  =  Q2TAB(IQ)
        ELSE
          X  =  0.
          Q  =  0.
        ENDIF
        I5 =  ICUTIJ/10000.
        I4 = (ICUTIJ-10000*I5)/1000.
        I3 = (ICUTIJ-10000*I5-1000*I4)/100.
        I2 = (ICUTIJ-10000*I5-1000*I4-100*I3)/10.
        I1 =  ICUTIJ-10000*I5-1000*I4-100*I3-10*I2

        XMIPR = XMICUT
        IF(XMICUT.LE.0.) XMIPR = XXTAB(1)
        QMIPR = QMICUT
        IF(QMICUT.LE.0.) QMIPR = Q2TAB(1)
        QMAPR = QMACUT
        IF(QMACUT.LE.0.) QMAPR = Q2TAB(NQ2)
        WRITE(6,'('' '')')
        WRITE(6,'('' IX = '',I5,'' x  ='',E12.5,'' xmin        = '',
     +  E12.5,'' pass/fail = '',A4)') IX, X, XMIPR, PASS(I1)
        WRITE(6,'('' IQ = '',I5,'' Q2 ='',E12.5,'' Qmin        = '',
     +  E12.5,'' pass/fail = '',A4)') IQ, Q, QMIPR, PASS(I2)
        WRITE(6,'('' IQ = '',I5,'' Q2 ='',E12.5,'' Qmax        = '',
     +  E12.5,'' pass/fail = '',A4)') IQ, Q, QMAPR, PASS(I3)
        WRITE(6,'(''      '',5X,'' s  ='',E12.5,'' Smax        = '',
     +  E12.5,'' pass/fail = '',A4)') Q/X, RS2CUT, PASS(I4)
        WRITE(6,'('' IQ = '',I5,'' Q2 ='',E12.5,'' Qmin_alphas = '',
     +  E12.5,'' pass/fail = '',A4)') IQ, Q, QMINAS, PASS(I5)
        WRITE(6,'('' '')')

      ENDIF

      RETURN
      END

CDECK  ID>, QTHRES.
 
C     ==========================
      SUBROUTINE QTHRES(T34,T45)
C     ==========================

C---  QTHRES:  user input of flavour thresholds.
C---  Input :  Double precision T34:  Q2 .lt. T34 --> f = 3
C---                                  Q2 .ge. T34 --> f = 4
C---                            T45:  Q2 .lt. T45 --> f = 4
C---                                  Q2 .ge. T45 --> f = 5
C---  Output:  THRS34 and THRS45 in +seq,QCGRID.
C---  NB1   :  Default THRS34 = -huge, THRS45 = +huge --> f = 4.
C---  NB2   :  The array NFMAP(Q2) = 3,4,5 is setup here through a
C---           call to QNSETT and maintained further in the grid
C---           defining routines.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      CALL QTRACE('QTHRES ',0)

      IF(T34.GE.T45) THEN
        IERR = 1
        GOTO 500
      ENDIF

      THRS34 = T34
      THRS45 = T45

C---  Fill the flavour map
      CALL QNSETT

      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QTHRES ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input Threshold34 :'',E12.5)') T34
      WRITE(6,'( ''       Threshold45 :'',E12.5)') T45
      WRITE(6,'(/'' Value of T34 .ge. T45'')')

      CALL QTRACE('QTHRES ',1)

      STOP

      END

CDECK  ID>, QNSETT.
 
C     =================
      SUBROUTINE QNSETT
C     =================

C---  Input:  THRS34 and THRS45 + grid-definitions, all this
C---          as stored in QCGRID.
C---  Output: integer array NFMAP(IQ) = 3,4,5
C---  Called  by QTHRES (user input of thresholds) and
C---          by all grid definition routines (update of NFMAP).

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      IF(NQ2.LE.0) THEN
        DO IQ = 1,MQ2
          NFMAP(IQ) = 4
        ENDDO
        RETURN
      ENDIF

      DO IQ = 1,NQ2
                                NFMAP(IQ) = 4
        IF(Q2TAB(IQ).LT.THRS34) NFMAP(IQ) = 3
        IF(Q2TAB(IQ).GE.THRS45) NFMAP(IQ) = 5
      ENDDO

C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

      RETURN
      END
 
CDECK  ID>, QNFMAP.
 
C     ==============================
      SUBROUTINE QNFMAP(OPT,T34,T45)
C     ==============================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT
 
 
C---  Obsolete 17/07/96: use QTHRES instead

      CALL QTHRES(T34,T45)

      RETURN
 
      END
 
CDECK  ID>, QNFSET.
 
C     ===========================
      SUBROUTINE QNFSET(IX,IQ,NF)   
C     ===========================
 
      WRITE(6,'(/'' QNFSET: this routine is not available'',
     +           '' ---> STOP'')')
      STOP
 
      END
 
CDECK  ID>, QNFNUL.
 
C     =================
      SUBROUTINE QNFNUL
C     =================
 
      WRITE(6,'(/'' QNFNUL: this routine is not available'',
     +           '' ---> STOP'')')
      STOP
 
      END

CDECK  ID>, NFLGET.
 
C     ===========================
      INTEGER FUNCTION NFLGET(IQ)
C     ===========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      CALL QTRACE('NFLGET ',0)
 
      NFLGET = 0
      IF(IQ.GE.1.AND.IQ.LE.NQ2) THEN
        NFLGET = NFMAP(IQ)
      ELSE
        WRITE(6,'(/'' ------------------------------------'')')
        WRITE(6,'( '' QCDNUM error in s/r NFLGET ---> STOP'')')
        WRITE(6,'( '' ------------------------------------'')')
        WRITE(6,'( '' Input IQ :'',I10)') IQ
        WRITE(6,'(/'' IQ outside grid boundary'')')
        CALL QTRACE('NFLGET ',1)
        STOP
      ENDIF
 
      RETURN
      END

CDECK  ID>, QPGRID.
 
C     ======================
      SUBROUTINE QPGRID(LUN)
C     ======================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
C--   Write x-Q2 evolution grid
C--   -------------------------

      WRITE(LUN,'(/'' QCDNUM x-Q2 evolution grid'')')
      WRITE(LUN,'( '' --------------------------'')')

      CALL GRGIVE(N_X,X_MI,X_MA,N_Q,Q_MI,Q_MA)
     
      WRITE(LUN,'(/''   nx      xmin      xmax'',
     +             ''   nq      qmin      qmax'')')
      WRITE(LUN,'(I5,2F10.7,I5,2F10.2)') 
     +            N_X,X_MI,X_MA,N_Q,Q_MI,Q_MA
      WRITE(LUN,'(/'' Xgrid (heavy quarks)'')')
      WRITE(LUN,'(5(I4,E12.5))') (I,XHTAB(I),I=1,NXX)
      WRITE(LUN,'(/'' Xgrid'')')
      WRITE(LUN,'(5(I4,E12.5))') (I,XXTAB(I),I=1,NXX)
      WRITE(LUN,'(/'' Qgrid'')')
      WRITE(LUN,'(5(I4,E12.5))') (I,Q2TAB(I),I=1,NQ2)
      IF(RS2CUT.GE.0.) THEN
        RS2C = SQRT(RS2CUT)
      ELSE
        RS2C = RS2CUT
      ENDIF
      WRITE(LUN,'(/'' Thresholds and cuts''/
     +             '' Q2  charm .......: '',E12.5/
     +             '' Q2 bottom .......: '',E12.5/
     +             '' Xmin  cut .......: '',E12.5/
     +             '' Qmin  cut .......: '',E12.5/
     +             '' Qmax  cut .......: '',E12.5/
     +             '' Roots cut .......: '',E12.5/
     +             '' Qmin  alpha_s ...: '',E12.5/)')
     +             THRS34,THRS45,XMICUT,QMICUT,QMACUT,RS2C,QMINAS

      RETURN
      END
 
CDECK  ID>, QDELQ2.
 
C     =================
      SUBROUTINE QDELQ2
C     =================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

C--   Pre-calculate log distance in Q2 for up and down evolution

      DO 10 IQ = 2,NQ2
        DELUP(IQ) = LOG(Q2TAB(IQ)/Q2TAB(IQ-1))
  10  CONTINUE
      DO 20 IQ = NQ2-1,1,-1
        DELDN(IQ) = LOG(Q2TAB(IQ)/Q2TAB(IQ+1))
  20  CONTINUE

      LDQ2OK = .TRUE. 

      RETURN
      END
 
CDECK  ID>, QFMARK.
 
C     ======================
      SUBROUTINE QFMARK(X,Q)
C     ======================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('QFMARK ',0)

C--   Mark gridpoints for fast structure function calculation

      IERR = 0
      IF(X.LE.0. .OR. X.GT.1.) THEN
        IERR = 1
        GOTO 500
      ENDIF
      IF(Q.LE.0.) THEN
        IERR = 2
        GOTO 500
      ENDIF

C--   Mark the evolution grid

      IX = IXFROMX(X)
      IQ = IQFROMQ(Q)
      IF(IX.EQ.0.OR.IQ.EQ.0) THEN
        IERR = 3
        GOTO 500
      ELSEIF(IX.GT.0.AND.IQ.GT.0) THEN
        MARKFF(IX,IQ)    = 1
        MARKQQ(IQ)       = 1
        LMARK            = .TRUE.
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN
        MARKFF(-IX,IQ)   = 1
        MARKFF(-IX+1,IQ) = 1
        MARKQQ(IQ)       = 1
        LMARK            = .TRUE.
      ELSEIF(IX.GT.0.AND.IQ.LT.0) THEN
        MARKFF(IX,-IQ)   = 1
        MARKFF(IX,-IQ+1) = 1
        MARKQQ(-IQ)      = 1
        MARKQQ(-IQ+1)    = 1
        LMARK            = .TRUE.
      ELSEIF(IX.LT.0.AND.IQ.LT.0) THEN
        MARKFF(-IX,-IQ)     = 1
        MARKFF(-IX+1,-IQ)   = 1
        MARKFF(-IX,-IQ+1)   = 1
        MARKFF(-IX+1,-IQ+1) = 1
        MARKQQ(-IQ)         = 1
        MARKQQ(-IQ+1)       = 1
        LMARK               = .TRUE.
      ENDIF

C--   Mark the heavy quark grid

      IX = IHFROMH(X)
      IQ = IQFROMQ(Q)
      IF(IX.EQ.0.OR.IQ.EQ.0) THEN
        IERR = 3
        GOTO 500
      ELSEIF(IX.GT.0.AND.IQ.GT.0) THEN
        MARKFH(IX,IQ)    = 1
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN
        MARKFH(-IX,IQ)   = 1
        MARKFH(-IX+1,IQ) = 1
      ELSEIF(IX.GT.0.AND.IQ.LT.0) THEN
        MARKFH(IX,-IQ)   = 1
        MARKFH(IX,-IQ+1) = 1
      ELSEIF(IX.LT.0.AND.IQ.LT.0) THEN
        MARKFH(-IX,-IQ)     = 1
        MARKFH(-IX+1,-IQ)   = 1
        MARKFH(-IX,-IQ+1)   = 1
        MARKFH(-IX+1,-IQ+1) = 1
      ENDIF

      RETURN

 500  CONTINUE

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QFMARK ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input x  :'',E12.5)') X
      WRITE(6,'( '' Input Q2 :'',E12.5)') Q
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' Value of x outside allowed range [0,1]'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Value of Q2 outside allowed range > 0'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Value of x and/or Q2 outside grid'')')
        IDUM = ICUTXQ(X,Q,1)
      ENDIF

      CALL QTRACE('QFMARK ',1)

      STOP

      END
 
CDECK  ID>, QFMNUL.
 
C     =================
      SUBROUTINE QFMNUL
C     =================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('QFMNUL ',0)

C--   Clear gridpoints for fast structure function calculation

      CALL QNINUL(MARKFF,MXX*MQ2)
      CALL QNINUL(MARKQQ,MQ2)
      CALL QNINUL(IDFAST,7*30)
      NDFAST = 30
      LMARK  = .FALSE.

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO

      RETURN
      END
 
CDECK  ID>, STFCLR.
 
C     =================
      SUBROUTINE STFCLR
C     =================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

C--   Clear memory allocation for STFAST

      CALL QTRACE('STFCLR ',0)

      CALL QNINUL(IDFAST,7*30)
      NDFAST = 30

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO

      RETURN
      END
 
CDECK  ID>, QNFILW.
 
C     ================================
      SUBROUTINE QNFILW(IQLIST,NQLIST)
C     ================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)


      DIMENSION IQLIST(*)
 
      IF(LTIME) CALL TIMEX_LHA(T_START(2))

      CALL QTRACE('QNFILW ',0)

      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF

C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

C--   Setup the adresses
      DO IX0 = 1,MXX
        DO IX = IX0,MXX
          IWADR(IX,IX0) = IWTAD(IX,IX0)
        ENDDO
      ENDDO
 
C--   Now calculate weights
      IF(LW1ANA) THEN
        DO 30 NF = 3,5
        CALL FILLO1(NF)
  30    CONTINUE
        LW1NUM = .FALSE.
        LWT1OK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate LO weights analytically'')')
      ENDIF
 
      I1 = 0
      I2 = 0
      I3 = 0
      IF(LW1NUM) THEN
        I1     = 1
        LWT1OK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate LO weights numerically'')')
      ENDIF
      IF(LW2NUM) THEN
        I2     = 1
        LWT2OK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate NLO weights'')')
      ENDIF
      IF(LW2STF) THEN
        I3     = 1
        LWTFOK = .TRUE. 
        WRITE(6,'(/'' QNFILW: Calculate F2 weights'')')
      ENDIF
 
      DO 40 NF = 3,5
      CALL FILLWF(I1,I2,I3,NF)
  40  CONTINUE
 
      IF(LWF2C.OR.LWF2B.OR.LWFLC.OR.LWFLB) THEN

C---    Check charm, bottom mass
        IF(.NOT.(0..LT.CBMSTF(4) .AND. CBMSTF(4).EQ.CBMSTF(5) .AND.
     +    CBMSTF(4).LT.CBMSTF(6) .AND. CBMSTF(6).EQ.CBMSTF(7))) THEN
          IERR = 2
          GOTO 500
        ENDIF

        IF(LWF2C) THEN
          LWFCOK = .TRUE. 
          CALL FIL_F2H(4)
          WRITE(6,'(/'' QNFILW: Calculate F2c weights'')')   
        ENDIF
        IF(LWF2B) THEN
          LWFBOK = .TRUE. 
          CALL FIL_F2H(6)
          WRITE(6,'(/'' QNFILW: Calculate F2b weights'')')   
        ENDIF
        IF(LWFLC) THEN
          LWLCOK = .TRUE. 
          CALL FIL_FLH(5)
          WRITE(6,'(/'' QNFILW: Calculate FLc weights'')')   
        ENDIF
        IF(LWFLB) THEN
          LWLBOK = .TRUE. 
          CALL FIL_FLH(7)
          WRITE(6,'(/'' QNFILW: Calculate FLb weights'')')   
        ENDIF

      ENDIF
 
      WRITE(6,'(/)') 

      IF(LTIME) THEN
        CALL TIMEX_LHA(T_END(2))
        T_SPENT(2) = T_SPENT(2)+T_END(2)-T_START(2)
        N_CALLS(2) = N_CALLS(2)+1
      ENDIF

      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNFILW ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ENDIF
      IF(IERR.EQ.2) THEN
        WRITE(6,'( '' Cmass (F2c,FLc) ='',2E12.5)') CBMSTF(4),CBMSTF(5)
        WRITE(6,'( '' Bmass (F2b,FLb) ='',2E12.5)') CBMSTF(6),CBMSTF(7)
        WRITE(6,'(/'' Masses not in ascending order or not equal'',
     +             '' for F2 and FL'')')
      ENDIF

      CALL QTRACE('QNFILW ',1)

      STOP

      END
      
CDECK  ID>, QNGETW.
 
C     ===============================================
      DOUBLE PRECISION FUNCTION QNGETW(OPT,IX0,IX,IQ)
C     ===============================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)


      REAL
     +WH_C0KG,WH_C1KG,WH_C1BKG,
     +WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ

      COMMON/QCHWGT/
     +WH_C0KG(0:MXX,MQ2,4:7),
     +WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),
     +WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),
     +WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)


      CHARACTER*(*) OPT
      CHARACTER*8   OPT8

      CALL QTRACE('QNGETW ',0)

      IERR = 0
      IF(IX0.LE.0.OR.IX0.GT.MXX-1) THEN
        IERR = 1
        GOTO 500
      ENDIF
      IF(IX.LE.0.OR.IX.GT.MXX-1) THEN
        IERR = 1
        GOTO 500
      ENDIF
      IF(IQ.LE.0.OR.IQ.GT.MQ2-1) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      NF  = NFMAP(IQ)
      IF(NF.LT.3.OR.NF.GT.5) THEN
        IERR = 2
        GOTO 500
      ENDIF

      IF(IX.LT.IX0) THEN
        QNGETW = 0.
        RETURN
      ENDIF

      LEN = MIN(LENOCC_LHA(OPT),8)
      OPT8(1:LEN) = OPT(1:LEN)
      CALL CLTOU_LHA(OPT8)
     
      IF(OPT8(1:6).EQ.'WGTFF1') THEN                
        QNGETW = WGTFF1(IWTAD(IX,IX0))       
      ELSEIF(OPT8(1:6).EQ.'WGTFG1') THEN                
        QNGETW = WGTFG1(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTGF1') THEN                
        QNGETW = WGTGF1(IWTAD(IX,IX0))        
      ELSEIF(OPT8(1:6).EQ.'WGTGG1') THEN                
        QNGETW = WGTGG1(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTPP2') THEN                
        QNGETW = WGTPP2(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTPM2') THEN                
        QNGETW = WGTPM2(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTNS2') THEN                
        QNGETW = WGTNS2(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTFF2') THEN                
        QNGETW = WGTFF2(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTFG2') THEN                
        QNGETW = WGTFG2(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTGF2') THEN                
        QNGETW = WGTGF2(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTGG2') THEN                
        QNGETW = WGTGG2(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTC2Q') THEN                
        QNGETW = WGTC2Q(IWTAD(IX,IX0))        
      ELSEIF(OPT8(1:6).EQ.'WGTC2G') THEN                
        QNGETW = WGTC2G(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTCLQ') THEN                
        QNGETW = WGTCLQ(IWTAD(IX,IX0))        
      ELSEIF(OPT8(1:6).EQ.'WGTCLG') THEN                
        QNGETW = WGTCLG(IWTAD(IX,IX0),NF)   
      ELSEIF(OPT8(1:6).EQ.'WGTC3Q') THEN                
        QNGETW = WGTC3Q(IWTAD(IX,IX0))        
      ELSEIF(OPT8(1:7).EQ.'WH_C02G') THEN                
        QNGETW = WH_C0KG(IX-IX0,IQ,4)
      ELSEIF(OPT8(1:7).EQ.'WH_C12G') THEN                
        QNGETW = WH_C1KG(IX-IX0,IQ,4)
      ELSEIF(OPT8(1:8).EQ.'WH_C1B2G') THEN                
        QNGETW = WH_C1BKG(IX-IX0,IQ,4)
      ELSEIF(OPT8(1:7).EQ.'WH_C12Q') THEN                
        QNGETW = WH_C1KQ(IX-IX0,IQ,4)
      ELSEIF(OPT8(1:8).EQ.'WH_C1B2Q') THEN                
        QNGETW = WH_C1BKQ(IX-IX0,IQ,4)
      ELSEIF(OPT8(1:7).EQ.'WH_D12Q') THEN                
        QNGETW = WH_D1KQ(IX-IX0,IQ,4)
      ELSEIF(OPT8(1:8).EQ.'WH_D1B2Q') THEN                
        QNGETW = WH_D1BKQ(IX-IX0,IQ,4)
      ELSEIF(OPT8(1:7).EQ.'WH_C0LG') THEN                
        QNGETW = WH_C0KG(IX-IX0,IQ,5)
      ELSEIF(OPT8(1:7).EQ.'WH_C1LG') THEN                
        QNGETW = WH_C1KG(IX-IX0,IQ,5)
      ELSEIF(OPT8(1:8).EQ.'WH_C1BLG') THEN                
        QNGETW = WH_C1BKG(IX-IX0,IQ,5)
      ELSEIF(OPT8(1:7).EQ.'WH_C1LQ') THEN                
        QNGETW = WH_C1KQ(IX-IX0,IQ,5)
      ELSEIF(OPT8(1:8).EQ.'WH_C1BLQ') THEN                
        QNGETW = WH_C1BKQ(IX-IX0,IQ,5)
      ELSEIF(OPT8(1:7).EQ.'WH_D1LQ') THEN                
        QNGETW = WH_D1KQ(IX-IX0,IQ,5)
      ELSEIF(OPT8(1:8).EQ.'WH_D1BLQ') THEN                
        QNGETW = WH_D1BKQ(IX-IX0,IQ,5)
      ELSE
        IERR = 3
        GOTO 500
      ENDIF

      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNGETW ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input OPT      :'',A)') OPT       
      WRITE(6,'( ''       IX0      :'',I10)') IX0       
      WRITE(6,'( ''       IX       :'',I10)') IX     
      WRITE(6,'( ''       IQ       :'',I10)') IQ     
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' IX0, IX and/or IQ outside allowed range'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' NF(IX,IQ) ='',I3,'' outside allowed range'')') NF
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Unknown option'')')
      ENDIF

      CALL QTRACE('QNGETW ',1)

      STOP

      END
      
CDECK  ID>, QSTRIP.
 
C     =================================
      SUBROUTINE QSTRIP(NAMEIN,NAMEOUT)
C     =================================
 
C---  Truncate NAMEIN to 5 characters and convert to upper case
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) NAMEIN
      CHARACTER*5   NAMEOUT

      LEN            = MIN(LENOCC_LHA(NAMEIN),5)
      NAMEOUT        = '     '
      NAMEOUT(1:LEN) = NAMEIN(1:LEN)
      CALL CLTOU_LHA(NAMEOUT)

      RETURN
      END
      
CDECK  ID>, CHKNAM.
 
C     ====================================
      SUBROUTINE CHKNAM(ID,NAME,SNAME,NAM)
C     ====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      CHARACTER*(*) NAME, SNAME
      CHARACTER*5 NAM

      LEN = MIN(LENOCC_LHA(NAME),5)
      NAM = '     '
      NAM(1:LEN) = NAME(1:LEN)
      CALL CLTOU_LHA(NAM)

      IF(NAM.EQ.'     ') THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF(NAM.EQ.'FREE ') THEN
        PNAM(ID)      =  NAM
        LNFP(ID,3)    = .FALSE.
        LNFP(ID,4)    = .FALSE.
        LNFP(ID,5)    = .FALSE.
        IF(ID.LE.10) THEN
          DO JD = 0,30
            PWGT(ID,JD,3) = 0.
            PWGT(ID,JD,4) = 0.
            PWGT(ID,JD,5) = 0.
          ENDDO
        ELSE
          DO JD = 0,10
            PWGT(JD,ID,3) = 0.
            PWGT(JD,ID,4) = 0.
            PWGT(JD,ID,5) = 0.
          ENDDO
        ENDIF
        RETURN
      ENDIF
 
      IF(PNAM(ID).NE.'FREE '.AND.PNAM(ID).NE.NAM) THEN
        IERR = 2
        GOTO 500
      ENDIF
 
      DO 10 JD = 0,30
        IF(JD.EQ.ID) GOTO 10
        IF(PNAM(JD).EQ.NAM) THEN
          IERR = 3
          GOTO 500
        ENDIF
  10  CONTINUE

      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r '',A,'' ---> STOP'')')
     +              SNAME
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input ID   :'',I10)') ID
      WRITE(6,'( '' Input NAME :'',A)') NAM
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' Blank name not allowed'')') 
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' ID already booked'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' NAME already used'')')
      ENDIF

      CALL QTRACE('CHKNAM ',1)

      STOP
 
      END
      
CDECK  ID>, QNBOOK.
 
C     ==========================
      SUBROUTINE QNBOOK(ID,NAME)
C     ==========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      CHARACTER*(*) NAME
      CHARACTER*5    NAM

      CALL QTRACE('QNBOOK ',0)
 
      CALL CHKNAM(ID,NAME,'QNBOOK',NAM)
 
      PNAM(ID)      =  NAM
      LNFP(ID,3)    = .TRUE.
      LNFP(ID,4)    = .TRUE.
      LNFP(ID,5)    = .TRUE.
      PWGT(ID,ID,3) = 1.
      PWGT(ID,ID,4) = 1.
      PWGT(ID,ID,5) = 1.
 
      RETURN
      END
 
CDECK  ID>, QNLINC.
 
C     ===================================
      SUBROUTINE QNLINC(ID,NAME,NF,WEITS)
C     ===================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      CHARACTER*(*) NAME
      CHARACTER*5   NAM
      DIMENSION     WEITS(10)

      CALL QTRACE('QNLINC ',0)
 
      IF(ID.LE.10.OR.ID.GE.31) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      IF(NF.LT.3 .OR.NF.GT.5 ) THEN
        IERR = 2
        GOTO 500
      ENDIF

      CALL CHKNAM(ID,NAME,'QNLINC',NAM)
 
      PNAM(ID)    = NAM
      LNFP(ID,NF) = .TRUE.
      DO 20 I=1,10
        PWGT(I,ID,NF) = WEITS(I)
  20  CONTINUE
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNLINC ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input ID        :'',I0)') ID
      WRITE(6,'( ''       NAME      :'',A)') NAME
      WRITE(6,'( ''       NF        :'',I0)') NF
      WRITE(6,'( ''       FACTORS(1):'',E12.5)') WEITS(1)
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' ID outside allowed range [11,30]'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' NF outside allowed range [3,5]'')')
      ENDIF

      CALL QTRACE('QNLINC ',1)

      STOP

      END
 
CDECK  ID>, QNGIVE.
 
C     ===================================
      SUBROUTINE QNGIVE(ID,NF,NAME,WEITS)
C     ===================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      CHARACTER*5 NAME
      DIMENSION   WEITS(10)

      CALL QTRACE('QNGIVE ',1)
 
      IF(ID.LT.0.OR.ID.GT.30.OR.NF.LT.3.OR.NF.GT.5) THEN
 
        NAME = 'NULL '
        DO 10 I=1,10
          WEITS(I) = 0.
  10    CONTINUE
 
      ELSE
 
        NAME = PNAM(ID)
        DO 15 I=1,10
          WEITS(I) = PWGT(I,ID,NF)
  15    CONTINUE
 
      ENDIF
 
      RETURN
      END

CDECK  ID>, IDCHEK.
 
C     =============================
      INTEGER FUNCTION IPDFID(UNAM)
C     =============================

C---  IPDFID = identifier of memory resident quark distn
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAM
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 

      CALL QTRACE('IPDFID ',0)
 
      CALL QSTRIP(UNAM,NAM)

      IF(NAM.EQ.'     '.OR.NAM.EQ.'FREE ') THEN
        GOTO 500
      ENDIF
 
      ID = -1
      DO I = 1,10
        IF(NAM.EQ.PNAM(I)) ID = I
      ENDDO   
 
      IPDFID = ID
 
      IF(ID.EQ.-1) THEN  
        GOTO 500
      ENDIF
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r IPDFID ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME      :'',A)') UNAM
      WRITE(6,'(/'' NAME not booked at all or NAME does not refer''/
     +           '' to a memory resident quark distribution'')')
      IF(NAM(1:1).EQ.' ')
     +WRITE(6,'(/'' WARNING: NAME has one or more leading blanks'')')

      CALL QTRACE('IPDFID ',1)

      STOP
      END
 

CDECK  ID>, IDCHEK.
 
C     ============================================
      INTEGER FUNCTION IDCHEK(NAM,NF,SRNAME,ISTOP)
C     ============================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*6   SRNAME
      CHARACTER*5   NAMLAST,NAM
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      SAVE IDLAST,NAMLAST
 
      DATA IDLAST      /   0    /
      DATA NAMLAST     / '    ' /
 
      IDCHEK = -1
 
      IF(NAM.EQ.'     '.OR.NAM.EQ.'FREE '.OR.
     +   NF.LT.3.OR.NF.GT.5)                       THEN
        IF(ISTOP.EQ.1) THEN
          IERR = 1
          GOTO 500
        ENDIF
        RETURN
      ENDIF
 
      ID = -1
      IF(NAM.EQ.NAMLAST.AND.LNFP(IDLAST,NF)) THEN
        ID     = IDLAST
      ELSE
        DO 10 I = 0,30
          IF(NAM.EQ.PNAM(I).AND.LNFP(I,NF)) ID = I
  10    CONTINUE
        IDLAST  = ID
        NAMLAST = NAM
      ENDIF
 
      IDCHEK = ID
 
      IF(ID.EQ.-1.AND.ISTOP.EQ.1) THEN  
        IERR = 2
        GOTO 500
      ENDIF
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r '',A,'' ---> STOP'')')
     +              SRNAME
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME      :'',A)') NAM
      WRITE(6,'( ''       NF        :'',I10)') NF
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' Input name not allowed and/or NF outside'',
     +             '' the allowed range [3,5]'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' NAME not booked at all or, if NAME refers to''/
     +             '' a linear combination, it might not have been''/
     +             '' booked for NF flavours'')')
        IF(NAM(1:1).EQ.' ')
     +  WRITE(6,'(/'' WARNING: NAME has one or more leading blanks'')')
      ENDIF

      CALL QTRACE('IDCHEK ',1)

      STOP
      END
 
CDECK  ID>, QNLIST.
 
C     ======================
      SUBROUTINE QNLIST(LUN)
C     ======================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*5 NAM
      CHARACTER*3 II
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      WRITE(LUN,'(////)')
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')')
      WRITE(LUN,'('' |             | W_'',I2,
     +           9(''  W_'',I2),'' |'')') (J, J=1,10)
      WRITE(LUN,'('' | ID NAME  nf | '',A4,
     +           9(2X,A4),'' |'')') (PNAM(J),J=1,10)
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')')
      DO 10 I = 0,10
        IF(IDCHEK(PNAM(I),3,'      ',0).EQ.-1) GOTO 10
        WRITE(LUN,'('' |'',I3,1X,A5,''    |'',F5.2,
     +             9(F6.2),'' |'')') I, PNAM(I),(PWGT(J,I,3),J=1,10)
  10  CONTINUE
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')')
      DO 20 I = 11,30
        NAM = PNAM(I)
        WRITE(II,'(I3)') I
        IF(IDCHEK(PNAM(I),3,'      ',0).NE.-1) THEN
        WRITE(LUN,'('' |'',A3,1X,A5,''  3 |'',F5.2,
     +             9(F6.2),'' |'')') II, NAM,(PWGT(J,I,3),J=1,10)
        NAM = '     '
        II  = '   '
        ENDIF
        IF(IDCHEK(PNAM(I),4,'      ',0).NE.-1) THEN
        WRITE(LUN,'('' |'',A3,1X,A5,''  4 |'',F5.2,
     +             9(F6.2),'' |'')') II, NAM,(PWGT(J,I,4),J=1,10)
        NAM = '     '
        II  = '   '
        ENDIF
        IF(IDCHEK(PNAM(I),5,'      ',0).NE.-1) THEN
        WRITE(LUN,'('' |'',A3,1X,A5,''  5 |'',F5.2,
     +             9(F6.2),'' |'')') II, NAM, (PWGT(J,I,5),J=1,10)
        NAM = '     '
        II  = '   '
        ENDIF
  20  CONTINUE
      WRITE(LUN,'(1X,''+'',13(''-''),''+'',60(''-''),''+'')')
      WRITE(LUN,'(////)')
 
      RETURN
      END
 
CDECK  ID>, QNPSET.
C     ================================= 
      SUBROUTINE QNPSET(UNAM,IX,IQ,VAL) 
C     ================================= 

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('QNPSET ',0)
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      CALL QSTRIP(UNAM,NAME)
 
      ID = IDCHEK(NAME,4,'QNPSET',1)
 
      IF(ID.EQ.-1) RETURN
 
      IF(IX.LT.1.OR.IX.GT.NXX) THEN
        IERR = 2
        GOTO 500
      ENDIF
 
      IF(IQ.LT.1.OR.IQ.GT.NQ2) THEN
        IERR = 2
        GOTO 500
      ENDIF
 
      IF(ID.LT.0.OR.ID.GT.10) THEN
        IERR = 3
        GOTO 500
      ENDIF

C--   If a different input value, invalidate evolution for this
C--   and all lower x-grid points
      IF(VAL.NE.PDFQCD(IX,IQ,ID)) THEN
        DO JX = 1,IX
          LEVDONE(JX,MAX(ID,1)) = .FALSE.
        ENDDO
      ENDIF
 
      PDFQCD(IX,IQ,ID) = VAL

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNPSET ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME :'',A)') UNAM
      WRITE(6,'( ''         IX :'',I10)') IX
      WRITE(6,'( ''         IQ :'',I10)') IQ
      WRITE(6,'( ''      Value :'',E12.5)') VAL
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' IX and/or IQ outside grid boundary'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' Apparently you try to assign a value'',
     +             '' to a linear combination: no thank you'')')
      ENDIF

      CALL QTRACE('QNPSET ',1)

      STOP

      END
 
CDECK  ID>, QADDSI.
 
C     =================================
      SUBROUTINE QADDSI(UNAM,IQ,FACTOR)
C     =================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('QADDSI ',0)
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      CALL QSTRIP(UNAM,NAME)
 
      ID = IDCHEK(NAME,4,'QADDSI',1)
 
      IF(ID.EQ.-1) RETURN

      IF(ID.EQ.0.OR.ID.EQ.1) THEN
        IERR = 2
        GOTO 500
      ENDIF
 
      IF(IQ.LT.1.OR.IQ.GT.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
 
      IF(ID.LT.0.OR.ID.GT.10) THEN
        IERR = 4
        GOTO 500
      ENDIF
 
      DO IX = 1,NXX
C--     Invalidate evolution of this pdf
        LEVDONE(IX,MAX(ID,1)) = .FALSE.
        PDFQCD(IX,IQ,ID) = PDFQCD(IX,IQ,ID)+
     +                     FACTOR*PDFQCD(IX,IQ,1)
      ENDDO

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QADDSI ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME :'',A)') UNAM
      WRITE(6,'( ''         IQ :'',I10)') IQ
      WRITE(6,'( ''     Factor :'',E12.5)') FACTOR
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' This routine cannot be used'',
     +             '' for singlet or gluon'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' IX and/or IQ outside grid boundary'')')
      ELSEIF(IERR.EQ.4) THEN
        WRITE(6,'(/'' Apparently you try to assign a value'',
     +             '' to a linear combination: no thank you'')')
      ENDIF

      CALL QTRACE('QADDSI ',1)

      STOP

      END
 
CDECK  ID>, QNPNUL.
 
C     =======================
      SUBROUTINE QNPNUL(UNAM)
C     =======================

C---  Set parton distribution 'NAME' to zero.
C---  Called by user.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('QNPNUL ',0)
 
      CALL QSTRIP(UNAM,NAME)
 
      ID = IDCHEK(NAME,4,'QNPNUL',1)
 
      IF(ID.EQ.-1) RETURN
 
      IF(ID.LT.0.OR.ID.GT.10) THEN
        GOTO 500
      ENDIF
 
      DO IX = 1,MXX
        DO IQ = 1,MQ2
          PDFQCD(IX,IQ,ID) = 0.
        ENDDO
      ENDDO

C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QNPNUL ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME :'',A)') UNAM
      WRITE(6,'(/'' Apparently you try to clear'',
     +           '' a linear combination: no thank you'')')

      CALL QTRACE('QNPNUL ',1)

      STOP

      END
 
CDECK  ID>, IX1CHK.
 
C     ==============================
      INTEGER FUNCTION IX1CHK(ISTOP)
C     ==============================

C---  Check all pdfs are zero at NXX+1 (x = 1).
C---  IX1CHK = 0    : All ok.
C---         = 1    : Nonzero entry in gluon or singlet.
C---         = 2-10 : Nonzero entry in PDF 2-10.
C---  Called by user.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('IX1CHK ',0)

      IERR = -1
      JQ   =  0

      DO ID = 0,10 
        DO IQ = 1,NQ2
          IF(ABS(PDFQCD(NXX+1,IQ,ID)).GT.1.E-11) THEN
            IERR = ID
            JQ   = IQ
          ENDIF
        ENDDO
      ENDDO

      IF(IERR.EQ.-1) THEN
        IX1CHK = 0
        RETURN
      ENDIF

      IX1CHK = MAX(IERR,1)
      IF(ISTOP.EQ.0) RETURN
 
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r IX1CHK ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Pdf identifier  ID :'',I5)') IERR
      WRITE(6,'( '' X = 1 gridpoint IX :'',I5)') NXX+1
      WRITE(6,'( '' Q2    gridpoint IQ :'',I5)') JQ
      WRITE(6,'(/'' Pdf nonzero at x = 1;''/        
     +           '' this should never happen....'')')

      CALL QTRACE('IX1CHK ',1)

      STOP

      END
 
CDECK  ID>, EVOLSG.

C     ================================ 
      SUBROUTINE EVOLSG(IQ0,IUQL,IUQH) 
C     ================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      IF(LTIME) CALL TIMEX_LHA(T_START(5))

      CALL QTRACE('EVOLSG ',0)
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF

      IQL = IUQL
      IQH = IUQH

      IXL = MAX(ABS(IXFROMX(XMICUT)),1)
      IQD = ABS(IQFROMQ(QMICUT))
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS)))
      IQU = ABS(IQFROMQ(QMACUT))
      IF(IQD.NE.0) IQL = MAX(IQD,IQL)
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH)
 
      IF(IQL.LE.0) IQL = 1
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN
      IF(IQL.GE.IQH) THEN
        IERR = 2
        GOTO 500
      ENDIF
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN
        IERR = 4
        GOTO 500
      ENDIF
      IF(.NOT.LWT1OK) THEN
        IERR = 5
        GOTO 500
      ENDIF
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN
        IERR = 6
        GOTO 500
      ENDIF

      IRUN = 0
      IF(.NOT.LALFOK) THEN
        CALL QFILAS('EVOLSG')
        IRUN = 1
      ENDIF
      IF(.NOT.LDQ2OK) THEN
        CALL QDELQ2
        IRUN = 1
      ENDIF
 
      DO IX = 1,NXX
      LE_DONE(IX) = LEVDONE(IX,1)
      DO IQ = 1,NQ2
        FGLQCD(IX,IQ) = PDFQCD(IX,IQ,0)
        FSIQCD(IX,IQ) = PDFQCD(IX,IQ,1)
      ENDDO   
      ENDDO   
 
      IF(IQ0.NE.IQ0_LAST(1) .OR.
     +   IQL.NE.IQL_LAST(1) .OR.
     +   IQH.NE.IQH_LAST(1)     ) IRUN = 1

      CALL APSI(IXL,IQ0,IQL,IQH,IRUN,EVL)

      IQ0_LAST(1) = IQ0
      IQL_LAST(1) = IQL
      IQH_LAST(1) = IQH
 
      DO IX = 1,NXX
      LEVDONE(IX,1) = LE_DONE(IX) 
      DO IQ = 1,NQ2
        PDFQCD(IX,IQ,0) = FGLQCD(IX,IQ)
        PDFQCD(IX,IQ,1) = FSIQCD(IX,IQ)
      ENDDO   
      ENDDO   
 
      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
 
      IF(LTIME) THEN
        CALL TIMEX_LHA(T_END(5))
        T_SPENT(5) = T_SPENT(5)+T_END(5)-T_START(5)
        N_CALLS(5) = N_CALLS(5)+1
        E_CALLS(5) = E_CALLS(5)+EVL
      ENDIF
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r EVOLSG ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input      IQ0      :'',I5)') IQ0
      WRITE(6,'( ''            IQLow    :'',I5)') IUQL
      WRITE(6,'( ''            IQHigh   :'',I5)') IUQH
      IF(IERR.NE.1) THEN
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0)
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL)
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH)
      ENDIF
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Value of IQL .ge. IQH'',
     +             '' (after applying Q2 cuts, if any)'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')')
      ELSEIF(IERR.EQ.4) THEN
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'',
     +             '' (after applying Q2 cuts, if any)'')')
      ELSEIF(IERR.EQ.5) THEN
        WRITE(6,'(/'' No LO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ELSEIF(IERR.EQ.6) THEN
        WRITE(6,'(/'' No NLO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ENDIF

      CALL QTRACE('EVOLSG ',1)

      STOP

      END
 
 
CDECK  ID>, APSI.
C     ========================================= 
      SUBROUTINE APSI(IXL,IQ0,IQL,IQH,IRUN,EVL) 
C     ========================================= 

      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)


      EVL = 0.

      FSI = FSIQCD(NXX,IQ0)
      FGL = FGLQCD(NXX,IQ0)
C     -------------------------------------------
      IF(.NOT.LE_DONE(NXX) .OR. IRUN.EQ.1) THEN !
C     -------------------------------------------
 
        NF  = NFMAP(IQ0)

        WQQ = ALFAPQ(IQ0) * WGTFF1(IWADR(NXX,NXX))    +
     +        ALFA2Q(IQ0) * WGTFF2(IWADR(NXX,NXX),NF)
        WQG = ALFAPQ(IQ0) * WGTFG1(IWADR(NXX,NXX),NF) +
     +        ALFA2Q(IQ0) * WGTFG2(IWADR(NXX,NXX),NF)
        WGQ = ALFAPQ(IQ0) * WGTGF1(IWADR(NXX,NXX))    +
     +        ALFA2Q(IQ0) * WGTGF2(IWADR(NXX,NXX),NF)
        WGG = ALFAPQ(IQ0) * WGTGG1(IWADR(NXX,NXX),NF) +
     +        ALFA2Q(IQ0) * WGTGG2(IWADR(NXX,NXX),NF)
 
        DSI = WQQ*FSI+WQG*FGL
        DGL = WGQ*FSI+WGG*FGL
 
        FSI0 = FSI
        DSI0 = DSI
        FGL0 = FGL
        DGL0 = DGL
        FSIQCD(NXX,IQ0) = FSI
        DSIQCD(NXX,IQ0) = DSI
        FGLQCD(NXX,IQ0) = FGL
        DGGQCD(NXX,IQ0) = DGL
        EVL             = EVL+1.
 
        DO 100 IQ = IQ0+1,IQH
          DEL = DELUP(IQ)
          NF  = NFMAP(IQ)
          WQQ = ALFAPQ(IQ) * WGTFF1(IWADR(NXX,NXX))    +
     +          ALFA2Q(IQ) * WGTFF2(IWADR(NXX,NXX),NF)
          WQG = ALFAPQ(IQ) * WGTFG1(IWADR(NXX,NXX),NF) +
     +          ALFA2Q(IQ) * WGTFG2(IWADR(NXX,NXX),NF)
          WGQ = ALFAPQ(IQ) * WGTGF1(IWADR(NXX,NXX))    +
     +          ALFA2Q(IQ) * WGTGF2(IWADR(NXX,NXX),NF)
          WGG = ALFAPQ(IQ) * WGTGG1(IWADR(NXX,NXX),NF) +
     +          ALFA2Q(IQ) * WGTGG2(IWADR(NXX,NXX),NF)
          AAS = 2.*FSI + DSI*DEL
          BBS = 2. - WQQ*DEL
          AAG = 2.*FGL + DGL*DEL
          BBG = 2. - WGG*DEL
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL)
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL)
          DSI = WQQ*FSI+WQG*FGL
          DGL = WGQ*FSI+WGG*FGL
          FSIQCD(NXX,IQ) = FSI
          DSIQCD(NXX,IQ) = DSI
          FGLQCD(NXX,IQ) = FGL
          DGGQCD(NXX,IQ) = DGL
 100    CONTINUE
        EVL = EVL+IQH-IQ0
 
        FSI = FSI0
        DSI = DSI0
        FGL = FGL0
        DGL = DGL0
 
        DO 200 IQ = IQ0-1,IQL,-1
          DEL = DELDN(IQ)
          NF  = NFMAP(IQ)
          WQQ = ALFAPQ(IQ) * WGTFF1(IWADR(NXX,NXX))    +
     +          ALFA2Q(IQ) * WGTFF2(IWADR(NXX,NXX),NF)
          WQG = ALFAPQ(IQ) * WGTFG1(IWADR(NXX,NXX),NF) +
     +          ALFA2Q(IQ) * WGTFG2(IWADR(NXX,NXX),NF)
          WGQ = ALFAPQ(IQ) * WGTGF1(IWADR(NXX,NXX))    +
     +          ALFA2Q(IQ) * WGTGF2(IWADR(NXX,NXX),NF)
          WGG = ALFAPQ(IQ) * WGTGG1(IWADR(NXX,NXX),NF) +
     +          ALFA2Q(IQ) * WGTGG2(IWADR(NXX,NXX),NF)
          AAS = 2.*FSI + DSI*DEL
          BBS = 2. - WQQ*DEL
          AAG = 2.*FGL + DGL*DEL
          BBG = 2. - WGG*DEL
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL)
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL)
          DSI = WQQ*FSI+WQG*FGL
          DGL = WGQ*FSI+WGG*FGL
          FSIQCD(NXX,IQ) = FSI
          DSIQCD(NXX,IQ) = DSI
          FGLQCD(NXX,IQ) = FGL
          DGGQCD(NXX,IQ) = DGL
 200    CONTINUE
        EVL = EVL+IQ0-IQL
 
C     -------
      ENDIF !
C     -------
 
C     ---------------------------
      DO 300 IX0 = NXX-1,IXL,-1 !
C     ---------------------------
 
        FSI = FSIQCD(IX0,IQ0)
        FGL = FGLQCD(IX0,IQ0)
        IF(LE_DONE(IX0) .AND. IRUN.EQ.0) GOTO 300
        ALF = ALFAPQ(IQ0)
        AL2 = ALFA2Q(IQ0)
        SQQ1 = 0.
        SQG1 = 0.
        SGQ1 = 0.
        SGG1 = 0.
        SQQ2 = 0.
        SQG2 = 0.
        SGQ2 = 0.
        SGG2 = 0.
        NF  = NFMAP(IQ0)
        DO 220 IX = NXX,IX0+1,-1
          IADR = IWADR(IX,IX0)
          SQQ1 = SQQ1 + WGTFF1(IADR)      * FSIQCD(IX,IQ0)
          SQQ2 = SQQ2 + WGTFF2(IADR,NF)   * FSIQCD(IX,IQ0)
          SQG1 = SQG1 + WGTFG1(IADR,NF)   * FGLQCD(IX,IQ0)
          SQG2 = SQG2 + WGTFG2(IADR,NF)   * FGLQCD(IX,IQ0)
          SGQ1 = SGQ1 + WGTGF1(IADR)      * FSIQCD(IX,IQ0)
          SGQ2 = SGQ2 + WGTGF2(IADR,NF)   * FSIQCD(IX,IQ0)
          SGG1 = SGG1 + WGTGG1(IADR,NF)   * FGLQCD(IX,IQ0)
          SGG2 = SGG2 + WGTGG2(IADR,NF)   * FGLQCD(IX,IQ0)
 220    CONTINUE
        IAD = IWADR(IX0,IX0)
        SQQ = ALF*SQQ1 + AL2*SQQ2
        SQG = ALF*SQG1 + AL2*SQG2
        SGQ = ALF*SGQ1 + AL2*SGQ2
        SGG = ALF*SGG1 + AL2*SGG2
        WQQ = ALF* WGTFF1(IAD)        + AL2*WGTFF2(IAD,NF)    
        WQG = ALF* WGTFG1(IAD,NF)     + AL2*WGTFG2(IAD,NF)    
        WGQ = ALF* WGTGF1(IAD)        + AL2*WGTGF2(IAD,NF)    
        WGG = ALF* WGTGG1(IAD,NF)     + AL2*WGTGG2(IAD,NF)    
        DSI = WQQ*FSI+SQQ+WQG*FGL+SQG
        DGL = WGQ*FSI+SGQ+WGG*FGL+SGG
 
        FSI0 = FSI
        DSI0 = DSI
        FGL0 = FGL
        DGL0 = DGL
        FSIQCD(IX0,IQ0) = FSI
        DSIQCD(IX0,IQ0) = DSI
        FGLQCD(IX0,IQ0) = FGL
        DGGQCD(IX0,IQ0) = DGL
        EVL             = EVL+NXX-IX0+1
 
        DO 250 IQ = IQ0+1,IQH
          IF(IFAILC(IX0,IQ).NE.0) GOTO 250
          ALF = ALFAPQ(IQ)
          AL2 = ALFA2Q(IQ)
          DEL = DELUP(IQ)
          SQQ1 = 0.
          SQG1 = 0.
          SGQ1 = 0.
          SGG1 = 0.
          SQQ2 = 0.
          SQG2 = 0.
          SGQ2 = 0.
          SGG2 = 0.
          NF  = NFMAP(IQ)
          DO 230 IX = NXX,IX0+1,-1
            IADR = IWADR(IX,IX0)
            SQQ1 = SQQ1 + WGTFF1(IADR)      * FSIQCD(IX,IQ)
            SQQ2 = SQQ2 + WGTFF2(IADR,NF)   * FSIQCD(IX,IQ)
            SQG1 = SQG1 + WGTFG1(IADR,NF)   * FGLQCD(IX,IQ)
            SQG2 = SQG2 + WGTFG2(IADR,NF)   * FGLQCD(IX,IQ)
            SGQ1 = SGQ1 + WGTGF1(IADR)      * FSIQCD(IX,IQ)
            SGQ2 = SGQ2 + WGTGF2(IADR,NF)   * FSIQCD(IX,IQ)
            SGG1 = SGG1 + WGTGG1(IADR,NF)   * FGLQCD(IX,IQ)
            SGG2 = SGG2 + WGTGG2(IADR,NF)   * FGLQCD(IX,IQ)
 230      CONTINUE
          IAD = IWADR(IX0,IX0)
          SQQ = ALF*SQQ1 + AL2*SQQ2
          SQG = ALF*SQG1 + AL2*SQG2
          SGQ = ALF*SGQ1 + AL2*SGQ2
          SGG = ALF*SGG1 + AL2*SGG2
          WQQ = ALF* WGTFF1(IAD)        + AL2*WGTFF2(IAD,NF)    
          WQG = ALF* WGTFG1(IAD,NF)     + AL2*WGTFG2(IAD,NF)    
          WGQ = ALF* WGTGF1(IAD)        + AL2*WGTGF2(IAD,NF)    
          WGG = ALF* WGTGG1(IAD,NF)     + AL2*WGTGG2(IAD,NF)    
          AAS = 2.*FSI + (DSI+SQQ+SQG)*DEL
          BBS = 2. - WQQ*DEL
          AAG = 2.*FGL + (DGL+SGQ+SGG)*DEL
          BBG = 2. - WGG*DEL
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL)
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL)
          DSI = WQQ*FSI+SQQ+WQG*FGL+SQG
          DGL = WGQ*FSI+SGQ+WGG*FGL+SGG
          FSIQCD(IX0,IQ) = FSI
          DSIQCD(IX0,IQ) = DSI
          FGLQCD(IX0,IQ) = FGL
          DGGQCD(IX0,IQ) = DGL
          EVL            = EVL+NXX-IX0+1
 250    CONTINUE
 
        FSI = FSI0
        DSI = DSI0
        FGL = FGL0
        DGL = DGL0
 
        DO 270 IQ = IQ0-1,IQL,-1
          ALF = ALFAPQ(IQ)
          AL2 = ALFA2Q(IQ)
          DEL = DELDN(IQ)
          SQQ1 = 0.
          SQG1 = 0.
          SGQ1 = 0.
          SGG1 = 0.
          SQQ2 = 0.
          SQG2 = 0.
          SGQ2 = 0.
          SGG2 = 0.
          NF  = NFMAP(IQ)
          DO 260 IX = NXX,IX0+1,-1
            IADR = IWADR(IX,IX0)
            SQQ1 = SQQ1 + WGTFF1(IADR)      * FSIQCD(IX,IQ)
            SQQ2 = SQQ2 + WGTFF2(IADR,NF)   * FSIQCD(IX,IQ)
            SQG1 = SQG1 + WGTFG1(IADR,NF)   * FGLQCD(IX,IQ)
            SQG2 = SQG2 + WGTFG2(IADR,NF)   * FGLQCD(IX,IQ)
            SGQ1 = SGQ1 + WGTGF1(IADR)      * FSIQCD(IX,IQ)
            SGQ2 = SGQ2 + WGTGF2(IADR,NF)   * FSIQCD(IX,IQ)
            SGG1 = SGG1 + WGTGG1(IADR,NF)   * FGLQCD(IX,IQ)
            SGG2 = SGG2 + WGTGG2(IADR,NF)   * FGLQCD(IX,IQ)
 260      CONTINUE
          IAD = IWADR(IX0,IX0)
          SQQ = ALF*SQQ1 + AL2*SQQ2
          SQG = ALF*SQG1 + AL2*SQG2
          SGQ = ALF*SGQ1 + AL2*SGQ2
          SGG = ALF*SGG1 + AL2*SGG2
          WQQ = ALF* WGTFF1(IAD)        + AL2*WGTFF2(IAD,NF)    
          WQG = ALF* WGTFG1(IAD,NF)     + AL2*WGTFG2(IAD,NF)    
          WGQ = ALF* WGTGF1(IAD)        + AL2*WGTGF2(IAD,NF)    
          WGG = ALF* WGTGG1(IAD,NF)     + AL2*WGTGG2(IAD,NF)    
          AAS = 2.*FSI + (DSI+SQQ+SQG)*DEL
          BBS = 2. - WQQ*DEL
          AAG = 2.*FGL + (DGL+SGQ+SGG)*DEL
          BBG = 2. - WGG*DEL
          FSI = (AAS*BBG+WQG*AAG*DEL) / (BBS*BBG-WQG*WGQ*DEL*DEL)
          FGL = (AAG*BBS+WGQ*AAS*DEL) / (BBG*BBS-WGQ*WQG*DEL*DEL)
          DSI = WQQ*FSI+SQQ+WQG*FGL+SQG
          DGL = WGQ*FSI+SGQ+WGG*FGL+SGG
          FSIQCD(IX0,IQ) = FSI
          DSIQCD(IX0,IQ) = DSI
          FGLQCD(IX0,IQ) = FGL
          DGGQCD(IX0,IQ) = DGL
          EVL            = EVL+NXX-IX0+1
 270    CONTINUE
 
C     ----------
 300  CONTINUE !
C     ----------

      EVL = EVL*2./(NXX*(NXX+1)*NQ2)

      CALL QNTRUE(LE_DONE,NXX)
 
      RETURN
      END
 
CDECK  ID>, EVOLNM.
 
C     =====================================
      SUBROUTINE EVOLNM(UNAM,IQ0,IUQL,IUQH)
C     =====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      IF(LTIME) CALL TIMEX_LHA(T_START(3))

      CALL QTRACE('EVOLNM ',0)
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF

      IQL = IUQL
      IQH = IUQH

      IXL = MAX(ABS(IXFROMX(XMICUT)),1)
      IQD = ABS(IQFROMQ(QMICUT))
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS)))
      IQU = ABS(IQFROMQ(QMACUT))
      IF(IQD.NE.0) IQL = MAX(IQD,IQL)
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH)
 
      IF(IQL.LE.0) IQL = 1
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN
      IF(IQL.GE.IQH) THEN
        IERR = 2
        GOTO 500
      ENDIF
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN
        IERR = 4
        GOTO 500
      ENDIF
      IF(.NOT.LWT1OK) THEN
        IERR = 5
        GOTO 500
      ENDIF
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN
        IERR = 6
        GOTO 500
      ENDIF
 
      CALL QSTRIP(UNAM,NAME)
 
      NFMI = 9
      NFMA = 0
      DO 15 IQ = IQL,IQH
      NFMI = MIN(NFMI,NFMAP(IQ))
      NFMA = MAX(NFMA,NFMAP(IQ))
  15  CONTINUE
 
      DO 16 NF = NFMI,NFMA
        ID = IDCHEK(NAME,NF,'EVOLNM',1)
  16  CONTINUE
 
      IRUN = 0
      IF(LPLUS) THEN
        DO 19 NF = 3,5
        DO 18 IX0 = 1,NXX
        DO 17 IX  = IX0,NXX
          WGTNS2(IWADR(IX,IX0),NF) = WGTPM2(IWADR(IX,IX0),NF)
  17    CONTINUE
  18    CONTINUE
  19    CONTINUE
        IRUN = 1
      ENDIF
      LPLUS = .FALSE.

      IF(.NOT.LALFOK) THEN
        CALL QFILAS('EVOLNM')
        IRUN = 1
      ENDIF
      IF(.NOT.LDQ2OK) THEN
        CALL QDELQ2
        IRUN = 1
      ENDIF
 
      DO IX = 1,NXX
      LE_DONE(IX) = LEVDONE(IX,ID)
      DO IQ = 1,NQ2
        FNSQCD(IX,IQ) = PDFQCD(IX,IQ,ID)
      ENDDO   
      ENDDO   
 
      IF(IQ0.NE.IQ0_LAST(ID) .OR.
     +   IQL.NE.IQL_LAST(ID) .OR.
     +   IQH.NE.IQH_LAST(ID)     ) IRUN = 1
 
      CALL APNS(IXL,IQ0,IQL,IQH,IRUN,EVL)

      IQ0_LAST(ID) = IQ0
      IQL_LAST(ID) = IQL
      IQH_LAST(ID) = IQH
 
      DO IX = 1,NXX
      LEVDONE(IX,ID) = LE_DONE(IX)
      DO IQ = 1,NQ2
        PDFQCD(IX,IQ,ID) = FNSQCD(IX,IQ)
      ENDDO   
      ENDDO   

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
 
      IF(LTIME) THEN
        CALL TIMEX_LHA(T_END(3))
        T_SPENT(3) = T_SPENT(3)+T_END(3)-T_START(3)
        N_CALLS(3) = N_CALLS(3)+1
        E_CALLS(3) = E_CALLS(3)+EVL
      ENDIF
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r EVOLNM ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input      NAME     :'',A)')  UNAM
      WRITE(6,'( ''            IQ0      :'',I5)') IQ0
      WRITE(6,'( ''            IQLow    :'',I5)') IUQL
      WRITE(6,'( ''            IQHigh   :'',I5)') IUQH
      IF(IERR.NE.1) THEN
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0)
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL)
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH)
      ENDIF
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Value of IQL .ge. IQH'',
     +             '' (after applying Q2 cuts, if any)'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')')
      ELSEIF(IERR.EQ.4) THEN
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'',
     +             '' (after applying Q2 cuts, if any)'')')
      ELSEIF(IERR.EQ.5) THEN
        WRITE(6,'(/'' No LO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ELSEIF(IERR.EQ.6) THEN
        WRITE(6,'(/'' No NLO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ENDIF

      CALL QTRACE('EVOLNM ',1)

      STOP

      END
 
CDECK  ID>, EVOLNP.
 
C     =====================================
      SUBROUTINE EVOLNP(UNAM,IQ0,IUQL,IUQH)
C     =====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      IF(LTIME) CALL TIMEX_LHA(T_START(4))

      CALL QTRACE('EVOLNP ',0)
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF

      IQL = IUQL
      IQH = IUQH

      IXL = MAX(ABS(IXFROMX(XMICUT)),1)
      IQD = ABS(IQFROMQ(QMICUT))
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS)))
      IQU = ABS(IQFROMQ(QMACUT))
      IF(IQD.NE.0) IQL = MAX(IQD,IQL)
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH)
 
      IF(IQL.LE.0) IQL = 1
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN
      IF(IQL.GE.IQH) THEN
        IERR = 2
        GOTO 500
      ENDIF
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN
        IERR = 4
        GOTO 500
      ENDIF
      IF(.NOT.LWT1OK) THEN
        IERR = 5
        GOTO 500
      ENDIF
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN
        IERR = 6
        GOTO 500
      ENDIF
 
      CALL QSTRIP(UNAM,NAME)
 
      NFMI = 9
      NFMA = 0
      DO 15 IQ = IQL,IQH
      NFMI = MIN(NFMI,NFMAP(IQ))
      NFMA = MAX(NFMA,NFMAP(IQ))
  15  CONTINUE
 
      DO 16 NF = NFMI,NFMA
        ID = IDCHEK(NAME,NF,'EVOLNP',1)
  16  CONTINUE
 
      IRUN = 0
      IF(.NOT.LPLUS) THEN
        DO 19 NF  = 3,5
        DO 18 IX0 = 1,NXX
        DO 17 IX  = IX0,NXX
          WGTNS2(IWADR(IX,IX0),NF) = WGTPP2(IWADR(IX,IX0),NF)
  17    CONTINUE
  18    CONTINUE
  19    CONTINUE
        IRUN = 1
      ENDIF
      LPLUS = .TRUE.

      IF(.NOT.LALFOK) THEN
        CALL QFILAS('EVOLNP')
        IRUN = 1
      ENDIF
      IF(.NOT.LDQ2OK) THEN
        CALL QDELQ2
        IRUN = 1
      ENDIF
 
      DO 25 IX = 1,NXX
      DO 20 IQ = 1,NQ2
  20  CONTINUE
  25  CONTINUE
 
      DO IX = 1,NXX
      LE_DONE(IX) = LEVDONE(IX,ID)
      DO IQ = 1,NQ2
        FNSQCD(IX,IQ) = PDFQCD(IX,IQ,ID)
      ENDDO   
      ENDDO   
 
      IF(IQ0.NE.IQ0_LAST(ID) .OR.
     +   IQL.NE.IQL_LAST(ID) .OR.
     +   IQH.NE.IQH_LAST(ID)     ) IRUN = 1
 
      CALL APNS(IXL,IQ0,IQL,IQH,IRUN,EVL)

      IQ0_LAST(ID) = IQ0
      IQL_LAST(ID) = IQL
      IQH_LAST(ID) = IQH
 
      DO IX = 1,NXX
      LEVDONE(IX,ID) = LE_DONE(IX)
      DO IQ = 1,NQ2
        PDFQCD(IX,IQ,ID) = FNSQCD(IX,IQ)
      ENDDO   
      ENDDO   

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
 
      IF(LTIME) THEN
        CALL TIMEX_LHA(T_END(4))
        T_SPENT(4) = T_SPENT(4)+T_END(4)-T_START(4)
        N_CALLS(4) = N_CALLS(4)+1
        E_CALLS(4) = E_CALLS(4)+EVL
      ENDIF
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r EVOLNP ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input      NAME     :'',A)')  UNAM
      WRITE(6,'( ''            IQ0      :'',I5)') IQ0
      WRITE(6,'( ''            IQLow    :'',I5)') IUQL
      WRITE(6,'( ''            IQHigh   :'',I5)') IUQH
      IF(IERR.NE.1) THEN
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0)
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL)
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH)
      ENDIF
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Value of IQL .ge. IQH'',
     +             '' (after applying Q2 cuts, if any)'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')')
      ELSEIF(IERR.EQ.4) THEN
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'',
     +             '' (after applying Q2 cuts, if any)'')')
      ELSEIF(IERR.EQ.5) THEN
        WRITE(6,'(/'' No LO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ELSEIF(IERR.EQ.6) THEN
        WRITE(6,'(/'' No NLO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ENDIF

      CALL QTRACE('EVOLNP ',1)

      STOP

      END
 
CDECK  ID>, EVPLUS.
 
C     =====================================
      SUBROUTINE EVPLUS(UNAM,IQ0,IUQL,IUQH)
C     =====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      IF(LTIME) CALL TIMEX_LHA(T_START(4))

      CALL QTRACE('EVPLUS ',0)
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF

      IQL = IUQL
      IQH = IUQH

      IXL = MAX(ABS(IXFROMX(XMICUT)),1)
      IQD = ABS(IQFROMQ(QMICUT))
      IQD = MAX(IQD,ABS(IQFROMQ(QMINAS)))
      IQU = ABS(IQFROMQ(QMACUT))
      IF(IQD.NE.0) IQL = MAX(IQD,IQL)
      IF(IQU.NE.0) IQH = MIN(IQU+1,IQH)
 
      IF(IQL.LE.0) IQL = 1
      IF(IQH.LE.0.OR.IQH.GT.NQ2) IQH = NQ2
      IF(IQL.EQ.IQ0.AND.IQH.EQ.IQ0) RETURN
      IF(IQL.GE.IQH) THEN
        IERR = 2
        GOTO 500
      ENDIF
      IF(IQL.LT.1.OR.IQL.GE.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQH.LE.1.OR.IQH.GT.NQ2) THEN
        IERR = 3
        GOTO 500
      ENDIF
      IF(IQ0.LT.IQL.OR.IQ0.GT.IQH) THEN
        IERR = 4
        GOTO 500
      ENDIF
      IF(NFMAP(IQL).NE.NFMAP(IQH-1)) THEN
        IERR = 5
        GOTO 500
      ENDIF
      IF(.NOT.LWT1OK) THEN
        IERR = 6
        GOTO 500
      ENDIF
      IF(IORD.EQ.2.AND..NOT.LWT2OK) THEN
        IERR = 7
        GOTO 500
      ENDIF
 
      CALL QSTRIP(UNAM,NAME)
 
      NFMI = 9
      NFMA = 0
      DO 15 IQ = IQL,IQH
      NFMI = MIN(NFMI,NFMAP(IQ))
      NFMA = MAX(NFMA,NFMAP(IQ))
  15  CONTINUE
 
      DO 16 NF = NFMI,NFMA
        ID = IDCHEK(NAME,NF,'EVPLUS',1)
  16  CONTINUE
 
      IRUN = 0
      IF(.NOT.LPLUS) THEN
        DO 19 NF  = 3,5
        DO 18 IX0 = 1,NXX
        DO 17 IX  = IX0,NXX
          WGTNS2(IWADR(IX,IX0),NF) = WGTPP2(IWADR(IX,IX0),NF)
  17    CONTINUE
  18    CONTINUE
  19    CONTINUE
        IRUN = 1
      ENDIF
      LPLUS = .TRUE.

      IF(.NOT.LALFOK) THEN
        CALL QFILAS('EVPLUS')
        IRUN = 1
      ENDIF
      IF(.NOT.LDQ2OK) THEN
        CALL QDELQ2
        IRUN = 1
      ENDIF
 
      DO IX = 1,NXX
      LE_DONE(IX) = LEVDONE(IX,ID)
      DO IQ = 1,NQ2
        FNSQCD(IX,IQ) = PDFQCD(IX,IQ,ID)
      ENDDO   
      ENDDO   
 
      IF(IQ0.NE.IQ0_LAST(ID) .OR.
     +   IQL.NE.IQL_LAST(ID) .OR.
     +   IQH.NE.IQH_LAST(ID)     ) IRUN = 1
 
      CALL APNS(IXL,IQ0,IQL,IQH,IRUN,EVL)

      IQ0_LAST(ID) = IQ0
      IQL_LAST(ID) = IQL
      IQH_LAST(ID) = IQH
 
      DO IX = 1,NXX
      LEVDONE(IX,ID) = LE_DONE(IX)
      DO IQ = 1,NQ2
        PDFQCD(IX,IQ,ID) = FNSQCD(IX,IQ)
      ENDDO   
      ENDDO   

      DO I = 1,30
        DO J = 1,7
          LFFCAL(J,I)  = .FALSE.
        ENDDO
      ENDDO
 
      IF(LTIME) THEN
        CALL TIMEX_LHA(T_END(4))
        T_SPENT(4) = T_SPENT(4)+T_END(4)-T_START(4)
        N_CALLS(4) = N_CALLS(4)+1
        E_CALLS(4) = E_CALLS(4)+EVL
      ENDIF
 
      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r EVPLUS ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME   :'',A)') UNAM
      WRITE(6,'( '' Input IQ0    :'',I10)') IQ0
      WRITE(6,'( ''       IQLow  :'',I10)') IUQL
      WRITE(6,'( ''       IQHigh :'',I10)') IUQH
      IF(IERR.NE.1) THEN
        WRITE(6,'(/'' After cuts IQ0, Q20 :'',I5,E12.5)') IQ0,Q2TAB(IQ0)
        WRITE(6,'( ''            IQL, Q2L :'',I5,E12.5)') IQL,Q2TAB(IQL)
        WRITE(6,'( ''            IQH, Q2H :'',I5,E12.5)') IQH,Q2TAB(IQH)
      ENDIF
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' Value of IQL .ge. IQH'',
     +             '' (after applying Q2 cuts, if any)'')')
      ELSEIF(IERR.EQ.3) THEN
        WRITE(6,'(/'' IQL and/or IQH outside grid boundary'')')
      ELSEIF(IERR.EQ.4) THEN
        WRITE(6,'(/'' IQ0 outside the range [IQL,IQH]'')')
      ELSEIF(IERR.EQ.5) THEN
        WRITE(6,'(/'' [IQL,IQH} crosses a flavour threshold'')')
      ELSEIF(IERR.EQ.6) THEN
        WRITE(6,'(/'' No LO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ELSEIF(IERR.EQ.7) THEN
        WRITE(6,'(/'' No NLO weight tables available'',
     +             '' (please call s/r QNFILW)'')')
      ENDIF

      CALL QTRACE('EVPLUS ',1)

      STOP

      END
 
CDECK  ID>, APNS.
 
C     =========================================
      SUBROUTINE APNS(IXL,IQ0,IQL,IQH,IRUN,EVL)
C     =========================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      EVL = 0.
 
      FNS = FNSQCD(NXX,IQ0)
C     -------------------------------------------
      IF(.NOT.LE_DONE(NXX) .OR. IRUN.EQ.1) THEN !
C     -------------------------------------------
 
        NF   = NFMAP(IQ0)
        WGT  = ALFAPQ(IQ0)*WGTFF1(IWADR(NXX,NXX)) +
     +         ALFA2Q(IQ0)*WGTNS2(IWADR(NXX,NXX),NF)
        DNS  = WGT*FNS
        FNS0 = FNS
        DNS0 = DNS
        FNSQCD(NXX,IQ0) = FNS
        DNSQCD(NXX,IQ0) = DNS
        EVL             = EVL+1.
 
        DO 100 IQ = IQ0+1,IQH
          NF   = NFMAP(IQ)
          WGT  = ALFAPQ(IQ)*WGTFF1(IWADR(NXX,NXX)) +
     +           ALFA2Q(IQ)*WGTNS2(IWADR(NXX,NXX),NF)
          FNS = ( 2.*FNS + DNS*DELUP(IQ) ) / ( 2. - WGT*DELUP(IQ) )
          DNS = WGT*FNS
          FNSQCD(NXX,IQ) = FNS
          DNSQCD(NXX,IQ) = DNS
 100    CONTINUE
        EVL = EVL+IQH-IQ0
 
        FNS = FNS0
        DNS = DNS0
 
        DO 200 IQ = IQ0-1,IQL,-1
          NF   = NFMAP(IQ)
          WGT  = ALFAPQ(IQ)*WGTFF1(IWADR(NXX,NXX)) +
     +           ALFA2Q(IQ)*WGTNS2(IWADR(NXX,NXX),NF)
          FNS = ( 2.*FNS + DNS*DELDN(IQ) ) / ( 2. - WGT*DELDN(IQ) )
          DNS = WGT*FNS
          FNSQCD(NXX,IQ) = FNS
          DNSQCD(NXX,IQ) = DNS
 200    CONTINUE
        EVL = EVL+IQ0-IQL
 
C     -------
      ENDIF !
C     -------
 
C     ---------------------------
      DO 300 IX0 = NXX-1,IXL,-1 !
C     ---------------------------
 
        FNS = FNSQCD(IX0,IQ0)
        IF(LE_DONE(IX0).AND.IRUN.EQ.0) GOTO 300
        ALFAS = ALFAPQ(IQ0)
        ALFA2 = ALFA2Q(IQ0)
        SUM   = 0.
        NF    = NFMAP(IQ0)
        DO 220 IX = NXX,IX0+1,-1
          WFF1  = WGTFF1(IWADR(IX,IX0))
          WNS2  = WGTNS2(IWADR(IX,IX0),NF)
          SUM   = SUM + (ALFAS*WFF1+ALFA2*WNS2) * FNSQCD(IX,IQ0)
 220    CONTINUE
        WGT = ALFAS*WGTFF1(IWADR(IX0,IX0)) +
     +        ALFA2*WGTNS2(IWADR(IX0,IX0),NF)
        DNS = WGT*FNS + SUM
 
        FNS0 = FNS
        DNS0 = DNS
        FNSQCD(IX0,IQ0) = FNS
        DNSQCD(IX0,IQ0) = DNS
        EVL             = EVL+NXX-IX0+1
 
        DO 250 IQ = IQ0+1,IQH
          IF(IFAILC(IX0,IQ).NE.0) GOTO 250
          ALFAS = ALFAPQ(IQ)
          ALFA2 = ALFA2Q(IQ)
          DELIQ = DELUP(IQ)
          SUM   = 0.
          NF    = NFMAP(IQ)
          DO 230 IX = NXX,IX0+1,-1
            WFF1  = WGTFF1(IWADR(IX,IX0))
            WNS2  = WGTNS2(IWADR(IX,IX0),NF)
            SUM   = SUM + (ALFAS*WFF1+ALFA2*WNS2) *  FNSQCD(IX,IQ)
 230      CONTINUE
          WGT = ALFAS*WGTFF1(IWADR(IX0,IX0)) +
     +          ALFA2*WGTNS2(IWADR(IX0,IX0),NF)
          FNS = ( 2.*FNS + (DNS+SUM)*DELIQ ) / ( 2. - WGT*DELIQ )
          DNS = WGT*FNS + SUM
          FNSQCD(IX0,IQ) = FNS
          DNSQCD(IX0,IQ) = DNS
          EVL            = EVL+NXX-IX0+1
 250    CONTINUE
 
        FNS = FNS0
        DNS = DNS0
 
        DO 270 IQ = IQ0-1,IQL,-1
          ALFAS = ALFAPQ(IQ)
          ALFA2 = ALFA2Q(IQ)
          DELIQ = DELDN(IQ)
          SUM   = 0.
          NF  = NFMAP(IQ)
          DO 260 IX = NXX,IX0+1,-1
            WFF1  = WGTFF1(IWADR(IX,IX0))
            WNS2  = WGTNS2(IWADR(IX,IX0),NF)
            SUM   = SUM + (ALFAS*WFF1+ALFA2*WNS2) * FNSQCD(IX,IQ)
 260      CONTINUE
          WGT = ALFAS*WGTFF1(IWADR(IX0,IX0)) +
     +          ALFA2*WGTNS2(IWADR(IX0,IX0),NF)
          FNS = ( 2.*FNS + (DNS+SUM)*DELIQ ) / ( 2. - WGT*DELIQ )
          DNS = WGT*FNS + SUM
          FNSQCD(IX0,IQ) = FNS
          DNSQCD(IX0,IQ) = DNS
          EVL            = EVL+NXX-IX0+1
 270    CONTINUE
 
C     ----------
 300  CONTINUE !
C     ----------

      EVL = EVL*2./(NXX*(NXX+1)*NQ2)

      CALL QNTRUE(LE_DONE,NXX)
 
      RETURN
      END
 
CDECK  ID>, QNPGET.
 
C     ============================================
      DOUBLE PRECISION FUNCTION QNPGET(NAME,IX,IQ)
C     ============================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) NAME

C---  Obsolete (21/05/96): use QPDFIJ instead

      QNPGET = QPDFIJ(NAME,IX,IQ,IFL)

      RETURN
      END
 
CDECK  ID>, QPDFIJ.
 
C     ================================================
      DOUBLE PRECISION FUNCTION QPDFIJ(UNAM,IX,IQ,IFL)
C     ================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C---  Returns parton distribution 'NAME' at gridpoint IX,IQ
C---  Output IFL =  0 : Inside grid or cuts
C---               -1 : Outside grid or cuts
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CALL QTRACE('QPDFIJ ',0)
 
      QPDFIJ = 0.
      IERR   = 0
      IFL    = 0
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = 1
        GOTO 500
      ENDIF
      IF(IX.LT.1.OR.IX.GT.MXX-1 .OR.
     +   IQ.LT.1.OR.IQ.GT.MQ2-1) THEN
        IERR =  2
        IFL  = -1
        IF(LIMCK) GOTO 500
        RETURN
      ENDIF
      IF(IFAILC(IX,IQ).NE.0)   THEN
        IERR =  2
        IFL  = -1
        IF(LIMCK) GOTO 500
        RETURN
      ENDIF
 
      CALL QSTRIP(UNAM,NAME)
 
      NF = NFMAP(IQ)
      ID = IDCHEK(NAME,NF,'QPDFIJ',1)
 
      IF(ID.EQ.-1) RETURN
 
      QPDFIJ = GET_PDFIJ(ID,IX,IQ)

      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QPDFIJ ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME : '',A)') UNAM
      WRITE(6,'( ''       IX   : '',I5)') IX
      WRITE(6,'( ''       IQ   : '',I5)') IQ
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid defined'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' IX and/or IQ outside grid or cuts'')')
        IDUM = ICUTIJ(IX,IQ,1)
      ENDIF

      CALL QTRACE('QPDFIJ ',1)

      STOP
 
      END
 
CDECK  ID>, PARTXQ.
 
C     ===================================
      SUBROUTINE PARTXQ(NAME,X,Q,VAL,IFL)
C     ===================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) NAME

C---  Obsolete (21/05/96): use QPDFXQ instead

      VAL = QPDFXQ(NAME,X,Q,IFL)

      RETURN
      END
 
CDECK  ID>, QPDFXQ.
 
C     ==============================================
      DOUBLE PRECISION FUNCTION QPDFXQ(UNAM,X,Q,IFL)
C     ==============================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C---  Returns parton distribution 'NAME' at X,Q
C---  Output IFL =  0 : Inside grid
C---               -1 : Outside grid or cuts
 
      CHARACTER*(*) UNAM
      CHARACTER*5   NAME
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
      
      CALL QTRACE('QPDFXQ ',0)
 
      VAL    = 0.
      IFL    = 0
      QPDFXQ = 0.
 
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR =  1
        IFL  = -1
        GOTO 500
      ENDIF
      JFL = ICUTXQ(X,Q,0)
      IF(JFL.NE.0) THEN
        IERR =  2
        IFL  = -1
        IF(LIMCK) GOTO 500
        RETURN
      ENDIF
 
      IX  = ABS(IXFROMX(X))
      IQ  = MIN(ABS(IQFROMQ(Q)),NQ2-1)
 
      CALL QSTRIP(UNAM,NAME)
     
      NF  = NFMAP(IQ)
      ID  = IDCHEK(NAME,NF,'QPDFXQ',1)
 
      IF(.NOT.LDQ2OK) CALL QDELQ2

      TX  = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX))
      TQ  = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))

      QPDFXQ = GET_PDFXQ(ID,IX,IQ,TX,TQ)
 
      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r QPDFXQ ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input NAME : '',A)') UNAM
      WRITE(6,'( ''       X    : '',E12.5)') X
      WRITE(6,'( ''       Q2   : '',E12.5)') Q
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' No x-Q2 grid defined'')')
      ELSEIF(IERR.EQ.2) THEN
        WRITE(6,'(/'' X and/or Q2 outside grid or cuts'')')
        IDUM = ICUTXQ(X,Q,1)
      ENDIF
      
      CALL QTRACE('QPDFXQ ',1)

      STOP
      END
 
CDECK  ID>, GET_PDFIJ.
 
C     =============================================
      DOUBLE PRECISION FUNCTION GET_PDFIJ(ID,IX,IQ)
C     =============================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C--   Return parton distribution ID at IX,IQ.
C--   IX should be in the range 1,...NXX.
C--   IQ should be in the range 1,...NQ2.
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      GET_PDFIJ = 0.
 
      NF = NFMAP(IQ)
 
      DO I = 0,10
        GET_PDFIJ = GET_PDFIJ + PWGT(I,ID,NF)*PDFQCD(IX,IQ,I)
      ENDDO   
 
      RETURN
      END
 
CDECK  ID>, GET_PDFXQ.
 
C     ===================================================
      DOUBLE PRECISION FUNCTION GET_PDFXQ(ID,IX,IQ,TX,TQ)
C     ===================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C--   Return parton distribution ID at X,Q.
C--   IX gridpoint at or below x; should be in the range 1,...NXX.
C--   IQ gridpoint at or below Q; should be in the range 1,...NQ2-1.
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      F11  = GET_PDFIJ(ID,IX,IQ)
      F12  = GET_PDFIJ(ID,IX,IQ+1)
      F21  = GET_PDFIJ(ID,IX+1,IQ)
      F22  = GET_PDFIJ(ID,IX+1,IQ+1)
      F1   = (1.-TQ)*F11 + TQ*F12
      F2   = (1.-TQ)*F21 + TQ*F22

      GET_PDFXQ  = (1.-TX)*F1 + TX*F2

      RETURN
      END
 
CDECK  ID>, BKFAST.
 
C     ==============================
      SUBROUTINE BKFAST(IDF,ID,IERR)
C     ==============================

C---  Book the NDFMAX arrays available for STFAST storage.
C---  Called by STFAST.
C---  Input  : IDF = structure function identifier;
C---            1  2   3   4   5   6   7
C---           F2 FL xF3 F2c Flc F2b Flb
C---           ID = parton dist identifier (1-30).
C---  Output : set IDFAST(IDF,ID) = j; the results of
C---           STFAST for the combination IDF,ID are
C---           stored in FSTORE(ix,iq,j).
C---           If j.gt.NDFMAX (no more space) then BKFAST
C---           acts as a do-nothing & sets ierr .ne. 0.
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      IERR = 0
      IF(IDFAST(IDF,ID).EQ.0) THEN
        IF(NDFAST.EQ.30+NDFMAX) THEN
          IERR = 1
          RETURN
        ENDIF
        NDFAST = NDFAST + 1
        IDFAST(IDF,ID) = NDFAST
        ISTFID(NDFAST) = IDF
        IPDFID(NDFAST) = ID
      ENDIF

      RETURN
      END
 
CDECK  ID>, STFAST.
 
C     ===========================
      SUBROUTINE STFAST(OPT,UNAM)
C     ===========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT,UNAM
      CHARACTER*5   NAME
      CHARACTER*5   OPT5 

 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      IF(LTIME) CALL TIMEX_LHA(T_START(6))
      
      CALL QTRACE('STFAST ',0)

      IERR = 0
      IF(.NOT.LMARK) THEN
        IERR = 1
        GOTO 500
      ENDIF
 
      CALL QSTRIP(UNAM,NAME)
      CALL QSTRIP(OPT ,OPT5)
 
      JX  = 0
      JQ  = 0
      XX  = 0.
      QQ  = 0.
      IDF = IFCHEK(OPT5,NAME,JX,JQ,XX,QQ,'STFAST',1,ID) 

      IF(.NOT.LALFOK) CALL QFILAS('STFAST')
      IF(.NOT.LDQ2OK) CALL QDELQ2
 
      IF(IDF.GE.1.AND.IDF.LE.7) THEN
        CALL BKFAST(IDF,ID,IERR)
        IF(IERR.NE.0) THEN
          LFFCAL(IDF,ID) = .FALSE.
          RETURN
        ENDIF
      ELSE
        IERR = 10
        GOTO 500
      ENDIF

      IF    (IDF.EQ.1)  THEN
        CALL FASTF2(ID)
      ELSEIF(IDF.EQ.2)  THEN
        CALL FASTFL(ID)
      ELSEIF(IDF.EQ.3)  THEN
        CALL FASTF3(ID)
      ELSE
        CALL FASTFKH(IDF,ID)
      ENDIF

      IF(LTIME) THEN
        CALL TIMEX_LHA(T_END(6))
        T_SPENT(6) = T_SPENT(6)+T_END(6)-T_START(6)
        N_CALLS(6) = N_CALLS(6)+1
      ENDIF

      RETURN

 500  CONTINUE

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r STFAST ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input OPT  : '',A)') OPT
      WRITE(6,'( '' Input NAME : '',A)') UNAM
      IF(IERR.EQ.1) THEN
        WRITE(6,
     +  '(/'' No gridpoints marked for fast calculation''/
     +     '' Please call s/r QFMARK before STFAST'')')
      ELSEIF(IERR.EQ.10) THEN
        WRITE(6,'(/'' Unknown input option OPT'')')
      ENDIF
      
      CALL QTRACE('STFAST ',1)

      STOP
 
      END
 
CDECK  ID>, FASTF2.
 
C     =====================
      SUBROUTINE FASTF2(ID)
C     =====================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      DIMENSION QUARKS(MXX),GLUONS(MXX)

C--   Get adress where to store F2
      JD = IDFAST(1,ID)

C--   Loop over all Q2 gridpoints
      DO 100 IQ = 1,NQ2

C--     Initialise FSTORE and get minimum value of x
        IXMIN = 999999
        DO IX = 1,NXX
          FSTORE(IX,IQ,JD) = -401.
          IF(MARKFF(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX)
        ENDDO

C--     Is this Q2 gridpoint marked?
        IF(MARKQQ(IQ).NE.1) GOTO 100

C--     Get scale and check if inside Q2 gridboundaries
        QMU   = Q2TAB(IQ)*AAM2L + BBM2L
        IMU   = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
        IF(IMU.EQ.0) GOTO 100
        QR2   = QMU*AAAR2 + BBBR2
        IR2   = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
        IF(IR2.EQ.0) GOTO 100
 
C--     Calculate F2 for all marked gridpoints
        FACT = LOG(Q2TAB(IQ)/QMU)
        NF   = NFMAP(IMU)
        TX   = 0.
        TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
        TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))
        AS   = GET_AS(IR2,TR)
        DO IX0 = NXX,IXMIN,-1
          GLUONS(IX0) = GET_PDFXQ( 0,IX0,IMU,TX,TQ)       
          QUARKS(IX0) = GET_PDFXQ(ID,IX0,IMU,TX,TQ)       
          IF(MARKFF(IX0,IQ).EQ.1) THEN
            FFF0 = QUARKS(IX0) 
            IF(IORD.EQ.1) THEN
              FSTORE(IX0,IQ,JD) = FFF0
            ELSE
              FF = 0.
              DO IX = IX0,NXX
                FF = FF +
     +              (WGTC2Q(IWADR(IX,IX0))+
     +               WGTFF1(IWADR(IX,IX0))*FACT)*QUARKS(IX) +
     +              (WGTC2G(IWADR(IX,IX0),NF)+
     +               WGTFG1(IWADR(IX,IX0),NF)*FACT)*
     +               GLUONS(IX)*PWGT(1,ID,NF)
              ENDDO
              FSTORE(IX0,IQ,JD) = FFF0 + AS*FF
            ENDIF
          ENDIF
        ENDDO
        FSTORE(NXX+1,IQ,JD) = 0.

 100  CONTINUE

C--   Mark F2 calculated for pdf ID
      LFFCAL(1,ID) = .TRUE.

      RETURN
      END

CDECK  ID>, FASTFL.
 
C     =====================
      SUBROUTINE FASTFL(ID)
C     =====================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      DIMENSION QUARKS(MXX),GLUONS(MXX)

C--   Get adress where to store FL
      JD = IDFAST(2,ID)

C--   Loop over all Q2 gridpoints
      DO 100 IQ = 1,NQ2

C--     Initialise FSTORE and get minimum value of x
        IXMIN = 999999
        DO IX = 1,NXX
          FSTORE(IX,IQ,JD) = -401.
          IF(MARKFF(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX)
        ENDDO

C--     Is this Q2 gridpoint marked?
        IF(MARKQQ(IQ).NE.1) GOTO 100

C--     Get scale and check if inside Q2 gridboundaries
        QMU  = Q2TAB(IQ)*AAM2L + BBM2L
        IMU  = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
        IF(IMU.EQ.0) GOTO 100
        QR2   = QMU*AAAR2 + BBBR2
        IR2   = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
        IF(IR2.EQ.0) GOTO 100

C--     Calculate FL for all marked gridpoints
        FACT = LOG(Q2TAB(IQ)/QMU)*FL_FAC
        NF   = NFMAP(IMU)
        TX   = 0.
        TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
        TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))
        AS   = GET_AS(IR2,TR)
        DO IX0 = NXX,IXMIN,-1 
          GLUONS(IX0) = GET_PDFXQ( 0,IX0,IMU,TX,TQ)         
          QUARKS(IX0) = GET_PDFXQ(ID,IX0,IMU,TX,TQ)         
          IF(MARKFF(IX0,IQ).EQ.1) THEN
            FFF0 = 0.
            IF(IORD.EQ.1) THEN
              FSTORE(IX0,IQ,JD) = 0.
            ELSE
              FF = 0.
              DO IX = IX0,NXX
                FF = FF +
     +              (WGTCLQ(IWADR(IX,IX0))+
     +               WGTFF1(IWADR(IX,IX0))*FACT)*QUARKS(IX) +
     +              (WGTCLG(IWADR(IX,IX0),NF)+
     +               WGTFG1(IWADR(IX,IX0),NF)*FACT)*
     +               GLUONS(IX)*PWGT(1,ID,NF)
              ENDDO
              FSTORE(IX0,IQ,JD) = FFF0 + AS*FF
            ENDIF
          ENDIF
        ENDDO
        FSTORE(NXX+1,IQ,JD) = 0.

 100  CONTINUE

C--   Mark FL calculated for pdf ID
      LFFCAL(2,ID) = .TRUE.

      RETURN
      END
 
CDECK  ID>, FASTF3.
 
C     =====================
      SUBROUTINE FASTF3(ID)
C     =====================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      DIMENSION QUARKS(MXX)

C--   Get adress where to store F3
      JD = IDFAST(3,ID)

C--   Loop over all Q2 gridpoints
      DO 100 IQ = 1,NQ2

C--     Initialise FSTORE and get minimum value of x
        IXMIN = 999999
        DO IX = 1,NXX
          FSTORE(IX,IQ,JD) = -401.
          IF(MARKFF(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX)
        ENDDO

C--     Is this Q2 gridpoint marked?
        IF(MARKQQ(IQ).NE.1) GOTO 100

C--     Get scale and check if inside Q2 gridboundaries
        QMU  = Q2TAB(IQ)*AAM2L + BBM2L
        IMU  = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
        IF(IMU.EQ.0) GOTO 100
        QR2   = QMU*AAAR2 + BBBR2
        IR2   = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
        IF(IR2.EQ.0) GOTO 100

C--     Calculate F3 for all marked gridpoints
        FACT = LOG(Q2TAB(IQ)/QMU)
        TX   = 0.
        TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
        TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))
        AS   = GET_AS(IR2,TR)
        DO IX0 = NXX,IXMIN,-1
          QUARKS(IX0) = GET_PDFXQ(ID,IX0,IMU,TX,TQ)         
          IF(MARKFF(IX0,IQ).EQ.1) THEN
            FFF0 = QUARKS(IX0) 
            IF(IORD.EQ.1) THEN
              FSTORE(IX0,IQ,JD) = FFF0
            ELSE
              FF = 0.
              DO IX = IX0,NXX
                FF = FF +
     +              (WGTC3Q(IWADR(IX,IX0))+
     +               WGTFF1(IWADR(IX,IX0))*FACT)*QUARKS(IX)
              ENDDO
              FSTORE(IX0,IQ,JD) = FFF0 + AS*FF
            ENDIF
          ENDIF
        ENDDO
        FSTORE(NXX+1,IQ,JD) = 0.

 100  CONTINUE

C--   Mark F3 calculated for pdf ID
      LFFCAL(3,ID) = .TRUE.

      RETURN
      END
 
CDECK  ID>, FASTFKH.
 
C     ==========================
      SUBROUTINE FASTFKH(IDF,ID)
C     ==========================

C--   IDF   = 4,5,6,7 for F2c,FLc,F2b,FLb

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 

 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      REAL
     +WH_C0KG,WH_C1KG,WH_C1BKG,
     +WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ

      COMMON/QCHWGT/
     +WH_C0KG(0:MXX,MQ2,4:7),
     +WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),
     +WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),
     +WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      DIMENSION QU(MXX),GL(MXX),SI(MXX)

C--   Correct quark mass
      QMASS = CBMSTF(IDF)
      CCCC  = CHARGE(IDF)

C--   Get adress where to store FKH
      JD = IDFAST(IDF,ID)
 
C--   FKH in LO
      IF(IORD.EQ.1) THEN

        DO 100 IQ = 1,NQ2
          IXMIN = 999999
          DO IX = 1,NXX
            FSTORE(IX,IQ,JD) = -401.
            IF(MARKFH(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX)
          ENDDO
          IF(MARKQQ(IQ).NE.1) GOTO 100
          QMU = Q2TAB(IQ)*AAM2H + BBM2H
          IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
          IF(IMU.EQ.0) GOTO 100
          QR2 = QMU*AAAR2 + BBBR2
          IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
          IF(IR2.EQ.0) GOTO 100
          TQ = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
          TR = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))
          AS = GET_AS(IR2,TR)
          DO IX0 = NXX,IXMIN,-1
            IXL     = IHTAB(IX0)
            X       = XHTAB(IX0)
            TX      = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL))
            GL(IX0) = GET_PDFXQ( 0,IXL,IMU,TX,TQ)
            IF(MARKFH(IX0,IQ).EQ.1) THEN
              FF   = 0.
              DO IX = IX0,NXX
                FF     = FF   +  
     +            WH_C0KG(IX-IX0,IQ,IDF)*GL(IX)
              ENDDO   
              FSTORE(IX0,IQ,JD) = CCCC*AS*FF   
            ENDIF
          ENDDO
          FSTORE(NXX+1,IQ,JD) = 0.
 100    CONTINUE

 
C--   FKH in NLO
      ELSE

        DO 200 IQ = 1,NQ2
          IXMIN = 999999
          DO IX = 1,NXX
            FSTORE(IX,IQ,JD) = -401.
            IF(MARKFH(IX,IQ).EQ.1) IXMIN = MIN(IXMIN,IX)
          ENDDO
          IF(MARKQQ(IQ).NE.1) GOTO 200
          QMU = Q2TAB(IQ)*AAM2H + BBM2H
          IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
          IF(IMU.EQ.0) GOTO 200
          QR2 = QMU*AAAR2 + BBBR2
          IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
          IF(IR2.EQ.0) GOTO 200
          TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
          TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))
          AS   = GET_AS(IR2,TR)
          FACT = LOG(QMU/(QMASS*QMASS))         
          DO IX0 = NXX,IXMIN,-1
            IXL     = IHTAB(IX0)
            X       = XHTAB(IX0)
            TX      = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL))
            GL(IX0) = GET_PDFXQ( 0,IXL,IMU,TX,TQ)
            SI(IX0) = GET_PDFXQ( 1,IXL,IMU,TX,TQ)
            QU(IX0) = GET_PDFXQ(ID,IXL,IMU,TX,TQ)
            IF(MARKFH(IX0,IQ).EQ.1) THEN
              F1 = 0.
              F2 = 0.
              F3 = 0.
              F4 = 0.
              DO IX = IX0,NXX
                I    = IX-IX0
                F1   = F1 +  
     +          WH_C0KG(I,IQ,IDF)*GL(IX)
                F2   = F2 + 
     +         (WH_C1KG(I,IQ,IDF)+WH_C1BKG(I,IQ,IDF)*FACT)*GL(IX)
                F3   = F3 + 
     +         (WH_C1KQ(I,IQ,IDF)+WH_C1BKQ(I,IQ,IDF)*FACT)*SI(IX)
                F4   = F4 + 
     +         (WH_D1KQ(I,IQ,IDF)+WH_D1BKQ(I,IQ,IDF)*FACT)*QU(IX)
              ENDDO   
              FSTORE(IX0,IQ,JD) = CCCC * 
     +          (AS*F1+AS*AS*(F2+F3)) + AS*AS*F4
            ENDIF
          ENDDO
          FSTORE(NXX+1,IQ,JD) = 0.
 200    CONTINUE

      ENDIF

      LFFCAL(IDF,ID) = .TRUE.

 
      RETURN
      END
 
CDECK  ID>, QNFGET.
 
C     ================================================
      DOUBLE PRECISION FUNCTION QNFGET(OPT,NAME,IX,IQ)
C     ================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT,NAME

C---  Obsolete (16/07/96): use QSTFIJ instead

      QNFGET = QSTFIJ(OPT,NAME,IX,IQ,IFL)

      RETURN
      END
 
CDECK  ID>, QSTFIJ.
 
C     ====================================================
      DOUBLE PRECISION FUNCTION QSTFIJ(OPT,UNAM,IX,IQ,IFL)
C     ====================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C---  Returns stf 'OPT' from pdf 'NAME' at gridpoint IX,IQ
C---  IFL =  0 : F2 sucessfully calculated
C---         1 : Fast calculation
C---        -1 : Scale mu outside grid
 
      CHARACTER*(*) OPT,UNAM
      CHARACTER*5   NAME
      CHARACTER*5   OPT5 
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
      
      CALL QTRACE('QSTFIJ ',0)
 
      CALL QSTRIP(UNAM,NAME)
      CALL QSTRIP(OPT ,OPT5)
 
      QSTFIJ = 0.
      IFL    = 0
      X      = 0.
      Q      = 0.
      IERR   = IFCHEK(OPT5,NAME,IX,IQ,X,Q,'QSTFIJ',1,ID)

C--   Outside grid or cuts?
      IF(IERR.EQ.-2) THEN
        IFL  = -1
        RETURN
      ENDIF
 
      IF(.NOT.LALFOK) CALL QFILAS('QSTFIJ')
      IF(.NOT.LDQ2OK) CALL QDELQ2
 
      IF(IERR.EQ.1) THEN                      
        QSTFIJ = GET_F2(ID,IX,IQ,IFL) 
        IFCNT(IFL,1) = IFCNT(IFL,1)+1
      ELSEIF(IERR.EQ.2) THEN                      
        QSTFIJ = GET_FL(ID,IX,IQ,IFL) 
        IFCNT(IFL,2) = IFCNT(IFL,2)+1
      ELSEIF(IERR.EQ.3) THEN                      
        QSTFIJ = GET_F3(ID,IX,IQ,IFL) 
        IFCNT(IFL,3) = IFCNT(IFL,3)+1
C---  Use GETFKH instead of GET_FKH for the heavy quarks since 
C---  we have to interpolate on the heavy quark grid.
      ELSEIF(IERR.EQ.4) THEN
        CALL GETFKH(4,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,4) = IFCNT(IFL,4)+1
      ELSEIF(IERR.EQ.5) THEN
        CALL GETFKH(5,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,5) = IFCNT(IFL,5)+1
      ELSEIF(IERR.EQ.6) THEN
        CALL GETFKH(6,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,4) = IFCNT(IFL,4)+1
      ELSEIF(IERR.EQ.7) THEN
        CALL GETFKH(7,ID,XXTAB(IX),Q2TAB(IQ),QSTFIJ,IFL) 
        IFCNT(IFL,5) = IFCNT(IFL,5)+1
      ENDIF

      RETURN

      END
 
CDECK  ID>, STRFXQ.
 
C     =======================================
      SUBROUTINE STRFXQ(OPT,NAME,X,Q,VAL,IFL)
C     =======================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*(*) OPT,NAME

C---  Obsolete (16/07/96): use QSTFXQ instead

      VAL = QSTFXQ(OPT,NAME,X,Q,IFL)

      RETURN
      END
 
CDECK  ID>, QSTFXQ.
 
C     ==================================================
      DOUBLE PRECISION FUNCTION QSTFXQ(OPT,UNAM,X,Q,IFL)
C     ==================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
C---  IFL =  0 : F2 sucessfully calculated
C---         1 : Fast calculation
C---        -1 : Scale mu outside grid
 
      CHARACTER*(*) OPT,UNAM
      CHARACTER*5   NAME
      CHARACTER*5   OPT5 

 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
      
      CALL QTRACE('QSTFXQ ',0)
 
      CALL QSTRIP(UNAM,NAME)
      CALL QSTRIP(OPT ,OPT5)
 
      QSTFXQ = 0.
      IFL    = 0
      IERR   = IFCHEK(OPT5,NAME,0,0,X,Q,'QSTFXQ',1,ID)

C--   Outside grid or cuts?
      IF(IERR.EQ.-2) THEN
        IFL = -1
        RETURN
      ENDIF

      IF(.NOT.LALFOK) CALL QFILAS('QSTFXQ')
      IF(.NOT.LDQ2OK) CALL QDELQ2
 
      IF    (IERR.EQ.1) THEN                        
        CALL GETF2(ID,X,Q,STRF,IFL)
        IFCNT(IFL,1) = IFCNT(IFL,1)+1
      ELSEIF(IERR.EQ.2) THEN                        
        CALL GETFL(ID,X,Q,STRF,IFL)
        IFCNT(IFL,2) = IFCNT(IFL,2)+1
      ELSEIF(IERR.EQ.3) THEN                        
        CALL GETF3(ID,X,Q,STRF,IFL)
        IFCNT(IFL,3) = IFCNT(IFL,3)+1
      ELSEIF(IERR.EQ.4) THEN                        
        CALL GETFKH(4,ID,X,Q,STRF,IFL)
        IFCNT(IFL,4) = IFCNT(IFL,4)+1
      ELSEIF(IERR.EQ.5) THEN                        
        CALL GETFKH(5,ID,X,Q,STRF,IFL)
        IFCNT(IFL,5) = IFCNT(IFL,5)+1
      ELSEIF(IERR.EQ.6) THEN                        
        CALL GETFKH(6,ID,X,Q,STRF,IFL)
        IFCNT(IFL,4) = IFCNT(IFL,4)+1
      ELSEIF(IERR.EQ.7) THEN                        
        CALL GETFKH(7,ID,X,Q,STRF,IFL)
        IFCNT(IFL,5) = IFCNT(IFL,5)+1
      ENDIF

      QSTFXQ = STRF

      RETURN

      END
 
CDECK  ID>, IFCHEK.
 
C     ============================================================
      INTEGER FUNCTION IFCHEK(OPT,NAME,JX,JQ,XX,QQ,SRNAM,ISTOP,ID)
C     ============================================================

C---  Check for structure function calculation

C---  IFCHEK = -5: Q2 < 1.5 GeV2 for heavy quark stfs
C---           -4: No weight tables
C---           -3: Input NAME corresponds to gluon
C---           -2: x,Q2,M2,R2 outside grid or cuts
C---           -1: No x,Q2 grid available
C---            0: Unknown option
C---          1-7: F2, FL, xF3, F2c, FLc, F2b, FLb

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*5   OPT
      CHARACTER*5   NAME
      CHARACTER*6   SRNAM

 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL LTIME  
      REAL T_START,T_END,T_SPENT
      COMMON/QCTIME/T_START(10),T_END(10),T_SPENT(10),N_CALLS(10),
     +E_CALLS(10),LTIME
      COMMON/QCFCNT/IFCNT(-1:1,5)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

 
C--   Check if valid option 
      IERR   = IDFCHK(OPT)
      IF(IERR.EQ.0) GOTO 500
      JJ = IERR
      IF(IERR.EQ.6) JJ = 4
      IF(IERR.EQ.7) JJ = 5

C--   Check x,Q2 grid available
      IF(NXX.EQ.0.OR.NQ2.EQ.0) THEN
        IERR = -1
        GOTO 500
      ENDIF

      IF(SRNAM.NE.'STFAST') THEN
C--   --------------------------

C--     Get x, Q2 
        IF(SRNAM.EQ.'QSTFIJ') THEN
          X = XFROMIX(JX)
          Q = QFROMIQ(JQ)
        ELSE
          X = XX
          Q = QQ
        ENDIF

C--     Check x,Q2 inside grid
        QP  = Q
        IX  = ABS(IXFROMX(X))
        IQ  = MIN(ABS(IQFROMQ(Q)),NQ2-1)
        IF(IX.EQ.0.OR.IQ.EQ.0)  THEN
          IFCNT(-1,JJ) = IFCNT(-1,JJ)+1
          IERR = -2
          GOTO 500
        ENDIF

C--     Check factorisation scale inside grid or cuts
        IF(IERR.LE.3) THEN
          QM = AAM2L*Q + BBM2L
        ELSE
          QM = AAM2H*Q + BBM2H
        ENDIF
        QP   = QM
        IFLG = ICUTXQ(X,QP,0)
        IF(IFLG.NE.0) THEN
          IFCNT(-1,JJ) = IFCNT(-1,JJ)+1
          IERR = -2
          GOTO 500
        ENDIF
        IM2 = MIN(ABS(IQFROMQ(QM)),NQ2-1)

C--     Check renormalisation scale inside grid and above Lamba2
        QR  = AAAR2*QM + BBBR2
        QP  = QR
        IR2 = MIN(ABS(IQFROMQ(QR)),NQ2-1)
        IF(IR2.EQ.0 .OR. IFLG.GE.10000)  THEN
          IFCNT(-1,JJ) = IFCNT(-1,JJ)+1
          IERR = -2
          GOTO 500
        ENDIF
 
C--     Check if the parton distribution is booked
        ID = IDCHEK(NAME,NFMAP(IQ)   ,SRNAM,1)
        ID = IDCHEK(NAME,NFMAP(IQ+1) ,SRNAM,1)
        ID = IDCHEK(NAME,NFMAP(IM2)  ,SRNAM,1)
        ID = IDCHEK(NAME,NFMAP(IM2+1),SRNAM,1)
        ID = IDCHEK(NAME,NFMAP(IR2)  ,SRNAM,1)
        ID = IDCHEK(NAME,NFMAP(IR2+1),SRNAM,1)

      ELSE 
C--   ----

C--     Check if the parton distribution is booked
        NFMIN = NFMAP(1)
        NFMAX = NFMAP(NQ2)
        DO NF = NFMIN,NFMAX
          ID = IDCHEK(NAME,NF,'STFAST',1)
        ENDDO

      ENDIF
C--   -----

C--   No structure functions from the gluon
      IF(ID.EQ.0) THEN
        IERR = -3
        GOTO 500
      ENDIF

C--   Check if the weight tables are available
      IF(IERR.LE.3) THEN
        IF(IORD.EQ.2.AND..NOT.LWTFOK) THEN
          IERR = -4
          GOTO 500
        ENDIF
      ELSEIF(IERR.EQ.4) THEN
        IF(.NOT.LWFCOK) THEN
          IERR = -4
          GOTO 500
        ENDIF
      ELSEIF(IERR.EQ.5) THEN
        IF(.NOT.LWLCOK) THEN
          IERR = -4
          GOTO 500
        ENDIF
      ELSEIF(IERR.EQ.6) THEN
        IF(.NOT.LWFBOK) THEN
          IERR = -4
          GOTO 500
        ENDIF
      ELSEIF(IERR.EQ.7) THEN
        IF(.NOT.LWLBOK) THEN
          IERR = -4
          GOTO 500
        ENDIF
      ENDIF

C--   Check low Q2 for heavy quarks
      IF(SRNAM.NE.'STFAST') THEN
        IF(IERR.GE.4) THEN
          IF(LCLOWQ.AND.Q.LE.1.5) THEN
            IERR = -5
            GOTO 500
          ENDIF
        ENDIF
      ENDIF

      IFCHEK = IERR

      RETURN

 500  CONTINUE

      IFCHEK = IERR

C--   Stop?
      IF(ISTOP.EQ.0) RETURN
      IF(.NOT.LIMCK.AND.IERR.EQ.-2) RETURN

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r '',A6,'' ---> STOP'')')
     +      SRNAM
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Input Opt  : '',A)')     OPT
      WRITE(6,'( ''       Name : '',A)')     NAME
      IF(SRNAM.NE.'STFAST') THEN
        IF(SRNAM.EQ.'QSTFIJ') THEN
          WRITE(6,'( ''       IX   : '',I10  )') JX
          WRITE(6,'( ''       IQ   : '',I10  )') JQ
        ELSE
          WRITE(6,'( ''       x    : '',E12.5)') XX
          WRITE(6,'( ''       Q2   : '',E12.5)') QQ
        ENDIF
      ENDIF
      IF(IERR.EQ.0) THEN
        WRITE(6,'(/'' Unknown option'')')
      ELSEIF(IERR.EQ.-1) THEN
        WRITE(6,'(/'' No x-Q2 grid available'')')
      ELSEIF(IERR.EQ.-2) THEN
        WRITE(6,'(/'' X, Q2 or mu2 outside grid or cuts'')')
        IDUM = ICUTXQ(X,QP,1)
      ELSEIF(IERR.EQ.-3) THEN
        WRITE(6,'(/'' Strf from the gluon, no thank you'')')
      ELSEIF(IERR.EQ.-4) THEN
        WRITE(6,'(/'' No weight tables available'')')
      ELSEIF(IERR.EQ.-5) THEN
        WRITE(6,'(/'' Cannot calculate F2h, FLh for Q2 < 1.5 GeV2'')')
      ENDIF
      
      CALL QTRACE('IFCHEK ',1)

      STOP

      END
 
CDECK  ID>, IDFCHK.
 
C     =============================
      INTEGER FUNCTION IDFCHK(OPT5)
C     =============================

C--   Returns 1,2,3,4,5,6,7 for F2,Fl,xF3,F2c,FLc,F2b,FLb.
C--   Returns 0 if no valid OPT is given on input.

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      CHARACTER*5   OPT5 
 
      IDFCHK = 0
 
      IF    (OPT5(1:3).EQ.'F2 ')  THEN
        IDFCHK = 1
      ELSEIF(OPT5(1:3).EQ.'FL ')  THEN
        IDFCHK = 2
      ELSEIF(OPT5(1:3).EQ.'XF3')  THEN
        IDFCHK = 3
      ELSEIF(OPT5(1:3).EQ.'F2C')  THEN
        IDFCHK = 4
      ELSEIF(OPT5(1:3).EQ.'FLC')  THEN
        IDFCHK = 5
      ELSEIF(OPT5(1:3).EQ.'F2B')  THEN
        IDFCHK = 6
      ELSEIF(OPT5(1:3).EQ.'FLB')  THEN
        IDFCHK = 7
      ENDIF

      RETURN
      END
 
CDECK  ID>, GETF2.
 
C     ================================
      SUBROUTINE GETF2(ID,X,Q,VAL,IFL)
C     ================================
 
C---  IFL =  0 : F2 sucessfully calculated
C---         1 : Fast calculation
C---        -1 : Scale mu outside grid
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      VAL =  0.
      JER =  1
      IFL = -1
      IX = IXFROMX(X)
      IQ = IQFROMQ(Q)

      IF(IX.GT.0.AND.IQ.GT.0) THEN
        VAL = GET_F2(ID,IX,IQ,IERR)
        JER = MIN(JER,IERR)
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IQ   = -IQ
        VAL1 = GET_F2(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_F2(ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN
        IX   = -IX
        VAL1 = GET_F2(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_F2(ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IX   = -IX
        IQ   = -IQ
        VAL1 = GET_F2(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_F2(ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        VAL3 = GET_F2(ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL4 = GET_F2(ID,IX+1,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSE
        VAL  =  0.
        JER  = -1
      ENDIF
 
      IFL = JER                  
 
      RETURN
      END
 
CDECK  ID>, GET_F2.
 
C     ================================================
      DOUBLE PRECISION FUNCTION GET_F2(ID,IX0,IQ,IERR)
C     ================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C--   Input:  ID      parton distribution identifier
C--           IX0     x gridpoint
C--           Q       Q2 value    
C--   Output: IERR =  0 F2 successfully calculated
C--                =  1 Fast calculation
C--                = -1 Scale mu outside grid 
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      GET_F2 = 0.

      IF(LFFCAL(1,ID)) THEN
        IERR = 1
        JD   = IDFAST(1,ID)
        GET_F2 = FSTORE(IX0,IQ,JD)
        IF(GET_F2.GE.-99.) RETURN
      ENDIF
 
      IERR = 0
      QMU = AAM2L*Q2TAB(IQ) + BBM2L 
      IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
      IF(IMU.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF

      TX   = 0.
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
      FFF0 = GET_PDFXQ(ID,IX0,IMU,TX,TQ)           
 
      IF(IORD.EQ.1) THEN
        GET_F2 = FFF0
        RETURN
      ENDIF

      QR2 = QMU*AAAR2 + BBBR2
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
      IF(IR2.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))
 
      NF   = NFMAP(IMU)
      FACT = LOG(Q2TAB(IQ)/QMU)
      F2   = 0.
      DO IX = IX0,NXX
        QU = GET_PDFXQ(ID,IX,IMU,TX,TQ)         
        GL = GET_PDFXQ( 0,IX,IMU,TX,TQ)         
        F2 = F2 + 
     +      (WGTC2Q(IWADR(IX,IX0))+
     +       WGTFF1(IWADR(IX,IX0))*FACT)*QU +
     +      (WGTC2G(IWADR(IX,IX0),NF)+
     +       WGTFG1(IWADR(IX,IX0),NF)*FACT)*GL*PWGT(1,ID,NF)
      ENDDO    
      GET_F2 = FFF0 + GET_AS(IR2,TR)*F2

      RETURN
      END

CDECK  ID>, GETFL.
 
C     ================================
      SUBROUTINE GETFL(ID,X,Q,VAL,IFL)
C     ================================
 
 
C---  IFL =  0 : F2 sucessfully calculated
C---         1 : Fast calculation
C---        -1 : Scale mu outside grid
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      VAL =  0.
      JER =  1
      IFL = -1
      IX = IXFROMX(X)
      IQ = IQFROMQ(Q)
 
      IF(IX.GT.0.AND.IQ.GT.0) THEN
        VAL = GET_FL(ID,IX,IQ,IERR)
        JER = MIN(JER,IERR)
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IQ   = -IQ
        VAL1 = GET_FL(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_FL(ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN
        IX   = -IX
        VAL1 = GET_FL(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_FL(ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IX   = -IX
        IQ   = -IQ
        VAL1 = GET_FL(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_FL(ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        VAL3 = GET_FL(ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL4 = GET_FL(ID,IX+1,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSE
        VAL  =  0.
        JER  = -1
      ENDIF
 
      IFL = JER
 
      RETURN
      END
 
CDECK  ID>, GET_FL.
 
C     ================================================
      DOUBLE PRECISION FUNCTION GET_FL(ID,IX0,IQ,IERR)
C     ================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C--   Input:  ID      parton distribution identifier
C--           IX0     x gridpoint
C--           Q       Q2 value    
C--   Output: IERR =  0 FL successfully calculated
C--                =  1 Fast calculation
C--                = -1 Scale mu outside grid 
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      GET_FL = 0.

      IF(LFFCAL(2,ID)) THEN
        IERR = 1
        JD   = IDFAST(2,ID)
        GET_FL = FSTORE(IX0,IQ,JD)
        IF(GET_FL.GE.-99.) RETURN
      ENDIF
 
      IERR = 0

      IF(IORD.EQ.1) THEN
        GET_FL = 0.
        RETURN
      ENDIF
 
      QMU = AAM2L*Q2TAB(IQ) + BBM2L 
      IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
      IF(IMU.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF

      QR2 = QMU*AAAR2 + BBBR2
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
      IF(IR2.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF
 
      TX   = 0.
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))

      NF   = NFMAP(IMU)
      FACT = LOG(Q2TAB(IQ)/QMU)*FL_FAC
      FL   = 0.
      DO IX = IX0,NXX
        QU = GET_PDFXQ(ID,IX,IMU,TX,TQ)          
        GL = GET_PDFXQ( 0,IX,IMU,TX,TQ)          
        FL = FL + 
     +      (WGTCLQ(IWADR(IX,IX0))+
     +       WGTFF1(IWADR(IX,IX0))*FACT)*QU +
     +      (WGTCLG(IWADR(IX,IX0),NF)+
     +       WGTFG1(IWADR(IX,IX0),NF)*FACT)*GL*PWGT(1,ID,NF)
      ENDDO    
      GET_FL = GET_AS(IR2,TR)*FL

      RETURN
      END

CDECK  ID>, GETF3.
 
C     ================================
      SUBROUTINE GETF3(ID,X,Q,VAL,IFL)
C     ================================
 
 
C---  IFL =  0 : F2 sucessfully calculated
C---         1 : Fast calculation
C---        -1 : Scale mu outside grid
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      VAL =  0.
      JER =  1
      IFL = -1
      IX = IXFROMX(X)
      IQ = IQFROMQ(Q)
 
      IF(IX.GT.0.AND.IQ.GT.0) THEN
        VAL = GET_F3(ID,IX,IQ,IERR)
        JER = MIN(JER,IERR)
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IQ   = -IQ
        VAL1 = GET_F3(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_F3(ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN
        IX   = -IX
        VAL1 = GET_F3(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_F3(ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IX   = -IX
        IQ   = -IQ
        VAL1 = GET_F3(ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_F3(ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        VAL3 = GET_F3(ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL4 = GET_F3(ID,IX+1,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4
        TX   = (X-XXTAB(IX))/(XXTAB(IX+1)-XXTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSE
        VAL  =  0.
        JER  = -1
      ENDIF
 
      IFL = JER                   
 
      RETURN
      END
 
CDECK  ID>, GET_F3.
 
C     ================================================
      DOUBLE PRECISION FUNCTION GET_F3(ID,IX0,IQ,IERR)
C     ================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C--   Input:  ID      parton distribution identifier
C--           IX0     x gridpoint
C--           Q       Q2 value    
C--   Output: IERR =  0 F3 successfully calculated
C--                =  1 Fast calculation
C--                = -1 Scale mu outside grid 
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 
 
      GET_F3 = 0.

      IF(LFFCAL(3,ID)) THEN
        IERR = 1
        JD   = IDFAST(3,ID)
        GET_F3 = FSTORE(IX0,IQ,JD)
        IF(GET_F3.GE.-99.) RETURN
      ENDIF

      IERR = 0

      QMU = AAM2L*Q2TAB(IQ) + BBM2L 
      IMU = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
      IF(IMU.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF

      TX   = 0.
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
      FFF0 = GET_PDFXQ(ID,IX0,IMU,TX,TQ)         
 
      IF(IORD.EQ.1) THEN
        GET_F3 = FFF0
        RETURN
      ENDIF

      QR2 = QMU*AAAR2 + BBBR2
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
      IF(IR2.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))
 
      F3   = 0.
      FACT = LOG(Q2TAB(IQ)/QMU)
      DO IX = IX0,NXX
        QU = GET_PDFXQ(ID,IX,IMU,TX,TQ)         
        F3 = F3 + 
     +      (WGTC3Q(IWADR(IX,IX0))+
     +       WGTFF1(IWADR(IX,IX0))*FACT)*QU
      ENDDO    
      GET_F3 = FFF0 + GET_AS(IR2,TR)*F3

      RETURN
      END
 
CDECK  ID>, GETFKH.
 
C     =====================================
      SUBROUTINE GETFKH(IDF,ID,X,Q,VAL,IFL)
C     =====================================

C---  Input : IDF = 4,5,6,7 for F2c,FLc,F2b,Flb
C---          ID  = parton distribution identifier
C---          X   = x value
C---          Q   = Q2 value

C---  Output: VAL = heavy quark structure function
C---          IFL =  0 : F2 sucessfully calculated
C---                 1 : Fast calculation
C---                -1 : Scale mu outside grid
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      VAL =  0.
      IFL = -1

      JER = 1
      IX  = IHFROMH(X)
      IQ  = IQFROMQ(Q)
 
      IF(IX.GT.0.AND.IQ.GT.0) THEN
        VAL = GET_FKH(IDF,ID,IX,IQ,IERR)
        JER = MIN(JER,IERR)
      ELSEIF(IX.GT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IQ   = -IQ
        VAL1 = GET_FKH(IDF,ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_FKH(IDF,ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL  = (1.-TQ)*VAL1 + TQ*VAL2
      ELSEIF(IX.LT.0.AND.IQ.GT.0) THEN
        IX   = -IX
        VAL1 = GET_FKH(IDF,ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_FKH(IDF,ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        TX   = (X-XHTAB(IX))/(XHTAB(IX+1)-XHTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSEIF(IX.LT.0.AND.IQ.LT.0.AND.IQ.NE.-NQ2) THEN
        IX   = -IX
        IQ   = -IQ
        VAL1 = GET_FKH(IDF,ID,IX,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL2 = GET_FKH(IDF,ID,IX,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        VAL3 = GET_FKH(IDF,ID,IX+1,IQ,IERR)
        JER  = MIN(JER,IERR)
        VAL4 = GET_FKH(IDF,ID,IX+1,IQ+1,IERR)
        JER  = MIN(JER,IERR)
        TQ   = LOG(Q/Q2TAB(IQ))/LOG(Q2TAB(IQ+1)/Q2TAB(IQ))
        VAL1 = (1.-TQ)*VAL1 + TQ*VAL2
        VAL2 = (1.-TQ)*VAL3 + TQ*VAL4
        TX   = (X-XHTAB(IX))/(XHTAB(IX+1)-XHTAB(IX))
        VAL  = (1.-TX)*VAL1 + TX*VAL2
      ELSE
        VAL  =  0.
        JER  = -1
      ENDIF
 
      IFL = JER                  

 
      RETURN
      END
 
CDECK  ID>, FILLWF.
 
C     ====================================
      SUBROUTINE FILLWF(IO1,IO2,IF2,NFLAV)
C     ====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      EXTERNAL C2Q, C2QX0, C2G, CLQ, CLG, D3Q
      EXTERNAL PQGLO, PGQLO, PQQLO, PQQX0, PGGLO, PGGX0
      EXTERNAL PP1SFUN, PP1SX0, PM1SFUN, PM1SX0
      EXTERNAL FF1SFUN, FF1SX0, GF1SFUN, XP1TFUN
      EXTERNAL GG1SFUN, GG1SX0, FG1SFUN, XG1TFUN
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF
 
      EGAUSS = 0.0001
      NF     = NFLAV
 
      CWFGG  = 6.*(11./12.-NF/18.) - 6.
 
      DO 90 IX0 = 1,NXX
 
        X0 = XXTAB(IX0)
 
        YNTC2Q(IX0) = DGAUSS_LHA(C2Q,0.D0,X0,EGAUSS)
 
        SI = X0/XXTAB(IX0)
        SP = X0/XXTAB(IX0+1)
 
        IF(IO1.NE.0) THEN
          CALL S1FUNC(PQGLO  ,SP,SI,S1PQG)
          WGTFG1(IWADR(IX0,IX0),NF) =   S1PQG
          CALL S1FUNC(PGQLO  ,SP,SI,S1PGQ)
          WGTGF1(IWADR(IX0,IX0)) =   S1PGQ
          CALL S1FUNC(PQQX0  ,SP,SI,S1PQQ)
          WGTFF1(IWADR(IX0,IX0)) =   S1PQQ+2.+(8./3.)*LOG(1.-SP)
          CALL S1FUNC(PGGX0  ,SP,SI,S1PGG)
          WGTGG1(IWADR(IX0,IX0),NF) =   S1PGG+6.*LOG(1.-SP)+CWFGG
        ENDIF
 
        IF(IO2.NE.0) THEN
          TERM1 = DGAUSS_LHA(PM1SFUN,0.D0,SP,EGAUSS)
          TERM2 = DGAUSS_LHA(XP1TFUN,0.D0,SP,EGAUSS)
          TERM3 = DGAUSS_LHA(XG1TFUN,0.D0,SP,EGAUSS)
          CALL S1FUNC(PP1SX0 ,SP,SI,S1NS2)
          WGTPP2(IWADR(IX0,IX0),NF) =   S1NS2 - TERM1
          WGTNS2(IWADR(IX0,IX0),NF) =   S1NS2 - TERM1
          LPLUS                     =   .TRUE.
          CALL S1FUNC(PM1SX0 ,SP,SI,S1F32)
          WGTPM2(IWADR(IX0,IX0),NF) =   S1F32 - TERM1
          CALL S1FUNC(FF1SX0 ,SP,SI,S1FF2)
          WGTFF2(IWADR(IX0,IX0),NF) =   S1FF2 - TERM2
          CALL S1FUNC(GF1SFUN,SP,SI,S1FG2)
          WGTFG2(IWADR(IX0,IX0),NF) =   S1FG2
          CALL S1FUNC(GG1SX0 ,SP,SI,S1GG2)
          WGTGG2(IWADR(IX0,IX0),NF) =   S1GG2 - TERM3
          CALL S1FUNC(FG1SFUN,SP,SI,S1GF2)
          WGTGF2(IWADR(IX0,IX0),NF) =   S1GF2
        ENDIF
 
        IF(IF2.NE.0) THEN
          TERM = DGAUSS_LHA(C2Q,0.D0,SP,EGAUSS)
          CALL S1FUNC(C2QX0  ,SP,SI,S1C2Q)
          WGTC2Q(IWADR(IX0,IX0))    =   S1C2Q - TERM
          CALL S1FUNC(C2G    ,SP,SI,S1C2G)
          WGTC2G(IWADR(IX0,IX0),NF) =   S1C2G
          CALL S1FUNC(CLQ    ,SP,SI,S1CLQ)
          WGTCLQ(IWADR(IX0,IX0))    =   S1CLQ
          CALL S1FUNC(CLG    ,SP,SI,S1CLG)
          WGTCLG(IWADR(IX0,IX0),NF) =   S1CLG
          CALL S1FUNC(D3Q    ,SP,SI,S1D3Q)
          WGTC3Q(IWADR(IX0,IX0))    =   S1C2Q - TERM - S1D3Q
        ENDIF
 
        DO 80 IX = IX0+1,NXX
 
          SI = X0/XXTAB(IX)
          SP = X0/XXTAB(IX+1)
          SM = X0/XXTAB(IX-1)
 
          IF(IO1.NE.0) THEN
            CALL S1FUNC(PQGLO  ,SP,SI,S1PQG)
            CALL S2FUNC(PQGLO  ,SI,SM,S2PQG)
            WGTFG1(IWADR(IX,IX0),NF) =   (S1PQG-S2PQG)
            CALL S1FUNC(PGQLO  ,SP,SI,S1PGQ)
            CALL S2FUNC(PGQLO  ,SI,SM,S2PGQ)
            WGTGF1(IWADR(IX,IX0)) =    S1PGQ-S2PGQ
            CALL S1FUNC(PQQLO  ,SP,SI,S1PQQ)
            CALL S2FUNC(PQQLO  ,SI,SM,S2PQQ)
            WGTFF1(IWADR(IX,IX0)) =    S1PQQ-S2PQQ
            CALL S1FUNC(PGGLO  ,SP,SI,S1PGG)
            CALL S2FUNC(PGGLO  ,SI,SM,S2PGG)
            WGTGG1(IWADR(IX,IX0),NF) =    S1PGG-S2PGG
          ENDIF
 
          IF(IO2.NE.0) THEN
            CALL S1FUNC(PP1SFUN,SP,SI,S1NS2)
            CALL S2FUNC(PP1SFUN,SI,SM,S2NS2)
            WGTPP2(IWADR(IX,IX0),NF) =    S1NS2-S2NS2
            WGTNS2(IWADR(IX,IX0),NF) =    S1NS2-S2NS2
            CALL S1FUNC(PM1SFUN,SP,SI,S1F32)
            CALL S2FUNC(PM1SFUN,SI,SM,S2F32)
            WGTPM2(IWADR(IX,IX0),NF) =    S1F32-S2F32
            CALL S1FUNC(FF1SFUN,SP,SI,S1FF2)
            CALL S2FUNC(FF1SFUN,SI,SM,S2FF2)
            WGTFF2(IWADR(IX,IX0),NF) =    S1FF2-S2FF2
            CALL S1FUNC(GF1SFUN,SP,SI,S1FG2)
            CALL S2FUNC(GF1SFUN,SI,SM,S2FG2)
            WGTFG2(IWADR(IX,IX0),NF) =    S1FG2-S2FG2
            CALL S1FUNC(GG1SFUN,SP,SI,S1GG2)
            CALL S2FUNC(GG1SFUN,SI,SM,S2GG2)
            WGTGG2(IWADR(IX,IX0),NF) =    S1GG2-S2GG2
            CALL S1FUNC(FG1SFUN,SP,SI,S1GF2)
            CALL S2FUNC(FG1SFUN,SI,SM,S2GF2)
            WGTGF2(IWADR(IX,IX0),NF) =    S1GF2-S2GF2
          ENDIF
 
          IF(IF2.NE.0) THEN
            CALL S1FUNC(C2Q    ,SP,SI,S1C2Q)
            CALL S2FUNC(C2Q    ,SI,SM,S2C2Q)
            WGTC2Q(IWADR(IX,IX0))    =    S1C2Q-S2C2Q
            CALL S1FUNC(C2G    ,SP,SI,S1C2G)
            CALL S2FUNC(C2G    ,SI,SM,S2C2G)
            WGTC2G(IWADR(IX,IX0),NF) =    S1C2G-S2C2G
            CALL S1FUNC(CLQ    ,SP,SI,S1CLQ)
            CALL S2FUNC(CLQ    ,SI,SM,S2CLQ)
            WGTCLQ(IWADR(IX,IX0))    =    S1CLQ-S2CLQ
            CALL S1FUNC(CLG    ,SP,SI,S1CLG)
            CALL S2FUNC(CLG    ,SI,SM,S2CLG)
            WGTCLG(IWADR(IX,IX0),NF) =    S1CLG-S2CLG
            CALL S1FUNC(D3Q    ,SP,SI,S1D3Q)
            CALL S2FUNC(D3Q    ,SI,SM,S2D3Q)
            WGTC3Q(IWADR(IX,IX0)) = S1C2Q-S2C2Q-S1D3Q+S2D3Q
          ENDIF
 
  80    CONTINUE
 
  90  CONTINUE
 
      YWGT = 0.
 
      RETURN
      END
 
CDECK  ID>, IWTADR.

      INTEGER FUNCTION IWTADR(I,J,K)

C---  Upper diagonal storage: I .ge. J (!)

 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)


      IWTADR = 1 + (J-1)*(MXX+1) -
     +         (J*(J-1))/2 + (I-J) + (K-1)*(MXX*(MXX+1))/2

      RETURN
      END
 
CDECK  ID>, IWTAD.

      INTEGER FUNCTION IWTAD(I,J)

C---  Upper diagonal storage: I .ge. J (!)

 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)


      IWTAD = 1 + (J-1)*(MXX+1) - (J*(J-1))/2 + (I-J)

      RETURN
      END

CDECK  ID>, S1FUNC.
 
C     ================================
      SUBROUTINE S1FUNC(FUN,U,V,S1FUN)
C     ================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      EXTERNAL FUN
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF
 
      YWGT  = U
      S1FUN = DGAUSS_LHA(FUN,U,V,EGAUSS)*V/(V-U)
 
      YWGT = 0.
 
      RETURN
      END
 
CDECK  ID>, S2FUNC.
 
C     ================================
      SUBROUTINE S2FUNC(FUN,U,V,S2FUN)
C     ================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      EXTERNAL FUN
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF
 
      YWGT  = V
      S2FUN = DGAUSS_LHA(FUN,U,V,EGAUSS)*U/(V-U)
 
      YWGT = 0.
 
      RETURN
      END
 
CDECK  ID>, FILLO1.
 
C     =====================
      SUBROUTINE FILLO1(NF)
C     =====================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C-----          | F |     | WGTFF WGTFG |  | F |
C-----  d/dLnQ2 |   |  =  |             |  |   |
C-----          | G |     | WGTGF WGTGG |  | G |
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      REAL
     +WGTFF1,WGTFG1,
     +WGTGF1,WGTGG1,
     +WGTPP2,WGTPM2,WGTNS2,
     +WGTFF2,WGTFG2,
     +WGTGF2,WGTGG2,
     +WGTC2Q,WGTC2G,YNTC2Q,
     +WGTCLQ,WGTCLG,WGTC3Q

      COMMON/QCWEIT/
     +WGTFF1(MXX*(MXX+1)/2)    ,WGTFG1(MXX*(MXX+1)/2,3:5),
     +WGTGF1(MXX*(MXX+1)/2)    ,WGTGG1(MXX*(MXX+1)/2,3:5),
     +WGTPP2(MXX*(MXX+1)/2,3:5),WGTPM2(MXX*(MXX+1)/2,3:5),
     +WGTNS2(MXX*(MXX+1)/2,3:5),
     +WGTFF2(MXX*(MXX+1)/2,3:5),WGTFG2(MXX*(MXX+1)/2,3:5),
     +WGTGF2(MXX*(MXX+1)/2,3:5),WGTGG2(MXX*(MXX+1)/2,3:5),
     +WGTC2Q(MXX*(MXX+1)/2)    ,WGTC2G(MXX*(MXX+1)/2,3:5),
     +WGTCLQ(MXX*(MXX+1)/2)    ,WGTCLG(MXX*(MXX+1)/2,3:5),
     +WGTC3Q(MXX*(MXX+1)/2)    ,YNTC2Q(MXX)

      COMMON/QCWADR/ IWADR(MXX,MXX)

 
      DO 100 IX0=1,NXX
      X0  = XXTAB(IX0)
 
      DO 100 IXI=IX0,NXX
      SI  = X0 / XXTAB(IXI)
      SP  = X0 / XXTAB(IXI+1)
      IF(IXI.EQ.IX0) THEN
         SSP = LOG(SP) / (1.-SP)
         WPQQV = SP + 4.*LOG(1.-SP)+ 2.*SP*SSP
         WPQGV = 3. - (1.-SP)**2   + 3.*SP*SSP
         WPGQV = - 7. - SP    - 4.*(1.+SP)*SSP
         WPGGV = - 12.5 - NF/3. + 6.*LOG(1.-SP) + (1.-SP)**2
     +                        - 6.*(1.+SP)*SSP
      ELSEIF(IXI.EQ.IX0+1) THEN
         SSI = LOG(SI) / (1.-SI)
         WPQQV =  SP-1.              +   SQQ(SI,SP)            - 2.*SSI
         WPQGV = (SP-1.)*(2.-SI-SP) - 3.*SP*LOG(SP/SI)/(SP-SI) - 3.*SSI
         WPGQV =  1.-SP        + 4.*(SP+1.)*LOG(SP/SI)/(SP-SI) + 8.*SSI
         WPGGV = (1.-SP)*(2.-SI-SP) + 6.*SGG(SI,SP)           + 12.*SSI
      ELSE
         SM  = X0 / XXTAB(IXI-1)
         WPQQV =  SP-SM                     + SQQ(SI,SP) - SQQ(SI,SM)
         WPQGV = (SP-SM)*(3.-SM-SI-SP) - 3.*SP*LOG(SP/SI)/(SP-SI)
     +                                 + 3.*SM*LOG(SM/SI)/(SM-SI)
         WPGQV =  SM-SP           + 4.*(SP+1.)*LOG(SP/SI)/(SP-SI)
     +                            - 4.*(SM+1.)*LOG(SM/SI)/(SM-SI)
         WPGGV = (SM-SP)*(3.-SM-SI-SP) + 6.*( SGG(SI,SP) - SGG(SI,SM) )
      ENDIF
 
      WGTFF1(IWADR(IXI,IX0))    =      2./3.    * SI * WPQQV
 
      WGTFG1(IWADR(IXI,IX0),NF) =      1./6.    * SI * WPQGV * 2.*NF
 
      WGTGF1(IWADR(IXI,IX0))    =      2./3.    * SI * WPGQV
 
      WGTGG1(IWADR(IXI,IX0),NF) =                 SI * WPGGV
 
100   CONTINUE
 
      RETURN
      END

CDECK  ID>, SQQ.
 
C     ==================================
      DOUBLE PRECISION FUNCTION SQQ(X,Y)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      SQQ = 2./(Y-X) * ( 2.*(Y-1.)*LOG((1.-Y)/(1.-X)) - Y*LOG(Y/X) )
 
      RETURN
      END

CDECK  ID>, SGG.
 
C     ==================================
      DOUBLE PRECISION FUNCTION SGG(X,Y)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      SGG = ( (1.+Y)*LOG(Y/X) - (1.-Y)*LOG((1.-Y)/(1.-X)) ) / (Y-X)
 
      RETURN
      END
 
CDECK  ID>, QNSPLF.
 
C     ===============================================
      DOUBLE PRECISION FUNCTION QNSPLF(OPT,X,Q,NFLAV)
C     ===============================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      CHARACTER*(*) OPT
      CHARACTER*10  OPT1
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF

      DATA OPT1 /'          '/
 
      YWGT   = 0.
      NF     = NFLAV
      QNSPLF = 0.
      QPCG   = Q
      CALL QNRGET('CMASS',QMASS)
 
      LEN  = LENOCC_LHA(OPT)
      IF(LEN.GT.10 .OR. LEN.LE.0) GOTO 550
C--   Avoid changing input parameter
      OPT1(1:LEN) = OPT(1:LEN)
      CALL CLTOU_LHA(OPT1)

      IF    (LEN.GE.4.AND.OPT1(1:4).EQ.'PFF1') THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = PQQLO(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PFG1') THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GT.1..OR.X.LT.0.)      RETURN
        QNSPLF = PQGLO(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGF1') THEN
        IF(X.GT.1..OR.X.LT.0.)      RETURN
        QNSPLF = PGQLO(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGG1') THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = PGGLO(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PPL2') THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = PP1SFUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PMI2') THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = PM1SFUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PFF2') THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = FF1SFUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PFG2') THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = FG1SFUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGF2') THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = GF1SFUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'PGG2') THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = GG1SFUN(X)
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C1Q')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = C2Q(X)-CLQ(X)
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C1G')  THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = C2G(X)-CLG(X)
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C2Q')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = C2Q(X)
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C2G')  THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = C2G(X)
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'CLQ')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = CLQ(X)
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'CLG')  THEN
        IF(NF.LE.0) GOTO 500
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = CLG(X)
      ELSEIF(LEN.GE.3.AND.OPT1(1:3).EQ.'C3Q')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = C2Q(X)-D3Q(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'C02G')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = X*C02G_FUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'C12G')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = X*C12G_FUN(X)
      ELSEIF(LEN.GE.5.AND.OPT1(1:5).EQ.'C1B2G')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = X*C1B2G_FUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'C12Q')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = X*C12Q_FUN(X)
      ELSEIF(LEN.GE.5.AND.OPT1(1:5).EQ.'C1B2Q')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = X*C1B2Q_FUN(X)
      ELSEIF(LEN.GE.4.AND.OPT1(1:4).EQ.'D12Q')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = X*D12Q_FUN(X)
      ELSEIF(LEN.GE.5.AND.OPT1(1:5).EQ.'D1B2Q')  THEN
        IF(X.GE.1..OR.X.LT.0.)      RETURN
        QNSPLF = X*D1B2Q_FUN(X)
      ELSE
        GOTO 550
      ENDIF
 
      RETURN

 500  CONTINUE
      WRITE(6,'('' QNSPLF: NF not allowed'',I10, 
     +          '' ---> STOP'')') NF
      STOP

 550  CONTINUE
      WRITE(6,'('' QNSPLF: undefined option '',A,
     +          '' ---> STOP'')') OPT
      STOP

      END
 
CDECK  ID>, PQGLO.
 
C     ==================================
      DOUBLE PRECISION FUNCTION PQGLO(X)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      PQG   = NF * ( X*X + (1.-X)*(1.-X) )
 
      PQGLO = (X-YWGT)*PQG/X
 
      RETURN
      END
 
CDECK  ID>, PGQLO.
 
C     ==================================
      DOUBLE PRECISION FUNCTION PGQLO(X)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      PGQ   = 4. * ( 1. + (1.-X)*(1.-X) ) / ( 3.*X )
 
      PGQLO = (X-YWGT)*PGQ/X
 
      RETURN
      END

CDECK  ID>, PQQLO.
C
C     ==================================
      DOUBLE PRECISION FUNCTION PQQLO(X)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      PQQ   = (4./3.) * ( 1. + X*X ) / (1.-X)
C
      PQQLO = (X-YWGT)*PQQ/X
C
      RETURN
      END

CDECK  ID>, PQQX0.
C
C     ==================================
      DOUBLE PRECISION FUNCTION PQQX0(X)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      PQQX0 = (4./3.) * ( (X-YWGT)*(1.+X*X)/X - 2.*(1.-YWGT) ) / (1.-X)
C
      RETURN
      END

CDECK  ID>, PGGLO.
C
C     ==================================
      DOUBLE PRECISION FUNCTION PGGLO(X)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      PGG   = 6. * ( X/(1.-X) + (1.-X)/X + X*(1.-X) )
C
      PGGLO = (X-YWGT)*PGG/X
C
      RETURN
      END

CDECK  ID>, PGGX0.
C
C     ==================================
      DOUBLE PRECISION FUNCTION PGGX0(X)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      PGGX0 = 6. * (X-YWGT) * ( (1.-X)/(X*X) + 1. - X )
C
      RETURN
      END

CDECK  ID>, PP1SFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION PP1SFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CPFFX  = (1.+CX2) / C1MX
      CPFFMX = (1.+CX2) / C1PX
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      AAA = - CPFFX*2.*CLX*CL1MX - (2.*X+3./C1MX)*CLX - .5*C1PX*CLX2
     +      - 5.*C1MX
      BBB =   CPFFX*(.5*CLX2+C11S6*CLX+CPIA) + C1PX*CLX + C20S3*C1MX
      CCC = - CPFFX*C2S3*(C5S3+CLX) - C4S3*C1MX
C
      PQQ  = C16S9*AAA + 4.*BBB + C2S3*NF*CCC
      PQQB = - C4S9 * ( CPFFMX*CS2X + C1PX*CLX + 2.*C1MX )
C
      PP1S    = PQQ + PQQB
      PP1SFUN = (X-YWGT)*PP1S/X
C
      RETURN
      END

CDECK  ID>, PP1SX0.
C
C     ===================================
      DOUBLE PRECISION FUNCTION PP1SX0(X)
C     ===================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      YREM   = YWGT
      YWGT   = 0.
      PPLUS  = PP1SFUN(X)
      PMINU  = PM1SFUN(X)
      YWGT   = YREM
      PP1SX0 = (X-YWGT)*PPLUS/X - (1.-YWGT)*PMINU
C
      RETURN
      END

CDECK  ID>, PM1SFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION PM1SFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CPFFX  = (1.+CX2) / C1MX
      CPFFMX = (1.+CX2) / C1PX
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      AAA = - CPFFX*2.*CLX*CL1MX - (2.*X+3./C1MX)*CLX - .5*C1PX*CLX2
     +      - 5.*C1MX
      BBB =   CPFFX*(.5*CLX2+C11S6*CLX+CPIA) + C1PX*CLX + C20S3*C1MX
      CCC = - CPFFX*C2S3*(C5S3+CLX) - C4S3*C1MX
C
      PQQ  = C16S9*AAA + 4.*BBB + C2S3*NF*CCC
      PQQB = - C4S9 * ( CPFFMX*CS2X + C1PX*CLX + 2.*C1MX )
C
      PM1S    = PQQ - PQQB
      PM1SFUN = (X-YWGT)*PM1S/X
C
      RETURN
      END

CDECK  ID>, PM1SX0.
C
C     ===================================
      DOUBLE PRECISION FUNCTION PM1SX0(X)
C     ===================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      YREM   = YWGT
      YWGT   = 0.
      PMINU  = PM1SFUN(X)
      YWGT   = YREM
      PM1SX0 = (X-YWGT)*PMINU/X - (1.-YWGT)*PMINU
C
      RETURN
      END

CDECK  ID>, FF1SFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION FF1SFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CPFFX  = (1.+CX2) / C1MX
      CPFFMX = (1.+CX2) / C1PX
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      AAA = - CPFFX*CLX*(1.5+2.*CL1MX) + 2.*CPFFMX*CS2X
     +      - 1. + X + (.5-1.5*X)*CLX - .5*C1PX*CLX2
      BBB =   CPFFX*(C11S6*CLX+.5*CLX2+CPIA) - CPFFMX*CS2X
     +      + C14S3*C1MX
      CCC = - CPFFX*(C10S9+C2S3*CLX) + C40S9/X - 2.*C1PX*CLX2
     +      - C16S3 + C40S3*X + (10.*X+C16S3*CX2+2.)*CLX
     +      - C112S9*CX2
C
      FF1S    = C16S9*AAA + 4.*BBB + C2S3*NF*CCC
      FF1SFUN = (X-YWGT)*FF1S/X
C
      RETURN
      END
 
CDECK  ID>, FF1SX0.
C
C     ===================================
      DOUBLE PRECISION FUNCTION FF1SX0(X)
C     ===================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      YREM   = YWGT
      YWGT   = 0.
      FF1S   = FF1SFUN(X)
      XP1T   = XP1TFUN(X)
      YWGT   = YREM
      FF1SX0 = (X-YWGT)*FF1S/X - (1.-YWGT)*XP1T
C
      RETURN
      END

CDECK  ID>, GF1SFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION GF1SFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CL1MX2 = CL1MX**2
      CPGFX  = CX2 + C1MX**2
      CPGFMX = CX2 + C1PX**2
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      AAA =   4. - 9.*X + (4.*X-1.)*CLX + (2.*X-1.)*CLX2
     +      + 4.*CL1MX
     +      + (2.*CLX-2.*CLX*CL1MX+CLX2-2.*CL1MX+CL1MX2+CPIE)
     +      * 2. * CPGFX
      DDD =   C182S9 + C14S9*X + C40S9/X + (C136S3*X-C38S3)*CLX
     +      - 4.*CL1MX - (2.+8.*X)*CLX2 + 2.*CS2X*CPGFMX
     +      + (C44S3*CLX-CLX2-2.*CL1MX2+4.*CL1MX+CPIF) * CPGFX
C
      GF1S    = C2S3*NF*AAA + 1.5*NF*DDD
      GF1SFUN = (X-YWGT)*GF1S/X
C
      RETURN
      END

CDECK  ID>, XP1TFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION XP1TFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CL1MX2 = CL1MX**2
      CPFFX  = (1.+CX2) / C1MX
      CPFFMX = (1.+CX2) / C1PX
      CPFGX  = (1.+C1MX**2) / X
      CPFGMX = - (1.+C1PX**2) / X
      CS1X   = -DDILOG_LHA(1.D0-X)
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      AAA =   CPFFX*(1.5*CLX-2.*CLX2+2.*CLX*CL1MX) + 2.*CPFFMX*CS2X
     +      - 1. + X + (-1.5+.5*X)*CLX + .5*C1PX*CLX2
      BBB =   CPFFX*(C11S6*CLX+.5*CLX2+CPIA) - CPFFMX*CS2X
     +      + C14S3*C1MX
      CCC = - CPFFX*(C2S3*CLX+C10S9)
     +      - C52S3 + C28S3*X + C112S9*CX2 - C40S9/X
     +      - (10.+18.*X+C16S3*CX2)*CLX + 2.*C1PX*CLX2
      PFF1T = C16S9*AAA + 4.*BBB + C2S3*NF*CCC
C
      AAA = -.5 + 4.5*X + (-8.+.5*X)*CLX + 2.*X*CL1MX
     +      + (1.-.5*X)*CLX2
     +      + (CL1MX2+4.*CLX*CL1MX-8.*CS1X-CPIB) * CPFGX
      BBB =   C62S9 - C35S18*X - C44S9*CX2
     +      + (2.+12.*X+C8S3*CX2) * CLX
     +      - 2.*X*CL1MX - (4.+X)*CLX2 + CPFGMX*CS2X
     +      + ( - 2.*CLX*CL1MX - 3.*CLX - 1.5*CLX2
     +      - CL1MX2 + 8.*CS1X + CPIC ) * CPFGX
      PFG1T = C16S9*AAA + 4.*BBB
C
      XP1T    = X * ( PFF1T + PFG1T )
      XP1TFUN = (X-YWGT)*XP1T/X
C
      RETURN
      END

CDECK  ID>, GG1SFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION GG1SFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CL1MX2 = CL1MX**2
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      CPGG  = 1./C1MX + 1./X -2. + X - CX2
      CMPGG = 1./C1PX - 1./X -2. - X - CX2
C
c      AAA   = -16.+ 8.*X+ C20S3*CX2 + C4S3/X + (-6.-10.*X)*CLX +
      AAA   = -16.+ 8.*X+ C20S3*CX2 + C4S3/X + (-6.-10.*X)*CLX 
     +        -2.*C1PX*CLX2
      BBB   = 2.* C1MX +  26./9.*(CX2-1./X) - C4S3*C1PX*CLX -
     +        20./9.*CPGG	
      CCC   = 27./2.*C1MX + 67./9.*(CX2-1./X)+(-25./3.+11./3.*x-
     +        44./3.*CX2)*CLX+4.*C1PX*CLX2+(67./9.-4.*CLX*CL1MX +
     +        CLX2-CPI2S3)*CPGG + 2.*CMPGG*CS2X
C
      GG1S    = C2S3*NF*AAA + 1.5*NF*BBB + 9.* CCC
      GG1SFUN = (X-YWGT)*GG1S/X
C
      RETURN
      END

CDECK  ID>, GG1SX0.
C
C     ===================================
      DOUBLE PRECISION FUNCTION GG1SX0(X)
C     ===================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      YREM   = YWGT
      YWGT   = 0.
      GG1S   = GG1SFUN(X)
      XG1T   = XG1TFUN(X)
      YWGT   = YREM
      GG1SX0 = (X-YWGT)*GG1S/X - (1.-YWGT)*XG1T
C
      RETURN
      END

CDECK  ID>, FG1SFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION FG1SFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CL1MX2 = CL1MX**2
      CPFGX  = (1.+C1MX**2) / X
      CPFGMX = - (1.+C1PX**2) / X
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      AAA   = -5./2.- 7./2.*X+(2.+7./2.*X)*CLX+(-1.+0.5*X)*CLX2 
     +        -2.*X*CL1MX+ (-3.*CL1MX-CL1MX2)*CPFGX
      BBB   = 28./9.+65./18.*X+44./9.*CX2+(-12.-5.*X-8./3.*CX2)*CLX+
     +        (4.+X)*CLX2+2.*X*CL1MX+ (-2.*CLX*CL1MX+0.5*CLX2+
     +        11./3.*CL1MX+CL1MX2-0.5*CPI2S3+0.5)*CPFGX+CPFGMX*CS2X
      CCC   = -C4S3*X- (20./9.+C4S3*CL1MX)*CPFGX
C
      FG1S    = C16S9*AAA+4.*BBB+2./3.*NF*CCC
      FG1SFUN = (X-YWGT)*FG1S/X
C
      RETURN
      END

CDECK  ID>, XG1TFUN.
C
C     ====================================
      DOUBLE PRECISION FUNCTION XG1TFUN(X)
C     ====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
C
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
C
      CX2    = X**2
      C1PX   = 1.+X
      C1MX   = 1.-X
      CLX    = LOG(X)
      CLX2   = CLX**2
      CL1MX  = LOG(C1MX)
      CL1PX  = LOG(C1PX)
      CL1MX2 = CL1MX**2
      CPGFX  = CX2 + C1MX**2
      CPGFMX = CX2 + C1PX**2
      CS1X   = -DDILOG_LHA(1.D0-X)
      CS3X   = -DDILOG_LHA(-X)
      CS2X   = .5*(CLX2-CPI2S3) + 2.*(CS3X-CLX*CL1PX)
C
      CPGG  = 1./C1MX + 1./X -2. + X - CX2
      CMPGG = 1./C1PX - 1./X -2. - X - CX2
C
      AAA   = -4.+12.*x-164./9.*CX2+92./9./X+(10.+14.*X+C16S3*CX2+
     +        C16S3/X)*CLX + 2.*C1PX*CLX2
      BBB   = 2.-2.*X+26./9.*(CX2-1./X)-C4S3*C1PX*CLX-
     +        (20./9.+8./3.*CLX)*CPGG
      CCC   = 27./2.*(C1MX)+67./9.*(CX2-1./X)+(11./3.-25./3.*X-
     +        44./3./X)*CLX -4.*(C1PX) * CLX2 + (4.*CLX*CL1MX -
     +        3.*CLX2+22./3.*CLX-CPI2S3+67./9.)*CPGG+
     +        2.*CMPGG*CS2X
      PGG1T = 2./3.*NF*AAA+3./2.*NF*BBB+9.*CCC
C
      AAA   = -8./3.-(16./9.+8./3.*CLX+8./3.*CL1MX)*CPGFX
      BBB   = -2.+3.*X+(-7.+8.*X)*CLX-4.*CL1MX + (1.-2.*X)*CLX2
     +        +(-4.*CLX*CL1MX-2.*CLX2-2.*CL1MX+2.*CLX-2.*CL1MX2
     +        +16.*CS1X+ 2.*PI*PI - 10.)*CPGFX
      CCC   = -152./9.+166./9.*X-40./9./X+ (-C4S3-76./3.*X)*CLX+
     +        4.*CL1MX + (2.+8.*X)*CLX2+ (8.*CLX*CL1MX-CLX2-
     +        C4S3*CLX+10./3.*CL1MX+2.*CL1MX2-16.*CS1X-7.*CPI2S3+
     +        178./9.)*CPGFX+2.*CPGFMX*CS2X
      PGF1T = (0.5*NF)**2*AAA+2./3.*NF*BBB+3./2.*NF*CCC
C
      XG1T    = X * ( PGG1T + PGF1T )
      XG1TFUN = (X-YWGT)*XG1T/X
C
      RETURN
      END
 
CDECK  ID>, C2Q.
 
C     ================================
      DOUBLE PRECISION FUNCTION C2Q(X)
C     ================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      C1MX = 1.-X
      C2Q = 3. + C5S3*X + (C4S3*LOG(C1MX/X)-1.) * (1.+X**2) / C1MX
      C2Q = (X-YWGT)*C2Q/X
 
      RETURN
      END
 
CDECK  ID>, C2QX0.
 

C     ==================================
      DOUBLE PRECISION FUNCTION C2QX0(X)
C     ==================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      C1MX = 1.-X
      C2Q = 3. + C5S3*X + (C4S3*LOG(C1MX/X)-1.) * (1.+X**2) / C1MX
 
      C2QX0 = ((X-YWGT)/X+YWGT-1.)*C2Q
 
      RETURN
      END

CDECK  ID>, C2G.
 
C     ================================
      DOUBLE PRECISION FUNCTION C2G(X)
C     ================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      C1MX = 1. - X
      C2G = -.5 + 4.*X*C1MX + .5 * (X**2+C1MX**2) * LOG(C1MX/X)
      C2G = 2.*NF*(X-YWGT)*C2G/X
 
      RETURN
      END
 
CDECK  ID>, CLQ.
 
C     ================================
      DOUBLE PRECISION FUNCTION CLQ(X)
C     ================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      CLQ = C8S3*X
      CLQ = (X-YWGT)*CLQ/X
 
      RETURN
      END
 
CDECK  ID>, CLG.
 
C     ================================
      DOUBLE PRECISION FUNCTION CLG(X)
C     ================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      CLG = NF*4.*X*(1.-X)
      CLG = (X-YWGT)*CLG/X
 
      RETURN
      END
 
CDECK  ID>, D3Q.
 
C     ================================
      DOUBLE PRECISION FUNCTION D3Q(X)
C     ================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 

C--   C3Q = C2Q - D3Q
 
      COMMON /QCWGTC/ YWGT,QPGC,QMASS,EGAUSS,NF
 
      D3Q = C4S3*(1.+X)
C--   Fixed this bug in QCDNUM16.11 17-01-98
C     D3Q = (X-YWGT)*C3Q/X
      D3Q = (X-YWGT)*D3Q/X
 
      RETURN
      END
 
CDECK  ID>, PCGFUN.
 
C     ===================================
      DOUBLE PRECISION FUNCTION PCGFUN(X)
C     ===================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C--   Pcg (heavy quark) splitting function taken from
C--   Glueck, Hoffmann and Reya, Z. Phys. C13(1982)119 eq. (2.6).
C--   Notice that if YWGT is set to zero, PCGFUN(X) returns Pcg(x).
C--   Q2 and the quark mass are passed through the common block
C--   /QCWGTC/ as QPCG and QMASS respectively.
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF
 
      FACTOR = QMASS*QMASS/QPCG
      PCG    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        U    = 1.-X
        V    = SQRT(1.-4.*FACTOR*X/(1.-X))
        PCG  = (1./V)*(0.5-X*U+FACTOR*X*(3.-4.*X)/U
     +         -16.*FACTOR*FACTOR*X*X)  -
     +         (2.*FACTOR*X*(1.-3.*X)-8.*FACTOR*FACTOR*X*X)
     +         *LOG((1.+V)/(1.-V))
      ENDIF
      PCGFUN = (X-YWGT)*PCG/X
 
      RETURN
      END
 
CDECK  ID>, QASTOL.
 
C     ==============================
      SUBROUTINE LFROMA(AS,Q2,QL,NF)
C     ==============================

C---  Calculate Lambda^(nf) given alpha_s(Q^2)

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r LFROMA ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'(/'' This s/r is not available......     '')')

      STOP
      END

 
CDECK  ID>, AFROML.
 
C     ==============================
      SUBROUTINE AFROML(QL,NF,AS,Q2)
C     ==============================

C---  Calculate alpha_s(Q^2) given Lambda^(nf)

      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r AFROML ---> STOP'')')
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'(/'' This s/r is not available......     '')')

      STOP
      END
 
CDECK  ID>, QNALFA.
 
C     =====================================
      DOUBLE PRECISION FUNCTION QNALFA(QQ2)
C     =====================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      IF(LBMARK) THEN
c fix for rgr
         call rgras(qnalfa,qq2)
c      print *,' 1 rgras called and NF is ',nf
c        F      = 4.
c        QCDL   = 0.250
c        QNALFA = QNALAM(F,QQ2,QCDL,IORD)
      ELSEIF(LASOLD) THEN
        QNALFA = A0TOA1_OLD(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR)
      ELSE
        QNALFA = A0TOA1(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR)
      ENDIF

      RETURN
      END
 
CDECK  ID>, QALFAS.
 
C     ===================================================
      DOUBLE PRECISION FUNCTION QALFAS(QQ2,QLAMB,NF,IERR)
C     ===================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      IF(LBMARK) THEN
c fix for rgr alphas
c      print *,' 2 rgras called and NF is '
        call rgras(qalfas,qq2)
        QLAMB  = SQRT(Q_LAMB2(QQ2,QALFAS,NF,IORD))
c        F      = 4.
c        QCDL   = 0.250
c        QALFAS = QNALAM(F,QQ2,QCDL,IORD)
c        NF     = F
c        QLAMB  = 0.
      ELSEIF(LASOLD) THEN
        QALFAS = A0TOA1_OLD(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR)
        QLAMB  = SQRT(Q_LAMB2(QQ2,QALFAS,NF,IORD))
        IF(IERR.NE.0) QLAMB = 0.
      ELSE
        QALFAS = A0TOA1(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR)
        QLAMB  = SQRT(Q_LAMB2(QQ2,QALFAS,NF,IORD))
        IF(IERR.NE.0) QLAMB = 0.
      ENDIF

      RETURN
      END

CDECK  ID>, QFILAS.

C     ========================
      SUBROUTINE QFILAS(SRNAM)
C     ========================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 
 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      CHARACTER*6 SRNAM

C--   Check quark masses
      IF(.NOT.(0.LE.UDSCBT(1) .AND. UDSCBT(1).LE.UDSCBT(2) .AND.
     + UDSCBT(2).LE.UDSCBT(3) .AND. UDSCBT(3).LT.UDSCBT(4) .AND.
     + UDSCBT(4).LT.UDSCBT(5) .AND. UDSCBT(5).LT.UDSCBT(6))) THEN
        IERR = 1
        GOTO 500
      ENDIF

      IF(LBMARK) THEN
c-- This is a fix to put in the RGR alphas
        DO IQ = 1,NQ2

C--       Alphas at the renormalistion scale
          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2
c      print *,' 3 rgras called and iord is ',iord
          call rgras(ALF,QQ2)
c      print *,nf,iord,alf,qq2
          BET0       = 11.-2*NF/3.
          ALFASQ(IQ) = ALF
          ALFAPQ(IQ) = ALF/(2.*PI)
          ALFA2Q(IQ) = 0.
          IF(IORD.GE.2) THEN
            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ)
            FACT       = LOG(QQ2/Q2TAB(IQ))*BET0*0.5
            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ))
          ENDIF

        ENDDO   


cC--     Alphas for benchmark tests (HERA workshop)
c
c        F    = 4.
c        QCDL = 0.250
c
c        DO IQ = 1,NQ2
c
cC--       Alphas at the renormalistion scale
c          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2
c          ALFASQ(IQ) = QNALAM(F,QQ2,QCDL,IORD)
c          BET0       = 11.-2.*F/3.
c          ALFAPQ(IQ) = ALFASQ(IQ) /(2.*PI)
c          ALFA2Q(IQ) = 0.
c          IEALFA(IQ) = 0
c          IF(IORD.GE.2) THEN
c            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ)
c            FACT = LOG(QQ2/Q2TAB(IQ))*BET0*0.5
c            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ))
c          ENDIF
c
c        ENDDO   

      ELSEIF(LASOLD) THEN

C--     Alphas from old routine (for backwards compatibility)

        DO IQ = 1,NQ2

C--       Alphas at the renormalistion scale
          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2
          ALFASQ(IQ) = A0TOA1_OLD(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR)
          BET0       = 11.-2*NF/3.
          IEALFA(IQ) = IERR
          ALFAPQ(IQ) = ALFASQ(IQ) /(2.*PI)
          ALFA2Q(IQ) = 0.
          IF(IORD.GE.2) THEN
            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ)
            FACT       = LOG(QQ2/Q2TAB(IQ))*BET0*0.5
            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ))
          ENDIF

        ENDDO   

      ELSE

C--     This is the alphas to be used

        DO IQ = 1,NQ2

C--       Alphas at the renormalistion scale
          QQ2        = Q2TAB(IQ)*AAAR2 + BBBR2
          ALF        = A0TOA1(QQ2,Q0ALFA,ALPHA0,IORD,NF,IERR)
c          print *,iord,nf,qq2,alf
          BET0       = 11.-2*NF/3.
          IEALFA(IQ) = IERR
          ALFASQ(IQ) = ALF
          ALFAPQ(IQ) = ALF/(2.*PI)
          ALFA2Q(IQ) = 0.
          IF(IORD.GE.2) THEN
            ALFA2Q(IQ) = ALFAPQ(IQ)*ALFAPQ(IQ)
            FACT       = LOG(QQ2/Q2TAB(IQ))*BET0*0.5
            ALFAPQ(IQ) = ALFAPQ(IQ)*(1.+FACT*ALFAPQ(IQ))
          ENDIF

        ENDDO   

      ENDIF

      LALFOK = .TRUE.
C--   Invalidate all evolutions      
      CALL QNFALS(LEVDONE,MXX*10)

C--   Find lowest Q2 for which alpha_s is calculated
      QMINAS = Q2TAB(NQ2)
      DO IQ = NQ2,1,-1
        IF(IEALFA(IQ).EQ.0) QMINAS = Q2TAB(IQ)
      ENDDO

      RETURN

 500  CONTINUE
      WRITE(6,'(/'' ------------------------------------'')')
      WRITE(6,'( '' QCDNUM error in s/r '',A,'' ---> STOP'')')
     +              SRNAM
      WRITE(6,'( '' ------------------------------------'')')
      WRITE(6,'( '' Umass           :'',E12.5)') UDSCBT(1)
      WRITE(6,'( '' Dmass           :'',E12.5)') UDSCBT(2)
      WRITE(6,'( '' Smass           :'',E12.5)') UDSCBT(3)
      WRITE(6,'( '' Cmass           :'',E12.5)') UDSCBT(4)
      WRITE(6,'( '' Bmass           :'',E12.5)') UDSCBT(5)
      WRITE(6,'( '' Tmass           :'',E12.5)') UDSCBT(6)
      IF(IERR.EQ.1) THEN
        WRITE(6,'(/'' Quark masses not in ascending order'')')
      ENDIF

      CALL QTRACE('QFILAS ',1)

      STOP

      END

CDECK  ID>, GET_AS.
 
C     =======================================
      DOUBLE PRECISION FUNCTION GET_AS(IQ,TQ)
C     =======================================

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C--   Interpolation of alpha_s table: returns alpha_s/(2pi)
C--   Input IQ must be in the range 1,...,NQ2-1

 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

      GET_AS = ((1.-TQ)*ALFASQ(IQ)+TQ*ALFASQ(IQ+1))/(2.*PI)

      RETURN
      END

CDECK  ID>, QNALAM.
 
C     =================================================
      DOUBLE PRECISION FUNCTION QNALAM (F,Q2,QCDL,IORD)
C     =================================================

      IMPLICIT DOUBLE PRECISION (A - Z)
      INTEGER IORD

      DATA PI / 3.14159265359 /

C---  Calculation of alpha strong (Q**2) in NLO :
C---  F    = number of flavours
C---  Q2   = Q**2 in GeV**2
C---  QCDL = Lambda(MSbar) in GeV

      B0     = 11.D0 - 2.D0/3.D0 * F
      B0S    = B0 * B0
      B1     = 102.D0 - 38.D0/3.D0 * F
      LAM2   = QCDL * QCDL
      LQ2    = DLOG (Q2/LAM2)
      QNALAM = 1.D0/(B0 * LQ2)
      IF(IORD.GE.2) QNALAM = QNALAM - 1.D0/(B0 * LQ2) * 
     +              (B1/B0S * DLOG(LQ2)/LQ2)
      QNALAM = QNALAM*4.D0*PI

      RETURN
      END

CDECK  ID>, A0TOA1.
 
C     ===========================================================
      DOUBLE PRECISION FUNCTION A0TOA1(QSU,QS0,AS0,IORD,NFF,IERR)
C     ===========================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      QS1   = QSU

      QMU0  = SQRT(QS0)
      QMU1  = SQRT(QS1)
 
      DO 10 I=1,6
      IF(QMU0.GE.UDSCBT(I)) NF0 = I
      IF(QMU1.GE.UDSCBT(I)) NF1 = I
  10  CONTINUE
 
      IF(NF1.LT.NF0) THEN
        IST = -1
        JST =  0
      ELSE
        IST = 1
        JST = 1
      ENDIF
 
      ALFA0 = AS0
      Q00   = QS0
 
      DO 50 NF = NF0,NF1,IST
 
      IF(NF.NE.NF1) THEN
        Q21 = UDSCBT(NF+JST)*UDSCBT(NF+JST)
      ELSE
        Q21 = QS1
      ENDIF
      ALFA1 = ALPHAR(Q21,Q00,ALFA0,NF,IORD,JERR)
      ALFA0 = ALFA1
      Q00   = Q21
 
  50  CONTINUE
 
      A0TOA1 = ALFA0
      NFF    = NF1
      IERR   = JERR
 
      RETURN
      END
 
C     ===============================================================
      DOUBLE PRECISION FUNCTION A0TOA1_OLD(QSU,QS0,AS0,IORD,NFF,IERR)
C     ===============================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      QS1   = QSU
 
      QMU0  = SQRT(QS0)
      QMU1  = SQRT(QS1)
 
      DO 10 I=1,6
      IF(QMU0.GE.UDSCBT(I)) NF0 = I
      IF(QMU1.GE.UDSCBT(I)) NF1 = I
  10  CONTINUE
 
      IF(NF1.LT.NF0) THEN
        IST = -1
        JST =  0
      ELSE
        IST = 1
        JST = 1
      ENDIF
 
      ALFA0 = AS0
      Q00   = QS0
 
      DO 50 NF = NF0,NF1,IST
 
      IF(NF.NE.NF1) THEN
        Q21 = UDSCBT(NF+JST)*UDSCBT(NF+JST)
      ELSE
        Q21 = QS1
      ENDIF
      ALFA0 = ALPHAR_OLD(Q21,Q00,ALFA0,NF,IORD,JERR)
      Q00   = Q21
 
  50  CONTINUE
 
      A0TOA1_OLD = ALFA0
      NFF        = NF1
      IERR       = JERR
 
      RETURN
      END

CDECK  ID>, ALPHAR.
 
C     ==========================================================
      DOUBLE PRECISION FUNCTION ALPHAR(QSQ,QS0,AS0,NF,IORD,IERR)
C     ==========================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C--   ALPHAS FROM RGE GIVEN AS0 AT QS0
 
      DATA PI / 3.14159265359 /

      BET0 = 11.-2*NF/3.
      BET1 = 102.-38*NF/3.
      B0   = BET0/(4.*PI)
      B1   = BET1/(4.*PI*BET0)
      IERR = 0

      TERM0 = 1./AS0+B0*LOG(QSQ/QS0)
      IF(TERM0.LE.0.) THEN
        ALPHAR = 100.
        IERR   = 1
        RETURN
      ENDIF
      ALFA0 = 1./TERM0
      IF(IORD.EQ.1) THEN
        ALPHAR = ALFA0
        RETURN
      ENDIF
  20  CONTINUE
      ARG   = (1./ALFA0+B1)/(1./AS0+B1)
      IF(ARG.LE.0.) THEN
        ALPHAR = 100.
        IERR   = 1
        RETURN
      ELSE 
        TERM  = TERM0+B1*LOG(ARG)
        IF(TERM.LE.0) THEN
          ALPHAR = 100.
          IERR   = 1
          RETURN
        ELSE
          ALFA1 = 1./TERM
        ENDIF
      ENDIF 
      IF(ABS(ALFA1-ALFA0).GT.1.E-6) THEN
        ALFA0 = ALFA1
        GOTO 20
      ENDIF
 
      ALPHAR = ALFA1
 
      RETURN
      END
 
C     ==============================================================
      DOUBLE PRECISION FUNCTION ALPHAR_OLD(QSQ,QS0,AS0,NF,IORD,IERR)
C     ==============================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C-----MARCHIANO: ALPHAS FROM RGE GIVEN AS0 AT QS0
C-----This routine uses an incorrect truncation -->
C-----alpha_s is about 0.4% too low. 
 
      DATA PI    / 3.1415927 /
 
      QMU  = SQRT(QSQ)
      QM0  = SQRT(QS0)
 
      B3   = -(11.-2.*NF/3.)/(2.*PI)
      B33  = -(51.-19.*NF/3.)/(4.*PI*PI)
      B333 = -(2857.-5033.*NF/9.+325.*NF*NF/27.)/(64.*PI*PI*PI)
      IERR = 0
 
      TERM0 = 1./AS0-B3*LOG(QMU/QM0)
      ALFA0 = 1./TERM0
      IF(IORD.EQ.1) THEN
        ALPHAR_OLD  = ALFA0
        RETURN
      ENDIF
  20  CONTINUE
      TERM = TERM0-B33*LOG(ALFA0/AS0)/B3
      IF(IORD.EQ.3) TERM = TERM-(B333*B3-B33*B33)*(ALFA0-AS0)/(B3*B3)
      ALFA1 = 1./TERM
      IF(ABS(ALFA1-ALFA0).GT.1.E-6) THEN
        ALFA0 = ALFA1
        GOTO 20
      ENDIF
 
      ALPHAR_OLD = ALFA1
 
      RETURN
      END

CDECK  ID>, Q_LAMB2.
 
C     ==================================================
      DOUBLE PRECISION FUNCTION Q_LAMB2(QS0,AS0,NF,IORD)
C     ==================================================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C--   Calculate lambda**2 given AS0 at QS0 
 
      DATA PI / 3.14159265359 /

      BET0 = 11.-2*NF/3.
      BET1 = 102.-38*NF/3.
      AS   = AS0/(4.*PI)

      Q_LAMB2 = QS0*EXP(-1./(BET0*AS))

      IF(IORD.EQ.1) RETURN

      ARG     = 1. + BET0/(BET1*AS)
      POW     = BET1/(BET0*BET0)
      Q_LAMB2 = Q_LAMB2*ARG**POW

      RETURN
      END 

CDECK  ID>, QHEAVY.

c Heavy quark structure functions.
c Heavy quark coefficient functions up to NLO are taken from the code
c of S. Riemersma. For reference, see S. Riemersma, J. Smith and
c W.L. van Neerven, Phys. Lett. B347(1995)143.
 
CDECK  ID>, GET_FKH.
 
C     =====================================================
      DOUBLE PRECISION FUNCTION GET_FKH(IDF,ID,IX0,IQ,IERR)
C     =====================================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
C--   Input:  IDF  =  4,5,6,7 for F2c,Flc,F2b,Flb
C--   Input:  ID      parton distribution identifier
C--           IX0     x gridpoint of heavy quark grid
C--           IQ      Q2 gridpoint
C--   Output: IERR =  0 FKH successfully calculated
C--                =  1 Fast calculation
C--                = -1 Scale mu outside grid
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      LOGICAL
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL,LASOLD

      COMMON/QCFLAG/ 
     +IORD,IOLAST,
     +LDOUBL,LBMARK,LWF2C,LWF2B,LWFLC,LWFLB,
     +LW1ANA,LW1NUM,LW2NUM,LW2STF,LIMCK,LPLUS,
     +LALFOK,LDQ2OK,LWT1OK,LWT2OK,
     +LWTFOK,LWFCOK,LWLCOK,LWFBOK,LWLBOK,LMARK,LCLOWQ,
     +LFFCAL(7,30),LASOLD
 
 
      CHARACTER*5 PNAM,STFNAM
      LOGICAL     LNFP
      COMMON /QCLNFP/ LNFP(0:30,3:5)
      COMMON /QCPNAM/ PNAM(0:30)
      COMMON /QCPWGT/ PWGT(0:10,0:30,3:5)
      COMMON /QCFNAM/ STFNAM(7)
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      REAL
     +WH_C0KG,WH_C1KG,WH_C1BKG,
     +WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ

      COMMON/QCHWGT/
     +WH_C0KG(0:MXX,MQ2,4:7),
     +WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),
     +WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),
     +WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)

 
      COMMON/QCPASS/
     +ALPHA0, Q0ALFA, ASLAST, QALAST,
     +ALFASQ(MQ2), ALFAPQ(MQ2), ALFA2Q(MQ2),
     +DELUP(MQ2), DELDN(MQ2), PDFQCD(MXX,MQ2,0:10),
     +FNSQCD(MXX,MQ2),DNSQCD(MXX,MQ2),
     +FSIQCD(MXX,MQ2),DSIQCD(MXX,MQ2),
     +FGLQCD(MXX,MQ2),DGGQCD(MXX,MQ2),
     +FSTORE(MXX,MQ2,31:30+NDFMAX),IDFAST(7,30),NDFAST,
     +MARKFF(MXX,MQ2),MARKFH(MXX,MQ2),MARKQQ(MQ2),
     +ISTFID(31:30+NDFMAX),IPDFID(31:30+NDFMAX),IEALFA(MQ2),
     +IQL_LAST(10),IQ0_LAST(10),IQH_LAST(10)

      LOGICAL LEVDONE,LE_DONE
      COMMON/QCLEVL/
     +LEVDONE(MXX,10),LE_DONE(MXX)
 

C--   Correct quark mass
      QMASS = CBMSTF(IDF)
      CCCC  = CHARGE(IDF)

      GET_FKH = 0.
 
      IF(LFFCAL(IDF,ID)) THEN
        IERR = 1
        JD   = IDFAST(IDF,ID)
        GET_FKH = FSTORE(IX0,IQ,JD)
        IF(GET_FKH.GE.-99.) RETURN
      ENDIF
 
      QMU  = Q2TAB(IQ)*AAM2H + BBM2H
      IMU  = MIN(ABS(IQFROMQ(QMU)),NQ2-1)
      IF(IMU.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF
      QR2 = QMU*AAAR2 + BBBR2
      IR2 = MIN(ABS(IQFROMQ(QR2)),NQ2-1)
      IF(IR2.EQ.0) THEN
        IERR = -1
        RETURN
      ENDIF

      IERR = 0
      TQ   = LOG(QMU/Q2TAB(IMU))/LOG(Q2TAB(IMU+1)/Q2TAB(IMU))
      TR   = LOG(QR2/Q2TAB(IR2))/LOG(Q2TAB(IR2+1)/Q2TAB(IR2))   
 
      IF(IORD.EQ.1) THEN
 
        FF = 0.
        DO IX = IX0,NXX
          IXL = IHTAB(IX)           
          X   = XHTAB(IX)       
          TX  = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL))
          GL  = GET_PDFXQ(0,IXL,IMU,TX,TQ)
          FF  = FF + WH_C0KG(IX-IX0,IQ,IDF)*GL
        ENDDO    
        GET_FKH = CCCC * GET_AS(IR2,TR) * FF

      ELSE

        AS = GET_AS(IR2,TR)
        F1 = 0.
        F2 = 0.
        F3 = 0.
        F4 = 0.
        FACT = LOG(QMU/(QMASS*QMASS))         
        DO IX = IX0,NXX
          IXL = IHTAB(IX)           
          X   = XHTAB(IX)       
          TX  = (X-XXTAB(IXL))/(XXTAB(IXL+1)-XXTAB(IXL))
          GL  = GET_PDFXQ( 0,IXL,IMU,TX,TQ)
          SI  = GET_PDFXQ( 1,IXL,IMU,TX,TQ)
          QU  = GET_PDFXQ(ID,IXL,IMU,TX,TQ)
          I   = IX-IX0
          F1  = F1 +  WH_C0KG(I,IQ,IDF)*GL
          F2  = F2 + (WH_C1KG(I,IQ,IDF)+WH_C1BKG(I,IQ,IDF)*FACT)*GL
          F3  = F3 + (WH_C1KQ(I,IQ,IDF)+WH_C1BKQ(I,IQ,IDF)*FACT)*SI
          F4  = F4 + (WH_D1KQ(I,IQ,IDF)+WH_D1BKQ(I,IQ,IDF)*FACT)*QU
        ENDDO    
        GET_FKH = CCCC * (AS*F1+AS*AS*(F2+F3)) + AS*AS*F4
      ENDIF

      RETURN
      END
 
CDECK  ID>, FIL_F2H.
 
C     =======================
      SUBROUTINE FIL_F2H(IDF)
C     =======================
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      EXTERNAL C02G_FUN, C12G_FUN, C1B2G_FUN
      EXTERNAL           C12Q_FUN, C1B2Q_FUN
      EXTERNAL           D12Q_FUN, D1B2Q_FUN
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      REAL
     +WH_C0KG,WH_C1KG,WH_C1BKG,
     +WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ

      COMMON/QCHWGT/
     +WH_C0KG(0:MXX,MQ2,4:7),
     +WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),
     +WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),
     +WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)

 
      QMASS  = CBMSTF(IDF)

      EGAUSS = 0.001
 
      DO 400 IQ = 1,NQ2

        QPCG = Q2TAB(IQ)
        APCG = 1.+4.*QMASS*QMASS/QPCG

        IX0 = 1
        X0  = XHTAB(IX0)

*       WRITE(6,'('' Calculate F2H weights for IX ='',I4)') IX0

        DO 200 IX = IX0,NXX

          XI   = XHTAB(IX)
          XIP1 = XHTAB(IX+1)
          IF(IX.GT.IX0) XIM1 = XHTAB(IX-1)
          IF(XIP1.LE.X0*APCG) GOTO 200
          XI   = MAX(XI,X0*APCG)
          SIP1 = X0/XIP1
          SI   = X0/XI

          CALL S1FUNC(C02G_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C02G_FUN,SI,SIM1,S2FUN)
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C12G_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C12G_FUN,SI,SIM1,S2FUN)
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C1B2G_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C1B2G_FUN,SI,SIM1,S2FUN)
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C12Q_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C12Q_FUN,SI,SIM1,S2FUN)
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C1B2Q_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C1B2Q_FUN,SI,SIM1,S2FUN)
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(D12Q_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(D12Q_FUN,SI,SIM1,S2FUN)
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(D1B2Q_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(D1B2Q_FUN,SI,SIM1,S2FUN)
            WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

 200    CONTINUE

 400  CONTINUE
 
      RETURN
      END
 
CDECK  ID>, C02G_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION C02G_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      DATA PI       /3.14159265359/
 
      FACTOR = QMASS*QMASS/QPCG
      C02G    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        C02G = (C0_LG(ETA,XI)+C0_TG(ETA,XI)) * XI / (2.*PI)
      ENDIF
      C02G_FUN = (X-YWGT)*C02G/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C12G_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION C12G_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C12G    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        BET  = SQRT(ETA/(1.+ETA))
        RHO  = 1./(1.+ETA)
        C12G = CATF * (H1_ALG(ETA,XI)+H1_ATG(ETA,XI)) +
     +         CFTF * (H1_FLG(ETA,XI)+H1_FTG(ETA,XI)) +
     +  CATF * BET  * (GFUN_L(ETA,XI)+GFUN_T(ETA,XI)) +
     +  CATF * RHO  * (EFUN_LA(ETA,XI)+EFUN_TA(ETA,XI)) +
     +  CFTF * RHO  * (EFUN_LF(ETA,XI)+EFUN_TF(ETA,XI))
        C12G = C12G*4.*PI/FACTOR
      ENDIF
      C12G_FUN = (X-YWGT)*C12G/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C1B2G_FUN.
 
C     ======================================
      DOUBLE PRECISION FUNCTION C1B2G_FUN(X)
C     ======================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C1B2G    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI    = 1./FACTOR
        ETA   = XI * (1.-X)/(4.*X) - 1.
        BET   = SQRT(ETA/(1.+ETA))
        RHO   = 1./(1.+ETA)
        C1B2G = CATF * (H1BAR_LG(ETA,XI)+H1BAR_TG(ETA,XI)) +
     +   CATF * BET  * (GBAR_L(ETA,XI)+GBAR_T(ETA,XI)) +
     +   CATF * RHO  * (EBAR_LA(ETA,XI)+EBAR_TA(ETA,XI))
        C1B2G = C1B2G*4.*PI/FACTOR
      ENDIF
      C1B2G_FUN = (X-YWGT)*C1B2G/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C12Q_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION C12Q_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C12Q    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        BET  = SQRT(ETA/(1.+ETA))
        BET3 = BET*BET*BET
        RHO  = 1./(1.+ETA)
        C12Q = CFTF * (H1_HLQ(ETA,XI)+H1_HTQ(ETA,XI)) +
     +  CFTF * BET3 * (GFUN_L(ETA,XI)+GFUN_T(ETA,XI))
        C12Q = C12Q*4.*PI/FACTOR
      ENDIF
      C12Q_FUN = (X-YWGT)*C12Q/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C1B2Q_FUN.
 
C     ======================================
      DOUBLE PRECISION FUNCTION C1B2Q_FUN(X)
C     ======================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C1B2Q    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI    = 1./FACTOR
        ETA   = XI * (1.-X)/(4.*X) - 1.
        BET   = SQRT(ETA/(1.+ETA))
        BET3  = BET*BET*BET
        RHO   = 1./(1.+ETA)
        C1B2Q = CFTF * (H1BAR_HLQ(ETA,XI)+H1BAR_HTQ(ETA,XI)) +
     +   CFTF * BET3 * (GBAR_L(ETA,XI)+GBAR_T(ETA,XI))
        C1B2Q = C1B2Q*4.*PI/FACTOR
      ENDIF
      C1B2Q_FUN = (X-YWGT)*C1B2Q/(X*X)
 
      RETURN
      END
 
CDECK  ID>, D12Q_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION D12Q_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      D12Q    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        IF(QPCG.LE.1.5) THEN
          D12Q = CFTF * (H1F_LLQ(ETA,XI)+H1F_LTQ(ETA,XI))
        ELSE
          D12Q = CFTF * (H1_LLQ(ETA,XI)+H1_LTQ(ETA,XI))
        ENDIF
        D12Q = D12Q*4.*PI/FACTOR
      ENDIF
      D12Q_FUN = (X-YWGT)*D12Q/(X*X)
 
      RETURN
      END
 
CDECK  ID>, D1B2Q_FUN.
 
C     ======================================
      DOUBLE PRECISION FUNCTION D1B2Q_FUN(X)
C     ======================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      D1B2Q    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        IF(QPCG.LE.1.5) THEN
          D1B2Q = CFTF * H1BAR_LTQ(ETA,XI)
        ELSE
          D1B2Q = 0.
        ENDIF
        D1B2Q = D1B2Q*4.*PI/FACTOR
      ENDIF
      D1B2Q_FUN = (X-YWGT)*D1B2Q/(X*X)
 
      RETURN
      END
 
CDECK  ID>, FIL_FLH.
 
C     =======================
      SUBROUTINE FIL_FLH(IDF)
C     ======================= 
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      EXTERNAL C0LG_FUN, C1LG_FUN, C1BLG_FUN
      EXTERNAL           C1LQ_FUN, C1BLQ_FUN
      EXTERNAL           D1LQ_FUN, D1BLQ_FUN
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 
 
      PARAMETER ( MXX = 410 )
      PARAMETER ( MQ2 =  120 )

C--   Do not set the following parameter to zero!
      PARAMETER ( NDFMAX = 20)

 
      COMMON/QCGRID/
     +SCAX0,SCAQ0,XMICUT,QMICUT,QMACUT,RS2CUT,QMINAS,
     +XXTAB(MXX),Q2TAB(MQ2),XHTAB(MXX),THRS34,THRS45,
     +NXX,NQ2,NGRVER,IHTAB(MXX),NFMAP(MQ2),IQF2C(MQ2),
     +IQF2B(MQ2),IQFLC(MQ2),IQFLB(MQ2),IFAILC(MXX,MQ2)
 

      REAL
     +WH_C0KG,WH_C1KG,WH_C1BKG,
     +WH_C1KQ,WH_C1BKQ,WH_D1KQ,WH_D1BKQ

      COMMON/QCHWGT/
     +WH_C0KG(0:MXX,MQ2,4:7),
     +WH_C1KG(0:MXX,MQ2,4:7),WH_C1BKG(0:MXX,MQ2,4:7),
     +WH_C1KQ(0:MXX,MQ2,4:7),WH_C1BKQ(0:MXX,MQ2,4:7),
     +WH_D1KQ(0:MXX,MQ2,4:7),WH_D1BKQ(0:MXX,MQ2,4:7)

 
      QMASS  = CBMSTF(IDF)
 
      EGAUSS = 0.001
 
      DO 400 IQ = 1,NQ2

        QPCG = Q2TAB(IQ)
        APCG = 1.+4.*QMASS*QMASS/QPCG

        IX0 = 1
        X0  = XHTAB(IX0)

*       WRITE(6,'('' Calculate FLH weights for IX ='',I4)') IX0

        DO 200 IX = IX0,NXX

          XI   = XHTAB(IX)
          XIP1 = XHTAB(IX+1)
          IF(IX.GT.IX0) XIM1 = XHTAB(IX-1)
          IF(XIP1.LE.X0*APCG) GOTO 200
          XI   = MAX(XI,X0*APCG)
          SIP1 = X0/XIP1
          SI   = X0/XI

          CALL S1FUNC(C0LG_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C0LG_FUN,SI,SIM1,S2FUN)
            WH_C0KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C1LG_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C1LG_FUN,SI,SIM1,S2FUN)
            WH_C1KG(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C1BLG_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C1BLG_FUN,SI,SIM1,S2FUN)
            WH_C1BKG(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C1LQ_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C1LQ_FUN,SI,SIM1,S2FUN)
            WH_C1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(C1BLQ_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(C1BLQ_FUN,SI,SIM1,S2FUN)
            WH_C1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

          CALL S1FUNC(D1LQ_FUN,SIP1,SI,S1FUN)
          IF(IX.EQ.IX0) THEN
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN
          ELSE
            SIM1 = X0/XIM1
            CALL S2FUNC(D1LQ_FUN,SI,SIM1,S2FUN)
            WH_D1KQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
          ENDIF

*         CALL S1FUNC(D1BLQ_FUN,SIP1,SI,S1FUN)
*         IF(IX.EQ.IX0) THEN
*           WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN
*         ELSE
*           SIM1 = X0/XIM1
*           CALL S2FUNC(D1BLQ_FUN,SI,SIM1,S2FUN)
*           WH_D1BKQ(IX-IX0,IQ,IDF) = S1FUN-S2FUN
*         ENDIF
          WH_D1BKQ(IX-IX0,IQ,IDF) = 0.

 200    CONTINUE

 400  CONTINUE
 
      RETURN
      END
 
CDECK  ID>, C0LG_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION C0LG_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      DATA PI       /3.14159265359/
 
      FACTOR = QMASS*QMASS/QPCG
      C0LG    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        C0LG = C0_LG(ETA,XI) * XI / (2.*PI)
      ENDIF
      C0LG_FUN = (X-YWGT)*C0LG/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C1LG_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION C1LG_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C1LG    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        BET  = SQRT(ETA/(1.+ETA))
        RHO  = 1./(1.+ETA)
        C1LG = CATF * H1_ALG(ETA,XI) +
     +         CFTF * H1_FLG(ETA,XI) +
     +  CATF * BET  * GFUN_L(ETA,XI) +
     +  CATF * RHO  * EFUN_LA(ETA,XI) +
     +  CFTF * RHO  * EFUN_LF(ETA,XI)
        C1LG = C1LG*4.*PI/FACTOR
      ENDIF
      C1LG_FUN = (X-YWGT)*C1LG/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C1BLG_FUN.
 
C     ======================================
      DOUBLE PRECISION FUNCTION C1BLG_FUN(X)
C     ======================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C1BLG    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI    = 1./FACTOR
        ETA   = XI * (1.-X)/(4.*X) - 1.
        BET   = SQRT(ETA/(1.+ETA))
        RHO   = 1./(1.+ETA)
        C1BLG = CATF * H1BAR_LG(ETA,XI) +
     +   CATF * BET  * GBAR_L(ETA,XI) +
     +   CATF * RHO  * EBAR_LA(ETA,XI)
        C1BLG = C1BLG*4.*PI/FACTOR
      ENDIF
      C1BLG_FUN = (X-YWGT)*C1BLG/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C1LQ_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION C1LQ_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C1LQ    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        BET  = SQRT(ETA/(1.+ETA))
        BET3 = BET*BET*BET
        RHO  = 1./(1.+ETA)
        C1LQ = CFTF * H1_HLQ(ETA,XI) +
     +  CFTF * BET3 * GFUN_L(ETA,XI)
        C1LQ = C1LQ*4.*PI/FACTOR
      ENDIF
      C1LQ_FUN = (X-YWGT)*C1LQ/(X*X)
 
      RETURN
      END
 
CDECK  ID>, C1BLQ_FUN.
 
C     ======================================
      DOUBLE PRECISION FUNCTION C1BLQ_FUN(X)
C     ======================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      C1BLQ    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI    = 1./FACTOR
        ETA   = XI * (1.-X)/(4.*X) - 1.
        BET   = SQRT(ETA/(1.+ETA))
        BET3  = BET*BET*BET
        RHO   = 1./(1.+ETA)
        C1BLQ = CFTF * H1BAR_HLQ(ETA,XI) +
     +   CFTF * BET3 * GBAR_L(ETA,XI)
        C1BLQ = C1BLQ*4.*PI/FACTOR
      ENDIF
      C1BLQ_FUN = (X-YWGT)*C1BLQ/(X*X)
 
      RETURN
      END
 
CDECK  ID>, D1LQ_FUN.
 
C     =====================================
      DOUBLE PRECISION FUNCTION D1LQ_FUN(X)
C     =====================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      FACTOR = QMASS*QMASS/QPCG
      D1LQ    = 0.
      IF(X.LT.(1./(1.+4.*FACTOR))) THEN
        XI   = 1./FACTOR
        ETA  = XI * (1.-X)/(4.*X) - 1.
        IF(QPCG.LE.1.5) THEN
          D1LQ = CFTF * H1F_LLQ(ETA,XI)
        ELSE
          D1LQ = CFTF * H1_LLQ(ETA,XI)
        ENDIF
        D1LQ = D1LQ*4.*PI/FACTOR
      ENDIF
      D1LQ_FUN = (X-YWGT)*D1LQ/(X*X)
 
      RETURN
      END
 
CDECK  ID>, D1BLQ_FUN.
 
C     ======================================
      DOUBLE PRECISION FUNCTION D1BLQ_FUN(X)
C     ======================================
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
 
 
      COMMON/QCCONS/
     +PI,PROTON,EUTRON,UCLEON,UDSCBT(6),AAM2H,BBM2H,AAM2L,BBM2L,
     +AAAR2,BBBR2,FL_FAC,CBMSTF(4:7),CHARGE(4:7),
     +C1S3,C2S3,C4S3,C5S3,C8S3,C11S3,C14S3,C16S3,C20S3,C22S3,C28S3,
     +C38S3,C40S3,C44S3,C52S3,C136S3,C11S6,C2S9,C4S9,C10S9,C14S9,C16S9,
     +C40S9,C44S9,C62S9,C112S9,C182S9,C11S12,C35S18,C61S12,C215S1,
     +C29S12,CPI2S3,CPIA,CPIB,CPIC,CPID,CPIE,CPIF,CCA,CCF,CTF,CATF,CFTF
 
 

      COMMON /QCWGTC/ YWGT,QPCG,QMASS,EGAUSS,NF

      D1BLQ_FUN = 0.
 
      RETURN
      END

CDECK  ID>, BORN.

c This gives the Born coefficients 
c For QCD take tf = 1d0/2d0, for QED take  tf = 1d0.
c eta = (s - 4d0*m2)/4d0/m2, s is the gamma* gluon (gamma) CM Energy
c xi = Q^2/m2

c     =======================================
      double precision function C0_Lg(eta,xi)
c     =======================================

c     Longitudinal coefficient function: PL B347(1995)143 eq. (7).
c     This function is called born_l in the original code.

      implicit none
      double precision eta, xi, pi, tf
*     common/group/ca, cf, tf
      parameter(tf = 0.5d0)
      parameter(pi = 3.14159265359d0)

      C0_Lg  = 0.5d0*pi*tf*xi*(1.d0 + eta + 0.25d0*xi)**(-3.d0)*
     #         (2.d0*dsqrt(eta*(1.d0 + eta)) -
     #         dlog((dsqrt(1.d0 + eta) + dsqrt(eta))/
     #              (dsqrt(1.d0 + eta) - dsqrt(eta))))

      return
      end

c     =======================================
      double precision function C0_Tg(eta,xi)
c     =======================================

c     Transverse coefficient function: PL B347(1995)143 eq. (8).
c     This function is called born_t in the original code.

      implicit none
      double precision eta, xi, pi, tf
*     common/group/ca, cf, tf
      parameter(tf = 0.5d0)
      parameter(pi = 3.14159265359d0)

      C0_Tg  = 0.5d0*pi*tf*(1.d0 + eta + 0.25d0*xi)**(-3)*
     #         (-2.d0*((1.d0 + eta - 0.25d0*xi)**2 + eta + 1.d0)*
     #         dsqrt(eta/(1.d0 + eta)) + (2.d0*(1.d0 + eta)**2 +
     #         0.125d0*xi**2 + 2.d0*eta + 1.d0)*
     #         dlog((dsqrt(1.d0 + eta) + dsqrt(eta))/
     #              (dsqrt(1.d0 + eta) - dsqrt(eta))))

      return
      end

CDECK  ID>, ASYMP.

c These are the functions that give the asymptotic dependence of the
c coefficient functions with the appropriate factors. xi = mq2/m2 (Q^2/m2) 
c If xi is small, the regular routines have convergence
c problems and we take the limit. (not anymore after code update 03/06/96).

c     ==========================================
      double precision function Gfun_L(dummy,xi)
c     ==========================================

c     Longitudinal: equation (19) in PLB347 (1995) 143 - 151
c     This function is called asymp_l in the original code.

      implicit none
      double precision xilast, store
      double precision dummy
      double precision xi, pi, term1
      double precision fii, fjj
*     double precision fii_lim, fjj_lim
      parameter (pi = 3.14159265359d0)

      save xilast, store

      data xilast, store /0.D0, 0.D0/

      if(xi.eq.xilast) then
        Gfun_L = store
        return
      endif

*     term1 = 1.d0/(1.d0 + 0.25d0*xi)

*     if (xi .le. 1.d-1) then
*        Gfun_L = 1.d0/6.d0/pi*(-4.d0/3.d0*term1 + 
*    #        (1.d0  - 1.d0/6.d0*term1)*fjj_lim(xi) -
*    #        2.d0* (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0) +
*    #        0.25d0*term1*fii_lim(xi) -
*    #        3.d0* (1.d0/3.d0 - xi/10.d0 + 11.d0*xi**2/420.d0))
*     else
*        Gfun_L = 1.d0/6.d0/pi*(4.d0/xi - 4.d0/3.d0*term1 
*    #        + (1.d0 - 2.d0/xi - 1.d0/6.d0*term1)*fjj(xi)
*    #        - (3.d0/xi + 0.25d0*term1)*fii(xi))
*     endif

      term1   = 1.d0/(1.d0 + 0.25d0*xi)

      Gfun_L  = 1.d0/6.d0/pi*(4.d0/xi - 4.d0/3.d0*term1 
     #     + (1.d0 - 2.d0/xi - 1.d0/6.d0*term1)*fjj(xi)
     #     - (3.d0/xi + 0.25d0*term1)*fii(xi))

      xilast = xi
      store  = Gfun_L

      return
      end

c     ==========================================
      double precision function Gfun_T(dummy,xi)
c     ==========================================

c     Transverse: equation (20) in PLB347 (1995) 143 - 151
c     This function is called asymp_t in the original code.

      implicit none
      double precision xilast, store
      double precision dummy
      double precision xi, pi, term1
      double precision fii, fjj
*     double precision fii_lim, fjj_lim
      parameter (pi = 3.14159265359d0)

      save xilast, store

      data xilast, store /0.D0, 0.D0/

      if(xi.eq.xilast) then
        Gfun_T = store
        return
      endif

*     term1 = 1.d0/(1.d0 + 0.25d0*xi)

*     if (xi .le. 1.d-1) then
*        Gfun_T = 1.d0/6.d0/pi*(4.d0/3.d0*term1 + (7.d0/6.d0 +
*    #        1.d0/6.d0*term1)*fjj_lim(xi) + 1/3.d0*
*    #        (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0) +
*    #        (1.d0 + 0.25d0*term1)*fii_lim(xi) + 2.d0*
*    #        (1.d0/3.d0 - xi/10.d0 + 11.d0*xi**2/420.d0))
*     else
*        Gfun_T = 1.d0/6.d0/pi*(-2.d0/3.d0/xi + 4.d0/3.d0*term1
*    #        + (7.d0/6.d0 + 1.d0/3.d0/xi + 1.d0/6.d0*term1)*fjj(xi)
*    #        + (1.d0 + 2.d0/xi + 0.25d0*term1)*fii(xi))
*     endif

      term1   = 1.d0/(1.d0 + 0.25d0*xi)

      Gfun_t  = 1.d0/6.d0/pi*(-2.d0/3.d0/xi + 4.d0/3.d0*term1
     #     + (7.d0/6.d0 + 1.d0/3.d0/xi + 1.d0/6.d0*term1)*fjj(xi)
     #     + (1.d0 + 2.d0/xi + 0.25d0*term1)*fii(xi))

      xilast = xi
      store  = Gfun_T

      return
      end

c     ==========================================
      double precision function Gbar_L(dummy,xi)
c     ==========================================

c     Longitudinal mass factorization: (21) in PLB347 (1995) 143 - 151
c     This function is called asympbar_l in the original code.

      implicit none
      double precision xilast, store
      double precision dummy
      double precision xi, pi, term1
      double precision fjj
*     double precision fjj_lim
      parameter (pi = 3.14159265359d0)

      save xilast, store

      data xilast, store /0.D0, 0.D0/

      if(xi.eq.xilast) then
        Gbar_L = store
        return
      endif

*     term1 = 1.d0/(1.d0 + 0.25d0*xi)

*     if (xi .le. 1.d-1) then
*        Gbar_L = 1.d0/6.d0/pi*(0.5d0*term1 + 
*    #        0.25d0*term1*fjj_lim(xi) +
*    #        3.d0* (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0))
*     else
*        Gbar_L = 1.d0/6.d0/pi*(-6.d0/xi + 0.5d0*term1
*    #        + (3.d0/xi + 0.25d0*term1)*fjj(xi))
*     endif

      term1   = 1.d0/(1.d0 + 0.25d0*xi)

      Gbar_L  = 1.d0/6.d0/pi*(-6.d0/xi + 0.5d0*term1
     #     + (3.d0/xi + 0.25d0*term1)*fjj(xi))

      xilast = xi
      store  = Gbar_L

      return
      end

c     ==========================================
      double precision function Gbar_T(dummy,xi)
c     ==========================================

c     transverse mass factorization: (22) in PLB347 (1995) 143 - 151
c     This function is called asympbar_t in the original code.

      implicit none
      double precision xilast, store
      double precision dummy
      double precision xi, pi, term1
      double precision fjj
*     double precision fjj_lim
      parameter (pi = 3.14159265359d0)

      save xilast, store

      data xilast, store /0.D0, 0.D0/

      if(xi.eq.xilast) then
        Gbar_T = store
        return
      endif

*     term1 = 1.d0/(1.d0 + 0.25d0*xi)

*     if (xi .le. 1.d-1) then
*        Gbar_T = 1.d0/6.d0/pi*(-.5d0*term1 -
*    #        (1.d0 + 0.25d0*term1)*fjj_lim(xi) -
*    #        2.d0* (-1.d0/3.d0 + xi/15.d0 - xi**2/70.d0))
*     else
*        Gbar_T = 1.d0/6.d0/pi*(4.d0/xi - 0.5d0*term1
*    #        - (1.d0 + 2.d0/xi + 0.25d0*term1)*fjj(xi))
*     endif

      term1   = 1.d0/(1.d0 + 0.25d0*xi)

      Gbar_T  = 1.d0/6.d0/pi*(4.d0/xi - 0.5d0*term1
     #     - (1.d0 + 2.d0/xi + 0.25d0*term1)*fjj(xi))

      xilast = xi
      store  = Gbar_T

      return
      end

c     =================================
      double precision function fii(xi)
c     =================================

c     Equation (24) in PLB347 (1995) 143 - 151

      implicit none
      double precision pi, term1, term2, xi, di_log
      parameter (pi = 3.14159265359d0)

      term1 = dsqrt(xi)
      term2 = dsqrt(4.d0 + xi)
      fii = 4.d0/term1/term2*(-pi*pi/6.d0 
     #      - 0.5d0*(dlog((term2 + term1)/(term2 - term1)))**2
     #      + (dlog(0.5d0*(1.d0 - term1/term2)))**2 
     #      + 2.d0*di_log(0.5d0*(1.d0 - term1/term2)))

      return
      end

c     =================================
      double precision function fjj(xi)
c     =================================

c     Equation (23) in PLB347 (1995) 143 - 151

      implicit none
      double precision pi, xi, term1, term2
      parameter (pi = 3.14159265359d0)

      term1 = dsqrt(xi)
      term2 = dsqrt(4.d0 + xi)
      fjj = 4.d0/term1/term2*dlog((term2 + term1)/(term2 - term1))

      return
      end

c     =====================================
      double precision function fii_lim(xi)
c     =====================================

c     this gives fii(xi) in the limit that xi -> 0 up to xi**2

      implicit none
      double precision xi

      fii_lim = xi/3.d0 - xi**2/10.d0

      return
      end

c     =====================================
      double precision function fjj_lim(xi)
c     =====================================

c     this gives fjj(xi) in the limit that xi -> 0 up to xi**2

      implicit none
      double precision xi

      fjj_lim = 2.d0 - xi/3.d0 + xi**2/15.d0

      return
      end

c     ===================================
      double precision function di_log(x)
c     ===================================

c     Equation (25) in PLB347 (1995) 143 - 151

      implicit double precision  (a-z)
      dimension b(8)
      integer ncall
      data ncall/0/,pi6/1.644934066848226d+00/,een,vier/1.d+00,.25d+00/

      ncall = 0
      if(ncall.eq.0)go to 2
1     if(x.lt.0)go to 3
      if(x.gt.0.5)go to 4
      z=-dlog(1.-x)
7     z2=z*z
      di_log=z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))
     1 +b(5))+b(4))+b(3))+b(2))+een)-z2*vier
      if(x.gt.een)di_log=-di_log-.5*u*u+2.*pi6
      return
2     b(1)=een
      b(2)=een/36.
      b(3)=-een/3600.
      b(4)=een/211680.
      b(5)=-een/(30.*362880.d+00)
      b(6)=5./(66.*39916800.d+00)
      b(7)=-691./(2730.*39916800.d+00*156.)
      b(8)=een/(39916800.d+00*28080.)
      ncall=1
      go to 1
3     if(x.gt.-een)go to 5
      y=een/(een-x)
      z=-dlog(een-y)
      z2=z*z
      u=dlog(y)
      di_log=z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))
     1 +b(5))+b(4))+b(3))+b(2))+een)-z2*vier-u*(z+.5*u)-pi6
      return
4     if(x.ge.een)go to 10
      y=een-x
      z=-dlog(x)
6     u=dlog(y)
      z2=z*z
      di_log=-z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))
     1 +b(5))+b(4))+b(3))+b(2))+een-u)+z2*vier+pi6
      if(x.gt.een)di_log=-di_log-.5*z*z+pi6*2.
      return
5     y=een/(een-x)
      z=-dlog(y)
      z2=z*z
      di_log=-z*(z2*(z2*(z2*(z2*(z2*(z2*(z2*b(8)+b(7))+b(6))
     1 +b(5))+b(4))+b(3))+b(2))+een)-z2*vier
      return
10    if(x.eq.een)go to 20
      xx=1./x
      if(x.gt.2.)go to 11
      z=dlog(x)
      y=1.-xx
      go to 6
11    u=dlog(x)
      z=-dlog(1.-xx)
      go to 7
20    di_log=pi6

      return
      end

CDECK  ID>, THRESH.

c These are the functions that give the threshold dependence of the 
c coefficient functions with the appropriate factors.
c eta = (W^2 - 4d0*m2)/4d0/m2  where W is the CM energy of the 
c gamma* parton system. xi = mq2/m2 (Q^2/m2)

c     =========================================
      double precision function Efun_LF(eta,xi)
c     =========================================

c     Longitudinal CF group structure: eq (13) in PLB347 (195) 143 - 151
c     This function is called threshf_l in the original code.

      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)

      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      Efun_LF = 1.d0/6.d0/pi*xi*term1**3*beta*beta*pi*pi/2.d0

      return
      end

c     =========================================
      double precision function Efun_TF(eta,xi)
c     =========================================

c     Transverse CF group structure: eq (14) in PLB347 (195) 143 - 151
c     This function is called threshf_t in the original code.

      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)

      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      Efun_TF = 0.25d0/pi*term1*pi*pi/2.d0

      return
      end

c     =========================================
      double precision function Efun_LA(eta,xi)
c     =========================================

c     Longitudinal CA group structure: eq (15) in PLB347 (195) 143 - 151
c     This function is called thresha_l in the original code.

      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)

      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      Efun_LA = 1.d0/6.d0/pi*xi*term1**3*beta**2*
     #     (beta*(dlog(8.d0*beta*beta))**2
     #     - 5.d0*beta*dlog(8.d0*beta*beta) - 0.25d0*pi*pi)

      return
      end

c     =========================================
      double precision function Efun_TA(eta,xi)
c     =========================================

c     Transverse CA group structure: eq (16) in PLB347 (195) 143 - 151
c     This function is called thresha_t in the original code.
      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)

      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      Efun_TA = 0.25d0/pi*term1*(beta*(dlog(8.d0*beta*beta))**2
     #     - 5.d0*beta*dlog(8.d0*beta*beta) - 0.25d0*pi*pi)

      return
      end

c     =========================================
      double precision function Ebar_LA(eta,xi)
c     =========================================

c     Longitudinal CA group structure for the mass factorization piece: 
c     equation (17) in PLB347 (195) 143 - 151
c     This function is called threshbar_l in the original code.

      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)

      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      Ebar_LA = 1.d0/6.d0/pi*xi*term1**3*beta**3*
     #     (-dlog(4.d0*beta*beta))

      return
      end

c     =========================================
      double precision function Ebar_TA(eta,xi)
c     =========================================

c     Transverse CA group structure for the mass factorization piece: 
c     equation (18) in PLB347 (195) 143 - 151
c     This function is called threshbar_t in the original code.

      implicit none
      double precision pi, eta, xi, beta, term1
      parameter (pi = 3.14159265359d0)

      beta = dsqrt(eta/(1.d0 + eta))
      term1 = 1.d0/(1.d0 + 0.25d0*xi)
      Ebar_TA = 0.25d0/pi*term1*beta*(-dlog(4.d0*beta*beta))

      return
      end

CDECK  ID>, LOCATE.

c     ===========================
      Subroutine Locate(xx,n,x,j)
c     ===========================
c     routine taken out of Numerical Recipes

      Integer j,n
      Double Precision x,xx(n)
      Integer jl,ju,jm

      jl = 0
      ju = n+1
 10   If (ju - jl .gt. 1) then
         jm = (ju + jl)/2
         If ((xx(n) .gt. xx(1)) .eqv. (x .gt. xx(jm))) then
            jl = jm
         else
            ju = jm
         endif
         goto 10
      endif
      j = jl

      return
      End

CDECK  ID>, GCORRT.

c     ========================================
      double precision function h1_ATg(eta,xi)
c     ========================================

c     eq (9) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subctca in the original code.
c     Called sctca in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /0.4323D-03, 0.5138D-03,
     #    0.6270D-03, 0.7996D-03, 0.9331D-03, 0.1128D-02, 0.1413D-02,
     #    0.1683D-02, 0.2046D-02, 0.2457D-02, 0.2961D-02, 0.3609D-02,
     #    0.4386D-02, 0.5294D-02, 0.6434D-02, 0.7763D-02, 0.9365D-02,
     #    0.1136D-01, 0.1370D-01, 0.1657D-01, 0.2004D-01, 0.2424D-01,
     #    0.2932D-01, 0.3548D-01, 0.4293D-01, 0.5192D-01, 0.6267D-01,
     #    0.7534D-01, 0.8988D-01, 0.1058D+00, 0.1217D+00, 0.1351D+00,
     #    0.1421D+00, 0.1379D+00, 0.1184D+00, 0.8306D-01, 0.3588D-01,
     #    -.1530D-01, -.6227D-01, -.9944D-01, -.1244D+00, -.1372D+00,
     #    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9476D-01,
     #    -.8013D-01, -.6655D-01, -.5451D-01, -.4402D-01, -.3519D-01,
     #    -.2786D-01, -.2194D-01, -.1711D-01, -.1324D-01, -.1021D-01,
     #    -.7860D-02, -.6008D-02, -.4529D-02, -.3433D-02, -.2592D-02,
     #    -.1943D-02, -.1488D-02, -.1096D-02, -.8350D-03, -.6387D-03,
     #    -.4413D-03, -.3097D-03, -.2442D-03, -.1783D-03, -.1122D-03,
     #    -.1126D-03/

      data (calcpts(j, 2), j = 1,neta) /0.4112D-03, 0.5596D-03,
     #    0.6731D-03, 0.7794D-03, 0.9800D-03, 0.1176D-02, 0.1394D-02,
     #    0.1665D-02, 0.2028D-02, 0.2507D-02, 0.3011D-02, 0.3593D-02,
     #    0.4371D-02, 0.5280D-02, 0.6421D-02, 0.7751D-02, 0.9354D-02,
     #    0.1135D-01, 0.1370D-01, 0.1656D-01, 0.2004D-01, 0.2424D-01,
     #    0.2932D-01, 0.3547D-01, 0.4293D-01, 0.5191D-01, 0.6265D-01,
     #    0.7532D-01, 0.8986D-01, 0.1057D+00, 0.1217D+00, 0.1351D+00,
     #    0.1421D+00, 0.1379D+00, 0.1184D+00, 0.8304D-01, 0.3587D-01,
     #    -.1531D-01, -.6227D-01, -.9945D-01, -.1244D+00, -.1372D+00,
     #    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9475D-01,
     #    -.8011D-01, -.6660D-01, -.5450D-01, -.4401D-01, -.3518D-01,
     #    -.2791D-01, -.2193D-01, -.1710D-01, -.1329D-01, -.1019D-01,
     #    -.7845D-02, -.5992D-02, -.4581D-02, -.3485D-02, -.2577D-02,
     #    -.1927D-02, -.1473D-02, -.1081D-02, -.8195D-03, -.6233D-03,
     #    -.4258D-03, -.3609D-03, -.2288D-03, -.1629D-03, -.1634D-03,
     #    -.9715D-04/

      data (calcpts(j, 3), j = 1,neta) /0.4469D-03, 0.5291D-03,
     #    0.6430D-03, 0.8165D-03, 0.9509D-03, 0.1147D-02, 0.1366D-02,
     #    0.1705D-02, 0.2069D-02, 0.2482D-02, 0.2987D-02, 0.3637D-02,
     #    0.4350D-02, 0.5326D-02, 0.6402D-02, 0.7734D-02, 0.9338D-02,
     #    0.1133D-01, 0.1370D-01, 0.1656D-01, 0.2003D-01, 0.2423D-01,
     #    0.2931D-01, 0.3547D-01, 0.4292D-01, 0.5190D-01, 0.6264D-01,
     #    0.7531D-01, 0.8984D-01, 0.1057D+00, 0.1216D+00, 0.1351D+00,
     #    0.1420D+00, 0.1378D+00, 0.1184D+00, 0.8300D-01, 0.3585D-01,
     #    -.1532D-01, -.6227D-01, -.9944D-01, -.1244D+00, -.1372D+00,
     #    -.1396D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9473D-01,
     #    -.8016D-01, -.6658D-01, -.5447D-01, -.4405D-01, -.3522D-01,
     #    -.2789D-01, -.2190D-01, -.1708D-01, -.1326D-01, -.1024D-01,
     #    -.7822D-02, -.5970D-02, -.4558D-02, -.3462D-02, -.2621D-02,
     #    -.1972D-02, -.1450D-02, -.1125D-02, -.7969D-03, -.6007D-03,
     #    -.4699D-03, -.3383D-03, -.2728D-03, -.2069D-03, -.1408D-03,
     #    -.7452D-04/

      data (calcpts(j, 4), j = 1,neta) /0.4681D-03, 0.5509D-03,
     #    0.6654D-03, 0.7730D-03, 0.9749D-03, 0.1172D-02, 0.1392D-02,
     #    0.1665D-02, 0.2031D-02, 0.2445D-02, 0.3018D-02, 0.3603D-02,
     #    0.4384D-02, 0.5296D-02, 0.6441D-02, 0.7775D-02, 0.9382D-02,
     #    0.1131D-01, 0.1370D-01, 0.1656D-01, 0.2003D-01, 0.2422D-01,
     #    0.2930D-01, 0.3546D-01, 0.4290D-01, 0.5188D-01, 0.6262D-01,
     #    0.7528D-01, 0.8980D-01, 0.1057D+00, 0.1216D+00, 0.1350D+00,
     #    0.1420D+00, 0.1378D+00, 0.1183D+00, 0.8296D-01, 0.3582D-01,
     #    -.1534D-01, -.6228D-01, -.9945D-01, -.1244D+00, -.1372D+00,
     #    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9477D-01,
     #    -.8013D-01, -.6655D-01, -.5451D-01, -.4402D-01, -.3519D-01,
     #    -.2786D-01, -.2194D-01, -.1711D-01, -.1323D-01, -.1020D-01,
     #    -.7856D-02, -.6003D-02, -.4525D-02, -.3429D-02, -.2588D-02,
     #    -.1938D-02, -.1483D-02, -.1092D-02, -.8303D-03, -.6341D-03,
     #    -.4366D-03, -.3050D-03, -.2395D-03, -.1737D-03, -.1076D-03,
     #    -.1079D-03/

      data (calcpts(j, 5), j = 1,neta) /0.4681D-03, 0.5517D-03,
     #    0.6672D-03, 0.7759D-03, 0.9790D-03, 0.1178D-02, 0.1399D-02,
     #    0.1674D-02, 0.2041D-02, 0.2457D-02, 0.2967D-02, 0.3621D-02,
     #    0.4405D-02, 0.5319D-02, 0.6400D-02, 0.7738D-02, 0.9348D-02,
     #    0.1135D-01, 0.1369D-01, 0.1655D-01, 0.2002D-01, 0.2421D-01,
     #    0.2928D-01, 0.3544D-01, 0.4288D-01, 0.5185D-01, 0.6259D-01,
     #    0.7523D-01, 0.8975D-01, 0.1056D+00, 0.1215D+00, 0.1349D+00,
     #    0.1419D+00, 0.1377D+00, 0.1182D+00, 0.8289D-01, 0.3577D-01,
     #    -.1536D-01, -.6229D-01, -.9945D-01, -.1244D+00, -.1371D+00,
     #    -.1396D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9472D-01,
     #    -.8015D-01, -.6657D-01, -.5446D-01, -.4404D-01, -.3521D-01,
     #    -.2788D-01, -.2189D-01, -.1713D-01, -.1325D-01, -.1022D-01,
     #    -.7874D-02, -.6021D-02, -.4543D-02, -.3447D-02, -.2605D-02,
     #    -.1956D-02, -.1501D-02, -.1109D-02, -.8482D-03, -.5853D-03,
     #    -.4545D-03, -.3229D-03, -.2574D-03, -.1916D-03, -.1254D-03,
     #    -.1258D-03/

      data (calcpts(j, 6), j = 1,neta) /0.4370D-03, 0.5219D-03,
     #    0.6388D-03, 0.8157D-03, 0.9540D-03, 0.1155D-02, 0.1379D-02,
     #    0.1656D-02, 0.2026D-02, 0.2445D-02, 0.2957D-02, 0.3615D-02,
     #    0.4403D-02, 0.5255D-02, 0.6408D-02, 0.7750D-02, 0.9365D-02,
     #    0.1130D-01, 0.1368D-01, 0.1653D-01, 0.2000D-01, 0.2419D-01,
     #    0.2926D-01, 0.3541D-01, 0.4285D-01, 0.5181D-01, 0.6253D-01,
     #    0.7518D-01, 0.8967D-01, 0.1055D+00, 0.1214D+00, 0.1348D+00,
     #    0.1418D+00, 0.1375D+00, 0.1181D+00, 0.8279D-01, 0.3571D-01,
     #    -.1540D-01, -.6231D-01, -.9945D-01, -.1244D+00, -.1371D+00,
     #    -.1396D+00, -.1341D+00, -.1233D+00, -.1096D+00, -.9473D-01,
     #    -.8015D-01, -.6657D-01, -.5446D-01, -.4403D-01, -.3520D-01,
     #    -.2787D-01, -.2188D-01, -.1712D-01, -.1324D-01, -.1022D-01,
     #    -.7869D-02, -.6016D-02, -.4538D-02, -.3442D-02, -.2601D-02,
     #    -.1951D-02, -.1496D-02, -.1105D-02, -.8434D-03, -.5804D-03,
     #    -.4497D-03, -.3181D-03, -.2526D-03, -.1867D-03, -.1206D-03,
     #    -.1210D-03/

      data (calcpts(j, 7), j = 1,neta) /0.4271D-03, 0.5137D-03,
     #    0.6327D-03, 0.8119D-03, 0.9528D-03, 0.1156D-02, 0.1384D-02,
     #    0.1664D-02, 0.2038D-02, 0.2462D-02, 0.2979D-02, 0.3643D-02,
     #    0.4369D-02, 0.5295D-02, 0.6387D-02, 0.7736D-02, 0.9359D-02,
     #    0.1131D-01, 0.1367D-01, 0.1652D-01, 0.1998D-01, 0.2417D-01,
     #    0.2923D-01, 0.3537D-01, 0.4280D-01, 0.5175D-01, 0.6246D-01,
     #    0.7509D-01, 0.8956D-01, 0.1054D+00, 0.1212D+00, 0.1346D+00,
     #    0.1415D+00, 0.1373D+00, 0.1179D+00, 0.8265D-01, 0.3561D-01,
     #    -.1546D-01, -.6233D-01, -.9945D-01, -.1243D+00, -.1371D+00,
     #    -.1395D+00, -.1341D+00, -.1233D+00, -.1095D+00, -.9470D-01,
     #    -.8012D-01, -.6654D-01, -.5449D-01, -.4400D-01, -.3517D-01,
     #    -.2790D-01, -.2191D-01, -.1709D-01, -.1327D-01, -.1025D-01,
     #    -.7831D-02, -.5978D-02, -.4566D-02, -.3470D-02, -.2629D-02,
     #    -.1980D-02, -.1458D-02, -.1066D-02, -.8051D-03, -.6089D-03,
     #    -.4781D-03, -.3465D-03, -.6143D-03, -.1485D-03, -.1490D-03,
     #    -.8274D-04/

      data (calcpts(j, 8), j = 1,neta) /0.4171D-03, 0.5064D-03,
     #    0.6284D-03, 0.8110D-03, 0.9558D-03, 0.1164D-02, 0.1396D-02,
     #    0.1682D-02, 0.2062D-02, 0.2492D-02, 0.2950D-02, 0.3621D-02,
     #    0.4356D-02, 0.5291D-02, 0.6392D-02, 0.7752D-02, 0.9319D-02,
     #    0.1128D-01, 0.1365D-01, 0.1650D-01, 0.1995D-01, 0.2413D-01,
     #    0.2919D-01, 0.3531D-01, 0.4273D-01, 0.5167D-01, 0.6235D-01,
     #    0.7495D-01, 0.8940D-01, 0.1052D+00, 0.1210D+00, 0.1343D+00,
     #    0.1413D+00, 0.1370D+00, 0.1177D+00, 0.8245D-01, 0.3546D-01,
     #    -.1554D-01, -.6236D-01, -.9945D-01, -.1243D+00, -.1371D+00,
     #    -.1395D+00, -.1340D+00, -.1232D+00, -.1095D+00, -.9470D-01,
     #    -.8011D-01, -.6653D-01, -.5448D-01, -.4398D-01, -.3522D-01,
     #    -.2788D-01, -.2189D-01, -.1707D-01, -.1325D-01, -.1023D-01,
     #    -.7811D-02, -.6025D-02, -.4546D-02, -.3450D-02, -.2609D-02,
     #    -.1959D-02, -.1438D-02, -.1113D-02, -.7847D-03, -.5884D-03,
     #    -.4576D-03, -.3260D-03, -.2605D-03, -.1947D-03, -.1285D-03,
     #    -.1289D-03/

      data (calcpts(j, 9), j = 1,neta) /0.4435D-03, 0.5367D-03,
     #    0.6631D-03, 0.7841D-03, 0.9344D-03, 0.1148D-02, 0.1388D-02,
     #    0.1681D-02, 0.2003D-02, 0.2443D-02, 0.2978D-02, 0.3594D-02,
     #    0.4342D-02, 0.5289D-02, 0.6406D-02, 0.7714D-02, 0.9296D-02,
     #    0.1127D-01, 0.1362D-01, 0.1646D-01, 0.1991D-01, 0.2407D-01,
     #    0.2912D-01, 0.3524D-01, 0.4263D-01, 0.5155D-01, 0.6220D-01,
     #    0.7476D-01, 0.8916D-01, 0.1049D+00, 0.1206D+00, 0.1339D+00,
     #    0.1408D+00, 0.1366D+00, 0.1173D+00, 0.8214D-01, 0.3525D-01,
     #    -.1566D-01, -.6242D-01, -.9946D-01, -.1243D+00, -.1371D+00,
     #    -.1395D+00, -.1340D+00, -.1232D+00, -.1095D+00, -.9470D-01,
     #    -.8011D-01, -.6651D-01, -.5446D-01, -.4403D-01, -.3520D-01,
     #    -.2786D-01, -.2194D-01, -.1711D-01, -.1323D-01, -.1020D-01,
     #    -.7853D-02, -.6000D-02, -.4521D-02, -.3425D-02, -.2584D-02,
     #    -.1934D-02, -.1480D-02, -.1088D-02, -.8263D-03, -.6301D-03,
     #    -.4326D-03, -.3010D-03, -.2355D-03, -.1696D-03, -.1035D-03,
     #    -.1039D-03/

      data (calcpts(j,10), j = 1,neta) /0.4611D-03, 0.4933D-03,
     #    0.6262D-03, 0.7544D-03, 0.9129D-03, 0.1136D-02, 0.1386D-02,
     #    0.1691D-02, 0.2025D-02, 0.2479D-02, 0.2963D-02, 0.3595D-02,
     #    0.4361D-02, 0.5262D-02, 0.6332D-02, 0.7662D-02, 0.9268D-02,
     #    0.1120D-01, 0.1357D-01, 0.1641D-01, 0.1984D-01, 0.2399D-01,
     #    0.2902D-01, 0.3512D-01, 0.4249D-01, 0.5136D-01, 0.6198D-01,
     #    0.7448D-01, 0.8881D-01, 0.1045D+00, 0.1201D+00, 0.1333D+00,
     #    0.1402D+00, 0.1360D+00, 0.1167D+00, 0.8169D-01, 0.3495D-01,
     #    -.1584D-01, -.6249D-01, -.9946D-01, -.1243D+00, -.1370D+00,
     #    -.1394D+00, -.1339D+00, -.1231D+00, -.1095D+00, -.9468D-01,
     #    -.8007D-01, -.6653D-01, -.5441D-01, -.4398D-01, -.3521D-01,
     #    -.2787D-01, -.2188D-01, -.1711D-01, -.1323D-01, -.1021D-01,
     #    -.7857D-02, -.6004D-02, -.4525D-02, -.3429D-02, -.2588D-02,
     #    -.1938D-02, -.1483D-02, -.1091D-02, -.8300D-03, -.6337D-03,
     #    -.4363D-03, -.3047D-03, -.2392D-03, -.1733D-03, -.1072D-03,
     #    -.1076D-03/

      data (calcpts(j,11), j = 1,neta) /0.4058D-03, 0.5130D-03,
     #    0.6553D-03, 0.7941D-03, 0.9646D-03, 0.1135D-02, 0.1399D-02,
     #    0.1654D-02, 0.2007D-02, 0.2415D-02, 0.2921D-02, 0.3578D-02,
     #    0.4303D-02, 0.5233D-02, 0.6333D-02, 0.7629D-02, 0.9268D-02,
     #    0.1117D-01, 0.1351D-01, 0.1632D-01, 0.1975D-01, 0.2388D-01,
     #    0.2888D-01, 0.3494D-01, 0.4227D-01, 0.5110D-01, 0.6164D-01,
     #    0.7406D-01, 0.8831D-01, 0.1038D+00, 0.1194D+00, 0.1325D+00,
     #    0.1393D+00, 0.1350D+00, 0.1159D+00, 0.8103D-01, 0.3450D-01,
     #    -.1609D-01, -.6259D-01, -.9947D-01, -.1242D+00, -.1369D+00,
     #    -.1393D+00, -.1339D+00, -.1231D+00, -.1094D+00, -.9458D-01,
     #    -.8003D-01, -.6648D-01, -.5441D-01, -.4397D-01, -.3513D-01,
     #    -.2786D-01, -.2187D-01, -.1710D-01, -.1322D-01, -.1019D-01,
     #    -.7843D-02, -.5989D-02, -.4577D-02, -.3481D-02, -.2572D-02,
     #    -.1990D-02, -.1468D-02, -.1076D-02, -.8148D-03, -.6185D-03,
     #    -.4210D-03, -.3561D-03, -.2239D-03, -.1580D-03, -.1586D-03,
     #    -.9227D-04/

      data (calcpts(j,12), j = 1,neta) /0.4531D-03, 0.5058D-03,
     #    0.6618D-03, 0.7494D-03, 0.9372D-03, 0.1127D-02, 0.1346D-02,
     #    0.1625D-02, 0.2005D-02, 0.2442D-02, 0.2914D-02, 0.3540D-02,
     #    0.4304D-02, 0.5208D-02, 0.6287D-02, 0.7563D-02, 0.9184D-02,
     #    0.1107D-01, 0.1341D-01, 0.1621D-01, 0.1961D-01, 0.2371D-01,
     #    0.2867D-01, 0.3469D-01, 0.4195D-01, 0.5071D-01, 0.6116D-01,
     #    0.7347D-01, 0.8757D-01, 0.1029D+00, 0.1183D+00, 0.1313D+00,
     #    0.1379D+00, 0.1337D+00, 0.1147D+00, 0.8008D-01, 0.3385D-01,
     #    -.1646D-01, -.6275D-01, -.9949D-01, -.1242D+00, -.1368D+00,
     #    -.1392D+00, -.1337D+00, -.1230D+00, -.1093D+00, -.9456D-01,
     #    -.7998D-01, -.6642D-01, -.5441D-01, -.4396D-01, -.3518D-01,
     #    -.2783D-01, -.2190D-01, -.1707D-01, -.1325D-01, -.1022D-01,
     #    -.7808D-02, -.5954D-02, -.4542D-02, -.3445D-02, -.2604D-02,
     #    -.1954D-02, -.1499D-02, -.1107D-02, -.8456D-03, -.5826D-03,
     #    -.4518D-03, -.3202D-03, -.2547D-03, -.1888D-03, -.1227D-03,
     #    -.1231D-03/

      data (calcpts(j,13), j = 1,neta) /0.4062D-03, 0.5431D-03,
     #    0.6522D-03, 0.7622D-03, 0.9086D-03, 0.1126D-02, 0.1377D-02,
     #    0.1625D-02, 0.1977D-02, 0.2390D-02, 0.2910D-02, 0.3520D-02,
     #    0.4273D-02, 0.5104D-02, 0.6247D-02, 0.7524D-02, 0.9082D-02,
     #    0.1098D-01, 0.1327D-01, 0.1605D-01, 0.1941D-01, 0.2347D-01,
     #    0.2837D-01, 0.3432D-01, 0.4151D-01, 0.5015D-01, 0.6047D-01,
     #    0.7261D-01, 0.8651D-01, 0.1017D+00, 0.1168D+00, 0.1295D+00,
     #    0.1360D+00, 0.1318D+00, 0.1130D+00, 0.7871D-01, 0.3290D-01,
     #    -.1700D-01, -.6298D-01, -.9950D-01, -.1241D+00, -.1367D+00,
     #    -.1390D+00, -.1336D+00, -.1228D+00, -.1092D+00, -.9446D-01,
     #    -.7991D-01, -.6638D-01, -.5436D-01, -.4389D-01, -.3511D-01,
     #    -.2782D-01, -.2189D-01, -.1705D-01, -.1324D-01, -.1021D-01,
     #    -.7855D-02, -.6000D-02, -.4521D-02, -.3424D-02, -.2582D-02,
     #    -.1932D-02, -.1477D-02, -.1085D-02, -.8239D-03, -.6275D-03,
     #    -.4300D-03, -.3650D-03, -.2329D-03, -.1670D-03, -.1009D-03,
     #    -.1012D-03/

      data (calcpts(j,14), j = 1,neta) /0.4179D-03, 0.5134D-03,
     #    0.5844D-03, 0.7266D-03, 0.9092D-03, 0.1101D-02, 0.1331D-02,
     #    0.1629D-02, 0.1970D-02, 0.2379D-02, 0.2833D-02, 0.3451D-02,
     #    0.4151D-02, 0.5069D-02, 0.6103D-02, 0.7411D-02, 0.8938D-02,
     #    0.1082D-01, 0.1308D-01, 0.1581D-01, 0.1912D-01, 0.2311D-01,
     #    0.2795D-01, 0.3380D-01, 0.4086D-01, 0.4935D-01, 0.5947D-01,
     #    0.7138D-01, 0.8499D-01, 0.9979D-01, 0.1146D+00, 0.1270D+00,
     #    0.1333D+00, 0.1290D+00, 0.1105D+00, 0.7672D-01, 0.3154D-01,
     #    -.1778D-01, -.6329D-01, -.9952D-01, -.1239D+00, -.1364D+00,
     #    -.1388D+00, -.1333D+00, -.1226D+00, -.1090D+00, -.9429D-01,
     #    -.7975D-01, -.6632D-01, -.5426D-01, -.4385D-01, -.3505D-01,
     #    -.2783D-01, -.2182D-01, -.1705D-01, -.1323D-01, -.1020D-01,
     #    -.7844D-02, -.5988D-02, -.4575D-02, -.3478D-02, -.2569D-02,
     #    -.1986D-02, -.1464D-02, -.1072D-02, -.8103D-03, -.6139D-03,
     #    -.4831D-03, -.3514D-03, -.2192D-03, -.1533D-03, -.1539D-03,
     #    -.8758D-04/

      data (calcpts(j,15), j = 1,neta) /0.3832D-03, 0.5148D-03,
     #    0.6265D-03, 0.7480D-03, 0.9156D-03, 0.1099D-02, 0.1326D-02,
     #    0.1563D-02, 0.1918D-02, 0.2281D-02, 0.2765D-02, 0.3356D-02,
     #    0.4104D-02, 0.4945D-02, 0.5978D-02, 0.7226D-02, 0.8765D-02,
     #    0.1059D-01, 0.1280D-01, 0.1547D-01, 0.1871D-01, 0.2261D-01,
     #    0.2733D-01, 0.3305D-01, 0.3994D-01, 0.4821D-01, 0.5807D-01,
     #    0.6963D-01, 0.8283D-01, 0.9717D-01, 0.1114D+00, 0.1234D+00,
     #    0.1294D+00, 0.1251D+00, 0.1069D+00, 0.7389D-01, 0.2959D-01,
     #    -.1888D-01, -.6375D-01, -.9952D-01, -.1236D+00, -.1361D+00,
     #    -.1384D+00, -.1330D+00, -.1223D+00, -.1087D+00, -.9407D-01,
     #    -.7959D-01, -.6617D-01, -.5415D-01, -.4378D-01, -.3503D-01,
     #    -.2772D-01, -.2184D-01, -.1700D-01, -.1317D-01, -.1021D-01,
     #    -.7786D-02, -.5996D-02, -.4515D-02, -.3418D-02, -.2575D-02,
     #    -.1925D-02, -.1470D-02, -.1077D-02, -.8160D-03, -.6195D-03,
     #    -.4219D-03, -.3569D-03, -.2247D-03, -.1588D-03, -.1594D-03,
     #    -.9305D-04/

      data (calcpts(j,16), j = 1,neta) /0.3814D-03, 0.4972D-03,
     #    0.5997D-03, 0.7195D-03, 0.8268D-03, 0.1025D-02, 0.1277D-02,
     #    0.1550D-02, 0.1884D-02, 0.2238D-02, 0.2726D-02, 0.3265D-02,
     #    0.3976D-02, 0.4791D-02, 0.5810D-02, 0.7055D-02, 0.8466D-02,
     #    0.1027D-01, 0.1241D-01, 0.1500D-01, 0.1813D-01, 0.2191D-01,
     #    0.2647D-01, 0.3199D-01, 0.3864D-01, 0.4661D-01, 0.5610D-01,
     #    0.6719D-01, 0.7983D-01, 0.9351D-01, 0.1071D+00, 0.1184D+00,
     #    0.1239D+00, 0.1197D+00, 0.1020D+00, 0.6990D-01, 0.2683D-01,
     #    -.2045D-01, -.6437D-01, -.9952D-01, -.1233D+00, -.1355D+00,
     #    -.1378D+00, -.1324D+00, -.1218D+00, -.1083D+00, -.9371D-01,
     #    -.7932D-01, -.6596D-01, -.5402D-01, -.4368D-01, -.3491D-01,
     #    -.2772D-01, -.2176D-01, -.1698D-01, -.1321D-01, -.1018D-01,
     #    -.7819D-02, -.5961D-02, -.4545D-02, -.3447D-02, -.2604D-02,
     #    -.1953D-02, -.1431D-02, -.1105D-02, -.8437D-03, -.5805D-03,
     #    -.4495D-03, -.3178D-03, -.2523D-03, -.1863D-03, -.1202D-03,
     #    -.1205D-03/

      data (calcpts(j,17), j = 1,neta) /0.3666D-03, 0.4863D-03,
     #    0.5352D-03, 0.6784D-03, 0.8203D-03, 0.9984D-03, 0.1178D-02,
     #    0.1458D-02, 0.1748D-02, 0.2142D-02, 0.2619D-02, 0.3166D-02,
     #    0.3768D-02, 0.4559D-02, 0.5569D-02, 0.6687D-02, 0.8117D-02,
     #    0.9818D-02, 0.1186D-01, 0.1434D-01, 0.1733D-01, 0.2093D-01,
     #    0.2528D-01, 0.3053D-01, 0.3685D-01, 0.4441D-01, 0.5339D-01,
     #    0.6385D-01, 0.7572D-01, 0.8853D-01, 0.1012D+00, 0.1116D+00,
     #    0.1165D+00, 0.1122D+00, 0.9512D-01, 0.6438D-01, 0.2300D-01,
     #    -.2262D-01, -.6522D-01, -.9947D-01, -.1227D+00, -.1347D+00,
     #    -.1370D+00, -.1316D+00, -.1211D+00, -.1077D+00, -.9331D-01,
     #    -.7897D-01, -.6564D-01, -.5376D-01, -.4350D-01, -.3483D-01,
     #    -.2762D-01, -.2171D-01, -.1692D-01, -.1315D-01, -.1017D-01,
     #    -.7809D-02, -.5949D-02, -.4532D-02, -.3432D-02, -.2588D-02,
     #    -.1938D-02, -.1482D-02, -.1089D-02, -.8271D-03, -.6305D-03,
     #    -.4328D-03, -.3010D-03, -.2354D-03, -.1695D-03, -.1033D-03,
     #    -.1037D-03/

      data (calcpts(j,18), j = 1,neta) /0.3296D-03, 0.4115D-03,
     #    0.5016D-03, 0.6332D-03, 0.7788D-03, 0.9104D-03, 0.1128D-02,
     #    0.1399D-02, 0.1634D-02, 0.1996D-02, 0.2463D-02, 0.2957D-02,
     #    0.3596D-02, 0.4314D-02, 0.5208D-02, 0.6295D-02, 0.7644D-02,
     #    0.9209D-02, 0.1113D-01, 0.1344D-01, 0.1625D-01, 0.1962D-01,
     #    0.2368D-01, 0.2858D-01, 0.3446D-01, 0.4148D-01, 0.4977D-01,
     #    0.5941D-01, 0.7029D-01, 0.8195D-01, 0.9335D-01, 0.1026D+00,
     #    0.1068D+00, 0.1023D+00, 0.8599D-01, 0.5694D-01, 0.1780D-01,
     #    -.2557D-01, -.6633D-01, -.9933D-01, -.1218D+00, -.1335D+00,
     #    -.1357D+00, -.1305D+00, -.1201D+00, -.1069D+00, -.9263D-01,
     #    -.7842D-01, -.6529D-01, -.5351D-01, -.4325D-01, -.3460D-01,
     #    -.2749D-01, -.2163D-01, -.1689D-01, -.1311D-01, -.1012D-01,
     #    -.7758D-02, -.5895D-02, -.4542D-02, -.3441D-02, -.2596D-02,
     #    -.1945D-02, -.1488D-02, -.1095D-02, -.8333D-03, -.6366D-03,
     #    -.4388D-03, -.3069D-03, -.2413D-03, -.1753D-03, -.1091D-03,
     #    -.1095D-03/

      data (calcpts(j,19), j = 1,neta) /0.2951D-03, 0.3689D-03,
     #    0.4670D-03, 0.5583D-03, 0.6835D-03, 0.8831D-03, 0.1059D-02,
     #    0.1247D-02, 0.1494D-02, 0.1828D-02, 0.2232D-02, 0.2694D-02,
     #    0.3265D-02, 0.3947D-02, 0.4766D-02, 0.5738D-02, 0.6961D-02,
     #    0.8415D-02, 0.1017D-01, 0.1228D-01, 0.1484D-01, 0.1791D-01,
     #    0.2160D-01, 0.2605D-01, 0.3136D-01, 0.3769D-01, 0.4513D-01,
     #    0.5373D-01, 0.6336D-01, 0.7359D-01, 0.8345D-01, 0.9125D-01,
     #    0.9436D-01, 0.8964D-01, 0.7425D-01, 0.4728D-01, 0.1099D-01,
     #    -.2944D-01, -.6772D-01, -.9898D-01, -.1205D+00, -.1318D+00,
     #    -.1339D+00, -.1288D+00, -.1187D+00, -.1057D+00, -.9161D-01,
     #    -.7767D-01, -.6468D-01, -.5304D-01, -.4296D-01, -.3438D-01,
     #    -.2730D-01, -.2148D-01, -.1678D-01, -.1305D-01, -.1006D-01,
     #    -.7689D-02, -.5888D-02, -.4466D-02, -.3430D-02, -.2584D-02,
     #    -.1931D-02, -.1474D-02, -.1081D-02, -.8188D-03, -.6218D-03,
     #    -.4239D-03, -.3586D-03, -.2263D-03, -.1602D-03, -.1607D-03,
     #    -.9433D-04/

      data (calcpts(j,20), j = 1,neta) /0.2649D-03, 0.3628D-03,
     #    0.4389D-03, 0.5311D-03, 0.6156D-03, 0.7351D-03, 0.9273D-03,
     #    0.1098D-02, 0.1360D-02, 0.1614D-02, 0.1975D-02, 0.2366D-02,
     #    0.2840D-02, 0.3463D-02, 0.4193D-02, 0.5110D-02, 0.6146D-02,
     #    0.7424D-02, 0.8974D-02, 0.1083D-01, 0.1308D-01, 0.1578D-01,
     #    0.1902D-01, 0.2290D-01, 0.2754D-01, 0.3302D-01, 0.3944D-01,
     #    0.4679D-01, 0.5495D-01, 0.6349D-01, 0.7155D-01, 0.7762D-01,
     #    0.7945D-01, 0.7436D-01, 0.5992D-01, 0.3533D-01, 0.2460D-02,
     #    -.3427D-01, -.6935D-01, -.9831D-01, -.1185D+00, -.1292D+00,
     #    -.1312D+00, -.1263D+00, -.1166D+00, -.1040D+00, -.9026D-01,
     #    -.7664D-01, -.6388D-01, -.5242D-01, -.4250D-01, -.3404D-01,
     #    -.2704D-01, -.2125D-01, -.1666D-01, -.1292D-01, -.9981D-02,
     #    -.7669D-02, -.5863D-02, -.4437D-02, -.3399D-02, -.2551D-02,
     #    -.1897D-02, -.1440D-02, -.1046D-02, -.7831D-03, -.5859D-03,
     #    -.4545D-03, -.3224D-03, -.2566D-03, -.1906D-03, -.1243D-03,
     #    -.1246D-03/

      data (calcpts(j,21), j = 1,neta) /0.2746D-03, 0.2937D-03,
     #    0.3818D-03, 0.4467D-03, 0.5340D-03, 0.6221D-03, 0.7518D-03,
     #    0.9649D-03, 0.1110D-02, 0.1358D-02, 0.1692D-02, 0.2035D-02,
     #    0.2442D-02, 0.2911D-02, 0.3557D-02, 0.4292D-02, 0.5185D-02,
     #    0.6263D-02, 0.7562D-02, 0.9125D-02, 0.1101D-01, 0.1327D-01,
     #    0.1598D-01, 0.1921D-01, 0.2306D-01, 0.2759D-01, 0.3285D-01,
     #    0.3881D-01, 0.4535D-01, 0.5204D-01, 0.5812D-01, 0.6231D-01,
     #    0.6271D-01, 0.5712D-01, 0.4360D-01, 0.2153D-01, -.7528D-02,
     #    -.3993D-01, -.7107D-01, -.9708D-01, -.1155D+00, -.1254D+00,
     #    -.1274D+00, -.1229D+00, -.1137D+00, -.1016D+00, -.8842D-01,
     #    -.7514D-01, -.6277D-01, -.5157D-01, -.4185D-01, -.3357D-01,
     #    -.2671D-01, -.2101D-01, -.1646D-01, -.1276D-01, -.9880D-02,
     #    -.7626D-02, -.5813D-02, -.4450D-02, -.3342D-02, -.2559D-02,
     #    -.1904D-02, -.1445D-02, -.1051D-02, -.7878D-03, -.5903D-03,
     #    -.4587D-03, -.3265D-03, -.2606D-03, -.1945D-03, -.1282D-03,
     #    -.1284D-03/

      data (calcpts(j,22), j = 1,neta) /0.2248D-03, 0.2547D-03,
     #    0.3143D-03, 0.3815D-03, 0.4381D-03, 0.5321D-03, 0.6410D-03,
     #    0.7432D-03, 0.8898D-03, 0.1121D-02, 0.1291D-02, 0.1588D-02,
     #    0.1936D-02, 0.2333D-02, 0.2822D-02, 0.3406D-02, 0.4113D-02,
     #    0.4971D-02, 0.5996D-02, 0.7237D-02, 0.8724D-02, 0.1050D-01,
     #    0.1263D-01, 0.1517D-01, 0.1817D-01, 0.2168D-01, 0.2572D-01,
     #    0.3025D-01, 0.3511D-01, 0.3993D-01, 0.4403D-01, 0.4633D-01,
     #    0.4529D-01, 0.3915D-01, 0.2645D-01, 0.6839D-02, -.1830D-01,
     #    -.4602D-01, -.7264D-01, -.9510D-01, -.1113D+00, -.1203D+00,
     #    -.1222D+00, -.1182D+00, -.1097D+00, -.9839D-01, -.8586D-01,
     #    -.7318D-01, -.6123D-01, -.5042D-01, -.4101D-01, -.3296D-01,
     #    -.2623D-01, -.2068D-01, -.1623D-01, -.1258D-01, -.9749D-02,
     #    -.7485D-02, -.5732D-02, -.4364D-02, -.3319D-02, -.2534D-02,
     #    -.1877D-02, -.1418D-02, -.1089D-02, -.8255D-03, -.6277D-03,
     #    -.4292D-03, -.2969D-03, -.2309D-03, -.1647D-03, -.1650D-03,
     #    -.9859D-04/

      data (calcpts(j,23), j = 1,neta) /0.1575D-03, 0.1414D-03,
     #    0.1837D-03, 0.2659D-03, 0.3061D-03, 0.3553D-03, 0.4615D-03,
     #    0.5397D-03, 0.6435D-03, 0.7975D-03, 0.9631D-03, 0.1172D-02,
     #    0.1414D-02, 0.1714D-02, 0.2071D-02, 0.2500D-02, 0.3019D-02,
     #    0.3651D-02, 0.4404D-02, 0.5304D-02, 0.6396D-02, 0.7693D-02,
     #    0.9237D-02, 0.1107D-01, 0.1323D-01, 0.1573D-01, 0.1859D-01,
     #    0.2172D-01, 0.2499D-01, 0.2807D-01, 0.3035D-01, 0.3096D-01,
     #    0.2865D-01, 0.2205D-01, 0.1012D-01, -.7229D-02, -.2869D-01,
     #    -.5179D-01, -.7370D-01, -.9219D-01, -.1057D+00, -.1135D+00,
     #    -.1154D+00, -.1120D+00, -.1044D+00, -.9415D-01, -.8249D-01,
     #    -.7063D-01, -.5927D-01, -.4896D-01, -.3987D-01, -.3211D-01,
     #    -.2564D-01, -.2024D-01, -.1589D-01, -.1234D-01, -.9563D-02,
     #    -.7355D-02, -.5661D-02, -.4288D-02, -.3306D-02, -.2452D-02,
     #    -.1861D-02, -.1400D-02, -.1070D-02, -.8064D-03, -.6082D-03,
     #    -.4095D-03, -.3437D-03, -.2109D-03, -.1447D-03, -.1449D-03,
     #    -.7844D-04/

      data (calcpts(j,24), j = 1,neta) /0.9565D-04, 0.1144D-03,
     #    0.1394D-03, 0.1691D-03, 0.2046D-03, 0.2465D-03, 0.2996D-03,
     #    0.3624D-03, 0.4374D-03, 0.5335D-03, 0.6405D-03, 0.7778D-03,
     #    0.9370D-03, 0.1136D-02, 0.1376D-02, 0.1657D-02, 0.2002D-02,
     #    0.2416D-02, 0.2906D-02, 0.3499D-02, 0.4216D-02, 0.5063D-02,
     #    0.6065D-02, 0.7252D-02, 0.8636D-02, 0.1023D-01, 0.1200D-01,
     #    0.1390D-01, 0.1578D-01, 0.1735D-01, 0.1812D-01, 0.1736D-01,
     #    0.1409D-01, 0.7257D-02, -.3859D-02, -.1916D-01, -.3737D-01,
     #    -.5634D-01, -.7382D-01, -.8828D-01, -.9890D-01, -.1052D+00,
     #    -.1070D+00, -.1043D+00, -.9787D-01, -.8882D-01, -.7832D-01,
     #    -.6740D-01, -.5686D-01, -.4712D-01, -.3854D-01, -.3114D-01,
     #    -.2486D-01, -.1968D-01, -.1550D-01, -.1206D-01, -.9400D-02,
     #    -.7247D-02, -.5546D-02, -.4235D-02, -.3250D-02, -.2460D-02,
     #    -.1867D-02, -.1405D-02, -.1008D-02, -.8105D-03, -.6120D-03,
     #    -.4130D-03, -.3470D-03, -.2141D-03, -.1478D-03, -.1480D-03,
     #    -.8150D-04/

      data (calcpts(j,25), j = 1,neta) /0.4989D-04, 0.6372D-04,
     #    0.7586D-04, 0.9470D-04, 0.1172D-03, 0.1402D-03, 0.1717D-03,
     #    0.2067D-03, 0.2498D-03, 0.3003D-03, 0.3632D-03, 0.4391D-03,
     #    0.5342D-03, 0.6391D-03, 0.7736D-03, 0.9330D-03, 0.1122D-02,
     #    0.1355D-02, 0.1626D-02, 0.1957D-02, 0.2347D-02, 0.2812D-02,
     #    0.3356D-02, 0.3994D-02, 0.4725D-02, 0.5546D-02, 0.6430D-02,
     #    0.7312D-02, 0.8061D-02, 0.8431D-02, 0.8039D-02, 0.6292D-02,
     #    0.2426D-02, -.4343D-02, -.1454D-01, -.2794D-01, -.4336D-01,
     #    -.5888D-01, -.7259D-01, -.8343D-01, -.9112D-01, -.9571D-01,
     #    -.9709D-01, -.9512D-01, -.9001D-01, -.8241D-01, -.7327D-01,
     #    -.6351D-01, -.5389D-01, -.4489D-01, -.3690D-01, -.2994D-01,
     #    -.2399D-01, -.1903D-01, -.1502D-01, -.1176D-01, -.9151D-02,
     #    -.7055D-02, -.5414D-02, -.4165D-02, -.3177D-02, -.2385D-02,
     #    -.1790D-02, -.1394D-02, -.9966D-03, -.7984D-03, -.5996D-03,
     #    -.4004D-03, -.3342D-03, -.2013D-03, -.2015D-03, -.1350D-03,
     #    -.6850D-04/

      data (calcpts(j,26), j = 1,neta) /0.1907D-04, 0.1918D-04,
     #    0.2593D-04, 0.3718D-04, 0.4555D-04, 0.5013D-04, 0.6176D-04,
     #    0.7818D-04, 0.9929D-04, 0.1208D-03, 0.1428D-03, 0.1736D-03,
     #    0.2073D-03, 0.2545D-03, 0.3059D-03, 0.3685D-03, 0.4413D-03,
     #    0.5237D-03, 0.6323D-03, 0.7488D-03, 0.8974D-03, 0.1060D-02,
     #    0.1249D-02, 0.1461D-02, 0.1691D-02, 0.1922D-02, 0.2125D-02,
     #    0.2235D-02, 0.2139D-02, 0.1643D-02, 0.4357D-03, -.1939D-02,
     #    -.6063D-02, -.1252D-01, -.2168D-01, -.3329D-01, -.4632D-01,
     #    -.5906D-01, -.6983D-01, -.7774D-01, -.8286D-01, -.8565D-01,
     #    -.8639D-01, -.8491D-01, -.8106D-01, -.7502D-01, -.6742D-01,
     #    -.5900D-01, -.5047D-01, -.4236D-01, -.3498D-01, -.2847D-01,
     #    -.2293D-01, -.1833D-01, -.1449D-01, -.1135D-01, -.8859D-02,
     #    -.6821D-02, -.5307D-02, -.4054D-02, -.3063D-02, -.2336D-02,
     #    -.1740D-02, -.1343D-02, -.1012D-02, -.7464D-03, -.5473D-03,
     #    -.4146D-03, -.2817D-03, -.2153D-03, -.1489D-03, -.1490D-03,
     #    -.8244D-04/

      data (calcpts(j,27), j = 1,neta) /0.2006D-05, 0.2856D-05,
     #    0.1167D-05, 0.3743D-05, 0.5087D-05, -.4811D-06, 0.1882D-06,
     #    0.3604D-06, 0.1543D-05, -.4601D-05, -.3152D-05, -.4930D-05,
     #    -.8063D-05, -.1520D-04, -.1737D-04, -.2860D-04, -.4090D-04,
     #    -.5485D-04, -.6813D-04, -.9724D-04, -.1257D-03, -.1702D-03,
     #    -.2322D-03, -.3168D-03, -.4380D-03, -.6165D-03, -.8839D-03,
     #    -.1301D-02, -.1962D-02, -.3024D-02, -.4730D-02, -.7424D-02,
     #    -.1154D-01, -.1752D-01, -.2560D-01, -.3554D-01, -.4649D-01,
     #    -.5701D-01, -.6561D-01, -.7144D-01, -.7456D-01, -.7573D-01,
     #    -.7560D-01, -.7426D-01, -.7142D-01, -.6691D-01, -.6092D-01,
     #    -.5396D-01, -.4665D-01, -.3949D-01, -.3285D-01, -.2693D-01,
     #    -.2181D-01, -.1747D-01, -.1388D-01, -.1092D-01, -.8556D-02,
     #    -.6645D-02, -.5126D-02, -.3936D-02, -.3010D-02, -.2281D-02,
     #    -.1751D-02, -.1286D-02, -.1021D-02, -.7556D-03, -.5563D-03,
     #    -.4235D-03, -.2904D-03, -.2240D-03, -.1575D-03, -.1576D-03,
     #    -.9097D-04/

      data (calcpts(j,28), j = 1,neta) /-.1237D-04, -.1446D-04,
     #    -.1884D-04, -.2362D-04, -.3282D-04, -.3729D-04, -.4875D-04,
     #    -.5886D-04, -.7149D-04, -.8621D-04, -.1070D-03, -.1237D-03,
     #    -.1536D-03, -.1859D-03, -.2326D-03, -.2819D-03, -.3422D-03,
     #    -.4187D-03, -.5150D-03, -.6270D-03, -.7669D-03, -.9413D-03,
     #    -.1158D-02, -.1426D-02, -.1763D-02, -.2192D-02, -.2745D-02,
     #    -.3476D-02, -.4466D-02, -.5839D-02, -.7781D-02, -.1055D-01,
     #    -.1448D-01, -.1986D-01, -.2687D-01, -.3531D-01, -.4447D-01,
     #    -.5320D-01, -.6021D-01, -.6468D-01, -.6654D-01, -.6648D-01,
     #    -.6542D-01, -.6384D-01, -.6161D-01, -.5836D-01, -.5391D-01,
     #    -.4846D-01, -.4244D-01, -.3633D-01, -.3050D-01, -.2519D-01,
     #    -.2053D-01, -.1653D-01, -.1318D-01, -.1042D-01, -.8179D-02,
     #    -.6375D-02, -.4933D-02, -.3800D-02, -.2919D-02, -.2222D-02,
     #    -.1691D-02, -.1279D-02, -.9605D-03, -.7213D-03, -.5418D-03,
     #    -.4088D-03, -.3024D-03, -.2292D-03, -.1693D-03, -.1227D-03,
     #    -.9611D-04/

      data (calcpts(j,29), j = 1,neta) /-.2297D-04, -.2752D-04,
     #    -.3754D-04, -.4311D-04, -.5382D-04, -.5937D-04, -.7678D-04,
     #    -.8971D-04, -.1077D-03, -.1287D-03, -.1558D-03, -.1915D-03,
     #    -.2322D-03, -.2801D-03, -.3415D-03, -.4181D-03, -.5071D-03,
     #    -.6130D-03, -.7460D-03, -.9078D-03, -.1104D-02, -.1346D-02,
     #    -.1642D-02, -.2004D-02, -.2451D-02, -.3006D-02, -.3698D-02,
     #    -.4577D-02, -.5709D-02, -.7193D-02, -.9172D-02, -.1184D-01,
     #    -.1544D-01, -.2018D-01, -.2618D-01, -.3327D-01, -.4091D-01,
     #    -.4818D-01, -.5404D-01, -.5768D-01, -.5890D-01, -.5817D-01,
     #    -.5640D-01, -.5434D-01, -.5225D-01, -.4982D-01, -.4667D-01,
     #    -.4265D-01, -.3795D-01, -.3293D-01, -.2797D-01, -.2331D-01,
     #    -.1914D-01, -.1551D-01, -.1244D-01, -.9882D-02, -.7787D-02,
     #    -.6085D-02, -.4727D-02, -.3652D-02, -.2803D-02, -.2145D-02,
     #    -.1627D-02, -.1235D-02, -.9289D-03, -.6028D-03, -.5232D-03,
     #    -.3901D-03, -.2903D-03, -.2171D-03, -.1572D-03, -.1172D-03,
     #    -.8393D-04/

      data (calcpts(j,30), j = 1,neta) /-.2720D-04, -.2861D-04,
     #    -.3471D-04, -.4794D-04, -.5707D-04, -.6429D-04, -.7893D-04,
     #    -.9699D-04, -.1206D-03, -.1465D-03, -.1769D-03, -.2139D-03,
     #    -.2600D-03, -.3148D-03, -.3814D-03, -.4633D-03, -.5624D-03,
     #    -.6828D-03, -.8292D-03, -.1008D-02, -.1224D-02, -.1489D-02,
     #    -.1811D-02, -.2204D-02, -.2684D-02, -.3275D-02, -.4004D-02,
     #    -.4911D-02, -.6053D-02, -.7509D-02, -.9389D-02, -.1184D-01,
     #    -.1503D-01, -.1911D-01, -.2418D-01, -.3008D-01, -.3642D-01,
     #    -.4249D-01, -.4745D-01, -.5062D-01, -.5165D-01, -.5077D-01,
     #    -.4867D-01, -.4620D-01, -.4390D-01, -.4181D-01, -.3953D-01,
     #    -.3672D-01, -.3327D-01, -.2936D-01, -.2529D-01, -.2133D-01,
     #    -.1768D-01, -.1444D-01, -.1165D-01, -.9313D-02, -.7372D-02,
     #    -.5788D-02, -.4514D-02, -.3498D-02, -.2694D-02, -.2069D-02,
     #    -.1577D-02, -.1198D-02, -.9051D-03, -.6122D-03, -.5125D-03,
     #    -.3860D-03, -.2861D-03, -.2129D-03, -.1596D-03, -.1197D-03,
     #    -.8635D-04/

      data (calcpts(j,31), j = 1,neta) /-.2258D-04, -.3019D-04,
     #    -.3714D-04, -.4516D-04, -.5510D-04, -.6652D-04, -.8066D-04,
     #    -.9812D-04, -.1185D-03, -.1435D-03, -.1744D-03, -.2112D-03,
     #    -.2566D-03, -.3107D-03, -.3767D-03, -.4573D-03, -.5548D-03,
     #    -.6731D-03, -.8174D-03, -.9925D-03, -.1204D-02, -.1462D-02,
     #    -.1777D-02, -.2159D-02, -.2625D-02, -.3194D-02, -.3891D-02,
     #    -.4753D-02, -.5822D-02, -.7163D-02, -.8859D-02, -.1102D-01,
     #    -.1377D-01, -.1723D-01, -.2144D-01, -.2631D-01, -.3153D-01,
     #    -.3657D-01, -.4081D-01, -.4365D-01, -.4473D-01, -.4408D-01,
     #    -.4210D-01, -.3948D-01, -.3692D-01, -.3476D-01, -.3289D-01,
     #    -.3091D-01, -.2852D-01, -.2566D-01, -.2249D-01, -.1924D-01,
     #    -.1614D-01, -.1332D-01, -.1083D-01, -.8710D-02, -.6933D-02,
     #    -.5472D-02, -.4283D-02, -.3333D-02, -.2582D-02, -.1983D-02,
     #    -.1517D-02, -.1158D-02, -.8784D-03, -.6120D-03, -.4989D-03,
     #    -.3724D-03, -.2791D-03, -.2059D-03, -.1526D-03, -.1126D-03,
     #    -.8596D-04/

      data (calcpts(j,32), j = 1,neta) /-.2433D-04, -.2931D-04,
     #    -.3516D-04, -.4244D-04, -.5156D-04, -.6163D-04, -.7470D-04,
     #    -.9082D-04, -.1098D-03, -.1328D-03, -.1611D-03, -.1946D-03,
     #    -.2361D-03, -.2861D-03, -.3465D-03, -.4206D-03, -.5098D-03,
     #    -.6182D-03, -.7499D-03, -.9101D-03, -.1103D-02, -.1340D-02,
     #    -.1626D-02, -.1974D-02, -.2397D-02, -.2912D-02, -.3542D-02,
     #    -.4314D-02, -.5266D-02, -.6446D-02, -.7921D-02, -.9772D-02,
     #    -.1209D-01, -.1496D-01, -.1841D-01, -.2238D-01, -.2663D-01,
     #    -.3079D-01, -.3438D-01, -.3695D-01, -.3815D-01, -.3789D-01,
     #    -.3633D-01, -.3394D-01, -.3131D-01, -.2897D-01, -.2711D-01,
     #    -.2553D-01, -.2389D-01, -.2192D-01, -.1961D-01, -.1709D-01,
     #    -.1455D-01, -.1214D-01, -.9967D-02, -.8077D-02, -.6471D-02,
     #    -.5135D-02, -.4045D-02, -.3161D-02, -.2449D-02, -.1896D-02,
     #    -.1457D-02, -.1111D-02, -.8444D-03, -.6046D-03, -.4781D-03,
     #    -.3582D-03, -.2716D-03, -.1983D-03, -.1450D-03, -.1117D-03,
     #    -.7837D-04/

      data (calcpts(j,33), j = 1,neta) /-.1992D-04, -.2417D-04,
     #    -.2929D-04, -.3614D-04, -.4347D-04, -.5343D-04, -.6432D-04,
     #    -.7849D-04, -.9477D-04, -.1151D-03, -.1399D-03, -.1700D-03,
     #    -.2059D-03, -.2498D-03, -.3031D-03, -.3675D-03, -.4459D-03,
     #    -.5409D-03, -.6558D-03, -.7954D-03, -.9646D-03, -.1171D-02,
     #    -.1420D-02, -.1723D-02, -.2091D-02, -.2539D-02, -.3083D-02,
     #    -.3749D-02, -.4566D-02, -.5572D-02, -.6817D-02, -.8362D-02,
     #    -.1027D-01, -.1262D-01, -.1541D-01, -.1860D-01, -.2204D-01,
     #    -.2544D-01, -.2845D-01, -.3073D-01, -.3201D-01, -.3213D-01,
     #    -.3112D-01, -.2920D-01, -.2681D-01, -.2443D-01, -.2244D-01,
     #    -.2090D-01, -.1963D-01, -.1830D-01, -.1671D-01, -.1488D-01,
     #    -.1290D-01, -.1093D-01, -.9078D-02, -.7432D-02, -.6003D-02,
     #    -.4793D-02, -.3795D-02, -.2984D-02, -.2325D-02, -.1805D-02,
     #    -.1393D-02, -.1066D-02, -.8131D-03, -.5933D-03, -.4667D-03,
     #    -.3535D-03, -.2668D-03, -.2002D-03, -.1469D-03, -.1136D-03,
     #    -.8026D-04/

      data (calcpts(j,34), j = 1,neta) /-.1712D-04, -.2071D-04,
     #    -.2527D-04, -.3077D-04, -.3773D-04, -.4540D-04, -.5514D-04,
     #    -.6700D-04, -.8094D-04, -.9790D-04, -.1186D-03, -.1438D-03,
     #    -.1749D-03, -.2115D-03, -.2566D-03, -.3113D-03, -.3772D-03,
     #    -.4571D-03, -.5546D-03, -.6724D-03, -.8150D-03, -.9890D-03,
     #    -.1199D-02, -.1454D-02, -.1765D-02, -.2141D-02, -.2598D-02,
     #    -.3156D-02, -.3838D-02, -.4672D-02, -.5699D-02, -.6963D-02,
     #    -.8515D-02, -.1040D-01, -.1263D-01, -.1518D-01, -.1792D-01,
     #    -.2066D-01, -.2314D-01, -.2513D-01, -.2639D-01, -.2679D-01,
     #    -.2629D-01, -.2496D-01, -.2303D-01, -.2086D-01, -.1882D-01,
     #    -.1719D-01, -.1597D-01, -.1496D-01, -.1390D-01, -.1265D-01,
     #    -.1121D-01, -.9674D-02, -.8164D-02, -.6756D-02, -.5513D-02,
     #    -.4435D-02, -.3537D-02, -.2791D-02, -.2192D-02, -.1706D-02,
     #    -.1319D-02, -.1013D-02, -.7732D-03, -.5733D-03, -.4467D-03,
     #    -.3401D-03, -.2535D-03, -.1935D-03, -.1402D-03, -.1068D-03,
     #    -.8018D-04/

      data (calcpts(j,35), j = 1,neta) /-.1442D-04, -.1761D-04,
     #    -.2114D-04, -.2543D-04, -.3088D-04, -.3788D-04, -.4561D-04,
     #    -.5524D-04, -.6656D-04, -.8093D-04, -.9821D-04, -.1189D-03,
     #    -.1444D-03, -.1747D-03, -.2120D-03, -.2566D-03, -.3108D-03,
     #    -.3768D-03, -.4572D-03, -.5540D-03, -.6717D-03, -.8145D-03,
     #    -.9876D-03, -.1197D-02, -.1452D-02, -.1761D-02, -.2136D-02,
     #    -.2592D-02, -.3149D-02, -.3828D-02, -.4659D-02, -.5676D-02,
     #    -.6916D-02, -.8412D-02, -.1018D-01, -.1218D-01, -.1435D-01,
     #    -.1653D-01, -.1855D-01, -.2023D-01, -.2142D-01, -.2198D-01,
     #    -.2186D-01, -.2106D-01, -.1968D-01, -.1791D-01, -.1604D-01,
     #    -.1436D-01, -.1306D-01, -.1210D-01, -.1132D-01, -.1049D-01,
     #    -.9515D-02, -.8398D-02, -.7220D-02, -.6068D-02, -.5007D-02,
     #    -.4069D-02, -.3270D-02, -.2598D-02, -.2052D-02, -.1605D-02,
     #    -.1246D-02, -.9591D-03, -.7326D-03, -.5526D-03, -.4260D-03,
     #    -.3261D-03, -.2461D-03, -.1861D-03, -.1395D-03, -.1061D-03,
     #    -.7946D-04/

      data (calcpts(j,36), j = 1,neta) /-.1137D-04, -.1382D-04,
     #    -.1702D-04, -.2062D-04, -.2489D-04, -.3011D-04, -.3664D-04,
     #    -.4486D-04, -.5375D-04, -.6514D-04, -.7944D-04, -.9638D-04,
     #    -.1165D-03, -.1415D-03, -.1711D-03, -.2073D-03, -.2513D-03,
     #    -.3046D-03, -.3692D-03, -.4476D-03, -.5425D-03, -.6577D-03,
     #    -.7973D-03, -.9666D-03, -.1172D-02, -.1421D-02, -.1723D-02,
     #    -.2090D-02, -.2536D-02, -.3079D-02, -.3741D-02, -.4548D-02,
     #    -.5527D-02, -.6701D-02, -.8081D-02, -.9647D-02, -.1134D-01,
     #    -.1306D-01, -.1468D-01, -.1608D-01, -.1713D-01, -.1775D-01,
     #    -.1788D-01, -.1748D-01, -.1660D-01, -.1530D-01, -.1377D-01,
     #    -.1222D-01, -.1087D-01, -.9851D-02, -.9116D-02, -.8513D-02,
     #    -.7875D-02, -.7120D-02, -.6263D-02, -.5366D-02, -.4494D-02,
     #    -.3697D-02, -.2997D-02, -.2401D-02, -.1913D-02, -.1499D-02,
     #    -.1166D-02, -.9065D-03, -.6999D-03, -.5266D-03, -.4067D-03,
     #    -.3067D-03, -.2334D-03, -.1734D-03, -.1334D-03, -.1001D-03,
     #    -.7340D-04/

      data (calcpts(j,37), j = 1,neta) /-.9350D-05, -.1113D-04,
     #    -.1370D-04, -.1661D-04, -.2005D-04, -.2421D-04, -.2924D-04,
     #    -.3544D-04, -.4294D-04, -.5203D-04, -.6306D-04, -.7640D-04,
     #    -.9263D-04, -.1122D-03, -.1360D-03, -.1649D-03, -.1998D-03,
     #    -.2422D-03, -.2935D-03, -.3558D-03, -.4312D-03, -.5227D-03,
     #    -.6336D-03, -.7680D-03, -.9309D-03, -.1128D-02, -.1368D-02,
     #    -.1658D-02, -.2011D-02, -.2439D-02, -.2961D-02, -.3593D-02,
     #    -.4358D-02, -.5271D-02, -.6341D-02, -.7553D-02, -.8865D-02,
     #    -.1021D-01, -.1149D-01, -.1263D-01, -.1353D-01, -.1413D-01,
     #    -.1439D-01, -.1427D-01, -.1377D-01, -.1291D-01, -.1178D-01,
     #    -.1050D-01, -.9244D-02, -.8180D-02, -.7389D-02, -.6829D-02,
     #    -.6369D-02, -.5881D-02, -.5303D-02, -.4651D-02, -.3971D-02,
     #    -.3316D-02, -.2720D-02, -.2199D-02, -.1758D-02, -.1392D-02,
     #    -.1095D-02, -.8512D-03, -.6606D-03, -.5066D-03, -.3886D-03,
     #    -.2953D-03, -.2240D-03, -.1693D-03, -.1273D-03, -.9535D-04,
     #    -.7135D-04/

      data (calcpts(j,38), j = 1,neta) /-.7323D-05, -.8879D-05,
     #    -.1071D-04, -.1298D-04, -.1574D-04, -.1902D-04, -.2306D-04,
     #    -.2791D-04, -.3375D-04, -.4091D-04, -.4954D-04, -.6005D-04,
     #    -.7274D-04, -.8814D-04, -.1067D-03, -.1294D-03, -.1568D-03,
     #    -.1900D-03, -.2303D-03, -.2792D-03, -.3383D-03, -.4100D-03,
     #    -.4970D-03, -.6023D-03, -.7300D-03, -.8847D-03, -.1072D-02,
     #    -.1299D-02, -.1575D-02, -.1909D-02, -.2315D-02, -.2806D-02,
     #    -.3397D-02, -.4101D-02, -.4924D-02, -.5855D-02, -.6865D-02,
     #    -.7905D-02, -.8912D-02, -.9819D-02, -.1057D-01, -.1111D-01,
     #    -.1141D-01, -.1146D-01, -.1122D-01, -.1071D-01, -.9941D-02,
     #    -.8985D-02, -.7943D-02, -.6946D-02, -.6119D-02, -.5514D-02,
     #    -.5091D-02, -.4743D-02, -.4372D-02, -.3933D-02, -.3439D-02,
     #    -.2928D-02, -.2438D-02, -.1994D-02, -.1609D-02, -.1283D-02,
     #    -.1016D-02, -.7942D-03, -.6176D-03, -.4770D-03, -.3677D-03,
     #    -.2804D-03, -.2130D-03, -.1610D-03, -.1217D-03, -.9104D-04,
     #    -.6771D-04/

      data (calcpts(j,39), j = 1,neta) /-.5564D-05, -.6759D-05,
     #    -.8192D-05, -.9970D-05, -.1212D-04, -.1469D-04, -.1779D-04,
     #    -.2157D-04, -.2609D-04, -.3166D-04, -.3838D-04, -.4656D-04,
     #    -.5639D-04, -.6835D-04, -.8283D-04, -.1004D-03, -.1217D-03,
     #    -.1475D-03, -.1787D-03, -.2167D-03, -.2625D-03, -.3182D-03,
     #    -.3856D-03, -.4674D-03, -.5663D-03, -.6863D-03, -.8314D-03,
     #    -.1007D-02, -.1221D-02, -.1479D-02, -.1792D-02, -.2170D-02,
     #    -.2623D-02, -.3162D-02, -.3790D-02, -.4501D-02, -.5273D-02,
     #    -.6072D-02, -.6852D-02, -.7568D-02, -.8177D-02, -.8646D-02,
     #    -.8952D-02, -.9074D-02, -.9000D-02, -.8723D-02, -.8246D-02,
     #    -.7592D-02, -.6807D-02, -.5974D-02, -.5194D-02, -.4557D-02,
     #    -.4098D-02, -.3780D-02, -.3519D-02, -.3239D-02, -.2907D-02,
     #    -.2535D-02, -.2153D-02, -.1788D-02, -.1457D-02, -.1175D-02,
     #    -.9354D-03, -.7381D-03, -.5775D-03, -.4488D-03, -.3468D-03,
     #    -.2662D-03, -.2035D-03, -.1549D-03, -.1169D-03, -.8820D-04,
     #    -.6620D-04/

      data (calcpts(j,40), j = 1,neta) /-.4321D-05, -.5241D-05,
     #    -.6319D-05, -.7696D-05, -.9306D-05, -.1129D-04, -.1367D-04,
     #    -.1662D-04, -.2009D-04, -.2435D-04, -.2952D-04, -.3579D-04,
     #    -.4337D-04, -.5257D-04, -.6371D-04, -.7722D-04, -.9360D-04,
     #    -.1134D-03, -.1374D-03, -.1666D-03, -.2019D-03, -.2446D-03,
     #    -.2965D-03, -.3593D-03, -.4353D-03, -.5274D-03, -.6389D-03,
     #    -.7739D-03, -.9375D-03, -.1135D-02, -.1374D-02, -.1663D-02,
     #    -.2009D-02, -.2418D-02, -.2895D-02, -.3434D-02, -.4020D-02,
     #    -.4630D-02, -.5230D-02, -.5788D-02, -.6274D-02, -.6666D-02,
     #    -.6944D-02, -.7097D-02, -.7115D-02, -.6989D-02, -.6715D-02,
     #    -.6298D-02, -.5755D-02, -.5125D-02, -.4469D-02, -.3865D-02,
     #    -.3379D-02, -.3033D-02, -.2795D-02, -.2600D-02, -.2389D-02,
     #    -.2140D-02, -.1862D-02, -.1578D-02, -.1307D-02, -.1065D-02,
     #    -.8552D-03, -.6799D-03, -.5353D-03, -.4180D-03, -.3246D-03,
     #    -.2506D-03, -.1920D-03, -.1466D-03, -.1113D-03, -.8399D-04,
     #    -.6332D-04/

      data (calcpts(j,41), j = 1,neta) /-.3334D-05, -.4055D-05,
     #    -.4852D-05, -.5910D-05, -.7143D-05, -.8672D-05, -.1049D-04,
     #    -.1268D-04, -.1537D-04, -.1864D-04, -.2260D-04, -.2733D-04,
     #    -.3314D-04, -.4016D-04, -.4862D-04, -.5896D-04, -.7144D-04,
     #    -.8655D-04, -.1049D-03, -.1271D-03, -.1540D-03, -.1866D-03,
     #    -.2261D-03, -.2740D-03, -.3319D-03, -.4022D-03, -.4871D-03,
     #    -.5900D-03, -.7145D-03, -.8649D-03, -.1047D-02, -.1265D-02,
     #    -.1527D-02, -.1837D-02, -.2196D-02, -.2603D-02, -.3046D-02,
     #    -.3508D-02, -.3966D-02, -.4397D-02, -.4780D-02, -.5098D-02,
     #    -.5339D-02, -.5494D-02, -.5555D-02, -.5518D-02, -.5376D-02,
     #    -.5128D-02, -.4777D-02, -.4337D-02, -.3838D-02, -.3328D-02,
     #    -.2864D-02, -.2496D-02, -.2236D-02, -.2060D-02, -.1915D-02,
     #    -.1757D-02, -.1571D-02, -.1364D-02, -.1157D-02, -.9529D-03,
     #    -.7742D-03, -.6209D-03, -.4923D-03, -.3869D-03, -.3023D-03,
     #    -.2343D-03, -.1803D-03, -.1383D-03, -.1050D-03, -.7963D-04,
     #    -.6029D-04/

      data (calcpts(j,42), j = 1,neta) /-.2479D-05, -.3065D-05,
     #    -.3689D-05, -.4454D-05, -.5396D-05, -.6551D-05, -.7966D-05,
     #    -.9624D-05, -.1164D-04, -.1409D-04, -.1709D-04, -.2071D-04,
     #    -.2511D-04, -.3044D-04, -.3685D-04, -.4467D-04, -.5412D-04,
     #    -.6560D-04, -.7945D-04, -.9630D-04, -.1166D-03, -.1413D-03,
     #    -.1713D-03, -.2076D-03, -.2514D-03, -.3046D-03, -.3689D-03,
     #    -.4468D-03, -.5409D-03, -.6546D-03, -.7917D-03, -.9566D-03,
     #    -.1154D-02, -.1386D-02, -.1657D-02, -.1962D-02, -.2295D-02,
     #    -.2644D-02, -.2991D-02, -.3321D-02, -.3618D-02, -.3872D-02,
     #    -.4073D-02, -.4215D-02, -.4293D-02, -.4303D-02, -.4241D-02,
     #    -.4104D-02, -.3890D-02, -.3602D-02, -.3251D-02, -.2861D-02,
     #    -.2468D-02, -.2115D-02, -.1837D-02, -.1644D-02, -.1513D-02,
     #    -.1406D-02, -.1289D-02, -.1150D-02, -.9963D-03, -.8400D-03,
     #    -.6934D-03, -.5621D-03, -.4501D-03, -.3568D-03, -.2801D-03,
     #    -.2181D-03, -.1688D-03, -.1301D-03, -.9944D-04, -.7544D-04,
     #    -.5744D-04/

      data (calcpts(j,43), j = 1,neta) /-.1859D-05, -.2269D-05,
     #    -.2779D-05, -.3347D-05, -.4064D-05, -.4958D-05, -.5995D-05,
     #    -.7236D-05, -.8771D-05, -.1062D-04, -.1288D-04, -.1560D-04,
     #    -.1890D-04, -.2290D-04, -.2775D-04, -.3363D-04, -.4075D-04,
     #    -.4937D-04, -.5983D-04, -.7250D-04, -.8785D-04, -.1064D-03,
     #    -.1290D-03, -.1563D-03, -.1893D-03, -.2293D-03, -.2777D-03,
     #    -.3363D-03, -.4070D-03, -.4925D-03, -.5955D-03, -.7191D-03,
     #    -.8667D-03, -.1041D-02, -.1243D-02, -.1471D-02, -.1720D-02,
     #    -.1982D-02, -.2244D-02, -.2495D-02, -.2724D-02, -.2923D-02,
     #    -.3086D-02, -.3209D-02, -.3288D-02, -.3321D-02, -.3304D-02,
     #    -.3235D-02, -.3111D-02, -.2932D-02, -.2702D-02, -.2426D-02,
     #    -.2125D-02, -.1824D-02, -.1557D-02, -.1349D-02, -.1205D-02,
     #    -.1109D-02, -.1029D-02, -.9423D-03, -.8397D-03, -.7260D-03,
     #    -.6111D-03, -.5032D-03, -.4074D-03, -.3254D-03, -.2574D-03,
     #    -.2021D-03, -.1574D-03, -.1214D-03, -.9342D-04, -.7142D-04,
     #    -.5409D-04/

      data (calcpts(j,44), j = 1,neta) /-.1425D-05, -.1723D-05,
     #    -.2083D-05, -.2524D-05, -.3056D-05, -.3699D-05, -.4481D-05,
     #    -.5430D-05, -.6576D-05, -.7963D-05, -.9650D-05, -.1169D-04,
     #    -.1416D-04, -.1716D-04, -.2079D-04, -.2519D-04, -.3052D-04,
     #    -.3698D-04, -.4482D-04, -.5431D-04, -.6579D-04, -.7972D-04,
     #    -.9660D-04, -.1170D-03, -.1417D-03, -.1717D-03, -.2079D-03,
     #    -.2518D-03, -.3047D-03, -.3686D-03, -.4455D-03, -.5378D-03,
     #    -.6479D-03, -.7776D-03, -.9280D-03, -.1098D-02, -.1284D-02,
     #    -.1479D-02, -.1676D-02, -.1865D-02, -.2041D-02, -.2195D-02,
     #    -.2325D-02, -.2428D-02, -.2499D-02, -.2539D-02, -.2546D-02,
     #    -.2517D-02, -.2450D-02, -.2345D-02, -.2200D-02, -.2016D-02,
     #    -.1803D-02, -.1571D-02, -.1344D-02, -.1143D-02, -.9871D-03,
     #    -.8809D-03, -.8099D-03, -.7514D-03, -.6872D-03, -.6114D-03,
     #    -.5277D-03, -.4433D-03, -.3645D-03, -.2946D-03, -.2351D-03,
     #    -.1856D-03, -.1456D-03, -.1129D-03, -.8693D-04, -.6693D-04,
     #    -.5093D-04/

      data (calcpts(j,45), j = 1,neta) /-.1047D-05, -.1275D-05,
     #    -.1544D-05, -.1873D-05, -.2268D-05, -.2748D-05, -.3332D-05,
     #    -.4036D-05, -.4893D-05, -.5928D-05, -.7185D-05, -.8710D-05,
     #    -.1055D-04, -.1279D-04, -.1549D-04, -.1877D-04, -.2276D-04,
     #    -.2757D-04, -.3341D-04, -.4049D-04, -.4905D-04, -.5944D-04,
     #    -.7201D-04, -.8724D-04, -.1057D-03, -.1280D-03, -.1550D-03,
     #    -.1876D-03, -.2271D-03, -.2746D-03, -.3319D-03, -.4005D-03,
     #    -.4822D-03, -.5785D-03, -.6900D-03, -.8160D-03, -.9539D-03,
     #    -.1099D-02, -.1246D-02, -.1389D-02, -.1522D-02, -.1641D-02,
     #    -.1743D-02, -.1826D-02, -.1887D-02, -.1928D-02, -.1945D-02,
     #    -.1938D-02, -.1906D-02, -.1846D-02, -.1758D-02, -.1642D-02,
     #    -.1499D-02, -.1335D-02, -.1159D-02, -.9869D-03, -.8364D-03,
     #    -.7209D-03, -.6425D-03, -.5904D-03, -.5475D-03, -.5002D-03,
     #    -.4444D-03, -.3830D-03, -.3212D-03, -.2637D-03, -.2128D-03,
     #    -.1696D-03, -.1338D-03, -.1049D-03, -.8132D-04, -.6279D-04,
     #    -.4812D-04/

      data (calcpts(j,46), j = 1,neta) /-.7797D-06, -.9460D-06,
     #    -.1149D-05, -.1390D-05, -.1685D-05, -.2043D-05, -.2478D-05,
     #    -.3000D-05, -.3631D-05, -.4402D-05, -.5337D-05, -.6469D-05,
     #    -.7835D-05, -.9494D-05, -.1150D-04, -.1394D-04, -.1689D-04,
     #    -.2047D-04, -.2480D-04, -.3005D-04, -.3641D-04, -.4411D-04,
     #    -.5345D-04, -.6475D-04, -.7843D-04, -.9499D-04, -.1150D-03,
     #    -.1392D-03, -.1685D-03, -.2037D-03, -.2461D-03, -.2970D-03,
     #    -.3574D-03, -.4286D-03, -.5110D-03, -.6042D-03, -.7062D-03,
     #    -.8140D-03, -.9235D-03, -.1030D-02, -.1131D-02, -.1222D-02,
     #    -.1300D-02, -.1366D-02, -.1417D-02, -.1454D-02, -.1474D-02,
     #    -.1479D-02, -.1466D-02, -.1434D-02, -.1383D-02, -.1313D-02,
     #    -.1221D-02, -.1110D-02, -.9850D-03, -.8519D-03, -.7227D-03,
     #    -.6105D-03, -.5250D-03, -.4674D-03, -.4293D-03, -.3978D-03,
     #    -.3632D-03, -.3223D-03, -.2773D-03, -.2321D-03, -.1902D-03,
     #    -.1533D-03, -.1220D-03, -.9633D-04, -.7513D-04, -.5833D-04,
     #    -.4486D-04/

      data (calcpts(j,47), j = 1,neta) /-.5812D-06, -.7041D-06,
     #    -.8530D-06, -.1034D-05, -.1247D-05, -.1512D-05, -.1830D-05,
     #    -.2218D-05, -.2692D-05, -.3258D-05, -.3949D-05, -.4785D-05,
     #    -.5798D-05, -.7020D-05, -.8509D-05, -.1031D-04, -.1249D-04,
     #    -.1514D-04, -.1834D-04, -.2222D-04, -.2692D-04, -.3261D-04,
     #    -.3952D-04, -.4787D-04, -.5798D-04, -.7023D-04, -.8502D-04,
     #    -.1029D-03, -.1245D-03, -.1505D-03, -.1819D-03, -.2193D-03,
     #    -.2639D-03, -.3164D-03, -.3771D-03, -.4458D-03, -.5210D-03,
     #    -.6007D-03, -.6818D-03, -.7614D-03, -.8367D-03, -.9054D-03,
     #    -.9658D-03, -.1018D-02, -.1059D-02, -.1090D-02, -.1111D-02,
     #    -.1120D-02, -.1118D-02, -.1102D-02, -.1074D-02, -.1032D-02,
     #    -.9757D-03, -.9045D-03, -.8198D-03, -.7246D-03, -.6244D-03,
     #    -.5279D-03, -.4446D-03, -.3815D-03, -.3393D-03, -.3115D-03,
     #    -.2885D-03, -.2631D-03, -.2332D-03, -.2003D-03, -.1675D-03,
     #    -.1370D-03, -.1103D-03, -.8765D-04, -.6899D-04, -.5385D-04,
     #    -.4165D-04/

      data (calcpts(j,48), j = 1,neta) /-.4289D-06, -.5178D-06,
     #    -.6274D-06, -.7621D-06, -.9198D-06, -.1112D-05, -.1351D-05,
     #    -.1637D-05, -.1984D-05, -.2400D-05, -.2909D-05, -.3527D-05,
     #    -.4273D-05, -.5175D-05, -.6268D-05, -.7597D-05, -.9203D-05,
     #    -.1115D-04, -.1351D-04, -.1637D-04, -.1983D-04, -.2403D-04,
     #    -.2912D-04, -.3527D-04, -.4272D-04, -.5174D-04, -.6264D-04,
     #    -.7582D-04, -.9172D-04, -.1109D-03, -.1339D-03, -.1615D-03,
     #    -.1943D-03, -.2329D-03, -.2775D-03, -.3278D-03, -.3832D-03,
     #    -.4419D-03, -.5019D-03, -.5609D-03, -.6172D-03, -.6690D-03,
     #    -.7152D-03, -.7550D-03, -.7880D-03, -.8138D-03, -.8322D-03,
     #    -.8427D-03, -.8453D-03, -.8395D-03, -.8249D-03, -.8008D-03,
     #    -.7669D-03, -.7226D-03, -.6678D-03, -.6033D-03, -.5315D-03,
     #    -.4565D-03, -.3860D-03, -.3231D-03, -.2767D-03, -.2458D-03,
     #    -.2256D-03, -.2088D-03, -.1903D-03, -.1684D-03, -.1445D-03,
     #    -.1206D-03, -.9858D-04, -.7925D-04, -.6292D-04, -.4952D-04,
     #    -.3852D-04/

      data (calcpts(j,49), j = 1,neta) /-.3130D-06, -.3793D-06,
     #    -.4580D-06, -.5590D-06, -.6787D-06, -.8204D-06, -.9885D-06,
     #    -.1201D-05, -.1456D-05, -.1761D-05, -.2137D-05, -.2588D-05,
     #    -.3137D-05, -.3800D-05, -.4604D-05, -.5579D-05, -.6762D-05,
     #    -.8190D-05, -.9926D-05, -.1203D-04, -.1457D-04, -.1765D-04,
     #    -.2138D-04, -.2590D-04, -.3137D-04, -.3800D-04, -.4600D-04,
     #    -.5567D-04, -.6735D-04, -.8141D-04, -.9832D-04, -.1185D-03,
     #    -.1426D-03, -.1708D-03, -.2035D-03, -.2405D-03, -.2811D-03,
     #    -.3241D-03, -.3683D-03, -.4121D-03, -.4539D-03, -.4927D-03,
     #    -.5276D-03, -.5582D-03, -.5840D-03, -.6048D-03, -.6204D-03,
     #    -.6307D-03, -.6355D-03, -.6346D-03, -.6277D-03, -.6146D-03,
     #    -.5947D-03, -.5677D-03, -.5333D-03, -.4915D-03, -.4427D-03,
     #    -.3888D-03, -.3330D-03, -.2798D-03, -.2343D-03, -.2003D-03,
     #    -.1778D-03, -.1630D-03, -.1509D-03, -.1374D-03, -.1215D-03,
     #    -.1041D-03, -.8673D-04, -.7079D-04, -.5686D-04, -.4513D-04,
     #    -.3539D-04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1_ATg = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     ========================================
      double precision function h1_FTg(eta,xi)
c     ========================================

c     eq (10) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subctcf in the original code.
c     Called sctcf in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi
      data (calcpts(j, 1), j = 1,neta) /-.2005D-03, -.2004D-03,
     #    -.3501D-03, -.3497D-03, -.4991D-03, -.4983D-03, -.6470D-03,
     #    -.7952D-03, -.9425D-03, -.1089D-02, -.1383D-02, -.1524D-02,
     #    -.1962D-02, -.2243D-02, -.2666D-02, -.3227D-02, -.3769D-02,
     #    -.4434D-02, -.5209D-02, -.6075D-02, -.7007D-02, -.7963D-02,
     #    -.8887D-02, -.9694D-02, -.1011D-01, -.1027D-01, -.9623D-02,
     #    -.7967D-02, -.4835D-02, -.5091D-03, 0.5340D-02, 0.1151D-01,
     #    0.1643D-01, 0.1747D-01, 0.1237D-01, 0.7897D-03, -.1390D-01,
     #    -.2616D-01, -.3083D-01, -.2674D-01, -.1655D-01, -.4410D-02,
     #    0.6429D-02, 0.1431D-01, 0.1894D-01, 0.2087D-01, 0.2082D-01,
     #    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1299D-01, 0.1083D-01,
     #    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,
     #    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     #    0.7622D-03, 0.5780D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     #    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 2), j = 1,neta) /-.1546D-03, -.3044D-03,
     #    -.3042D-03, -.3038D-03, -.4532D-03, -.4523D-03, -.6011D-03,
     #    -.7493D-03, -.8966D-03, -.1043D-02, -.1337D-02, -.1628D-02,
     #    -.1916D-02, -.2347D-02, -.2770D-02, -.3181D-02, -.3873D-02,
     #    -.4538D-02, -.5313D-02, -.6180D-02, -.6961D-02, -.7918D-02,
     #    -.8841D-02, -.9649D-02, -.1022D-01, -.1023D-01, -.9578D-02,
     #    -.7923D-02, -.4941D-02, -.4661D-03, 0.5382D-02, 0.1155D-01,
     #    0.1647D-01, 0.1750D-01, 0.1240D-01, 0.8170D-03, -.1388D-01,
     #    -.2616D-01, -.3083D-01, -.2673D-01, -.1655D-01, -.4404D-02,
     #    0.6433D-02, 0.1429D-01, 0.1894D-01, 0.2086D-01, 0.2082D-01,
     #    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     #    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,
     #    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     #    0.7622D-03, 0.5780D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     #    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 3), j = 1,neta) /-.2373D-03, -.2372D-03,
     #    -.2369D-03, -.3865D-03, -.3859D-03, -.5351D-03, -.6838D-03,
     #    -.6820D-03, -.9793D-03, -.1125D-02, -.1270D-02, -.1561D-02,
     #    -.1848D-02, -.2280D-02, -.2703D-02, -.3264D-02, -.3806D-02,
     #    -.4471D-02, -.5246D-02, -.6112D-02, -.7044D-02, -.8001D-02,
     #    -.8924D-02, -.9582D-02, -.1015D-01, -.1016D-01, -.9512D-02,
     #    -.7858D-02, -.4877D-02, -.4031D-03, 0.5293D-02, 0.1145D-01,
     #    0.1637D-01, 0.1755D-01, 0.1244D-01, 0.8570D-03, -.1399D-01,
     #    -.2615D-01, -.3083D-01, -.2673D-01, -.1656D-01, -.4395D-02,
     #    0.6424D-02, 0.1430D-01, 0.1893D-01, 0.2086D-01, 0.2082D-01,
     #    0.1952D-01, 0.1755D-01, 0.1527D-01, 0.1299D-01, 0.1083D-01,
     #    0.8899D-02, 0.7217D-02, 0.5789D-02, 0.4600D-02, 0.3625D-02,
     #    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     #    0.7622D-03, 0.5778D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     #    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7583D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 4), j = 1,neta) /-.1385D-03, -.2883D-03,
     #    -.2881D-03, -.2877D-03, -.4371D-03, -.5862D-03, -.5850D-03,
     #    -.7331D-03, -.8804D-03, -.1026D-02, -.1321D-02, -.1612D-02,
     #    -.1900D-02, -.2331D-02, -.2754D-02, -.3165D-02, -.3857D-02,
     #    -.4522D-02, -.5297D-02, -.6164D-02, -.6946D-02, -.7902D-02,
     #    -.8826D-02, -.9634D-02, -.1020D-01, -.1021D-01, -.9565D-02,
     #    -.7912D-02, -.4932D-02, -.4606D-03, 0.5233D-02, 0.1154D-01,
     #    0.1645D-01, 0.1748D-01, 0.1236D-01, 0.7658D-03, -.1394D-01,
     #    -.2615D-01, -.3082D-01, -.2673D-01, -.1655D-01, -.4398D-02,
     #    0.6433D-02, 0.1429D-01, 0.1894D-01, 0.2087D-01, 0.2083D-01,
     #    0.1952D-01, 0.1753D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     #    0.8899D-02, 0.7216D-02, 0.5790D-02, 0.4600D-02, 0.3625D-02,
     #    0.2837D-02, 0.2204D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     #    0.7622D-03, 0.5778D-03, 0.4364D-03, 0.3286D-03, 0.2464D-03,
     #    0.1844D-03, 0.1375D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 5), j = 1,neta) /-.1435D-03, -.2933D-03,
     #    -.2930D-03, -.2926D-03, -.4421D-03, -.5912D-03, -.5900D-03,
     #    -.7381D-03, -.8854D-03, -.1031D-02, -.1326D-02, -.1617D-02,
     #    -.1905D-02, -.2336D-02, -.2759D-02, -.3170D-02, -.3862D-02,
     #    -.4527D-02, -.5302D-02, -.6169D-02, -.6951D-02, -.7908D-02,
     #    -.8831D-02, -.9640D-02, -.1021D-01, -.1022D-01, -.9573D-02,
     #    -.7921D-02, -.4944D-02, -.4749D-03, 0.5215D-02, 0.1152D-01,
     #    0.1642D-01, 0.1744D-01, 0.1231D-01, 0.8520D-03, -.1402D-01,
     #    -.2614D-01, -.3081D-01, -.2671D-01, -.1654D-01, -.4394D-02,
     #    0.6431D-02, 0.1430D-01, 0.1893D-01, 0.2087D-01, 0.2083D-01,
     #    0.1953D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     #    0.8898D-02, 0.7216D-02, 0.5788D-02, 0.4600D-02, 0.3625D-02,
     #    0.2835D-02, 0.2205D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     #    0.7621D-03, 0.5778D-03, 0.4365D-03, 0.3286D-03, 0.2464D-03,
     #    0.1844D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 6), j = 1,neta) /-.2310D-03, -.2308D-03,
     #    -.2305D-03, -.3801D-03, -.3795D-03, -.5287D-03, -.6774D-03,
     #    -.8256D-03, -.9729D-03, -.1119D-02, -.1263D-02, -.1555D-02,
     #    -.1842D-02, -.2274D-02, -.2697D-02, -.3257D-02, -.3799D-02,
     #    -.4464D-02, -.5240D-02, -.6107D-02, -.7039D-02, -.7996D-02,
     #    -.8920D-02, -.9579D-02, -.1015D-01, -.1016D-01, -.9515D-02,
     #    -.7865D-02, -.4891D-02, -.5759D-03, 0.5258D-02, 0.1140D-01,
     #    0.1630D-01, 0.1745D-01, 0.1231D-01, 0.8284D-03, -.1392D-01,
     #    -.2614D-01, -.3080D-01, -.2671D-01, -.1653D-01, -.4397D-02,
     #    0.6421D-02, 0.1430D-01, 0.1894D-01, 0.2086D-01, 0.2082D-01,
     #    0.1953D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     #    0.8897D-02, 0.7216D-02, 0.5788D-02, 0.4599D-02, 0.3625D-02,
     #    0.2836D-02, 0.2205D-02, 0.1703D-02, 0.1309D-02, 0.1001D-02,
     #    0.7621D-03, 0.5779D-03, 0.4365D-03, 0.3284D-03, 0.2464D-03,
     #    0.1844D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 7), j = 1,neta) /-.2194D-03, -.2192D-03,
     #    -.2189D-03, -.3685D-03, -.3680D-03, -.5171D-03, -.6659D-03,
     #    -.8140D-03, -.9613D-03, -.1107D-02, -.1252D-02, -.1543D-02,
     #    -.1831D-02, -.2262D-02, -.2685D-02, -.3246D-02, -.3788D-02,
     #    -.4453D-02, -.5228D-02, -.6096D-02, -.7028D-02, -.7985D-02,
     #    -.8910D-02, -.9569D-02, -.1014D-01, -.1030D-01, -.9660D-02,
     #    -.7863D-02, -.5043D-02, -.5842D-03, 0.5241D-02, 0.1137D-01,
     #    0.1625D-01, 0.1739D-01, 0.1222D-01, 0.7137D-03, -.1391D-01,
     #    -.2612D-01, -.3079D-01, -.2669D-01, -.1652D-01, -.4402D-02,
     #    0.6419D-02, 0.1429D-01, 0.1892D-01, 0.2086D-01, 0.2081D-01,
     #    0.1952D-01, 0.1754D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     #    0.8896D-02, 0.7215D-02, 0.5787D-02, 0.4599D-02, 0.3625D-02,
     #    0.2836D-02, 0.2205D-02, 0.1704D-02, 0.1309D-02, 0.1001D-02,
     #    0.7621D-03, 0.5779D-03, 0.4365D-03, 0.3285D-03, 0.2464D-03,
     #    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 8), j = 1,neta) /-.2128D-03, -.2126D-03,
     #    -.3623D-03, -.3619D-03, -.3613D-03, -.5105D-03, -.6592D-03,
     #    -.8074D-03, -.9547D-03, -.1101D-02, -.1245D-02, -.1536D-02,
     #    -.1824D-02, -.2256D-02, -.2679D-02, -.3239D-02, -.3782D-02,
     #    -.4447D-02, -.5222D-02, -.6090D-02, -.7022D-02, -.7980D-02,
     #    -.8905D-02, -.9566D-02, -.1014D-01, -.1030D-01, -.9663D-02,
     #    -.8021D-02, -.5056D-02, -.6067D-03, 0.5056D-02, 0.1132D-01,
     #    0.1618D-01, 0.1713D-01, 0.1223D-01, 0.6853D-03, -.1398D-01,
     #    -.2611D-01, -.3077D-01, -.2667D-01, -.1652D-01, -.4388D-02,
     #    0.6431D-02, 0.1429D-01, 0.1893D-01, 0.2086D-01, 0.2082D-01,
     #    0.1951D-01, 0.1753D-01, 0.1526D-01, 0.1298D-01, 0.1083D-01,
     #    0.8895D-02, 0.7215D-02, 0.5788D-02, 0.4598D-02, 0.3624D-02,
     #    0.2836D-02, 0.2203D-02, 0.1704D-02, 0.1309D-02, 0.1001D-02,
     #    0.7620D-03, 0.5779D-03, 0.4365D-03, 0.3285D-03, 0.2464D-03,
     #    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7582D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j, 9), j = 1,neta) /-.1453D-03, -.2952D-03,
     #    -.2949D-03, -.2945D-03, -.4439D-03, -.4431D-03, -.5918D-03,
     #    -.7400D-03, -.8873D-03, -.1033D-02, -.1328D-02, -.1619D-02,
     #    -.1907D-02, -.2188D-02, -.2762D-02, -.3172D-02, -.3864D-02,
     #    -.4530D-02, -.5306D-02, -.6023D-02, -.6956D-02, -.7915D-02,
     #    -.8841D-02, -.9653D-02, -.1023D-01, -.1024D-01, -.9610D-02,
     #    -.7974D-02, -.5019D-02, -.7318D-03, 0.4913D-02, 0.1115D-01,
     #    0.1598D-01, 0.1704D-01, 0.1209D-01, 0.6323D-03, -.1395D-01,
     #    -.2608D-01, -.3072D-01, -.2665D-01, -.1649D-01, -.4378D-02,
     #    0.6416D-02, 0.1428D-01, 0.1891D-01, 0.2085D-01, 0.2080D-01,
     #    0.1950D-01, 0.1752D-01, 0.1527D-01, 0.1298D-01, 0.1083D-01,
     #    0.8894D-02, 0.7213D-02, 0.5787D-02, 0.4599D-02, 0.3624D-02,
     #    0.2835D-02, 0.2203D-02, 0.1702D-02, 0.1309D-02, 0.1001D-02,
     #    0.7620D-03, 0.5777D-03, 0.4363D-03, 0.3285D-03, 0.2464D-03,
     #    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7581D-04, 0.5611D-04,
     #    0.4143D-04/

      data (calcpts(j,10), j = 1,neta) /-.2188D-03, -.2186D-03,
     #    -.2183D-03, -.3679D-03, -.3673D-03, -.5165D-03, -.6652D-03,
     #    -.8134D-03, -.9608D-03, -.1107D-02, -.1251D-02, -.1543D-02,
     #    -.1830D-02, -.2262D-02, -.2685D-02, -.3246D-02, -.3788D-02,
     #    -.4454D-02, -.5230D-02, -.6098D-02, -.7032D-02, -.7841D-02,
     #    -.8769D-02, -.9583D-02, -.1016D-01, -.1018D-01, -.9704D-02,
     #    -.8077D-02, -.5135D-02, -.8675D-03, 0.4751D-02, 0.1096D-01,
     #    0.1573D-01, 0.1673D-01, 0.1185D-01, 0.4632D-03, -.1406D-01,
     #    -.2606D-01, -.3067D-01, -.2659D-01, -.1647D-01, -.4373D-02,
     #    0.6415D-02, 0.1427D-01, 0.1891D-01, 0.2083D-01, 0.2079D-01,
     #    0.1950D-01, 0.1752D-01, 0.1526D-01, 0.1297D-01, 0.1082D-01,
     #    0.8891D-02, 0.7211D-02, 0.5785D-02, 0.4598D-02, 0.3623D-02,
     #    0.2835D-02, 0.2204D-02, 0.1702D-02, 0.1308D-02, 0.1001D-02,
     #    0.7619D-03, 0.5776D-03, 0.4364D-03, 0.3285D-03, 0.2463D-03,
     #    0.1842D-03, 0.1374D-03, 0.1022D-03, 0.7581D-04, 0.5610D-04,
     #    0.4142D-04/

      data (calcpts(j,11), j = 1,neta) /-.1437D-03, -.2935D-03,
     #    -.2933D-03, -.2929D-03, -.4423D-03, -.4414D-03, -.5902D-03,
     #    -.7384D-03, -.8857D-03, -.1032D-02, -.1326D-02, -.1618D-02,
     #    -.1905D-02, -.2187D-02, -.2610D-02, -.3171D-02, -.3714D-02,
     #    -.4380D-02, -.5156D-02, -.6025D-02, -.6960D-02, -.7920D-02,
     #    -.8850D-02, -.9667D-02, -.1010D-01, -.1028D-01, -.9659D-02,
     #    -.8046D-02, -.5273D-02, -.1033D-02, 0.4546D-02, 0.1055D-01,
     #    0.1540D-01, 0.1646D-01, 0.1163D-01, 0.4108D-03, -.1410D-01,
     #    -.2601D-01, -.3059D-01, -.2652D-01, -.1642D-01, -.4356D-02,
     #    0.6410D-02, 0.1426D-01, 0.1888D-01, 0.2081D-01, 0.2078D-01,
     #    0.1949D-01, 0.1752D-01, 0.1525D-01, 0.1297D-01, 0.1082D-01,
     #    0.8887D-02, 0.7209D-02, 0.5783D-02, 0.4596D-02, 0.3622D-02,
     #    0.2834D-02, 0.2202D-02, 0.1703D-02, 0.1308D-02, 0.1000D-02,
     #    0.7617D-03, 0.5775D-03, 0.4362D-03, 0.3284D-03, 0.2463D-03,
     #    0.1843D-03, 0.1374D-03, 0.1022D-03, 0.7580D-04, 0.5609D-04,
     #    0.4142D-04/

      data (calcpts(j,12), j = 1,neta) /-.1721D-03, -.1719D-03,
     #    -.3216D-03, -.3212D-03, -.4707D-03, -.4698D-03, -.6186D-03,
     #    -.7668D-03, -.9141D-03, -.1060D-02, -.1355D-02, -.1496D-02,
     #    -.1934D-02, -.2216D-02, -.2639D-02, -.3200D-02, -.3743D-02,
     #    -.4410D-02, -.5187D-02, -.6056D-02, -.6993D-02, -.7805D-02,
     #    -.8738D-02, -.9560D-02, -.1015D-01, -.1019D-01, -.9731D-02,
     #    -.8137D-02, -.5394D-02, -.1194D-02, 0.4180D-02, 0.1010D-01,
     #    0.1486D-01, 0.1594D-01, 0.1109D-01, 0.1429D-03, -.1411D-01,
     #    -.2595D-01, -.3047D-01, -.2643D-01, -.1637D-01, -.4346D-02,
     #    0.6403D-02, 0.1424D-01, 0.1885D-01, 0.2079D-01, 0.2076D-01,
     #    0.1946D-01, 0.1749D-01, 0.1524D-01, 0.1296D-01, 0.1081D-01,
     #    0.8882D-02, 0.7204D-02, 0.5779D-02, 0.4593D-02, 0.3620D-02,
     #    0.2833D-02, 0.2201D-02, 0.1701D-02, 0.1308D-02, 0.1000D-02,
     #    0.7615D-03, 0.5774D-03, 0.4361D-03, 0.3282D-03, 0.2463D-03,
     #    0.1841D-03, 0.1373D-03, 0.1021D-03, 0.7577D-04, 0.5607D-04,
     #    0.4140D-04/

      data (calcpts(j,13), j = 1,neta) /-.1707D-03, -.1705D-03,
     #    -.3202D-03, -.3198D-03, -.4693D-03, -.4684D-03, -.6172D-03,
     #    -.7654D-03, -.9128D-03, -.1059D-02, -.1353D-02, -.1495D-02,
     #    -.1783D-02, -.2215D-02, -.2639D-02, -.3200D-02, -.3743D-02,
     #    -.4410D-02, -.5188D-02, -.5909D-02, -.6848D-02, -.7813D-02,
     #    -.8751D-02, -.9579D-02, -.1018D-01, -.1023D-01, -.9793D-02,
     #    -.8378D-02, -.5676D-02, -.1534D-02, 0.3758D-02, 0.9572D-02,
     #    0.1418D-01, 0.1522D-01, 0.1059D-01, -.1719D-03, -.1426D-01,
     #    -.2585D-01, -.3032D-01, -.2629D-01, -.1629D-01, -.4321D-02,
     #    0.6391D-02, 0.1421D-01, 0.1882D-01, 0.2075D-01, 0.2072D-01,
     #    0.1943D-01, 0.1748D-01, 0.1521D-01, 0.1294D-01, 0.1080D-01,
     #    0.8874D-02, 0.7198D-02, 0.5775D-02, 0.4590D-02, 0.3617D-02,
     #    0.2831D-02, 0.2200D-02, 0.1700D-02, 0.1307D-02, 0.9996D-03,
     #    0.7612D-03, 0.5771D-03, 0.4359D-03, 0.3281D-03, 0.2462D-03,
     #    0.1841D-03, 0.1373D-03, 0.1021D-03, 0.7575D-04, 0.5606D-04,
     #    0.4139D-04/

      data (calcpts(j,14), j = 1,neta) /-.1968D-03, -.1967D-03,
     #    -.3464D-03, -.3460D-03, -.3455D-03, -.4946D-03, -.6434D-03,
     #    -.7917D-03, -.9391D-03, -.1085D-02, -.1230D-02, -.1521D-02,
     #    -.1809D-02, -.2242D-02, -.2666D-02, -.3077D-02, -.3621D-02,
     #    -.4289D-02, -.5069D-02, -.5942D-02, -.6883D-02, -.7703D-02,
     #    -.8647D-02, -.9484D-02, -.1010D-01, -.1032D-01, -.9760D-02,
     #    -.8537D-02, -.5893D-02, -.1986D-02, 0.3039D-02, 0.8692D-02,
     #    0.1309D-01, 0.1430D-01, 0.9794D-02, -.7502D-03, -.1435D-01,
     #    -.2570D-01, -.3009D-01, -.2609D-01, -.1617D-01, -.4278D-02,
     #    0.6379D-02, 0.1415D-01, 0.1876D-01, 0.2070D-01, 0.2068D-01,
     #    0.1941D-01, 0.1744D-01, 0.1520D-01, 0.1292D-01, 0.1078D-01,
     #    0.8862D-02, 0.7189D-02, 0.5769D-02, 0.4586D-02, 0.3615D-02,
     #    0.2828D-02, 0.2198D-02, 0.1699D-02, 0.1306D-02, 0.9988D-03,
     #    0.7606D-03, 0.5768D-03, 0.4357D-03, 0.3279D-03, 0.2461D-03,
     #    0.1840D-03, 0.1372D-03, 0.1021D-03, 0.7573D-04, 0.5604D-04,
     #    0.4138D-04/

      data (calcpts(j,15), j = 1,neta) /-.1824D-03, -.1823D-03,
     #    -.3320D-03, -.3316D-03, -.4811D-03, -.4803D-03, -.6291D-03,
     #    -.7773D-03, -.9248D-03, -.1071D-02, -.1216D-02, -.1507D-02,
     #    -.1796D-02, -.2228D-02, -.2503D-02, -.3065D-02, -.3610D-02,
     #    -.4279D-02, -.5061D-02, -.5787D-02, -.6732D-02, -.7708D-02,
     #    -.8511D-02, -.9361D-02, -.9993D-02, -.1024D-01, -.9876D-02,
     #    -.8711D-02, -.6303D-02, -.2665D-02, 0.2193D-02, 0.7467D-02,
     #    0.1186D-01, 0.1284D-01, 0.8604D-02, -.1434D-02, -.1442D-01,
     #    -.2550D-01, -.2975D-01, -.2580D-01, -.1602D-01, -.4239D-02,
     #    0.6339D-02, 0.1408D-01, 0.1867D-01, 0.2062D-01, 0.2060D-01,
     #    0.1933D-01, 0.1739D-01, 0.1515D-01, 0.1289D-01, 0.1076D-01,
     #    0.8844D-02, 0.7176D-02, 0.5758D-02, 0.4578D-02, 0.3609D-02,
     #    0.2824D-02, 0.2195D-02, 0.1697D-02, 0.1304D-02, 0.9978D-03,
     #    0.7599D-03, 0.5762D-03, 0.4354D-03, 0.3277D-03, 0.2459D-03,
     #    0.1839D-03, 0.1371D-03, 0.1020D-03, 0.7567D-04, 0.5600D-04,
     #    0.4136D-04/

      data (calcpts(j,16), j = 1,neta) /-.1800D-03, -.1799D-03,
     #    -.3296D-03, -.3292D-03, -.3287D-03, -.4779D-03, -.6267D-03,
     #    -.6250D-03, -.7725D-03, -.1069D-02, -.1213D-02, -.1506D-02,
     #    -.1794D-02, -.2077D-02, -.2502D-02, -.2915D-02, -.3612D-02,
     #    -.4133D-02, -.4917D-02, -.5647D-02, -.6598D-02, -.7583D-02,
     #    -.8399D-02, -.9268D-02, -.9927D-02, -.1022D-01, -.1006D-01,
     #    -.8976D-02, -.6836D-02, -.3517D-02, 0.9542D-03, 0.5906D-02,
     #    0.1002D-01, 0.1105D-01, 0.7198D-02, -.2258D-02, -.1472D-01,
     #    -.2521D-01, -.2927D-01, -.2542D-01, -.1580D-01, -.4190D-02,
     #    0.6275D-02, 0.1396D-01, 0.1855D-01, 0.2048D-01, 0.2050D-01,
     #    0.1925D-01, 0.1732D-01, 0.1510D-01, 0.1285D-01, 0.1073D-01,
     #    0.8819D-02, 0.7157D-02, 0.5744D-02, 0.4567D-02, 0.3601D-02,
     #    0.2819D-02, 0.2191D-02, 0.1694D-02, 0.1302D-02, 0.9963D-03,
     #    0.7588D-03, 0.5754D-03, 0.4348D-03, 0.3272D-03, 0.2455D-03,
     #    0.1837D-03, 0.1370D-03, 0.1019D-03, 0.7560D-04, 0.5596D-04,
     #    0.4132D-04/

      data (calcpts(j,17), j = 1,neta) /-.1148D-03, -.2646D-03,
     #    -.2644D-03, -.2640D-03, -.4135D-03, -.4127D-03, -.5616D-03,
     #    -.7100D-03, -.8576D-03, -.1004D-02, -.1149D-02, -.1441D-02,
     #    -.1730D-02, -.2013D-02, -.2439D-02, -.2854D-02, -.3402D-02,
     #    -.4076D-02, -.4714D-02, -.5599D-02, -.6409D-02, -.7256D-02,
     #    -.8239D-02, -.9134D-02, -.9831D-02, -.1017D-01, -.1010D-01,
     #    -.9280D-02, -.7456D-02, -.4522D-02, -.5274D-03, 0.3977D-02,
     #    0.7644D-02, 0.8816D-02, 0.5388D-02, -.3332D-02, -.1483D-01,
     #    -.2478D-01, -.2863D-01, -.2489D-01, -.1552D-01, -.4146D-02,
     #    0.6172D-02, 0.1378D-01, 0.1835D-01, 0.2029D-01, 0.2033D-01,
     #    0.1912D-01, 0.1722D-01, 0.1502D-01, 0.1278D-01, 0.1068D-01,
     #    0.8782D-02, 0.7130D-02, 0.5725D-02, 0.4553D-02, 0.3590D-02,
     #    0.2811D-02, 0.2186D-02, 0.1690D-02, 0.1299D-02, 0.9941D-03,
     #    0.7572D-03, 0.5743D-03, 0.4340D-03, 0.3268D-03, 0.2452D-03,
     #    0.1835D-03, 0.1368D-03, 0.1018D-03, 0.7550D-04, 0.5588D-04,
     #    0.4127D-04/

      data (calcpts(j,18), j = 1,neta) /-.1467D-03, -.1465D-03,
     #    -.2963D-03, -.2960D-03, -.2955D-03, -.4447D-03, -.5937D-03,
     #    -.5921D-03, -.7398D-03, -.8864D-03, -.1181D-02, -.1324D-02,
     #    -.1613D-02, -.1898D-02, -.2325D-02, -.2741D-02, -.3291D-02,
     #    -.3819D-02, -.4462D-02, -.5205D-02, -.6176D-02, -.7039D-02,
     #    -.7897D-02, -.8826D-02, -.9575D-02, -.9992D-02, -.1002D-01,
     #    -.9512D-02, -.8062D-02, -.5594D-02, -.2193D-02, 0.1706D-02,
     #    0.5020D-02, 0.6064D-02, 0.3033D-02, -.4576D-02, -.1507D-01,
     #    -.2416D-01, -.2776D-01, -.2419D-01, -.1519D-01, -.4142D-02,
     #    0.5976D-02, 0.1351D-01, 0.1805D-01, 0.2003D-01, 0.2009D-01,
     #    0.1892D-01, 0.1705D-01, 0.1489D-01, 0.1269D-01, 0.1061D-01,
     #    0.8730D-02, 0.7091D-02, 0.5696D-02, 0.4531D-02, 0.3575D-02,
     #    0.2799D-02, 0.2178D-02, 0.1683D-02, 0.1295D-02, 0.9910D-03,
     #    0.7550D-03, 0.5727D-03, 0.4329D-03, 0.3260D-03, 0.2446D-03,
     #    0.1830D-03, 0.1365D-03, 0.1016D-03, 0.7536D-04, 0.5579D-04,
     #    0.4120D-04/

      data (calcpts(j,19), j = 1,neta) /-.2090D-03, -.2088D-03,
     #    -.2086D-03, -.2083D-03, -.3578D-03, -.3571D-03, -.5061D-03,
     #    -.6547D-03, -.6525D-03, -.7993D-03, -.1095D-02, -.1238D-02,
     #    -.1528D-02, -.1813D-02, -.2092D-02, -.2510D-02, -.3064D-02,
     #    -.3595D-02, -.4245D-02, -.4999D-02, -.5684D-02, -.6569D-02,
     #    -.7458D-02, -.8283D-02, -.9099D-02, -.9764D-02, -.9935D-02,
     #    -.9630D-02, -.8473D-02, -.6571D-02, -.3899D-02, -.6442D-03,
     #    0.2218D-02, 0.3113D-02, 0.6896D-03, -.5955D-02, -.1509D-01,
     #    -.2328D-01, -.2662D-01, -.2333D-01, -.1482D-01, -.4195D-02,
     #    0.5655D-02, 0.1305D-01, 0.1759D-01, 0.1960D-01, 0.1974D-01,
     #    0.1863D-01, 0.1682D-01, 0.1472D-01, 0.1256D-01, 0.1051D-01,
     #    0.8655D-02, 0.7035D-02, 0.5655D-02, 0.4501D-02, 0.3553D-02,
     #    0.2784D-02, 0.2166D-02, 0.1676D-02, 0.1289D-02, 0.9868D-03,
     #    0.7519D-03, 0.5706D-03, 0.4312D-03, 0.3248D-03, 0.2438D-03,
     #    0.1824D-03, 0.1361D-03, 0.1013D-03, 0.7515D-04, 0.5564D-04,
     #    0.4110D-04/

      data (calcpts(j,20), j = 1,neta) /-.1704D-03, -.1703D-03,
     #    -.1701D-03, -.1698D-03, -.3194D-03, -.3188D-03, -.4679D-03,
     #    -.4665D-03, -.6145D-03, -.7616D-03, -.9074D-03, -.1051D-02,
     #    -.1342D-02, -.1629D-02, -.1909D-02, -.2330D-02, -.2737D-02,
     #    -.3275D-02, -.3784D-02, -.4550D-02, -.5253D-02, -.6015D-02,
     #    -.6793D-02, -.7677D-02, -.8426D-02, -.9065D-02, -.9413D-02,
     #    -.9366D-02, -.8727D-02, -.7347D-02, -.5105D-02, -.2548D-02,
     #    -.2590D-03, 0.4423D-03, -.1496D-02, -.6912D-02, -.1477D-01,
     #    -.2202D-01, -.2513D-01, -.2227D-01, -.1444D-01, -.4398D-02,
     #    0.5099D-02, 0.1237D-01, 0.1690D-01, 0.1899D-01, 0.1922D-01,
     #    0.1822D-01, 0.1651D-01, 0.1447D-01, 0.1237D-01, 0.1037D-01,
     #    0.8549D-02, 0.6956D-02, 0.5596D-02, 0.4459D-02, 0.3522D-02,
     #    0.2761D-02, 0.2149D-02, 0.1663D-02, 0.1280D-02, 0.9806D-03,
     #    0.7475D-03, 0.5674D-03, 0.4290D-03, 0.3232D-03, 0.2427D-03,
     #    0.1816D-03, 0.1355D-03, 0.1009D-03, 0.7488D-04, 0.5544D-04,
     #    0.4096D-04/

      data (calcpts(j,21), j = 1,neta) /-.9777D-04, -.9765D-04,
     #    -.2475D-03, -.2472D-03, -.2468D-03, -.3963D-03, -.3955D-03,
     #    -.5443D-03, -.5425D-03, -.6900D-03, -.8362D-03, -.9806D-03,
     #    -.1272D-02, -.1411D-02, -.1693D-02, -.2117D-02, -.2380D-02,
     #    -.2924D-02, -.3443D-02, -.3924D-02, -.4649D-02, -.5293D-02,
     #    -.6119D-02, -.6921D-02, -.7621D-02, -.8255D-02, -.8666D-02,
     #    -.8774D-02, -.8275D-02, -.7367D-02, -.5844D-02, -.3874D-02,
     #    -.1962D-02, -.1328D-02, -.2876D-02, -.7216D-02, -.1382D-01,
     #    -.2019D-01, -.2324D-01, -.2102D-01, -.1410D-01, -.4830D-02,
     #    0.4201D-02, 0.1132D-01, 0.1589D-01, 0.1810D-01, 0.1848D-01,
     #    0.1764D-01, 0.1604D-01, 0.1411D-01, 0.1210D-01, 0.1017D-01,
     #    0.8402D-02, 0.6848D-02, 0.5517D-02, 0.4401D-02, 0.3480D-02,
     #    0.2730D-02, 0.2128D-02, 0.1649D-02, 0.1269D-02, 0.9725D-03,
     #    0.7418D-03, 0.5633D-03, 0.4261D-03, 0.3212D-03, 0.2412D-03,
     #    0.1805D-03, 0.1348D-03, 0.1003D-03, 0.7450D-04, 0.5519D-04,
     #    0.4077D-04/

      data (calcpts(j,22), j = 1,neta) /-.1735D-03, -.1734D-03,
     #    -.1732D-03, -.1730D-03, -.1727D-03, -.3222D-03, -.3215D-03,
     #    -.4705D-03, -.4690D-03, -.6168D-03, -.7635D-03, -.9088D-03,
     #    -.1052D-02, -.1192D-02, -.1476D-02, -.1754D-02, -.2022D-02,
     #    -.2424D-02, -.2805D-02, -.3302D-02, -.3902D-02, -.4582D-02,
     #    -.5160D-02, -.5890D-02, -.6402D-02, -.7051D-02, -.7399D-02,
     #    -.7551D-02, -.7244D-02, -.6584D-02, -.5435D-02, -.3748D-02,
     #    -.2404D-02, -.1634D-02, -.2806D-02, -.6324D-02, -.1186D-01,
     #    -.1759D-01, -.2080D-01, -.1952D-01, -.1382D-01, -.5557D-02,
     #    0.2891D-02, 0.9818D-02, 0.1445D-01, 0.1684D-01, 0.1745D-01,
     #    0.1682D-01, 0.1542D-01, 0.1364D-01, 0.1175D-01, 0.9902D-02,
     #    0.8205D-02, 0.6703D-02, 0.5412D-02, 0.4324D-02, 0.3423D-02,
     #    0.2689D-02, 0.2099D-02, 0.1627D-02, 0.1254D-02, 0.9617D-03,
     #    0.7340D-03, 0.5578D-03, 0.4222D-03, 0.3184D-03, 0.2392D-03,
     #    0.1791D-03, 0.1338D-03, 0.9964D-04, 0.7402D-04, 0.5483D-04,
     #    0.4054D-04/

      data (calcpts(j,23), j = 1,neta) /-.1129D-03, -.1128D-03,
     #    -.1127D-03, -.1125D-03, -.1122D-03, -.2618D-03, -.2612D-03,
     #    -.2604D-03, -.4091D-03, -.4073D-03, -.5546D-03, -.7007D-03,
     #    -.8449D-03, -.9864D-03, -.1124D-02, -.1406D-02, -.1679D-02,
     #    -.1939D-02, -.2331D-02, -.2697D-02, -.3172D-02, -.3590D-02,
     #    -.4073D-02, -.4583D-02, -.5063D-02, -.5583D-02, -.5880D-02,
     #    -.5942D-02, -.5700D-02, -.5019D-02, -.3989D-02, -.2646D-02,
     #    -.1380D-02, -.6668D-03, -.1348D-02, -.4099D-02, -.8787D-02,
     #    -.1408D-01, -.1771D-01, -.1766D-01, -.1350D-01, -.6539D-02,
     #    0.1131D-02, 0.7788D-02, 0.1250D-01, 0.1516D-01, 0.1607D-01,
     #    0.1573D-01, 0.1458D-01, 0.1301D-01, 0.1127D-01, 0.9550D-02,
     #    0.7946D-02, 0.6514D-02, 0.5274D-02, 0.4223D-02, 0.3352D-02,
     #    0.2638D-02, 0.2061D-02, 0.1599D-02, 0.1235D-02, 0.9479D-03,
     #    0.7242D-03, 0.5508D-03, 0.4171D-03, 0.3147D-03, 0.2367D-03,
     #    0.1774D-03, 0.1326D-03, 0.9877D-04, 0.7339D-04, 0.5439D-04,
     #    0.4023D-04/

      data (calcpts(j,24), j = 1,neta) /-.6910D-04, -.6903D-04,
     #    -.9893D-04, -.1138D-03, -.1286D-03, -.1583D-03, -.2028D-03,
     #    -.2471D-03, -.2911D-03, -.3496D-03, -.4225D-03, -.5093D-03,
     #    -.6097D-03, -.7229D-03, -.8780D-03, -.1043D-02, -.1247D-02,
     #    -.1470D-02, -.1739D-02, -.2031D-02, -.2367D-02, -.2716D-02,
     #    -.3103D-02, -.3481D-02, -.3821D-02, -.4103D-02, -.4266D-02,
     #    -.4227D-02, -.3915D-02, -.3268D-02, -.2253D-02, -.9436D-03,
     #    0.4012D-03, 0.1290D-02, 0.1046D-02, -.9929D-03, -.4925D-02,
     #    -.9856D-02, -.1397D-01, -.1528D-01, -.1294D-01, -.7601D-02,
     #    -.9618D-03, 0.5278D-02, 0.1004D-01, 0.1299D-01, 0.1429D-01,
     #    0.1432D-01, 0.1350D-01, 0.1220D-01, 0.1067D-01, 0.9105D-02,
     #    0.7620D-02, 0.6276D-02, 0.5100D-02, 0.4098D-02, 0.3261D-02,
     #    0.2573D-02, 0.2015D-02, 0.1566D-02, 0.1211D-02, 0.9308D-03,
     #    0.7119D-03, 0.5422D-03, 0.4110D-03, 0.3105D-03, 0.2336D-03,
     #    0.1753D-03, 0.1310D-03, 0.9769D-04, 0.7262D-04, 0.5386D-04,
     #    0.3984D-04/

      data (calcpts(j,25), j = 1,neta) /-.4463D-04, -.5957D-04,
     #    -.7450D-04, -.8938D-04, -.1042D-03, -.1190D-03, -.1486D-03,
     #    -.1781D-03, -.2073D-03, -.2512D-03, -.3095D-03, -.3671D-03,
     #    -.4385D-03, -.5383D-03, -.6356D-03, -.7593D-03, -.8927D-03,
     #    -.1063D-02, -.1253D-02, -.1455D-02, -.1694D-02, -.1941D-02,
     #    -.2196D-02, -.2435D-02, -.2639D-02, -.2786D-02, -.2809D-02,
     #    -.2651D-02, -.2252D-02, -.1543D-02, -.5098D-03, 0.8178D-03,
     #    0.2215D-02, 0.3330D-02, 0.3531D-02, 0.2191D-02, -.9599D-03,
     #    -.5427D-02, -.9834D-02, -.1238D-01, -.1187D-01, -.8389D-02,
     #    -.3088D-02, 0.2501D-02, 0.7192D-02, 0.1042D-01, 0.1214D-01,
     #    0.1261D-01, 0.1219D-01, 0.1120D-01, 0.9929D-02, 0.8561D-02,
     #    0.7221D-02, 0.5986D-02, 0.4890D-02, 0.3947D-02, 0.3152D-02,
     #    0.2494D-02, 0.1957D-02, 0.1526D-02, 0.1182D-02, 0.9102D-03,
     #    0.6974D-03, 0.5317D-03, 0.4036D-03, 0.3053D-03, 0.2299D-03,
     #    0.1726D-03, 0.1292D-03, 0.9638D-04, 0.7171D-04, 0.5322D-04,
     #    0.3940D-04/

      data (calcpts(j,26), j = 1,neta) /-.2966D-04, -.2962D-04,
     #    -.4456D-04, -.4447D-04, -.5935D-04, -.7417D-04, -.8890D-04,
     #    -.1185D-03, -.1329D-03, -.1621D-03, -.2058D-03, -.2490D-03,
     #    -.3063D-03, -.3624D-03, -.4316D-03, -.5132D-03, -.6057D-03,
     #    -.7225D-03, -.8457D-03, -.9865D-03, -.1139D-02, -.1295D-02,
     #    -.1441D-02, -.1591D-02, -.1687D-02, -.1708D-02, -.1632D-02,
     #    -.1397D-02, -.9495D-03, -.2161D-03, 0.8048D-03, 0.2109D-02,
     #    0.3533D-02, 0.4767D-02, 0.5314D-02, 0.4615D-02, 0.2265D-02,
     #    -.1537D-02, -.5856D-02, -.9181D-02, -.1023D-01, -.8583D-02,
     #    -.4844D-02, -.1984D-03, 0.4188D-02, 0.7570D-02, 0.9685D-02,
     #    0.1062D-01, 0.1064D-01, 0.1003D-01, 0.9054D-02, 0.7917D-02,
     #    0.6752D-02, 0.5644D-02, 0.4644D-02, 0.3768D-02, 0.3024D-02,
     #    0.2402D-02, 0.1891D-02, 0.1479D-02, 0.1148D-02, 0.8863D-03,
     #    0.6802D-03, 0.5196D-03, 0.3951D-03, 0.2992D-03, 0.2257D-03,
     #    0.1695D-03, 0.1270D-03, 0.9488D-04, 0.7065D-04, 0.5247D-04,
     #    0.3887D-04/

      data (calcpts(j,27), j = 1,neta) /-.3332D-04, -.3329D-04,
     #    -.4825D-04, -.4819D-04, -.6309D-04, -.6296D-04, -.7777D-04,
     #    -.9248D-04, -.1071D-03, -.1364D-03, -.1505D-03, -.1792D-03,
     #    -.2222D-03, -.2494D-03, -.3051D-03, -.3589D-03, -.4248D-03,
     #    -.4865D-03, -.5719D-03, -.6482D-03, -.7412D-03, -.8295D-03,
     #    -.9192D-03, -.9822D-03, -.9994D-03, -.9586D-03, -.8365D-03,
     #    -.5633D-03, -.9504D-04, 0.5896D-03, 0.1553D-02, 0.2755D-02,
     #    0.4087D-02, 0.5337D-02, 0.6085D-02, 0.5854D-02, 0.4228D-02,
     #    0.1195D-02, -.2655D-02, -.6188D-02, -.8228D-02, -.8095D-02,
     #    -.5908D-02, -.2429D-02, 0.1368D-02, 0.4683D-02, 0.7072D-02,
     #    0.8434D-02, 0.8900D-02, 0.8695D-02, 0.8056D-02, 0.7179D-02,
     #    0.6213D-02, 0.5253D-02, 0.4361D-02, 0.3564D-02, 0.2877D-02,
     #    0.2297D-02, 0.1817D-02, 0.1425D-02, 0.1110D-02, 0.8591D-03,
     #    0.6609D-03, 0.5058D-03, 0.3854D-03, 0.2922D-03, 0.2208D-03,
     #    0.1661D-03, 0.1246D-03, 0.9317D-04, 0.6945D-04, 0.5163D-04,
     #    0.3828D-04/

      data (calcpts(j,28), j = 1,neta) /-.1367D-04, -.1365D-04,
     #    -.2862D-04, -.2858D-04, -.2851D-04, -.4342D-04, -.4328D-04,
     #    -.5807D-04, -.7277D-04, -.7232D-04, -.1017D-03, -.1157D-03,
     #    -.1293D-03, -.1572D-03, -.1842D-03, -.2248D-03, -.2633D-03,
     #    -.2987D-03, -.3447D-03, -.3991D-03, -.4439D-03, -.4897D-03,
     #    -.5300D-03, -.5403D-03, -.5221D-03, -.4407D-03, -.2989D-03,
     #    -.2706D-04, 0.3975D-03, 0.1014D-02, 0.1850D-02, 0.2886D-02,
     #    0.4067D-02, 0.5210D-02, 0.6002D-02, 0.6036D-02, 0.4981D-02,
     #    0.2682D-02, -.5298D-03, -.3840D-02, -.6280D-02, -.7128D-02,
     #    -.6212D-02, -.3917D-02, -.9303D-03, 0.2049D-02, 0.4500D-02,
     #    0.6172D-02, 0.7042D-02, 0.7241D-02, 0.6951D-02, 0.6357D-02,
     #    0.5610D-02, 0.4815D-02, 0.4043D-02, 0.3336D-02, 0.2713D-02,
     #    0.2179D-02, 0.1734D-02, 0.1365D-02, 0.1067D-02, 0.8287D-03,
     #    0.6394D-03, 0.4906D-03, 0.3745D-03, 0.2845D-03, 0.2153D-03,
     #    0.1623D-03, 0.1219D-03, 0.9126D-04, 0.6811D-04, 0.5068D-04,
     #    0.3761D-04/

      data (calcpts(j,29), j = 1,neta) /0.8002D-06, -.1419D-04,
     #    -.1416D-04, -.1413D-04, -.1409D-04, -.1402D-04, -.2892D-04,
     #    -.2877D-04, -.2856D-04, -.4325D-04, -.5778D-04, -.5711D-04,
     #    -.7112D-04, -.8466D-04, -.1125D-03, -.1244D-03, -.1498D-03,
     #    -.1730D-03, -.1931D-03, -.2236D-03, -.2473D-03, -.2610D-03,
     #    -.2753D-03, -.2534D-03, -.2158D-03, -.1335D-03, 0.2768D-04,
     #    0.2657D-03, 0.6328D-03, 0.1148D-02, 0.1843D-02, 0.2699D-02,
     #    0.3677D-02, 0.4635D-02, 0.5363D-02, 0.5530D-02, 0.4838D-02,
     #    0.3127D-02, 0.5668D-03, -.2303D-02, -.4731D-02, -.6054D-02,
     #    -.5981D-02, -.4655D-02, -.2514D-02, -.7367D-04, 0.2202D-02,
     #    0.3995D-02, 0.5164D-02, 0.5717D-02, 0.5769D-02, 0.5467D-02,
     #    0.4952D-02, 0.4334D-02, 0.3695D-02, 0.3085D-02, 0.2533D-02,
     #    0.2051D-02, 0.1640D-02, 0.1300D-02, 0.1021D-02, 0.7954D-03,
     #    0.6157D-03, 0.4738D-03, 0.3626D-03, 0.2761D-03, 0.2094D-03,
     #    0.1580D-03, 0.1189D-03, 0.8917D-04, 0.6664D-04, 0.4965D-04,
     #    0.3688D-04/

      data (calcpts(j,30), j = 1,neta) /0.2726D-05, -.1226D-04,
     #    -.1225D-04, -.1223D-04, -.1219D-04, -.1215D-04, -.1208D-04,
     #    -.1198D-04, -.2683D-04, -.2661D-04, -.2628D-04, -.4081D-04,
     #    -.4012D-04, -.5410D-04, -.6761D-04, -.6541D-04, -.7719D-04,
     #    -.1025D-03, -.1105D-03, -.1154D-03, -.1305D-03, -.1237D-03,
     #    -.1217D-03, -.8993D-04, -.5168D-04, 0.3277D-04, 0.1769D-03,
     #    0.3852D-03, 0.6838D-03, 0.1107D-02, 0.1652D-02, 0.2325D-02,
     #    0.3112D-02, 0.3884D-02, 0.4477D-02, 0.4672D-02, 0.4216D-02,
     #    0.2951D-02, 0.9433D-03, -.1449D-02, -.3665D-02, -.5139D-02,
     #    -.5535D-02, -.4866D-02, -.3416D-02, -.1555D-02, 0.3704D-03,
     #    0.2080D-02, 0.3384D-02, 0.4200D-02, 0.4549D-02, 0.4527D-02,
     #    0.4248D-02, 0.3816D-02, 0.3319D-02, 0.2814D-02, 0.2337D-02,
     #    0.1910D-02, 0.1540D-02, 0.1228D-02, 0.9698D-03, 0.7593D-03,
     #    0.5900D-03, 0.4556D-03, 0.3496D-03, 0.2670D-03, 0.2029D-03,
     #    0.1536D-03, 0.1157D-03, 0.8690D-04, 0.6504D-04, 0.4852D-04,
     #    0.3610D-04/

      data (calcpts(j,31), j = 1,neta) /0.1204D-05, 0.1211D-05,
     #    0.1222D-05, 0.1237D-05, 0.1259D-05, -.1371D-04, -.1366D-04,
     #    -.1359D-04, -.1349D-04, -.1333D-04, -.1311D-04, -.1278D-04,
     #    -.2730D-04, -.2659D-04, -.2556D-04, -.3904D-04, -.3680D-04,
     #    -.4853D-04, -.4372D-04, -.5167D-04, -.5635D-04, -.4120D-04,
     #    -.3402D-04, -.1605D-05, 0.4573D-04, 0.1297D-03, 0.2447D-03,
     #    0.4041D-03, 0.6562D-03, 0.9796D-03, 0.1404D-02, 0.1920D-02,
     #    0.2519D-02, 0.3115D-02, 0.3590D-02, 0.3764D-02, 0.3443D-02,
     #    0.2495D-02, 0.9307D-03, -.1023D-02, -.2965D-02, -.4429D-02,
     #    -.5075D-02, -.4820D-02, -.3847D-02, -.2457D-02, -.9175D-03,
     #    0.5657D-03, 0.1835D-02, 0.2778D-02, 0.3347D-02, 0.3567D-02,
     #    0.3512D-02, 0.3267D-02, 0.2916D-02, 0.2522D-02, 0.2127D-02,
     #    0.1761D-02, 0.1433D-02, 0.1152D-02, 0.9153D-03, 0.7205D-03,
     #    0.5625D-03, 0.4360D-03, 0.3358D-03, 0.2572D-03, 0.1960D-03,
     #    0.1486D-03, 0.1123D-03, 0.8446D-04, 0.6331D-04, 0.4732D-04,
     #    0.3525D-04/

      data (calcpts(j,32), j = 1,neta) /-.4108D-06, -.4060D-06,
     #    -.3988D-06, -.3883D-06, -.1873D-05, -.1850D-05, -.3317D-05,
     #    -.3268D-05, -.4697D-05, -.6092D-05, -.7438D-05, -.8712D-05,
     #    -.9880D-05, -.1089D-04, -.1318D-04, -.1513D-04, -.1659D-04,
     #    -.1733D-04, -.1702D-04, -.1515D-04, -.9533D-05, 0.9116D-06,
     #    0.1771D-04, 0.4607D-04, 0.8921D-04, 0.1533D-03, 0.2492D-03,
     #    0.3834D-03, 0.5712D-03, 0.8215D-03, 0.1145D-02, 0.1540D-02,
     #    0.1985D-02, 0.2433D-02, 0.2792D-02, 0.2929D-02, 0.2695D-02,
     #    0.1979D-02, 0.7654D-03, -.8107D-03, -.2468D-02, -.3849D-02,
     #    -.4632D-02, -.4666D-02, -.4031D-02, -.2965D-02, -.1732D-02,
     #    -.5033D-03, 0.6184D-03, 0.1553D-02, 0.2232D-02, 0.2630D-02,
     #    0.2766D-02, 0.2698D-02, 0.2493D-02, 0.2213D-02, 0.1905D-02,
     #    0.1600D-02, 0.1319D-02, 0.1070D-02, 0.8571D-03, 0.6791D-03,
     #    0.5331D-03, 0.4152D-03, 0.3211D-03, 0.2467D-03, 0.1886D-03,
     #    0.1434D-03, 0.1086D-03, 0.8187D-04, 0.6149D-04, 0.4602D-04,
     #    0.3434D-04/

      data (calcpts(j,33), j = 1,neta) /-.1502D-05, -.1499D-05,
     #    -.1494D-05, -.2987D-05, -.2976D-05, -.2960D-05, -.2938D-05,
     #    -.2904D-05, -.2855D-05, -.4283D-05, -.4177D-05, -.4021D-05,
     #    -.5293D-05, -.4958D-05, -.5967D-05, -.5246D-05, -.5687D-05,
     #    -.4135D-05, -.1857D-05, 0.2986D-05, 0.9379D-05, 0.1956D-04,
     #    0.3607D-04, 0.6194D-04, 0.9788D-04, 0.1516D-03, 0.2260D-03,
     #    0.3319D-03, 0.4751D-03, 0.6637D-03, 0.9059D-03, 0.1200D-02,
     #    0.1530D-02, 0.1861D-02, 0.2124D-02, 0.2225D-02, 0.2050D-02,
     #    0.1508D-02, 0.5710D-03, -.6807D-03, -.2063D-02, -.3315D-02,
     #    -.4162D-02, -.4421D-02, -.4069D-02, -.3260D-02, -.2236D-02,
     #    -.1198D-02, -.2422D-03, 0.5943D-03, 0.1277D-02, 0.1765D-02,
     #    0.2043D-02, 0.2126D-02, 0.2058D-02, 0.1891D-02, 0.1669D-02,
     #    0.1431D-02, 0.1198D-02, 0.9835D-03, 0.7955D-03, 0.6352D-03,
     #    0.5020D-03, 0.3931D-03, 0.3054D-03, 0.2357D-03, 0.1807D-03,
     #    0.1379D-03, 0.1047D-03, 0.7910D-04, 0.5955D-04, 0.4466D-04,
     #    0.3338D-04/

      data (calcpts(j,34), j = 1,neta) /-.6676D-06, -.6653D-06,
     #    -.6619D-06, -.6570D-06, -.6497D-06, -.6391D-06, -.6234D-06,
     #    -.6005D-06, -.5668D-06, -.5174D-06, -.4448D-06, -.3383D-06,
     #    -.1820D-06, 0.4757D-07, 0.3840D-06, 0.8782D-06, 0.3104D-05,
     #    0.5667D-05, 0.8728D-05, 0.1252D-04, 0.2037D-04, 0.2979D-04,
     #    0.4449D-04, 0.6552D-04, 0.9590D-04, 0.1378D-03, 0.1958D-03,
     #    0.2772D-03, 0.3849D-03, 0.5267D-03, 0.7048D-03, 0.9213D-03,
     #    0.1163D-02, 0.1404D-02, 0.1595D-02, 0.1666D-02, 0.1531D-02,
     #    0.1122D-02, 0.4051D-03, -.5752D-03, -.1702D-02, -.2792D-02,
     #    -.3638D-02, -.4057D-02, -.3963D-02, -.3408D-02, -.2568D-02,
     #    -.1655D-02, -.8125D-03, -.8359D-04, 0.5332D-03, 0.1029D-02,
     #    0.1379D-02, 0.1572D-02, 0.1621D-02, 0.1560D-02, 0.1425D-02,
     #    0.1253D-02, 0.1070D-02, 0.8921D-03, 0.7305D-03, 0.5890D-03,
     #    0.4691D-03, 0.3697D-03, 0.2889D-03, 0.2240D-03, 0.1725D-03,
     #    0.1320D-03, 0.1005D-03, 0.7618D-04, 0.5748D-04, 0.4321D-04,
     #    0.3237D-04/

      data (calcpts(j,35), j = 1,neta) /0.5347D-06, 0.5363D-06,
     #    0.5386D-06, 0.5419D-06, 0.5469D-06, 0.5542D-06, 0.5649D-06,
     #    0.5806D-06, 0.6036D-06, 0.6374D-06, 0.2187D-05, 0.2260D-05,
     #    0.2367D-05, 0.2524D-05, 0.4254D-05, 0.4592D-05, 0.6588D-05,
     #    0.8816D-05, 0.1288D-04, 0.1745D-04, 0.2274D-04, 0.3211D-04,
     #    0.4453D-04, 0.6073D-04, 0.8475D-04, 0.1181D-03, 0.1628D-03,
     #    0.2234D-03, 0.3054D-03, 0.4095D-03, 0.5410D-03, 0.6985D-03,
     #    0.8741D-03, 0.1048D-02, 0.1186D-02, 0.1233D-02, 0.1131D-02,
     #    0.8216D-03, 0.2791D-03, -.4777D-03, -.1375D-02, -.2291D-02,
     #    -.3077D-02, -.3580D-02, -.3695D-02, -.3395D-02, -.2766D-02,
     #    -.1979D-02, -.1205D-02, -.5397D-03, 0.7416D-05, 0.4582D-03,
     #    0.8161D-03, 0.1067D-02, 0.1201D-02, 0.1229D-02, 0.1175D-02,
     #    0.1069D-02, 0.9362D-03, 0.7963D-03, 0.6621D-03, 0.5404D-03,
     #    0.4347D-03, 0.3453D-03, 0.2716D-03, 0.2118D-03, 0.1638D-03,
     #    0.1259D-03, 0.9621D-04, 0.7313D-04, 0.5534D-04, 0.4170D-04,
     #    0.3129D-04/

      data (calcpts(j,36), j = 1,neta) /-.1272D-06, -.1261D-06,
     #    -.1245D-06, -.1222D-06, -.1188D-06, -.1139D-06, 0.1393D-05,
     #    0.1404D-05, 0.1420D-05, 0.1443D-05, 0.1477D-05, 0.1527D-05,
     #    0.3100D-05, 0.3207D-05, 0.4864D-05, 0.5095D-05, 0.6934D-05,
     #    0.8931D-05, 0.1266D-04, 0.1673D-04, 0.2130D-04, 0.2960D-04,
     #    0.3896D-04, 0.5288D-04, 0.7206D-04, 0.9603D-04, 0.1307D-03,
     #    0.1766D-03, 0.2366D-03, 0.3126D-03, 0.4092D-03, 0.5243D-03,
     #    0.6506D-03, 0.7755D-03, 0.8721D-03, 0.9047D-03, 0.8264D-03,
     #    0.5968D-03, 0.1887D-03, -.3877D-03, -.1088D-02, -.1834D-02,
     #    -.2521D-02, -.3038D-02, -.3286D-02, -.3207D-02, -.2811D-02,
     #    -.2193D-02, -.1499D-02, -.8651D-03, -.3506D-03, 0.5516D-04,
     #    0.3822D-03, 0.6395D-03, 0.8182D-03, 0.9113D-03, 0.9262D-03,
     #    0.8813D-03, 0.7983D-03, 0.6966D-03, 0.5905D-03, 0.4894D-03,
     #    0.3984D-03, 0.3197D-03, 0.2535D-03, 0.1989D-03, 0.1548D-03,
     #    0.1195D-03, 0.9167D-04, 0.6994D-04, 0.5308D-04, 0.4011D-04,
     #    0.3018D-04/

      data (calcpts(j,37), j = 1,neta) /-.3661D-07, -.3588D-07,
     #    -.3480D-07, -.3323D-07, -.3091D-07, -.2751D-07, 0.1477D-05,
     #    0.1485D-05, 0.1496D-05, 0.1511D-05, 0.1534D-05, 0.1568D-05,
     #    0.3118D-05, 0.3191D-05, 0.4799D-05, 0.4956D-05, 0.6688D-05,
     #    0.8527D-05, 0.1202D-04, 0.1426D-04, 0.1982D-04, 0.2589D-04,
     #    0.3269D-04, 0.4355D-04, 0.5745D-04, 0.7660D-04, 0.1035D-03,
     #    0.1364D-03, 0.1804D-03, 0.2378D-03, 0.3072D-03, 0.3892D-03,
     #    0.4797D-03, 0.5693D-03, 0.6385D-03, 0.6609D-03, 0.6013D-03,
     #    0.4300D-03, 0.1266D-03, -.3072D-03, -.8445D-03, -.1435D-02,
     #    -.2010D-02, -.2491D-02, -.2801D-02, -.2875D-02, -.2689D-02,
     #    -.2270D-02, -.1706D-02, -.1120D-02, -.6135D-03, -.2218D-03,
     #    0.7605D-04, 0.3118D-03, 0.4963D-03, 0.6232D-03, 0.6876D-03,
     #    0.6946D-03, 0.6579D-03, 0.5936D-03, 0.5163D-03, 0.4364D-03,
     #    0.3607D-03, 0.2929D-03, 0.2344D-03, 0.1855D-03, 0.1452D-03,
     #    0.1128D-03, 0.8695D-04, 0.6660D-04, 0.5073D-04, 0.3844D-04,
     #    0.2901D-04/

      data (calcpts(j,38), j = 1,neta) /0.4340D-06, 0.4345D-06,
     #    0.4352D-06, 0.5863D-06, 0.5879D-06, 0.7402D-06, 0.8936D-06,
     #    0.1049D-05, 0.1206D-05, 0.1517D-05, 0.1832D-05, 0.2156D-05,
     #    0.2640D-05, 0.3290D-05, 0.4113D-05, 0.5120D-05, 0.6328D-05,
     #    0.7909D-05, 0.1005D-04, 0.1265D-04, 0.1623D-04, 0.2090D-04,
     #    0.2711D-04, 0.3525D-04, 0.4610D-04, 0.6057D-04, 0.7963D-04,
     #    0.1045D-03, 0.1369D-03, 0.1778D-03, 0.2282D-03, 0.2876D-03,
     #    0.3529D-03, 0.4165D-03, 0.4653D-03, 0.4797D-03, 0.4353D-03,
     #    0.3089D-03, 0.8466D-04, -.2385D-03, -.6450D-03, -.1103D-02,
     #    -.1567D-02, -.1985D-02, -.2300D-02, -.2460D-02, -.2429D-02,
     #    -.2195D-02, -.1796D-02, -.1306D-02, -.8268D-03, -.4301D-03,
     #    -.1358D-03, 0.8103D-04, 0.2500D-03, 0.3818D-03, 0.4719D-03,
     #    0.5163D-03, 0.5186D-03, 0.4891D-03, 0.4398D-03, 0.3814D-03,
     #    0.3214D-03, 0.2650D-03, 0.2148D-03, 0.1714D-03, 0.1354D-03,
     #    0.1058D-03, 0.8203D-04, 0.6313D-04, 0.4828D-04, 0.3672D-04,
     #    0.2779D-04/

      data (calcpts(j,39), j = 1,neta) /0.5623D-07, 0.5657D-07,
     #    0.2071D-06, 0.2078D-06, 0.3589D-06, 0.3605D-06, 0.5128D-06,
     #    0.6662D-06, 0.8212D-06, 0.9785D-06, 0.1289D-05, 0.1605D-05,
     #    0.2078D-05, 0.2562D-05, 0.3212D-05, 0.4036D-05, 0.5043D-05,
     #    0.6251D-05, 0.7983D-05, 0.1012D-04, 0.1287D-04, 0.1645D-04,
     #    0.2127D-04, 0.2748D-04, 0.3561D-04, 0.4644D-04, 0.6040D-04,
     #    0.7877D-04, 0.1022D-03, 0.1320D-03, 0.1684D-03, 0.2110D-03,
     #    0.2576D-03, 0.3029D-03, 0.3373D-03, 0.3468D-03, 0.3138D-03,
     #    0.2211D-03, 0.5647D-04, -.1822D-03, -.4860D-03, -.8348D-03,
     #    -.1199D-02, -.1545D-02, -.1832D-02, -.2025D-02, -.2087D-02,
     #    -.1997D-02, -.1755D-02, -.1398D-02, -.9886D-03, -.6044D-03,
     #    -.2986D-03, -.7958D-04, 0.7717D-04, 0.1978D-03, 0.2916D-03,
     #    0.3554D-03, 0.3859D-03, 0.3857D-03, 0.3623D-03, 0.3247D-03,
     #    0.2808D-03, 0.2361D-03, 0.1942D-03, 0.1570D-03, 0.1251D-03,
     #    0.9858D-04, 0.7692D-04, 0.5953D-04, 0.4575D-04, 0.3493D-04,
     #    0.2653D-04/

      data (calcpts(j,40), j = 1,neta) /0.5510D-07, 0.2053D-06,
     #    0.2057D-06, 0.2062D-06, 0.3569D-06, 0.3580D-06, 0.5096D-06,
     #    0.6619D-06, 0.8153D-06, 0.9703D-06, 0.1128D-05, 0.1438D-05,
     #    0.1754D-05, 0.2227D-05, 0.2711D-05, 0.3361D-05, 0.4185D-05,
     #    0.5192D-05, 0.6400D-05, 0.8132D-05, 0.1027D-04, 0.1302D-04,
     #    0.1660D-04, 0.2126D-04, 0.2732D-04, 0.3528D-04, 0.4562D-04,
     #    0.5906D-04, 0.7606D-04, 0.9755D-04, 0.1236D-03, 0.1542D-03,
     #    0.1874D-03, 0.2196D-03, 0.2437D-03, 0.2500D-03, 0.2255D-03,
     #    0.1579D-03, 0.3784D-04, -.1373D-03, -.3623D-03, -.6244D-03,
     #    -.9049D-03, -.1181D-02, -.1427D-02, -.1616D-02, -.1722D-02,
     #    -.1723D-02, -.1607D-02, -.1381D-02, -.1074D-02, -.7406D-03,
     #    -.4383D-03, -.2052D-03, -.4368D-04, 0.6896D-04, 0.1547D-03,
     #    0.2212D-03, 0.2663D-03, 0.2872D-03, 0.2859D-03, 0.2676D-03,
     #    0.2391D-03, 0.2061D-03, 0.1729D-03, 0.1419D-03, 0.1145D-03,
     #    0.9106D-04, 0.7162D-04, 0.5580D-04, 0.4311D-04, 0.3307D-04,
     #    0.2523D-04/

      data (calcpts(j,41), j = 1,neta) /0.1538D-06, 0.1540D-06,
     #    0.1542D-06, 0.3046D-06, 0.3051D-06, 0.4558D-06, 0.4569D-06,
     #    0.6085D-06, 0.6108D-06, 0.7642D-06, 0.9192D-06, 0.1227D-05,
     #    0.1387D-05, 0.1853D-05, 0.2176D-05, 0.2660D-05, 0.3310D-05,
     #    0.4134D-05, 0.5141D-05, 0.6349D-05, 0.8080D-05, 0.1007D-04,
     #    0.1282D-04, 0.1624D-04, 0.2075D-04, 0.2664D-04, 0.3413D-04,
     #    0.4397D-04, 0.5625D-04, 0.7167D-04, 0.9044D-04, 0.1121D-03,
     #    0.1358D-03, 0.1586D-03, 0.1756D-03, 0.1796D-03, 0.1617D-03,
     #    0.1126D-03, 0.2545D-04, -.1023D-03, -.2677D-03, -.4625D-03,
     #    -.6750D-03, -.8898D-03, -.1090D-02, -.1259D-02, -.1376D-02,
     #    -.1426D-02, -.1393D-02, -.1273D-02, -.1072D-02, -.8171D-03,
     #    -.5502D-03, -.3156D-03, -.1398D-03, -.2141D-04, 0.5911D-04,
     #    0.1198D-03, 0.1670D-03, 0.1987D-03, 0.2130D-03, 0.2110D-03,
     #    0.1969D-03, 0.1755D-03, 0.1509D-03, 0.1263D-03, 0.1034D-03,
     #    0.8329D-04, 0.6615D-04, 0.5193D-04, 0.4039D-04, 0.3117D-04,
     #    0.2388D-04/

      data (calcpts(j,42), j = 1,neta) /0.1268D-06, 0.1269D-06,
     #    0.1271D-06, 0.1273D-06, 0.2777D-06, 0.2782D-06, 0.2789D-06,
     #    0.4300D-06, 0.5816D-06, 0.5839D-06, 0.7373D-06, 0.8923D-06,
     #    0.1050D-05, 0.1360D-05, 0.1676D-05, 0.1999D-05, 0.2484D-05,
     #    0.3133D-05, 0.3957D-05, 0.4814D-05, 0.6172D-05, 0.7603D-05,
     #    0.9741D-05, 0.1219D-04, 0.1561D-04, 0.1981D-04, 0.2539D-04,
     #    0.3239D-04, 0.4125D-04, 0.5232D-04, 0.6577D-04, 0.8122D-04,
     #    0.9796D-04, 0.1141D-03, 0.1261D-03, 0.1287D-03, 0.1156D-03,
     #    0.8019D-04, 0.1712D-04, -.7555D-04, -.1962D-03, -.3400D-03,
     #    -.4988D-03, -.6630D-03, -.8216D-03, -.9624D-03, -.1073D-02,
     #    -.1142D-02, -.1157D-02, -.1108D-02, -.9944D-03, -.8232D-03,
     #    -.6161D-03, -.4059D-03, -.2258D-03, -.9430D-04, -.8106D-05,
     #    0.4920D-04, 0.9207D-04, 0.1254D-03, 0.1477D-03, 0.1575D-03,
     #    0.1554D-03, 0.1445D-03, 0.1285D-03, 0.1102D-03, 0.9204D-04,
     #    0.7524D-04, 0.6046D-04, 0.4794D-04, 0.3757D-04, 0.2919D-04,
     #    0.2248D-04/

      data (calcpts(j,43), j = 1,neta) /0.3333D-07, 0.3340D-07,
     #    0.1835D-06, 0.1837D-06, 0.1839D-06, 0.1842D-06, 0.3347D-06,
     #    0.3355D-06, 0.3366D-06, 0.4881D-06, 0.6405D-06, 0.6439D-06,
     #    0.7989D-06, 0.1106D-05, 0.1267D-05, 0.1583D-05, 0.1906D-05,
     #    0.2390D-05, 0.3040D-05, 0.3713D-05, 0.4571D-05, 0.5778D-05,
     #    0.7209D-05, 0.9196D-05, 0.1164D-04, 0.1475D-04, 0.1864D-04,
     #    0.2375D-04, 0.3010D-04, 0.3810D-04, 0.4761D-04, 0.5868D-04,
     #    0.7061D-04, 0.8200D-04, 0.9031D-04, 0.9201D-04, 0.8259D-04,
     #    0.5698D-04, 0.1157D-04, -.5540D-04, -.1431D-03, -.2484D-03,
     #    -.3660D-03, -.4896D-03, -.6121D-03, -.7254D-03, -.8216D-03,
     #    -.8921D-03, -.9283D-03, -.9227D-03, -.8695D-03, -.7683D-03,
     #    -.6264D-03, -.4612D-03, -.2978D-03, -.1608D-03, -.6301D-04,
     #    -.5616D-06, 0.4006D-04, 0.7022D-04, 0.9372D-04, 0.1094D-03,
     #    0.1160D-03, 0.1141D-03, 0.1058D-03, 0.9379D-04, 0.8031D-04,
     #    0.6693D-04, 0.5461D-04, 0.4381D-04, 0.3468D-04, 0.2715D-04,
     #    0.2104D-04/

      data (calcpts(j,44), j = 1,neta) /0.8178D-07, 0.9683D-07,
     #    0.1119D-06, 0.1270D-06, 0.1572D-06, 0.1724D-06, 0.2177D-06,
     #    0.2632D-06, 0.3090D-06, 0.3701D-06, 0.4466D-06, 0.5540D-06,
     #    0.6624D-06, 0.8174D-06, 0.9897D-06, 0.1210D-05, 0.1481D-05,
     #    0.1835D-05, 0.2259D-05, 0.2788D-05, 0.3462D-05, 0.4319D-05,
     #    0.5406D-05, 0.6791D-05, 0.8566D-05, 0.1082D-04, 0.1369D-04,
     #    0.1736D-04, 0.2194D-04, 0.2760D-04, 0.3441D-04, 0.4223D-04,
     #    0.5065D-04, 0.5868D-04, 0.6457D-04, 0.6569D-04, 0.5879D-04,
     #    0.4045D-04, 0.7843D-05, -.4037D-04, -.1038D-03, -.1805D-03,
     #    -.2670D-03, -.3590D-03, -.4519D-03, -.5404D-03, -.6195D-03,
     #    -.6833D-03, -.7262D-03, -.7420D-03, -.7260D-03, -.6746D-03,
     #    -.5881D-03, -.4730D-03, -.3430D-03, -.2173D-03, -.1139D-03,
     #    -.4169D-04, 0.3367D-05, 0.3205D-04, 0.5322D-04, 0.6976D-04,
     #    0.8076D-04, 0.8520D-04, 0.8352D-04, 0.7725D-04, 0.6834D-04,
     #    0.5838D-04, 0.4857D-04, 0.3955D-04, 0.3168D-04, 0.2505D-04,
     #    0.1957D-04/

      data (calcpts(j,45), j = 1,neta) /0.3399D-07, 0.4903D-07,
     #    0.4908D-07, 0.6415D-07, 0.9426D-07, 0.1094D-06, 0.1396D-06,
     #    0.1700D-06, 0.2155D-06, 0.2612D-06, 0.3223D-06, 0.3839D-06,
     #    0.4762D-06, 0.5846D-06, 0.7246D-06, 0.8820D-06, 0.1088D-05,
     #    0.1344D-05, 0.1652D-05, 0.2046D-05, 0.2546D-05, 0.3174D-05,
     #    0.3971D-05, 0.4982D-05, 0.6261D-05, 0.7899D-05, 0.9971D-05,
     #    0.1259D-04, 0.1587D-04, 0.1989D-04, 0.2474D-04, 0.3029D-04,
     #    0.3624D-04, 0.4189D-04, 0.4602D-04, 0.4677D-04, 0.4180D-04,
     #    0.2866D-04, 0.5308D-05, -.2928D-04, -.7499D-04, -.1305D-03,
     #    -.1937D-03, -.2616D-03, -.3313D-03, -.3991D-03, -.4619D-03,
     #    -.5157D-03, -.5569D-03, -.5813D-03, -.5850D-03, -.5648D-03,
     #    -.5184D-03, -.4467D-03, -.3548D-03, -.2537D-03, -.1578D-03,
     #    -.8039D-04, -.2727D-04, 0.5103D-05, 0.2530D-04, 0.4012D-04,
     #    0.5173D-04, 0.5943D-04, 0.6243D-04, 0.6099D-04, 0.5628D-04,
     #    0.4968D-04, 0.4236D-04, 0.3517D-04, 0.2860D-04, 0.2287D-04,
     #    0.1806D-04/

      data (calcpts(j,46), j = 1,neta) /0.2403D-07, 0.3905D-07,
     #    0.5409D-07, 0.5414D-07, 0.6921D-07, 0.8432D-07, 0.1145D-06,
     #    0.1297D-06, 0.1601D-06, 0.1906D-06, 0.2363D-06, 0.2974D-06,
     #    0.3589D-06, 0.4363D-06, 0.5447D-06, 0.6547D-06, 0.8120D-06,
     #    0.1003D-05, 0.1229D-05, 0.1522D-05, 0.1886D-05, 0.2341D-05,
     #    0.2923D-05, 0.3645D-05, 0.4581D-05, 0.5753D-05, 0.7236D-05,
     #    0.9121D-05, 0.1145D-04, 0.1432D-04, 0.1775D-04, 0.2168D-04,
     #    0.2590D-04, 0.2987D-04, 0.3277D-04, 0.3325D-04, 0.2967D-04,
     #    0.2028D-04, 0.3616D-05, -.2114D-04, -.5397D-04, -.9405D-04,
     #    -.1399D-03, -.1898D-03, -.2413D-03, -.2927D-03, -.3412D-03,
     #    -.3847D-03, -.4206D-03, -.4463D-03, -.4591D-03, -.4560D-03,
     #    -.4351D-03, -.3952D-03, -.3368D-03, -.2646D-03, -.1869D-03,
     #    -.1142D-03, -.5652D-04, -.1763D-04, 0.5553D-05, 0.1974D-04,
     #    0.3009D-04, 0.3822D-04, 0.4360D-04, 0.4561D-04, 0.4443D-04,
     #    0.4090D-04, 0.3603D-04, 0.3067D-04, 0.2542D-04, 0.2064D-04,
     #    0.1816D-04/

      data (calcpts(j,47), j = 1,neta) /0.3417D-07, 0.3418D-07,
     #    0.3421D-07, 0.4924D-07, 0.6429D-07, 0.6436D-07, 0.7947D-07,
     #    0.1096D-06, 0.1249D-06, 0.1552D-06, 0.1857D-06, 0.2314D-06,
     #    0.2775D-06, 0.3391D-06, 0.4014D-06, 0.4948D-06, 0.6048D-06,
     #    0.7472D-06, 0.9079D-06, 0.1119D-05, 0.1382D-05, 0.1716D-05,
     #    0.2140D-05, 0.2663D-05, 0.3339D-05, 0.4184D-05, 0.5248D-05,
     #    0.6591D-05, 0.8255D-05, 0.1029D-04, 0.1273D-04, 0.1550D-04,
     #    0.1847D-04, 0.2126D-04, 0.2327D-04, 0.2360D-04, 0.2103D-04,
     #    0.1434D-04, 0.2465D-05, -.1521D-04, -.3871D-04, -.6754D-04,
     #    -.1007D-03, -.1370D-03, -.1751D-03, -.2133D-03, -.2503D-03,
     #    -.2844D-03, -.3140D-03, -.3374D-03, -.3528D-03, -.3583D-03,
     #    -.3521D-03, -.3326D-03, -.2990D-03, -.2525D-03, -.1964D-03,
     #    -.1370D-03, -.8239D-04, -.3957D-04, -.1122D-04, 0.5333D-05,
     #    0.1525D-04, 0.2350D-04, 0.2827D-04, 0.3192D-04, 0.3325D-04,
     #    0.3231D-04, 0.3967D-04, 0.2610D-04, 0.2217D-04, 0.2139D-04,
     #    0.1488D-04/

      data (calcpts(j,48), j = 1,neta) /0.1551D-07, 0.3052D-07,
     #    0.3053D-07, 0.3056D-07, 0.4559D-07, 0.4564D-07, 0.6072D-07,
     #    0.7582D-07, 0.9098D-07, 0.1062D-06, 0.1366D-06, 0.1671D-06,
     #    0.1978D-06, 0.2439D-06, 0.2904D-06, 0.3678D-06, 0.4462D-06,
     #    0.5412D-06, 0.6685D-06, 0.8143D-06, 0.1010D-05, 0.1258D-05,
     #    0.1547D-05, 0.1926D-05, 0.2419D-05, 0.3019D-05, 0.3787D-05,
     #    0.4727D-05, 0.5913D-05, 0.7366D-05, 0.9086D-05, 0.1104D-04,
     #    0.1313D-04, 0.1509D-04, 0.1650D-04, 0.1671D-04, 0.1489D-04,
     #    0.1013D-04, 0.1680D-05, -.1091D-04, -.2770D-04, -.4837D-04,
     #    -.7228D-04, -.9860D-04, -.1264D-03, -.1548D-03, -.1824D-03,
     #    -.2087D-03, -.2323D-03, -.2522D-03, -.2670D-03, -.2758D-03,
     #    -.2771D-03, -.2696D-03, -.2523D-03, -.2250D-03, -.1884D-03,
     #    -.1451D-03, -.1001D-03, -.5924D-04, -.2765D-04, -.7038D-05,
     #    0.4754D-05, 0.1169D-04, 0.1671D-04, 0.2068D-04, 0.2329D-04,
     #    0.2419D-04, 0.2344D-04, 0.2149D-04, 0.1885D-04, 0.1600D-04,
     #    0.1322D-04/

      data (calcpts(j,49), j = 1,neta) /0.1268D-07, 0.1269D-07,
     #    0.2770D-07, 0.2771D-07, 0.2774D-07, 0.4277D-07, 0.4282D-07,
     #    0.5790D-07, 0.7300D-07, 0.7316D-07, 0.1034D-06, 0.1187D-06,
     #    0.1492D-06, 0.1800D-06, 0.2110D-06, 0.2576D-06, 0.3200D-06,
     #    0.3984D-06, 0.4784D-06, 0.5907D-06, 0.7364D-06, 0.9022D-06,
     #    0.1120D-05, 0.1394D-05, 0.1743D-05, 0.2175D-05, 0.2714D-05,
     #    0.3389D-05, 0.4234D-05, 0.5260D-05, 0.6466D-05, 0.7858D-05,
     #    0.9321D-05, 0.1070D-04, 0.1170D-04, 0.1182D-04, 0.1052D-04,
     #    0.7142D-05, 0.1146D-05, -.7803D-05, -.1976D-04, -.3455D-04,
     #    -.5172D-04, -.7074D-04, -.9095D-04, -.1117D-03, -.1324D-03,
     #    -.1522D-03, -.1706D-03, -.1866D-03, -.1996D-03, -.2088D-03,
     #    -.2135D-03, -.2124D-03, -.2049D-03, -.1902D-03, -.1683D-03,
     #    -.1398D-03, -.1068D-03, -.7290D-04, -.4251D-04, -.1928D-04,
     #    -.4354D-05, 0.4011D-05, 0.8844D-05, 0.1234D-04, 0.1510D-04,
     #    0.1693D-04, 0.1753D-04, 0.1695D-04, 0.1551D-04, 0.1360D-04,
     #    0.1152D-04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1_FTg = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     ==========================================
      double precision function h1bar_Tg(eta,xi)
c     ==========================================

c     eq (12) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subctbar in the original code.
c     Called sctbar in updated code (03/06/96).
 
      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /0.2829D-03, 0.3429D-03,
     #    0.4153D-03, 0.5032D-03, 0.6093D-03, 0.7385D-03, 0.8944D-03,
     #    0.1084D-02, 0.1313D-02, 0.1591D-02, 0.1928D-02, 0.2339D-02,
     #    0.2827D-02, 0.3429D-02, 0.4159D-02, 0.5038D-02, 0.6106D-02,
     #    0.7404D-02, 0.8979D-02, 0.1089D-01, 0.1322D-01, 0.1605D-01,
     #    0.1950D-01, 0.2372D-01, 0.2888D-01, 0.3520D-01, 0.4295D-01,
     #    0.5243D-01, 0.6398D-01, 0.7789D-01, 0.9419D-01, 0.1127D+00,
     #    0.1321D+00, 0.1504D+00, 0.1646D+00, 0.1713D+00, 0.1691D+00,
     #    0.1584D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8429D-01,
     #    0.6827D-01, 0.5456D-01, 0.4314D-01, 0.3383D-01, 0.2625D-01,
     #    0.2023D-01, 0.1549D-01, 0.1175D-01, 0.8913D-02, 0.6710D-02,
     #    0.4996D-02, 0.3763D-02, 0.2807D-02, 0.2058D-02, 0.1515D-02,
     #    0.1108D-02, 0.8360D-03, 0.6327D-03, 0.4304D-03, 0.2955D-03,
     #    0.2278D-03, 0.1604D-03, 0.9327D-04, 0.9293D-04, 0.9271D-04,
     #    0.2589D-04, 0.2578D-04, 0.2571D-04, 0.2566D-04, 0.2563D-04,
     #    0.2561D-04/

      data (calcpts(j, 2), j = 1,neta) /0.2830D-03, 0.3423D-03,
     #    0.4154D-03, 0.5027D-03, 0.6095D-03, 0.7380D-03, 0.8946D-03,
     #    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1928D-02, 0.2333D-02,
     #    0.2828D-02, 0.3430D-02, 0.4153D-02, 0.5039D-02, 0.6107D-02,
     #    0.7399D-02, 0.8973D-02, 0.1089D-01, 0.1321D-01, 0.1604D-01,
     #    0.1950D-01, 0.2371D-01, 0.2888D-01, 0.3519D-01, 0.4294D-01,
     #    0.5242D-01, 0.6398D-01, 0.7789D-01, 0.9419D-01, 0.1127D+00,
     #    0.1321D+00, 0.1504D+00, 0.1645D+00, 0.1713D+00, 0.1691D+00,
     #    0.1584D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8429D-01,
     #    0.6827D-01, 0.5462D-01, 0.4320D-01, 0.3382D-01, 0.2623D-01,
     #    0.2021D-01, 0.1548D-01, 0.1173D-01, 0.8899D-02, 0.6697D-02,
     #    0.5049D-02, 0.3750D-02, 0.2794D-02, 0.2045D-02, 0.1501D-02,
     #    0.1094D-02, 0.8227D-03, 0.6194D-03, 0.4172D-03, 0.3490D-03,
     #    0.2146D-03, 0.1472D-03, 0.1467D-03, 0.7970D-04, 0.7948D-04,
     #    0.7932D-04, 0.1255D-04, 0.1248D-04, 0.1243D-04, 0.1240D-04,
     #    0.1237D-04/

      data (calcpts(j, 3), j = 1,neta) /0.2825D-03, 0.3425D-03,
     #    0.4150D-03, 0.5030D-03, 0.6091D-03, 0.7384D-03, 0.8943D-03,
     #    0.1084D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2333D-02,
     #    0.2829D-02, 0.3431D-02, 0.4154D-02, 0.5033D-02, 0.6102D-02,
     #    0.7400D-02, 0.8975D-02, 0.1088D-01, 0.1322D-01, 0.1605D-01,
     #    0.1950D-01, 0.2372D-01, 0.2887D-01, 0.3519D-01, 0.4294D-01,
     #    0.5242D-01, 0.6397D-01, 0.7783D-01, 0.9418D-01, 0.1127D+00,
     #    0.1321D+00, 0.1503D+00, 0.1645D+00, 0.1713D+00, 0.1691D+00,
     #    0.1583D+00, 0.1416D+00, 0.1221D+00, 0.1025D+00, 0.8428D-01,
     #    0.6826D-01, 0.5460D-01, 0.4318D-01, 0.3380D-01, 0.2621D-01,
     #    0.2019D-01, 0.1546D-01, 0.1178D-01, 0.8880D-02, 0.6677D-02,
     #    0.5030D-02, 0.3730D-02, 0.2774D-02, 0.2092D-02, 0.1549D-02,
     #    0.1142D-02, 0.8033D-03, 0.6000D-03, 0.4644D-03, 0.3296D-03,
     #    0.2618D-03, 0.1945D-03, 0.1273D-03, 0.6031D-04, 0.6008D-04,
     #    0.5993D-04, 0.5982D-04, -.6914D-05, -.6963D-05, -.6996D-05,
     #    -.7019D-05/

      data (calcpts(j, 4), j = 1,neta) /0.2827D-03, 0.3428D-03,
     #    0.4153D-03, 0.5027D-03, 0.6089D-03, 0.7382D-03, 0.8942D-03,
     #    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2335D-02,
     #    0.2830D-02, 0.3426D-02, 0.4156D-02, 0.5035D-02, 0.6104D-02,
     #    0.7403D-02, 0.8971D-02, 0.1089D-01, 0.1321D-01, 0.1604D-01,
     #    0.1949D-01, 0.2371D-01, 0.2887D-01, 0.3519D-01, 0.4293D-01,
     #    0.5241D-01, 0.6395D-01, 0.7783D-01, 0.9418D-01, 0.1126D+00,
     #    0.1320D+00, 0.1503D+00, 0.1644D+00, 0.1713D+00, 0.1691D+00,
     #    0.1583D+00, 0.1416D+00, 0.1221D+00, 0.1024D+00, 0.8428D-01,
     #    0.6826D-01, 0.5457D-01, 0.4315D-01, 0.3377D-01, 0.2625D-01,
     #    0.2023D-01, 0.1550D-01, 0.1175D-01, 0.8918D-02, 0.6715D-02,
     #    0.5001D-02, 0.3768D-02, 0.2813D-02, 0.2064D-02, 0.1520D-02,
     #    0.1113D-02, 0.8415D-03, 0.6382D-03, 0.4360D-03, 0.3011D-03,
     #    0.2334D-03, 0.1660D-03, 0.9883D-04, 0.9849D-04, 0.3160D-04,
     #    0.3145D-04, 0.3134D-04, 0.3127D-04, 0.3122D-04, 0.3119D-04,
     #    0.3117D-04/

      data (calcpts(j, 5), j = 1,neta) /0.2824D-03, 0.3425D-03,
     #    0.4151D-03, 0.5025D-03, 0.6088D-03, 0.7382D-03, 0.8944D-03,
     #    0.1083D-02, 0.1313D-02, 0.1591D-02, 0.1927D-02, 0.2336D-02,
     #    0.2832D-02, 0.3428D-02, 0.4152D-02, 0.5031D-02, 0.6100D-02,
     #    0.7399D-02, 0.8968D-02, 0.1088D-01, 0.1321D-01, 0.1604D-01,
     #    0.1949D-01, 0.2370D-01, 0.2886D-01, 0.3518D-01, 0.4292D-01,
     #    0.5239D-01, 0.6393D-01, 0.7782D-01, 0.9411D-01, 0.1126D+00,
     #    0.1320D+00, 0.1503D+00, 0.1644D+00, 0.1713D+00, 0.1690D+00,
     #    0.1583D+00, 0.1415D+00, 0.1221D+00, 0.1024D+00, 0.8427D-01,
     #    0.6825D-01, 0.5459D-01, 0.4317D-01, 0.3380D-01, 0.2621D-01,
     #    0.2019D-01, 0.1545D-01, 0.1178D-01, 0.8876D-02, 0.6674D-02,
     #    0.5026D-02, 0.3727D-02, 0.2771D-02, 0.2089D-02, 0.1545D-02,
     #    0.1138D-02, 0.7997D-03, 0.5964D-03, 0.4608D-03, 0.3260D-03,
     #    0.2582D-03, 0.1909D-03, 0.1237D-03, 0.5670D-04, 0.5648D-04,
     #    0.5632D-04, 0.5622D-04, 0.5615D-04, -.1057D-04, -.1060D-04,
     #    -.1062D-04/

      data (calcpts(j, 6), j = 1,neta) /0.2829D-03, 0.3424D-03,
     #    0.4150D-03, 0.5026D-03, 0.6090D-03, 0.7379D-03, 0.8935D-03,
     #    0.1083D-02, 0.1312D-02, 0.1590D-02, 0.1925D-02, 0.2332D-02,
     #    0.2828D-02, 0.3424D-02, 0.4155D-02, 0.5035D-02, 0.6098D-02,
     #    0.7398D-02, 0.8967D-02, 0.1088D-01, 0.1320D-01, 0.1603D-01,
     #    0.1948D-01, 0.2369D-01, 0.2885D-01, 0.3516D-01, 0.4290D-01,
     #    0.5237D-01, 0.6390D-01, 0.7776D-01, 0.9410D-01, 0.1125D+00,
     #    0.1319D+00, 0.1502D+00, 0.1643D+00, 0.1711D+00, 0.1690D+00,
     #    0.1582D+00, 0.1415D+00, 0.1220D+00, 0.1024D+00, 0.8425D-01,
     #    0.6824D-01, 0.5459D-01, 0.4318D-01, 0.3380D-01, 0.2621D-01,
     #    0.2020D-01, 0.1546D-01, 0.1178D-01, 0.8882D-02, 0.6679D-02,
     #    0.5031D-02, 0.3732D-02, 0.2776D-02, 0.2094D-02, 0.1550D-02,
     #    0.1143D-02, 0.8052D-03, 0.6018D-03, 0.4662D-03, 0.3314D-03,
     #    0.2637D-03, 0.1963D-03, 0.1291D-03, 0.6213D-04, 0.6190D-04,
     #    0.6175D-04, 0.6164D-04, -.5098D-05, -.5147D-05, -.5180D-05,
     #    -.5203D-05/

      data (calcpts(j, 7), j = 1,neta) /0.2822D-03, 0.3418D-03,
     #    0.4146D-03, 0.5024D-03, 0.6083D-03, 0.7374D-03, 0.8933D-03,
     #    0.1082D-02, 0.1311D-02, 0.1589D-02, 0.1925D-02, 0.2335D-02,
     #    0.2825D-02, 0.3422D-02, 0.4147D-02, 0.5028D-02, 0.6098D-02,
     #    0.7392D-02, 0.8962D-02, 0.1087D-01, 0.1319D-01, 0.1602D-01,
     #    0.1947D-01, 0.2368D-01, 0.2883D-01, 0.3514D-01, 0.4287D-01,
     #    0.5234D-01, 0.6386D-01, 0.7775D-01, 0.9403D-01, 0.1124D+00,
     #    0.1318D+00, 0.1501D+00, 0.1642D+00, 0.1711D+00, 0.1689D+00,
     #    0.1581D+00, 0.1414D+00, 0.1220D+00, 0.1024D+00, 0.8422D-01,
     #    0.6822D-01, 0.5457D-01, 0.4315D-01, 0.3378D-01, 0.2626D-01,
     #    0.2024D-01, 0.1544D-01, 0.1176D-01, 0.8925D-02, 0.6722D-02,
     #    0.5008D-02, 0.3775D-02, 0.2820D-02, 0.2071D-02, 0.1527D-02,
     #    0.1120D-02, 0.8487D-03, 0.5787D-03, 0.4431D-03, 0.3083D-03,
     #    0.2405D-03, 0.1732D-03, 0.1060D-03, 0.1057D-03, 0.3878D-04,
     #    0.3863D-04, 0.3852D-04, 0.3845D-04, 0.3840D-04, 0.3837D-04,
     #    0.3835D-04/

      data (calcpts(j, 8), j = 1,neta) /0.2819D-03, 0.3417D-03,
     #    0.4140D-03, 0.5020D-03, 0.6082D-03, 0.7369D-03, 0.8925D-03,
     #    0.1081D-02, 0.1311D-02, 0.1588D-02, 0.1923D-02, 0.2327D-02,
     #    0.2824D-02, 0.3422D-02, 0.4148D-02, 0.5023D-02, 0.6094D-02,
     #    0.7383D-02, 0.8954D-02, 0.1087D-01, 0.1319D-01, 0.1601D-01,
     #    0.1946D-01, 0.2366D-01, 0.2880D-01, 0.3511D-01, 0.4283D-01,
     #    0.5229D-01, 0.6380D-01, 0.7762D-01, 0.9395D-01, 0.1123D+00,
     #    0.1317D+00, 0.1500D+00, 0.1640D+00, 0.1709D+00, 0.1687D+00,
     #    0.1580D+00, 0.1414D+00, 0.1219D+00, 0.1023D+00, 0.8419D-01,
     #    0.6819D-01, 0.5450D-01, 0.4315D-01, 0.3378D-01, 0.2626D-01,
     #    0.2017D-01, 0.1544D-01, 0.1176D-01, 0.8926D-02, 0.6724D-02,
     #    0.5010D-02, 0.3777D-02, 0.2755D-02, 0.2073D-02, 0.1529D-02,
     #    0.1122D-02, 0.8504D-03, 0.5805D-03, 0.4449D-03, 0.3100D-03,
     #    0.2423D-03, 0.1749D-03, 0.1078D-03, 0.1074D-03, 0.4054D-04,
     #    0.4039D-04, 0.4028D-04, 0.4021D-04, 0.4016D-04, 0.4013D-04,
     #    0.4011D-04/

      data (calcpts(j, 9), j = 1,neta) /0.2821D-03, 0.3414D-03,
     #    0.4141D-03, 0.5010D-03, 0.6076D-03, 0.7361D-03, 0.8916D-03,
     #    0.1080D-02, 0.1309D-02, 0.1585D-02, 0.1921D-02, 0.2328D-02,
     #    0.2820D-02, 0.3419D-02, 0.4139D-02, 0.5022D-02, 0.6082D-02,
     #    0.7378D-02, 0.8945D-02, 0.1085D-01, 0.1317D-01, 0.1599D-01,
     #    0.1943D-01, 0.2363D-01, 0.2877D-01, 0.3506D-01, 0.4277D-01,
     #    0.5221D-01, 0.6370D-01, 0.7755D-01, 0.9379D-01, 0.1121D+00,
     #    0.1315D+00, 0.1497D+00, 0.1638D+00, 0.1707D+00, 0.1685D+00,
     #    0.1579D+00, 0.1412D+00, 0.1218D+00, 0.1023D+00, 0.8414D-01,
     #    0.6816D-01, 0.5450D-01, 0.4309D-01, 0.3378D-01, 0.2620D-01,
     #    0.2018D-01, 0.1544D-01, 0.1177D-01, 0.8867D-02, 0.6665D-02,
     #    0.5017D-02, 0.3718D-02, 0.2762D-02, 0.2080D-02, 0.1537D-02,
     #    0.1130D-02, 0.7915D-03, 0.5882D-03, 0.4526D-03, 0.3177D-03,
     #    0.2500D-03, 0.1826D-03, 0.1155D-03, 0.1151D-03, 0.4825D-04,
     #    0.4810D-04, 0.4800D-04, 0.4793D-04, 0.4788D-04, -.1882D-04,
     #    -.1885D-04/

      data (calcpts(j,10), j = 1,neta) /0.2816D-03, 0.3406D-03,
     #    0.4130D-03, 0.5005D-03, 0.6063D-03, 0.7348D-03, 0.8897D-03,
     #    0.1078D-02, 0.1307D-02, 0.1583D-02, 0.1917D-02, 0.2324D-02,
     #    0.2812D-02, 0.3413D-02, 0.4136D-02, 0.5014D-02, 0.6076D-02,
     #    0.7362D-02, 0.8930D-02, 0.1083D-01, 0.1315D-01, 0.1596D-01,
     #    0.1939D-01, 0.2359D-01, 0.2871D-01, 0.3500D-01, 0.4269D-01,
     #    0.5211D-01, 0.6357D-01, 0.7734D-01, 0.9356D-01, 0.1119D+00,
     #    0.1311D+00, 0.1493D+00, 0.1634D+00, 0.1703D+00, 0.1682D+00,
     #    0.1576D+00, 0.1410D+00, 0.1217D+00, 0.1022D+00, 0.8406D-01,
     #    0.6810D-01, 0.5448D-01, 0.4307D-01, 0.3376D-01, 0.2618D-01,
     #    0.2016D-01, 0.1543D-01, 0.1175D-01, 0.8918D-02, 0.6716D-02,
     #    0.5002D-02, 0.3770D-02, 0.2814D-02, 0.2066D-02, 0.1522D-02,
     #    0.1115D-02, 0.8435D-03, 0.5735D-03, 0.4379D-03, 0.3031D-03,
     #    0.2354D-03, 0.1680D-03, 0.1008D-03, 0.1005D-03, 0.3361D-04,
     #    0.3346D-04, 0.3335D-04, 0.3328D-04, 0.3324D-04, 0.3320D-04,
     #    0.3318D-04/

      data (calcpts(j,11), j = 1,neta) /0.2808D-03, 0.3397D-03,
     #    0.4121D-03, 0.4989D-03, 0.6049D-03, 0.7330D-03, 0.8876D-03,
     #    0.1076D-02, 0.1304D-02, 0.1579D-02, 0.1913D-02, 0.2318D-02,
     #    0.2811D-02, 0.3401D-02, 0.4126D-02, 0.5001D-02, 0.6060D-02,
     #    0.7342D-02, 0.8908D-02, 0.1080D-01, 0.1311D-01, 0.1592D-01,
     #    0.1934D-01, 0.2352D-01, 0.2864D-01, 0.3490D-01, 0.4257D-01,
     #    0.5195D-01, 0.6338D-01, 0.7713D-01, 0.9325D-01, 0.1115D+00,
     #    0.1307D+00, 0.1489D+00, 0.1630D+00, 0.1698D+00, 0.1678D+00,
     #    0.1573D+00, 0.1408D+00, 0.1215D+00, 0.1020D+00, 0.8395D-01,
     #    0.6802D-01, 0.5440D-01, 0.4305D-01, 0.3368D-01, 0.2616D-01,
     #    0.2015D-01, 0.1541D-01, 0.1174D-01, 0.8907D-02, 0.6705D-02,
     #    0.4991D-02, 0.3759D-02, 0.2804D-02, 0.2055D-02, 0.1512D-02,
     #    0.1105D-02, 0.8330D-03, 0.6298D-03, 0.4275D-03, 0.2927D-03,
     #    0.2250D-03, 0.1576D-03, 0.9045D-04, 0.9012D-04, 0.8989D-04,
     #    0.2308D-04, 0.2297D-04, 0.2290D-04, 0.2285D-04, 0.2282D-04,
     #    0.2280D-04/

      data (calcpts(j,12), j = 1,neta) /0.2794D-03, 0.3384D-03,
     #    0.4104D-03, 0.4976D-03, 0.6028D-03, 0.7303D-03, 0.8845D-03,
     #    0.1072D-02, 0.1298D-02, 0.1573D-02, 0.1906D-02, 0.2310D-02,
     #    0.2798D-02, 0.3391D-02, 0.4107D-02, 0.4980D-02, 0.6037D-02,
     #    0.7318D-02, 0.8875D-02, 0.1076D-01, 0.1306D-01, 0.1586D-01,
     #    0.1927D-01, 0.2343D-01, 0.2853D-01, 0.3476D-01, 0.4239D-01,
     #    0.5173D-01, 0.6310D-01, 0.7678D-01, 0.9279D-01, 0.1109D+00,
     #    0.1301D+00, 0.1481D+00, 0.1622D+00, 0.1691D+00, 0.1672D+00,
     #    0.1568D+00, 0.1404D+00, 0.1212D+00, 0.1018D+00, 0.8379D-01,
     #    0.6790D-01, 0.5432D-01, 0.4298D-01, 0.3368D-01, 0.2616D-01,
     #    0.2015D-01, 0.1542D-01, 0.1174D-01, 0.8843D-02, 0.6708D-02,
     #    0.4995D-02, 0.3762D-02, 0.2807D-02, 0.2059D-02, 0.1515D-02,
     #    0.1108D-02, 0.8366D-03, 0.6334D-03, 0.4312D-03, 0.2963D-03,
     #    0.2286D-03, 0.1613D-03, 0.9411D-04, 0.9378D-04, 0.9356D-04,
     #    0.2674D-04, 0.2664D-04, 0.2657D-04, 0.2652D-04, 0.2649D-04,
     #    0.2647D-04/

      data (calcpts(j,13), j = 1,neta) /0.2781D-03, 0.3369D-03,
     #    0.4082D-03, 0.4949D-03, 0.5992D-03, 0.7261D-03, 0.8799D-03,
     #    0.1066D-02, 0.1291D-02, 0.1565D-02, 0.1896D-02, 0.2297D-02,
     #    0.2783D-02, 0.3376D-02, 0.4084D-02, 0.4957D-02, 0.6001D-02,
     #    0.7282D-02, 0.8828D-02, 0.1071D-01, 0.1300D-01, 0.1577D-01,
     #    0.1916D-01, 0.2330D-01, 0.2836D-01, 0.3455D-01, 0.4214D-01,
     #    0.5141D-01, 0.6268D-01, 0.7623D-01, 0.9216D-01, 0.1102D+00,
     #    0.1291D+00, 0.1471D+00, 0.1611D+00, 0.1681D+00, 0.1663D+00,
     #    0.1560D+00, 0.1398D+00, 0.1208D+00, 0.1015D+00, 0.8356D-01,
     #    0.6773D-01, 0.5417D-01, 0.4290D-01, 0.3360D-01, 0.2609D-01,
     #    0.2015D-01, 0.1542D-01, 0.1174D-01, 0.8844D-02, 0.6643D-02,
     #    0.4997D-02, 0.3765D-02, 0.2810D-02, 0.2062D-02, 0.1518D-02,
     #    0.1111D-02, 0.8399D-03, 0.6366D-03, 0.4344D-03, 0.2996D-03,
     #    0.2319D-03, 0.1645D-03, 0.9741D-04, 0.9708D-04, 0.9686D-04,
     #    0.3005D-04, 0.2994D-04, 0.2987D-04, 0.2983D-04, 0.2979D-04,
     #    0.2977D-04/

      data (calcpts(j,14), j = 1,neta) /0.2757D-03, 0.3342D-03,
     #    0.4053D-03, 0.4909D-03, 0.5944D-03, 0.7208D-03, 0.8734D-03,
     #    0.1058D-02, 0.1282D-02, 0.1553D-02, 0.1881D-02, 0.2279D-02,
     #    0.2760D-02, 0.3346D-02, 0.4057D-02, 0.4912D-02, 0.5959D-02,
     #    0.7225D-02, 0.8761D-02, 0.1063D-01, 0.1289D-01, 0.1565D-01,
     #    0.1901D-01, 0.2312D-01, 0.2813D-01, 0.3426D-01, 0.4177D-01,
     #    0.5094D-01, 0.6209D-01, 0.7546D-01, 0.9123D-01, 0.1090D+00,
     #    0.1277D+00, 0.1456D+00, 0.1595D+00, 0.1666D+00, 0.1649D+00,
     #    0.1550D+00, 0.1390D+00, 0.1201D+00, 0.1010D+00, 0.8322D-01,
     #    0.6748D-01, 0.5402D-01, 0.4276D-01, 0.3354D-01, 0.2604D-01,
     #    0.2009D-01, 0.1537D-01, 0.1169D-01, 0.8864D-02, 0.6664D-02,
     #    0.5018D-02, 0.3720D-02, 0.2765D-02, 0.2084D-02, 0.1540D-02,
     #    0.1134D-02, 0.7956D-03, 0.5924D-03, 0.4569D-03, 0.3221D-03,
     #    0.2544D-03, 0.1870D-03, 0.1199D-03, 0.1196D-03, 0.5270D-04,
     #    0.5255D-04, 0.5245D-04, 0.5238D-04, -.1433D-04, -.1436D-04,
     #    -.1438D-04/

      data (calcpts(j,15), j = 1,neta) /0.2728D-03, 0.3303D-03,
     #    0.4008D-03, 0.4855D-03, 0.5879D-03, 0.7125D-03, 0.8631D-03,
     #    0.1045D-02, 0.1267D-02, 0.1535D-02, 0.1860D-02, 0.2254D-02,
     #    0.2733D-02, 0.3311D-02, 0.4014D-02, 0.4862D-02, 0.5890D-02,
     #    0.7144D-02, 0.8656D-02, 0.1050D-01, 0.1274D-01, 0.1547D-01,
     #    0.1879D-01, 0.2284D-01, 0.2779D-01, 0.3384D-01, 0.4124D-01,
     #    0.5028D-01, 0.6126D-01, 0.7442D-01, 0.8991D-01, 0.1074D+00,
     #    0.1259D+00, 0.1435D+00, 0.1573D+00, 0.1644D+00, 0.1630D+00,
     #    0.1534D+00, 0.1378D+00, 0.1192D+00, 0.1004D+00, 0.8273D-01,
     #    0.6712D-01, 0.5375D-01, 0.4256D-01, 0.3335D-01, 0.2591D-01,
     #    0.1998D-01, 0.1532D-01, 0.1165D-01, 0.8822D-02, 0.6623D-02,
     #    0.4978D-02, 0.3748D-02, 0.2793D-02, 0.2045D-02, 0.1502D-02,
     #    0.1095D-02, 0.8240D-03, 0.6209D-03, 0.4188D-03, 0.3507D-03,
     #    0.2163D-03, 0.1490D-03, 0.1485D-03, 0.8154D-04, 0.8133D-04,
     #    0.1452D-04, 0.1442D-04, 0.1435D-04, 0.1431D-04, 0.1427D-04,
     #    0.1425D-04/

      data (calcpts(j,16), j = 1,neta) /0.2682D-03, 0.3250D-03,
     #    0.3946D-03, 0.4778D-03, 0.5786D-03, 0.7010D-03, 0.8497D-03,
     #    0.1029D-02, 0.1247D-02, 0.1511D-02, 0.1830D-02, 0.2218D-02,
     #    0.2686D-02, 0.3253D-02, 0.3946D-02, 0.4780D-02, 0.5795D-02,
     #    0.7024D-02, 0.8518D-02, 0.1033D-01, 0.1254D-01, 0.1521D-01,
     #    0.1848D-01, 0.2246D-01, 0.2732D-01, 0.3325D-01, 0.4050D-01,
     #    0.4935D-01, 0.6008D-01, 0.7296D-01, 0.8805D-01, 0.1051D+00,
     #    0.1232D+00, 0.1404D+00, 0.1541D+00, 0.1614D+00, 0.1603D+00,
     #    0.1512D+00, 0.1361D+00, 0.1180D+00, 0.9940D-01, 0.8202D-01,
     #    0.6661D-01, 0.5338D-01, 0.4228D-01, 0.3315D-01, 0.2579D-01,
     #    0.1993D-01, 0.1528D-01, 0.1161D-01, 0.8786D-02, 0.6655D-02,
     #    0.4945D-02, 0.3715D-02, 0.2761D-02, 0.2080D-02, 0.1537D-02,
     #    0.1131D-02, 0.7928D-03, 0.5897D-03, 0.4543D-03, 0.3196D-03,
     #    0.2519D-03, 0.1846D-03, 0.1175D-03, 0.1172D-03, 0.5032D-04,
     #    0.5017D-04, 0.5008D-04, 0.5001D-04, 0.4997D-04, -.1673D-04,
     #    -.1675D-04/

      data (calcpts(j,17), j = 1,neta) /0.2625D-03, 0.3178D-03,
     #    0.3854D-03, 0.4667D-03, 0.5652D-03, 0.6851D-03, 0.8304D-03,
     #    0.1006D-02, 0.1219D-02, 0.1476D-02, 0.1789D-02, 0.2167D-02,
     #    0.2629D-02, 0.3185D-02, 0.3855D-02, 0.4675D-02, 0.5665D-02,
     #    0.6864D-02, 0.8322D-02, 0.1010D-01, 0.1225D-01, 0.1486D-01,
     #    0.1804D-01, 0.2192D-01, 0.2666D-01, 0.3243D-01, 0.3947D-01,
     #    0.4806D-01, 0.5845D-01, 0.7091D-01, 0.8548D-01, 0.1020D+00,
     #    0.1195D+00, 0.1363D+00, 0.1497D+00, 0.1571D+00, 0.1566D+00,
     #    0.1481D+00, 0.1336D+00, 0.1161D+00, 0.9804D-01, 0.8102D-01,
     #    0.6588D-01, 0.5284D-01, 0.4189D-01, 0.3291D-01, 0.2564D-01,
     #    0.1978D-01, 0.1514D-01, 0.1154D-01, 0.8721D-02, 0.6593D-02,
     #    0.4951D-02, 0.3722D-02, 0.2768D-02, 0.2022D-02, 0.1479D-02,
     #    0.1139D-02, 0.8017D-03, 0.5988D-03, 0.4634D-03, 0.3287D-03,
     #    0.2611D-03, 0.1938D-03, 0.1267D-03, 0.5977D-04, 0.5957D-04,
     #    0.5944D-04, 0.5934D-04, -.7387D-05, -.7430D-05, -.7460D-05,
     #    -.7480D-05/

      data (calcpts(j,18), j = 1,neta) /0.2543D-03, 0.3078D-03,
     #    0.3732D-03, 0.4520D-03, 0.5474D-03, 0.6629D-03, 0.8035D-03,
     #    0.9733D-03, 0.1180D-02, 0.1429D-02, 0.1731D-02, 0.2098D-02,
     #    0.2541D-02, 0.3079D-02, 0.3729D-02, 0.4525D-02, 0.5479D-02,
     #    0.6644D-02, 0.8051D-02, 0.9766D-02, 0.1184D-01, 0.1437D-01,
     #    0.1745D-01, 0.2119D-01, 0.2575D-01, 0.3131D-01, 0.3808D-01,
     #    0.4632D-01, 0.5627D-01, 0.6816D-01, 0.8206D-01, 0.9782D-01,
     #    0.1145D+00, 0.1306D+00, 0.1438D+00, 0.1513D+00, 0.1513D+00,
     #    0.1437D+00, 0.1302D+00, 0.1135D+00, 0.9614D-01, 0.7963D-01,
     #    0.6486D-01, 0.5210D-01, 0.4140D-01, 0.3251D-01, 0.2532D-01,
     #    0.1955D-01, 0.1505D-01, 0.1146D-01, 0.8710D-02, 0.6519D-02,
     #    0.4945D-02, 0.3651D-02, 0.2766D-02, 0.2020D-02, 0.1478D-02,
     #    0.1138D-02, 0.8008D-03, 0.5980D-03, 0.4628D-03, 0.3282D-03,
     #    0.2606D-03, 0.1934D-03, 0.1263D-03, 0.5934D-04, 0.5915D-04,
     #    0.5902D-04, 0.5893D-04, -.7793D-05, -.7834D-05, -.7862D-05,
     #    -.7881D-05/

      data (calcpts(j,19), j = 1,neta) /0.2427D-03, 0.2943D-03,
     #    0.3564D-03, 0.4321D-03, 0.5233D-03, 0.6339D-03, 0.7677D-03,
     #    0.9304D-03, 0.1128D-02, 0.1366D-02, 0.1654D-02, 0.2005D-02,
     #    0.2429D-02, 0.2943D-02, 0.3568D-02, 0.4323D-02, 0.5235D-02,
     #    0.6346D-02, 0.7694D-02, 0.9331D-02, 0.1131D-01, 0.1372D-01,
     #    0.1665D-01, 0.2022D-01, 0.2455D-01, 0.2983D-01, 0.3625D-01,
     #    0.4403D-01, 0.5342D-01, 0.6460D-01, 0.7767D-01, 0.9241D-01,
     #    0.1081D+00, 0.1234D+00, 0.1360D+00, 0.1437D+00, 0.1443D+00,
     #    0.1378D+00, 0.1256D+00, 0.1100D+00, 0.9352D-01, 0.7771D-01,
     #    0.6346D-01, 0.5109D-01, 0.4065D-01, 0.3199D-01, 0.2496D-01,
     #    0.1934D-01, 0.1485D-01, 0.1134D-01, 0.8593D-02, 0.6472D-02,
     #    0.4902D-02, 0.3676D-02, 0.2725D-02, 0.2047D-02, 0.1505D-02,
     #    0.1100D-02, 0.8295D-03, 0.6269D-03, 0.4251D-03, 0.2906D-03,
     #    0.2231D-03, 0.1559D-03, 0.8884D-04, 0.8859D-04, 0.8841D-04,
     #    0.2162D-04, 0.2154D-04, 0.2149D-04, 0.2145D-04, 0.2142D-04,
     #    0.2140D-04/

      data (calcpts(j,20), j = 1,neta) /0.2281D-03, 0.2765D-03,
     #    0.3351D-03, 0.4057D-03, 0.4920D-03, 0.5961D-03, 0.7219D-03,
     #    0.8744D-03, 0.1060D-02, 0.1284D-02, 0.1555D-02, 0.1885D-02,
     #    0.2284D-02, 0.2768D-02, 0.3353D-02, 0.4060D-02, 0.4921D-02,
     #    0.5965D-02, 0.7228D-02, 0.8768D-02, 0.1063D-01, 0.1289D-01,
     #    0.1564D-01, 0.1897D-01, 0.2303D-01, 0.2795D-01, 0.3393D-01,
     #    0.4116D-01, 0.4985D-01, 0.6017D-01, 0.7220D-01, 0.8575D-01,
     #    0.1002D+00, 0.1144D+00, 0.1263D+00, 0.1338D+00, 0.1352D+00,
     #    0.1300D+00, 0.1193D+00, 0.1053D+00, 0.8999D-01, 0.7513D-01,
     #    0.6159D-01, 0.4974D-01, 0.3967D-01, 0.3130D-01, 0.2449D-01,
     #    0.1896D-01, 0.1462D-01, 0.1112D-01, 0.8449D-02, 0.6401D-02,
     #    0.4834D-02, 0.3611D-02, 0.2662D-02, 0.1985D-02, 0.1511D-02,
     #    0.1106D-02, 0.7688D-03, 0.5665D-03, 0.4316D-03, 0.2972D-03,
     #    0.2298D-03, 0.1626D-03, 0.9560D-04, 0.9537D-04, 0.2855D-04,
     #    0.2844D-04, 0.2836D-04, 0.2831D-04, 0.2828D-04, 0.2826D-04,
     #    0.2824D-04/

      data (calcpts(j,21), j = 1,neta) /0.2103D-03, 0.2549D-03,
     #    0.3087D-03, 0.3736D-03, 0.4527D-03, 0.5489D-03, 0.6649D-03,
     #    0.8050D-03, 0.9762D-03, 0.1182D-02, 0.1432D-02, 0.1735D-02,
     #    0.2103D-02, 0.2547D-02, 0.3085D-02, 0.3741D-02, 0.4530D-02,
     #    0.5493D-02, 0.6658D-02, 0.8067D-02, 0.9784D-02, 0.1186D-01,
     #    0.1438D-01, 0.1744D-01, 0.2116D-01, 0.2566D-01, 0.3112D-01,
     #    0.3769D-01, 0.4558D-01, 0.5491D-01, 0.6575D-01, 0.7794D-01,
     #    0.9094D-01, 0.1037D+00, 0.1147D+00, 0.1220D+00, 0.1241D+00,
     #    0.1202D+00, 0.1113D+00, 0.9908D-01, 0.8539D-01, 0.7177D-01,
     #    0.5916D-01, 0.4799D-01, 0.3842D-01, 0.3041D-01, 0.2384D-01,
     #    0.1852D-01, 0.1426D-01, 0.1091D-01, 0.8312D-02, 0.6336D-02,
     #    0.4774D-02, 0.3554D-02, 0.2674D-02, 0.1998D-02, 0.1458D-02,
     #    0.1120D-02, 0.7841D-03, 0.5821D-03, 0.4474D-03, 0.3131D-03,
     #    0.2458D-03, 0.1787D-03, 0.1117D-03, 0.1115D-03, 0.4471D-04,
     #    0.4462D-04, 0.4455D-04, 0.4451D-04, 0.4448D-04, 0.4446D-04,
     #    0.4445D-04/

      data (calcpts(j,22), j = 1,neta) /0.1892D-03, 0.2287D-03,
     #    0.2776D-03, 0.3361D-03, 0.4075D-03, 0.4932D-03, 0.5976D-03,
     #    0.7242D-03, 0.8775D-03, 0.1063D-02, 0.1288D-02, 0.1560D-02,
     #    0.1890D-02, 0.2291D-02, 0.2775D-02, 0.3362D-02, 0.4075D-02,
     #    0.4940D-02, 0.5984D-02, 0.7251D-02, 0.8790D-02, 0.1066D-01,
     #    0.1292D-01, 0.1566D-01, 0.1898D-01, 0.2301D-01, 0.2788D-01,
     #    0.3373D-01, 0.4073D-01, 0.4899D-01, 0.5855D-01, 0.6927D-01,
     #    0.8071D-01, 0.9201D-01, 0.1019D+00, 0.1087D+00, 0.1111D+00,
     #    0.1086D+00, 0.1016D+00, 0.9138D-01, 0.7959D-01, 0.6752D-01,
     #    0.5609D-01, 0.4579D-01, 0.3685D-01, 0.2929D-01, 0.2304D-01,
     #    0.1796D-01, 0.1389D-01, 0.1066D-01, 0.8130D-02, 0.6135D-02,
     #    0.4644D-02, 0.3495D-02, 0.2617D-02, 0.1942D-02, 0.1470D-02,
     #    0.1067D-02, 0.7975D-03, 0.5958D-03, 0.3947D-03, 0.3272D-03,
     #    0.2600D-03, 0.1930D-03, 0.1261D-03, 0.5924D-04, 0.5913D-04,
     #    0.5905D-04, 0.5900D-04, 0.5896D-04, -.7732D-05, -.7749D-05,
     #    -.7760D-05/

      data (calcpts(j,23), j = 1,neta) /0.1655D-03, 0.2005D-03,
     #    0.2427D-03, 0.2942D-03, 0.3569D-03, 0.4318D-03, 0.5232D-03,
     #    0.6342D-03, 0.7686D-03, 0.9306D-03, 0.1128D-02, 0.1366D-02,
     #    0.1655D-02, 0.2006D-02, 0.2430D-02, 0.2944D-02, 0.3566D-02,
     #    0.4324D-02, 0.5236D-02, 0.6346D-02, 0.7697D-02, 0.9327D-02,
     #    0.1130D-01, 0.1370D-01, 0.1660D-01, 0.2012D-01, 0.2435D-01,
     #    0.2944D-01, 0.3551D-01, 0.4267D-01, 0.5093D-01, 0.6019D-01,
     #    0.7004D-01, 0.7982D-01, 0.8841D-01, 0.9454D-01, 0.9712D-01,
     #    0.9561D-01, 0.9035D-01, 0.8227D-01, 0.7258D-01, 0.6234D-01,
     #    0.5234D-01, 0.4311D-01, 0.3494D-01, 0.2794D-01, 0.2208D-01,
     #    0.1727D-01, 0.1340D-01, 0.1032D-01, 0.7891D-02, 0.6003D-02,
     #    0.4538D-02, 0.3418D-02, 0.2556D-02, 0.1909D-02, 0.1419D-02,
     #    0.1049D-02, 0.7738D-03, 0.5724D-03, 0.4115D-03, 0.3043D-03,
     #    0.2172D-03, 0.1635D-03, 0.1167D-03, 0.8322D-04, 0.5646D-04,
     #    0.4307D-04, 0.2969D-04, 0.2300D-04, 0.1631D-04, 0.9633D-05,
     #    0.2957D-05/

      data (calcpts(j,24), j = 1,neta) /0.1409D-03, 0.1707D-03,
     #    0.2069D-03, 0.2508D-03, 0.3035D-03, 0.3675D-03, 0.4456D-03,
     #    0.5401D-03, 0.6543D-03, 0.7925D-03, 0.9600D-03, 0.1164D-02,
     #    0.1410D-02, 0.1708D-02, 0.2069D-02, 0.2507D-02, 0.3038D-02,
     #    0.3684D-02, 0.4462D-02, 0.5404D-02, 0.6550D-02, 0.7939D-02,
     #    0.9619D-02, 0.1166D-01, 0.1413D-01, 0.1711D-01, 0.2072D-01,
     #    0.2504D-01, 0.3019D-01, 0.3626D-01, 0.4327D-01, 0.5112D-01,
     #    0.5950D-01, 0.6782D-01, 0.7521D-01, 0.8060D-01, 0.8310D-01,
     #    0.8228D-01, 0.7840D-01, 0.7221D-01, 0.6458D-01, 0.5629D-01,
     #    0.4793D-01, 0.3996D-01, 0.3271D-01, 0.2636D-01, 0.2096D-01,
     #    0.1649D-01, 0.1285D-01, 0.9932D-02, 0.7623D-02, 0.5816D-02,
     #    0.4408D-02, 0.3325D-02, 0.2498D-02, 0.1867D-02, 0.1391D-02,
     #    0.1029D-02, 0.7605D-03, 0.5595D-03, 0.4122D-03, 0.3051D-03,
     #    0.2181D-03, 0.1579D-03, 0.1177D-03, 0.8429D-04, 0.6423D-04,
     #    0.4418D-04, 0.3082D-04, 0.2413D-04, 0.1745D-04, 0.1077D-04,
     #    0.1076D-04/

      data (calcpts(j,25), j = 1,neta) /0.1168D-03, 0.1415D-03,
     #    0.1715D-03, 0.2077D-03, 0.2514D-03, 0.3048D-03, 0.3695D-03,
     #    0.4475D-03, 0.5420D-03, 0.6569D-03, 0.7959D-03, 0.9642D-03,
     #    0.1169D-02, 0.1415D-02, 0.1715D-02, 0.2078D-02, 0.2518D-02,
     #    0.3051D-02, 0.3697D-02, 0.4481D-02, 0.5431D-02, 0.6581D-02,
     #    0.7974D-02, 0.9667D-02, 0.1171D-01, 0.1419D-01, 0.1717D-01,
     #    0.2076D-01, 0.2503D-01, 0.3008D-01, 0.3591D-01, 0.4247D-01,
     #    0.4949D-01, 0.5653D-01, 0.6285D-01, 0.6757D-01, 0.6993D-01,
     #    0.6954D-01, 0.6664D-01, 0.6189D-01, 0.5601D-01, 0.4956D-01,
     #    0.4291D-01, 0.3634D-01, 0.3015D-01, 0.2456D-01, 0.1970D-01,
     #    0.1560D-01, 0.1222D-01, 0.9487D-02, 0.7313D-02, 0.5599D-02,
     #    0.4256D-02, 0.3222D-02, 0.2424D-02, 0.1814D-02, 0.1359D-02,
     #    0.1011D-02, 0.7496D-03, 0.5489D-03, 0.4018D-03, 0.2948D-03,
     #    0.2146D-03, 0.1611D-03, 0.1143D-03, 0.8092D-04, 0.6087D-04,
     #    0.4084D-04, 0.3415D-04, 0.2080D-04, 0.1413D-04, 0.1412D-04,
     #    0.7449D-05/

      data (calcpts(j,26), j = 1,neta) /0.9441D-04, 0.1144D-03,
     #    0.1386D-03, 0.1679D-03, 0.2035D-03, 0.2465D-03, 0.2988D-03,
     #    0.3618D-03, 0.4387D-03, 0.5310D-03, 0.6434D-03, 0.7796D-03,
     #    0.9444D-03, 0.1144D-02, 0.1386D-02, 0.1680D-02, 0.2035D-02,
     #    0.2466D-02, 0.2989D-02, 0.3622D-02, 0.4389D-02, 0.5322D-02,
     #    0.6448D-02, 0.7811D-02, 0.9470D-02, 0.1148D-01, 0.1389D-01,
     #    0.1680D-01, 0.2027D-01, 0.2438D-01, 0.2914D-01, 0.3452D-01,
     #    0.4033D-01, 0.4624D-01, 0.5164D-01, 0.5581D-01, 0.5808D-01,
     #    0.5806D-01, 0.5589D-01, 0.5214D-01, 0.4753D-01, 0.4257D-01,
     #    0.3746D-01, 0.3231D-01, 0.2728D-01, 0.2255D-01, 0.1829D-01,
     #    0.1461D-01, 0.1153D-01, 0.8999D-02, 0.6966D-02, 0.5350D-02,
     #    0.4084D-02, 0.3099D-02, 0.2343D-02, 0.1761D-02, 0.1313D-02,
     #    0.9785D-03, 0.7245D-03, 0.5374D-03, 0.3904D-03, 0.2902D-03,
     #    0.2101D-03, 0.1567D-03, 0.1099D-03, 0.7655D-04, 0.5652D-04,
     #    0.4316D-04, 0.2982D-04, 0.1647D-04, 0.1647D-04, 0.9795D-05,
     #    0.3125D-05/

      data (calcpts(j,27), j = 1,neta) /0.7459D-04, 0.9038D-04,
     #    0.1096D-03, 0.1328D-03, 0.1608D-03, 0.1948D-03, 0.2361D-03,
     #    0.2860D-03, 0.3463D-03, 0.4201D-03, 0.5086D-03, 0.6162D-03,
     #    0.7467D-03, 0.9047D-03, 0.1096D-02, 0.1328D-02, 0.1609D-02,
     #    0.1950D-02, 0.2363D-02, 0.2863D-02, 0.3470D-02, 0.4206D-02,
     #    0.5098D-02, 0.6182D-02, 0.7492D-02, 0.9074D-02, 0.1099D-01,
     #    0.1330D-01, 0.1607D-01, 0.1933D-01, 0.2315D-01, 0.2749D-01,
     #    0.3223D-01, 0.3712D-01, 0.4171D-01, 0.4543D-01, 0.4767D-01,
     #    0.4805D-01, 0.4654D-01, 0.4356D-01, 0.3980D-01, 0.3583D-01,
     #    0.3191D-01, 0.2802D-01, 0.2413D-01, 0.2032D-01, 0.1674D-01,
     #    0.1353D-01, 0.1078D-01, 0.8474D-02, 0.6599D-02, 0.5100D-02,
     #    0.3910D-02, 0.2980D-02, 0.2259D-02, 0.1704D-02, 0.1277D-02,
     #    0.9560D-03, 0.7089D-03, 0.5286D-03, 0.3884D-03, 0.2883D-03,
     #    0.2149D-03, 0.1548D-03, 0.1148D-03, 0.8145D-04, 0.6143D-04,
     #    0.4808D-04, 0.3474D-04, 0.2807D-04, 0.2140D-04, 0.1473D-04,
     #    0.1472D-04/

      data (calcpts(j,28), j = 1,neta) /0.5791D-04, 0.7018D-04,
     #    0.8503D-04, 0.1030D-03, 0.1248D-03, 0.1512D-03, 0.1832D-03,
     #    0.2219D-03, 0.2689D-03, 0.3258D-03, 0.3947D-03, 0.4780D-03,
     #    0.5794D-03, 0.7018D-03, 0.8505D-03, 0.1030D-02, 0.1249D-02,
     #    0.1513D-02, 0.1834D-02, 0.2222D-02, 0.2693D-02, 0.3264D-02,
     #    0.3956D-02, 0.4796D-02, 0.5814D-02, 0.7043D-02, 0.8538D-02,
     #    0.1034D-01, 0.1248D-01, 0.1505D-01, 0.1805D-01, 0.2148D-01,
     #    0.2527D-01, 0.2925D-01, 0.3310D-01, 0.3637D-01, 0.3858D-01,
     #    0.3935D-01, 0.3852D-01, 0.3628D-01, 0.3320D-01, 0.2986D-01,
     #    0.2667D-01, 0.2369D-01, 0.2079D-01, 0.1789D-01, 0.1503D-01,
     #    0.1235D-01, 0.9957D-02, 0.7905D-02, 0.6194D-02, 0.4811D-02,
     #    0.3709D-02, 0.2841D-02, 0.2160D-02, 0.1633D-02, 0.1232D-02,
     #    0.9185D-03, 0.6850D-03, 0.5115D-03, 0.3781D-03, 0.2780D-03,
     #    0.2046D-03, 0.1512D-03, 0.1112D-03, 0.7787D-04, 0.5786D-04,
     #    0.4452D-04, 0.3119D-04, 0.2452D-04, 0.1785D-04, 0.1118D-04,
     #    0.1118D-04/

      data (calcpts(j,29), j = 1,neta) /0.4422D-04, 0.5359D-04,
     #    0.6494D-04, 0.7870D-04, 0.9534D-04, 0.1155D-03, 0.1400D-03,
     #    0.1695D-03, 0.2054D-03, 0.2489D-03, 0.3015D-03, 0.3653D-03,
     #    0.4423D-03, 0.5363D-03, 0.6496D-03, 0.7869D-03, 0.9536D-03,
     #    0.1156D-02, 0.1400D-02, 0.1697D-02, 0.2057D-02, 0.2493D-02,
     #    0.3022D-02, 0.3664D-02, 0.4441D-02, 0.5384D-02, 0.6524D-02,
     #    0.7899D-02, 0.9553D-02, 0.1153D-01, 0.1384D-01, 0.1651D-01,
     #    0.1948D-01, 0.2266D-01, 0.2581D-01, 0.2862D-01, 0.3073D-01,
     #    0.3179D-01, 0.3158D-01, 0.3012D-01, 0.2772D-01, 0.2490D-01,
     #    0.2214D-01, 0.1968D-01, 0.1747D-01, 0.1533D-01, 0.1318D-01,
     #    0.1106D-01, 0.9063D-02, 0.7286D-02, 0.5765D-02, 0.4510D-02,
     #    0.3496D-02, 0.2688D-02, 0.2055D-02, 0.1561D-02, 0.1174D-02,
     #    0.8874D-03, 0.6607D-03, 0.4939D-03, 0.3672D-03, 0.2672D-03,
     #    0.2005D-03, 0.1472D-03, 0.1071D-03, 0.7381D-04, 0.5380D-04,
     #    0.4047D-04, 0.2713D-04, 0.2046D-04, 0.1379D-04, 0.7127D-05,
     #    0.7127D-05/

      data (calcpts(j,30), j = 1,neta) /0.3339D-04, 0.4040D-04,
     #    0.4896D-04, 0.5931D-04, 0.7186D-04, 0.8708D-04, 0.1055D-03,
     #    0.1279D-03, 0.1549D-03, 0.1876D-03, 0.2273D-03, 0.2755D-03,
     #    0.3337D-03, 0.4043D-03, 0.4899D-03, 0.5933D-03, 0.7195D-03,
     #    0.8717D-03, 0.1056D-02, 0.1280D-02, 0.1551D-02, 0.1880D-02,
     #    0.2279D-02, 0.2763D-02, 0.3350D-02, 0.4061D-02, 0.4922D-02,
     #    0.5962D-02, 0.7212D-02, 0.8703D-02, 0.1047D-01, 0.1251D-01,
     #    0.1481D-01, 0.1729D-01, 0.1981D-01, 0.2216D-01, 0.2408D-01,
     #    0.2527D-01, 0.2553D-01, 0.2477D-01, 0.2311D-01, 0.2086D-01,
     #    0.1846D-01, 0.1628D-01, 0.1443D-01, 0.1281D-01, 0.1125D-01,
     #    0.9669D-02, 0.8097D-02, 0.6622D-02, 0.5310D-02, 0.4192D-02,
     #    0.3272D-02, 0.2532D-02, 0.1945D-02, 0.1485D-02, 0.1125D-02,
     #    0.8448D-03, 0.6381D-03, 0.4781D-03, 0.3514D-03, 0.2648D-03,
     #    0.1914D-03, 0.1448D-03, 0.1048D-03, 0.7809D-04, 0.5809D-04,
     #    0.3809D-04, 0.3142D-04, 0.1809D-04, 0.1809D-04, 0.1142D-04,
     #    0.4756D-05/

      data (calcpts(j,31), j = 1,neta) /0.2490D-04, 0.3016D-04,
     #    0.3654D-04, 0.4428D-04, 0.5367D-04, 0.6502D-04, 0.7877D-04,
     #    0.9543D-04, 0.1156D-03, 0.1401D-03, 0.1697D-03, 0.2056D-03,
     #    0.2490D-03, 0.3017D-03, 0.3656D-03, 0.4430D-03, 0.5366D-03,
     #    0.6505D-03, 0.7880D-03, 0.9552D-03, 0.1158D-02, 0.1403D-02,
     #    0.1701D-02, 0.2062D-02, 0.2499D-02, 0.3031D-02, 0.3673D-02,
     #    0.4450D-02, 0.5386D-02, 0.6504D-02, 0.7828D-02, 0.9372D-02,
     #    0.1112D-01, 0.1302D-01, 0.1501D-01, 0.1691D-01, 0.1855D-01,
     #    0.1974D-01, 0.2028D-01, 0.2007D-01, 0.1909D-01, 0.1747D-01,
     #    0.1552D-01, 0.1357D-01, 0.1189D-01, 0.1053D-01, 0.9356D-02,
     #    0.8220D-02, 0.7059D-02, 0.5903D-02, 0.4817D-02, 0.3855D-02,
     #    0.3039D-02, 0.2368D-02, 0.1827D-02, 0.1400D-02, 0.1067D-02,
     #    0.8068D-03, 0.6068D-03, 0.4535D-03, 0.3402D-03, 0.2535D-03,
     #    0.1869D-03, 0.1402D-03, 0.1002D-03, 0.7354D-04, 0.5354D-04,
     #    0.4021D-04, 0.2687D-04, 0.2021D-04, 0.1354D-04, 0.1354D-04,
     #    0.6874D-05/

      data (calcpts(j,32), j = 1,neta) /0.1842D-04, 0.2232D-04,
     #    0.2705D-04, 0.3277D-04, 0.3967D-04, 0.4809D-04, 0.5828D-04,
     #    0.7059D-04, 0.8552D-04, 0.1036D-03, 0.1255D-03, 0.1521D-03,
     #    0.1842D-03, 0.2232D-03, 0.2705D-03, 0.3277D-03, 0.3971D-03,
     #    0.4812D-03, 0.5832D-03, 0.7063D-03, 0.8566D-03, 0.1038D-02,
     #    0.1258D-02, 0.1525D-02, 0.1849D-02, 0.2242D-02, 0.2717D-02,
     #    0.3293D-02, 0.3986D-02, 0.4815D-02, 0.5799D-02, 0.6949D-02,
     #    0.8259D-02, 0.9705D-02, 0.1123D-01, 0.1273D-01, 0.1409D-01,
     #    0.1517D-01, 0.1583D-01, 0.1597D-01, 0.1551D-01, 0.1450D-01,
     #    0.1306D-01, 0.1144D-01, 0.9914D-02, 0.8646D-02, 0.7648D-02,
     #    0.6802D-02, 0.5979D-02, 0.5131D-02, 0.4284D-02, 0.3490D-02,
     #    0.2787D-02, 0.2193D-02, 0.1706D-02, 0.1315D-02, 0.1007D-02,
     #    0.7654D-03, 0.5787D-03, 0.4354D-03, 0.3261D-03, 0.2428D-03,
     #    0.1801D-03, 0.1328D-03, 0.9812D-04, 0.7146D-04, 0.5213D-04,
     #    0.3813D-04, 0.2746D-04, 0.1946D-04, 0.1413D-04, 0.1013D-04,
     #    0.6796D-05/

      data (calcpts(j,33), j = 1,neta) /0.1353D-04, 0.1639D-04,
     #    0.1986D-04, 0.2406D-04, 0.2915D-04, 0.3532D-04, 0.4280D-04,
     #    0.5186D-04, 0.6284D-04, 0.7611D-04, 0.9222D-04, 0.1117D-03,
     #    0.1353D-03, 0.1640D-03, 0.1987D-03, 0.2407D-03, 0.2917D-03,
     #    0.3535D-03, 0.4283D-03, 0.5190D-03, 0.6291D-03, 0.7624D-03,
     #    0.9242D-03, 0.1120D-02, 0.1359D-02, 0.1647D-02, 0.1996D-02,
     #    0.2419D-02, 0.2929D-02, 0.3539D-02, 0.4264D-02, 0.5114D-02,
     #    0.6087D-02, 0.7170D-02, 0.8324D-02, 0.9486D-02, 0.1058D-01,
     #    0.1150D-01, 0.1216D-01, 0.1247D-01, 0.1237D-01, 0.1182D-01,
     #    0.1089D-01, 0.9674D-02, 0.8381D-02, 0.7203D-02, 0.6260D-02,
     #    0.5537D-02, 0.4928D-02, 0.4334D-02, 0.3718D-02, 0.3101D-02,
     #    0.2522D-02, 0.2011D-02, 0.1580D-02, 0.1228D-02, 0.9457D-03,
     #    0.7231D-03, 0.5498D-03, 0.4151D-03, 0.3125D-03, 0.2338D-03,
     #    0.1745D-03, 0.1299D-03, 0.9586D-04, 0.7119D-04, 0.5253D-04,
     #    0.3853D-04, 0.2853D-04, 0.2053D-04, 0.1520D-04, 0.1120D-04,
     #    0.8532D-05/

      data (calcpts(j,34), j = 1,neta) /0.9884D-05, 0.1197D-04,
     #    0.1451D-04, 0.1758D-04, 0.2129D-04, 0.2579D-04, 0.3125D-04,
     #    0.3787D-04, 0.4585D-04, 0.5560D-04, 0.6733D-04, 0.8161D-04,
     #    0.9883D-04, 0.1198D-03, 0.1451D-03, 0.1758D-03, 0.2130D-03,
     #    0.2581D-03, 0.3128D-03, 0.3790D-03, 0.4594D-03, 0.5567D-03,
     #    0.6748D-03, 0.8180D-03, 0.9920D-03, 0.1203D-02, 0.1457D-02,
     #    0.1766D-02, 0.2138D-02, 0.2585D-02, 0.3116D-02, 0.3739D-02,
     #    0.4456D-02, 0.5258D-02, 0.6121D-02, 0.7005D-02, 0.7857D-02,
     #    0.8612D-02, 0.9205D-02, 0.9575D-02, 0.9668D-02, 0.9447D-02,
     #    0.8908D-02, 0.8095D-02, 0.7109D-02, 0.6099D-02, 0.5209D-02,
     #    0.4514D-02, 0.3993D-02, 0.3557D-02, 0.3130D-02, 0.2683D-02,
     #    0.2236D-02, 0.1816D-02, 0.1445D-02, 0.1134D-02, 0.8796D-03,
     #    0.6770D-03, 0.5170D-03, 0.3924D-03, 0.2930D-03, 0.2224D-03,
     #    0.1664D-03, 0.1237D-03, 0.9174D-04, 0.6774D-04, 0.4974D-04,
     #    0.3641D-04, 0.2708D-04, 0.1974D-04, 0.1441D-04, 0.1041D-04,
     #    0.7744D-05/

      data (calcpts(j,35), j = 1,neta) /0.7181D-05, 0.8703D-05,
     #    0.1054D-04, 0.1277D-04, 0.1548D-04, 0.1875D-04, 0.2272D-04,
     #    0.2752D-04, 0.3334D-04, 0.4039D-04, 0.4895D-04, 0.5928D-04,
     #    0.7186D-04, 0.8704D-04, 0.1055D-03, 0.1278D-03, 0.1548D-03,
     #    0.1876D-03, 0.2273D-03, 0.2754D-03, 0.3338D-03, 0.4046D-03,
     #    0.4904D-03, 0.5944D-03, 0.7209D-03, 0.8739D-03, 0.1059D-02,
     #    0.1283D-02, 0.1554D-02, 0.1878D-02, 0.2265D-02, 0.2719D-02,
     #    0.3243D-02, 0.3833D-02, 0.4472D-02, 0.5136D-02, 0.5787D-02,
     #    0.6385D-02, 0.6885D-02, 0.7246D-02, 0.7428D-02, 0.7396D-02,
     #    0.7134D-02, 0.6646D-02, 0.5971D-02, 0.5191D-02, 0.4417D-02,
     #    0.3752D-02, 0.3245D-02, 0.2871D-02, 0.2560D-02, 0.2253D-02,
     #    0.1931D-02, 0.1607D-02, 0.1303D-02, 0.1036D-02, 0.8116D-03,
     #    0.6290D-03, 0.4830D-03, 0.3684D-03, 0.2791D-03, 0.2104D-03,
     #    0.1578D-03, 0.1178D-03, 0.8778D-04, 0.6511D-04, 0.4778D-04,
     #    0.3512D-04, 0.2578D-04, 0.1845D-04, 0.1378D-04, 0.9784D-05,
     #    0.7117D-05/

      data (calcpts(j,36), j = 1,neta) /0.5199D-05, 0.6298D-05,
     #    0.7628D-05, 0.9240D-05, 0.1120D-04, 0.1356D-04, 0.1644D-04,
     #    0.1991D-04, 0.2413D-04, 0.2923D-04, 0.3541D-04, 0.4290D-04,
     #    0.5199D-04, 0.6297D-04, 0.7629D-04, 0.9246D-04, 0.1120D-03,
     #    0.1357D-03, 0.1645D-03, 0.1993D-03, 0.2415D-03, 0.2927D-03,
     #    0.3548D-03, 0.4301D-03, 0.5213D-03, 0.6320D-03, 0.7660D-03,
     #    0.9282D-03, 0.1124D-02, 0.1359D-02, 0.1639D-02, 0.1969D-02,
     #    0.2350D-02, 0.2780D-02, 0.3250D-02, 0.3743D-02, 0.4234D-02,
     #    0.4697D-02, 0.5101D-02, 0.5419D-02, 0.5623D-02, 0.5688D-02,
     #    0.5595D-02, 0.5336D-02, 0.4918D-02, 0.4375D-02, 0.3771D-02,
     #    0.3185D-02, 0.2694D-02, 0.2326D-02, 0.2059D-02, 0.1837D-02,
     #    0.1617D-02, 0.1386D-02, 0.1152D-02, 0.9331D-03, 0.7411D-03,
     #    0.5799D-03, 0.4492D-03, 0.3446D-03, 0.2626D-03, 0.1993D-03,
     #    0.1499D-03, 0.1126D-03, 0.8394D-04, 0.6261D-04, 0.4595D-04,
     #    0.3395D-04, 0.2528D-04, 0.1795D-04, 0.1328D-04, 0.9951D-05,
     #    0.7284D-05/

      data (calcpts(j,37), j = 1,neta) /0.3747D-05, 0.4542D-05,
     #    0.5498D-05, 0.6662D-05, 0.8071D-05, 0.9782D-05, 0.1185D-04,
     #    0.1435D-04, 0.1739D-04, 0.2107D-04, 0.2553D-04, 0.3093D-04,
     #    0.3748D-04, 0.4540D-04, 0.5502D-04, 0.6667D-04, 0.8072D-04,
     #    0.9783D-04, 0.1185D-03, 0.1437D-03, 0.1741D-03, 0.2110D-03,
     #    0.2558D-03, 0.3100D-03, 0.3758D-03, 0.4556D-03, 0.5522D-03,
     #    0.6690D-03, 0.8100D-03, 0.9794D-03, 0.1181D-02, 0.1419D-02,
     #    0.1695D-02, 0.2008D-02, 0.2351D-02, 0.2714D-02, 0.3080D-02,
     #    0.3432D-02, 0.3749D-02, 0.4013D-02, 0.4205D-02, 0.4308D-02,
     #    0.4308D-02, 0.4192D-02, 0.3958D-02, 0.3614D-02, 0.3188D-02,
     #    0.2726D-02, 0.2289D-02, 0.1928D-02, 0.1663D-02, 0.1473D-02,
     #    0.1315D-02, 0.1158D-02, 0.9917D-03, 0.8239D-03, 0.6665D-03,
     #    0.5292D-03, 0.4132D-03, 0.3199D-03, 0.2452D-03, 0.1865D-03,
     #    0.1412D-03, 0.1066D-03, 0.7989D-04, 0.5923D-04, 0.4389D-04,
     #    0.3256D-04, 0.2389D-04, 0.1723D-04, 0.1323D-04, 0.9229D-05,
     #    0.6563D-05/

      data (calcpts(j,38), j = 1,neta) /0.2693D-05, 0.3262D-05,
     #    0.3953D-05, 0.4790D-05, 0.5801D-05, 0.7032D-05, 0.8515D-05,
     #    0.1032D-04, 0.1250D-04, 0.1514D-04, 0.1835D-04, 0.2223D-04,
     #    0.2693D-04, 0.3263D-04, 0.3954D-04, 0.4790D-04, 0.5803D-04,
     #    0.7034D-04, 0.8521D-04, 0.1033D-03, 0.1251D-03, 0.1516D-03,
     #    0.1838D-03, 0.2228D-03, 0.2700D-03, 0.3273D-03, 0.3967D-03,
     #    0.4807D-03, 0.5819D-03, 0.7036D-03, 0.8488D-03, 0.1020D-02,
     #    0.1219D-02, 0.1445D-02, 0.1694D-02, 0.1960D-02, 0.2230D-02,
     #    0.2494D-02, 0.2738D-02, 0.2949D-02, 0.3115D-02, 0.3224D-02,
     #    0.3266D-02, 0.3231D-02, 0.3114D-02, 0.2915D-02, 0.2640D-02,
     #    0.2311D-02, 0.1963D-02, 0.1640D-02, 0.1377D-02, 0.1186D-02,
     #    0.1051D-02, 0.9394D-03, 0.8273D-03, 0.7081D-03, 0.5877D-03,
     #    0.4752D-03, 0.3766D-03, 0.2938D-03, 0.2271D-03, 0.1738D-03,
     #    0.1325D-03, 0.9981D-04, 0.7515D-04, 0.5648D-04, 0.4182D-04,
     #    0.3115D-04, 0.2315D-04, 0.1648D-04, 0.1248D-04, 0.9150D-05,
     #    0.6484D-05/

      data (calcpts(j,39), j = 1,neta) /0.1929D-05, 0.2338D-05,
     #    0.2832D-05, 0.3431D-05, 0.4157D-05, 0.5039D-05, 0.6100D-05,
     #    0.7390D-05, 0.8955D-05, 0.1085D-04, 0.1314D-04, 0.1593D-04,
     #    0.1930D-04, 0.2338D-04, 0.2833D-04, 0.3433D-04, 0.4159D-04,
     #    0.5039D-04, 0.6106D-04, 0.7396D-04, 0.8967D-04, 0.1087D-03,
     #    0.1317D-03, 0.1596D-03, 0.1935D-03, 0.2345D-03, 0.2842D-03,
     #    0.3443D-03, 0.4170D-03, 0.5041D-03, 0.6082D-03, 0.7312D-03,
     #    0.8742D-03, 0.1037D-02, 0.1217D-02, 0.1410D-02, 0.1608D-02,
     #    0.1804D-02, 0.1989D-02, 0.2153D-02, 0.2288D-02, 0.2388D-02,
     #    0.2445D-02, 0.2452D-02, 0.2404D-02, 0.2298D-02, 0.2134D-02,
     #    0.1919D-02, 0.1669D-02, 0.1410D-02, 0.1172D-02, 0.9811D-03,
     #    0.8447D-03, 0.7488D-03, 0.6697D-03, 0.5899D-03, 0.5048D-03,
     #    0.4188D-03, 0.3383D-03, 0.2679D-03, 0.2091D-03, 0.1614D-03,
     #    0.1236D-03, 0.9402D-04, 0.7108D-04, 0.5349D-04, 0.3989D-04,
     #    0.2989D-04, 0.2189D-04, 0.1655D-04, 0.1189D-04, 0.9221D-05,
     #    0.6554D-05/

      data (calcpts(j,40), j = 1,neta) /0.1379D-05, 0.1671D-05,
     #    0.2025D-05, 0.2453D-05, 0.2972D-05, 0.3600D-05, 0.4362D-05,
     #    0.5285D-05, 0.6401D-05, 0.7759D-05, 0.9399D-05, 0.1138D-04,
     #    0.1380D-04, 0.1671D-04, 0.2025D-04, 0.2454D-04, 0.2973D-04,
     #    0.3602D-04, 0.4364D-04, 0.5288D-04, 0.6408D-04, 0.7768D-04,
     #    0.9415D-04, 0.1141D-03, 0.1382D-03, 0.1676D-03, 0.2031D-03,
     #    0.2461D-03, 0.2980D-03, 0.3602D-03, 0.4347D-03, 0.5226D-03,
     #    0.6251D-03, 0.7419D-03, 0.8716D-03, 0.1011D-02, 0.1155D-02,
     #    0.1300D-02, 0.1438D-02, 0.1563D-02, 0.1670D-02, 0.1755D-02,
     #    0.1812D-02, 0.1837D-02, 0.1825D-02, 0.1775D-02, 0.1685D-02,
     #    0.1554D-02, 0.1389D-02, 0.1201D-02, 0.1009D-02, 0.8352D-03,
     #    0.6976D-03, 0.6001D-03, 0.5322D-03, 0.4763D-03, 0.4197D-03,
     #    0.3590D-03, 0.2976D-03, 0.2402D-03, 0.1901D-03, 0.1482D-03,
     #    0.1143D-03, 0.8746D-04, 0.6646D-04, 0.5026D-04, 0.3773D-04,
     #    0.2826D-04, 0.2106D-04, 0.1546D-04, 0.1153D-04, 0.8464D-05,
     #    0.6264D-05/

      data (calcpts(j,41), j = 1,neta) /0.9836D-06, 0.1192D-05,
     #    0.1444D-05, 0.1750D-05, 0.2120D-05, 0.2568D-05, 0.3111D-05,
     #    0.3769D-05, 0.4567D-05, 0.5531D-05, 0.6704D-05, 0.8123D-05,
     #    0.9839D-05, 0.1192D-04, 0.1444D-04, 0.1750D-04, 0.2120D-04,
     #    0.2569D-04, 0.3113D-04, 0.3772D-04, 0.4570D-04, 0.5539D-04,
     #    0.6713D-04, 0.8134D-04, 0.9861D-04, 0.1195D-03, 0.1449D-03,
     #    0.1754D-03, 0.2125D-03, 0.2569D-03, 0.3099D-03, 0.3727D-03,
     #    0.4459D-03, 0.5295D-03, 0.6227D-03, 0.7233D-03, 0.8281D-03,
     #    0.9335D-03, 0.1036D-02, 0.1130D-02, 0.1213D-02, 0.1281D-02,
     #    0.1331D-02, 0.1362D-02, 0.1368D-02, 0.1349D-02, 0.1303D-02,
     #    0.1229D-02, 0.1126D-02, 0.1001D-02, 0.8613D-03, 0.7202D-03,
     #    0.5940D-03, 0.4950D-03, 0.4256D-03, 0.3776D-03, 0.3382D-03,
     #    0.2980D-03, 0.2548D-03, 0.2111D-03, 0.1702D-03, 0.1346D-03,
     #    0.1049D-03, 0.8085D-04, 0.6179D-04, 0.4692D-04, 0.3539D-04,
     #    0.2659D-04, 0.1985D-04, 0.1466D-04, 0.1092D-04, 0.8055D-05,
     #    0.5922D-05/

      data (calcpts(j,42), j = 1,neta) /0.7004D-06, 0.8482D-06,
     #    0.1028D-05, 0.1246D-05, 0.1509D-05, 0.1827D-05, 0.2214D-05,
     #    0.2683D-05, 0.3250D-05, 0.3938D-05, 0.4771D-05, 0.5778D-05,
     #    0.7001D-05, 0.8488D-05, 0.1028D-04, 0.1245D-04, 0.1509D-04,
     #    0.1828D-04, 0.2216D-04, 0.2684D-04, 0.3252D-04, 0.3942D-04,
     #    0.4777D-04, 0.5790D-04, 0.7017D-04, 0.8503D-04, 0.1031D-03,
     #    0.1248D-03, 0.1512D-03, 0.1828D-03, 0.2205D-03, 0.2653D-03,
     #    0.3174D-03, 0.3772D-03, 0.4439D-03, 0.5161D-03, 0.5919D-03,
     #    0.6686D-03, 0.7434D-03, 0.8136D-03, 0.8767D-03, 0.9305D-03,
     #    0.9725D-03, 0.1001D-02, 0.1015D-02, 0.1012D-02, 0.9913D-03,
     #    0.9518D-03, 0.8919D-03, 0.8136D-03, 0.7195D-03, 0.6161D-03,
     #    0.5131D-03, 0.4218D-03, 0.3507D-03, 0.3014D-03, 0.2676D-03,
     #    0.2398D-03, 0.2113D-03, 0.1806D-03, 0.1496D-03, 0.1206D-03,
     #    0.9525D-04, 0.7412D-04, 0.5712D-04, 0.4366D-04, 0.3312D-04,
     #    0.2499D-04, 0.1879D-04, 0.1392D-04, 0.1039D-04, 0.7724D-05,
     #    0.5658D-05/

      data (calcpts(j,43), j = 1,neta) /0.4974D-06, 0.6029D-06,
     #    0.7301D-06, 0.8846D-06, 0.1071D-05, 0.1298D-05, 0.1573D-05,
     #    0.1906D-05, 0.2309D-05, 0.2798D-05, 0.3389D-05, 0.4106D-05,
     #    0.4975D-05, 0.6027D-05, 0.7305D-05, 0.8846D-05, 0.1072D-04,
     #    0.1299D-04, 0.1574D-04, 0.1907D-04, 0.2311D-04, 0.2800D-04,
     #    0.3393D-04, 0.4113D-04, 0.4985D-04, 0.6041D-04, 0.7320D-04,
     #    0.8870D-04, 0.1073D-03, 0.1298D-03, 0.1566D-03, 0.1884D-03,
     #    0.2256D-03, 0.2681D-03, 0.3157D-03, 0.3675D-03, 0.4220D-03,
     #    0.4776D-03, 0.5321D-03, 0.5840D-03, 0.6313D-03, 0.6725D-03,
     #    0.7062D-03, 0.7312D-03, 0.7465D-03, 0.7510D-03, 0.7440D-03,
     #    0.7243D-03, 0.6914D-03, 0.6450D-03, 0.5856D-03, 0.5156D-03,
     #    0.4396D-03, 0.3647D-03, 0.2989D-03, 0.2481D-03, 0.2132D-03,
     #    0.1893D-03, 0.1697D-03, 0.1496D-03, 0.1278D-03, 0.1058D-03,
     #    0.8526D-04, 0.6726D-04, 0.5232D-04, 0.4032D-04, 0.3079D-04,
     #    0.2333D-04, 0.1759D-04, 0.1319D-04, 0.9859D-05, 0.7325D-05,
     #    0.5459D-05/

      data (calcpts(j,44), j = 1,neta) /0.3528D-06, 0.4274D-06,
     #    0.5179D-06, 0.6277D-06, 0.7598D-06, 0.9211D-06, 0.1116D-05,
     #    0.1352D-05, 0.1638D-05, 0.1984D-05, 0.2404D-05, 0.2912D-05,
     #    0.3528D-05, 0.4275D-05, 0.5179D-05, 0.6275D-05, 0.7603D-05,
     #    0.9212D-05, 0.1116D-04, 0.1352D-04, 0.1639D-04, 0.1986D-04,
     #    0.2406D-04, 0.2916D-04, 0.3535D-04, 0.4284D-04, 0.5190D-04,
     #    0.6288D-04, 0.7611D-04, 0.9204D-04, 0.1111D-03, 0.1336D-03,
     #    0.1600D-03, 0.1903D-03, 0.2242D-03, 0.2612D-03, 0.3003D-03,
     #    0.3403D-03, 0.3800D-03, 0.4180D-03, 0.4531D-03, 0.4843D-03,
     #    0.5106D-03, 0.5312D-03, 0.5454D-03, 0.5527D-03, 0.5524D-03,
     #    0.5439D-03, 0.5268D-03, 0.5004D-03, 0.4648D-03, 0.4202D-03,
     #    0.3685D-03, 0.3130D-03, 0.2588D-03, 0.2115D-03, 0.1753D-03,
     #    0.1505D-03, 0.1337D-03, 0.1199D-03, 0.1057D-03, 0.9034D-04,
     #    0.7472D-04, 0.6014D-04, 0.4747D-04, 0.3687D-04, 0.2840D-04,
     #    0.2167D-04, 0.1640D-04, 0.1240D-04, 0.9271D-05, 0.6938D-05,
     #    0.5138D-05/

      data (calcpts(j,45), j = 1,neta) /0.2498D-06, 0.3026D-06,
     #    0.3666D-06, 0.4442D-06, 0.5384D-06, 0.6517D-06, 0.7901D-06,
     #    0.9569D-06, 0.1160D-05, 0.1405D-05, 0.1702D-05, 0.2062D-05,
     #    0.2499D-05, 0.3027D-05, 0.3667D-05, 0.4443D-05, 0.5383D-05,
     #    0.6523D-05, 0.7902D-05, 0.9579D-05, 0.1160D-04, 0.1406D-04,
     #    0.1704D-04, 0.2065D-04, 0.2502D-04, 0.3033D-04, 0.3675D-04,
     #    0.4452D-04, 0.5389D-04, 0.6516D-04, 0.7864D-04, 0.9462D-04,
     #    0.1133D-03, 0.1348D-03, 0.1589D-03, 0.1853D-03, 0.2133D-03,
     #    0.2421D-03, 0.2708D-03, 0.2985D-03, 0.3243D-03, 0.3477D-03,
     #    0.3678D-03, 0.3841D-03, 0.3963D-03, 0.4039D-03, 0.4067D-03,
     #    0.4041D-03, 0.3958D-03, 0.3816D-03, 0.3610D-03, 0.3339D-03,
     #    0.3007D-03, 0.2628D-03, 0.2225D-03, 0.1834D-03, 0.1495D-03,
     #    0.1237D-03, 0.1062D-03, 0.9438D-04, 0.8469D-04, 0.7467D-04,
     #    0.6379D-04, 0.5275D-04, 0.4245D-04, 0.3348D-04, 0.2604D-04,
     #    0.2004D-04, 0.1524D-04, 0.1158D-04, 0.8709D-05, 0.6576D-05,
     #    0.4909D-05/

      data (calcpts(j,46), j = 1,neta) /0.1766D-06, 0.2140D-06,
     #    0.2593D-06, 0.3141D-06, 0.3805D-06, 0.4610D-06, 0.5583D-06,
     #    0.6765D-06, 0.8200D-06, 0.9935D-06, 0.1204D-05, 0.1458D-05,
     #    0.1766D-05, 0.2140D-05, 0.2593D-05, 0.3142D-05, 0.3807D-05,
     #    0.4612D-05, 0.5588D-05, 0.6771D-05, 0.8207D-05, 0.9939D-05,
     #    0.1205D-04, 0.1460D-04, 0.1770D-04, 0.2144D-04, 0.2598D-04,
     #    0.3147D-04, 0.3810D-04, 0.4606D-04, 0.5559D-04, 0.6689D-04,
     #    0.8012D-04, 0.9534D-04, 0.1125D-03, 0.1312D-03, 0.1512D-03,
     #    0.1719D-03, 0.1925D-03, 0.2126D-03, 0.2316D-03, 0.2488D-03,
     #    0.2640D-03, 0.2767D-03, 0.2866D-03, 0.2936D-03, 0.2972D-03,
     #    0.2976D-03, 0.2942D-03, 0.2869D-03, 0.2754D-03, 0.2595D-03,
     #    0.2392D-03, 0.2147D-03, 0.1870D-03, 0.1578D-03, 0.1297D-03,
     #    0.1055D-03, 0.8715D-04, 0.7480D-04, 0.6651D-04, 0.5970D-04,
     #    0.5264D-04, 0.4496D-04, 0.3716D-04, 0.2989D-04, 0.2356D-04,
     #    0.1830D-04, 0.1407D-04, 0.1073D-04, 0.8131D-05, 0.6124D-05,
     #    0.4591D-05/

      data (calcpts(j,47), j = 1,neta) /0.1247D-06, 0.1511D-06,
     #    0.1831D-06, 0.2218D-06, 0.2687D-06, 0.3256D-06, 0.3945D-06,
     #    0.4779D-06, 0.5790D-06, 0.7013D-06, 0.8498D-06, 0.1029D-05,
     #    0.1247D-05, 0.1511D-05, 0.1831D-05, 0.2218D-05, 0.2688D-05,
     #    0.3257D-05, 0.3946D-05, 0.4781D-05, 0.5793D-05, 0.7020D-05,
     #    0.8506D-05, 0.1031D-04, 0.1249D-04, 0.1514D-04, 0.1834D-04,
     #    0.2222D-04, 0.2689D-04, 0.3252D-04, 0.3925D-04, 0.4723D-04,
     #    0.5657D-04, 0.6735D-04, 0.7949D-04, 0.9282D-04, 0.1071D-03,
     #    0.1218D-03, 0.1366D-03, 0.1512D-03, 0.1650D-03, 0.1777D-03,
     #    0.1890D-03, 0.1986D-03, 0.2065D-03, 0.2123D-03, 0.2161D-03,
     #    0.2176D-03, 0.2167D-03, 0.2133D-03, 0.2071D-03, 0.1981D-03,
     #    0.1860D-03, 0.1709D-03, 0.1530D-03, 0.1328D-03, 0.1118D-03,
     #    0.9159D-04, 0.7433D-04, 0.6134D-04, 0.5263D-04, 0.4681D-04,
     #    0.4204D-04, 0.3707D-04, 0.3166D-04, 0.2615D-04, 0.2102D-04,
     #    0.1656D-04, 0.1286D-04, 0.9878D-05, 0.7524D-05, 0.5698D-05,
     #    0.4291D-05/

      data (calcpts(j,48), j = 1,neta) /0.8797D-07, 0.1066D-06,
     #    0.1291D-06, 0.1564D-06, 0.1895D-06, 0.2296D-06, 0.2782D-06,
     #    0.3371D-06, 0.4083D-06, 0.4947D-06, 0.5994D-06, 0.7261D-06,
     #    0.8796D-06, 0.1066D-05, 0.1291D-05, 0.1565D-05, 0.1896D-05,
     #    0.2296D-05, 0.2783D-05, 0.3372D-05, 0.4086D-05, 0.4951D-05,
     #    0.6000D-05, 0.7270D-05, 0.8808D-05, 0.1068D-04, 0.1293D-04,
     #    0.1567D-04, 0.1897D-04, 0.2293D-04, 0.2767D-04, 0.3331D-04,
     #    0.3991D-04, 0.4752D-04, 0.5611D-04, 0.6556D-04, 0.7568D-04,
     #    0.8621D-04, 0.9686D-04, 0.1073D-03, 0.1173D-03, 0.1265D-03,
     #    0.1350D-03, 0.1422D-03, 0.1482D-03, 0.1530D-03, 0.1564D-03,
     #    0.1582D-03, 0.1585D-03, 0.1572D-03, 0.1541D-03, 0.1491D-03,
     #    0.1421D-03, 0.1330D-03, 0.1219D-03, 0.1088D-03, 0.9418D-04,
     #    0.7904D-04, 0.6462D-04, 0.5233D-04, 0.4313D-04, 0.3700D-04,
     #    0.3292D-04, 0.2958D-04, 0.2609D-04, 0.2227D-04, 0.1839D-04,
     #    0.1478D-04, 0.1163D-04, 0.9027D-05, 0.6934D-05, 0.5281D-05,
     #    0.4001D-05/

      data (calcpts(j,49), j = 1,neta) /0.6194D-07, 0.7506D-07,
     #    0.9095D-07, 0.1102D-06, 0.1335D-06, 0.1617D-06, 0.1960D-06,
     #    0.2374D-06, 0.2876D-06, 0.3485D-06, 0.4222D-06, 0.5115D-06,
     #    0.6198D-06, 0.7509D-06, 0.9094D-06, 0.1102D-05, 0.1335D-05,
     #    0.1618D-05, 0.1960D-05, 0.2375D-05, 0.2878D-05, 0.3488D-05,
     #    0.4226D-05, 0.5121D-05, 0.6206D-05, 0.7520D-05, 0.9108D-05,
     #    0.1104D-04, 0.1335D-04, 0.1615D-04, 0.1949D-04, 0.2346D-04,
     #    0.2811D-04, 0.3348D-04, 0.3956D-04, 0.4625D-04, 0.5343D-04,
     #    0.6092D-04, 0.6852D-04, 0.7603D-04, 0.8325D-04, 0.8997D-04,
     #    0.9617D-04, 0.1015D-03, 0.1062D-03, 0.1099D-03, 0.1127D-03,
     #    0.1145D-03, 0.1153D-03, 0.1150D-03, 0.1135D-03, 0.1109D-03,
     #    0.1070D-03, 0.1017D-03, 0.9490D-04, 0.8672D-04, 0.7719D-04,
     #    0.6667D-04, 0.5582D-04, 0.4553D-04, 0.3680D-04, 0.3030D-04,
     #    0.2599D-04, 0.2313D-04, 0.2079D-04, 0.1833D-04, 0.1565D-04,
     #    0.1292D-04, 0.1038D-04, 0.8170D-05, 0.6337D-05, 0.4864D-05,
     #    0.3704D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ixi .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1bar_Tg = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

CDECK  ID>, GCORRL.

c     ========================================
      double precision function h1_ALg(eta,xi)
c     ========================================

c     eq (9) in PLB347 (1995) 143 - 151 for the longitudinal piece
c     MSbar scheme
c     This routine is called subclca in the original code.
c     Called sclca in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /-.1179D-07, -.1428D-07,
     #    -.1730D-07, -.2095D-07, -.2538D-07, -.3074D-07, -.3723D-07,
     #    -.4509D-07, -.5457D-07, -.6604D-07, -.7989D-07, -.9657D-07,
     #    -.1166D-06, -.1406D-06, -.1691D-06, -.2029D-06, -.2423D-06,
     #    -.2875D-06, -.3377D-06, -.3910D-06, -.4424D-06, -.4824D-06,
     #    -.4929D-06, -.4417D-06, -.2734D-06, 0.1048D-06, 0.8410D-06,
     #    0.2167D-05, 0.4413D-05, 0.8018D-05, 0.1347D-04, 0.2118D-04,
     #    0.3115D-04, 0.4274D-04, 0.5440D-04, 0.6402D-04, 0.6968D-04,
     #    0.7031D-04, 0.6605D-04, 0.5802D-04, 0.4795D-04, 0.3757D-04,
     #    0.2814D-04, 0.2032D-04, 0.1427D-04, 0.9805D-05, 0.6626D-05,
     #    0.4430D-05, 0.2942D-05, 0.1939D-05, 0.1271D-05, 0.8315D-06,
     #    0.5416D-06, 0.3496D-06, 0.2296D-06, 0.1507D-06, 0.9812D-07,
     #    0.6371D-07, 0.3752D-07, 0.2606D-07, 0.1129D-07, 0.1001D-07,
     #    0.6726D-08, -.6033D-10, 0.1982D-08, -.1166D-08, -.3311D-08,
     #    -.4773D-08, 0.8985D-09, 0.2197D-09, -.2427D-09, -.5576D-09,
     #    -.7721D-09/

      data (calcpts(j, 2), j = 1,neta) /-.1730D-07, -.2096D-07,
     #    -.2538D-07, -.3075D-07, -.3725D-07, -.4512D-07, -.5464D-07,
     #    -.6617D-07, -.8009D-07, -.9693D-07, -.1173D-06, -.1417D-06,
     #    -.1711D-06, -.2063D-06, -.2482D-06, -.2978D-06, -.3556D-06,
     #    -.4219D-06, -.4957D-06, -.5739D-06, -.6493D-06, -.7080D-06,
     #    -.7235D-06, -.6485D-06, -.4017D-06, 0.1531D-06, 0.1234D-05,
     #    0.3179D-05, 0.6475D-05, 0.1177D-04, 0.1977D-04, 0.3108D-04,
     #    0.4572D-04, 0.6272D-04, 0.7983D-04, 0.9395D-04, 0.1023D-03,
     #    0.1032D-03, 0.9692D-04, 0.8514D-04, 0.7037D-04, 0.5514D-04,
     #    0.4130D-04, 0.2982D-04, 0.2094D-04, 0.1439D-04, 0.9726D-05,
     #    0.6501D-05, 0.4316D-05, 0.2843D-05, 0.1869D-05, 0.1219D-05,
     #    0.7955D-06, 0.5175D-06, 0.3379D-06, 0.2175D-06, 0.1385D-06,
     #    0.8579D-07, 0.5801D-07, 0.3185D-07, 0.2039D-07, 0.1227D-07,
     #    0.4342D-08, 0.1049D-08, 0.9303D-09, -.3690D-08, -.1711D-09,
     #    -.2317D-08, -.3777D-08, -.4773D-08, -.5452D-08, -.5914D-08,
     #    -.6228D-08/

      data (calcpts(j, 3), j = 1,neta) /-.2537D-07, -.3074D-07,
     #    -.3724D-07, -.4511D-07, -.5465D-07, -.6619D-07, -.8016D-07,
     #    -.9707D-07, -.1175D-06, -.1422D-06, -.1720D-06, -.2079D-06,
     #    -.2510D-06, -.3027D-06, -.3642D-06, -.4368D-06, -.5217D-06,
     #    -.6189D-06, -.7272D-06, -.8419D-06, -.9525D-06, -.1039D-05,
     #    -.1061D-05, -.9512D-06, -.5895D-06, 0.2244D-06, 0.1810D-05,
     #    0.4663D-05, 0.9499D-05, 0.1726D-04, 0.2900D-04, 0.4559D-04,
     #    0.6706D-04, 0.9199D-04, 0.1171D-03, 0.1378D-03, 0.1500D-03,
     #    0.1513D-03, 0.1421D-03, 0.1249D-03, 0.1032D-03, 0.8086D-04,
     #    0.6056D-04, 0.4373D-04, 0.3071D-04, 0.2110D-04, 0.1427D-04,
     #    0.9545D-05, 0.6330D-05, 0.4175D-05, 0.2746D-05, 0.1799D-05,
     #    0.1177D-05, 0.7653D-06, 0.4997D-06, 0.3263D-06, 0.2127D-06,
     #    0.1402D-06, 0.9418D-07, 0.5982D-07, 0.4034D-07, 0.2889D-07,
     #    0.2081D-07, 0.1287D-07, 0.9587D-08, 0.9478D-08, 0.4861D-08,
     #    0.8381D-08, 0.6240D-08, 0.4779D-08, 0.3784D-08, 0.3106D-08,
     #    0.2644D-08/

      data (calcpts(j, 4), j = 1,neta) /-.3724D-07, -.4511D-07,
     #    -.5464D-07, -.6620D-07, -.8019D-07, -.9713D-07, -.1176D-06,
     #    -.1424D-06, -.1724D-06, -.2087D-06, -.2524D-06, -.3051D-06,
     #    -.3684D-06, -.4442D-06, -.5344D-06, -.6411D-06, -.7656D-06,
     #    -.9083D-06, -.1067D-05, -.1236D-05, -.1398D-05, -.1524D-05,
     #    -.1558D-05, -.1397D-05, -.8658D-06, 0.3268D-06, 0.2652D-05,
     #    0.6837D-05, 0.1393D-04, 0.2531D-04, 0.4253D-04, 0.6687D-04,
     #    0.9836D-04, 0.1349D-03, 0.1717D-03, 0.2021D-03, 0.2200D-03,
     #    0.2219D-03, 0.2085D-03, 0.1831D-03, 0.1514D-03, 0.1186D-03,
     #    0.8883D-04, 0.6414D-04, 0.4504D-04, 0.3095D-04, 0.2093D-04,
     #    0.1400D-04, 0.9283D-05, 0.6119D-05, 0.4024D-05, 0.2635D-05,
     #    0.1720D-05, 0.1122D-05, 0.7284D-06, 0.4753D-06, 0.3088D-06,
     #    0.2015D-06, 0.1291D-06, 0.8310D-07, 0.5541D-07, 0.3594D-07,
     #    0.2453D-07, 0.1644D-07, 0.8512D-08, 0.5240D-08, 0.5134D-08,
     #    0.7185D-08, 0.4044D-08, 0.1901D-08, 0.4413D-09, 0.6114D-08,
     #    0.5437D-08/

      data (calcpts(j, 5), j = 1,neta) /-.5464D-07, -.6620D-07,
     #    -.8018D-07, -.9714D-07, -.1177D-06, -.1425D-06, -.1726D-06,
     #    -.2090D-06, -.2530D-06, -.3062D-06, -.3704D-06, -.4477D-06,
     #    -.5406D-06, -.6519D-06, -.7842D-06, -.9407D-06, -.1123D-05,
     #    -.1333D-05, -.1566D-05, -.1813D-05, -.2052D-05, -.2229D-05,
     #    -.2287D-05, -.2051D-05, -.1274D-05, 0.4740D-06, 0.3881D-05,
     #    0.1002D-04, 0.2042D-04, 0.3710D-04, 0.6236D-04, 0.9805D-04,
     #    0.1442D-03, 0.1979D-03, 0.2518D-03, 0.2964D-03, 0.3225D-03,
     #    0.3254D-03, 0.3056D-03, 0.2685D-03, 0.2219D-03, 0.1739D-03,
     #    0.1302D-03, 0.9403D-04, 0.6603D-04, 0.4537D-04, 0.3067D-04,
     #    0.2051D-04, 0.1360D-04, 0.8964D-05, 0.5884D-05, 0.3854D-05,
     #    0.2514D-05, 0.1636D-05, 0.1062D-05, 0.6875D-06, 0.4415D-06,
     #    0.2878D-06, 0.1807D-06, 0.1151D-06, 0.6913D-07, 0.4147D-07,
     #    0.2875D-07, 0.1733D-07, 0.9258D-08, 0.1351D-08, -.1914D-08,
     #    -.2016D-08, 0.4406D-10, -.3098D-08, -.5239D-08, -.6697D-08,
     #    -.7690D-08/

      data (calcpts(j, 6), j = 1,neta) /-.8015D-07, -.9710D-07,
     #    -.1176D-06, -.1425D-06, -.1726D-06, -.2090D-06, -.2532D-06,
     #    -.3066D-06, -.3711D-06, -.4491D-06, -.5433D-06, -.6566D-06,
     #    -.7929D-06, -.9561D-06, -.1150D-05, -.1380D-05, -.1648D-05,
     #    -.1955D-05, -.2297D-05, -.2660D-05, -.3010D-05, -.3283D-05,
     #    -.3357D-05, -.3012D-05, -.1874D-05, 0.6859D-06, 0.5677D-05,
     #    0.1467D-04, 0.2990D-04, 0.5435D-04, 0.9137D-04, 0.1437D-03,
     #    0.2113D-03, 0.2900D-03, 0.3690D-03, 0.4343D-03, 0.4726D-03,
     #    0.4768D-03, 0.4478D-03, 0.3933D-03, 0.3251D-03, 0.2547D-03,
     #    0.1908D-03, 0.1377D-03, 0.9673D-04, 0.6645D-04, 0.4493D-04,
     #    0.3004D-04, 0.1995D-04, 0.1316D-04, 0.8593D-05, 0.5674D-05,
     #    0.3711D-05, 0.2394D-05, 0.1547D-05, 0.1026D-05, 0.6864D-06,
     #    0.4268D-06, 0.2468D-06, 0.1668D-06, 0.8797D-07, 0.5549D-07,
     #    0.5467D-07, 0.8638D-08, 0.4394D-07, 0.2258D-07, 0.8028D-08,
     #    -.1890D-08, -.8640D-08, -.1324D-07, -.1638D-07, -.1852D-07,
     #    -.1997D-07/

      data (calcpts(j, 7), j = 1,neta) /-.1175D-06, -.1424D-06,
     #    -.1725D-06, -.2089D-06, -.2531D-06, -.3065D-06, -.3712D-06,
     #    -.4496D-06, -.5441D-06, -.6585D-06, -.7966D-06, -.9629D-06,
     #    -.1163D-05, -.1402D-05, -.1687D-05, -.2023D-05, -.2417D-05,
     #    -.2867D-05, -.3369D-05, -.3901D-05, -.4415D-05, -.4817D-05,
     #    -.4927D-05, -.4425D-05, -.2761D-05, 0.9843D-06, 0.8293D-05,
     #    0.2145D-04, 0.4376D-04, 0.7956D-04, 0.1338D-03, 0.2103D-03,
     #    0.3094D-03, 0.4245D-03, 0.5403D-03, 0.6358D-03, 0.6919D-03,
     #    0.6980D-03, 0.6555D-03, 0.5757D-03, 0.4758D-03, 0.3728D-03,
     #    0.2792D-03, 0.2016D-03, 0.1416D-03, 0.9723D-04, 0.6578D-04,
     #    0.4393D-04, 0.2913D-04, 0.1919D-04, 0.1264D-04, 0.8225D-05,
     #    0.5357D-05, 0.3523D-05, 0.2272D-05, 0.1492D-05, 0.9729D-06,
     #    0.6333D-06, 0.3745D-06, 0.2620D-06, 0.1824D-06, 0.1038D-06,
     #    0.7170D-07, 0.7095D-07, 0.2502D-07, -.6248D-08, 0.3911D-07,
     #    0.2459D-07, 0.1470D-07, 0.7959D-08, 0.3366D-08, 0.2383D-09,
     #    -.1893D-08/

      data (calcpts(j, 8), j = 1,neta) /-.1723D-06, -.2087D-06,
     #    -.2528D-06, -.3063D-06, -.3710D-06, -.4494D-06, -.5442D-06,
     #    -.6590D-06, -.7977D-06, -.9654D-06, -.1168D-05, -.1412D-05,
     #    -.1705D-05, -.2055D-05, -.2473D-05, -.2966D-05, -.3543D-05,
     #    -.4204D-05, -.4940D-05, -.5721D-05, -.6476D-05, -.7067D-05,
     #    -.7232D-05, -.6503D-05, -.4077D-05, 0.1394D-05, 0.1208D-04,
     #    0.3131D-04, 0.6393D-04, 0.1163D-03, 0.1956D-03, 0.3076D-03,
     #    0.4526D-03, 0.6210D-03, 0.7904D-03, 0.9301D-03, 0.1012D-02,
     #    0.1021D-02, 0.9584D-03, 0.8418D-03, 0.6956D-03, 0.5450D-03,
     #    0.4082D-03, 0.2947D-03, 0.2069D-03, 0.1421D-03, 0.9608D-04,
     #    0.6424D-04, 0.4255D-04, 0.2802D-04, 0.1842D-04, 0.1201D-04,
     #    0.7843D-05, 0.5108D-05, 0.3342D-05, 0.2159D-05, 0.1384D-05,
     #    0.8661D-06, 0.5282D-06, 0.3378D-06, 0.2262D-06, 0.1472D-06,
     #    0.6927D-07, 0.3732D-07, 0.3679D-07, -.8953D-08, -.4013D-07,
     #    0.5292D-08, -.9167D-08, -.1903D-07, -.2575D-07, -.3033D-07,
     #    -.3344D-07/

      data (calcpts(j, 9), j = 1,neta) /-.2523D-06, -.3056D-06,
     #    -.3702D-06, -.4485D-06, -.5433D-06, -.6580D-06, -.7969D-06,
     #    -.9650D-06, -.1168D-05, -.1414D-05, -.1710D-05, -.2067D-05,
     #    -.2496D-05, -.3010D-05, -.3621D-05, -.4344D-05, -.5189D-05,
     #    -.6157D-05, -.7236D-05, -.8381D-05, -.9489D-05, -.1036D-04,
     #    -.1061D-04, -.9553D-05, -.6026D-05, 0.1952D-05, 0.1753D-04,
     #    0.4560D-04, 0.9323D-04, 0.1697D-03, 0.2854D-03, 0.4491D-03,
     #    0.6608D-03, 0.9066D-03, 0.1154D-02, 0.1358D-02, 0.1477D-02,
     #    0.1489D-02, 0.1398D-02, 0.1228D-02, 0.1015D-02, 0.7949D-03,
     #    0.5953D-03, 0.4298D-03, 0.3017D-03, 0.2073D-03, 0.1401D-03,
     #    0.9366D-04, 0.6213D-04, 0.4095D-04, 0.2689D-04, 0.1763D-04,
     #    0.1148D-04, 0.7522D-05, 0.4865D-05, 0.3176D-05, 0.2071D-05,
     #    0.1367D-05, 0.9203D-06, 0.5863D-06, 0.3981D-06, 0.2880D-06,
     #    0.2103D-06, 0.1330D-06, 0.1016D-06, 0.1015D-06, 0.5597D-07,
     #    0.9162D-07, 0.7051D-07, 0.5611D-07, 0.4630D-07, 0.3963D-07,
     #    0.3507D-07/

      data (calcpts(j,10), j = 1,neta) /-.3692D-06, -.4473D-06,
     #    -.5418D-06, -.6564D-06, -.7951D-06, -.9630D-06, -.1166D-05,
     #    -.1412D-05, -.1710D-05, -.2069D-05, -.2503D-05, -.3025D-05,
     #    -.3653D-05, -.4405D-05, -.5300D-05, -.6359D-05, -.7596D-05,
     #    -.9014D-05, -.1059D-04, -.1228D-04, -.1390D-04, -.1519D-04,
     #    -.1557D-04, -.1406D-04, -.8939D-05, 0.2642D-05, 0.2530D-04,
     #    0.6612D-04, 0.1355D-03, 0.2468D-03, 0.4155D-03, 0.6540D-03,
     #    0.9626D-03, 0.1321D-02, 0.1681D-02, 0.1977D-02, 0.2151D-02,
     #    0.2168D-02, 0.2035D-02, 0.1787D-02, 0.1476D-02, 0.1157D-02,
     #    0.8661D-03, 0.6252D-03, 0.4389D-03, 0.3014D-03, 0.2036D-03,
     #    0.1361D-03, 0.9018D-04, 0.5939D-04, 0.3901D-04, 0.2549D-04,
     #    0.1665D-04, 0.1087D-04, 0.7076D-05, 0.4575D-05, 0.2974D-05,
     #    0.1947D-05, 0.1253D-05, 0.8136D-06, 0.5508D-06, 0.3657D-06,
     #    0.2582D-06, 0.1818D-06, 0.1055D-06, 0.7487D-07, 0.7522D-07,
     #    0.3003D-07, 0.6594D-07, 0.4496D-07, 0.3066D-07, 0.2093D-07,
     #    0.1430D-07/

      data (calcpts(j,11), j = 1,neta) /-.5396D-06, -.6538D-06,
     #    -.7919D-06, -.9593D-06, -.1162D-05, -.1408D-05, -.1705D-05,
     #    -.2064D-05, -.2499D-05, -.3024D-05, -.3658D-05, -.4422D-05,
     #    -.5340D-05, -.6440D-05, -.7748D-05, -.9296D-05, -.1111D-04,
     #    -.1318D-04, -.1550D-04, -.1796D-04, -.2035D-04, -.2225D-04,
     #    -.2285D-04, -.2070D-04, -.1334D-04, 0.3407D-05, 0.3622D-04,
     #    0.9542D-04, 0.1961D-03, 0.3577D-03, 0.6026D-03, 0.9490D-03,
     #    0.1397D-02, 0.1918D-02, 0.2441D-02, 0.2870D-02, 0.3121D-02,
     #    0.3145D-02, 0.2951D-02, 0.2590D-02, 0.2140D-02, 0.1676D-02,
     #    0.1255D-02, 0.9058D-03, 0.6357D-03, 0.4364D-03, 0.2948D-03,
     #    0.1969D-03, 0.1304D-03, 0.8575D-04, 0.5625D-04, 0.3676D-04,
     #    0.2393D-04, 0.1552D-04, 0.1008D-04, 0.6481D-05, 0.4160D-05,
     #    0.2653D-05, 0.1713D-05, 0.1101D-05, 0.6720D-06, 0.4159D-06,
     #    0.2361D-06, 0.1315D-06, 0.5727D-07, 0.4929D-07, 0.1966D-07,
     #    -.4596D-07, -.2396D-07, -.5443D-07, -.8516D-08, -.2265D-07,
     #    -.3228D-07/

      data (calcpts(j,12), j = 1,neta) /-.7869D-06, -.9534D-06,
     #    -.1155D-05, -.1399D-05, -.1695D-05, -.2053D-05, -.2486D-05,
     #    -.3010D-05, -.3644D-05, -.4410D-05, -.5335D-05, -.6449D-05,
     #    -.7788D-05, -.9392D-05, -.1130D-04, -.1356D-04, -.1620D-04,
     #    -.1923D-04, -.2262D-04, -.2623D-04, -.2974D-04, -.3256D-04,
     #    -.3352D-04, -.3053D-04, -.2001D-04, 0.4009D-05, 0.5124D-04,
     #    0.1366D-03, 0.2818D-03, 0.5152D-03, 0.8691D-03, 0.1370D-02,
     #    0.2017D-02, 0.2770D-02, 0.3525D-02, 0.4144D-02, 0.4503D-02,
     #    0.4535D-02, 0.4252D-02, 0.3731D-02, 0.3082D-02, 0.2414D-02,
     #    0.1807D-02, 0.1304D-02, 0.9149D-03, 0.6277D-03, 0.4238D-03,
     #    0.2828D-03, 0.1872D-03, 0.1229D-03, 0.8080D-04, 0.5295D-04,
     #    0.3401D-04, 0.2244D-04, 0.1462D-04, 0.9176D-05, 0.6076D-05,
     #    0.3683D-05, 0.2688D-05, 0.1315D-05, 0.1259D-05, 0.3109D-06,
     #    0.3326D-06, 0.5592D-06, 0.2594D-06, 0.5532D-07, -.8377D-07,
     #    -.1786D-06, -.2431D-06, -.2871D-06, -.3171D-06, -.3375D-06,
     #    0.3153D-06/

      data (calcpts(j,13), j = 1,neta) /-.1144D-05, -.1386D-05,
     #    -.1679D-05, -.2034D-05, -.2464D-05, -.2985D-05, -.3615D-05,
     #    -.4377D-05, -.5298D-05, -.6413D-05, -.7758D-05, -.9378D-05,
     #    -.1133D-04, -.1366D-04, -.1644D-04, -.1973D-04, -.2357D-04,
     #    -.2799D-04, -.3293D-04, -.3821D-04, -.4338D-04, -.4758D-04,
     #    -.4914D-04, -.4507D-04, -.3027D-04, 0.3885D-05, 0.7130D-04,
     #    0.1933D-03, 0.4011D-03, 0.7355D-03, 0.1243D-02, 0.1961D-02,
     #    0.2891D-02, 0.3971D-02, 0.5053D-02, 0.5938D-02, 0.6447D-02,
     #    0.6486D-02, 0.6077D-02, 0.5330D-02, 0.4401D-02, 0.3446D-02,
     #    0.2579D-02, 0.1861D-02, 0.1304D-02, 0.8946D-03, 0.6032D-03,
     #    0.4024D-03, 0.2659D-03, 0.1747D-03, 0.1141D-03, 0.7479D-04,
     #    0.4834D-04, 0.3132D-04, 0.2016D-04, 0.1329D-04, 0.8727D-05,
     #    0.5761D-05, 0.3467D-05, 0.2542D-05, 0.1215D-05, 0.1189D-05,
     #    0.2640D-06, 0.2996D-06, 0.5363D-06, 0.2436D-06, 0.4415D-07,
     #    -.9180D-07, -.1843D-06, -.2474D-06, -.2904D-06, -.3197D-06,
     #    0.3270D-06/

      data (calcpts(j,14), j = 1,neta) /-.1657D-05, -.2007D-05,
     #    -.2431D-05, -.2945D-05, -.3568D-05, -.4322D-05, -.5234D-05,
     #    -.6338D-05, -.7672D-05, -.9286D-05, -.1123D-04, -.1358D-04,
     #    -.1640D-04, -.1978D-04, -.2381D-04, -.2858D-04, -.3416D-04,
     #    -.4059D-04, -.4778D-04, -.5550D-04, -.6310D-04, -.6938D-04,
     #    -.7199D-04, -.6670D-04, -.4629D-04, 0.1539D-05, 0.9639D-04,
     #    0.2687D-03, 0.5627D-03, 0.1037D-02, 0.1757D-02, 0.2777D-02,
     #    0.4099D-02, 0.5632D-02, 0.7167D-02, 0.8417D-02, 0.9127D-02,
     #    0.9171D-02, 0.8582D-02, 0.7520D-02, 0.6206D-02, 0.4858D-02,
     #    0.3635D-02, 0.2621D-02, 0.1836D-02, 0.1258D-02, 0.8476D-03,
     #    0.5644D-03, 0.3724D-03, 0.2439D-03, 0.1595D-03, 0.1036D-03,
     #    0.6734D-04, 0.4349D-04, 0.2802D-04, 0.1813D-04, 0.1171D-04,
     #    0.7432D-05, 0.4671D-05, 0.2520D-05, 0.1690D-05, 0.1095D-05,
     #    0.4487D-06, 0.2198D-06, 0.2762D-06, -.1392D-06, -.4223D-06,
     #    0.5138D-07, -.7992D-07, -.1695D-06, -.2305D-06, -.2721D-06,
     #    -.3004D-06/

      data (calcpts(j,15), j = 1,neta) /-.2383D-05, -.2887D-05,
     #    -.3497D-05, -.4237D-05, -.5132D-05, -.6216D-05, -.7528D-05,
     #    -.9117D-05, -.1104D-04, -.1336D-04, -.1616D-04, -.1954D-04,
     #    -.2360D-04, -.2847D-04, -.3427D-04, -.4115D-04, -.4920D-04,
     #    -.5849D-04, -.6892D-04, -.8016D-04, -.9134D-04, -.1008D-03,
     #    -.1052D-03, -.9882D-04, -.7144D-04, -.5986D-05, 0.1249D-03,
     #    0.3641D-03, 0.7735D-03, 0.1435D-02, 0.2441D-02, 0.3868D-02,
     #    0.5719D-02, 0.7864D-02, 0.1001D-01, 0.1174D-01, 0.1271D-01,
     #    0.1274D-01, 0.1190D-01, 0.1042D-01, 0.8590D-02, 0.6721D-02,
     #    0.5026D-02, 0.3621D-02, 0.2535D-02, 0.1734D-02, 0.1166D-02,
     #    0.7749D-03, 0.5102D-03, 0.3340D-03, 0.2176D-03, 0.1414D-03,
     #    0.9123D-04, 0.5901D-04, 0.3835D-04, 0.2483D-04, 0.1587D-04,
     #    0.1004D-04, 0.6855D-05, 0.4387D-05, 0.3100D-05, 0.1738D-05,
     #    0.1237D-05, 0.1319D-05, 0.4663D-06, 0.5524D-06, 0.8235D-06,
     #    0.5539D-06, 0.3704D-06, 0.2452D-06, 0.1599D-06, 0.7685D-06,
     #    0.7290D-06/

      data (calcpts(j,16), j = 1,neta) /-.3399D-05, -.4118D-05,
     #    -.4987D-05, -.6042D-05, -.7320D-05, -.8866D-05, -.1074D-04,
     #    -.1300D-04, -.1574D-04, -.1905D-04, -.2305D-04, -.2787D-04,
     #    -.3367D-04, -.4062D-04, -.4892D-04, -.5875D-04, -.7030D-04,
     #    -.8363D-04, -.9867D-04, -.1150D-03, -.1314D-03, -.1457D-03,
     #    -.1534D-03, -.1467D-03, -.1116D-03, -.2496D-04, 0.1510D-03,
     #    0.4744D-03, 0.1031D-02, 0.1933D-02, 0.3310D-02, 0.5266D-02,
     #    0.7804D-02, 0.1074D-01, 0.1367D-01, 0.1602D-01, 0.1729D-01,
     #    0.1729D-01, 0.1611D-01, 0.1407D-01, 0.1159D-01, 0.9058D-02,
     #    0.6768D-02, 0.4871D-02, 0.3403D-02, 0.2322D-02, 0.1558D-02,
     #    0.1031D-02, 0.6766D-03, 0.4404D-03, 0.2855D-03, 0.1841D-03,
     #    0.1183D-03, 0.7551D-04, 0.4836D-04, 0.3095D-04, 0.1992D-04,
     #    0.1215D-04, 0.7833D-05, 0.5229D-05, 0.3152D-05, 0.2130D-05,
     #    0.1620D-05, 0.5744D-06, 0.7410D-06, 0.6133D-06, 0.7196D-07,
     #    0.3697D-06, 0.1186D-06, -.5265D-07, 0.4973D-06, 0.4179D-06,
     #    0.3637D-06/

      data (calcpts(j,17), j = 1,neta) /-.4787D-05, -.5799D-05,
     #    -.7024D-05, -.8510D-05, -.1031D-04, -.1249D-04, -.1512D-04,
     #    -.1831D-04, -.2217D-04, -.2684D-04, -.3247D-04, -.3927D-04,
     #    -.4744D-04, -.5726D-04, -.6897D-04, -.8288D-04, -.9925D-04,
     #    -.1182D-03, -.1397D-03, -.1632D-03, -.1872D-03, -.2089D-03,
     #    -.2225D-03, -.2175D-03, -.1756D-03, -.6628D-04, 0.1608D-03,
     #    0.5829D-03, 0.1315D-02, 0.2507D-02, 0.4333D-02, 0.6934D-02,
     #    0.1031D-01, 0.1423D-01, 0.1811D-01, 0.2118D-01, 0.2278D-01,
     #    0.2267D-01, 0.2103D-01, 0.1831D-01, 0.1505D-01, 0.1175D-01,
     #    0.8769D-02, 0.6299D-02, 0.4389D-02, 0.2984D-02, 0.1991D-02,
     #    0.1311D-02, 0.8538D-03, 0.5514D-03, 0.3545D-03, 0.2259D-03,
     #    0.1436D-03, 0.9038D-04, 0.5691D-04, 0.3544D-04, 0.2219D-04,
     #    0.1349D-04, 0.8014D-05, 0.4806D-05, 0.2954D-05, 0.1390D-05,
     #    0.7233D-06, 0.4491D-06, -.4337D-06, -.1554D-06, -.2076D-06,
     #    -.6975D-06, -.3643D-06, -.5918D-06, -.8006D-07, -.1856D-06,
     #    -.2575D-06/

      data (calcpts(j,18), j = 1,neta) /-.6622D-05, -.8023D-05,
     #    -.9718D-05, -.1177D-04, -.1426D-04, -.1728D-04, -.2092D-04,
     #    -.2534D-04, -.3068D-04, -.3714D-04, -.4494D-04, -.5435D-04,
     #    -.6568D-04, -.7930D-04, -.9556D-04, -.1149D-03, -.1377D-03,
     #    -.1643D-03, -.1945D-03, -.2280D-03, -.2629D-03, -.2957D-03,
     #    -.3192D-03, -.3204D-03, -.2763D-03, -.1477D-03, 0.1293D-03,
     #    0.6528D-03, 0.1571D-02, 0.3078D-02, 0.5398D-02, 0.8718D-02,
     #    0.1304D-01, 0.1805D-01, 0.2298D-01, 0.2680D-01, 0.2868D-01,
     #    0.2835D-01, 0.2612D-01, 0.2263D-01, 0.1854D-01, 0.1444D-01,
     #    0.1075D-01, 0.7700D-02, 0.5341D-02, 0.3610D-02, 0.2390D-02,
     #    0.1559D-02, 0.1004D-02, 0.6399D-03, 0.4053D-03, 0.2541D-03,
     #    0.1585D-03, 0.9786D-04, 0.6010D-04, 0.3658D-04, 0.2153D-04,
     #    0.1259D-04, 0.7535D-05, 0.4100D-05, 0.2275D-05, 0.6996D-06,
     #    0.4511D-06, 0.2193D-06, -.4223D-06, -.4336D-06, -.1650D-07,
     #    0.2570D-07, -.3993D-06, -.2249D-07, -.2200D-06, -.3545D-06,
     #    -.4461D-06/

      data (calcpts(j,19), j = 1,neta) /-.8944D-05, -.1084D-04,
     #    -.1313D-04, -.1590D-04, -.1926D-04, -.2333D-04, -.2826D-04,
     #    -.3423D-04, -.4144D-04, -.5018D-04, -.6073D-04, -.7346D-04,
     #    -.8880D-04, -.1072D-03, -.1293D-03, -.1556D-03, -.1868D-03,
     #    -.2231D-03, -.2649D-03, -.3117D-03, -.3616D-03, -.4106D-03,
     #    -.4504D-03, -.4657D-03, -.4291D-03, -.2940D-03, 0.1615D-04,
     #    0.6224D-03, 0.1702D-02, 0.3494D-02, 0.6278D-02, 0.1028D-01,
     #    0.1552D-01, 0.2159D-01, 0.2751D-01, 0.3198D-01, 0.3397D-01,
     #    0.3323D-01, 0.3029D-01, 0.2600D-01, 0.2118D-01, 0.1643D-01,
     #    0.1219D-01, 0.8681D-02, 0.5976D-02, 0.3995D-02, 0.2606D-02,
     #    0.1672D-02, 0.1050D-02, 0.6528D-03, 0.4005D-03, 0.2438D-03,
     #    0.1417D-03, 0.8085D-04, 0.5090D-04, 0.2916D-04, 0.1133D-04,
     #    0.9738D-05, -.7403D-06, 0.3042D-05, -.1345D-05, -.2214D-05,
     #    -.6755D-06, -.4174D-05, 0.1085D-06, -.1515D-05, -.2621D-05,
     #    -.3374D-05, 0.2779D-05, 0.2429D-05, 0.2191D-05, 0.2029D-05,
     #    0.1918D-05/

      data (calcpts(j,20), j = 1,neta) /-.1170D-04, -.1418D-04,
     #    -.1718D-04, -.2081D-04, -.2521D-04, -.3054D-04, -.3699D-04,
     #    -.4480D-04, -.5424D-04, -.6568D-04, -.7950D-04, -.9619D-04,
     #    -.1163D-03, -.1405D-03, -.1696D-03, -.2043D-03, -.2455D-03,
     #    -.2939D-03, -.3500D-03, -.4137D-03, -.4831D-03, -.5545D-03,
     #    -.6190D-03, -.6600D-03, -.6477D-03, -.5303D-03, -.2221D-03,
     #    0.4126D-03, 0.1576D-02, 0.3543D-02, 0.6635D-02, 0.1113D-01,
     #    0.1703D-01, 0.2388D-01, 0.3049D-01, 0.3532D-01, 0.3712D-01,
     #    0.3572D-01, 0.3197D-01, 0.2701D-01, 0.2174D-01, 0.1674D-01,
     #    0.1232D-01, 0.8686D-02, 0.5892D-02, 0.3851D-02, 0.2443D-02,
     #    0.1508D-02, 0.9013D-03, 0.5197D-03, 0.2912D-03, 0.1579D-03,
     #    0.7953D-04, 0.3170D-04, 0.7900D-05, -.3297D-05, -.7561D-05,
     #    -.6888D-05, -.7032D-05, -.1196D-04, -.4404D-05, -.6222D-05,
     #    -.5329D-05, -.2602D-05, -.5286D-05, -.4467D-06, -.1692D-05,
     #    -.2541D-05, -.3118D-05, -.3512D-05, -.3781D-05, -.3963D-05,
     #    -.4088D-05/

      data (calcpts(j,21), j = 1,neta) /-.1470D-04, -.1781D-04,
     #    -.2158D-04, -.2614D-04, -.3167D-04, -.3836D-04, -.4647D-04,
     #    -.5628D-04, -.6815D-04, -.8253D-04, -.9992D-04, -.1209D-03,
     #    -.1463D-03, -.1768D-03, -.2135D-03, -.2575D-03, -.3099D-03,
     #    -.3718D-03, -.4443D-03, -.5276D-03, -.6206D-03, -.7201D-03,
     #    -.8181D-03, -.8986D-03, -.9318D-03, -.8660D-03, -.6136D-03,
     #    -.3460D-04, 0.1080D-02, 0.3021D-02, 0.6132D-02, 0.1071D-01,
     #    0.1680D-01, 0.2386D-01, 0.3062D-01, 0.3531D-01, 0.3655D-01,
     #    0.3428D-01, 0.2968D-01, 0.2428D-01, 0.1905D-01, 0.1439D-01,
     #    0.1041D-01, 0.7176D-02, 0.4703D-02, 0.2916D-02, 0.1706D-02,
     #    0.9332D-03, 0.4593D-03, 0.1896D-03, 0.4181D-04, -.3145D-04,
     #    -.5890D-04, -.6627D-04, -.6098D-04, -.5508D-04, -.4132D-04,
     #    -.3532D-04, -.2972D-04, -.2194D-04, -.1481D-04, -.1025D-04,
     #    -.9558D-05, -.6966D-05, -.3075D-05, -.4965D-05, 0.4133D-06,
     #    -.4645D-06, -.1062D-05, -.1469D-05, -.1747D-05, -.1936D-05,
     #    -.2065D-05/

      data (calcpts(j,22), j = 1,neta) /-.1759D-04, -.2131D-04,
     #    -.2581D-04, -.3127D-04, -.3788D-04, -.4589D-04, -.5559D-04,
     #    -.6734D-04, -.8155D-04, -.9876D-04, -.1196D-03, -.1448D-03,
     #    -.1752D-03, -.2119D-03, -.2560D-03, -.3091D-03, -.3725D-03,
     #    -.4480D-03, -.5370D-03, -.6406D-03, -.7588D-03, -.8898D-03,
     #    -.1027D-02, -.1158D-02, -.1257D-02, -.1277D-02, -.1139D-02,
     #    -.7134D-03, 0.1963D-03, 0.1866D-02, 0.4629D-02, 0.8781D-02,
     #    0.1438D-01, 0.2091D-01, 0.2711D-01, 0.3112D-01, 0.3152D-01,
     #    0.2827D-01, 0.2292D-01, 0.1735D-01, 0.1266D-01, 0.9007D-02,
     #    0.6154D-02, 0.3926D-02, 0.2252D-02, 0.1077D-02, 0.3285D-03,
     #    -.1048D-03, -.3108D-03, -.3821D-03, -.3808D-03, -.3361D-03,
     #    -.2800D-03, -.2292D-03, -.1760D-03, -.1380D-03, -.1006D-03,
     #    -.7878D-04, -.5814D-04, -.4252D-04, -.2794D-04, -.2284D-04,
     #    -.1511D-04, -.1227D-04, -.8204D-05, -.3311D-05, -.4519D-05,
     #    -.5343D-05, 0.7633D-06, 0.3809D-06, 0.1204D-06, -.5698D-07,
     #    -.1778D-06/

      data (calcpts(j,23), j = 1,neta) /-.1989D-04, -.2409D-04,
     #    -.2918D-04, -.3536D-04, -.4284D-04, -.5190D-04, -.6287D-04,
     #    -.7616D-04, -.9223D-04, -.1117D-03, -.1353D-03, -.1638D-03,
     #    -.1983D-03, -.2399D-03, -.2901D-03, -.3506D-03, -.4231D-03,
     #    -.5098D-03, -.6129D-03, -.7342D-03, -.8750D-03, -.1036D-02,
     #    -.1212D-02, -.1397D-02, -.1569D-02, -.1695D-02, -.1710D-02,
     #    -.1509D-02, -.9289D-03, 0.2640D-03, 0.2358D-02, 0.5620D-02,
     #    0.1011D-01, 0.1541D-01, 0.2038D-01, 0.2331D-01, 0.2276D-01,
     #    0.1873D-01, 0.1286D-01, 0.7356D-02, 0.3497D-02, 0.1266D-02,
     #    0.3697D-04, -.7100D-03, -.1187D-02, -.1463D-02, -.1552D-02,
     #    -.1489D-02, -.1333D-02, -.1135D-02, -.9232D-03, -.7340D-03,
     #    -.5716D-03, -.4336D-03, -.3286D-03, -.2446D-03, -.1785D-03,
     #    -.1308D-03, -.9282D-04, -.6781D-04, -.5136D-04, -.3832D-04,
     #    -.2306D-04, -.1963D-04, -.1516D-04, -.9997D-05, -.4353D-05,
     #    -.5049D-05, -.5523D-05, -.5847D-05, 0.5996D-06, 0.4496D-06,
     #    0.3474D-06/

      data (calcpts(j,24), j = 1,neta) /-.2117D-04, -.2564D-04,
     #    -.3106D-04, -.3763D-04, -.4560D-04, -.5524D-04, -.6692D-04,
     #    -.8107D-04, -.9819D-04, -.1189D-03, -.1441D-03, -.1745D-03,
     #    -.2112D-03, -.2557D-03, -.3093D-03, -.3741D-03, -.4520D-03,
     #    -.5456D-03, -.6574D-03, -.7902D-03, -.9465D-03, -.1128D-02,
     #    -.1335D-02, -.1564D-02, -.1803D-02, -.2029D-02, -.2199D-02,
     #    -.2238D-02, -.2028D-02, -.1394D-02, -.1156D-03, 0.2017D-02,
     #    0.5066D-02, 0.8726D-02, 0.1210D-01, 0.1376D-01, 0.1244D-01,
     #    0.8023D-02, 0.2015D-02, -.3294D-02, -.6393D-02, -.7245D-02,
     #    -.6777D-02, -.5883D-02, -.5009D-02, -.4254D-02, -.3594D-02,
     #    -.2993D-02, -.2443D-02, -.1947D-02, -.1520D-02, -.1169D-02,
     #    -.8818D-03, -.6554D-03, -.4863D-03, -.3526D-03, -.2554D-03,
     #    -.1867D-03, -.1368D-03, -.9494D-04, -.6941D-04, -.4806D-04,
     #    -.3168D-04, -.2748D-04, -.1583D-04, -.1031D-04, -.1109D-04,
     #    -.4956D-05, -.5318D-05, -.5565D-05, 0.9334D-06, 0.8188D-06,
     #    0.7408D-06/

      data (calcpts(j,25), j = 1,neta) /-.2120D-04, -.2568D-04,
     #    -.3111D-04, -.3769D-04, -.4567D-04, -.5532D-04, -.6702D-04,
     #    -.8120D-04, -.9835D-04, -.1191D-03, -.1443D-03, -.1748D-03,
     #    -.2117D-03, -.2563D-03, -.3102D-03, -.3754D-03, -.4540D-03,
     #    -.5486D-03, -.6623D-03, -.7982D-03, -.9596D-03, -.1150D-02,
     #    -.1372D-02, -.1626D-02, -.1907D-02, -.2205D-02, -.2495D-02,
     #    -.2732D-02, -.2841D-02, -.2708D-02, -.2186D-02, -.1130D-02,
     #    0.5125D-03, 0.2538D-02, 0.4317D-02, 0.4811D-02, 0.2999D-02,
     #    -.1337D-02, -.7059D-02, -.1210D-01, -.1476D-01, -.1475D-01,
     #    -.1299D-01, -.1067D-01, -.8534D-02, -.6815D-02, -.5453D-02,
     #    -.4354D-02, -.3441D-02, -.2691D-02, -.2071D-02, -.1573D-02,
     #    -.1175D-02, -.8679D-03, -.6419D-03, -.4655D-03, -.3374D-03,
     #    -.2412D-03, -.1729D-03, -.1209D-03, -.8633D-04, -.6337D-04,
     #    -.4589D-04, -.3428D-04, -.2211D-04, -.1625D-04, -.1012D-04,
     #    -.1049D-04, -.4079D-05, -.4251D-05, -.4369D-05, -.4448D-05,
     #    -.4503D-05/

      data (calcpts(j,26), j = 1,neta) /-.2004D-04, -.2428D-04,
     #    -.2941D-04, -.3563D-04, -.4317D-04, -.5230D-04, -.6336D-04,
     #    -.7677D-04, -.9298D-04, -.1126D-03, -.1365D-03, -.1653D-03,
     #    -.2002D-03, -.2425D-03, -.2936D-03, -.3554D-03, -.4301D-03,
     #    -.5202D-03, -.6287D-03, -.7591D-03, -.9150D-03, -.1101D-02,
     #    -.1321D-02, -.1577D-02, -.1872D-02, -.2202D-02, -.2558D-02,
     #    -.2917D-02, -.3239D-02, -.3459D-02, -.3493D-02, -.3253D-02,
     #    -.2705D-02, -.1976D-02, -.1463D-02, -.1853D-02, -.3876D-02,
     #    -.7789D-02, -.1288D-01, -.1756D-01, -.2015D-01, -.1998D-01,
     #    -.1766D-01, -.1444D-01, -.1135D-01, -.8830D-02, -.6891D-02,
     #    -.5395D-02, -.4216D-02, -.3267D-02, -.2506D-02, -.1896D-02,
     #    -.1418D-02, -.1049D-02, -.7705D-03, -.5611D-03, -.4041D-03,
     #    -.2886D-03, -.2095D-03, -.1480D-03, -.1048D-03, -.7391D-04,
     #    -.5554D-04, -.3665D-04, -.2408D-04, -.1793D-04, -.1162D-04,
     #    -.1186D-04, -.5353D-05, -.5465D-05, -.5541D-05, 0.1074D-05,
     #    0.1039D-05/

      data (calcpts(j,27), j = 1,neta) /-.1799D-04, -.2179D-04,
     #    -.2640D-04, -.3199D-04, -.3875D-04, -.4695D-04, -.5688D-04,
     #    -.6891D-04, -.8347D-04, -.1011D-03, -.1225D-03, -.1484D-03,
     #    -.1798D-03, -.2178D-03, -.2637D-03, -.3193D-03, -.3866D-03,
     #    -.4678D-03, -.5659D-03, -.6842D-03, -.8261D-03, -.9964D-03,
     #    -.1200D-02, -.1440D-02, -.1722D-02, -.2048D-02, -.2416D-02,
     #    -.2821D-02, -.3243D-02, -.3654D-02, -.4010D-02, -.4266D-02,
     #    -.4407D-02, -.4507D-02, -.4803D-02, -.5710D-02, -.7709D-02,
     #    -.1103D-01, -.1532D-01, -.1951D-01, -.2220D-01, -.2245D-01,
     #    -.2037D-01, -.1695D-01, -.1334D-01, -.1025D-01, -.7864D-02,
     #    -.6080D-02, -.4713D-02, -.3649D-02, -.2801D-02, -.2129D-02,
     #    -.1595D-02, -.1187D-02, -.8684D-03, -.6365D-03, -.4599D-03,
     #    -.3334D-03, -.2381D-03, -.1680D-03, -.1235D-03, -.8495D-04,
     #    -.5929D-04, -.4665D-04, -.3378D-04, -.2077D-04, -.1432D-04,
     #    -.1447D-04, -.7903D-05, -.7972D-05, -.8019D-05, -.1384D-05,
     #    -.1406D-05/

      data (calcpts(j,28), j = 1,neta) /-.1544D-04, -.1871D-04,
     #    -.2266D-04, -.2745D-04, -.3326D-04, -.4030D-04, -.4882D-04,
     #    -.5915D-04, -.7165D-04, -.8681D-04, -.1052D-03, -.1274D-03,
     #    -.1543D-03, -.1870D-03, -.2264D-03, -.2742D-03, -.3321D-03,
     #    -.4021D-03, -.4866D-03, -.5888D-03, -.7117D-03, -.8598D-03,
     #    -.1037D-02, -.1249D-02, -.1501D-02, -.1797D-02, -.2141D-02,
     #    -.2533D-02, -.2970D-02, -.3441D-02, -.3929D-02, -.4414D-02,
     #    -.4893D-02, -.5410D-02, -.6097D-02, -.7195D-02, -.8996D-02,
     #    -.1169D-01, -.1512D-01, -.1871D-01, -.2144D-01, -.2235D-01,
     #    -.2108D-01, -.1813D-01, -.1453D-01, -.1116D-01, -.8466D-02,
     #    -.6453D-02, -.4965D-02, -.3831D-02, -.2950D-02, -.2251D-02,
     #    -.1699D-02, -.1272D-02, -.9380D-03, -.6869D-03, -.4997D-03,
     #    -.3571D-03, -.2600D-03, -.1819D-03, -.1299D-03, -.9075D-04,
     #    -.6469D-04, -.4510D-04, -.3205D-04, -.2558D-04, -.1904D-04,
     #    -.1246D-04, -.5857D-05, -.5898D-05, -.5926D-05, -.5946D-05,
     #    0.7080D-06/

      data (calcpts(j,29), j = 1,neta) /-.1277D-04, -.1547D-04,
     #    -.1874D-04, -.2270D-04, -.2750D-04, -.3332D-04, -.4037D-04,
     #    -.4891D-04, -.5924D-04, -.7178D-04, -.8697D-04, -.1054D-03,
     #    -.1276D-03, -.1546D-03, -.1873D-03, -.2268D-03, -.2748D-03,
     #    -.3327D-03, -.4028D-03, -.4876D-03, -.5898D-03, -.7133D-03,
     #    -.8618D-03, -.1040D-02, -.1253D-02, -.1506D-02, -.1804D-02,
     #    -.2152D-02, -.2552D-02, -.3002D-02, -.3499D-02, -.4038D-02,
     #    -.4618D-02, -.5268D-02, -.6058D-02, -.7120D-02, -.8624D-02,
     #    -.1070D-01, -.1334D-01, -.1624D-01, -.1880D-01, -.2025D-01,
     #    -.1999D-01, -.1802D-01, -.1495D-01, -.1167D-01, -.8823D-02,
     #    -.6636D-02, -.5040D-02, -.3866D-02, -.2982D-02, -.2286D-02,
     #    -.1743D-02, -.1308D-02, -.9757D-03, -.7144D-03, -.5247D-03,
     #    -.3806D-03, -.2689D-03, -.1968D-03, -.1376D-03, -.9809D-04,
     #    -.7179D-04, -.5204D-04, -.3221D-04, -.2566D-04, -.1907D-04,
     #    -.1246D-04, -.5827D-05, -.5852D-05, -.5869D-05, 0.7861D-06,
     #    0.7782D-06/

      data (calcpts(j,30), j = 1,neta) /-.1024D-04, -.1241D-04,
     #    -.1503D-04, -.1821D-04, -.2206D-04, -.2673D-04, -.3238D-04,
     #    -.3923D-04, -.4753D-04, -.5758D-04, -.6977D-04, -.8452D-04,
     #    -.1024D-03, -.1240D-03, -.1502D-03, -.1820D-03, -.2205D-03,
     #    -.2670D-03, -.3233D-03, -.3915D-03, -.4738D-03, -.5733D-03,
     #    -.6933D-03, -.8376D-03, -.1011D-02, -.1218D-02, -.1464D-02,
     #    -.1754D-02, -.2094D-02, -.2485D-02, -.2929D-02, -.3427D-02,
     #    -.3981D-02, -.4606D-02, -.5340D-02, -.6249D-02, -.7431D-02,
     #    -.8975D-02, -.1091D-01, -.1312D-01, -.1531D-01, -.1698D-01,
     #    -.1754D-01, -.1668D-01, -.1456D-01, -.1177D-01, -.9012D-02,
     #    -.6734D-02, -.5036D-02, -.3817D-02, -.2926D-02, -.2254D-02,
     #    -.1725D-02, -.1312D-02, -.9835D-03, -.7334D-03, -.5357D-03,
     #    -.3905D-03, -.2849D-03, -.2056D-03, -.1461D-03, -.9979D-04,
     #    -.7335D-04, -.5350D-04, -.3361D-04, -.2701D-04, -.2039D-04,
     #    -.1376D-04, -.7115D-05, -.7130D-05, -.7141D-05, -.4813D-06,
     #    -.4861D-06/

      data (calcpts(j,31), j = 1,neta) /-.8016D-05, -.9712D-05,
     #    -.1176D-04, -.1425D-04, -.1727D-04, -.2092D-04, -.2535D-04,
     #    -.3071D-04, -.3720D-04, -.4507D-04, -.5461D-04, -.6616D-04,
     #    -.8015D-04, -.9711D-04, -.1176D-03, -.1425D-03, -.1726D-03,
     #    -.2091D-03, -.2532D-03, -.3066D-03, -.3712D-03, -.4493D-03,
     #    -.5436D-03, -.6573D-03, -.7940D-03, -.9580D-03, -.1154D-02,
     #    -.1386D-02, -.1661D-02, -.1980D-02, -.2349D-02, -.2769D-02,
     #    -.3242D-02, -.3776D-02, -.4389D-02, -.5113D-02, -.6000D-02,
     #    -.7105D-02, -.8465D-02, -.1006D-01, -.1178D-01, -.1334D-01,
     #    -.1435D-01, -.1440D-01, -.1333D-01, -.1135D-01, -.8994D-02,
     #    -.6786D-02, -.5024D-02, -.3742D-02, -.2832D-02, -.2172D-02,
     #    -.1671D-02, -.1280D-02, -.9694D-03, -.7248D-03, -.5396D-03,
     #    -.3939D-03, -.2879D-03, -.2083D-03, -.1486D-03, -.1088D-03,
     #    -.7564D-04, -.5574D-04, -.3580D-04, -.2918D-04, -.1588D-04,
     #    -.1590D-04, -.9249D-05, -.9259D-05, -.2599D-05, -.2604D-05,
     #    -.2607D-05/

      data (calcpts(j,32), j = 1,neta) /-.6153D-05, -.7455D-05,
     #    -.9030D-05, -.1094D-04, -.1326D-04, -.1606D-04, -.1946D-04,
     #    -.2357D-04, -.2856D-04, -.3460D-04, -.4192D-04, -.5078D-04,
     #    -.6152D-04, -.7454D-04, -.9028D-04, -.1094D-03, -.1325D-03,
     #    -.1605D-03, -.1944D-03, -.2355D-03, -.2851D-03, -.3451D-03,
     #    -.4177D-03, -.5052D-03, -.6106D-03, -.7374D-03, -.8890D-03,
     #    -.1070D-02, -.1284D-02, -.1536D-02, -.1828D-02, -.2163D-02,
     #    -.2543D-02, -.2970D-02, -.3452D-02, -.4003D-02, -.4647D-02,
     #    -.5416D-02, -.6342D-02, -.7441D-02, -.8684D-02, -.9956D-02,
     #    -.1104D-01, -.1161D-01, -.1141D-01, -.1034D-01, -.8643D-02,
     #    -.6739D-02, -.5023D-02, -.3691D-02, -.2739D-02, -.2071D-02,
     #    -.1588D-02, -.1222D-02, -.9344D-03, -.7078D-03, -.5294D-03,
     #    -.3914D-03, -.2865D-03, -.2075D-03, -.1497D-03, -.1065D-03,
     #    -.7590D-04, -.5396D-04, -.3800D-04, -.2670D-04, -.1872D-04,
     #    -.1273D-04, -.8742D-05, -.6082D-05, -.4086D-05, -.2756D-05,
     #    -.1425D-05/

      data (calcpts(j,33), j = 1,neta) /-.4652D-05, -.5636D-05,
     #    -.6827D-05, -.8271D-05, -.1002D-04, -.1214D-04, -.1471D-04,
     #    -.1782D-04, -.2159D-04, -.2616D-04, -.3169D-04, -.3839D-04,
     #    -.4651D-04, -.5635D-04, -.6826D-04, -.8269D-04, -.1002D-03,
     #    -.1214D-03, -.1470D-03, -.1780D-03, -.2156D-03, -.2610D-03,
     #    -.3160D-03, -.3822D-03, -.4622D-03, -.5584D-03, -.6736D-03,
     #    -.8114D-03, -.9751D-03, -.1168D-02, -.1392D-02, -.1651D-02,
     #    -.1944D-02, -.2273D-02, -.2639D-02, -.3046D-02, -.3505D-02,
     #    -.4031D-02, -.4646D-02, -.5373D-02, -.6219D-02, -.7152D-02,
     #    -.8076D-02, -.8811D-02, -.9122D-02, -.8814D-02, -.7864D-02,
     #    -.6474D-02, -.4981D-02, -.3676D-02, -.2685D-02, -.1986D-02,
     #    -.1501D-02, -.1151D-02, -.8859D-03, -.6775D-03, -.5128D-03,
     #    -.3839D-03, -.2835D-03, -.2077D-03, -.1505D-03, -.1086D-03,
     #    -.7804D-04, -.5541D-04, -.3944D-04, -.2813D-04, -.2014D-04,
     #    -.1415D-04, -.1016D-04, -.7497D-05, -.5500D-05, -.4169D-05,
     #    -.2837D-05/

      data (calcpts(j,34), j = 1,neta) /-.3472D-05, -.4207D-05,
     #    -.5096D-05, -.6174D-05, -.7481D-05, -.9063D-05, -.1098D-04,
     #    -.1330D-04, -.1611D-04, -.1952D-04, -.2366D-04, -.2866D-04,
     #    -.3472D-04, -.4207D-04, -.5095D-04, -.6173D-04, -.7479D-04,
     #    -.9059D-04, -.1097D-03, -.1329D-03, -.1609D-03, -.1949D-03,
     #    -.2359D-03, -.2855D-03, -.3452D-03, -.4172D-03, -.5035D-03,
     #    -.6068D-03, -.7296D-03, -.8745D-03, -.1044D-02, -.1239D-02,
     #    -.1460D-02, -.1707D-02, -.1978D-02, -.2274D-02, -.2596D-02,
     #    -.2953D-02, -.3356D-02, -.3824D-02, -.4374D-02, -.5007D-02,
     #    -.5697D-02, -.6361D-02, -.6858D-02, -.7012D-02, -.6688D-02,
     #    -.5890D-02, -.4790D-02, -.3645D-02, -.2667D-02, -.1936D-02,
     #    -.1429D-02, -.1079D-02, -.8275D-03, -.6368D-03, -.4866D-03,
     #    -.3682D-03, -.2751D-03, -.2032D-03, -.1480D-03, -.1074D-03,
     #    -.7742D-04, -.5545D-04, -.3947D-04, -.2815D-04, -.1949D-04,
     #    -.1416D-04, -.1017D-04, -.6839D-05, -.4841D-05, -.3509D-05,
     #    -.2843D-05/

      data (calcpts(j,35), j = 1,neta) /-.2566D-05, -.3109D-05,
     #    -.3766D-05, -.4563D-05, -.5529D-05, -.6698D-05, -.8115D-05,
     #    -.9832D-05, -.1191D-04, -.1443D-04, -.1748D-04, -.2118D-04,
     #    -.2566D-04, -.3109D-04, -.3766D-04, -.4562D-04, -.5527D-04,
     #    -.6696D-04, -.8110D-04, -.9824D-04, -.1190D-03, -.1441D-03,
     #    -.1744D-03, -.2110D-03, -.2552D-03, -.3085D-03, -.3724D-03,
     #    -.4489D-03, -.5400D-03, -.6474D-03, -.7730D-03, -.9178D-03,
     #    -.1082D-02, -.1264D-02, -.1463D-02, -.1676D-02, -.1901D-02,
     #    -.2142D-02, -.2405D-02, -.2702D-02, -.3048D-02, -.3455D-02,
     #    -.3924D-02, -.4429D-02, -.4904D-02, -.5239D-02, -.5304D-02,
     #    -.5007D-02, -.4363D-02, -.3511D-02, -.2647D-02, -.1922D-02,
     #    -.1388D-02, -.1022D-02, -.7714D-03, -.5912D-03, -.4549D-03,
     #    -.3477D-03, -.2625D-03, -.1960D-03, -.1440D-03, -.1054D-03,
     #    -.7611D-04, -.5480D-04, -.3881D-04, -.2749D-04, -.1949D-04,
     #    -.1350D-04, -.9501D-05, -.6836D-05, -.4838D-05, -.3505D-05,
     #    -.2173D-05/

      data (calcpts(j,36), j = 1,neta) /-.1882D-05, -.2280D-05,
     #    -.2762D-05, -.3346D-05, -.4055D-05, -.4912D-05, -.5951D-05,
     #    -.7210D-05, -.8734D-05, -.1058D-04, -.1282D-04, -.1553D-04,
     #    -.1882D-04, -.2280D-04, -.2762D-04, -.3346D-04, -.4054D-04,
     #    -.4910D-04, -.5948D-04, -.7205D-04, -.8724D-04, -.1056D-03,
     #    -.1279D-03, -.1548D-03, -.1872D-03, -.2263D-03, -.2732D-03,
     #    -.3294D-03, -.3962D-03, -.4752D-03, -.5675D-03, -.6739D-03,
     #    -.7942D-03, -.9276D-03, -.1072D-02, -.1224D-02, -.1382D-02,
     #    -.1545D-02, -.1717D-02, -.1904D-02, -.2118D-02, -.2370D-02,
     #    -.2669D-02, -.3013D-02, -.3381D-02, -.3720D-02, -.3946D-02,
     #    -.3963D-02, -.3711D-02, -.3205D-02, -.2557D-02, -.1912D-02,
     #    -.1379D-02, -.9917D-03, -.7282D-03, -.5492D-03, -.4207D-03,
     #    -.3236D-03, -.2470D-03, -.1871D-03, -.1391D-03, -.1025D-03,
     #    -.7449D-04, -.5384D-04, -.3852D-04, -.2786D-04, -.1986D-04,
     #    -.1387D-04, -.9868D-05, -.6536D-05, -.4537D-05, -.3204D-05,
     #    -.2538D-05/

      data (calcpts(j,37), j = 1,neta) /-.1371D-05, -.1661D-05,
     #    -.2012D-05, -.2438D-05, -.2954D-05, -.3579D-05, -.4336D-05,
     #    -.5253D-05, -.6363D-05, -.7709D-05, -.9341D-05, -.1132D-04,
     #    -.1371D-04, -.1661D-04, -.2012D-04, -.2438D-04, -.2953D-04,
     #    -.3577D-04, -.4333D-04, -.5249D-04, -.6356D-04, -.7697D-04,
     #    -.9319D-04, -.1128D-03, -.1364D-03, -.1649D-03, -.1991D-03,
     #    -.2400D-03, -.2888D-03, -.3463D-03, -.4136D-03, -.4912D-03,
     #    -.5787D-03, -.6755D-03, -.7795D-03, -.8880D-03, -.9986D-03,
     #    -.1110D-02, -.1223D-02, -.1341D-02, -.1472D-02, -.1625D-02,
     #    -.1808D-02, -.2026D-02, -.2278D-02, -.2546D-02, -.2787D-02,
     #    -.2939D-02, -.2933D-02, -.2727D-02, -.2338D-02, -.1851D-02,
     #    -.1374D-02, -.9852D-03, -.7055D-03, -.5172D-03, -.3894D-03,
     #    -.2988D-03, -.2296D-03, -.1756D-03, -.1323D-03, -.9832D-04,
     #    -.7234D-04, -.5302D-04, -.3836D-04, -.2703D-04, -.1970D-04,
     #    -.1370D-04, -.9704D-05, -.7038D-05, -.5039D-05, -.3706D-05,
     #    -.2373D-05/

      data (calcpts(j,38), j = 1,neta) /-.9934D-06, -.1204D-05,
     #    -.1458D-05, -.1767D-05, -.2140D-05, -.2593D-05, -.3141D-05,
     #    -.3806D-05, -.4611D-05, -.5586D-05, -.6768D-05, -.8200D-05,
     #    -.9934D-05, -.1204D-04, -.1458D-04, -.1766D-04, -.2140D-04,
     #    -.2592D-04, -.3140D-04, -.3803D-04, -.4606D-04, -.5577D-04,
     #    -.6753D-04, -.8172D-04, -.9885D-04, -.1195D-03, -.1443D-03,
     #    -.1739D-03, -.2093D-03, -.2510D-03, -.2997D-03, -.3559D-03,
     #    -.4192D-03, -.4891D-03, -.5638D-03, -.6411D-03, -.7187D-03,
     #    -.7950D-03, -.8699D-03, -.9455D-03, -.1026D-02, -.1117D-02,
     #    -.1226D-02, -.1358D-02, -.1518D-02, -.1702D-02, -.1895D-02,
     #    -.2067D-02, -.2170D-02, -.2155D-02, -.1991D-02, -.1696D-02,
     #    -.1334D-02, -.9843D-03, -.7016D-03, -.5005D-03, -.3659D-03,
     #    -.2753D-03, -.2113D-03, -.1620D-03, -.1240D-03, -.9339D-04,
     #    -.6940D-04, -.5141D-04, -.3741D-04, -.2675D-04, -.1942D-04,
     #    -.1342D-04, -.9422D-05, -.6756D-05, -.4756D-05, -.3423D-05,
     #    -.2090D-05/

      data (calcpts(j,39), j = 1,neta) /-.7169D-06, -.8686D-06,
     #    -.1052D-05, -.1275D-05, -.1545D-05, -.1871D-05, -.2267D-05,
     #    -.2747D-05, -.3327D-05, -.4031D-05, -.4884D-05, -.5917D-05,
     #    -.7169D-05, -.8685D-05, -.1052D-04, -.1275D-04, -.1544D-04,
     #    -.1871D-04, -.2266D-04, -.2745D-04, -.3324D-04, -.4025D-04,
     #    -.4873D-04, -.5897D-04, -.7134D-04, -.8623D-04, -.1041D-03,
     #    -.1255D-03, -.1510D-03, -.1811D-03, -.2163D-03, -.2568D-03,
     #    -.3024D-03, -.3527D-03, -.4062D-03, -.4612D-03, -.5158D-03,
     #    -.5685D-03, -.6187D-03, -.6676D-03, -.7174D-03, -.7719D-03,
     #    -.8355D-03, -.9132D-03, -.1009D-02, -.1126D-02, -.1259D-02,
     #    -.1399D-02, -.1521D-02, -.1591D-02, -.1573D-02, -.1446D-02,
     #    -.1226D-02, -.9584D-03, -.7031D-03, -.4988D-03, -.3545D-03,
     #    -.2587D-03, -.1947D-03, -.1492D-03, -.1147D-03, -.8761D-04,
     #    -.6616D-04, -.4956D-04, -.3623D-04, -.2623D-04, -.1890D-04,
     #    -.1357D-04, -.9571D-05, -.6905D-05, -.4905D-05, -.3572D-05,
     #    -.2239D-05/

      data (calcpts(j,40), j = 1,neta) /-.5152D-06, -.6243D-06,
     #    -.7562D-06, -.9162D-06, -.1110D-05, -.1345D-05, -.1629D-05,
     #    -.1974D-05, -.2391D-05, -.2897D-05, -.3510D-05, -.4253D-05,
     #    -.5152D-05, -.6242D-05, -.7561D-05, -.9160D-05, -.1110D-04,
     #    -.1344D-04, -.1628D-04, -.1973D-04, -.2389D-04, -.2893D-04,
     #    -.3502D-04, -.4238D-04, -.5127D-04, -.6197D-04, -.7482D-04,
     #    -.9021D-04, -.1085D-03, -.1302D-03, -.1554D-03, -.1845D-03,
     #    -.2173D-03, -.2533D-03, -.2915D-03, -.3306D-03, -.3691D-03,
     #    -.4057D-03, -.4398D-03, -.4717D-03, -.5030D-03, -.5357D-03,
     #    -.5727D-03, -.6176D-03, -.6733D-03, -.7430D-03, -.8276D-03,
     #    -.9246D-03, -.1025D-02, -.1112D-02, -.1159D-02, -.1142D-02,
     #    -.1046D-02, -.8819D-03, -.6861D-03, -.5007D-03, -.3536D-03,
     #    -.2504D-03, -.1824D-03, -.1371D-03, -.1051D-03, -.8080D-04,
     #    -.6168D-04, -.4655D-04, -.3462D-04, -.2542D-04, -.1848D-04,
     #    -.1335D-04, -.9553D-05, -.6820D-05, -.4820D-05, -.3420D-05,
     #    -.2420D-05/

      data (calcpts(j,41), j = 1,neta) /-.3691D-06, -.4472D-06,
     #    -.5416D-06, -.6563D-06, -.7952D-06, -.9633D-06, -.1167D-05,
     #    -.1414D-05, -.1713D-05, -.2075D-05, -.2514D-05, -.3046D-05,
     #    -.3691D-05, -.4471D-05, -.5416D-05, -.6562D-05, -.7950D-05,
     #    -.9630D-05, -.1167D-04, -.1413D-04, -.1711D-04, -.2072D-04,
     #    -.2509D-04, -.3036D-04, -.3672D-04, -.4439D-04, -.5360D-04,
     #    -.6462D-04, -.7775D-04, -.9324D-04, -.1113D-03, -.1322D-03,
     #    -.1556D-03, -.1813D-03, -.2086D-03, -.2364D-03, -.2635D-03,
     #    -.2890D-03, -.3124D-03, -.3336D-03, -.3535D-03, -.3734D-03,
     #    -.3951D-03, -.4206D-03, -.4523D-03, -.4925D-03, -.5429D-03,
     #    -.6043D-03, -.6745D-03, -.7467D-03, -.8083D-03, -.8408D-03,
     #    -.8255D-03, -.7532D-03, -.6325D-03, -.4898D-03, -.3558D-03,
     #    -.2501D-03, -.1766D-03, -.1284D-03, -.9645D-04, -.7386D-04,
     #    -.5680D-04, -.4333D-04, -.3267D-04, -.2427D-04, -.1780D-04,
     #    -.1294D-04, -.9270D-05, -.6670D-05, -.4737D-05, -.3337D-05,
     #    -.2337D-05/

      data (calcpts(j,42), j = 1,neta) /-.2638D-06, -.3195D-06,
     #    -.3871D-06, -.4689D-06, -.5682D-06, -.6883D-06, -.8339D-06,
     #    -.1010D-05, -.1224D-05, -.1483D-05, -.1797D-05, -.2177D-05,
     #    -.2637D-05, -.3195D-05, -.3870D-05, -.4688D-05, -.5680D-05,
     #    -.6881D-05, -.8335D-05, -.1010D-04, -.1223D-04, -.1481D-04,
     #    -.1793D-04, -.2169D-04, -.2624D-04, -.3172D-04, -.3830D-04,
     #    -.4617D-04, -.5555D-04, -.6662D-04, -.7954D-04, -.9441D-04,
     #    -.1111D-03, -.1295D-03, -.1489D-03, -.1686D-03, -.1878D-03,
     #    -.2057D-03, -.2218D-03, -.2361D-03, -.2490D-03, -.2613D-03,
     #    -.2741D-03, -.2886D-03, -.3064D-03, -.3289D-03, -.3579D-03,
     #    -.3944D-03, -.4389D-03, -.4895D-03, -.5414D-03, -.5851D-03,
     #    -.6073D-03, -.5946D-03, -.5408D-03, -.4524D-03, -.3489D-03,
     #    -.2524D-03, -.1767D-03, -.1244D-03, -.9029D-04, -.6776D-04,
     #    -.5190D-04, -.3990D-04, -.3044D-04, -.2297D-04, -.1704D-04,
     #    -.1250D-04, -.9105D-05, -.6505D-05, -.4638D-05, -.3305D-05,
     #    -.2372D-05/

      data (calcpts(j,43), j = 1,neta) /-.1880D-06, -.2277D-06,
     #    -.2758D-06, -.3342D-06, -.4049D-06, -.4906D-06, -.5944D-06,
     #    -.7201D-06, -.8723D-06, -.1057D-05, -.1281D-05, -.1551D-05,
     #    -.1879D-05, -.2277D-05, -.2758D-05, -.3342D-05, -.4049D-05,
     #    -.4904D-05, -.5941D-05, -.7196D-05, -.8714D-05, -.1055D-04,
     #    -.1278D-04, -.1546D-04, -.1870D-04, -.2261D-04, -.2729D-04,
     #    -.3291D-04, -.3959D-04, -.4748D-04, -.5669D-04, -.6728D-04,
     #    -.7919D-04, -.9224D-04, -.1060D-03, -.1200D-03, -.1336D-03,
     #    -.1462D-03, -.1573D-03, -.1670D-03, -.1755D-03, -.1833D-03,
     #    -.1910D-03, -.1993D-03, -.2093D-03, -.2217D-03, -.2379D-03,
     #    -.2588D-03, -.2852D-03, -.3172D-03, -.3537D-03, -.3909D-03,
     #    -.4218D-03, -.4371D-03, -.4269D-03, -.3872D-03, -.3228D-03,
     #    -.2480D-03, -.1787D-03, -.1247D-03, -.8754D-04, -.6341D-04,
     #    -.4755D-04, -.3642D-04, -.2802D-04, -.2135D-04, -.1609D-04,
     #    -.1195D-04, -.8754D-05, -.6354D-05, -.4554D-05, -.3288D-05,
     #    -.2288D-05/

      data (calcpts(j,44), j = 1,neta) /-.1338D-06, -.1621D-06,
     #    -.1963D-06, -.2378D-06, -.2880D-06, -.3489D-06, -.4227D-06,
     #    -.5121D-06, -.6204D-06, -.7516D-06, -.9106D-06, -.1103D-05,
     #    -.1337D-05, -.1619D-05, -.1961D-05, -.2376D-05, -.2879D-05,
     #    -.3488D-05, -.4225D-05, -.5117D-05, -.6197D-05, -.7504D-05,
     #    -.9086D-05, -.1100D-04, -.1330D-04, -.1608D-04, -.1941D-04,
     #    -.2340D-04, -.2815D-04, -.3376D-04, -.4031D-04, -.4784D-04,
     #    -.5630D-04, -.6557D-04, -.7537D-04, -.8529D-04, -.9487D-04,
     #    -.1037D-03, -.1115D-03, -.1182D-03, -.1238D-03, -.1288D-03,
     #    -.1335D-03, -.1384D-03, -.1439D-03, -.1508D-03, -.1596D-03,
     #    -.1712D-03, -.1863D-03, -.2053D-03, -.2284D-03, -.2546D-03,
     #    -.2812D-03, -.3031D-03, -.3135D-03, -.3057D-03, -.2764D-03,
     #    -.2298D-03, -.1760D-03, -.1263D-03, -.8785D-04, -.6152D-04,
     #    -.4446D-04, -.3332D-04, -.2552D-04, -.1959D-04, -.1499D-04,
     #    -.1126D-04, -.8392D-05, -.6126D-05, -.4459D-05, -.3193D-05,
     #    -.2259D-05/

      data (calcpts(j,45), j = 1,neta) /-.9473D-07, -.1149D-06,
     #    -.1392D-06, -.1688D-06, -.2045D-06, -.2477D-06, -.3001D-06,
     #    -.3636D-06, -.4404D-06, -.5337D-06, -.6466D-06, -.7833D-06,
     #    -.9490D-06, -.1150D-05, -.1393D-05, -.1687D-05, -.2044D-05,
     #    -.2476D-05, -.3000D-05, -.3634D-05, -.4400D-05, -.5328D-05,
     #    -.6451D-05, -.7807D-05, -.9444D-05, -.1142D-04, -.1378D-04,
     #    -.1662D-04, -.1999D-04, -.2397D-04, -.2862D-04, -.3397D-04,
     #    -.3997D-04, -.4655D-04, -.5350D-04, -.6052D-04, -.6730D-04,
     #    -.7351D-04, -.7896D-04, -.8357D-04, -.8742D-04, -.9068D-04,
     #    -.9360D-04, -.9648D-04, -.9962D-04, -.1034D-03, -.1082D-03,
     #    -.1145D-03, -.1228D-03, -.1336D-03, -.1473D-03, -.1640D-03,
     #    -.1827D-03, -.2017D-03, -.2172D-03, -.2243D-03, -.2184D-03,
     #    -.1970D-03, -.1634D-03, -.1247D-03, -.8922D-04, -.6185D-04,
     #    -.4319D-04, -.3121D-04, -.2337D-04, -.1791D-04, -.1377D-04,
     #    -.1051D-04, -.7907D-05, -.5907D-05, -.4307D-05, -.3107D-05,
     #    -.2241D-05/

      data (calcpts(j,46), j = 1,neta) /-.6701D-07, -.8119D-07,
     #    -.9870D-07, -.1195D-06, -.1447D-06, -.1754D-06, -.2127D-06,
     #    -.2576D-06, -.3120D-06, -.3781D-06, -.4581D-06, -.5551D-06,
     #    -.6724D-06, -.8147D-06, -.9868D-06, -.1196D-05, -.1449D-05,
     #    -.1755D-05, -.2125D-05, -.2575D-05, -.3118D-05, -.3776D-05,
     #    -.4571D-05, -.5532D-05, -.6691D-05, -.8089D-05, -.9765D-05,
     #    -.1177D-04, -.1416D-04, -.1699D-04, -.2028D-04, -.2407D-04,
     #    -.2832D-04, -.3298D-04, -.3790D-04, -.4286D-04, -.4765D-04,
     #    -.5203D-04, -.5584D-04, -.5904D-04, -.6167D-04, -.6384D-04,
     #    -.6570D-04, -.6744D-04, -.6924D-04, -.7133D-04, -.7392D-04,
     #    -.7731D-04, -.8181D-04, -.8777D-04, -.9555D-04, -.1054D-03,
     #    -.1173D-03, -.1308D-03, -.1443D-03, -.1552D-03, -.1602D-03,
     #    -.1556D-03, -.1401D-03, -.1158D-03, -.8818D-04, -.6290D-04,
     #    -.4347D-04, -.3029D-04, -.2185D-04, -.1636D-04, -.1252D-04,
     #    -.9628D-05, -.7341D-05, -.5528D-05, -.4108D-05, -.3008D-05,
     #    -.2181D-05/

      data (calcpts(j,47), j = 1,neta) /-.4757D-07, -.5758D-07,
     #    -.6968D-07, -.8450D-07, -.1024D-06, -.1242D-06, -.1503D-06,
     #    -.1822D-06, -.2207D-06, -.2675D-06, -.3240D-06, -.3926D-06,
     #    -.4757D-06, -.5763D-06, -.6981D-06, -.8458D-06, -.1025D-05,
     #    -.1241D-05, -.1504D-05, -.1821D-05, -.2206D-05, -.2671D-05,
     #    -.3234D-05, -.3913D-05, -.4734D-05, -.5722D-05, -.6908D-05,
     #    -.8329D-05, -.1002D-04, -.1202D-04, -.1435D-04, -.1702D-04,
     #    -.2003D-04, -.2333D-04, -.2680D-04, -.3031D-04, -.3369D-04,
     #    -.3677D-04, -.3945D-04, -.4168D-04, -.4349D-04, -.4495D-04,
     #    -.4616D-04, -.4724D-04, -.4829D-04, -.4945D-04, -.5086D-04,
     #    -.5267D-04, -.5507D-04, -.5828D-04, -.6256D-04, -.6814D-04,
     #    -.7521D-04, -.8374D-04, -.9332D-04, -.1029D-03, -.1107D-03,
     #    -.1141D-03, -.1106D-03, -.9943D-04, -.8204D-04, -.6228D-04,
     #    -.4429D-04, -.3052D-04, -.2122D-04, -.1528D-04, -.1143D-04,
     #    -.8745D-05, -.6726D-05, -.5126D-05, -.3859D-05, -.2859D-05,
     #    -.2092D-05/

      data (calcpts(j,48), j = 1,neta) /-.3318D-07, -.4036D-07,
     #    -.4933D-07, -.5977D-07, -.7242D-07, -.8763D-07, -.1062D-06,
     #    -.1288D-06, -.1559D-06, -.1890D-06, -.2290D-06, -.2774D-06,
     #    -.3361D-06, -.4072D-06, -.4933D-06, -.5976D-06, -.7240D-06,
     #    -.8771D-06, -.1062D-05, -.1287D-05, -.1558D-05, -.1887D-05,
     #    -.2285D-05, -.2765D-05, -.3345D-05, -.4043D-05, -.4881D-05,
     #    -.5885D-05, -.7080D-05, -.8490D-05, -.1014D-04, -.1203D-04,
     #    -.1415D-04, -.1648D-04, -.1893D-04, -.2141D-04, -.2379D-04,
     #    -.2597D-04, -.2785D-04, -.2941D-04, -.3066D-04, -.3166D-04,
     #    -.3246D-04, -.3313D-04, -.3376D-04, -.3442D-04, -.3519D-04,
     #    -.3615D-04, -.3743D-04, -.3914D-04, -.4144D-04, -.4450D-04,
     #    -.4849D-04, -.5354D-04, -.5964D-04, -.6647D-04, -.7329D-04,
     #    -.7875D-04, -.8108D-04, -.7854D-04, -.7046D-04, -.5801D-04,
     #    -.4393D-04, -.3116D-04, -.2142D-04, -.1486D-04, -.1069D-04,
     #    -.7993D-05, -.6113D-05, -.4700D-05, -.3586D-05, -.2700D-05,
     #    -.2000D-05/

      data (calcpts(j,49), j = 1,neta) /-.2387D-07, -.2858D-07,
     #    -.3511D-07, -.4218D-07, -.5120D-07, -.6191D-07, -.7500D-07,
     #    -.9087D-07, -.1101D-06, -.1334D-06, -.1616D-06, -.1957D-06,
     #    -.2372D-06, -.2873D-06, -.3480D-06, -.4217D-06, -.5109D-06,
     #    -.6189D-06, -.7496D-06, -.9081D-06, -.1100D-05, -.1332D-05,
     #    -.1612D-05, -.1951D-05, -.2360D-05, -.2853D-05, -.3444D-05,
     #    -.4152D-05, -.4995D-05, -.5990D-05, -.7151D-05, -.8486D-05,
     #    -.9986D-05, -.1163D-04, -.1336D-04, -.1510D-04, -.1678D-04,
     #    -.1831D-04, -.1963D-04, -.2073D-04, -.2160D-04, -.2228D-04,
     #    -.2282D-04, -.2326D-04, -.2364D-04, -.2402D-04, -.2445D-04,
     #    -.2496D-04, -.2563D-04, -.2653D-04, -.2775D-04, -.2939D-04,
     #    -.3159D-04, -.3444D-04, -.3805D-04, -.4239D-04, -.4725D-04,
     #    -.5208D-04, -.5593D-04, -.5753D-04, -.5566D-04, -.4986D-04,
     #    -.4097D-04, -.3095D-04, -.2190D-04, -.1502D-04, -.1040D-04,
     #    -.7471D-05, -.5584D-05, -.4271D-05, -.3284D-05, -.2504D-05,
     #    -.1884D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1_ALg = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     ========================================
      double precision function h1_FLg(eta,xi)
c     ========================================

c     eq (10) in PLB347 (1995) 143 - 151 for the longitudinal piece
c     MSbar scheme
c     This routine is called subclcf in the original code.
c     Called sclcf in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /-.1526D-12, -.3323D-12,
     #    -.3907D-12, -.6839D-12, -.1600D-11, -.3278D-11, -.4479D-11,
     #    -.9221D-11, -.1419D-10, -.2587D-10, -.4799D-10, -.7559D-10,
     #    -.1451D-09, -.2621D-09, -.4500D-09, -.8116D-09, -.1474D-08,
     #    -.2638D-08, -.4581D-08, -.8208D-08, -.1447D-07, -.2578D-07,
     #    -.4622D-07, -.8126D-07, -.1450D-06, -.2590D-06, -.4588D-06,
     #    -.8141D-06, -.1438D-05, -.2515D-05, -.4340D-05, -.7316D-05,
     #    -.1190D-04, -.1839D-04, -.2652D-04, -.3509D-04, -.4205D-04,
     #    -.4536D-04, -.4420D-04, -.3927D-04, -.3230D-04, -.2498D-04,
     #    -.1844D-04, -.1315D-04, -.9162D-05, -.6272D-05, -.4243D-05,
     #    -.2849D-05, -.1902D-05, -.1265D-05, -.8396D-06, -.5559D-06,
     #    -.3675D-06, -.2427D-06, -.1601D-06, -.1055D-06, -.6950D-07,
     #    -.4569D-07, -.3001D-07, -.1968D-07, -.1290D-07, -.8435D-08,
     #    -.5514D-08, -.3594D-08, -.4557D-08, -.3116D-08, -.2128D-08,
     #    -.1452D-08, -.9914D-09, -.6763D-09, -.4610D-09, -.3142D-09,
     #    -.2142D-09/

      data (calcpts(j, 2), j = 1,neta) /-.1979D-12, -.6116D-12,
     #    -.5642D-12, -.1280D-11, -.3041D-11, -.3966D-11, -.7910D-11,
     #    -.1347D-10, -.2032D-10, -.3911D-10, -.7392D-10, -.1265D-09,
     #    -.2222D-09, -.4048D-09, -.6812D-09, -.1207D-08, -.2240D-08,
     #    -.3794D-08, -.6782D-08, -.1216D-07, -.2132D-07, -.3805D-07,
     #    -.6763D-07, -.1202D-06, -.2143D-06, -.3812D-06, -.6731D-06,
     #    -.1196D-05, -.2112D-05, -.3695D-05, -.6377D-05, -.1074D-04,
     #    -.1746D-04, -.2699D-04, -.3893D-04, -.5150D-04, -.6170D-04,
     #    -.6657D-04, -.6486D-04, -.5763D-04, -.4739D-04, -.3665D-04,
     #    -.2706D-04, -.1930D-04, -.1345D-04, -.9205D-05, -.6227D-05,
     #    -.4180D-05, -.2791D-05, -.1856D-05, -.1232D-05, -.8156D-06,
     #    -.5392D-06, -.3562D-06, -.2349D-06, -.1548D-06, -.1020D-06,
     #    -.6705D-07, -.4403D-07, -.2888D-07, -.1893D-07, -.1238D-07,
     #    -.8090D-08, -.5273D-08, -.3429D-08, -.4572D-08, -.3123D-08,
     #    -.2131D-08, -.1455D-08, -.9921D-09, -.6764D-09, -.4611D-09,
     #    -.3143D-09/

      data (calcpts(j, 3), j = 1,neta) /-.2047D-12, -.4402D-12,
     #    -.5594D-12, -.1213D-11, -.3449D-11, -.4707D-11, -.9446D-11,
     #    -.1768D-10, -.2612D-10, -.5612D-10, -.9231D-10, -.1774D-09,
     #    -.3093D-09, -.5600D-09, -.9492D-09, -.1660D-08, -.3105D-08,
     #    -.5504D-08, -.9882D-08, -.1767D-07, -.3091D-07, -.5602D-07,
     #    -.9938D-07, -.1750D-06, -.3126D-06, -.5560D-06, -.9846D-06,
     #    -.1747D-05, -.3092D-05, -.5405D-05, -.9329D-05, -.1574D-04,
     #    -.2559D-04, -.3955D-04, -.5706D-04, -.7550D-04, -.9047D-04,
     #    -.9761D-04, -.9510D-04, -.8452D-04, -.6949D-04, -.5375D-04,
     #    -.3968D-04, -.2830D-04, -.1972D-04, -.1350D-04, -.9131D-05,
     #    -.6129D-05, -.4092D-05, -.2721D-05, -.1806D-05, -.1196D-05,
     #    -.7903D-06, -.5220D-06, -.3444D-06, -.2268D-06, -.1495D-06,
     #    -.9828D-07, -.6453D-07, -.4234D-07, -.2774D-07, -.1814D-07,
     #    -.1186D-07, -.7726D-08, -.5024D-08, -.3262D-08, -.4580D-08,
     #    -.3126D-08, -.2133D-08, -.1455D-08, -.9916D-09, -.6762D-09,
     #    -.4608D-09/

      data (calcpts(j, 4), j = 1,neta) /-.3980D-12, -.9437D-12,
     #    -.1372D-11, -.2820D-11, -.4058D-11, -.7437D-11, -.1433D-10,
     #    -.2712D-10, -.4303D-10, -.7171D-10, -.1424D-09, -.2625D-09,
     #    -.4584D-09, -.8241D-09, -.1411D-08, -.2519D-08, -.4554D-08,
     #    -.8235D-08, -.1450D-07, -.2605D-07, -.4624D-07, -.8090D-07,
     #    -.1457D-06, -.2586D-06, -.4593D-06, -.8177D-06, -.1447D-05,
     #    -.2562D-05, -.4530D-05, -.7931D-05, -.1368D-04, -.2309D-04,
     #    -.3753D-04, -.5802D-04, -.8370D-04, -.1107D-03, -.1327D-03,
     #    -.1432D-03, -.1395D-03, -.1240D-03, -.1019D-03, -.7884D-04,
     #    -.5820D-04, -.4152D-04, -.2892D-04, -.1980D-04, -.1339D-04,
     #    -.8990D-05, -.6002D-05, -.3991D-05, -.2649D-05, -.1754D-05,
     #    -.1159D-05, -.7655D-06, -.5050D-06, -.3328D-06, -.2192D-06,
     #    -.1441D-06, -.9463D-07, -.6208D-07, -.4067D-07, -.2659D-07,
     #    -.1738D-07, -.1133D-07, -.7365D-08, -.4782D-08, -.3097D-08,
     #    -.4585D-08, -.3129D-08, -.2134D-08, -.1454D-08, -.9915D-09,
     #    -.6759D-09/

      data (calcpts(j, 5), j = 1,neta) /-.8492D-12, -.1819D-11,
     #    -.1594D-11, -.4321D-11, -.7149D-11, -.1278D-10, -.2327D-10,
     #    -.4772D-10, -.5993D-10, -.1160D-09, -.2318D-09, -.3877D-09,
     #    -.6909D-09, -.1180D-08, -.2148D-08, -.3792D-08, -.6799D-08,
     #    -.1217D-07, -.2153D-07, -.3862D-07, -.6690D-07, -.1197D-06,
     #    -.2149D-06, -.3801D-06, -.6744D-06, -.1203D-05, -.2123D-05,
     #    -.3762D-05, -.6655D-05, -.1164D-04, -.2008D-04, -.3386D-04,
     #    -.5505D-04, -.8509D-04, -.1227D-03, -.1624D-03, -.1945D-03,
     #    -.2099D-03, -.2045D-03, -.1818D-03, -.1495D-03, -.1156D-03,
     #    -.8534D-04, -.6087D-04, -.4240D-04, -.2902D-04, -.1963D-04,
     #    -.1318D-04, -.8800D-05, -.5851D-05, -.3883D-05, -.2571D-05,
     #    -.1699D-05, -.1122D-05, -.7403D-06, -.4877D-06, -.3213D-06,
     #    -.2112D-06, -.1387D-06, -.9099D-07, -.5960D-07, -.3897D-07,
     #    -.2547D-07, -.1659D-07, -.1079D-07, -.7007D-08, -.4537D-08,
     #    -.2929D-08, -.4588D-08, -.3128D-08, -.2132D-08, -.1454D-08,
     #    -.9910D-09/

      data (calcpts(j, 6), j = 1,neta) /-.1553D-11, -.2541D-11,
     #    -.1878D-11, -.5611D-11, -.1141D-10, -.1789D-10, -.3021D-10,
     #    -.5472D-10, -.9229D-10, -.1729D-09, -.3173D-09, -.5690D-09,
     #    -.1020D-08, -.1828D-08, -.3025D-08, -.5610D-08, -.9985D-08,
     #    -.1771D-07, -.3101D-07, -.5642D-07, -.9798D-07, -.1758D-06,
     #    -.3135D-06, -.5555D-06, -.9859D-06, -.1752D-05, -.3104D-05,
     #    -.5519D-05, -.9739D-05, -.1703D-04, -.2940D-04, -.4958D-04,
     #    -.8056D-04, -.1245D-03, -.1798D-03, -.2378D-03, -.2849D-03,
     #    -.3075D-03, -.2996D-03, -.2663D-03, -.2190D-03, -.1694D-03,
     #    -.1250D-03, -.8919D-04, -.6212D-04, -.4252D-04, -.2876D-04,
     #    -.1931D-04, -.1289D-04, -.8570D-05, -.5687D-05, -.3765D-05,
     #    -.2488D-05, -.1643D-05, -.1084D-05, -.7140D-06, -.4703D-06,
     #    -.3092D-06, -.2030D-06, -.1332D-06, -.8723D-07, -.5703D-07,
     #    -.3726D-07, -.2427D-07, -.1579D-07, -.1025D-07, -.6635D-08,
     #    -.4282D-08, -.2759D-08, -.4583D-08, -.3124D-08, -.2130D-08,
     #    -.1452D-08/

      data (calcpts(j, 7), j = 1,neta) /-.1951D-11, -.3023D-11,
     #    -.3552D-11, -.6768D-11, -.1542D-10, -.3304D-10, -.4905D-10,
     #    -.8922D-10, -.1383D-09, -.2580D-09, -.4742D-09, -.7587D-09,
     #    -.1494D-08, -.2591D-08, -.4467D-08, -.8113D-08, -.1468D-07,
     #    -.2642D-07, -.4627D-07, -.8186D-07, -.1445D-06, -.2566D-06,
     #    -.4593D-06, -.8145D-06, -.1443D-05, -.2580D-05, -.4555D-05,
     #    -.8069D-05, -.1426D-04, -.2494D-04, -.4300D-04, -.7255D-04,
     #    -.1179D-03, -.1822D-03, -.2629D-03, -.3479D-03, -.4170D-03,
     #    -.4500D-03, -.4386D-03, -.3898D-03, -.3205D-03, -.2479D-03,
     #    -.1830D-03, -.1305D-03, -.9092D-04, -.6223D-04, -.4210D-04,
     #    -.2826D-04, -.1886D-04, -.1254D-04, -.8322D-05, -.5508D-05,
     #    -.3640D-05, -.2404D-05, -.1585D-05, -.1044D-05, -.6877D-06,
     #    -.4521D-06, -.2967D-06, -.1947D-06, -.1275D-06, -.8334D-07,
     #    -.5444D-07, -.3546D-07, -.2305D-07, -.1496D-07, -.9679D-08,
     #    -.6249D-08, -.4026D-08, -.2581D-08, -.4573D-08, -.3117D-08,
     #    -.2125D-08/

      data (calcpts(j, 8), j = 1,neta) /-.3202D-11, -.4660D-11,
     #    -.6771D-11, -.1185D-10, -.2005D-10, -.3729D-10, -.7634D-10,
     #    -.1351D-09, -.2145D-09, -.3817D-09, -.7858D-09, -.1241D-08,
     #    -.2195D-08, -.3904D-08, -.6628D-08, -.1198D-07, -.2138D-07,
     #    -.3774D-07, -.6762D-07, -.1203D-06, -.2116D-06, -.3773D-06,
     #    -.6675D-06, -.1188D-05, -.2118D-05, -.3769D-05, -.6672D-05,
     #    -.1182D-04, -.2086D-04, -.3649D-04, -.6290D-04, -.1060D-03,
     #    -.1724D-03, -.2665D-03, -.3843D-03, -.5086D-03, -.6095D-03,
     #    -.6578D-03, -.6413D-03, -.5699D-03, -.4687D-03, -.3625D-03,
     #    -.2676D-03, -.1909D-03, -.1329D-03, -.9100D-04, -.6154D-04,
     #    -.4130D-04, -.2757D-04, -.1833D-04, -.1216D-04, -.8049D-05,
     #    -.5319D-05, -.3511D-05, -.2316D-05, -.1525D-05, -.1004D-05,
     #    -.6600D-06, -.4332D-06, -.2840D-06, -.1861D-06, -.1216D-06,
     #    -.7942D-07, -.5172D-07, -.3361D-07, -.2180D-07, -.1412D-07,
     #    -.9108D-08, -.5862D-08, -.3756D-08, -.2397D-08, -.4558D-08,
     #    -.3106D-08/

      data (calcpts(j, 9), j = 1,neta) /-.2020D-11, -.5453D-11,
     #    -.5060D-11, -.1092D-10, -.3336D-10, -.5003D-10, -.9420D-10,
     #    -.1724D-09, -.2710D-09, -.5493D-09, -.9121D-09, -.1654D-08,
     #    -.2942D-08, -.5559D-08, -.9296D-08, -.1649D-07, -.3097D-07,
     #    -.5391D-07, -.9745D-07, -.1736D-06, -.3048D-06, -.5456D-06,
     #    -.9811D-06, -.1731D-05, -.3082D-05, -.5485D-05, -.9689D-05,
     #    -.1719D-04, -.3034D-04, -.5312D-04, -.9155D-04, -.1544D-03,
     #    -.2510D-03, -.3881D-03, -.5599D-03, -.7412D-03, -.8885D-03,
     #    -.9592D-03, -.9351D-03, -.8313D-03, -.6838D-03, -.5289D-03,
     #    -.3904D-03, -.2785D-03, -.1939D-03, -.1327D-03, -.8974D-04,
     #    -.6022D-04, -.4019D-04, -.2671D-04, -.1772D-04, -.1173D-04,
     #    -.7748D-05, -.5113D-05, -.3372D-05, -.2221D-05, -.1462D-05,
     #    -.9603D-06, -.6301D-06, -.4131D-06, -.2704D-06, -.1766D-06,
     #    -.1153D-06, -.7510D-07, -.4878D-07, -.3163D-07, -.2046D-07,
     #    -.1318D-07, -.8481D-08, -.5434D-08, -.3464D-08, -.2200D-08,
     #    -.4531D-08/

      data (calcpts(j,10), j = 1,neta) /-.4329D-11, -.8017D-11,
     #    -.1468D-10, -.1912D-10, -.4450D-10, -.7630D-10, -.1318D-09,
     #    -.2570D-09, -.4401D-09, -.7766D-09, -.1464D-08, -.2495D-08,
     #    -.4473D-08, -.8107D-08, -.1423D-07, -.2431D-07, -.4600D-07,
     #    -.7971D-07, -.1427D-06, -.2553D-06, -.4500D-06, -.8034D-06,
     #    -.1424D-05, -.2529D-05, -.4495D-05, -.7996D-05, -.1418D-04,
     #    -.2511D-04, -.4424D-04, -.7734D-04, -.1333D-03, -.2246D-03,
     #    -.3650D-03, -.5643D-03, -.8141D-03, -.1078D-02, -.1292D-02,
     #    -.1396D-02, -.1361D-02, -.1210D-02, -.9954D-03, -.7700D-03,
     #    -.5684D-03, -.4053D-03, -.2823D-03, -.1931D-03, -.1306D-03,
     #    -.8760D-04, -.5845D-04, -.3884D-04, -.2576D-04, -.1704D-04,
     #    -.1125D-04, -.7428D-05, -.4896D-05, -.3223D-05, -.2121D-05,
     #    -.1393D-05, -.9137D-06, -.5988D-06, -.3918D-06, -.2558D-06,
     #    -.1670D-06, -.1086D-06, -.7052D-07, -.4570D-07, -.2953D-07,
     #    -.1901D-07, -.1223D-07, -.7824D-08, -.4982D-08, -.3159D-08,
     #    -.1992D-08/

      data (calcpts(j,11), j = 1,neta) /-.7740D-11, -.1319D-10,
     #    -.1127D-10, -.3932D-10, -.7316D-10, -.1185D-09, -.2253D-09,
     #    -.4273D-09, -.7028D-09, -.1122D-08, -.2186D-08, -.3787D-08,
     #    -.6692D-08, -.1282D-07, -.2105D-07, -.3761D-07, -.6681D-07,
     #    -.1181D-06, -.2093D-06, -.3678D-06, -.6528D-06, -.1171D-05,
     #    -.2076D-05, -.3676D-05, -.6540D-05, -.1168D-04, -.2046D-04,
     #    -.3634D-04, -.6416D-04, -.1120D-03, -.1930D-03, -.3253D-03,
     #    -.5284D-03, -.8167D-03, -.1178D-02, -.1560D-02, -.1872D-02,
     #    -.2022D-02, -.1973D-02, -.1755D-02, -.1444D-02, -.1117D-02,
     #    -.8243D-03, -.5878D-03, -.4092D-03, -.2799D-03, -.1892D-03,
     #    -.1269D-03, -.8463D-04, -.5622D-04, -.3727D-04, -.2465D-04,
     #    -.1627D-04, -.1073D-04, -.7072D-05, -.4653D-05, -.3060D-05,
     #    -.2009D-05, -.1317D-05, -.8626D-06, -.5641D-06, -.3682D-06,
     #    -.2400D-06, -.1560D-06, -.1012D-06, -.6552D-07, -.4230D-07,
     #    -.2721D-07, -.1746D-07, -.1116D-07, -.7094D-08, -.4488D-08,
     #    -.2823D-08/

      data (calcpts(j,12), j = 1,neta) /-.5151D-11, -.2014D-10,
     #    -.2631D-10, -.4695D-10, -.1052D-09, -.1791D-09, -.3485D-09,
     #    -.6448D-09, -.8489D-09, -.1639D-08, -.3087D-08, -.5399D-08,
     #    -.9179D-08, -.1779D-07, -.2957D-07, -.5384D-07, -.9629D-07,
     #    -.1688D-06, -.3013D-06, -.5323D-06, -.9346D-06, -.1675D-05,
     #    -.2995D-05, -.5313D-05, -.9461D-05, -.1675D-04, -.2958D-04,
     #    -.5241D-04, -.9238D-04, -.1612D-03, -.2776D-03, -.4674D-03,
     #    -.7593D-03, -.1173D-02, -.1694D-02, -.2243D-02, -.2692D-02,
     #    -.2911D-02, -.2842D-02, -.2528D-02, -.2081D-02, -.1610D-02,
     #    -.1188D-02, -.8472D-03, -.5896D-03, -.4031D-03, -.2724D-03,
     #    -.1826D-03, -.1217D-03, -.8082D-04, -.5355D-04, -.3539D-04,
     #    -.2335D-04, -.1540D-04, -.1014D-04, -.6664D-05, -.4380D-05,
     #    -.2873D-05, -.1881D-05, -.1231D-05, -.8042D-06, -.5242D-06,
     #    -.3414D-06, -.2216D-06, -.1435D-06, -.9286D-07, -.5979D-07,
     #    -.3840D-07, -.2459D-07, -.1567D-07, -.9930D-08, -.6256D-08,
     #    -.3925D-08/

      data (calcpts(j,13), j = 1,neta) /-.1063D-10, -.3297D-10,
     #    -.2997D-10, -.6987D-10, -.1541D-09, -.1764D-09, -.4019D-09,
     #    -.7702D-09, -.1329D-08, -.2305D-08, -.4447D-08, -.7561D-08,
     #    -.1408D-07, -.2476D-07, -.4276D-07, -.7568D-07, -.1385D-06,
     #    -.2503D-06, -.4271D-06, -.7685D-06, -.1350D-05, -.2407D-05,
     #    -.4305D-05, -.7545D-05, -.1347D-04, -.2398D-04, -.4235D-04,
     #    -.7490D-04, -.1318D-03, -.2300D-03, -.3951D-03, -.6661D-03,
     #    -.1080D-02, -.1670D-02, -.2411D-02, -.3195D-02, -.3840D-02,
     #    -.4154D-02, -.4059D-02, -.3614D-02, -.2975D-02, -.2302D-02,
     #    -.1699D-02, -.1211D-02, -.8425D-03, -.5757D-03, -.3887D-03,
     #    -.2604D-03, -.1735D-03, -.1151D-03, -.7620D-04, -.5031D-04,
     #    -.3317D-04, -.2184D-04, -.1437D-04, -.9435D-05, -.6194D-05,
     #    -.4058D-05, -.2655D-05, -.1734D-05, -.1131D-05, -.7362D-06,
     #    -.4786D-06, -.3101D-06, -.2004D-06, -.1293D-06, -.8305D-07,
     #    -.5313D-07, -.3392D-07, -.2152D-07, -.1358D-07, -.8518D-08,
     #    -.5306D-08/

      data (calcpts(j,14), j = 1,neta) /-.2328D-10, -.4109D-10,
     #    -.6336D-10, -.1073D-09, -.2166D-09, -.4000D-09, -.6766D-09,
     #    -.1298D-08, -.1955D-08, -.3561D-08, -.6533D-08, -.1121D-07,
     #    -.1965D-07, -.3564D-07, -.6167D-07, -.1104D-06, -.2020D-06,
     #    -.3533D-06, -.6145D-06, -.1108D-05, -.1935D-05, -.3441D-05,
     #    -.6092D-05, -.1088D-04, -.1924D-04, -.3402D-04, -.5993D-04,
     #    -.1058D-03, -.1861D-03, -.3243D-03, -.5572D-03, -.9357D-03,
     #    -.1517D-02, -.2345D-02, -.3386D-02, -.4491D-02, -.5401D-02,
     #    -.5853D-02, -.5726D-02, -.5103D-02, -.4204D-02, -.3254D-02,
     #    -.2401D-02, -.1710D-02, -.1189D-02, -.8120D-03, -.5478D-03,
     #    -.3666D-03, -.2439D-03, -.1616D-03, -.1069D-03, -.7047D-04,
     #    -.4639D-04, -.3050D-04, -.2003D-04, -.1314D-04, -.8608D-05,
     #    -.5629D-05, -.3675D-05, -.2396D-05, -.1559D-05, -.1012D-05,
     #    -.6559D-06, -.4238D-06, -.2728D-06, -.1752D-06, -.1121D-06,
     #    -.7147D-07, -.4532D-07, -.2857D-07, -.1789D-07, -.1112D-07,
     #    -.6848D-08/

      data (calcpts(j,15), j = 1,neta) /-.1614D-10, -.4985D-10,
     #    -.4193D-10, -.9810D-10, -.3052D-09, -.5043D-09, -.7527D-09,
     #    -.1530D-08, -.2329D-08, -.3894D-08, -.8865D-08, -.1514D-07,
     #    -.2616D-07, -.4793D-07, -.8227D-07, -.1503D-06, -.2650D-06,
     #    -.4862D-06, -.8500D-06, -.1523D-05, -.2672D-05, -.4765D-05,
     #    -.8445D-05, -.1498D-04, -.2667D-04, -.4723D-04, -.8297D-04,
     #    -.1465D-03, -.2575D-03, -.4472D-03, -.7674D-03, -.1288D-02,
     #    -.2085D-02, -.3222D-02, -.4654D-02, -.6183D-02, -.7451D-02,
     #    -.8090D-02, -.7929D-02, -.7077D-02, -.5836D-02, -.4518D-02,
     #    -.3333D-02, -.2373D-02, -.1648D-02, -.1124D-02, -.7570D-03,
     #    -.5058D-03, -.3360D-03, -.2222D-03, -.1467D-03, -.9650D-04,
     #    -.6339D-04, -.4159D-04, -.2725D-04, -.1782D-04, -.1165D-04,
     #    -.7591D-05, -.4940D-05, -.3209D-05, -.2080D-05, -.1345D-05,
     #    -.8676D-06, -.5575D-06, -.3569D-06, -.2278D-06, -.1446D-06,
     #    -.9136D-07, -.5733D-07, -.3575D-07, -.2207D-07, -.1349D-07,
     #    -.8146D-08/

      data (calcpts(j,16), j = 1,neta) /-.3779D-10, -.7818D-10,
     #    -.8196D-10, -.1363D-09, -.4489D-09, -.6883D-09, -.1116D-08,
     #    -.2256D-08, -.3465D-08, -.5744D-08, -.1173D-07, -.2133D-07,
     #    -.3697D-07, -.6801D-07, -.1161D-06, -.2106D-06, -.3768D-06,
     #    -.6683D-06, -.1181D-05, -.2105D-05, -.3688D-05, -.6626D-05,
     #    -.1173D-04, -.2059D-04, -.3645D-04, -.6435D-04, -.1129D-03,
     #    -.1981D-03, -.3482D-03, -.6031D-03, -.1029D-02, -.1724D-02,
     #    -.2789D-02, -.4304D-02, -.6223D-02, -.8281D-02, -.1000D-01,
     #    -.1089D-01, -.1071D-01, -.9576D-02, -.7907D-02, -.6124D-02,
     #    -.4516D-02, -.3212D-02, -.2228D-02, -.1516D-02, -.1019D-02,
     #    -.6792D-03, -.4498D-03, -.2967D-03, -.1952D-03, -.1281D-03,
     #    -.8383D-04, -.5480D-04, -.3576D-04, -.2330D-04, -.1516D-04,
     #    -.9831D-05, -.6362D-05, -.4111D-05, -.2647D-05, -.1699D-05,
     #    -.1088D-05, -.6925D-06, -.4388D-06, -.2768D-06, -.1733D-06,
     #    -.1077D-06, -.6648D-07, -.4052D-07, -.2428D-07, -.1431D-07,
     #    -.8243D-08/

      data (calcpts(j,17), j = 1,neta) /-.6224D-10, -.1157D-09,
     #    -.2071D-09, -.2779D-09, -.5111D-09, -.1001D-08, -.1657D-08,
     #    -.3073D-08, -.4998D-08, -.8622D-08, -.1677D-07, -.2878D-07,
     #    -.5099D-07, -.9334D-07, -.1627D-06, -.2805D-06, -.5088D-06,
     #    -.9048D-06, -.1583D-05, -.2830D-05, -.4949D-05, -.8740D-05,
     #    -.1552D-04, -.2748D-04, -.4835D-04, -.8505D-04, -.1485D-03,
     #    -.2604D-03, -.4541D-03, -.7820D-03, -.1333D-02, -.2222D-02,
     #    -.3583D-02, -.5523D-02, -.7988D-02, -.1065D-01, -.1292D-01,
     #    -.1413D-01, -.1394D-01, -.1251D-01, -.1035D-01, -.8017D-02,
     #    -.5909D-02, -.4197D-02, -.2903D-02, -.1970D-02, -.1319D-02,
     #    -.8760D-03, -.5778D-03, -.3793D-03, -.2484D-03, -.1620D-03,
     #    -.1055D-03, -.6854D-04, -.4444D-04, -.2874D-04, -.1856D-04,
     #    -.1194D-04, -.7653D-05, -.4891D-05, -.3114D-05, -.1972D-05,
     #    -.1244D-05, -.7786D-06, -.4830D-06, -.2973D-06, -.1809D-06,
     #    -.1085D-06, -.6401D-07, -.3663D-07, -.2033D-07, -.1066D-07,
     #    -.5102D-08/

      data (calcpts(j,18), j = 1,neta) /-.6221D-10, -.1474D-09,
     #    -.1298D-09, -.3912D-09, -.6718D-09, -.1189D-08, -.2102D-08,
     #    -.4431D-08, -.5705D-08, -.1121D-07, -.2129D-07, -.3646D-07,
     #    -.6552D-07, -.1150D-06, -.1978D-06, -.3621D-06, -.6497D-06,
     #    -.1157D-05, -.2045D-05, -.3569D-05, -.6302D-05, -.1123D-04,
     #    -.1991D-04, -.3492D-04, -.6120D-04, -.1076D-03, -.1863D-03,
     #    -.3256D-03, -.5637D-03, -.9672D-03, -.1635D-02, -.2711D-02,
     #    -.4353D-02, -.6694D-02, -.9686D-02, -.1295D-01, -.1579D-01,
     #    -.1736D-01, -.1723D-01, -.1553D-01, -.1289D-01, -.9997D-02,
     #    -.7362D-02, -.5214D-02, -.3594D-02, -.2427D-02, -.1616D-02,
     #    -.1066D-02, -.6979D-03, -.4545D-03, -.2951D-03, -.1908D-03,
     #    -.1230D-03, -.7906D-04, -.5065D-04, -.3233D-04, -.2058D-04,
     #    -.1301D-04, -.8195D-05, -.5126D-05, -.3183D-05, -.1957D-05,
     #    -.1192D-05, -.7138D-06, -.4200D-06, -.2413D-06, -.1338D-06,
     #    -.7023D-07, -.3388D-07, -.1335D-07, -.2407D-08, 0.2877D-08,
     #    0.4963D-08/

      data (calcpts(j,19), j = 1,neta) /-.7602D-10, -.1220D-09,
     #    -.2737D-09, -.3859D-09, -.9139D-09, -.1511D-08, -.2536D-08,
     #    -.4168D-08, -.7125D-08, -.1412D-07, -.2662D-07, -.4549D-07,
     #    -.8145D-07, -.1415D-06, -.2551D-06, -.4471D-06, -.7992D-06,
     #    -.1408D-05, -.2494D-05, -.4496D-05, -.7735D-05, -.1362D-04,
     #    -.2398D-04, -.4201D-04, -.7350D-04, -.1277D-03, -.2213D-03,
     #    -.3840D-03, -.6589D-03, -.1119D-02, -.1875D-02, -.3080D-02,
     #    -.4910D-02, -.7516D-02, -.1087D-01, -.1458D-01, -.1788D-01,
     #    -.1984D-01, -.1985D-01, -.1801D-01, -.1501D-01, -.1166D-01,
     #    -.8571D-02, -.6046D-02, -.4139D-02, -.2772D-02, -.1828D-02,
     #    -.1192D-02, -.7704D-03, -.4946D-03, -.3161D-03, -.2009D-03,
     #    -.1269D-03, -.7981D-04, -.4988D-04, -.3093D-04, -.1903D-04,
     #    -.1158D-04, -.6948D-05, -.4099D-05, -.2360D-05, -.1313D-05,
     #    -.6978D-06, -.3404D-06, -.1395D-06, -.3238D-07, 0.2071D-07,
     #    0.4317D-07, 0.4897D-07, 0.4694D-07, 0.4109D-07, 0.3426D-07,
     #    0.2766D-07/

      data (calcpts(j,20), j = 1,neta) /-.1486D-09, -.2084D-09,
     #    -.2156D-09, -.5165D-09, -.1028D-08, -.1695D-08, -.2959D-08,
     #    -.5026D-08, -.9531D-08, -.1689D-07, -.3069D-07, -.5319D-07,
     #    -.9289D-07, -.1644D-06, -.2927D-06, -.5169D-06, -.9236D-06,
     #    -.1621D-05, -.2863D-05, -.5112D-05, -.8725D-05, -.1553D-04,
     #    -.2730D-04, -.4743D-04, -.8240D-04, -.1426D-03, -.2449D-03,
     #    -.4185D-03, -.7110D-03, -.1193D-02, -.1971D-02, -.3194D-02,
     #    -.5033D-02, -.7630D-02, -.1101D-01, -.1480D-01, -.1829D-01,
     #    -.2051D-01, -.2077D-01, -.1904D-01, -.1596D-01, -.1242D-01,
     #    -.9104D-02, -.6373D-02, -.4315D-02, -.2845D-02, -.1840D-02,
     #    -.1173D-02, -.7391D-03, -.4604D-03, -.2842D-03, -.1733D-03,
     #    -.1043D-03, -.6193D-04, -.3594D-04, -.2030D-04, -.1104D-04,
     #    -.5610D-05, -.2531D-05, -.8511D-06, 0.3114D-08, 0.4043D-06,
     #    0.5460D-06, 0.5568D-06, 0.5061D-06, 0.4303D-06, 0.3510D-06,
     #    0.2788D-06, 0.2167D-06, 0.1660D-06, 0.1256D-06, 0.9417D-07,
     #    0.6990D-07/

      data (calcpts(j,21), j = 1,neta) /-.5347D-10, -.2247D-09,
     #    -.2536D-09, -.4946D-09, -.1075D-08, -.1854D-08, -.3507D-08,
     #    -.6687D-08, -.9907D-08, -.1667D-07, -.3265D-07, -.5625D-07,
     #    -.9228D-07, -.1809D-06, -.3111D-06, -.5438D-06, -.9714D-06,
     #    -.1708D-05, -.3045D-05, -.5259D-05, -.9173D-05, -.1617D-04,
     #    -.2835D-04, -.4914D-04, -.8478D-04, -.1455D-03, -.2474D-03,
     #    -.4174D-03, -.6997D-03, -.1152D-02, -.1866D-02, -.2962D-02,
     #    -.4565D-02, -.6829D-02, -.9739D-02, -.1308D-01, -.1630D-01,
     #    -.1854D-01, -.1909D-01, -.1776D-01, -.1503D-01, -.1172D-01,
     #    -.8532D-02, -.5885D-02, -.3892D-02, -.2485D-02, -.1542D-02,
     #    -.9325D-03, -.5493D-03, -.3140D-03, -.1730D-03, -.9005D-04,
     #    -.4266D-04, -.1663D-04, -.2895D-05, 0.3602D-05, 0.6205D-05,
     #    0.6783D-05, 0.6345D-05, 0.5478D-05, 0.4528D-05, 0.3614D-05,
     #    0.2823D-05, 0.2169D-05, 0.1646D-05, 0.1236D-05, 0.9190D-06,
     #    0.6792D-06, 0.4982D-06, 0.3639D-06, 0.2646D-06, 0.1917D-06,
     #    0.1382D-06/

      data (calcpts(j,22), j = 1,neta) /-.1087D-09, -.2056D-09,
     #    -.2857D-09, -.4519D-09, -.1035D-08, -.1817D-08, -.3161D-08,
     #    -.6500D-08, -.8736D-08, -.1626D-07, -.3079D-07, -.5446D-07,
     #    -.9652D-07, -.1794D-06, -.3003D-06, -.5267D-06, -.9420D-06,
     #    -.1654D-05, -.2896D-05, -.5136D-05, -.8853D-05, -.1543D-04,
     #    -.2682D-04, -.4618D-04, -.7917D-04, -.1347D-03, -.2258D-03,
     #    -.3773D-03, -.6192D-03, -.9964D-03, -.1572D-02, -.2419D-02,
     #    -.3614D-02, -.5217D-02, -.7271D-02, -.9648D-02, -.1207D-01,
     #    -.1397D-01, -.1470D-01, -.1397D-01, -.1198D-01, -.9338D-02,
     #    -.6697D-02, -.4463D-02, -.2789D-02, -.1633D-02, -.8906D-03,
     #    -.4390D-03, -.1801D-03, -.4064D-04, 0.2741D-04, 0.5574D-04,
     #    0.6281D-04, 0.5925D-04, 0.5137D-04, 0.4233D-04, 0.3375D-04,
     #    0.2630D-04, 0.2016D-04, 0.1524D-04, 0.1141D-04, 0.8462D-05,
     #    0.6232D-05, 0.4565D-05, 0.3327D-05, 0.2415D-05, 0.1745D-05,
     #    0.1257D-05, 0.9025D-06, 0.6467D-06, 0.4621D-06, 0.3295D-06,
     #    0.2345D-06/

      data (calcpts(j,23), j = 1,neta) /-.7139D-10, -.2032D-09,
     #    -.2202D-09, -.4896D-09, -.9366D-09, -.1551D-08, -.2642D-08,
     #    -.4985D-08, -.8101D-08, -.1518D-07, -.2690D-07, -.4750D-07,
     #    -.8275D-07, -.1502D-06, -.2509D-06, -.4601D-06, -.8073D-06,
     #    -.1424D-05, -.2501D-05, -.4335D-05, -.7507D-05, -.1324D-04,
     #    -.2278D-04, -.3909D-04, -.6652D-04, -.1117D-03, -.1864D-03,
     #    -.3059D-03, -.4916D-03, -.7702D-03, -.1172D-02, -.1726D-02,
     #    -.2437D-02, -.3320D-02, -.4357D-02, -.5539D-02, -.6817D-02,
     #    -.7998D-02, -.8679D-02, -.8506D-02, -.7418D-02, -.5731D-02,
     #    -.3914D-02, -.2337D-02, -.1169D-02, -.4055D-03, 0.3533D-04,
     #    0.2515D-03, 0.3307D-03, 0.3336D-03, 0.2995D-03, 0.2522D-03,
     #    0.2037D-03, 0.1599D-03, 0.1229D-03, 0.9307D-04, 0.6966D-04,
     #    0.5164D-04, 0.3801D-04, 0.2780D-04, 0.2022D-04, 0.1464D-04,
     #    0.1056D-04, 0.7597D-05, 0.5449D-05, 0.3897D-05, 0.2780D-05,
     #    0.1980D-05, 0.1407D-05, 0.9980D-06, 0.7070D-06, 0.5001D-06,
     #    0.3532D-06/

      data (calcpts(j,24), j = 1,neta) /-.6663D-10, -.1430D-09,
     #    -.2377D-09, -.3509D-09, -.6307D-09, -.1200D-08, -.2150D-08,
     #    -.3945D-08, -.6802D-08, -.1085D-07, -.2096D-07, -.3674D-07,
     #    -.6488D-07, -.1169D-06, -.1955D-06, -.3622D-06, -.6396D-06,
     #    -.1117D-05, -.1942D-05, -.3415D-05, -.5853D-05, -.1026D-04,
     #    -.1762D-04, -.2996D-04, -.5068D-04, -.8471D-04, -.1387D-03,
     #    -.2242D-03, -.3522D-03, -.5364D-03, -.7826D-03, -.1086D-02,
     #    -.1409D-02, -.1705D-02, -.1925D-02, -.2067D-02, -.2263D-02,
     #    -.2561D-02, -.2916D-02, -.3021D-02, -.2667D-02, -.1883D-02,
     #    -.9116D-03, -.3166D-04, 0.5909D-03, 0.9319D-03, 0.1045D-02,
     #    0.1008D-02, 0.8924D-03, 0.7462D-03, 0.6003D-03, 0.4697D-03,
     #    0.3600D-03, 0.2715D-03, 0.2024D-03, 0.1493D-03, 0.1095D-03,
     #    0.7967D-04, 0.5773D-04, 0.4164D-04, 0.2993D-04, 0.2145D-04,
     #    0.1532D-04, 0.1093D-04, 0.7775D-05, 0.5521D-05, 0.3914D-05,
     #    0.2770D-05, 0.1958D-05, 0.1382D-05, 0.9741D-06, 0.6859D-06,
     #    0.4824D-06/

      data (calcpts(j,25), j = 1,neta) /-.4096D-10, -.1024D-09,
     #    -.1250D-09, -.3239D-09, -.5429D-09, -.8035D-09, -.1449D-08,
     #    -.2800D-08, -.4499D-08, -.7629D-08, -.1569D-07, -.2552D-07,
     #    -.4639D-07, -.8264D-07, -.1419D-06, -.2453D-06, -.4483D-06,
     #    -.7893D-06, -.1374D-05, -.2390D-05, -.4106D-05, -.7060D-05,
     #    -.1218D-04, -.2085D-04, -.3488D-04, -.5793D-04, -.9397D-04,
     #    -.1492D-03, -.2306D-03, -.3418D-03, -.4774D-03, -.6178D-03,
     #    -.7062D-03, -.6706D-03, -.4351D-03, 0.5732D-05, 0.5147D-03,
     #    0.8986D-03, 0.1007D-02, 0.9469D-03, 0.9506D-03, 0.1159D-02,
     #    0.1518D-02, 0.1865D-02, 0.2064D-02, 0.2073D-02, 0.1925D-02,
     #    0.1681D-02, 0.1401D-02, 0.1126D-02, 0.8806D-03, 0.6745D-03,
     #    0.5082D-03, 0.3782D-03, 0.2785D-03, 0.2036D-03, 0.1479D-03,
     #    0.1069D-03, 0.7687D-04, 0.5511D-04, 0.3939D-04, 0.2808D-04,
     #    0.1997D-04, 0.1418D-04, 0.1005D-04, 0.7106D-05, 0.5020D-05,
     #    0.3543D-05, 0.2496D-05, 0.1757D-05, 0.1235D-05, 0.8675D-06,
     #    0.6088D-06/

      data (calcpts(j,26), j = 1,neta) /-.2490D-10, -.4478D-10,
     #    -.7078D-10, -.1422D-09, -.2641D-09, -.4349D-09, -.8422D-09,
     #    -.1633D-08, -.2776D-08, -.5104D-08, -.9995D-08, -.1603D-07,
     #    -.2874D-07, -.5237D-07, -.8911D-07, -.1598D-06, -.2803D-06,
     #    -.5038D-06, -.8796D-06, -.1533D-05, -.2617D-05, -.4537D-05,
     #    -.7801D-05, -.1317D-04, -.2206D-04, -.3644D-04, -.5860D-04,
     #    -.9246D-04, -.1406D-03, -.2029D-03, -.2731D-03, -.3271D-03,
     #    -.3154D-03, -.1690D-03, 0.1905D-03, 0.7872D-03, 0.1531D-02,
     #    0.2217D-02, 0.2644D-02, 0.2781D-02, 0.2773D-02, 0.2790D-02,
     #    0.2883D-02, 0.2974D-02, 0.2965D-02, 0.2807D-02, 0.2523D-02,
     #    0.2162D-02, 0.1780D-02, 0.1420D-02, 0.1104D-02, 0.8416D-03,
     #    0.6316D-03, 0.4681D-03, 0.3436D-03, 0.2503D-03, 0.1812D-03,
     #    0.1305D-03, 0.9363D-04, 0.6694D-04, 0.4772D-04, 0.3394D-04,
     #    0.2408D-04, 0.1706D-04, 0.1206D-04, 0.8518D-05, 0.6007D-05,
     #    0.4231D-05, 0.2976D-05, 0.2092D-05, 0.1468D-05, 0.1030D-05,
     #    0.7222D-06/

      data (calcpts(j,27), j = 1,neta) /-.1861D-10, -.4714D-10,
     #    -.5830D-10, -.1150D-09, -.2267D-09, -.3674D-09, -.6322D-09,
     #    -.1213D-08, -.1915D-08, -.3361D-08, -.6083D-08, -.1054D-07,
     #    -.1793D-07, -.3229D-07, -.5634D-07, -.9872D-07, -.1754D-06,
     #    -.3049D-06, -.5304D-06, -.9291D-06, -.1583D-05, -.2729D-05,
     #    -.4670D-05, -.7874D-05, -.1317D-04, -.2164D-04, -.3451D-04,
     #    -.5416D-04, -.8138D-04, -.1156D-03, -.1509D-03, -.1696D-03,
     #    -.1364D-03, 0.1381D-05, 0.3043D-03, 0.8057D-03, 0.1457D-02,
     #    0.2117D-02, 0.2619D-02, 0.2886D-02, 0.2985D-02, 0.3045D-02,
     #    0.3136D-02, 0.3219D-02, 0.3210D-02, 0.3060D-02, 0.2775D-02,
     #    0.2400D-02, 0.1996D-02, 0.1603D-02, 0.1254D-02, 0.9594D-03,
     #    0.7220D-03, 0.5360D-03, 0.3939D-03, 0.2869D-03, 0.2078D-03,
     #    0.1496D-03, 0.1072D-03, 0.7659D-04, 0.5455D-04, 0.3875D-04,
     #    0.2748D-04, 0.1944D-04, 0.1374D-04, 0.9692D-05, 0.6829D-05,
     #    0.4805D-05, 0.3378D-05, 0.2372D-05, 0.1665D-05, 0.1167D-05,
     #    0.8173D-06/

      data (calcpts(j,28), j = 1,neta) /-.1221D-10, -.1892D-10,
     #    -.3565D-10, -.6203D-10, -.1164D-09, -.2009D-09, -.3449D-09,
     #    -.6346D-09, -.9467D-09, -.1799D-08, -.3369D-08, -.5811D-08,
     #    -.1014D-07, -.1789D-07, -.3099D-07, -.5488D-07, -.9664D-07,
     #    -.1698D-06, -.2948D-06, -.5086D-06, -.8873D-06, -.1524D-05,
     #    -.2600D-05, -.4375D-05, -.7292D-05, -.1205D-04, -.1922D-04,
     #    -.2985D-04, -.4471D-04, -.6283D-04, -.8037D-04, -.8662D-04,
     #    -.5937D-04, 0.3383D-04, 0.2353D-03, 0.5676D-03, 0.1014D-02,
     #    0.1492D-02, 0.1891D-02, 0.2147D-02, 0.2293D-02, 0.2421D-02,
     #    0.2591D-02, 0.2779D-02, 0.2896D-02, 0.2874D-02, 0.2698D-02,
     #    0.2404D-02, 0.2044D-02, 0.1673D-02, 0.1327D-02, 0.1026D-02,
     #    0.7784D-03, 0.5813D-03, 0.4289D-03, 0.3133D-03, 0.2274D-03,
     #    0.1638D-03, 0.1176D-03, 0.8402D-04, 0.5985D-04, 0.4252D-04,
     #    0.3015D-04, 0.2132D-04, 0.1506D-04, 0.1062D-04, 0.7483D-05,
     #    0.5265D-05, 0.3700D-05, 0.2597D-05, 0.1821D-05, 0.1277D-05,
     #    0.8940D-06/

      data (calcpts(j,29), j = 1,neta) /-.4983D-11, -.9790D-11,
     #    -.1290D-10, -.3188D-10, -.5737D-10, -.9069D-10, -.1687D-09,
     #    -.3056D-09, -.4990D-09, -.9079D-09, -.1750D-08, -.2956D-08,
     #    -.5178D-08, -.9420D-08, -.1603D-07, -.2899D-07, -.5115D-07,
     #    -.8900D-07, -.1549D-06, -.2717D-06, -.4668D-06, -.8112D-06,
     #    -.1373D-05, -.2324D-05, -.3879D-05, -.6359D-05, -.1017D-04,
     #    -.1589D-04, -.2369D-04, -.3311D-04, -.4219D-04, -.4462D-04,
     #    -.2846D-04, 0.2510D-04, 0.1398D-03, 0.3315D-03, 0.5920D-03,
     #    0.8776D-03, 0.1124D-02, 0.1291D-02, 0.1397D-02, 0.1514D-02,
     #    0.1710D-02, 0.1973D-02, 0.2224D-02, 0.2368D-02, 0.2357D-02,
     #    0.2201D-02, 0.1943D-02, 0.1636D-02, 0.1327D-02, 0.1045D-02,
     #    0.8027D-03, 0.6054D-03, 0.4498D-03, 0.3305D-03, 0.2406D-03,
     #    0.1739D-03, 0.1250D-03, 0.8948D-04, 0.6380D-04, 0.4535D-04,
     #    0.3216D-04, 0.2276D-04, 0.1608D-04, 0.1134D-04, 0.7988D-05,
     #    0.5620D-05, 0.3948D-05, 0.2772D-05, 0.1944D-05, 0.1362D-05,
     #    0.9538D-06/

      data (calcpts(j,30), j = 1,neta) /-.2854D-11, -.4437D-11,
     #    -.7638D-11, -.1380D-10, -.2918D-10, -.5391D-10, -.8799D-10,
     #    -.1632D-09, -.2688D-09, -.4775D-09, -.8800D-09, -.1564D-08,
     #    -.2775D-08, -.4964D-08, -.8434D-08, -.1488D-07, -.2652D-07,
     #    -.4610D-07, -.8079D-07, -.1414D-06, -.2420D-06, -.4168D-06,
     #    -.7136D-06, -.1200D-05, -.2009D-05, -.3292D-05, -.5263D-05,
     #    -.8193D-05, -.1227D-04, -.1725D-04, -.2189D-04, -.2334D-04,
     #    -.1515D-04, 0.1224D-04, 0.7142D-04, 0.1709D-03, 0.3063D-03,
     #    0.4543D-03, 0.5785D-03, 0.6537D-03, 0.6912D-03, 0.7457D-03,
     #    0.8840D-03, 0.1130D-02, 0.1433D-02, 0.1699D-02, 0.1847D-02,
     #    0.1847D-02, 0.1719D-02, 0.1508D-02, 0.1263D-02, 0.1019D-02,
     #    0.7975D-03, 0.6098D-03, 0.4581D-03, 0.3392D-03, 0.2483D-03,
     #    0.1804D-03, 0.1300D-03, 0.9327D-04, 0.6661D-04, 0.4742D-04,
     #    0.3365D-04, 0.2383D-04, 0.1684D-04, 0.1188D-04, 0.8370D-05,
     #    0.5889D-05, 0.4138D-05, 0.2905D-05, 0.2038D-05, 0.1428D-05,
     #    0.9997D-06/

      data (calcpts(j,31), j = 1,neta) /-.9247D-12, -.2620D-11,
     #    -.4429D-11, -.7357D-11, -.1432D-10, -.2601D-10, -.4498D-10,
     #    -.8562D-10, -.1330D-09, -.2509D-09, -.4525D-09, -.7727D-09,
     #    -.1383D-08, -.2448D-08, -.4206D-08, -.7491D-08, -.1325D-07,
     #    -.2328D-07, -.4055D-07, -.7122D-07, -.1212D-06, -.2087D-06,
     #    -.3586D-06, -.6048D-06, -.1010D-05, -.1663D-05, -.2651D-05,
     #    -.4146D-05, -.6220D-05, -.8759D-05, -.1125D-04, -.1221D-04,
     #    -.8548D-05, 0.4577D-05, 0.3298D-04, 0.8095D-04, 0.1456D-03,
     #    0.2140D-03, 0.2653D-03, 0.2830D-03, 0.2709D-03, 0.2637D-03,
     #    0.3173D-03, 0.4761D-03, 0.7347D-03, 0.1029D-02, 0.1273D-02,
     #    0.1403D-02, 0.1407D-02, 0.1307D-02, 0.1142D-02, 0.9523D-03,
     #    0.7647D-03, 0.5962D-03, 0.4544D-03, 0.3402D-03, 0.2512D-03,
     #    0.1834D-03, 0.1329D-03, 0.9566D-04, 0.6849D-04, 0.4883D-04,
     #    0.3470D-04, 0.2460D-04, 0.1740D-04, 0.1228D-04, 0.8652D-05,
     #    0.6089D-05, 0.4280D-05, 0.3004D-05, 0.2107D-05, 0.1477D-05,
     #    0.1034D-05/

      data (calcpts(j,32), j = 1,neta) /0.2151D-11, 0.8299D-12,
     #    0.1550D-11, -.1431D-11, -.5444D-11, -.1006D-10, -.1886D-10,
     #    -.3642D-10, -.5890D-10, -.1180D-09, -.2167D-09, -.3646D-09,
     #    -.6557D-09, -.1191D-08, -.2029D-08, -.3601D-08, -.6539D-08,
     #    -.1130D-07, -.1982D-07, -.3464D-07, -.5947D-07, -.1027D-06,
     #    -.1758D-06, -.2982D-06, -.4972D-06, -.8188D-06, -.1314D-05,
     #    -.2050D-05, -.3091D-05, -.4386D-05, -.5697D-05, -.6336D-05,
     #    -.4837D-05, 0.1010D-05, 0.1405D-04, 0.3593D-04, 0.6474D-04,
     #    0.9324D-04, 0.1093D-03, 0.1019D-03, 0.7001D-04, 0.3092D-04,
     #    0.2157D-04, 0.8568D-04, 0.2472D-03, 0.4866D-03, 0.7427D-03,
     #    0.9454D-03, 0.1051D-02, 0.1053D-02, 0.9759D-03, 0.8503D-03,
     #    0.7063D-03, 0.5654D-03, 0.4394D-03, 0.3339D-03, 0.2494D-03,
     #    0.1837D-03, 0.1339D-03, 0.9681D-04, 0.6956D-04, 0.4972D-04,
     #    0.3540D-04, 0.2512D-04, 0.1779D-04, 0.1256D-04, 0.8858D-05,
     #    0.6235D-05, 0.4384D-05, 0.3079D-05, 0.2160D-05, 0.1514D-05,
     #    0.1060D-05/

      data (calcpts(j,33), j = 1,neta) /-.4830D-11, -.3510D-11,
     #    -.2885D-11, -.2197D-11, -.5301D-11, -.7682D-11, -.1224D-10,
     #    -.2146D-10, -.3607D-10, -.6335D-10, -.1117D-09, -.1940D-09,
     #    -.3413D-09, -.6064D-09, -.1037D-08, -.1847D-08, -.3234D-08,
     #    -.5704D-08, -.9849D-08, -.1719D-07, -.2943D-07, -.5075D-07,
     #    -.8699D-07, -.1473D-06, -.2450D-06, -.4040D-06, -.6487D-06,
     #    -.1017D-05, -.1536D-05, -.2197D-05, -.2877D-05, -.3300D-05,
     #    -.2760D-05, -.2738D-06, 0.5417D-05, 0.1496D-04, 0.2710D-04,
     #    0.3770D-04, 0.3981D-04, 0.2627D-04, -.5854D-05, -.5007D-04,
     #    -.8679D-04, -.8547D-04, -.1608D-04, 0.1319D-03, 0.3348D-03,
     #    0.5416D-03, 0.6997D-03, 0.7792D-03, 0.7796D-03, 0.7201D-03,
     #    0.6254D-03, 0.5179D-03, 0.4134D-03, 0.3205D-03, 0.2430D-03,
     #    0.1811D-03, 0.1331D-03, 0.9683D-04, 0.6990D-04, 0.5014D-04,
     #    0.3579D-04, 0.2544D-04, 0.1804D-04, 0.1276D-04, 0.9000D-05,
     #    0.6340D-05, 0.4459D-05, 0.3132D-05, 0.2198D-05, 0.1540D-05,
     #    0.1079D-05/

      data (calcpts(j,34), j = 1,neta) /-.4478D-11, -.5153D-11,
     #    -.5308D-11, -.4177D-11, -.4213D-11, -.4759D-11, -.5756D-11,
     #    -.1097D-10, -.1695D-10, -.2947D-10, -.5351D-10, -.9124D-10,
     #    -.1597D-09, -.2835D-09, -.5010D-09, -.8807D-09, -.1553D-08,
     #    -.2698D-08, -.4757D-08, -.8210D-08, -.1417D-07, -.2437D-07,
     #    -.4186D-07, -.7064D-07, -.1181D-06, -.1950D-06, -.3131D-06,
     #    -.4943D-06, -.7498D-06, -.1078D-05, -.1435D-05, -.1678D-05,
     #    -.1527D-05, -.5054D-06, 0.1898D-05, 0.5895D-05, 0.1073D-04,
     #    0.1406D-04, 0.1199D-04, 0.9194D-07, -.2455D-04, -.6061D-04,
     #    -.9966D-04, -.1249D-03, -.1138D-03, -.4696D-04, 0.7833D-04,
     #    0.2402D-03, 0.3989D-03, 0.5166D-03, 0.5738D-03, 0.5720D-03,
     #    0.5266D-03, 0.4559D-03, 0.3765D-03, 0.2997D-03, 0.2318D-03,
     #    0.1754D-03, 0.1305D-03, 0.9577D-04, 0.6957D-04, 0.5013D-04,
     #    0.3592D-04, 0.2560D-04, 0.1818D-04, 0.1287D-04, 0.9093D-05,
     #    0.6410D-05, 0.4511D-05, 0.3170D-05, 0.2224D-05, 0.1560D-05,
     #    0.1093D-05/

      data (calcpts(j,35), j = 1,neta) /-.1445D-10, -.1011D-11,
     #    0.7187D-12, -.4568D-11, -.1821D-11, -.4338D-11, -.3443D-11,
     #    -.5130D-11, -.7749D-11, -.1404D-10, -.2392D-10, -.4275D-10,
     #    -.7507D-10, -.1339D-09, -.2362D-09, -.4118D-09, -.7348D-09,
     #    -.1279D-08, -.2235D-08, -.3895D-08, -.6681D-08, -.1161D-07,
     #    -.1988D-07, -.3368D-07, -.5648D-07, -.9351D-07, -.1508D-06,
     #    -.2386D-06, -.3626D-06, -.5248D-06, -.7084D-06, -.8508D-06,
     #    -.8231D-06, -.4278D-06, 0.5567D-06, 0.2181D-05, 0.3960D-05,
     #    0.4671D-05, 0.2131D-05, -.6248D-05, -.2267D-04, -.4762D-04,
     #    -.7831D-04, -.1071D-03, -.1211D-03, -.1046D-03, -.4569D-04,
     #    0.5467D-04, 0.1784D-03, 0.2957D-03, 0.3805D-03, 0.4201D-03,
     #    0.4170D-03, 0.3824D-03, 0.3301D-03, 0.2720D-03, 0.2161D-03,
     #    0.1668D-03, 0.1260D-03, 0.9353D-04, 0.6854D-04, 0.4972D-04,
     #    0.3579D-04, 0.2560D-04, 0.1822D-04, 0.1293D-04, 0.9145D-05,
     #    0.6452D-05, 0.4545D-05, 0.3195D-05, 0.2244D-05, 0.1573D-05,
     #    0.1102D-05/

      data (calcpts(j,36), j = 1,neta) /0.6876D-11, -.4528D-12,
     #    0.3776D-11, 0.3938D-12, -.4144D-11, 0.7553D-12, -.3980D-11,
     #    -.1515D-11, -.4962D-11, -.7698D-11, -.1130D-10, -.2065D-10,
     #    -.3616D-10, -.6477D-10, -.1112D-09, -.1966D-09, -.3543D-09,
     #    -.6119D-09, -.1063D-08, -.1860D-08, -.3216D-08, -.5546D-08,
     #    -.9528D-08, -.1609D-07, -.2715D-07, -.4477D-07, -.7242D-07,
     #    -.1148D-06, -.1757D-06, -.2565D-06, -.3483D-06, -.4296D-06,
     #    -.4394D-06, -.2954D-06, 0.9171D-07, 0.7169D-06, 0.1319D-05,
     #    0.1220D-05, -.7291D-06, -.6002D-05, -.1603D-04, -.3165D-04,
     #    -.5234D-04, -.7523D-04, -.9426D-04, -.1001D-03, -.8223D-04,
     #    -.3349D-04, 0.4377D-04, 0.1353D-03, 0.2199D-03, 0.2796D-03,
     #    0.3062D-03, 0.3022D-03, 0.2761D-03, 0.2377D-03, 0.1954D-03,
     #    0.1549D-03, 0.1194D-03, 0.9004D-04, 0.6675D-04, 0.4884D-04,
     #    0.3538D-04, 0.2544D-04, 0.1818D-04, 0.1293D-04, 0.9162D-05,
     #    0.6474D-05, 0.4563D-05, 0.3211D-05, 0.2256D-05, 0.1582D-05,
     #    0.1109D-05/

      data (calcpts(j,37), j = 1,neta) /0.3214D-11, 0.2471D-11,
     #    0.1989D-11, 0.4786D-11, 0.2349D-11, -.4747D-11, 0.3463D-12,
     #    0.2695D-12, -.4435D-13, -.1458D-11, -.6294D-11, -.9686D-11,
     #    -.1874D-10, -.2966D-10, -.5306D-10, -.9410D-10, -.1660D-09,
     #    -.2915D-09, -.5026D-09, -.8926D-09, -.1533D-08, -.2640D-08,
     #    -.4533D-08, -.7698D-08, -.1291D-07, -.2141D-07, -.3468D-07,
     #    -.5509D-07, -.8459D-07, -.1242D-06, -.1711D-06, -.2145D-06,
     #    -.2301D-06, -.1838D-06, -.3719D-07, 0.1903D-06, 0.3566D-06,
     #    0.1064D-06, -.1167D-05, -.4265D-05, -.1005D-04, -.1920D-04,
     #    -.3191D-04, -.4735D-04, -.6312D-04, -.7473D-04, -.7563D-04,
     #    -.5884D-04, -.2025D-04, 0.3754D-04, 0.1038D-03, 0.1636D-03,
     #    0.2047D-03, 0.2223D-03, 0.2181D-03, 0.1986D-03, 0.1705D-03,
     #    0.1398D-03, 0.1107D-03, 0.8517D-04, 0.6412D-04, 0.4747D-04,
     #    0.3469D-04, 0.2511D-04, 0.1803D-04, 0.1287D-04, 0.9141D-05,
     #    0.6472D-05, 0.4569D-05, 0.3217D-05, 0.2262D-05, 0.1588D-05,
     #    0.1113D-05/

      data (calcpts(j,38), j = 1,neta) /0.2265D-10, -.4611D-11,
     #    0.1382D-10, 0.1316D-10, -.3562D-11, -.2469D-11, -.3007D-12,
     #    -.6720D-11, 0.3697D-11, -.9792D-12, -.1845D-11, -.3928D-11,
     #    -.8268D-11, -.1260D-10, -.2389D-10, -.4290D-10, -.7696D-10,
     #    -.1363D-09, -.2383D-09, -.4171D-09, -.7147D-09, -.1251D-08,
     #    -.2138D-08, -.3636D-08, -.6118D-08, -.1016D-07, -.1648D-07,
     #    -.2633D-07, -.4057D-07, -.5986D-07, -.8323D-07, -.1064D-06,
     #    -.1190D-06, -.1063D-06, -.5577D-07, 0.2084D-07, 0.4457D-07,
     #    -.1681D-06, -.9323D-06, -.2673D-05, -.5877D-05, -.1100D-04,
     #    -.1834D-04, -.2781D-04, -.3861D-04, -.4890D-04, -.5543D-04,
     #    -.5375D-04, -.3926D-04, -.9647D-05, 0.3266D-04, 0.7984D-04,
     #    0.1215D-03, 0.1495D-03, 0.1608D-03, 0.1569D-03, 0.1422D-03,
     #    0.1218D-03, 0.9973D-04, 0.7881D-04, 0.6055D-04, 0.4554D-04,
     #    0.3367D-04, 0.2458D-04, 0.1776D-04, 0.1274D-04, 0.9085D-05,
     #    0.6448D-05, 0.4561D-05, 0.3217D-05, 0.2265D-05, 0.1590D-05,
     #    0.1116D-05/

      data (calcpts(j,39), j = 1,neta) /0.8899D-11, 0.2293D-10,
     #    0.1677D-11, -.1608D-10, 0.2425D-11, -.1380D-10, 0.4994D-11,
     #    0.2777D-12, 0.8584D-11, 0.6138D-11, 0.2812D-11, 0.1515D-11,
     #    -.1299D-11, -.8634D-11, -.1286D-10, -.2092D-10, -.3649D-10,
     #    -.6586D-10, -.1145D-09, -.2014D-09, -.3462D-09, -.5964D-09,
     #    -.1022D-08, -.1742D-08, -.2924D-08, -.4869D-08, -.7902D-08,
     #    -.1260D-07, -.1952D-07, -.2905D-07, -.4074D-07, -.5301D-07,
     #    -.6136D-07, -.5983D-07, -.4423D-07, -.2299D-07, -.3755D-07,
     #    -.1818D-06, -.6164D-06, -.1563D-05, -.3287D-05, -.6063D-05,
     #    -.1012D-04, -.1557D-04, -.2225D-04, -.2948D-04, -.3591D-04,
     #    -.3926D-04, -.3647D-04, -.2462D-04, -.2424D-05, 0.2807D-04,
     #    0.6125D-04, 0.8998D-04, 0.1088D-03, 0.1158D-03, 0.1124D-03,
     #    0.1016D-03, 0.8679D-04, 0.7093D-04, 0.5596D-04, 0.4296D-04,
     #    0.3226D-04, 0.2383D-04, 0.1737D-04, 0.1254D-04, 0.8988D-05,
     #    0.6403D-05, 0.4540D-05, 0.3208D-05, 0.2262D-05, 0.1590D-05,
     #    0.1116D-05/

      data (calcpts(j,40), j = 1,neta) /0.3289D-10, 0.2708D-10,
     #    0.3539D-10, -.6742D-11, 0.5593D-11, 0.7691D-11, 0.2261D-10,
     #    0.8058D-11, -.1388D-12, 0.9135D-11, 0.1398D-10, -.2515D-11,
     #    0.1087D-11, -.2156D-11, -.3048D-11, -.1035D-10, -.1705D-10,
     #    -.3096D-10, -.5363D-10, -.9460D-10, -.1621D-09, -.2806D-09,
     #    -.4827D-09, -.8212D-09, -.1382D-08, -.2294D-08, -.3755D-08,
     #    -.5997D-08, -.9319D-08, -.1391D-07, -.1973D-07, -.2600D-07,
     #    -.3104D-07, -.3247D-07, -.2878D-07, -.2572D-07, -.4432D-07,
     #    -.1324D-06, -.3711D-06, -.8743D-06, -.1782D-05, -.3251D-05,
     #    -.5431D-05, -.8440D-05, -.1229D-04, -.1682D-04, -.2151D-04,
     #    -.2537D-04, -.2682D-04, -.2382D-04, -.1447D-04, 0.1894D-05,
     #    0.2362D-04, 0.4674D-04, 0.6637D-04, 0.7893D-04, 0.8326D-04,
     #    0.8034D-04, 0.7236D-04, 0.6169D-04, 0.5034D-04, 0.3966D-04,
     #    0.3040D-04, 0.2281D-04, 0.1683D-04, 0.1226D-04, 0.8842D-05,
     #    0.6330D-05, 0.4506D-05, 0.3192D-05, 0.2254D-05, 0.1587D-05,
     #    0.1116D-05/

      data (calcpts(j,41), j = 1,neta) /0.8070D-10, 0.7208D-10,
     #    -.9969D-11, 0.4621D-10, 0.3142D-10, 0.1773D-10, 0.2619D-10,
     #    0.5520D-11, 0.1387D-10, -.2577D-11, 0.4067D-11, -.4187D-11,
     #    0.1809D-11, 0.1111D-11, 0.3716D-11, -.1177D-11, -.5532D-11,
     #    -.9871D-11, -.2146D-10, -.4289D-10, -.7489D-10, -.1314D-09,
     #    -.2265D-09, -.3856D-09, -.6518D-09, -.1086D-08, -.1774D-08,
     #    -.2838D-08, -.4438D-08, -.6668D-08, -.9526D-08, -.1275D-07,
     #    -.1562D-07, -.1721D-07, -.1718D-07, -.1892D-07, -.3309D-07,
     #    -.8376D-07, -.2116D-06, -.4746D-06, -.9454D-06, -.1708D-05,
     #    -.2854D-05, -.4465D-05, -.6595D-05, -.9230D-05, -.1222D-04,
     #    -.1518D-04, -.1741D-04, -.1781D-04, -.1502D-04, -.7817D-05,
     #    0.4090D-05, 0.1945D-04, 0.3544D-04, 0.4878D-04, 0.5709D-04,
     #    0.5967D-04, 0.5728D-04, 0.5143D-04, 0.4375D-04, 0.3564D-04,
     #    0.2805D-04, 0.2148D-04, 0.1609D-04, 0.1187D-04, 0.8635D-05,
     #    0.6223D-05, 0.4450D-05, 0.3165D-05, 0.2241D-05, 0.1581D-05,
     #    0.1113D-05/

      data (calcpts(j,42), j = 1,neta) /-.5846D-10, -.7014D-10,
     #    -.5778D-10, -.1180D-09, -.2375D-10, -.5015D-10, -.7008D-11,
     #    0.8792D-11, -.1201D-10, -.3614D-10, -.1938D-10, -.1763D-10,
     #    0.7249D-11, -.6352D-11, -.4248D-11, -.9391D-11, -.7513D-11,
     #    -.1266D-10, -.1417D-10, -.2237D-10, -.3978D-10, -.6331D-10,
     #    -.1093D-09, -.1839D-09, -.3089D-09, -.5148D-09, -.8423D-09,
     #    -.1355D-08, -.2121D-08, -.3203D-08, -.4610D-08, -.6246D-08,
     #    -.7828D-08, -.9010D-08, -.9846D-08, -.1204D-07, -.2119D-07,
     #    -.4927D-07, -.1165D-06, -.2519D-06, -.4931D-06, -.8844D-06,
     #    -.1476D-05, -.2321D-05, -.3462D-05, -.4926D-05, -.6685D-05,
     #    -.8617D-05, -.1044D-04, -.1166D-04, -.1152D-04, -.9118D-05,
     #    -.3686D-05, 0.4897D-05, 0.1567D-04, 0.2668D-04, 0.3570D-04,
     #    0.4116D-04, 0.4267D-04, 0.4075D-04, 0.3648D-04, 0.3097D-04,
     #    0.2520D-04, 0.1981D-04, 0.1515D-04, 0.1134D-04, 0.8355D-05,
     #    0.6075D-05, 0.4374D-05, 0.3126D-05, 0.2221D-05, 0.1572D-05,
     #    0.1108D-05/

      data (calcpts(j,43), j = 1,neta) /0.1136D-10, -.8782D-10,
     #    0.6688D-10, -.2130D-10, 0.8003D-10, 0.2656D-10, -.1288D-10,
     #    -.8851D-11, -.1165D-10, -.1624D-11, 0.1652D-11, 0.3481D-11,
     #    -.9166D-11, -.8690D-11, -.1727D-11, 0.2107D-11, 0.7933D-11,
     #    -.2786D-11, -.5017D-11, -.1410D-10, -.1768D-10, -.3233D-10,
     #    -.4968D-10, -.8618D-10, -.1465D-09, -.2441D-09, -.3988D-09,
     #    -.6432D-09, -.1010D-08, -.1531D-08, -.2219D-08, -.3050D-08,
     #    -.3898D-08, -.4655D-08, -.5410D-08, -.7109D-08, -.1256D-07,
     #    -.2769D-07, -.6255D-07, -.1316D-06, -.2538D-06, -.4523D-06,
     #    -.7542D-06, -.1189D-05, -.1789D-05, -.2576D-05, -.3560D-05,
     #    -.4712D-05, -.5939D-05, -.7035D-05, -.7651D-05, -.7277D-05,
     #    -.5307D-05, -.1264D-05, 0.4879D-05, 0.1241D-04, 0.1996D-04,
     #    0.2602D-04, 0.2959D-04, 0.3043D-04, 0.2893D-04, 0.2583D-04,
     #    0.2188D-04, 0.1779D-04, 0.1397D-04, 0.1067D-04, 0.7984D-05,
     #    0.5875D-05, 0.4269D-05, 0.3070D-05, 0.2193D-05, 0.1557D-05,
     #    0.1101D-05/

      data (calcpts(j,44), j = 1,neta) /0.2906D-09, -.1005D-09,
     #    -.3852D-10, -.4085D-10, 0.4381D-10, 0.4428D-10, 0.1203D-11,
     #    -.1534D-10, -.7004D-11, 0.1085D-10, 0.1420D-10, -.1206D-10,
     #    0.4450D-11, 0.9734D-11, -.1428D-10, 0.5013D-12, -.3193D-11,
     #    0.5180D-11, 0.8894D-12, -.6236D-12, -.1257D-10, -.1550D-10,
     #    -.2144D-10, -.4033D-10, -.6840D-10, -.1162D-09, -.1881D-09,
     #    -.3056D-09, -.4808D-09, -.7301D-09, -.1067D-08, -.1479D-08,
     #    -.1927D-08, -.2374D-08, -.2901D-08, -.3997D-08, -.7078D-08,
     #    -.1508D-07, -.3295D-07, -.6784D-07, -.1293D-06, -.2292D-06,
     #    -.3817D-06, -.6034D-06, -.9124D-06, -.1326D-05, -.1859D-05,
     #    -.2509D-05, -.3253D-05, -.4018D-05, -.4658D-05, -.4929D-05,
     #    -.4484D-05, -.2922D-05, 0.5770D-07, 0.4431D-05, 0.9675D-05,
     #    0.1484D-04, 0.1891D-04, 0.2124D-04, 0.2167D-04, 0.2052D-04,
     #    0.1825D-04, 0.1545D-04, 0.1254D-04, 0.9835D-05, 0.7509D-05,
     #    0.5613D-05, 0.4126D-05, 0.2995D-05, 0.2154D-05, 0.1537D-05,
     #    0.1091D-05/

      data (calcpts(j,45), j = 1,neta) /0.6116D-10, 0.3562D-09,
     #    0.3791D-09, 0.2375D-09, 0.1795D-09, 0.2456D-09, 0.2054D-09,
     #    0.3163D-09, 0.1831D-09, 0.1081D-09, 0.5660D-10, 0.8214D-10,
     #    0.7798D-10, 0.1560D-10, 0.1258D-10, 0.2074D-10, 0.3867D-10,
     #    0.6209D-11, 0.2225D-10, 0.1446D-10, 0.1357D-10, 0.4389D-11,
     #    -.7446D-11, -.1488D-10, -.2801D-10, -.5172D-10, -.8844D-10,
     #    -.1439D-09, -.2279D-09, -.3493D-09, -.5138D-09, -.7197D-09,
     #    -.9534D-09, -.1207D-08, -.1533D-08, -.2187D-08, -.3875D-08,
     #    -.8040D-08, -.1711D-07, -.3462D-07, -.6532D-07, -.1152D-06,
     #    -.1917D-06, -.3035D-06, -.4610D-06, -.6749D-06, -.9555D-06,
     #    -.1309D-05, -.1734D-05, -.2207D-05, -.2676D-05, -.3038D-05,
     #    -.3120D-05, -.2687D-05, -.1476D-05, 0.7008D-06, 0.3801D-05,
     #    0.7441D-05, 0.1096D-04, 0.1369D-04, 0.1519D-04, 0.1540D-04,
     #    0.1452D-04, 0.1289D-04, 0.1089D-04, 0.8827D-05, 0.6918D-05,
     #    0.5277D-05, 0.3942D-05, 0.2896D-05, 0.2101D-05, 0.1509D-05,
     #    0.1076D-05/

      data (calcpts(j,46), j = 1,neta) /0.1917D-09, -.1535D-09,
     #    0.4083D-09, 0.2116D-09, 0.9985D-10, -.3683D-11, 0.6403D-10,
     #    0.2144D-10, 0.7432D-11, 0.7975D-10, -.1710D-10, 0.2668D-10,
     #    -.1262D-10, 0.4799D-11, 0.3884D-11, -.4044D-11, 0.4642D-11,
     #    -.6977D-11, 0.6772D-11, 0.2195D-10, 0.1218D-10, 0.8504D-11,
     #    -.4265D-11, -.5370D-11, -.1092D-10, -.2660D-10, -.4248D-10,
     #    -.7007D-10, -.1082D-09, -.1669D-09, -.2471D-09, -.3489D-09,
     #    -.4687D-09, -.6066D-09, -.7951D-09, -.1165D-08, -.2068D-08,
     #    -.4211D-08, -.8778D-08, -.1752D-07, -.3277D-07, -.5755D-07,
     #    -.9563D-07, -.1516D-06, -.2311D-06, -.3402D-06, -.4856D-06,
     #    -.6733D-06, -.9060D-06, -.1180D-05, -.1478D-05, -.1760D-05,
     #    -.1953D-05, -.1940D-05, -.1557D-05, -.6336D-06, 0.9465D-06,
     #    0.3136D-05, 0.5659D-05, 0.8059D-05, 0.9882D-05, 0.1085D-04,
     #    0.1093D-04, 0.1026D-04, 0.9090D-05, 0.7666D-05, 0.6207D-05,
     #    0.4860D-05, 0.3705D-05, 0.2766D-05, 0.2031D-05, 0.1472D-05,
     #    0.1057D-05/

      data (calcpts(j,47), j = 1,neta) /0.2895D-09, -.2610D-09,
     #    -.3456D-09, -.1412D-09, -.3047D-10, -.2021D-10, -.2062D-09,
     #    -.9289D-10, 0.4744D-10, -.9101D-10, -.2432D-10, -.1832D-10,
     #    0.5847D-10, -.2453D-10, -.3673D-10, -.2271D-10, 0.1469D-10,
     #    -.5788D-11, -.7590D-11, -.1979D-10, 0.1805D-10, -.6081D-11,
     #    -.2603D-11, -.8448D-11, -.6680D-11, -.1677D-10, -.2327D-10,
     #    -.3327D-10, -.5595D-10, -.7616D-10, -.1179D-09, -.1698D-09,
     #    -.2286D-09, -.3027D-09, -.4085D-09, -.6112D-09, -.1086D-08,
     #    -.2176D-08, -.4463D-08, -.8801D-08, -.1634D-07, -.2859D-07,
     #    -.4746D-07, -.7531D-07, -.1151D-06, -.1702D-06, -.2447D-06,
     #    -.3423D-06, -.4663D-06, -.6178D-06, -.7926D-06, -.9777D-06,
     #    -.1144D-05, -.1239D-05, -.1182D-05, -.8625D-06, -.1674D-06,
     #    0.9738D-06, 0.2517D-05, 0.4263D-05, 0.5896D-05, 0.7111D-05,
     #    0.7731D-05, 0.7740D-05, 0.7242D-05, 0.6402D-05, 0.5391D-05,
     #    0.4360D-05, 0.3411D-05, 0.2599D-05, 0.1938D-05, 0.1422D-05,
     #    0.1030D-05/

      data (calcpts(j,48), j = 1,neta) /-.1464D-09, 0.1705D-10,
     #    0.2130D-09, -.6478D-10, 0.5286D-09, 0.1417D-09, 0.3096D-09,
     #    0.1552D-09, -.5639D-10, 0.1330D-09, 0.1519D-09, 0.5894D-10,
     #    0.5478D-10, 0.4993D-10, 0.4679D-10, -.7341D-10, 0.3779D-10,
     #    0.4836D-10, 0.5389D-10, 0.6009D-11, -.5886D-12, 0.1044D-10,
     #    -.2832D-11, 0.1719D-10, 0.4355D-11, -.2739D-11, -.1025D-10,
     #    -.1470D-10, -.1767D-10, -.3432D-10, -.5392D-10, -.7840D-10,
     #    -.1105D-09, -.1499D-09, -.2074D-09, -.3156D-09, -.5618D-09,
     #    -.1113D-08, -.2252D-08, -.4395D-08, -.8110D-08, -.1414D-07,
     #    -.2344D-07, -.3724D-07, -.5702D-07, -.8466D-07, -.1223D-06,
     #    -.1724D-06, -.2372D-06, -.3185D-06, -.4163D-06, -.5270D-06,
     #    -.6404D-06, -.7353D-06, -.7752D-06, -.7035D-06, -.4463D-06,
     #    0.7188D-07, 0.8923D-06, 0.1977D-05, 0.3184D-05, 0.4294D-05,
     #    0.5103D-05, 0.5499D-05, 0.5475D-05, 0.5106D-05, 0.4503D-05,
     #    0.3787D-05, 0.3060D-05, 0.2392D-05, 0.1821D-05, 0.1357D-05,
     #    0.9954D-06/

      data (calcpts(j,49), j = 1,neta) /0.5682D-09, 0.1002D-08,
     #    -.8636D-09, 0.3879D-09, -.6704D-09, -.1877D-09, 0.6433D-10,
     #    0.4983D-09, 0.2832D-09, 0.1430D-09, -.1107D-09, -.2155D-09,
     #    -.7760D-10, 0.9064D-10, 0.5010D-10, 0.5425D-10, -.2434D-10,
     #    0.2420D-11, -.3557D-10, -.2176D-10, 0.2093D-10, 0.3055D-11,
     #    -.5441D-12, 0.2863D-11, 0.5720D-12, -.4297D-11, -.8496D-11,
     #    0.8641D-12, -.1555D-10, -.1598D-10, -.2747D-10, -.3948D-10,
     #    -.5439D-10, -.7508D-10, -.1040D-09, -.1614D-09, -.2881D-09,
     #    -.5647D-09, -.1129D-08, -.2184D-08, -.4008D-08, -.6967D-08,
     #    -.1154D-07, -.1834D-07, -.2814D-07, -.4188D-07, -.6078D-07,
     #    -.8618D-07, -.1195D-06, -.1623D-06, -.2151D-06, -.2778D-06,
     #    -.3471D-06, -.4155D-06, -.4677D-06, -.4778D-06, -.4068D-06,
     #    -.2046D-06, 0.1783D-06, 0.7663D-06, 0.1528D-05, 0.2361D-05,
     #    0.3115D-05, 0.3654D-05, 0.3904D-05, 0.3867D-05, 0.3595D-05,
     #    0.3165D-05, 0.2658D-05, 0.2146D-05, 0.1677D-05, 0.1275D-05,
     #    0.9499D-06/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1_FLg = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     ==========================================
      double precision function h1bar_Lg(eta,xi)
c     ==========================================

c     eq (12) in PLB347 (1995) 143 - 151 for the longitudinal piece
c     MSbar scheme
c     This routine is called subclbar in the original code.
c     Called sclbar in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /0.7071D-08, 0.8567D-08,
     #    0.1038D-07, 0.1257D-07, 0.1524D-07, 0.1846D-07, 0.2236D-07,
     #    0.2710D-07, 0.3283D-07, 0.3978D-07, 0.4822D-07, 0.5844D-07,
     #    0.7084D-07, 0.8591D-07, 0.1042D-06, 0.1265D-06, 0.1537D-06,
     #    0.1870D-06, 0.2279D-06, 0.2786D-06, 0.3418D-06, 0.4217D-06,
     #    0.5243D-06, 0.6586D-06, 0.8386D-06, 0.1086D-05, 0.1434D-05,
     #    0.1933D-05, 0.2658D-05, 0.3705D-05, 0.5187D-05, 0.7191D-05,
     #    0.9704D-05, 0.1252D-04, 0.1518D-04, 0.1707D-04, 0.1771D-04,
     #    0.1701D-04, 0.1527D-04, 0.1299D-04, 0.1059D-04, 0.8349D-05,
     #    0.6403D-05, 0.4797D-05, 0.3525D-05, 0.2546D-05, 0.1816D-05,
     #    0.1282D-05, 0.8938D-06, 0.6230D-06, 0.4303D-06, 0.2961D-06,
     #    0.2068D-06, 0.1394D-06, 0.9358D-07, 0.6473D-07, 0.4295D-07,
     #    0.3262D-07, 0.1892D-07, 0.1412D-07, 0.1085D-07, 0.8620D-08,
     #    0.7103D-08, 0.6068D-08, 0.5363D-08, -.1784D-08, -.2111D-08,
     #    -.2334D-08, -.2486D-08, -.2589D-08, -.2660D-08, -.2708D-08,
     #    -.2741D-08/

      data (calcpts(j, 2), j = 1,neta) /0.1038D-07, 0.1257D-07,
     #    0.1523D-07, 0.1845D-07, 0.2236D-07, 0.2709D-07, 0.3282D-07,
     #    0.3977D-07, 0.4818D-07, 0.5839D-07, 0.7077D-07, 0.8577D-07,
     #    0.1040D-06, 0.1261D-06, 0.1529D-06, 0.1857D-06, 0.2256D-06,
     #    0.2745D-06, 0.3345D-06, 0.4089D-06, 0.5016D-06, 0.6189D-06,
     #    0.7695D-06, 0.9666D-06, 0.1231D-05, 0.1593D-05, 0.2104D-05,
     #    0.2837D-05, 0.3901D-05, 0.5438D-05, 0.7612D-05, 0.1055D-04,
     #    0.1424D-04, 0.1838D-04, 0.2228D-04, 0.2506D-04, 0.2600D-04,
     #    0.2497D-04, 0.2241D-04, 0.1906D-04, 0.1554D-04, 0.1225D-04,
     #    0.9395D-05, 0.7042D-05, 0.5175D-05, 0.3742D-05, 0.2663D-05,
     #    0.1879D-05, 0.1317D-05, 0.9144D-06, 0.6334D-06, 0.4387D-06,
     #    0.2970D-06, 0.2074D-06, 0.1398D-06, 0.9388D-07, 0.6503D-07,
     #    0.4321D-07, 0.3288D-07, 0.1917D-07, 0.1438D-07, 0.1111D-07,
     #    0.8879D-08, 0.7360D-08, 0.6325D-08, 0.5620D-08, 0.5140D-08,
     #    0.4813D-08, 0.4590D-08, 0.4438D-08, 0.4335D-08, 0.4264D-08,
     #    0.4216D-08/

      data (calcpts(j, 3), j = 1,neta) /0.1522D-07, 0.1844D-07,
     #    0.2234D-07, 0.2707D-07, 0.3280D-07, 0.3974D-07, 0.4815D-07,
     #    0.5834D-07, 0.7068D-07, 0.8565D-07, 0.1038D-06, 0.1258D-06,
     #    0.1525D-06, 0.1850D-06, 0.2244D-06, 0.2724D-06, 0.3309D-06,
     #    0.4026D-06, 0.4907D-06, 0.5998D-06, 0.7358D-06, 0.9079D-06,
     #    0.1129D-05, 0.1418D-05, 0.1805D-05, 0.2338D-05, 0.3087D-05,
     #    0.4163D-05, 0.5723D-05, 0.7978D-05, 0.1117D-04, 0.1548D-04,
     #    0.2090D-04, 0.2696D-04, 0.3269D-04, 0.3676D-04, 0.3814D-04,
     #    0.3662D-04, 0.3287D-04, 0.2796D-04, 0.2279D-04, 0.1796D-04,
     #    0.1378D-04, 0.1033D-04, 0.7581D-05, 0.5477D-05, 0.3902D-05,
     #    0.2753D-05, 0.1925D-05, 0.1338D-05, 0.9239D-06, 0.6335D-06,
     #    0.4377D-06, 0.2956D-06, 0.1991D-06, 0.1380D-06, 0.9217D-07,
     #    0.6328D-07, 0.4146D-07, 0.2447D-07, 0.1743D-07, 0.1263D-07,
     #    0.9369D-08, 0.4751D-09, -.1043D-08, -.2076D-08, -.2780D-08,
     #    -.3260D-08, -.3587D-08, -.3809D-08, -.3961D-08, -.4065D-08,
     #    -.4135D-08/

      data (calcpts(j, 4), j = 1,neta) /0.2234D-07, 0.2706D-07,
     #    0.3278D-07, 0.3972D-07, 0.4813D-07, 0.5831D-07, 0.7065D-07,
     #    0.8560D-07, 0.1037D-06, 0.1257D-06, 0.1523D-06, 0.1846D-06,
     #    0.2238D-06, 0.2714D-06, 0.3292D-06, 0.3996D-06, 0.4856D-06,
     #    0.5907D-06, 0.7200D-06, 0.8801D-06, 0.1080D-05, 0.1332D-05,
     #    0.1656D-05, 0.2081D-05, 0.2649D-05, 0.3430D-05, 0.4529D-05,
     #    0.6107D-05, 0.8395D-05, 0.1171D-04, 0.1638D-04, 0.2272D-04,
     #    0.3066D-04, 0.3956D-04, 0.4796D-04, 0.5393D-04, 0.5596D-04,
     #    0.5373D-04, 0.4823D-04, 0.4102D-04, 0.3344D-04, 0.2636D-04,
     #    0.2021D-04, 0.1515D-04, 0.1113D-04, 0.8040D-05, 0.5732D-05,
     #    0.4043D-05, 0.2826D-05, 0.1960D-05, 0.1359D-05, 0.9340D-06,
     #    0.6419D-06, 0.4389D-06, 0.2964D-06, 0.2064D-06, 0.1387D-06,
     #    0.9274D-07, 0.6384D-07, 0.4204D-07, 0.3172D-07, 0.1801D-07,
     #    0.1322D-07, 0.9956D-08, 0.7730D-08, -.4522D-09, -.1485D-08,
     #    -.2189D-08, -.2668D-08, -.2995D-08, -.3218D-08, -.3369D-08,
     #    -.3473D-08/

      data (calcpts(j, 5), j = 1,neta) /0.3277D-07, 0.3971D-07,
     #    0.4810D-07, 0.5828D-07, 0.7061D-07, 0.8555D-07, 0.1036D-06,
     #    0.1256D-06, 0.1522D-06, 0.1844D-06, 0.2235D-06, 0.2708D-06,
     #    0.3283D-06, 0.3982D-06, 0.4830D-06, 0.5863D-06, 0.7124D-06,
     #    0.8667D-06, 0.1056D-05, 0.1291D-05, 0.1584D-05, 0.1954D-05,
     #    0.2430D-05, 0.3052D-05, 0.3886D-05, 0.5032D-05, 0.6644D-05,
     #    0.8958D-05, 0.1231D-04, 0.1717D-04, 0.2403D-04, 0.3332D-04,
     #    0.4497D-04, 0.5803D-04, 0.7035D-04, 0.7913D-04, 0.8209D-04,
     #    0.7883D-04, 0.7075D-04, 0.6016D-04, 0.4905D-04, 0.3866D-04,
     #    0.2965D-04, 0.2222D-04, 0.1633D-04, 0.1179D-04, 0.8411D-05,
     #    0.5937D-05, 0.4149D-05, 0.2887D-05, 0.1997D-05, 0.1377D-05,
     #    0.9428D-06, 0.6499D-06, 0.4463D-06, 0.3037D-06, 0.2070D-06,
     #    0.1459D-06, 0.9995D-07, 0.7108D-07, 0.4928D-07, 0.3230D-07,
     #    0.2527D-07, 0.2048D-07, 0.1055D-07, 0.8328D-08, 0.6813D-08,
     #    0.5781D-08, 0.5079D-08, 0.4599D-08, 0.4273D-08, 0.4051D-08,
     #    0.3899D-08/

      data (calcpts(j, 6), j = 1,neta) /0.4805D-07, 0.5822D-07,
     #    0.7053D-07, 0.8545D-07, 0.1035D-06, 0.1254D-06, 0.1520D-06,
     #    0.1842D-06, 0.2231D-06, 0.2704D-06, 0.3277D-06, 0.3971D-06,
     #    0.4815D-06, 0.5839D-06, 0.7082D-06, 0.8597D-06, 0.1045D-05,
     #    0.1271D-05, 0.1549D-05, 0.1893D-05, 0.2323D-05, 0.2866D-05,
     #    0.3563D-05, 0.4475D-05, 0.5698D-05, 0.7377D-05, 0.9741D-05,
     #    0.1313D-04, 0.1806D-04, 0.2517D-04, 0.3524D-04, 0.4885D-04,
     #    0.6594D-04, 0.8508D-04, 0.1032D-03, 0.1160D-03, 0.1204D-03,
     #    0.1156D-03, 0.1037D-03, 0.8819D-04, 0.7189D-04, 0.5667D-04,
     #    0.4346D-04, 0.3256D-04, 0.2392D-04, 0.1729D-04, 0.1232D-04,
     #    0.8691D-05, 0.6081D-05, 0.4225D-05, 0.2921D-05, 0.2010D-05,
     #    0.1380D-05, 0.9449D-06, 0.6514D-06, 0.4410D-06, 0.3051D-06,
     #    0.2084D-06, 0.1406D-06, 0.9476D-07, 0.6592D-07, 0.4414D-07,
     #    0.3385D-07, 0.2016D-07, 0.1538D-07, 0.1212D-07, 0.9899D-08,
     #    0.8387D-08, 0.6908D-09, -.1138D-10, -.4898D-09, -.8155D-09,
     #    -.1037D-08/

      data (calcpts(j, 7), j = 1,neta) /0.7044D-07, 0.8534D-07,
     #    0.1034D-06, 0.1253D-06, 0.1518D-06, 0.1839D-06, 0.2228D-06,
     #    0.2699D-06, 0.3270D-06, 0.3963D-06, 0.4803D-06, 0.5821D-06,
     #    0.7057D-06, 0.8558D-06, 0.1038D-05, 0.1260D-05, 0.1531D-05,
     #    0.1863D-05, 0.2270D-05, 0.2775D-05, 0.3405D-05, 0.4200D-05,
     #    0.5222D-05, 0.6559D-05, 0.8351D-05, 0.1081D-04, 0.1428D-04,
     #    0.1925D-04, 0.2646D-04, 0.3688D-04, 0.5164D-04, 0.7160D-04,
     #    0.9666D-04, 0.1247D-03, 0.1512D-03, 0.1701D-03, 0.1764D-03,
     #    0.1694D-03, 0.1520D-03, 0.1292D-03, 0.1053D-03, 0.8300D-04,
     #    0.6365D-04, 0.4768D-04, 0.3504D-04, 0.2532D-04, 0.1805D-04,
     #    0.1274D-04, 0.8887D-05, 0.6193D-05, 0.4276D-05, 0.2941D-05,
     #    0.2053D-05, 0.1382D-05, 0.9261D-06, 0.6392D-06, 0.4224D-06,
     #    0.3199D-06, 0.1833D-06, 0.1356D-06, 0.1032D-06, 0.8102D-07,
     #    0.6595D-07, 0.5567D-07, 0.4867D-07, 0.4390D-07, 0.4065D-07,
     #    0.3843D-07, 0.3693D-07, 0.3590D-07, 0.3520D-07, 0.3472D-07,
     #    0.3440D-07/

      data (calcpts(j, 8), j = 1,neta) /0.1032D-06, 0.1250D-06,
     #    0.1515D-06, 0.1835D-06, 0.2223D-06, 0.2694D-06, 0.3264D-06,
     #    0.3955D-06, 0.4791D-06, 0.5806D-06, 0.7037D-06, 0.8529D-06,
     #    0.1034D-05, 0.1254D-05, 0.1521D-05, 0.1846D-05, 0.2243D-05,
     #    0.2729D-05, 0.3326D-05, 0.4065D-05, 0.4988D-05, 0.6154D-05,
     #    0.7650D-05, 0.9609D-05, 0.1223D-04, 0.1583D-04, 0.2091D-04,
     #    0.2819D-04, 0.3875D-04, 0.5401D-04, 0.7562D-04, 0.1049D-03,
     #    0.1415D-03, 0.1826D-03, 0.2215D-03, 0.2492D-03, 0.2585D-03,
     #    0.2481D-03, 0.2226D-03, 0.1892D-03, 0.1542D-03, 0.1215D-03,
     #    0.9315D-04, 0.6981D-04, 0.5128D-04, 0.3707D-04, 0.2644D-04,
     #    0.1866D-04, 0.1302D-04, 0.9091D-05, 0.6303D-05, 0.4304D-05,
     #    0.2964D-05, 0.2075D-05, 0.1403D-05, 0.9480D-06, 0.6617D-06,
     #    0.4450D-06, 0.3427D-06, 0.2064D-06, 0.1589D-06, 0.1265D-06,
     #    0.1045D-06, 0.8944D-07, 0.1253D-07, 0.5554D-08, 0.8006D-09,
     #    -.2439D-08, -.4644D-08, -.6148D-08, -.7172D-08, -.7870D-08,
     #    -.8345D-08/

      data (calcpts(j, 9), j = 1,neta) /0.1510D-06, 0.1829D-06,
     #    0.2216D-06, 0.2685D-06, 0.3253D-06, 0.3941D-06, 0.4775D-06,
     #    0.5786D-06, 0.7010D-06, 0.8495D-06, 0.1030D-05, 0.1248D-05,
     #    0.1513D-05, 0.1834D-05, 0.2225D-05, 0.2701D-05, 0.3282D-05,
     #    0.3992D-05, 0.4866D-05, 0.5948D-05, 0.7297D-05, 0.9002D-05,
     #    0.1119D-04, 0.1406D-04, 0.1789D-04, 0.2316D-04, 0.3058D-04,
     #    0.4123D-04, 0.5667D-04, 0.7900D-04, 0.1106D-03, 0.1534D-03,
     #    0.2071D-03, 0.2673D-03, 0.3241D-03, 0.3646D-03, 0.3781D-03,
     #    0.3629D-03, 0.3255D-03, 0.2765D-03, 0.2252D-03, 0.1775D-03,
     #    0.1361D-03, 0.1019D-03, 0.7488D-04, 0.5409D-04, 0.3859D-04,
     #    0.2717D-04, 0.1898D-04, 0.1318D-04, 0.9152D-05, 0.6280D-05,
     #    0.4277D-05, 0.2938D-05, 0.1983D-05, 0.1379D-05, 0.9252D-06,
     #    0.6396D-06, 0.4236D-06, 0.2553D-06, 0.1859D-06, 0.1387D-06,
     #    0.3983D-07, 0.1788D-07, 0.2928D-08, -.7253D-08, -.1419D-07,
     #    -.1892D-07, -.2214D-07, -.2433D-07, -.2583D-07, -.2685D-07,
     #    -.2754D-07/

      data (calcpts(j,10), j = 1,neta) /0.2207D-06, 0.2674D-06,
     #    0.3239D-06, 0.3924D-06, 0.4755D-06, 0.5761D-06, 0.6980D-06,
     #    0.8458D-06, 0.1025D-05, 0.1242D-05, 0.1505D-05, 0.1824D-05,
     #    0.2211D-05, 0.2681D-05, 0.3252D-05, 0.3948D-05, 0.4797D-05,
     #    0.5836D-05, 0.7113D-05, 0.8694D-05, 0.1066D-04, 0.1316D-04,
     #    0.1636D-04, 0.2054D-04, 0.2614D-04, 0.3384D-04, 0.4467D-04,
     #    0.6022D-04, 0.8277D-04, 0.1154D-03, 0.1615D-03, 0.2240D-03,
     #    0.3025D-03, 0.3905D-03, 0.4737D-03, 0.5328D-03, 0.5527D-03,
     #    0.5302D-03, 0.4753D-03, 0.4036D-03, 0.3286D-03, 0.2589D-03,
     #    0.1984D-03, 0.1486D-03, 0.1092D-03, 0.7896D-04, 0.5628D-04,
     #    0.3968D-04, 0.2778D-04, 0.1927D-04, 0.1335D-04, 0.9172D-05,
     #    0.6298D-05, 0.4299D-05, 0.2963D-05, 0.2012D-05, 0.1345D-05,
     #    0.9590D-06, 0.6082D-06, 0.4600D-06, 0.2924D-06, 0.2235D-06,
     #    0.1100D-06, 0.7802D-07, 0.5624D-07, 0.4141D-07, 0.3130D-07,
     #    0.2441D-07, 0.1972D-07, 0.1652D-07, 0.1435D-07, 0.1286D-07,
     #    0.1185D-07/

      data (calcpts(j,11), j = 1,neta) /0.3220D-06, 0.3901D-06,
     #    0.4725D-06, 0.5725D-06, 0.6937D-06, 0.8405D-06, 0.1018D-05,
     #    0.1234D-05, 0.1495D-05, 0.1811D-05, 0.2195D-05, 0.2661D-05,
     #    0.3226D-05, 0.3912D-05, 0.4745D-05, 0.5760D-05, 0.6999D-05,
     #    0.8514D-05, 0.1038D-04, 0.1268D-04, 0.1556D-04, 0.1919D-04,
     #    0.2385D-04, 0.2996D-04, 0.3812D-04, 0.4934D-04, 0.6512D-04,
     #    0.8776D-04, 0.1206D-03, 0.1681D-03, 0.2354D-03, 0.3265D-03,
     #    0.4410D-03, 0.5695D-03, 0.6909D-03, 0.7773D-03, 0.8061D-03,
     #    0.7730D-03, 0.6925D-03, 0.5877D-03, 0.4781D-03, 0.3765D-03,
     #    0.2886D-03, 0.2162D-03, 0.1589D-03, 0.1148D-03, 0.8193D-04,
     #    0.5780D-04, 0.4049D-04, 0.2811D-04, 0.1949D-04, 0.1344D-04,
     #    0.9262D-05, 0.6335D-05, 0.4346D-05, 0.3018D-05, 0.2074D-05,
     #    0.1411D-05, 0.1028D-05, 0.6800D-06, 0.4667D-06, 0.3667D-06,
     #    0.2320D-06, 0.1856D-06, 0.1540D-06, 0.1325D-06, 0.1178D-06,
     #    0.1078D-06, 0.1010D-06, 0.9635D-07, 0.9319D-07, 0.9104D-07,
     #    0.8957D-07/

      data (calcpts(j,12), j = 1,neta) /0.4683D-06, 0.5674D-06,
     #    0.6873D-06, 0.8327D-06, 0.1009D-05, 0.1222D-05, 0.1481D-05,
     #    0.1795D-05, 0.2174D-05, 0.2635D-05, 0.3193D-05, 0.3870D-05,
     #    0.4692D-05, 0.5689D-05, 0.6901D-05, 0.8377D-05, 0.1018D-04,
     #    0.1238D-04, 0.1509D-04, 0.1844D-04, 0.2262D-04, 0.2790D-04,
     #    0.3468D-04, 0.4354D-04, 0.5541D-04, 0.7170D-04, 0.9460D-04,
     #    0.1275D-03, 0.1751D-03, 0.2441D-03, 0.3418D-03, 0.4742D-03,
     #    0.6407D-03, 0.8277D-03, 0.1005D-02, 0.1130D-02, 0.1172D-02,
     #    0.1123D-02, 0.1005D-02, 0.8521D-03, 0.6927D-03, 0.5450D-03,
     #    0.4176D-03, 0.3128D-03, 0.2299D-03, 0.1662D-03, 0.1186D-03,
     #    0.8370D-04, 0.5860D-04, 0.4075D-04, 0.2823D-04, 0.1950D-04,
     #    0.1342D-04, 0.9210D-05, 0.6376D-05, 0.4340D-05, 0.3028D-05,
     #    0.2093D-05, 0.1437D-05, 0.1060D-05, 0.7149D-06, 0.5039D-06,
     #    0.4057D-06, 0.2720D-06, 0.2264D-06, 0.1953D-06, 0.1741D-06,
     #    0.1597D-06, 0.1499D-06, 0.1431D-06, 0.1386D-06, 0.1355D-06,
     #    0.1334D-06/

      data (calcpts(j,13), j = 1,neta) /0.6783D-06, 0.8219D-06,
     #    0.9956D-06, 0.1206D-05, 0.1462D-05, 0.1771D-05, 0.2145D-05,
     #    0.2600D-05, 0.3150D-05, 0.3817D-05, 0.4626D-05, 0.5606D-05,
     #    0.6796D-05, 0.8242D-05, 0.9996D-05, 0.1213D-04, 0.1474D-04,
     #    0.1793D-04, 0.2186D-04, 0.2671D-04, 0.3276D-04, 0.4041D-04,
     #    0.5021D-04, 0.6303D-04, 0.8018D-04, 0.1037D-03, 0.1368D-03,
     #    0.1842D-03, 0.2531D-03, 0.3527D-03, 0.4939D-03, 0.6854D-03,
     #    0.9269D-03, 0.1198D-02, 0.1455D-02, 0.1638D-02, 0.1697D-02,
     #    0.1625D-02, 0.1452D-02, 0.1229D-02, 0.9978D-03, 0.7844D-03,
     #    0.6007D-03, 0.4499D-03, 0.3307D-03, 0.2392D-03, 0.1708D-03,
     #    0.1206D-03, 0.8451D-04, 0.5882D-04, 0.4067D-04, 0.2798D-04,
     #    0.1955D-04, 0.1315D-04, 0.9469D-05, 0.6745D-05, 0.4676D-05,
     #    0.3051D-05, 0.2398D-05, 0.1953D-05, 0.9828D-06, 0.7760D-06,
     #    0.6353D-06, 0.5393D-06, 0.4738D-06, 0.4293D-06, 0.3989D-06,
     #    0.3782D-06, 0.3641D-06, 0.3545D-06, 0.3480D-06, 0.3435D-06,
     #    0.3405D-06/

      data (calcpts(j,14), j = 1,neta) /0.9761D-06, 0.1183D-05,
     #    0.1433D-05, 0.1736D-05, 0.2103D-05, 0.2548D-05, 0.3087D-05,
     #    0.3741D-05, 0.4532D-05, 0.5492D-05, 0.6656D-05, 0.8067D-05,
     #    0.9780D-05, 0.1186D-04, 0.1438D-04, 0.1746D-04, 0.2121D-04,
     #    0.2580D-04, 0.3145D-04, 0.3843D-04, 0.4712D-04, 0.5811D-04,
     #    0.7220D-04, 0.9060D-04, 0.1152D-03, 0.1490D-03, 0.1964D-03,
     #    0.2644D-03, 0.3630D-03, 0.5058D-03, 0.7084D-03, 0.9837D-03,
     #    0.1331D-02, 0.1722D-02, 0.2093D-02, 0.2357D-02, 0.2442D-02,
     #    0.2335D-02, 0.2083D-02, 0.1759D-02, 0.1425D-02, 0.1118D-02,
     #    0.8558D-03, 0.6404D-03, 0.4707D-03, 0.3408D-03, 0.2433D-03,
     #    0.1714D-03, 0.1205D-03, 0.8340D-04, 0.5819D-04, 0.4026D-04,
     #    0.2781D-04, 0.1890D-04, 0.1263D-04, 0.9049D-05, 0.6393D-05,
     #    0.4368D-05, 0.2775D-05, 0.2145D-05, 0.1714D-05, 0.7546D-06,
     #    0.5551D-06, 0.4189D-06, 0.3261D-06, 0.2630D-06, 0.2199D-06,
     #    0.1906D-06, 0.1707D-06, 0.1570D-06, 0.1478D-06, 0.1414D-06,
     #    0.1371D-06/

      data (calcpts(j,15), j = 1,neta) /0.1392D-05, 0.1687D-05,
     #    0.2044D-05, 0.2476D-05, 0.3000D-05, 0.3635D-05, 0.4404D-05,
     #    0.5337D-05, 0.6465D-05, 0.7835D-05, 0.9495D-05, 0.1151D-04,
     #    0.1395D-04, 0.1692D-04, 0.2052D-04, 0.2491D-04, 0.3026D-04,
     #    0.3680D-04, 0.4485D-04, 0.5480D-04, 0.6719D-04, 0.8283D-04,
     #    0.1029D-03, 0.1290D-03, 0.1640D-03, 0.2119D-03, 0.2792D-03,
     #    0.3756D-03, 0.5155D-03, 0.7180D-03, 0.1006D-02, 0.1397D-02,
     #    0.1893D-02, 0.2452D-02, 0.2984D-02, 0.3362D-02, 0.3482D-02,
     #    0.3324D-02, 0.2956D-02, 0.2488D-02, 0.2009D-02, 0.1574D-02,
     #    0.1203D-02, 0.9001D-03, 0.6612D-03, 0.4787D-03, 0.3412D-03,
     #    0.2412D-03, 0.1686D-03, 0.1173D-03, 0.8115D-04, 0.5598D-04,
     #    0.3859D-04, 0.2589D-04, 0.1793D-04, 0.1186D-04, 0.8419D-05,
     #    0.5190D-05, 0.3898D-05, 0.2351D-05, 0.1751D-05, 0.6754D-06,
     #    0.3970D-06, 0.2070D-06, 0.7757D-07, -.1055D-07, -.7060D-07,
     #    -.1115D-06, -.1394D-06, -.1584D-06, -.1713D-06, -.1801D-06,
     #    -.1862D-06/

      data (calcpts(j,16), j = 1,neta) /0.1963D-05, 0.2378D-05,
     #    0.2881D-05, 0.3490D-05, 0.4229D-05, 0.5124D-05, 0.6208D-05,
     #    0.7522D-05, 0.9113D-05, 0.1104D-04, 0.1338D-04, 0.1622D-04,
     #    0.1966D-04, 0.2384D-04, 0.2892D-04, 0.3510D-04, 0.4264D-04,
     #    0.5186D-04, 0.6319D-04, 0.7719D-04, 0.9463D-04, 0.1166D-03,
     #    0.1448D-03, 0.1815D-03, 0.2304D-03, 0.2975D-03, 0.3914D-03,
     #    0.5261D-03, 0.7214D-03, 0.1005D-02, 0.1407D-02, 0.1957D-02,
     #    0.2654D-02, 0.3445D-02, 0.4200D-02, 0.4737D-02, 0.4905D-02,
     #    0.4672D-02, 0.4139D-02, 0.3467D-02, 0.2788D-02, 0.2177D-02,
     #    0.1661D-02, 0.1242D-02, 0.9134D-03, 0.6611D-03, 0.4721D-03,
     #    0.3337D-03, 0.2342D-03, 0.1627D-03, 0.1128D-03, 0.7755D-04,
     #    0.5352D-04, 0.3630D-04, 0.2484D-04, 0.1728D-04, 0.1149D-04,
     #    0.7571D-05, 0.5140D-05, 0.3272D-05, 0.2453D-05, 0.1894D-05,
     #    0.8474D-06, 0.5881D-06, 0.4114D-06, 0.2911D-06, 0.2091D-06,
     #    0.1532D-06, 0.1152D-06, 0.8923D-07, 0.7155D-07, 0.5952D-07,
     #    0.5132D-07/

      data (calcpts(j,17), j = 1,neta) /0.2719D-05, 0.3294D-05,
     #    0.3990D-05, 0.4835D-05, 0.5858D-05, 0.7098D-05, 0.8599D-05,
     #    0.1042D-04, 0.1262D-04, 0.1530D-04, 0.1854D-04, 0.2247D-04,
     #    0.2724D-04, 0.3303D-04, 0.4005D-04, 0.4862D-04, 0.5906D-04,
     #    0.7181D-04, 0.8748D-04, 0.1068D-03, 0.1309D-03, 0.1613D-03,
     #    0.2001D-03, 0.2506D-03, 0.3179D-03, 0.4097D-03, 0.5383D-03,
     #    0.7223D-03, 0.9891D-03, 0.1376D-02, 0.1929D-02, 0.2685D-02,
     #    0.3648D-02, 0.4749D-02, 0.5806D-02, 0.6560D-02, 0.6792D-02,
     #    0.6451D-02, 0.5686D-02, 0.4731D-02, 0.3782D-02, 0.2938D-02,
     #    0.2236D-02, 0.1671D-02, 0.1228D-02, 0.8906D-03, 0.6366D-03,
     #    0.4510D-03, 0.3165D-03, 0.2206D-03, 0.1529D-03, 0.1054D-03,
     #    0.7247D-04, 0.5007D-04, 0.3397D-04, 0.2328D-04, 0.1627D-04,
     #    0.1085D-04, 0.7844D-05, 0.4920D-05, 0.3835D-05, 0.2430D-05,
     #    0.1926D-05, 0.1583D-05, 0.6827D-06, 0.5235D-06, 0.4149D-06,
     #    0.3410D-06, 0.2907D-06, 0.2563D-06, 0.2329D-06, 0.2170D-06,
     #    0.2062D-06/

      data (calcpts(j,18), j = 1,neta) /0.3677D-05, 0.4455D-05,
     #    0.5396D-05, 0.6538D-05, 0.7922D-05, 0.9598D-05, 0.1163D-04,
     #    0.1409D-04, 0.1707D-04, 0.2068D-04, 0.2507D-04, 0.3038D-04,
     #    0.3683D-04, 0.4466D-04, 0.5415D-04, 0.6572D-04, 0.7983D-04,
     #    0.9706D-04, 0.1182D-03, 0.1443D-03, 0.1768D-03, 0.2176D-03,
     #    0.2697D-03, 0.3374D-03, 0.4273D-03, 0.5497D-03, 0.7207D-03,
     #    0.9649D-03, 0.1319D-02, 0.1833D-02, 0.2568D-02, 0.3579D-02,
     #    0.4879D-02, 0.6374D-02, 0.7823D-02, 0.8865D-02, 0.9184D-02,
     #    0.8698D-02, 0.7616D-02, 0.6282D-02, 0.4975D-02, 0.3839D-02,
     #    0.2909D-02, 0.2170D-02, 0.1597D-02, 0.1158D-02, 0.8295D-03,
     #    0.5883D-03, 0.4137D-03, 0.2884D-03, 0.2003D-03, 0.1379D-03,
     #    0.9479D-04, 0.6551D-04, 0.4453D-04, 0.3054D-04, 0.2084D-04,
     #    0.1450D-04, 0.9540D-05, 0.6857D-05, 0.4815D-05, 0.3211D-05,
     #    0.1906D-05, 0.1471D-05, 0.1174D-05, 0.9723D-06, 0.1680D-06,
     #    0.7420D-07, 0.1038D-07, -.3316D-07, -.6282D-07, -.8302D-07,
     #    -.9678D-07/

      data (calcpts(j,19), j = 1,neta) /0.4815D-05, 0.5834D-05,
     #    0.7067D-05, 0.8563D-05, 0.1038D-04, 0.1257D-04, 0.1523D-04,
     #    0.1845D-04, 0.2236D-04, 0.2709D-04, 0.3283D-04, 0.3979D-04,
     #    0.4823D-04, 0.5848D-04, 0.7091D-04, 0.8605D-04, 0.1045D-03,
     #    0.1270D-03, 0.1547D-03, 0.1887D-03, 0.2310D-03, 0.2842D-03,
     #    0.3518D-03, 0.4393D-03, 0.5551D-03, 0.7123D-03, 0.9310D-03,
     #    0.1242D-02, 0.1694D-02, 0.2349D-02, 0.3290D-02, 0.4593D-02,
     #    0.6281D-02, 0.8248D-02, 0.1018D-01, 0.1159D-01, 0.1204D-01,
     #    0.1138D-01, 0.9887D-02, 0.8062D-02, 0.6306D-02, 0.4815D-02,
     #    0.3625D-02, 0.2697D-02, 0.1984D-02, 0.1442D-02, 0.1035D-02,
     #    0.7363D-03, 0.5187D-03, 0.3626D-03, 0.2517D-03, 0.1742D-03,
     #    0.1200D-03, 0.8207D-04, 0.5639D-04, 0.3855D-04, 0.2627D-04,
     #    0.1773D-04, 0.1218D-04, 0.8433D-05, 0.5453D-05, 0.3663D-05,
     #    0.2898D-05, 0.1710D-05, 0.1355D-05, 0.1113D-05, 0.2814D-06,
     #    0.1690D-06, 0.9258D-07, 0.4042D-07, 0.4880D-08, -.1932D-07,
     #    -.3580D-07/

      data (calcpts(j,20), j = 1,neta) /0.6052D-05, 0.7332D-05,
     #    0.8882D-05, 0.1076D-04, 0.1304D-04, 0.1580D-04, 0.1914D-04,
     #    0.2319D-04, 0.2810D-04, 0.3405D-04, 0.4126D-04, 0.5000D-04,
     #    0.6060D-04, 0.7348D-04, 0.8909D-04, 0.1081D-03, 0.1313D-03,
     #    0.1595D-03, 0.1941D-03, 0.2368D-03, 0.2896D-03, 0.3558D-03,
     #    0.4397D-03, 0.5479D-03, 0.6905D-03, 0.8828D-03, 0.1149D-02,
     #    0.1527D-02, 0.2073D-02, 0.2866D-02, 0.4009D-02, 0.5604D-02,
     #    0.7695D-02, 0.1017D-01, 0.1265D-01, 0.1452D-01, 0.1516D-01,
     #    0.1433D-01, 0.1237D-01, 0.9951D-02, 0.7656D-02, 0.5758D-02,
     #    0.4289D-02, 0.3177D-02, 0.2336D-02, 0.1702D-02, 0.1227D-02,
     #    0.8756D-03, 0.6190D-03, 0.4342D-03, 0.3023D-03, 0.2098D-03,
     #    0.1449D-03, 0.9966D-04, 0.6879D-04, 0.4702D-04, 0.3254D-04,
     #    0.2208D-04, 0.1546D-04, 0.1077D-04, 0.7606D-05, 0.5022D-05,
     #    0.3505D-05, 0.2924D-05, 0.1862D-05, 0.1593D-05, 0.1409D-05,
     #    0.6174D-06, 0.5323D-06, 0.4742D-06, 0.4347D-06, 0.4077D-06,
     #    0.3894D-06/

      data (calcpts(j,21), j = 1,neta) /0.7225D-05, 0.8754D-05,
     #    0.1060D-04, 0.1285D-04, 0.1557D-04, 0.1886D-04, 0.2285D-04,
     #    0.2769D-04, 0.3354D-04, 0.4064D-04, 0.4925D-04, 0.5969D-04,
     #    0.7234D-04, 0.8770D-04, 0.1063D-03, 0.1290D-03, 0.1566D-03,
     #    0.1902D-03, 0.2314D-03, 0.2821D-03, 0.3446D-03, 0.4228D-03,
     #    0.5215D-03, 0.6482D-03, 0.8139D-03, 0.1036D-02, 0.1341D-02,
     #    0.1772D-02, 0.2391D-02, 0.3291D-02, 0.4591D-02, 0.6420D-02,
     #    0.8852D-02, 0.1179D-01, 0.1482D-01, 0.1722D-01, 0.1815D-01,
     #    0.1725D-01, 0.1484D-01, 0.1179D-01, 0.8890D-02, 0.6547D-02,
     #    0.4798D-02, 0.3523D-02, 0.2586D-02, 0.1889D-02, 0.1369D-02,
     #    0.9817D-03, 0.6970D-03, 0.4904D-03, 0.3405D-03, 0.2364D-03,
     #    0.1636D-03, 0.1165D-03, 0.7802D-04, 0.5204D-04, 0.3676D-04,
     #    0.2420D-04, 0.1352D-04, 0.1079D-04, 0.8921D-05, 0.7650D-05,
     #    0.1180D-06, -.4722D-06, -.8743D-06, -.1148D-05, -.1335D-05,
     #    -.1462D-05, -.1548D-05, -.1607D-05, -.1648D-05, -.1675D-05,
     #    -.1694D-05/

      data (calcpts(j,22), j = 1,neta) /0.8126D-05, 0.9846D-05,
     #    0.1193D-04, 0.1445D-04, 0.1751D-04, 0.2121D-04, 0.2570D-04,
     #    0.3114D-04, 0.3772D-04, 0.4571D-04, 0.5539D-04, 0.6712D-04,
     #    0.8135D-04, 0.9862D-04, 0.1195D-03, 0.1450D-03, 0.1760D-03,
     #    0.2137D-03, 0.2598D-03, 0.3164D-03, 0.3862D-03, 0.4730D-03,
     #    0.5821D-03, 0.7212D-03, 0.9018D-03, 0.1142D-02, 0.1468D-02,
     #    0.1925D-02, 0.2577D-02, 0.3522D-02, 0.4889D-02, 0.6829D-02,
     #    0.9448D-02, 0.1269D-01, 0.1617D-01, 0.1908D-01, 0.2047D-01,
     #    0.1972D-01, 0.1705D-01, 0.1345D-01, 0.9946D-02, 0.7133D-02,
     #    0.5103D-02, 0.3690D-02, 0.2694D-02, 0.1972D-02, 0.1441D-02,
     #    0.1041D-02, 0.7446D-03, 0.5284D-03, 0.3724D-03, 0.2599D-03,
     #    0.1772D-03, 0.1258D-03, 0.8889D-04, 0.5733D-04, 0.4279D-04,
     #    0.3074D-04, 0.2041D-04, 0.1124D-04, 0.9540D-05, 0.8379D-05,
     #    0.9215D-06, 0.3822D-06, 0.1478D-07, -.2354D-06, -.4059D-06,
     #    -.5221D-06, -.6012D-06, -.6551D-06, -.6919D-06, -.7169D-06,
     #    -.7339D-06/

      data (calcpts(j,23), j = 1,neta) /0.8555D-05, 0.1037D-04,
     #    0.1256D-04, 0.1521D-04, 0.1843D-04, 0.2233D-04, 0.2706D-04,
     #    0.3278D-04, 0.3971D-04, 0.4812D-04, 0.5831D-04, 0.7066D-04,
     #    0.8563D-04, 0.1038D-03, 0.1258D-03, 0.1526D-03, 0.1851D-03,
     #    0.2247D-03, 0.2731D-03, 0.3323D-03, 0.4050D-03, 0.4952D-03,
     #    0.6079D-03, 0.7506D-03, 0.9342D-03, 0.1175D-02, 0.1500D-02,
     #    0.1948D-02, 0.2582D-02, 0.3494D-02, 0.4813D-02, 0.6696D-02,
     #    0.9276D-02, 0.1255D-01, 0.1623D-01, 0.1956D-01, 0.2150D-01,
     #    0.2122D-01, 0.1870D-01, 0.1484D-01, 0.1085D-01, 0.7583D-02,
     #    0.5254D-02, 0.3705D-02, 0.2674D-02, 0.1958D-02, 0.1439D-02,
     #    0.1054D-02, 0.7605D-03, 0.5451D-03, 0.3902D-03, 0.2743D-03,
     #    0.1917D-03, 0.1316D-03, 0.9125D-04, 0.6188D-04, 0.4216D-04,
     #    0.3112D-04, 0.2148D-04, 0.1279D-04, 0.1140D-04, 0.3796D-05,
     #    0.3154D-05, 0.2717D-05, 0.2418D-05, 0.2215D-05, 0.2077D-05,
     #    0.1983D-05, 0.1919D-05, 0.1875D-05, 0.1845D-05, 0.1825D-05,
     #    0.1811D-05/

      data (calcpts(j,24), j = 1,neta) /0.8413D-05, 0.1019D-04,
     #    0.1235D-04, 0.1496D-04, 0.1813D-04, 0.2196D-04, 0.2661D-04,
     #    0.3224D-04, 0.3905D-04, 0.4732D-04, 0.5734D-04, 0.6948D-04,
     #    0.8420D-04, 0.1020D-03, 0.1237D-03, 0.1500D-03, 0.1819D-03,
     #    0.2207D-03, 0.2680D-03, 0.3259D-03, 0.3968D-03, 0.4842D-03,
     #    0.5930D-03, 0.7296D-03, 0.9037D-03, 0.1130D-02, 0.1429D-02,
     #    0.1837D-02, 0.2406D-02, 0.3215D-02, 0.4381D-02, 0.6047D-02,
     #    0.8359D-02, 0.1138D-01, 0.1491D-01, 0.1838D-01, 0.2084D-01,
     #    0.2132D-01, 0.1945D-01, 0.1584D-01, 0.1168D-01, 0.8046D-02,
     #    0.5399D-02, 0.3674D-02, 0.2589D-02, 0.1882D-02, 0.1394D-02,
     #    0.1027D-02, 0.7572D-03, 0.5472D-03, 0.3965D-03, 0.2795D-03,
     #    0.1985D-03, 0.1375D-03, 0.9440D-04, 0.6770D-04, 0.4313D-04,
     #    0.3334D-04, 0.2454D-04, 0.1643D-04, 0.8770D-05, 0.8095D-05,
     #    0.7637D-05, 0.6570D-06, 0.4437D-06, 0.2984D-06, 0.1995D-06,
     #    0.1320D-06, 0.8611D-07, 0.5480D-07, 0.3347D-07, 0.1894D-07,
     #    0.9044D-08/

      data (calcpts(j,25), j = 1,neta) /0.7746D-05, 0.9385D-05,
     #    0.1137D-04, 0.1377D-04, 0.1669D-04, 0.2022D-04, 0.2450D-04,
     #    0.2968D-04, 0.3595D-04, 0.4356D-04, 0.5279D-04, 0.6396D-04,
     #    0.7750D-04, 0.9393D-04, 0.1138D-03, 0.1380D-03, 0.1673D-03,
     #    0.2030D-03, 0.2464D-03, 0.2993D-03, 0.3640D-03, 0.4435D-03,
     #    0.5418D-03, 0.6644D-03, 0.8191D-03, 0.1017D-02, 0.1276D-02,
     #    0.1623D-02, 0.2097D-02, 0.2763D-02, 0.3711D-02, 0.5062D-02,
     #    0.6951D-02, 0.9470D-02, 0.1255D-01, 0.1582D-01, 0.1854D-01,
     #    0.1980D-01, 0.1897D-01, 0.1619D-01, 0.1236D-01, 0.8615D-02,
     #    0.5685D-02, 0.3727D-02, 0.2527D-02, 0.1798D-02, 0.1322D-02,
     #    0.9898D-03, 0.7401D-03, 0.5472D-03, 0.3930D-03, 0.2873D-03,
     #    0.2008D-03, 0.1385D-03, 0.9903D-04, 0.6815D-04, 0.4528D-04,
     #    0.2999D-04, 0.2199D-04, 0.1441D-04, 0.1379D-04, 0.6702D-05,
     #    0.6414D-05, 0.6217D-05, -.5833D-06, -.6745D-06, -.7366D-06,
     #    -.7790D-06, -.8078D-06, -.8274D-06, -.8408D-06, -.8499D-06,
     #    -.8561D-06/

      data (calcpts(j,26), j = 1,neta) /0.6715D-05, 0.8136D-05,
     #    0.9855D-05, 0.1194D-04, 0.1447D-04, 0.1753D-04, 0.2123D-04,
     #    0.2573D-04, 0.3117D-04, 0.3776D-04, 0.4576D-04, 0.5544D-04,
     #    0.6718D-04, 0.8141D-04, 0.9864D-04, 0.1196D-03, 0.1450D-03,
     #    0.1758D-03, 0.2132D-03, 0.2589D-03, 0.3145D-03, 0.3827D-03,
     #    0.4666D-03, 0.5705D-03, 0.7003D-03, 0.8648D-03, 0.1076D-02,
     #    0.1354D-02, 0.1727D-02, 0.2241D-02, 0.2960D-02, 0.3976D-02,
     #    0.5397D-02, 0.7320D-02, 0.9753D-02, 0.1251D-01, 0.1514D-01,
     #    0.1691D-01, 0.1715D-01, 0.1558D-01, 0.1263D-01, 0.9184D-02,
     #    0.6147D-02, 0.3950D-02, 0.2568D-02, 0.1754D-02, 0.1266D-02,
     #    0.9457D-03, 0.7134D-03, 0.5339D-03, 0.3943D-03, 0.2873D-03,
     #    0.2062D-03, 0.1459D-03, 0.1026D-03, 0.7161D-04, 0.5138D-04,
     #    0.3698D-04, 0.2292D-04, 0.1576D-04, 0.8751D-05, 0.8521D-05,
     #    0.1697D-05, 0.1590D-05, 0.1517D-05, 0.1467D-05, 0.1433D-05,
     #    0.1410D-05, 0.1394D-05, 0.1384D-05, 0.1376D-05, 0.1371D-05,
     #    0.1368D-05/

      data (calcpts(j,27), j = 1,neta) /0.5527D-05, 0.6697D-05,
     #    0.8112D-05, 0.9828D-05, 0.1191D-04, 0.1443D-04, 0.1748D-04,
     #    0.2118D-04, 0.2565D-04, 0.3108D-04, 0.3766D-04, 0.4563D-04,
     #    0.5529D-04, 0.6700D-04, 0.8117D-04, 0.9838D-04, 0.1193D-03,
     #    0.1446D-03, 0.1753D-03, 0.2127D-03, 0.2582D-03, 0.3138D-03,
     #    0.3820D-03, 0.4658D-03, 0.5698D-03, 0.7001D-03, 0.8652D-03,
     #    0.1078D-02, 0.1359D-02, 0.1736D-02, 0.2254D-02, 0.2975D-02,
     #    0.3975D-02, 0.5336D-02, 0.7100D-02, 0.9208D-02, 0.1142D-01,
     #    0.1330D-01, 0.1427D-01, 0.1389D-01, 0.1213D-01, 0.9453D-02,
     #    0.6646D-02, 0.4334D-02, 0.2749D-02, 0.1791D-02, 0.1239D-02,
     #    0.9080D-03, 0.6858D-03, 0.5201D-03, 0.3907D-03, 0.2893D-03,
     #    0.2107D-03, 0.1511D-03, 0.1076D-03, 0.7520D-04, 0.5248D-04,
     #    0.3666D-04, 0.2566D-04, 0.1810D-04, 0.1261D-04, 0.8501D-05,
     #    0.6429D-05, 0.4380D-05, 0.3013D-05, 0.2324D-05, 0.1642D-05,
     #    0.1631D-05, 0.9573D-06, 0.9524D-06, 0.9491D-06, 0.9468D-06,
     #    0.9452D-06/

      data (calcpts(j,28), j = 1,neta) /0.4356D-05, 0.5278D-05,
     #    0.6393D-05, 0.7746D-05, 0.9385D-05, 0.1137D-04, 0.1377D-04,
     #    0.1669D-04, 0.2022D-04, 0.2450D-04, 0.2968D-04, 0.3596D-04,
     #    0.4357D-04, 0.5279D-04, 0.6396D-04, 0.7751D-04, 0.9394D-04,
     #    0.1139D-03, 0.1380D-03, 0.1674D-03, 0.2031D-03, 0.2466D-03,
     #    0.2997D-03, 0.3648D-03, 0.4450D-03, 0.5445D-03, 0.6690D-03,
     #    0.8273D-03, 0.1031D-02, 0.1300D-02, 0.1660D-02, 0.2150D-02,
     #    0.2822D-02, 0.3731D-02, 0.4925D-02, 0.6402D-02, 0.8068D-02,
     #    0.9700D-02, 0.1093D-01, 0.1138D-01, 0.1074D-01, 0.9100D-02,
     #    0.6902D-02, 0.4741D-02, 0.3044D-02, 0.1922D-02, 0.1261D-02,
     #    0.8844D-03, 0.6548D-03, 0.4977D-03, 0.3789D-03, 0.2847D-03,
     #    0.2103D-03, 0.1528D-03, 0.1097D-03, 0.7798D-04, 0.5441D-04,
     #    0.3824D-04, 0.2613D-04, 0.1806D-04, 0.1267D-04, 0.8635D-05,
     #    0.5944D-05, 0.3927D-05, 0.3250D-05, 0.1909D-05, 0.1237D-05,
     #    0.1233D-05, 0.5641D-06, 0.5624D-06, 0.5613D-06, 0.5605D-06,
     #    0.5600D-06/

      data (calcpts(j,29), j = 1,neta) /0.3316D-05, 0.4017D-05,
     #    0.4866D-05, 0.5896D-05, 0.7143D-05, 0.8654D-05, 0.1048D-04,
     #    0.1270D-04, 0.1539D-04, 0.1864D-04, 0.2259D-04, 0.2737D-04,
     #    0.3316D-04, 0.4018D-04, 0.4868D-04, 0.5898D-04, 0.7148D-04,
     #    0.8663D-04, 0.1050D-03, 0.1273D-03, 0.1544D-03, 0.1873D-03,
     #    0.2274D-03, 0.2764D-03, 0.3363D-03, 0.4102D-03, 0.5017D-03,
     #    0.6164D-03, 0.7619D-03, 0.9490D-03, 0.1194D-02, 0.1520D-02,
     #    0.1957D-02, 0.2541D-02, 0.3310D-02, 0.4278D-02, 0.5426D-02,
     #    0.6659D-02, 0.7797D-02, 0.8574D-02, 0.8706D-02, 0.8034D-02,
     #    0.6662D-02, 0.4955D-02, 0.3351D-02, 0.2133D-02, 0.1347D-02,
     #    0.8913D-03, 0.6316D-03, 0.4717D-03, 0.3603D-03, 0.2743D-03,
     #    0.2056D-03, 0.1516D-03, 0.1102D-03, 0.7889D-04, 0.5555D-04,
     #    0.3887D-04, 0.2687D-04, 0.1887D-04, 0.1287D-04, 0.8864D-05,
     #    0.6196D-05, 0.4195D-05, 0.2861D-05, 0.1528D-05, 0.8609D-06,
     #    0.8608D-06, 0.1940D-06, 0.1939D-06, 0.1939D-06, 0.1938D-06,
     #    0.1938D-06/

      data (calcpts(j,30), j = 1,neta) /0.2456D-05, 0.2976D-05,
     #    0.3605D-05, 0.4368D-05, 0.5292D-05, 0.6411D-05, 0.7767D-05,
     #    0.9411D-05, 0.1140D-04, 0.1381D-04, 0.1674D-04, 0.2027D-04,
     #    0.2456D-04, 0.2976D-04, 0.3606D-04, 0.4369D-04, 0.5294D-04,
     #    0.6415D-04, 0.7774D-04, 0.9423D-04, 0.1142D-03, 0.1385D-03,
     #    0.1680D-03, 0.2040D-03, 0.2478D-03, 0.3016D-03, 0.3675D-03,
     #    0.4493D-03, 0.5515D-03, 0.6804D-03, 0.8454D-03, 0.1060D-02,
     #    0.1340D-02, 0.1708D-02, 0.2186D-02, 0.2794D-02, 0.3532D-02,
     #    0.4376D-02, 0.5249D-02, 0.6019D-02, 0.6490D-02, 0.6471D-02,
     #    0.5869D-02, 0.4789D-02, 0.3513D-02, 0.2351D-02, 0.1490D-02,
     #    0.9437D-03, 0.6290D-03, 0.4496D-03, 0.3378D-03, 0.2583D-03,
     #    0.1967D-03, 0.1476D-03, 0.1085D-03, 0.7861D-04, 0.5603D-04,
     #    0.3942D-04, 0.2812D-04, 0.1948D-04, 0.1350D-04, 0.9509D-05,
     #    0.6184D-05, 0.4190D-05, 0.2860D-05, 0.2196D-05, 0.1531D-05,
     #    0.8655D-06, 0.8663D-06, 0.2002D-06, 0.2006D-06, 0.2009D-06,
     #    0.2010D-06/

      data (calcpts(j,31), j = 1,neta) /0.1782D-05, 0.2159D-05,
     #    0.2615D-05, 0.3168D-05, 0.3839D-05, 0.4650D-05, 0.5634D-05,
     #    0.6826D-05, 0.8269D-05, 0.1002D-04, 0.1214D-04, 0.1471D-04,
     #    0.1782D-04, 0.2159D-04, 0.2615D-04, 0.3169D-04, 0.3839D-04,
     #    0.4652D-04, 0.5637D-04, 0.6831D-04, 0.8278D-04, 0.1003D-03,
     #    0.1217D-03, 0.1476D-03, 0.1791D-03, 0.2175D-03, 0.2644D-03,
     #    0.3220D-03, 0.3931D-03, 0.4814D-03, 0.5922D-03, 0.7325D-03,
     #    0.9115D-03, 0.1141D-02, 0.1435D-02, 0.1805D-02, 0.2259D-02,
     #    0.2796D-02, 0.3394D-02, 0.3997D-02, 0.4507D-02, 0.4786D-02,
     #    0.4704D-02, 0.4211D-02, 0.3395D-02, 0.2465D-02, 0.1639D-02,
     #    0.1036D-02, 0.6582D-03, 0.4417D-03, 0.3174D-03, 0.2395D-03,
     #    0.1833D-03, 0.1396D-03, 0.1045D-03, 0.7664D-04, 0.5541D-04,
     #    0.3948D-04, 0.2819D-04, 0.1956D-04, 0.1358D-04, 0.9596D-05,
     #    0.6273D-05, 0.4280D-05, 0.2951D-05, 0.2288D-05, 0.1623D-05,
     #    0.9582D-06, 0.9592D-06, 0.2932D-06, 0.2937D-06, 0.2940D-06,
     #    0.2942D-06/

      data (calcpts(j,32), j = 1,neta) /0.1272D-05, 0.1541D-05,
     #    0.1866D-05, 0.2261D-05, 0.2740D-05, 0.3319D-05, 0.4021D-05,
     #    0.4872D-05, 0.5902D-05, 0.7150D-05, 0.8664D-05, 0.1050D-04,
     #    0.1272D-04, 0.1541D-04, 0.1866D-04, 0.2261D-04, 0.2740D-04,
     #    0.3320D-04, 0.4022D-04, 0.4874D-04, 0.5904D-04, 0.7155D-04,
     #    0.8673D-04, 0.1051D-03, 0.1274D-03, 0.1546D-03, 0.1876D-03,
     #    0.2278D-03, 0.2770D-03, 0.3373D-03, 0.4117D-03, 0.5039D-03,
     #    0.6187D-03, 0.7624D-03, 0.9419D-03, 0.1164D-02, 0.1437D-02,
     #    0.1763D-02, 0.2141D-02, 0.2555D-02, 0.2964D-02, 0.3298D-02,
     #    0.3459D-02, 0.3363D-02, 0.2980D-02, 0.2382D-02, 0.1717D-02,
     #    0.1136D-02, 0.7172D-03, 0.4566D-03, 0.3082D-03, 0.2229D-03,
     #    0.1680D-03, 0.1290D-03, 0.9783D-04, 0.7330D-04, 0.5406D-04,
     #    0.3879D-04, 0.2751D-04, 0.1953D-04, 0.1356D-04, 0.9569D-05,
     #    0.6245D-05, 0.4252D-05, 0.2923D-05, 0.2259D-05, 0.1594D-05,
     #    0.9291D-06, 0.2634D-06, 0.2640D-06, 0.2645D-06, 0.2648D-06,
     #    0.2650D-06/

      data (calcpts(j,33), j = 1,neta) /0.8970D-06, 0.1087D-05,
     #    0.1317D-05, 0.1595D-05, 0.1933D-05, 0.2341D-05, 0.2837D-05,
     #    0.3437D-05, 0.4163D-05, 0.5044D-05, 0.6112D-05, 0.7404D-05,
     #    0.8970D-05, 0.1087D-04, 0.1317D-04, 0.1595D-04, 0.1933D-04,
     #    0.2341D-04, 0.2837D-04, 0.3437D-04, 0.4163D-04, 0.5045D-04,
     #    0.6112D-04, 0.7405D-04, 0.8972D-04, 0.1087D-03, 0.1317D-03,
     #    0.1597D-03, 0.1936D-03, 0.2347D-03, 0.2848D-03, 0.3457D-03,
     #    0.4200D-03, 0.5106D-03, 0.6210D-03, 0.7547D-03, 0.9159D-03,
     #    0.1109D-02, 0.1336D-02, 0.1597D-02, 0.1879D-02, 0.2154D-02,
     #    0.2370D-02, 0.2463D-02, 0.2373D-02, 0.2087D-02, 0.1657D-02,
     #    0.1189D-02, 0.7842D-03, 0.4950D-03, 0.3161D-03, 0.2139D-03,
     #    0.1556D-03, 0.1179D-03, 0.9002D-04, 0.6880D-04, 0.5155D-04,
     #    0.3760D-04, 0.2763D-04, 0.1966D-04, 0.1368D-04, 0.9687D-05,
     #    0.7028D-05, 0.5033D-05, 0.3036D-05, 0.2372D-05, 0.1707D-05,
     #    0.1042D-05, 0.1042D-05, 0.3762D-06, 0.3766D-06, 0.3768D-06,
     #    0.3770D-06/

      data (calcpts(j,34), j = 1,neta) /0.6268D-06, 0.7595D-06,
     #    0.9200D-06, 0.1115D-05, 0.1351D-05, 0.1636D-05, 0.1982D-05,
     #    0.2402D-05, 0.2909D-05, 0.3525D-05, 0.4271D-05, 0.5174D-05,
     #    0.6268D-05, 0.7595D-05, 0.9200D-05, 0.1115D-04, 0.1350D-04,
     #    0.1636D-04, 0.1982D-04, 0.2401D-04, 0.2908D-04, 0.3523D-04,
     #    0.4268D-04, 0.5169D-04, 0.6260D-04, 0.7581D-04, 0.9176D-04,
     #    0.1110D-03, 0.1343D-03, 0.1624D-03, 0.1961D-03, 0.2367D-03,
     #    0.2851D-03, 0.3429D-03, 0.4115D-03, 0.4925D-03, 0.5880D-03,
     #    0.7006D-03, 0.8336D-03, 0.9893D-03, 0.1167D-02, 0.1358D-02,
     #    0.1540D-02, 0.1681D-02, 0.1733D-02, 0.1659D-02, 0.1450D-02,
     #    0.1146D-02, 0.8190D-03, 0.5392D-03, 0.3403D-03, 0.2178D-03,
     #    0.1480D-03, 0.1076D-03, 0.8157D-04, 0.6259D-04, 0.4758D-04,
     #    0.3556D-04, 0.2612D-04, 0.1887D-04, 0.1348D-04, 0.9490D-05,
     #    0.6696D-05, 0.4633D-05, 0.3236D-05, 0.2238D-05, 0.1572D-05,
     #    0.1106D-05, 0.7737D-06, 0.5075D-06, 0.3744D-06, 0.3079D-06,
     #    0.1747D-06/

      data (calcpts(j,35), j = 1,neta) /0.4350D-06, 0.5271D-06,
     #    0.6385D-06, 0.7736D-06, 0.9373D-06, 0.1136D-05, 0.1376D-05,
     #    0.1667D-05, 0.2019D-05, 0.2446D-05, 0.2964D-05, 0.3591D-05,
     #    0.4350D-05, 0.5271D-05, 0.6385D-05, 0.7735D-05, 0.9372D-05,
     #    0.1135D-04, 0.1375D-04, 0.1666D-04, 0.2018D-04, 0.2445D-04,
     #    0.2961D-04, 0.3585D-04, 0.4340D-04, 0.5253D-04, 0.6354D-04,
     #    0.7681D-04, 0.9277D-04, 0.1119D-03, 0.1347D-03, 0.1618D-03,
     #    0.1937D-03, 0.2310D-03, 0.2742D-03, 0.3239D-03, 0.3809D-03,
     #    0.4467D-03, 0.5232D-03, 0.6132D-03, 0.7186D-03, 0.8385D-03,
     #    0.9666D-03, 0.1088D-02, 0.1179D-02, 0.1209D-02, 0.1152D-02,
     #    0.1002D-02, 0.7892D-03, 0.5624D-03, 0.3697D-03, 0.2333D-03,
     #    0.1496D-03, 0.1018D-03, 0.7418D-04, 0.5625D-04, 0.4316D-04,
     #    0.3279D-04, 0.2447D-04, 0.1795D-04, 0.1296D-04, 0.9234D-05,
     #    0.6505D-05, 0.4508D-05, 0.3110D-05, 0.2178D-05, 0.1446D-05,
     #    0.9797D-06, 0.6468D-06, 0.4471D-06, 0.3140D-06, 0.1808D-06,
     #    0.1142D-06/

      data (calcpts(j,36), j = 1,neta) /0.3005D-06, 0.3641D-06,
     #    0.4410D-06, 0.5343D-06, 0.6474D-06, 0.7844D-06, 0.9503D-06,
     #    0.1151D-05, 0.1395D-05, 0.1690D-05, 0.2047D-05, 0.2480D-05,
     #    0.3005D-05, 0.3641D-05, 0.4410D-05, 0.5343D-05, 0.6473D-05,
     #    0.7842D-05, 0.9500D-05, 0.1151D-04, 0.1394D-04, 0.1688D-04,
     #    0.2044D-04, 0.2475D-04, 0.2996D-04, 0.3624D-04, 0.4381D-04,
     #    0.5293D-04, 0.6385D-04, 0.7688D-04, 0.9234D-04, 0.1105D-03,
     #    0.1317D-03, 0.1561D-03, 0.1837D-03, 0.2147D-03, 0.2492D-03,
     #    0.2879D-03, 0.3319D-03, 0.3831D-03, 0.4434D-03, 0.5142D-03,
     #    0.5948D-03, 0.6807D-03, 0.7617D-03, 0.8210D-03, 0.8378D-03,
     #    0.7949D-03, 0.6898D-03, 0.5417D-03, 0.3854D-03, 0.2531D-03,
     #    0.1597D-03, 0.1025D-03, 0.6996D-04, 0.5100D-04, 0.3870D-04,
     #    0.2972D-04, 0.2253D-04, 0.1688D-04, 0.1235D-04, 0.8956D-05,
     #    0.6359D-05, 0.4494D-05, 0.3096D-05, 0.2163D-05, 0.1497D-05,
     #    0.1031D-05, 0.6979D-06, 0.4981D-06, 0.2982D-06, 0.2317D-06,
     #    0.1651D-06/

      data (calcpts(j,37), j = 1,neta) /0.2068D-06, 0.2505D-06,
     #    0.3035D-06, 0.3677D-06, 0.4455D-06, 0.5397D-06, 0.6539D-06,
     #    0.7923D-06, 0.9597D-06, 0.1163D-05, 0.1409D-05, 0.1707D-05,
     #    0.2068D-05, 0.2505D-05, 0.3035D-05, 0.3677D-05, 0.4454D-05,
     #    0.5396D-05, 0.6537D-05, 0.7918D-05, 0.9589D-05, 0.1161D-04,
     #    0.1406D-04, 0.1703D-04, 0.2060D-04, 0.2492D-04, 0.3011D-04,
     #    0.3636D-04, 0.4383D-04, 0.5271D-04, 0.6320D-04, 0.7547D-04,
     #    0.8960D-04, 0.1057D-03, 0.1236D-03, 0.1432D-03, 0.1645D-03,
     #    0.1875D-03, 0.2130D-03, 0.2420D-03, 0.2759D-03, 0.3161D-03,
     #    0.3636D-03, 0.4177D-03, 0.4753D-03, 0.5293D-03, 0.5682D-03,
     #    0.5779D-03, 0.5467D-03, 0.4734D-03, 0.3711D-03, 0.2636D-03,
     #    0.1730D-03, 0.1092D-03, 0.7015D-04, 0.4791D-04, 0.3500D-04,
     #    0.2655D-04, 0.2036D-04, 0.1550D-04, 0.1157D-04, 0.8508D-05,
     #    0.6110D-05, 0.4379D-05, 0.3046D-05, 0.2114D-05, 0.1514D-05,
     #    0.1048D-05, 0.7145D-06, 0.5147D-06, 0.3148D-06, 0.2482D-06,
     #    0.1816D-06/

      data (calcpts(j,38), j = 1,neta) /0.1419D-06, 0.1719D-06,
     #    0.2082D-06, 0.2523D-06, 0.3057D-06, 0.3703D-06, 0.4487D-06,
     #    0.5436D-06, 0.6585D-06, 0.7978D-06, 0.9667D-06, 0.1171D-05,
     #    0.1419D-05, 0.1719D-05, 0.2082D-05, 0.2523D-05, 0.3056D-05,
     #    0.3702D-05, 0.4485D-05, 0.5433D-05, 0.6579D-05, 0.7968D-05,
     #    0.9649D-05, 0.1168D-04, 0.1413D-04, 0.1709D-04, 0.2065D-04,
     #    0.2492D-04, 0.3002D-04, 0.3607D-04, 0.4320D-04, 0.5149D-04,
     #    0.6098D-04, 0.7165D-04, 0.8339D-04, 0.9600D-04, 0.1093D-03,
     #    0.1234D-03, 0.1383D-03, 0.1548D-03, 0.1737D-03, 0.1960D-03,
     #    0.2228D-03, 0.2547D-03, 0.2911D-03, 0.3297D-03, 0.3658D-03,
     #    0.3915D-03, 0.3972D-03, 0.3750D-03, 0.3241D-03, 0.2537D-03,
     #    0.1801D-03, 0.1181D-03, 0.7455D-04, 0.4790D-04, 0.3279D-04,
     #    0.2393D-04, 0.1820D-04, 0.1394D-04, 0.1061D-04, 0.7880D-05,
     #    0.5815D-05, 0.4149D-05, 0.2950D-05, 0.2084D-05, 0.1417D-05,
     #    0.1017D-05, 0.6842D-06, 0.2843D-06, 0.2844D-06, 0.2178D-06,
     #    0.1512D-06/

      data (calcpts(j,39), j = 1,neta) /0.9721D-07, 0.1178D-06,
     #    0.1427D-06, 0.1729D-06, 0.2094D-06, 0.2537D-06, 0.3074D-06,
     #    0.3724D-06, 0.4511D-06, 0.5466D-06, 0.6623D-06, 0.8023D-06,
     #    0.9720D-06, 0.1178D-05, 0.1427D-05, 0.1728D-05, 0.2094D-05,
     #    0.2537D-05, 0.3073D-05, 0.3722D-05, 0.4507D-05, 0.5459D-05,
     #    0.6610D-05, 0.8000D-05, 0.9679D-05, 0.1170D-04, 0.1414D-04,
     #    0.1705D-04, 0.2054D-04, 0.2466D-04, 0.2951D-04, 0.3513D-04,
     #    0.4153D-04, 0.4867D-04, 0.5644D-04, 0.6466D-04, 0.7316D-04,
     #    0.8184D-04, 0.9078D-04, 0.1003D-03, 0.1108D-03, 0.1231D-03,
     #    0.1379D-03, 0.1558D-03, 0.1771D-03, 0.2016D-03, 0.2277D-03,
     #    0.2518D-03, 0.2689D-03, 0.2724D-03, 0.2567D-03, 0.2216D-03,
     #    0.1733D-03, 0.1230D-03, 0.8063D-04, 0.5093D-04, 0.3276D-04,
     #    0.2239D-04, 0.1640D-04, 0.1247D-04, 0.9535D-05, 0.7270D-05,
     #    0.5404D-05, 0.4005D-05, 0.2872D-05, 0.2072D-05, 0.1473D-05,
     #    0.1006D-05, 0.7395D-06, 0.4729D-06, 0.3396D-06, 0.2730D-06,
     #    0.2064D-06/

      data (calcpts(j,40), j = 1,neta) /0.6647D-07, 0.8054D-07,
     #    0.9756D-07, 0.1182D-06, 0.1432D-06, 0.1735D-06, 0.2102D-06,
     #    0.2547D-06, 0.3085D-06, 0.3738D-06, 0.4529D-06, 0.5486D-06,
     #    0.6647D-06, 0.8053D-06, 0.9755D-06, 0.1182D-05, 0.1432D-05,
     #    0.1734D-05, 0.2101D-05, 0.2545D-05, 0.3082D-05, 0.3732D-05,
     #    0.4519D-05, 0.5470D-05, 0.6617D-05, 0.8001D-05, 0.9662D-05,
     #    0.1166D-04, 0.1403D-04, 0.1684D-04, 0.2014D-04, 0.2395D-04,
     #    0.2828D-04, 0.3308D-04, 0.3826D-04, 0.4367D-04, 0.4917D-04,
     #    0.5464D-04, 0.6008D-04, 0.6564D-04, 0.7160D-04, 0.7835D-04,
     #    0.8637D-04, 0.9616D-04, 0.1081D-03, 0.1225D-03, 0.1390D-03,
     #    0.1566D-03, 0.1729D-03, 0.1843D-03, 0.1864D-03, 0.1755D-03,
     #    0.1513D-03, 0.1183D-03, 0.8387D-04, 0.5499D-04, 0.3474D-04,
     #    0.2235D-04, 0.1530D-04, 0.1119D-04, 0.8507D-05, 0.6528D-05,
     #    0.4955D-05, 0.3703D-05, 0.2716D-05, 0.1963D-05, 0.1397D-05,
     #    0.9834D-06, 0.6902D-06, 0.4835D-06, 0.3369D-06, 0.2303D-06,
     #    0.1636D-06/

      data (calcpts(j,41), j = 1,neta) /0.4540D-07, 0.5501D-07,
     #    0.6663D-07, 0.8073D-07, 0.9782D-07, 0.1185D-06, 0.1436D-06,
     #    0.1740D-06, 0.2107D-06, 0.2553D-06, 0.3093D-06, 0.3747D-06,
     #    0.4540D-06, 0.5501D-06, 0.6663D-06, 0.8072D-06, 0.9780D-06,
     #    0.1185D-05, 0.1435D-05, 0.1738D-05, 0.2105D-05, 0.2549D-05,
     #    0.3087D-05, 0.3736D-05, 0.4519D-05, 0.5464D-05, 0.6598D-05,
     #    0.7957D-05, 0.9578D-05, 0.1149D-04, 0.1374D-04, 0.1633D-04,
     #    0.1926D-04, 0.2250D-04, 0.2597D-04, 0.2956D-04, 0.3316D-04,
     #    0.3667D-04, 0.4005D-04, 0.4337D-04, 0.4679D-04, 0.5052D-04,
     #    0.5486D-04, 0.6013D-04, 0.6665D-04, 0.7469D-04, 0.8439D-04,
     #    0.9556D-04, 0.1074D-03, 0.1184D-03, 0.1261D-03, 0.1274D-03,
     #    0.1198D-03, 0.1033D-03, 0.8069D-04, 0.5719D-04, 0.3748D-04,
     #    0.2367D-04, 0.1524D-04, 0.1043D-04, 0.7626D-05, 0.5800D-05,
     #    0.4447D-05, 0.3374D-05, 0.2521D-05, 0.1848D-05, 0.1328D-05,
     #    0.9483D-06, 0.6683D-06, 0.4617D-06, 0.3217D-06, 0.2217D-06,
     #    0.1484D-06/

      data (calcpts(j,42), j = 1,neta) /0.3100D-07, 0.3755D-07,
     #    0.4549D-07, 0.5512D-07, 0.6678D-07, 0.8090D-07, 0.9801D-07,
     #    0.1188D-06, 0.1439D-06, 0.1743D-06, 0.2112D-06, 0.2558D-06,
     #    0.3099D-06, 0.3755D-06, 0.4549D-06, 0.5511D-06, 0.6677D-06,
     #    0.8088D-06, 0.9797D-06, 0.1187D-05, 0.1437D-05, 0.1740D-05,
     #    0.2107D-05, 0.2550D-05, 0.3085D-05, 0.3729D-05, 0.4503D-05,
     #    0.5431D-05, 0.6536D-05, 0.7841D-05, 0.9368D-05, 0.1113D-04,
     #    0.1312D-04, 0.1531D-04, 0.1765D-04, 0.2005D-04, 0.2243D-04,
     #    0.2471D-04, 0.2685D-04, 0.2888D-04, 0.3088D-04, 0.3297D-04,
     #    0.3533D-04, 0.3814D-04, 0.4162D-04, 0.4599D-04, 0.5141D-04,
     #    0.5796D-04, 0.6552D-04, 0.7356D-04, 0.8100D-04, 0.8616D-04,
     #    0.8698D-04, 0.8179D-04, 0.7046D-04, 0.5502D-04, 0.3899D-04,
     #    0.2555D-04, 0.1615D-04, 0.1039D-04, 0.7120D-05, 0.5207D-05,
     #    0.3961D-05, 0.3035D-05, 0.2308D-05, 0.1722D-05, 0.1262D-05,
     #    0.9083D-06, 0.6484D-06, 0.4550D-06, 0.3217D-06, 0.2217D-06,
     #    0.1551D-06/

      data (calcpts(j,43), j = 1,neta) /0.2115D-07, 0.2562D-07,
     #    0.3104D-07, 0.3760D-07, 0.4556D-07, 0.5520D-07, 0.6687D-07,
     #    0.8102D-07, 0.9814D-07, 0.1189D-06, 0.1441D-06, 0.1745D-06,
     #    0.2115D-06, 0.2562D-06, 0.3103D-06, 0.3760D-06, 0.4555D-06,
     #    0.5518D-06, 0.6684D-06, 0.8097D-06, 0.9804D-06, 0.1187D-05,
     #    0.1438D-05, 0.1740D-05, 0.2105D-05, 0.2544D-05, 0.3072D-05,
     #    0.3704D-05, 0.4457D-05, 0.5347D-05, 0.6387D-05, 0.7585D-05,
     #    0.8936D-05, 0.1042D-04, 0.1200D-04, 0.1362D-04, 0.1520D-04,
     #    0.1670D-04, 0.1808D-04, 0.1934D-04, 0.2054D-04, 0.2173D-04,
     #    0.2303D-04, 0.2453D-04, 0.2637D-04, 0.2869D-04, 0.3162D-04,
     #    0.3529D-04, 0.3972D-04, 0.4485D-04, 0.5030D-04, 0.5534D-04,
     #    0.5882D-04, 0.5935D-04, 0.5579D-04, 0.4805D-04, 0.3751D-04,
     #    0.2657D-04, 0.1742D-04, 0.1101D-04, 0.7086D-05, 0.4853D-05,
     #    0.3553D-05, 0.2700D-05, 0.2073D-05, 0.1573D-05, 0.1167D-05,
     #    0.8600D-06, 0.6200D-06, 0.4400D-06, 0.3134D-06, 0.2201D-06,
     #    0.1534D-06/

      data (calcpts(j,44), j = 1,neta) /0.1442D-07, 0.1747D-07,
     #    0.2116D-07, 0.2564D-07, 0.3107D-07, 0.3764D-07, 0.4560D-07,
     #    0.5525D-07, 0.6692D-07, 0.8108D-07, 0.9824D-07, 0.1190D-06,
     #    0.1442D-06, 0.1747D-06, 0.2116D-06, 0.2564D-06, 0.3106D-06,
     #    0.3763D-06, 0.4558D-06, 0.5521D-06, 0.6685D-06, 0.8096D-06,
     #    0.9802D-06, 0.1186D-05, 0.1435D-05, 0.1735D-05, 0.2094D-05,
     #    0.2525D-05, 0.3039D-05, 0.3645D-05, 0.4353D-05, 0.5168D-05,
     #    0.6086D-05, 0.7095D-05, 0.8165D-05, 0.9254D-05, 0.1032D-04,
     #    0.1131D-04, 0.1221D-04, 0.1301D-04, 0.1374D-04, 0.1444D-04,
     #    0.1516D-04, 0.1597D-04, 0.1694D-04, 0.1816D-04, 0.1971D-04,
     #    0.2169D-04, 0.2416D-04, 0.2718D-04, 0.3065D-04, 0.3435D-04,
     #    0.3778D-04, 0.4014D-04, 0.4048D-04, 0.3803D-04, 0.3275D-04,
     #    0.2556D-04, 0.1811D-04, 0.1187D-04, 0.7499D-05, 0.4826D-05,
     #    0.3306D-05, 0.2419D-05, 0.1840D-05, 0.1413D-05, 0.1073D-05,
     #    0.7996D-06, 0.5863D-06, 0.4197D-06, 0.2997D-06, 0.2130D-06,
     #    0.1463D-06/

      data (calcpts(j,45), j = 1,neta) /0.9834D-08, 0.1192D-07,
     #    0.1443D-07, 0.1749D-07, 0.2119D-07, 0.2567D-07, 0.3110D-07,
     #    0.3768D-07, 0.4564D-07, 0.5530D-07, 0.6700D-07, 0.8117D-07,
     #    0.9834D-07, 0.1191D-06, 0.1443D-06, 0.1748D-06, 0.2118D-06,
     #    0.2566D-06, 0.3108D-06, 0.3765D-06, 0.4559D-06, 0.5521D-06,
     #    0.6685D-06, 0.8090D-06, 0.9786D-06, 0.1183D-05, 0.1428D-05,
     #    0.1722D-05, 0.2072D-05, 0.2485D-05, 0.2968D-05, 0.3523D-05,
     #    0.4148D-05, 0.4833D-05, 0.5559D-05, 0.6296D-05, 0.7012D-05,
     #    0.7676D-05, 0.8269D-05, 0.8788D-05, 0.9244D-05, 0.9661D-05,
     #    0.1007D-04, 0.1051D-04, 0.1102D-04, 0.1166D-04, 0.1247D-04,
     #    0.1351D-04, 0.1485D-04, 0.1653D-04, 0.1857D-04, 0.2094D-04,
     #    0.2345D-04, 0.2578D-04, 0.2738D-04, 0.2760D-04, 0.2593D-04,
     #    0.2233D-04, 0.1743D-04, 0.1234D-04, 0.8090D-05, 0.5112D-05,
     #    0.3293D-05, 0.2254D-05, 0.1654D-05, 0.1254D-05, 0.9610D-06,
     #    0.7277D-06, 0.5477D-06, 0.4011D-06, 0.2877D-06, 0.2077D-06,
     #    0.1477D-06/

      data (calcpts(j,46), j = 1,neta) /0.6703D-08, 0.8121D-08,
     #    0.9837D-08, 0.1192D-07, 0.1444D-07, 0.1750D-07, 0.2120D-07,
     #    0.2568D-07, 0.3111D-07, 0.3769D-07, 0.4567D-07, 0.5532D-07,
     #    0.6702D-07, 0.8121D-07, 0.9836D-07, 0.1192D-06, 0.1444D-06,
     #    0.1749D-06, 0.2119D-06, 0.2566D-06, 0.3108D-06, 0.3763D-06,
     #    0.4556D-06, 0.5514D-06, 0.6670D-06, 0.8063D-06, 0.9734D-06,
     #    0.1174D-05, 0.1412D-05, 0.1694D-05, 0.2022D-05, 0.2400D-05,
     #    0.2825D-05, 0.3292D-05, 0.3785D-05, 0.4284D-05, 0.4768D-05,
     #    0.5214D-05, 0.5608D-05, 0.5947D-05, 0.6237D-05, 0.6492D-05,
     #    0.6730D-05, 0.6974D-05, 0.7248D-05, 0.7579D-05, 0.7998D-05,
     #    0.8541D-05, 0.9245D-05, 0.1015D-04, 0.1129D-04, 0.1268D-04,
     #    0.1429D-04, 0.1600D-04, 0.1758D-04, 0.1867D-04, 0.1881D-04,
     #    0.1768D-04, 0.1522D-04, 0.1187D-04, 0.8410D-05, 0.5511D-05,
     #    0.3483D-05, 0.2243D-05, 0.1537D-05, 0.1125D-05, 0.8554D-06,
     #    0.6561D-06, 0.4988D-06, 0.3721D-06, 0.2728D-06, 0.1974D-06,
     #    0.1408D-06/

      data (calcpts(j,47), j = 1,neta) /0.4567D-08, 0.5534D-08,
     #    0.6703D-08, 0.8122D-08, 0.9841D-08, 0.1192D-07, 0.1444D-07,
     #    0.1750D-07, 0.2120D-07, 0.2568D-07, 0.3112D-07, 0.3770D-07,
     #    0.4567D-07, 0.5534D-07, 0.6703D-07, 0.8121D-07, 0.9838D-07,
     #    0.1192D-06, 0.1444D-06, 0.1749D-06, 0.2118D-06, 0.2564D-06,
     #    0.3105D-06, 0.3757D-06, 0.4545D-06, 0.5494D-06, 0.6633D-06,
     #    0.7997D-06, 0.9622D-06, 0.1154D-05, 0.1378D-05, 0.1635D-05,
     #    0.1925D-05, 0.2242D-05, 0.2577D-05, 0.2916D-05, 0.3243D-05,
     #    0.3544D-05, 0.3808D-05, 0.4032D-05, 0.4219D-05, 0.4378D-05,
     #    0.4520D-05, 0.4658D-05, 0.4807D-05, 0.4980D-05, 0.5197D-05,
     #    0.5476D-05, 0.5841D-05, 0.6317D-05, 0.6932D-05, 0.7708D-05,
     #    0.8653D-05, 0.9745D-05, 0.1091D-04, 0.1199D-04, 0.1273D-04,
     #    0.1283D-04, 0.1205D-04, 0.1037D-04, 0.8089D-05, 0.5729D-05,
     #    0.3755D-05, 0.2372D-05, 0.1527D-05, 0.1047D-05, 0.7661D-06,
     #    0.5821D-06, 0.4461D-06, 0.3387D-06, 0.2527D-06, 0.1854D-06,
     #    0.1334D-06/

      data (calcpts(j,48), j = 1,neta) /0.3113D-08, 0.3771D-08,
     #    0.4568D-08, 0.5535D-08, 0.6707D-08, 0.8125D-08, 0.9843D-08,
     #    0.1193D-07, 0.1445D-07, 0.1750D-07, 0.2121D-07, 0.2569D-07,
     #    0.3113D-07, 0.3771D-07, 0.4568D-07, 0.5534D-07, 0.6705D-07,
     #    0.8122D-07, 0.9839D-07, 0.1192D-06, 0.1443D-06, 0.1748D-06,
     #    0.2116D-06, 0.2561D-06, 0.3097D-06, 0.3744D-06, 0.4520D-06,
     #    0.5450D-06, 0.6557D-06, 0.7863D-06, 0.9388D-06, 0.1114D-05,
     #    0.1311D-05, 0.1527D-05, 0.1755D-05, 0.1986D-05, 0.2208D-05,
     #    0.2411D-05, 0.2588D-05, 0.2738D-05, 0.2860D-05, 0.2962D-05,
     #    0.3048D-05, 0.3128D-05, 0.3210D-05, 0.3302D-05, 0.3414D-05,
     #    0.3557D-05, 0.3744D-05, 0.3991D-05, 0.4314D-05, 0.4731D-05,
     #    0.5259D-05, 0.5902D-05, 0.6646D-05, 0.7437D-05, 0.8169D-05,
     #    0.8672D-05, 0.8739D-05, 0.8207D-05, 0.7063D-05, 0.5512D-05,
     #    0.3904D-05, 0.2558D-05, 0.1616D-05, 0.1041D-05, 0.7134D-06,
     #    0.5221D-06, 0.3968D-06, 0.3048D-06, 0.2315D-06, 0.1728D-06,
     #    0.1261D-06/

      data (calcpts(j,49), j = 1,neta) /0.2121D-08, 0.2570D-08,
     #    0.3113D-08, 0.3772D-08, 0.4570D-08, 0.5536D-08, 0.6708D-08,
     #    0.8127D-08, 0.9844D-08, 0.1193D-07, 0.1445D-07, 0.1751D-07,
     #    0.2121D-07, 0.2570D-07, 0.3113D-07, 0.3771D-07, 0.4569D-07,
     #    0.5535D-07, 0.6704D-07, 0.8121D-07, 0.9834D-07, 0.1191D-06,
     #    0.1442D-06, 0.1745D-06, 0.2111D-06, 0.2551D-06, 0.3080D-06,
     #    0.3714D-06, 0.4468D-06, 0.5358D-06, 0.6397D-06, 0.7591D-06,
     #    0.8934D-06, 0.1040D-05, 0.1195D-05, 0.1352D-05, 0.1503D-05,
     #    0.1641D-05, 0.1761D-05, 0.1861D-05, 0.1942D-05, 0.2007D-05,
     #    0.2061D-05, 0.2109D-05, 0.2155D-05, 0.2205D-05, 0.2263D-05,
     #    0.2336D-05, 0.2431D-05, 0.2557D-05, 0.2724D-05, 0.2944D-05,
     #    0.3228D-05, 0.3586D-05, 0.4024D-05, 0.4530D-05, 0.5069D-05,
     #    0.5567D-05, 0.5910D-05, 0.5955D-05, 0.5592D-05, 0.4813D-05,
     #    0.3756D-05, 0.2660D-05, 0.1743D-05, 0.1101D-05, 0.7091D-06,
     #    0.4858D-06, 0.3558D-06, 0.2705D-06, 0.2078D-06, 0.1578D-06,
     #    0.1178D-06/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ixi .ge. 72) ieta = 72
         pxi = (dlxi - dlaxi(ixi))/delxi
         f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #        (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #        pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
         f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #        (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #        pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
         f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #        (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #        pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
         peta = (dleta - dlaeta(ieta))/deleta
         h1bar_Lg = peta*(peta-1d0)/2d0*f(-1) +
     #        (1d0 - peta**2)*f(0) +
CMB  #        + peta*(peta+1d0)/2d0*f(1)
     #        peta*(peta+1d0)/2d0*f(1)
      return
      end

CDECK  ID>, QCORRT.

c     ========================================
      double precision function h1_HTq(eta,xi)
c     ========================================

c     eq (26) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subcqht in the original code.
c     Called schqt in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /-.9757D-09, -.1701D-08,
     #    -.2961D-08, -.5155D-08, -.8967D-08, -.1559D-07, -.2708D-07,
     #    -.4703D-07, -.8158D-07, -.1415D-06, -.2452D-06, -.4245D-06,
     #    -.7345D-06, -.1270D-05, -.2194D-05, -.3787D-05, -.6531D-05,
     #    -.1125D-04, -.1936D-04, -.3327D-04, -.5709D-04, -.9784D-04,
     #    -.1674D-03, -.2859D-03, -.4868D-03, -.8266D-03, -.1398D-02,
     #    -.2352D-02, -.3932D-02, -.6512D-02, -.1065D-01, -.1711D-01,
     #    -.2682D-01, -.4073D-01, -.5935D-01, -.8225D-01, -.1077D+00,
     #    -.1325D+00, -.1534D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     #    -.1612D+00, -.1472D+00, -.1307D+00, -.1132D+00, -.9612D-01,
     #    -.8027D-01, -.6602D-01, -.5365D-01, -.4317D-01, -.3440D-01,
     #    -.2727D-01, -.2137D-01, -.1673D-01, -.1295D-01, -.1003D-01,
     #    -.7682D-02, -.5769D-02, -.4444D-02, -.3410D-02, -.2522D-02,
     #    -.1930D-02, -.1485D-02, -.1039D-02, -.7414D-03, -.5931D-03,
     #    -.4443D-03, -.2950D-03, -.2956D-03, -.1459D-03, -.1462D-03,
     #    -.1464D-03/

      data (calcpts(j, 2), j = 1,neta) /-.9756D-09, -.1701D-08,
     #    -.2961D-08, -.5155D-08, -.8966D-08, -.1559D-07, -.2708D-07,
     #    -.4701D-07, -.8156D-07, -.1415D-06, -.2452D-06, -.4245D-06,
     #    -.7345D-06, -.1270D-05, -.2194D-05, -.3786D-05, -.6529D-05,
     #    -.1125D-04, -.1936D-04, -.3327D-04, -.5708D-04, -.9783D-04,
     #    -.1674D-03, -.2857D-03, -.4866D-03, -.8264D-03, -.1397D-02,
     #    -.2352D-02, -.3932D-02, -.6511D-02, -.1065D-01, -.1711D-01,
     #    -.2682D-01, -.4073D-01, -.5935D-01, -.8225D-01, -.1076D+00,
     #    -.1325D+00, -.1534D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     #    -.1612D+00, -.1472D+00, -.1307D+00, -.1132D+00, -.9610D-01,
     #    -.8026D-01, -.6600D-01, -.5363D-01, -.4316D-01, -.3439D-01,
     #    -.2725D-01, -.2135D-01, -.1672D-01, -.1293D-01, -.1001D-01,
     #    -.7667D-02, -.5903D-02, -.4428D-02, -.3395D-02, -.2507D-02,
     #    -.1914D-02, -.1470D-02, -.1023D-02, -.8760D-03, -.5777D-03,
     #    -.4288D-03, -.2796D-03, -.2801D-03, -.1305D-03, -.1308D-03,
     #    -.1309D-03/

      data (calcpts(j, 3), j = 1,neta) /-.9753D-09, -.1700D-08,
     #    -.2960D-08, -.5153D-08, -.8964D-08, -.1558D-07, -.2707D-07,
     #    -.4701D-07, -.8154D-07, -.1414D-06, -.2450D-06, -.4243D-06,
     #    -.7343D-06, -.1270D-05, -.2193D-05, -.3785D-05, -.6528D-05,
     #    -.1124D-04, -.1935D-04, -.3325D-04, -.5708D-04, -.9781D-04,
     #    -.1673D-03, -.2857D-03, -.4866D-03, -.8262D-03, -.1397D-02,
     #    -.2351D-02, -.3931D-02, -.6510D-02, -.1064D-01, -.1710D-01,
     #    -.2681D-01, -.4072D-01, -.5934D-01, -.8223D-01, -.1076D+00,
     #    -.1325D+00, -.1533D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     #    -.1612D+00, -.1472D+00, -.1307D+00, -.1132D+00, -.9611D-01,
     #    -.8024D-01, -.6598D-01, -.5376D-01, -.4314D-01, -.3437D-01,
     #    -.2723D-01, -.2133D-01, -.1670D-01, -.1291D-01, -.9990D-02,
     #    -.7644D-02, -.5881D-02, -.4405D-02, -.3372D-02, -.2484D-02,
     #    -.1892D-02, -.1447D-02, -.1001D-02, -.8533D-03, -.5550D-03,
     #    -.4062D-03, -.2570D-03, -.2575D-03, -.1079D-03, -.1081D-03,
     #    -.1083D-03/

      data (calcpts(j, 4), j = 1,neta) /-.9749D-09, -.1699D-08,
     #    -.2960D-08, -.5150D-08, -.8961D-08, -.1558D-07, -.2706D-07,
     #    -.4698D-07, -.8151D-07, -.1414D-06, -.2450D-06, -.4241D-06,
     #    -.7340D-06, -.1269D-05, -.2192D-05, -.3785D-05, -.6526D-05,
     #    -.1124D-04, -.1934D-04, -.3325D-04, -.5704D-04, -.9777D-04,
     #    -.1673D-03, -.2855D-03, -.4864D-03, -.8260D-03, -.1397D-02,
     #    -.2351D-02, -.3930D-02, -.6508D-02, -.1064D-01, -.1710D-01,
     #    -.2680D-01, -.4071D-01, -.5932D-01, -.8222D-01, -.1076D+00,
     #    -.1325D+00, -.1533D+00, -.1673D+00, -.1729D+00, -.1704D+00,
     #    -.1611D+00, -.1472D+00, -.1306D+00, -.1132D+00, -.9609D-01,
     #    -.8020D-01, -.6610D-01, -.5373D-01, -.4325D-01, -.3448D-01,
     #    -.2720D-01, -.2144D-01, -.1666D-01, -.1288D-01, -.9957D-02,
     #    -.7611D-02, -.5847D-02, -.4372D-02, -.3339D-02, -.2601D-02,
     #    -.1859D-02, -.1414D-02, -.1118D-02, -.8201D-03, -.5218D-03,
     #    -.3729D-03, -.3737D-03, -.2243D-03, -.2246D-03, -.7488D-04,
     #    -.7505D-04/

      data (calcpts(j, 5), j = 1,neta) /-.9743D-09, -.1698D-08,
     #    -.2958D-08, -.5147D-08, -.8956D-08, -.1557D-07, -.2705D-07,
     #    -.4696D-07, -.8146D-07, -.1413D-06, -.2448D-06, -.4240D-06,
     #    -.7335D-06, -.1268D-05, -.2191D-05, -.3781D-05, -.6522D-05,
     #    -.1124D-04, -.1933D-04, -.3323D-04, -.5702D-04, -.9773D-04,
     #    -.1672D-03, -.2855D-03, -.4862D-03, -.8256D-03, -.1396D-02,
     #    -.2350D-02, -.3928D-02, -.6505D-02, -.1064D-01, -.1709D-01,
     #    -.2679D-01, -.4069D-01, -.5930D-01, -.8219D-01, -.1076D+00,
     #    -.1324D+00, -.1533D+00, -.1672D+00, -.1729D+00, -.1703D+00,
     #    -.1611D+00, -.1472D+00, -.1306D+00, -.1132D+00, -.9609D-01,
     #    -.8015D-01, -.6605D-01, -.5368D-01, -.4320D-01, -.3444D-01,
     #    -.2730D-01, -.2140D-01, -.1661D-01, -.1298D-01, -.9909D-02,
     #    -.7712D-02, -.5799D-02, -.4473D-02, -.3440D-02, -.2552D-02,
     #    -.1960D-02, -.1365D-02, -.1069D-02, -.7713D-03, -.6230D-03,
     #    -.4742D-03, -.3249D-03, -.1755D-03, -.1758D-03, -.1761D-03,
     #    -.2626D-04/

      data (calcpts(j, 6), j = 1,neta) /-.9735D-09, -.1697D-08,
     #    -.2955D-08, -.5144D-08, -.8947D-08, -.1555D-07, -.2702D-07,
     #    -.4691D-07, -.8139D-07, -.1411D-06, -.2447D-06, -.4236D-06,
     #    -.7330D-06, -.1267D-05, -.2189D-05, -.3779D-05, -.6517D-05,
     #    -.1123D-04, -.1932D-04, -.3320D-04, -.5697D-04, -.9766D-04,
     #    -.1671D-03, -.2853D-03, -.4858D-03, -.8250D-03, -.1395D-02,
     #    -.2348D-02, -.3925D-02, -.6501D-02, -.1063D-01, -.1708D-01,
     #    -.2678D-01, -.4067D-01, -.5927D-01, -.8214D-01, -.1075D+00,
     #    -.1324D+00, -.1532D+00, -.1672D+00, -.1728D+00, -.1703D+00,
     #    -.1611D+00, -.1472D+00, -.1306D+00, -.1132D+00, -.9608D-01,
     #    -.8023D-01, -.6598D-01, -.5361D-01, -.4313D-01, -.3436D-01,
     #    -.2723D-01, -.2132D-01, -.1669D-01, -.1291D-01, -.9987D-02,
     #    -.7641D-02, -.5877D-02, -.4402D-02, -.3369D-02, -.2480D-02,
     #    -.1888D-02, -.1444D-02, -.1147D-02, -.8498D-03, -.5515D-03,
     #    -.4026D-03, -.2534D-03, -.2540D-03, -.1043D-03, -.1046D-03,
     #    -.1047D-03/

      data (calcpts(j, 7), j = 1,neta) /-.9721D-09, -.1695D-08,
     #    -.2951D-08, -.5137D-08, -.8936D-08, -.1553D-07, -.2698D-07,
     #    -.4686D-07, -.8129D-07, -.1410D-06, -.2443D-06, -.4231D-06,
     #    -.7321D-06, -.1266D-05, -.2187D-05, -.3774D-05, -.6510D-05,
     #    -.1121D-04, -.1930D-04, -.3317D-04, -.5691D-04, -.9755D-04,
     #    -.1669D-03, -.2849D-03, -.4853D-03, -.8241D-03, -.1394D-02,
     #    -.2346D-02, -.3921D-02, -.6495D-02, -.1062D-01, -.1707D-01,
     #    -.2676D-01, -.4064D-01, -.5922D-01, -.8209D-01, -.1075D+00,
     #    -.1323D+00, -.1531D+00, -.1671D+00, -.1727D+00, -.1702D+00,
     #    -.1610D+00, -.1471D+00, -.1306D+00, -.1131D+00, -.9606D-01,
     #    -.8013D-01, -.6602D-01, -.5365D-01, -.4318D-01, -.3441D-01,
     #    -.2727D-01, -.2137D-01, -.1674D-01, -.1295D-01, -.1003D-01,
     #    -.7686D-02, -.5772D-02, -.4447D-02, -.3414D-02, -.2526D-02,
     #    -.1933D-02, -.1489D-02, -.1042D-02, -.7449D-03, -.5966D-03,
     #    -.4477D-03, -.2985D-03, -.5991D-03, -.1494D-03, -.1497D-03,
     #    -.1498D-03/

      data (calcpts(j, 8), j = 1,neta) /-.9703D-09, -.1691D-08,
     #    -.2945D-08, -.5127D-08, -.8919D-08, -.1550D-07, -.2693D-07,
     #    -.4678D-07, -.8114D-07, -.1407D-06, -.2438D-06, -.4223D-06,
     #    -.7308D-06, -.1264D-05, -.2183D-05, -.3768D-05, -.6498D-05,
     #    -.1119D-04, -.1926D-04, -.3311D-04, -.5682D-04, -.9739D-04,
     #    -.1666D-03, -.2846D-03, -.4845D-03, -.8229D-03, -.1392D-02,
     #    -.2342D-02, -.3917D-02, -.6486D-02, -.1061D-01, -.1705D-01,
     #    -.2672D-01, -.4059D-01, -.5917D-01, -.8200D-01, -.1074D+00,
     #    -.1322D+00, -.1530D+00, -.1670D+00, -.1726D+00, -.1702D+00,
     #    -.1610D+00, -.1471D+00, -.1305D+00, -.1131D+00, -.9603D-01,
     #    -.8013D-01, -.6602D-01, -.5365D-01, -.4318D-01, -.3441D-01,
     #    -.2727D-01, -.2137D-01, -.1674D-01, -.1295D-01, -.1003D-01,
     #    -.7682D-02, -.5768D-02, -.4443D-02, -.3410D-02, -.2522D-02,
     #    -.1930D-02, -.1485D-02, -.1039D-02, -.7411D-03, -.5928D-03,
     #    -.4439D-03, -.2947D-03, -.2952D-03, -.1456D-03, -.1459D-03,
     #    -.1460D-03/

      data (calcpts(j, 9), j = 1,neta) /-.9676D-09, -.1687D-08,
     #    -.2937D-08, -.5112D-08, -.8895D-08, -.1546D-07, -.2687D-07,
     #    -.4664D-07, -.8092D-07, -.1403D-06, -.2433D-06, -.4212D-06,
     #    -.7289D-06, -.1260D-05, -.2177D-05, -.3759D-05, -.6482D-05,
     #    -.1117D-04, -.1922D-04, -.3304D-04, -.5668D-04, -.9717D-04,
     #    -.1663D-03, -.2839D-03, -.4836D-03, -.8212D-03, -.1389D-02,
     #    -.2338D-02, -.3909D-02, -.6474D-02, -.1059D-01, -.1701D-01,
     #    -.2668D-01, -.4052D-01, -.5907D-01, -.8188D-01, -.1072D+00,
     #    -.1320D+00, -.1528D+00, -.1668D+00, -.1725D+00, -.1700D+00,
     #    -.1608D+00, -.1470D+00, -.1304D+00, -.1130D+00, -.9599D-01,
     #    -.8021D-01, -.6595D-01, -.5358D-01, -.4310D-01, -.3448D-01,
     #    -.2719D-01, -.2129D-01, -.1666D-01, -.1288D-01, -.9954D-02,
     #    -.7607D-02, -.5844D-02, -.4518D-02, -.3335D-02, -.2597D-02,
     #    -.1855D-02, -.1410D-02, -.1114D-02, -.8161D-03, -.6677D-03,
     #    -.3689D-03, -.3697D-03, -.2202D-03, -.2206D-03, -.7083D-04,
     #    -.7100D-04/

      data (calcpts(j,10), j = 1,neta) /-.9636D-09, -.1680D-08,
     #    -.2925D-08, -.5093D-08, -.8858D-08, -.1540D-07, -.2675D-07,
     #    -.4646D-07, -.8061D-07, -.1398D-06, -.2423D-06, -.4196D-06,
     #    -.7262D-06, -.1256D-05, -.2169D-05, -.3745D-05, -.6458D-05,
     #    -.1113D-04, -.1915D-04, -.3292D-04, -.5650D-04, -.9684D-04,
     #    -.1657D-03, -.2829D-03, -.4819D-03, -.8185D-03, -.1384D-02,
     #    -.2331D-02, -.3897D-02, -.6455D-02, -.1056D-01, -.1697D-01,
     #    -.2661D-01, -.4042D-01, -.5892D-01, -.8169D-01, -.1070D+00,
     #    -.1318D+00, -.1526D+00, -.1666D+00, -.1723D+00, -.1698D+00,
     #    -.1607D+00, -.1468D+00, -.1304D+00, -.1130D+00, -.9592D-01,
     #    -.8004D-01, -.6593D-01, -.5355D-01, -.4308D-01, -.3445D-01,
     #    -.2717D-01, -.2141D-01, -.1663D-01, -.1285D-01, -.9924D-02,
     #    -.7578D-02, -.5814D-02, -.4489D-02, -.3306D-02, -.2567D-02,
     #    -.1975D-02, -.1380D-02, -.1084D-02, -.7864D-03, -.6381D-03,
     #    -.4892D-03, -.3400D-03, -.1905D-03, -.1909D-03, -.1912D-03,
     #    -.4133D-04/

      data (calcpts(j,11), j = 1,neta) /-.9579D-09, -.1670D-08,
     #    -.2909D-08, -.5063D-08, -.8807D-08, -.1531D-07, -.2660D-07,
     #    -.4619D-07, -.8015D-07, -.1390D-06, -.2409D-06, -.4172D-06,
     #    -.7221D-06, -.1249D-05, -.2157D-05, -.3724D-05, -.6425D-05,
     #    -.1107D-04, -.1905D-04, -.3275D-04, -.5621D-04, -.9635D-04,
     #    -.1649D-03, -.2816D-03, -.4796D-03, -.8148D-03, -.1378D-02,
     #    -.2320D-02, -.3880D-02, -.6428D-02, -.1051D-01, -.1690D-01,
     #    -.2650D-01, -.4027D-01, -.5871D-01, -.8143D-01, -.1067D+00,
     #    -.1314D+00, -.1522D+00, -.1662D+00, -.1719D+00, -.1695D+00,
     #    -.1604D+00, -.1467D+00, -.1302D+00, -.1128D+00, -.9583D-01,
     #    -.8002D-01, -.6590D-01, -.5353D-01, -.4305D-01, -.3442D-01,
     #    -.2714D-01, -.2138D-01, -.1660D-01, -.1296D-01, -.9893D-02,
     #    -.7696D-02, -.5782D-02, -.4457D-02, -.3424D-02, -.2535D-02,
     #    -.1943D-02, -.1498D-02, -.1052D-02, -.7544D-03, -.6061D-03,
     #    -.4573D-03, -.3081D-03, -.3086D-03, -.1590D-03, -.1592D-03,
     #    -.1594D-03/

      data (calcpts(j,12), j = 1,neta) /-.9496D-09, -.1655D-08,
     #    -.2882D-08, -.5018D-08, -.8732D-08, -.1518D-07, -.2638D-07,
     #    -.4581D-07, -.7948D-07, -.1379D-06, -.2389D-06, -.4138D-06,
     #    -.7163D-06, -.1239D-05, -.2140D-05, -.3695D-05, -.6374D-05,
     #    -.1098D-04, -.1890D-04, -.3250D-04, -.5580D-04, -.9566D-04,
     #    -.1637D-03, -.2796D-03, -.4764D-03, -.8092D-03, -.1369D-02,
     #    -.2305D-02, -.3856D-02, -.6388D-02, -.1045D-01, -.1680D-01,
     #    -.2635D-01, -.4005D-01, -.5842D-01, -.8104D-01, -.1062D+00,
     #    -.1309D+00, -.1517D+00, -.1657D+00, -.1714D+00, -.1691D+00,
     #    -.1601D+00, -.1464D+00, -.1300D+00, -.1127D+00, -.9571D-01,
     #    -.7993D-01, -.6581D-01, -.5358D-01, -.4310D-01, -.3433D-01,
     #    -.2719D-01, -.2128D-01, -.1665D-01, -.1286D-01, -.9941D-02,
     #    -.7594D-02, -.5830D-02, -.4504D-02, -.3321D-02, -.2583D-02,
     #    -.1841D-02, -.1396D-02, -.1099D-02, -.8019D-03, -.6536D-03,
     #    -.5047D-03, -.3555D-03, -.2061D-03, -.2064D-03, -.5667D-04,
     #    -.5683D-04/

      data (calcpts(j,13), j = 1,neta) /-.9376D-09, -.1635D-08,
     #    -.2848D-08, -.4956D-08, -.8623D-08, -.1499D-07, -.2605D-07,
     #    -.4526D-07, -.7853D-07, -.1362D-06, -.2361D-06, -.4090D-06,
     #    -.7079D-06, -.1224D-05, -.2116D-05, -.3653D-05, -.6303D-05,
     #    -.1086D-04, -.1870D-04, -.3215D-04, -.5520D-04, -.9465D-04,
     #    -.1620D-03, -.2768D-03, -.4716D-03, -.8013D-03, -.1356D-02,
     #    -.2284D-02, -.3821D-02, -.6331D-02, -.1036D-01, -.1666D-01,
     #    -.2614D-01, -.3974D-01, -.5798D-01, -.8048D-01, -.1055D+00,
     #    -.1301D+00, -.1509D+00, -.1649D+00, -.1707D+00, -.1685D+00,
     #    -.1596D+00, -.1460D+00, -.1297D+00, -.1124D+00, -.9551D-01,
     #    -.7983D-01, -.6570D-01, -.5347D-01, -.4298D-01, -.3436D-01,
     #    -.2707D-01, -.2131D-01, -.1668D-01, -.1289D-01, -.9969D-02,
     #    -.7622D-02, -.5858D-02, -.4383D-02, -.3350D-02, -.2611D-02,
     #    -.1869D-02, -.1424D-02, -.1128D-02, -.8301D-03, -.5318D-03,
     #    -.3829D-03, -.3837D-03, -.2342D-03, -.2346D-03, -.8482D-04,
     #    -.8498D-04/

      data (calcpts(j,14), j = 1,neta) /-.9204D-09, -.1605D-08,
     #    -.2795D-08, -.4866D-08, -.8469D-08, -.1473D-07, -.2560D-07,
     #    -.4445D-07, -.7715D-07, -.1338D-06, -.2320D-06, -.4019D-06,
     #    -.6958D-06, -.1204D-05, -.2080D-05, -.3592D-05, -.6199D-05,
     #    -.1068D-04, -.1840D-04, -.3164D-04, -.5435D-04, -.9320D-04,
     #    -.1596D-03, -.2727D-03, -.4649D-03, -.7900D-03, -.1337D-02,
     #    -.2253D-02, -.3769D-02, -.6250D-02, -.1023D-01, -.1646D-01,
     #    -.2583D-01, -.3929D-01, -.5737D-01, -.7968D-01, -.1046D+00,
     #    -.1291D+00, -.1497D+00, -.1638D+00, -.1697D+00, -.1676D+00,
     #    -.1588D+00, -.1454D+00, -.1292D+00, -.1121D+00, -.9525D-01,
     #    -.7958D-01, -.6559D-01, -.5335D-01, -.4286D-01, -.3424D-01,
     #    -.2709D-01, -.2133D-01, -.1655D-01, -.1291D-01, -.9990D-02,
     #    -.7643D-02, -.5878D-02, -.4403D-02, -.3369D-02, -.2481D-02,
     #    -.1889D-02, -.1444D-02, -.9974D-03, -.8498D-03, -.5515D-03,
     #    -.4026D-03, -.2534D-03, -.2539D-03, -.1043D-03, -.1045D-03,
     #    -.1047D-03/

      data (calcpts(j,15), j = 1,neta) /-.8962D-09, -.1563D-08,
     #    -.2722D-08, -.4740D-08, -.8250D-08, -.1435D-07, -.2495D-07,
     #    -.4333D-07, -.7521D-07, -.1305D-06, -.2262D-06, -.3921D-06,
     #    -.6789D-06, -.1175D-05, -.2030D-05, -.3508D-05, -.6055D-05,
     #    -.1044D-04, -.1798D-04, -.3094D-04, -.5313D-04, -.9118D-04,
     #    -.1562D-03, -.2669D-03, -.4551D-03, -.7740D-03, -.1311D-02,
     #    -.2209D-02, -.3699D-02, -.6135D-02, -.1005D-01, -.1617D-01,
     #    -.2540D-01, -.3866D-01, -.5649D-01, -.7854D-01, -.1032D+00,
     #    -.1275D+00, -.1481D+00, -.1622D+00, -.1683D+00, -.1663D+00,
     #    -.1578D+00, -.1445D+00, -.1285D+00, -.1115D+00, -.9485D-01,
     #    -.7930D-01, -.6530D-01, -.5320D-01, -.4285D-01, -.3422D-01,
     #    -.2707D-01, -.2116D-01, -.1653D-01, -.1289D-01, -.9964D-02,
     #    -.7616D-02, -.5851D-02, -.4375D-02, -.3342D-02, -.2603D-02,
     #    -.1861D-02, -.1416D-02, -.1120D-02, -.8220D-03, -.5236D-03,
     #    -.3747D-03, -.3755D-03, -.2260D-03, -.2264D-03, -.7662D-04,
     #    -.7679D-04/

      data (calcpts(j,16), j = 1,neta) /-.8625D-09, -.1504D-08,
     #    -.2621D-08, -.4566D-08, -.7948D-08, -.1382D-07, -.2404D-07,
     #    -.4176D-07, -.7252D-07, -.1259D-06, -.2183D-06, -.3784D-06,
     #    -.6554D-06, -.1134D-05, -.1961D-05, -.3389D-05, -.5854D-05,
     #    -.1010D-04, -.1740D-04, -.2994D-04, -.5146D-04, -.8834D-04,
     #    -.1514D-03, -.2589D-03, -.4418D-03, -.7518D-03, -.1274D-02,
     #    -.2149D-02, -.3600D-02, -.5975D-02, -.9793D-02, -.1577D-01,
     #    -.2479D-01, -.3777D-01, -.5526D-01, -.7694D-01, -.1012D+00,
     #    -.1253D+00, -.1458D+00, -.1599D+00, -.1662D+00, -.1645D+00,
     #    -.1563D+00, -.1433D+00, -.1275D+00, -.1108D+00, -.9428D-01,
     #    -.7886D-01, -.6500D-01, -.5289D-01, -.4268D-01, -.3404D-01,
     #    -.2689D-01, -.2113D-01, -.1649D-01, -.1285D-01, -.9927D-02,
     #    -.7578D-02, -.5813D-02, -.4487D-02, -.3303D-02, -.2564D-02,
     #    -.1972D-02, -.1377D-02, -.1080D-02, -.7829D-03, -.6345D-03,
     #    -.4856D-03, -.3363D-03, -.1869D-03, -.1872D-03, -.1874D-03,
     #    -.3761D-04/

      data (calcpts(j,17), j = 1,neta) /-.8172D-09, -.1426D-08,
     #    -.2485D-08, -.4329D-08, -.7537D-08, -.1312D-07, -.2281D-07,
     #    -.3965D-07, -.6887D-07, -.1196D-06, -.2075D-06, -.3598D-06,
     #    -.6235D-06, -.1080D-05, -.1868D-05, -.3230D-05, -.5580D-05,
     #    -.9629D-05, -.1660D-04, -.2859D-04, -.4918D-04, -.8450D-04,
     #    -.1449D-03, -.2481D-03, -.4236D-03, -.7215D-03, -.1224D-02,
     #    -.2066D-02, -.3465D-02, -.5756D-02, -.9444D-02, -.1523D-01,
     #    -.2397D-01, -.3657D-01, -.5358D-01, -.7474D-01, -.9852D-01,
     #    -.1222D+00, -.1426D+00, -.1568D+00, -.1633D+00, -.1619D+00,
     #    -.1541D+00, -.1415D+00, -.1261D+00, -.1097D+00, -.9348D-01,
     #    -.7826D-01, -.6453D-01, -.5255D-01, -.4248D-01, -.3383D-01,
     #    -.2682D-01, -.2105D-01, -.1641D-01, -.1277D-01, -.9846D-02,
     #    -.7497D-02, -.5731D-02, -.4404D-02, -.3370D-02, -.2481D-02,
     #    -.1889D-02, -.1444D-02, -.9970D-03, -.8494D-03, -.5510D-03,
     #    -.4021D-03, -.2528D-03, -.2533D-03, -.1037D-03, -.1039D-03,
     #    -.1040D-03/

      data (calcpts(j,18), j = 1,neta) /-.7578D-09, -.1323D-08,
     #    -.2305D-08, -.4019D-08, -.7001D-08, -.1219D-07, -.2121D-07,
     #    -.3688D-07, -.6411D-07, -.1114D-06, -.1933D-06, -.3355D-06,
     #    -.5817D-06, -.1008D-05, -.1745D-05, -.3020D-05, -.5221D-05,
     #    -.9018D-05, -.1556D-04, -.2683D-04, -.4618D-04, -.7943D-04,
     #    -.1364D-03, -.2337D-03, -.3996D-03, -.6815D-03, -.1157D-02,
     #    -.1957D-02, -.3286D-02, -.5468D-02, -.8983D-02, -.1451D-01,
     #    -.2287D-01, -.3496D-01, -.5134D-01, -.7178D-01, -.9490D-01,
     #    -.1181D+00, -.1382D+00, -.1524D+00, -.1592D+00, -.1584D+00,
     #    -.1511D+00, -.1391D+00, -.1242D+00, -.1082D+00, -.9234D-01,
     #    -.7741D-01, -.6394D-01, -.5208D-01, -.4199D-01, -.3363D-01,
     #    -.2661D-01, -.2099D-01, -.1634D-01, -.1270D-01, -.9773D-02,
     #    -.7572D-02, -.5805D-02, -.4328D-02, -.3294D-02, -.2554D-02,
     #    -.1961D-02, -.1366D-02, -.1070D-02, -.7719D-03, -.6235D-03,
     #    -.4745D-03, -.3253D-03, -.1758D-03, -.1761D-03, -.1763D-03,
     #    -.2648D-04/

      data (calcpts(j,19), j = 1,neta) /-.6837D-09, -.1194D-08,
     #    -.2083D-08, -.3632D-08, -.6331D-08, -.1103D-07, -.1920D-07,
     #    -.3342D-07, -.5811D-07, -.1010D-06, -.1756D-06, -.3049D-06,
     #    -.5291D-06, -.9180D-06, -.1591D-05, -.2756D-05, -.4770D-05,
     #    -.8247D-05, -.1425D-04, -.2460D-04, -.4242D-04, -.7304D-04,
     #    -.1256D-03, -.2156D-03, -.3694D-03, -.6310D-03, -.1073D-02,
     #    -.1818D-02, -.3060D-02, -.5101D-02, -.8399D-02, -.1359D-01,
     #    -.2148D-01, -.3290D-01, -.4845D-01, -.6795D-01, -.9016D-01,
     #    -.1126D+00, -.1323D+00, -.1466D+00, -.1537D+00, -.1536D+00,
     #    -.1470D+00, -.1357D+00, -.1216D+00, -.1062D+00, -.9079D-01,
     #    -.7624D-01, -.6307D-01, -.5150D-01, -.4153D-01, -.3330D-01,
     #    -.2642D-01, -.2079D-01, -.1629D-01, -.1264D-01, -.9713D-02,
     #    -.7510D-02, -.5743D-02, -.4415D-02, -.3380D-02, -.2490D-02,
     #    -.1897D-02, -.1452D-02, -.1005D-02, -.8569D-03, -.5584D-03,
     #    -.4095D-03, -.2602D-03, -.2606D-03, -.1110D-03, -.1112D-03,
     #    -.1113D-03/

      data (calcpts(j,20), j = 1,neta) /-.5962D-09, -.1042D-08,
     #    -.1819D-08, -.3174D-08, -.5539D-08, -.9657D-08, -.1683D-07,
     #    -.2932D-07, -.5105D-07, -.8884D-07, -.1546D-06, -.2687D-06,
     #    -.4670D-06, -.8111D-06, -.1407D-05, -.2442D-05, -.4233D-05,
     #    -.7332D-05, -.1269D-04, -.2195D-04, -.3790D-04, -.6541D-04,
     #    -.1127D-03, -.1939D-03, -.3329D-03, -.5701D-03, -.9723D-03,
     #    -.1651D-02, -.2786D-02, -.4658D-02, -.7690D-02, -.1248D-01,
     #    -.1977D-01, -.3039D-01, -.4490D-01, -.6321D-01, -.8422D-01,
     #    -.1057D+00, -.1249D+00, -.1390D+00, -.1466D+00, -.1472D+00,
     #    -.1416D+00, -.1313D+00, -.1180D+00, -.1034D+00, -.8867D-01,
     #    -.7465D-01, -.6189D-01, -.5070D-01, -.4100D-01, -.3275D-01,
     #    -.2600D-01, -.2051D-01, -.1600D-01, -.1250D-01, -.9717D-02,
     #    -.7362D-02, -.5743D-02, -.4264D-02, -.3228D-02, -.2488D-02,
     #    -.1894D-02, -.1449D-02, -.1002D-02, -.8541D-03, -.5555D-03,
     #    -.4065D-03, -.2571D-03, -.2576D-03, -.1079D-03, -.1081D-03,
     #    -.1082D-03/

      data (calcpts(j,21), j = 1,neta) /-.5001D-09, -.8748D-09,
     #    -.1529D-08, -.2673D-08, -.4668D-08, -.8149D-08, -.1422D-07,
     #    -.2481D-07, -.4325D-07, -.7538D-07, -.1314D-06, -.2288D-06,
     #    -.3982D-06, -.6928D-06, -.1205D-05, -.2093D-05, -.3636D-05,
     #    -.6313D-05, -.1095D-04, -.1898D-04, -.3286D-04, -.5686D-04,
     #    -.9827D-04, -.1695D-03, -.2919D-03, -.5014D-03, -.8579D-03,
     #    -.1462D-02, -.2475D-02, -.4152D-02, -.6880D-02, -.1120D-01,
     #    -.1781D-01, -.2748D-01, -.4076D-01, -.5762D-01, -.7714D-01,
     #    -.9737D-01, -.1157D+00, -.1297D+00, -.1376D+00, -.1391D+00,
     #    -.1346D+00, -.1255D+00, -.1134D+00, -.9984D-01, -.8594D-01,
     #    -.7260D-01, -.6036D-01, -.4950D-01, -.4014D-01, -.3222D-01,
     #    -.2560D-01, -.2025D-01, -.1588D-01, -.1237D-01, -.9580D-02,
     #    -.7372D-02, -.5601D-02, -.4271D-02, -.3234D-02, -.2493D-02,
     #    -.1899D-02, -.1453D-02, -.1006D-02, -.8581D-03, -.5595D-03,
     #    -.4104D-03, -.2610D-03, -.2614D-03, -.1117D-03, -.1119D-03,
     #    -.1120D-03/

      data (calcpts(j,22), j = 1,neta) /-.4031D-09, -.7061D-09,
     #    -.1236D-08, -.2163D-08, -.3785D-08, -.6618D-08, -.1157D-07,
     #    -.2022D-07, -.3532D-07, -.6168D-07, -.1077D-06, -.1879D-06,
     #    -.3279D-06, -.5717D-06, -.9962D-06, -.1736D-05, -.3023D-05,
     #    -.5262D-05, -.9154D-05, -.1592D-04, -.2764D-04, -.4797D-04,
     #    -.8319D-04, -.1440D-03, -.2489D-03, -.4291D-03, -.7372D-03,
     #    -.1261D-02, -.2144D-02, -.3612D-02, -.6008D-02, -.9826D-02,
     #    -.1569D-01, -.2430D-01, -.3619D-01, -.5140D-01, -.6916D-01,
     #    -.8779D-01, -.1050D+00, -.1185D+00, -.1268D+00, -.1292D+00,
     #    -.1260D+00, -.1184D+00, -.1077D+00, -.9531D-01, -.8244D-01,
     #    -.6995D-01, -.5838D-01, -.4804D-01, -.3906D-01, -.3142D-01,
     #    -.2505D-01, -.1975D-01, -.1552D-01, -.1215D-01, -.9361D-02,
     #    -.7300D-02, -.5526D-02, -.4194D-02, -.3156D-02, -.2415D-02,
     #    -.1820D-02, -.1374D-02, -.1077D-02, -.7786D-03, -.6298D-03,
     #    -.4806D-03, -.3312D-03, -.1816D-03, -.1818D-03, -.1820D-03,
     #    -.3212D-04/

      data (calcpts(j,23), j = 1,neta) /-.3134D-09, -.5500D-09,
     #    -.9646D-09, -.1691D-08, -.2965D-08, -.5197D-08, -.9103D-08,
     #    -.1595D-07, -.2791D-07, -.4887D-07, -.8554D-07, -.1496D-06,
     #    -.2617D-06, -.4577D-06, -.7999D-06, -.1398D-05, -.2442D-05,
     #    -.4264D-05, -.7442D-05, -.1298D-04, -.2263D-04, -.3942D-04,
     #    -.6863D-04, -.1193D-03, -.2070D-03, -.3584D-03, -.6184D-03,
     #    -.1063D-02, -.1815D-02, -.3071D-02, -.5132D-02, -.8431D-02,
     #    -.1352D-01, -.2103D-01, -.3146D-01, -.4487D-01, -.6066D-01,
     #    -.7742D-01, -.9319D-01, -.1060D+00, -.1144D+00, -.1176D+00,
     #    -.1158D+00, -.1098D+00, -.1007D+00, -.8980D-01, -.7819D-01,
     #    -.6671D-01, -.5595D-01, -.4624D-01, -.3773D-01, -.3045D-01,
     #    -.2434D-01, -.1928D-01, -.1516D-01, -.1184D-01, -.9195D-02,
     #    -.7100D-02, -.5428D-02, -.4094D-02, -.3205D-02, -.2463D-02,
     #    -.1868D-02, -.1421D-02, -.9738D-03, -.8254D-03, -.5265D-03,
     #    -.3772D-03, -.3777D-03, -.2281D-03, -.2283D-03, -.7849D-04,
     #    -.7860D-04/

      data (calcpts(j,24), j = 1,neta) /-.2374D-09, -.4175D-09,
     #    -.7336D-09, -.1290D-08, -.2266D-08, -.3981D-08, -.6991D-08,
     #    -.1228D-07, -.2155D-07, -.3782D-07, -.6639D-07, -.1165D-06,
     #    -.2044D-06, -.3585D-06, -.6283D-06, -.1102D-05, -.1931D-05,
     #    -.3384D-05, -.5927D-05, -.1038D-04, -.1816D-04, -.3176D-04,
     #    -.5551D-04, -.9690D-04, -.1689D-03, -.2937D-03, -.5089D-03,
     #    -.8786D-03, -.1507D-02, -.2562D-02, -.4301D-02, -.7096D-02,
     #    -.1143D-01, -.1785D-01, -.2680D-01, -.3838D-01, -.5210D-01,
     #    -.6683D-01, -.8092D-01, -.9276D-01, -.1010D+00, -.1049D+00,
     #    -.1044D+00, -.1000D+00, -.9264D-01, -.8337D-01, -.7319D-01,
     #    -.6290D-01, -.5307D-01, -.4410D-01, -.3615D-01, -.2930D-01,
     #    -.2349D-01, -.1868D-01, -.1473D-01, -.1154D-01, -.8972D-02,
     #    -.6932D-02, -.5333D-02, -.4087D-02, -.3106D-02, -.2363D-02,
     #    -.1782D-02, -.1350D-02, -.1007D-02, -.7538D-03, -.5598D-03,
     #    -.4254D-03, -.3059D-03, -.2312D-03, -.1714D-03, -.1265D-03,
     #    -.9662D-04/

      data (calcpts(j,25), j = 1,neta) /-.1774D-09, -.3127D-09,
     #    -.5509D-09, -.9707D-09, -.1710D-08, -.3011D-08, -.5303D-08,
     #    -.9337D-08, -.1643D-07, -.2893D-07, -.5093D-07, -.8963D-07,
     #    -.1577D-06, -.2775D-06, -.4880D-06, -.8585D-06, -.1510D-05,
     #    -.2655D-05, -.4667D-05, -.8202D-05, -.1440D-04, -.2529D-04,
     #    -.4437D-04, -.7774D-04, -.1360D-03, -.2376D-03, -.4134D-03,
     #    -.7165D-03, -.1234D-02, -.2107D-02, -.3550D-02, -.5880D-02,
     #    -.9503D-02, -.1489D-01, -.2243D-01, -.3223D-01, -.4391D-01,
     #    -.5654D-01, -.6882D-01, -.7940D-01, -.8719D-01, -.9148D-01,
     #    -.9209D-01, -.8928D-01, -.8370D-01, -.7615D-01, -.6751D-01,
     #    -.5853D-01, -.4976D-01, -.4162D-01, -.3432D-01, -.2795D-01,
     #    -.2252D-01, -.1797D-01, -.1421D-01, -.1116D-01, -.8697D-02,
     #    -.6743D-02, -.5201D-02, -.3983D-02, -.3046D-02, -.2317D-02,
     #    -.1751D-02, -.1318D-02, -.9900D-03, -.7512D-03, -.5570D-03,
     #    -.4076D-03, -.3029D-03, -.2282D-03, -.1684D-03, -.1235D-03,
     #    -.9358D-04/

      data (calcpts(j,26), j = 1,neta) /-.1325D-09, -.2341D-09,
     #    -.4132D-09, -.7299D-09, -.1289D-08, -.2275D-08, -.4017D-08,
     #    -.7092D-08, -.1251D-07, -.2209D-07, -.3899D-07, -.6881D-07,
     #    -.1214D-06, -.2143D-06, -.3779D-06, -.6668D-06, -.1176D-05,
     #    -.2075D-05, -.3658D-05, -.6450D-05, -.1136D-04, -.2001D-04,
     #    -.3524D-04, -.6195D-04, -.1088D-03, -.1906D-03, -.3328D-03,
     #    -.5788D-03, -.1000D-02, -.1713D-02, -.2896D-02, -.4811D-02,
     #    -.7796D-02, -.1225D-01, -.1850D-01, -.2664D-01, -.3638D-01,
     #    -.4699D-01, -.5742D-01, -.6661D-01, -.7368D-01, -.7806D-01,
     #    -.7950D-01, -.7808D-01, -.7415D-01, -.6833D-01, -.6128D-01,
     #    -.5369D-01, -.4608D-01, -.3885D-01, -.3225D-01, -.2642D-01,
     #    -.2140D-01, -.1715D-01, -.1363D-01, -.1074D-01, -.8402D-02,
     #    -.6534D-02, -.5034D-02, -.3874D-02, -.2966D-02, -.2251D-02,
     #    -.1714D-02, -.1281D-02, -.9678D-03, -.7288D-03, -.5345D-03,
     #    -.4000D-03, -.2953D-03, -.2205D-03, -.1606D-03, -.1157D-03,
     #    -.8582D-04/

      data (calcpts(j,27), j = 1,neta) /-.9971D-10, -.1765D-09,
     #    -.3122D-09, -.5525D-09, -.9778D-09, -.1730D-08, -.3060D-08,
     #    -.5415D-08, -.9575D-08, -.1694D-07, -.2997D-07, -.5302D-07,
     #    -.9377D-07, -.1659D-06, -.2933D-06, -.5187D-06, -.9174D-06,
     #    -.1622D-05, -.2867D-05, -.5068D-05, -.8950D-05, -.1581D-04,
     #    -.2790D-04, -.4919D-04, -.8659D-04, -.1521D-03, -.2663D-03,
     #    -.4644D-03, -.8047D-03, -.1381D-02, -.2340D-02, -.3896D-02,
     #    -.6326D-02, -.9956D-02, -.1506D-01, -.2172D-01, -.2972D-01,
     #    -.3847D-01, -.4714D-01, -.5491D-01, -.6110D-01, -.6527D-01,
     #    -.6720D-01, -.6685D-01, -.6439D-01, -.6017D-01, -.5472D-01,
     #    -.4851D-01, -.4210D-01, -.3585D-01, -.3001D-01, -.2477D-01,
     #    -.2020D-01, -.1628D-01, -.1299D-01, -.1028D-01, -.8074D-02,
     #    -.6307D-02, -.4880D-02, -.3763D-02, -.2884D-02, -.2213D-02,
     #    -.1675D-02, -.1272D-02, -.9585D-03, -.7193D-03, -.5399D-03,
     #    -.4053D-03, -.3006D-03, -.2257D-03, -.1659D-03, -.1359D-03,
     #    -.9100D-04/

      data (calcpts(j,28), j = 1,neta) /-.7575D-10, -.1343D-09,
     #    -.2379D-09, -.4217D-09, -.7476D-09, -.1325D-08, -.2348D-08,
     #    -.4161D-08, -.7371D-08, -.1306D-07, -.2316D-07, -.4103D-07,
     #    -.7270D-07, -.1288D-06, -.2282D-06, -.4043D-06, -.7165D-06,
     #    -.1269D-05, -.2247D-05, -.3980D-05, -.7042D-05, -.1246D-04,
     #    -.2204D-04, -.3892D-04, -.6865D-04, -.1208D-03, -.2119D-03,
     #    -.3702D-03, -.6426D-03, -.1105D-02, -.1875D-02, -.3125D-02,
     #    -.5081D-02, -.8007D-02, -.1212D-01, -.1750D-01, -.2397D-01,
     #    -.3107D-01, -.3814D-01, -.4455D-01, -.4980D-01, -.5355D-01,
     #    -.5564D-01, -.5603D-01, -.5474D-01, -.5193D-01, -.4793D-01,
     #    -.4311D-01, -.3787D-01, -.3262D-01, -.2758D-01, -.2296D-01,
     #    -.1886D-01, -.1530D-01, -.1228D-01, -.9767D-02, -.7703D-02,
     #    -.6038D-02, -.4698D-02, -.3625D-02, -.2790D-02, -.2133D-02,
     #    -.1625D-02, -.1236D-02, -.9374D-03, -.6981D-03, -.5336D-03,
     #    -.3989D-03, -.2941D-03, -.2192D-03, -.1593D-03, -.1294D-03,
     #    -.8445D-04/

      data (calcpts(j,29), j = 1,neta) /-.5802D-10, -.1030D-09,
     #    -.1826D-09, -.3241D-09, -.5753D-09, -.1021D-08, -.1811D-08,
     #    -.3214D-08, -.5700D-08, -.1011D-07, -.1795D-07, -.3184D-07,
     #    -.5649D-07, -.1002D-06, -.1778D-06, -.3154D-06, -.5596D-06,
     #    -.9924D-06, -.1760D-05, -.3121D-05, -.5529D-05, -.9797D-05,
     #    -.1735D-04, -.3068D-04, -.5418D-04, -.9549D-04, -.1677D-03,
     #    -.2933D-03, -.5096D-03, -.8771D-03, -.1490D-02, -.2486D-02,
     #    -.4045D-02, -.6378D-02, -.9662D-02, -.1396D-01, -.1912D-01,
     #    -.2480D-01, -.3048D-01, -.3568D-01, -.4000D-01, -.4322D-01,
     #    -.4524D-01, -.4603D-01, -.4556D-01, -.4389D-01, -.4116D-01,
     #    -.3760D-01, -.3353D-01, -.2925D-01, -.2502D-01, -.2105D-01,
     #    -.1744D-01, -.1425D-01, -.1151D-01, -.9213D-02, -.7295D-02,
     #    -.5747D-02, -.4480D-02, -.3481D-02, -.2674D-02, -.2047D-02,
     #    -.1569D-02, -.1195D-02, -.8956D-03, -.6712D-03, -.5065D-03,
     #    -.3868D-03, -.2820D-03, -.2071D-03, -.1622D-03, -.1172D-03,
     #    -.8727D-04/

      data (calcpts(j,30), j = 1,neta) /-.4465D-10, -.7931D-10,
     #    -.1408D-09, -.2500D-09, -.4441D-09, -.7886D-09, -.1400D-08,
     #    -.2487D-08, -.4415D-08, -.7840D-08, -.1393D-07, -.2473D-07,
     #    -.4390D-07, -.7797D-07, -.1384D-06, -.2457D-06, -.4364D-06,
     #    -.7745D-06, -.1375D-05, -.2440D-05, -.4326D-05, -.7672D-05,
     #    -.1360D-04, -.2406D-04, -.4253D-04, -.7503D-04, -.1318D-03,
     #    -.2308D-03, -.4013D-03, -.6912D-03, -.1175D-02, -.1961D-02,
     #    -.3193D-02, -.5037D-02, -.7633D-02, -.1103D-01, -.1511D-01,
     #    -.1961D-01, -.2411D-01, -.2825D-01, -.3174D-01, -.3441D-01,
     #    -.3622D-01, -.3714D-01, -.3718D-01, -.3633D-01, -.3462D-01,
     #    -.3216D-01, -.2915D-01, -.2581D-01, -.2237D-01, -.1905D-01,
     #    -.1595D-01, -.1315D-01, -.1071D-01, -.8630D-02, -.6874D-02,
     #    -.5443D-02, -.4264D-02, -.3324D-02, -.2577D-02, -.1979D-02,
     #    -.1515D-02, -.1156D-02, -.8717D-03, -.6621D-03, -.4974D-03,
     #    -.3776D-03, -.2728D-03, -.2129D-03, -.1529D-03, -.1080D-03,
     #    -.7802D-04/

      data (calcpts(j,31), j = 1,neta) /-.3440D-10, -.6113D-10,
     #    -.1086D-09, -.1929D-09, -.3429D-09, -.6091D-09, -.1082D-08,
     #    -.1923D-08, -.3415D-08, -.6069D-08, -.1078D-07, -.1916D-07,
     #    -.3404D-07, -.6048D-07, -.1074D-06, -.1908D-06, -.3390D-06,
     #    -.6021D-06, -.1069D-05, -.1899D-05, -.3368D-05, -.5977D-05,
     #    -.1060D-04, -.1877D-04, -.3319D-04, -.5857D-04, -.1030D-03,
     #    -.1803D-03, -.3138D-03, -.5406D-03, -.9193D-03, -.1535D-02,
     #    -.2500D-02, -.3944D-02, -.5979D-02, -.8639D-02, -.1184D-01,
     #    -.1536D-01, -.1890D-01, -.2216D-01, -.2492D-01, -.2709D-01,
     #    -.2861D-01, -.2951D-01, -.2980D-01, -.2947D-01, -.2851D-01,
     #    -.2694D-01, -.2485D-01, -.2238D-01, -.1970D-01, -.1700D-01,
     #    -.1440D-01, -.1200D-01, -.9863D-02, -.8004D-02, -.6424D-02,
     #    -.5112D-02, -.4037D-02, -.3155D-02, -.2453D-02, -.1899D-02,
     #    -.1450D-02, -.1106D-02, -.8366D-03, -.6419D-03, -.4772D-03,
     #    -.3573D-03, -.2674D-03, -.2075D-03, -.1476D-03, -.1176D-03,
     #    -.8762D-04/

      data (calcpts(j,32), j = 1,neta) /-.2646D-10, -.4703D-10,
     #    -.8355D-10, -.1485D-09, -.2640D-09, -.4692D-09, -.8339D-09,
     #    -.1482D-08, -.2633D-08, -.4681D-08, -.8322D-08, -.1479D-07,
     #    -.2628D-07, -.4672D-07, -.8298D-07, -.1475D-06, -.2621D-06,
     #    -.4657D-06, -.8273D-06, -.1470D-05, -.2608D-05, -.4629D-05,
     #    -.8211D-05, -.1455D-04, -.2573D-04, -.4543D-04, -.7989D-04,
     #    -.1399D-03, -.2436D-03, -.4197D-03, -.7140D-03, -.1193D-02,
     #    -.1942D-02, -.3065D-02, -.4646D-02, -.6713D-02, -.9201D-02,
     #    -.1194D-01, -.1469D-01, -.1723D-01, -.1939D-01, -.2111D-01,
     #    -.2235D-01, -.2315D-01, -.2353D-01, -.2348D-01, -.2301D-01,
     #    -.2209D-01, -.2074D-01, -.1901D-01, -.1703D-01, -.1492D-01,
     #    -.1282D-01, -.1082D-01, -.8980D-02, -.7357D-02, -.5955D-02,
     #    -.4776D-02, -.3775D-02, -.2968D-02, -.2325D-02, -.1801D-02,
     #    -.1382D-02, -.1067D-02, -.8126D-03, -.6178D-03, -.4680D-03,
     #    -.3481D-03, -.2582D-03, -.1983D-03, -.1383D-03, -.1083D-03,
     #    -.7837D-04/

      data (calcpts(j,33), j = 1,neta) /-.2028D-10, -.3607D-10,
     #    -.6408D-10, -.1139D-09, -.2026D-09, -.3601D-09, -.6402D-09,
     #    -.1138D-08, -.2022D-08, -.3596D-08, -.6394D-08, -.1136D-07,
     #    -.2020D-07, -.3592D-07, -.6381D-07, -.1134D-06, -.2017D-06,
     #    -.3583D-06, -.6367D-06, -.1131D-05, -.2008D-05, -.3565D-05,
     #    -.6325D-05, -.1121D-04, -.1983D-04, -.3501D-04, -.6158D-04,
     #    -.1079D-03, -.1878D-03, -.3237D-03, -.5507D-03, -.9200D-03,
     #    -.1498D-02, -.2365D-02, -.3585D-02, -.5180D-02, -.7100D-02,
     #    -.9213D-02, -.1133D-01, -.1330D-01, -.1497D-01, -.1631D-01,
     #    -.1731D-01, -.1798D-01, -.1835D-01, -.1844D-01, -.1825D-01,
     #    -.1776D-01, -.1695D-01, -.1583D-01, -.1444D-01, -.1288D-01,
     #    -.1124D-01, -.9618D-02, -.8088D-02, -.6698D-02, -.5473D-02,
     #    -.4416D-02, -.3534D-02, -.2801D-02, -.2187D-02, -.1708D-02,
     #    -.1319D-02, -.1019D-02, -.7796D-03, -.5998D-03, -.4500D-03,
     #    -.3451D-03, -.2551D-03, -.1952D-03, -.1502D-03, -.1052D-03,
     #    -.7526D-04/

      data (calcpts(j,34), j = 1,neta) /-.1548D-10, -.2753D-10,
     #    -.4892D-10, -.8700D-10, -.1547D-09, -.2750D-09, -.4890D-09,
     #    -.8695D-09, -.1545D-08, -.2748D-08, -.4886D-08, -.8686D-08,
     #    -.1544D-07, -.2746D-07, -.4879D-07, -.8674D-07, -.1542D-06,
     #    -.2741D-06, -.4870D-06, -.8655D-06, -.1536D-05, -.2728D-05,
     #    -.4841D-05, -.8578D-05, -.1518D-04, -.2680D-04, -.4715D-04,
     #    -.8263D-04, -.1438D-03, -.2480D-03, -.4219D-03, -.7048D-03,
     #    -.1148D-02, -.1812D-02, -.2747D-02, -.3969D-02, -.5440D-02,
     #    -.7059D-02, -.8685D-02, -.1019D-01, -.1148D-01, -.1251D-01,
     #    -.1329D-01, -.1383D-01, -.1416D-01, -.1430D-01, -.1425D-01,
     #    -.1401D-01, -.1356D-01, -.1289D-01, -.1198D-01, -.1089D-01,
     #    -.9674D-02, -.8414D-02, -.7176D-02, -.6017D-02, -.4969D-02,
     #    -.4050D-02, -.3261D-02, -.2598D-02, -.2052D-02, -.1607D-02,
     #    -.1251D-02, -.9661D-03, -.7414D-03, -.5675D-03, -.4311D-03,
     #    -.3217D-03, -.2468D-03, -.1868D-03, -.1418D-03, -.9683D-04,
     #    -.8184D-04/

      data (calcpts(j,35), j = 1,neta) /-.1176D-10, -.2091D-10,
     #    -.3717D-10, -.6610D-10, -.1176D-09, -.2090D-09, -.3716D-09,
     #    -.6608D-09, -.1174D-08, -.2089D-08, -.3714D-08, -.6603D-08,
     #    -.1174D-07, -.2088D-07, -.3710D-07, -.6597D-07, -.1173D-06,
     #    -.2085D-06, -.3705D-06, -.6584D-06, -.1169D-05, -.2076D-05,
     #    -.3683D-05, -.6527D-05, -.1155D-04, -.2040D-04, -.3589D-04,
     #    -.6290D-04, -.1095D-03, -.1888D-03, -.3212D-03, -.5366D-03,
     #    -.8741D-03, -.1379D-02, -.2091D-02, -.3022D-02, -.4142D-02,
     #    -.5375D-02, -.6612D-02, -.7758D-02, -.8741D-02, -.9532D-02,
     #    -.1013D-01, -.1056D-01, -.1084D-01, -.1098D-01, -.1100D-01,
     #    -.1090D-01, -.1066D-01, -.1028D-01, -.9728D-02, -.9012D-02,
     #    -.8163D-02, -.7228D-02, -.6268D-02, -.5330D-02, -.4457D-02,
     #    -.3671D-02, -.2984D-02, -.2398D-02, -.1906D-02, -.1503D-02,
     #    -.1175D-02, -.9116D-03, -.7033D-03, -.5384D-03, -.4110D-03,
     #    -.3120D-03, -.2356D-03, -.1771D-03, -.1321D-03, -.9912D-04,
     #    -.7362D-04/

      data (calcpts(j,36), j = 1,neta) /-.8892D-11, -.1581D-10,
     #    -.2811D-10, -.4998D-10, -.8890D-10, -.1581D-09, -.2810D-09,
     #    -.4998D-09, -.8883D-09, -.1580D-08, -.2810D-08, -.4996D-08,
     #    -.8882D-08, -.1580D-07, -.2807D-07, -.4991D-07, -.8876D-07,
     #    -.1578D-06, -.2804D-06, -.4983D-06, -.8847D-06, -.1571D-05,
     #    -.2788D-05, -.4941D-05, -.8744D-05, -.1544D-04, -.2717D-04,
     #    -.4762D-04, -.8290D-04, -.1429D-03, -.2432D-03, -.4063D-03,
     #    -.6619D-03, -.1045D-02, -.1584D-02, -.2288D-02, -.3136D-02,
     #    -.4070D-02, -.5007D-02, -.5874D-02, -.6620D-02, -.7220D-02,
     #    -.7678D-02, -.8011D-02, -.8234D-02, -.8364D-02, -.8411D-02,
     #    -.8378D-02, -.8261D-02, -.8053D-02, -.7736D-02, -.7299D-02,
     #    -.6743D-02, -.6090D-02, -.5378D-02, -.4650D-02, -.3945D-02,
     #    -.3290D-02, -.2705D-02, -.2194D-02, -.1760D-02, -.1396D-02,
     #    -.1099D-02, -.8578D-03, -.6645D-03, -.5115D-03, -.3916D-03,
     #    -.2986D-03, -.2267D-03, -.1712D-03, -.1277D-03, -.9622D-04,
     #    -.7223D-04/

      data (calcpts(j,37), j = 1,neta) /-.6692D-11, -.1190D-10,
     #    -.2115D-10, -.3762D-10, -.6691D-10, -.1190D-09, -.2115D-09,
     #    -.3762D-09, -.6687D-09, -.1189D-08, -.2115D-08, -.3761D-08,
     #    -.6687D-08, -.1189D-07, -.2113D-07, -.3758D-07, -.6683D-07,
     #    -.1188D-06, -.2111D-06, -.3752D-06, -.6662D-06, -.1183D-05,
     #    -.2100D-05, -.3721D-05, -.6585D-05, -.1163D-04, -.2046D-04,
     #    -.3586D-04, -.6244D-04, -.1077D-03, -.1832D-03, -.3060D-03,
     #    -.4985D-03, -.7868D-03, -.1193D-02, -.1724D-02, -.2362D-02,
     #    -.3065D-02, -.3771D-02, -.4425D-02, -.4986D-02, -.5439D-02,
     #    -.5787D-02, -.6041D-02, -.6216D-02, -.6326D-02, -.6379D-02,
     #    -.6379D-02, -.6326D-02, -.6217D-02, -.6042D-02, -.5789D-02,
     #    -.5448D-02, -.5021D-02, -.4524D-02, -.3984D-02, -.3437D-02,
     #    -.2909D-02, -.2421D-02, -.1985D-02, -.1608D-02, -.1287D-02,
     #    -.1020D-02, -.8012D-03, -.6243D-03, -.4834D-03, -.3709D-03,
     #    -.2840D-03, -.2165D-03, -.1640D-03, -.1235D-03, -.9201D-04,
     #    -.6951D-04/

      data (calcpts(j,38), j = 1,neta) /-.5013D-11, -.8916D-11,
     #    -.1585D-10, -.2818D-10, -.5013D-10, -.8914D-10, -.1585D-09,
     #    -.2819D-09, -.5010D-09, -.8911D-09, -.1585D-08, -.2818D-08,
     #    -.5011D-08, -.8911D-08, -.1584D-07, -.2816D-07, -.5008D-07,
     #    -.8901D-07, -.1582D-06, -.2812D-06, -.4993D-06, -.8866D-06,
     #    -.1574D-05, -.2789D-05, -.4935D-05, -.8717D-05, -.1534D-04,
     #    -.2688D-04, -.4680D-04, -.8069D-04, -.1373D-03, -.2294D-03,
     #    -.3737D-03, -.5898D-03, -.8941D-03, -.1292D-02, -.1771D-02,
     #    -.2298D-02, -.2827D-02, -.3317D-02, -.3738D-02, -.4078D-02,
     #    -.4339D-02, -.4531D-02, -.4666D-02, -.4755D-02, -.4804D-02,
     #    -.4819D-02, -.4799D-02, -.4744D-02, -.4650D-02, -.4508D-02,
     #    -.4310D-02, -.4048D-02, -.3721D-02, -.3345D-02, -.2940D-02,
     #    -.2530D-02, -.2137D-02, -.1776D-02, -.1453D-02, -.1175D-02,
     #    -.9379D-03, -.7415D-03, -.5826D-03, -.4521D-03, -.3501D-03,
     #    -.2677D-03, -.2047D-03, -.1552D-03, -.1177D-03, -.8770D-04,
     #    -.6671D-04/

      data (calcpts(j,39), j = 1,neta) /-.3741D-11, -.6654D-11,
     #    -.1183D-10, -.2104D-10, -.3742D-10, -.6653D-10, -.1183D-09,
     #    -.2104D-09, -.3740D-09, -.6651D-09, -.1183D-08, -.2103D-08,
     #    -.3740D-08, -.6652D-08, -.1182D-07, -.2102D-07, -.3738D-07,
     #    -.6644D-07, -.1181D-06, -.2099D-06, -.3727D-06, -.6618D-06,
     #    -.1175D-05, -.2082D-05, -.3684D-05, -.6508D-05, -.1145D-04,
     #    -.2007D-04, -.3494D-04, -.6024D-04, -.1025D-03, -.1713D-03,
     #    -.2790D-03, -.4403D-03, -.6675D-03, -.9646D-03, -.1322D-02,
     #    -.1715D-02, -.2110D-02, -.2476D-02, -.2791D-02, -.3045D-02,
     #    -.3240D-02, -.3385D-02, -.3487D-02, -.3557D-02, -.3599D-02,
     #    -.3617D-02, -.3614D-02, -.3589D-02, -.3539D-02, -.3461D-02,
     #    -.3349D-02, -.3196D-02, -.2996D-02, -.2749D-02, -.2466D-02,
     #    -.2164D-02, -.1858D-02, -.1568D-02, -.1299D-02, -.1062D-02,
     #    -.8571D-03, -.6832D-03, -.5408D-03, -.4223D-03, -.3293D-03,
     #    -.2543D-03, -.1943D-03, -.1494D-03, -.1134D-03, -.8486D-04,
     #    -.6387D-04/

      data (calcpts(j,40), j = 1,neta) /-.2780D-11, -.4945D-11,
     #    -.8790D-11, -.1563D-10, -.2781D-10, -.4944D-10, -.8792D-10,
     #    -.1564D-09, -.2779D-09, -.4943D-09, -.8792D-09, -.1563D-08,
     #    -.2780D-08, -.4944D-08, -.8786D-08, -.1562D-07, -.2778D-07,
     #    -.4939D-07, -.8778D-07, -.1560D-06, -.2770D-06, -.4919D-06,
     #    -.8731D-06, -.1547D-05, -.2739D-05, -.4837D-05, -.8511D-05,
     #    -.1492D-04, -.2597D-04, -.4478D-04, -.7619D-04, -.1273D-03,
     #    -.2074D-03, -.3273D-03, -.4962D-03, -.7170D-03, -.9827D-03,
     #    -.1275D-02, -.1569D-02, -.1841D-02, -.2074D-02, -.2263D-02,
     #    -.2409D-02, -.2517D-02, -.2594D-02, -.2647D-02, -.2681D-02,
     #    -.2699D-02, -.2703D-02, -.2693D-02, -.2668D-02, -.2626D-02,
     #    -.2564D-02, -.2477D-02, -.2360D-02, -.2208D-02, -.2023D-02,
     #    -.1812D-02, -.1586D-02, -.1360D-02, -.1145D-02, -.9475D-03,
     #    -.7736D-03, -.6222D-03, -.4962D-03, -.3913D-03, -.3058D-03,
     #    -.2368D-03, -.1828D-03, -.1408D-03, -.1063D-03, -.8082D-04,
     #    -.6132D-04/

      data (calcpts(j,41), j = 1,neta) /-.2059D-11, -.3662D-11,
     #    -.6509D-11, -.1158D-10, -.2059D-10, -.3661D-10, -.6510D-10,
     #    -.1158D-09, -.2058D-09, -.3660D-09, -.6511D-09, -.1158D-08,
     #    -.2058D-08, -.3661D-08, -.6506D-08, -.1157D-07, -.2057D-07,
     #    -.3657D-07, -.6500D-07, -.1155D-06, -.2051D-06, -.3643D-06,
     #    -.6465D-06, -.1146D-05, -.2028D-05, -.3582D-05, -.6303D-05,
     #    -.1105D-04, -.1923D-04, -.3316D-04, -.5642D-04, -.9427D-04,
     #    -.1536D-03, -.2424D-03, -.3674D-03, -.5310D-03, -.7278D-03,
     #    -.9443D-03, -.1162D-02, -.1363D-02, -.1536D-02, -.1676D-02,
     #    -.1784D-02, -.1864D-02, -.1922D-02, -.1962D-02, -.1988D-02,
     #    -.2004D-02, -.2011D-02, -.2008D-02, -.1996D-02, -.1974D-02,
     #    -.1940D-02, -.1891D-02, -.1825D-02, -.1736D-02, -.1622D-02,
     #    -.1484D-02, -.1327D-02, -.1160D-02, -.9928D-03, -.8341D-03,
     #    -.6894D-03, -.5615D-03, -.4517D-03, -.3587D-03, -.2823D-03,
     #    -.2208D-03, -.1713D-03, -.1323D-03, -.1008D-03, -.7679D-04,
     #    -.5729D-04/

      data (calcpts(j,42), j = 1,neta) /-.1520D-11, -.2703D-11,
     #    -.4804D-11, -.8545D-11, -.1520D-10, -.2702D-10, -.4806D-10,
     #    -.8547D-10, -.1519D-09, -.2702D-09, -.4806D-09, -.8545D-09,
     #    -.1519D-08, -.2702D-08, -.4802D-08, -.8540D-08, -.1519D-07,
     #    -.2700D-07, -.4798D-07, -.8528D-07, -.1514D-06, -.2689D-06,
     #    -.4773D-06, -.8459D-06, -.1497D-05, -.2644D-05, -.4653D-05,
     #    -.8154D-05, -.1420D-04, -.2448D-04, -.4165D-04, -.6959D-04,
     #    -.1134D-03, -.1789D-03, -.2712D-03, -.3920D-03, -.5372D-03,
     #    -.6971D-03, -.8576D-03, -.1006D-02, -.1134D-02, -.1237D-02,
     #    -.1317D-02, -.1376D-02, -.1419D-02, -.1449D-02, -.1469D-02,
     #    -.1482D-02, -.1489D-02, -.1490D-02, -.1485D-02, -.1474D-02,
     #    -.1455D-02, -.1428D-02, -.1391D-02, -.1340D-02, -.1274D-02,
     #    -.1189D-02, -.1086D-02, -.9692D-03, -.8460D-03, -.7231D-03,
     #    -.6067D-03, -.5007D-03, -.4073D-03, -.3272D-03, -.2599D-03,
     #    -.2045D-03, -.1595D-03, -.1234D-03, -.9489D-04, -.7254D-04,
     #    -.5514D-04/

      data (calcpts(j,43), j = 1,neta) /-.1118D-11, -.1989D-11,
     #    -.3535D-11, -.6287D-11, -.1118D-10, -.1988D-10, -.3536D-10,
     #    -.6289D-10, -.1118D-09, -.1988D-09, -.3536D-09, -.6287D-09,
     #    -.1118D-08, -.1988D-08, -.3534D-08, -.6284D-08, -.1118D-07,
     #    -.1986D-07, -.3531D-07, -.6275D-07, -.1114D-06, -.1979D-06,
     #    -.3512D-06, -.6224D-06, -.1102D-05, -.1946D-05, -.3424D-05,
     #    -.6000D-05, -.1045D-04, -.1801D-04, -.3065D-04, -.5121D-04,
     #    -.8342D-04, -.1317D-03, -.1996D-03, -.2884D-03, -.3953D-03,
     #    -.5129D-03, -.6310D-03, -.7404D-03, -.8344D-03, -.9105D-03,
     #    -.9691D-03, -.1013D-02, -.1044D-02, -.1066D-02, -.1082D-02,
     #    -.1092D-02, -.1097D-02, -.1100D-02, -.1098D-02, -.1093D-02,
     #    -.1084D-02, -.1069D-02, -.1048D-02, -.1020D-02, -.9815D-03,
     #    -.9317D-03, -.8684D-03, -.7922D-03, -.7063D-03, -.6156D-03,
     #    -.5255D-03, -.4402D-03, -.3628D-03, -.2947D-03, -.2365D-03,
     #    -.1876D-03, -.1474D-03, -.1149D-03, -.8879D-04, -.6824D-04,
     #    -.5204D-04/

      data (calcpts(j,44), j = 1,neta) /-.8203D-12, -.1459D-11,
     #    -.2593D-11, -.4612D-11, -.8204D-11, -.1459D-10, -.2594D-10,
     #    -.4614D-10, -.8200D-10, -.1458D-09, -.2594D-09, -.4613D-09,
     #    -.8202D-09, -.1459D-08, -.2592D-08, -.4610D-08, -.8198D-08,
     #    -.1457D-07, -.2590D-07, -.4604D-07, -.8174D-07, -.1452D-06,
     #    -.2576D-06, -.4566D-06, -.8081D-06, -.1427D-05, -.2512D-05,
     #    -.4402D-05, -.7664D-05, -.1321D-04, -.2248D-04, -.3757D-04,
     #    -.6120D-04, -.9659D-04, -.1464D-03, -.2116D-03, -.2900D-03,
     #    -.3763D-03, -.4630D-03, -.5432D-03, -.6122D-03, -.6679D-03,
     #    -.7110D-03, -.7430D-03, -.7662D-03, -.7826D-03, -.7939D-03,
     #    -.8015D-03, -.8062D-03, -.8086D-03, -.8088D-03, -.8068D-03,
     #    -.8022D-03, -.7944D-03, -.7828D-03, -.7667D-03, -.7451D-03,
     #    -.7161D-03, -.6790D-03, -.6323D-03, -.5761D-03, -.5130D-03,
     #    -.4466D-03, -.3806D-03, -.3185D-03, -.2621D-03, -.2128D-03,
     #    -.1705D-03, -.1351D-03, -.1060D-03, -.8242D-04, -.6367D-04,
     #    -.4882D-04/

      data (calcpts(j,45), j = 1,neta) /-.6004D-12, -.1068D-11,
     #    -.1898D-11, -.3376D-11, -.6005D-11, -.1068D-10, -.1899D-10,
     #    -.3377D-10, -.6002D-10, -.1068D-09, -.1899D-09, -.3376D-09,
     #    -.6003D-09, -.1068D-08, -.1897D-08, -.3374D-08, -.6001D-08,
     #    -.1067D-07, -.1896D-07, -.3370D-07, -.5983D-07, -.1062D-06,
     #    -.1886D-06, -.3342D-06, -.5915D-06, -.1045D-05, -.1838D-05,
     #    -.3222D-05, -.5610D-05, -.9672D-05, -.1646D-04, -.2750D-04,
     #    -.4479D-04, -.7070D-04, -.1072D-03, -.1549D-03, -.2123D-03,
     #    -.2754D-03, -.3389D-03, -.3976D-03, -.4481D-03, -.4889D-03,
     #    -.5204D-03, -.5439D-03, -.5608D-03, -.5729D-03, -.5812D-03,
     #    -.5869D-03, -.5906D-03, -.5927D-03, -.5935D-03, -.5929D-03,
     #    -.5908D-03, -.5869D-03, -.5807D-03, -.5718D-03, -.5596D-03,
     #    -.5434D-03, -.5222D-03, -.4948D-03, -.4602D-03, -.4188D-03,
     #    -.3725D-03, -.3239D-03, -.2758D-03, -.2305D-03, -.1895D-03,
     #    -.1537D-03, -.1229D-03, -.9744D-04, -.7629D-04, -.5934D-04,
     #    -.4584D-04/

      data (calcpts(j,46), j = 1,neta) /-.4382D-12, -.7794D-12,
     #    -.1385D-11, -.2464D-11, -.4383D-11, -.7793D-11, -.1386D-10,
     #    -.2465D-10, -.4381D-10, -.7791D-10, -.1386D-09, -.2464D-09,
     #    -.4381D-09, -.7792D-09, -.1385D-08, -.2463D-08, -.4380D-08,
     #    -.7785D-08, -.1384D-07, -.2459D-07, -.4367D-07, -.7755D-07,
     #    -.1376D-06, -.2439D-06, -.4317D-06, -.7625D-06, -.1342D-05,
     #    -.2351D-05, -.4094D-05, -.7059D-05, -.1201D-04, -.2007D-04,
     #    -.3269D-04, -.5160D-04, -.7822D-04, -.1130D-03, -.1549D-03,
     #    -.2010D-03, -.2473D-03, -.2902D-03, -.3270D-03, -.3568D-03,
     #    -.3798D-03, -.3969D-03, -.4093D-03, -.4181D-03, -.4243D-03,
     #    -.4285D-03, -.4313D-03, -.4330D-03, -.4338D-03, -.4339D-03,
     #    -.4331D-03, -.4312D-03, -.4281D-03, -.4233D-03, -.4165D-03,
     #    -.4073D-03, -.3952D-03, -.3795D-03, -.3590D-03, -.3339D-03,
     #    -.3036D-03, -.2697D-03, -.2342D-03, -.1992D-03, -.1662D-03,
     #    -.1365D-03, -.1106D-03, -.8839D-04, -.6994D-04, -.5479D-04,
     #    -.4249D-04/

      data (calcpts(j,47), j = 1,neta) /-.3191D-12, -.5675D-12,
     #    -.1009D-11, -.1794D-11, -.3191D-11, -.5674D-11, -.1009D-10,
     #    -.1795D-10, -.3190D-10, -.5673D-10, -.1009D-09, -.1794D-09,
     #    -.3190D-09, -.5674D-09, -.1008D-08, -.1793D-08, -.3189D-08,
     #    -.5668D-08, -.1007D-07, -.1791D-07, -.3179D-07, -.5646D-07,
     #    -.1002D-06, -.1776D-06, -.3143D-06, -.5552D-06, -.9769D-06,
     #    -.1712D-05, -.2981D-05, -.5140D-05, -.8745D-05, -.1461D-04,
     #    -.2380D-04, -.3757D-04, -.5695D-04, -.8230D-04, -.1128D-03,
     #    -.1464D-03, -.1801D-03, -.2113D-03, -.2381D-03, -.2598D-03,
     #    -.2765D-03, -.2890D-03, -.2980D-03, -.3045D-03, -.3090D-03,
     #    -.3120D-03, -.3141D-03, -.3155D-03, -.3162D-03, -.3165D-03,
     #    -.3162D-03, -.3154D-03, -.3139D-03, -.3114D-03, -.3077D-03,
     #    -.3026D-03, -.2957D-03, -.2868D-03, -.2752D-03, -.2603D-03,
     #    -.2417D-03, -.2195D-03, -.1948D-03, -.1690D-03, -.1435D-03,
     #    -.1197D-03, -.9825D-04, -.7935D-04, -.6345D-04, -.5010D-04,
     #    -.3915D-04/

      data (calcpts(j,48), j = 1,neta) /-.2319D-12, -.4124D-12,
     #    -.7330D-12, -.1304D-11, -.2319D-11, -.4123D-11, -.7332D-11,
     #    -.1304D-10, -.2318D-10, -.4122D-10, -.7332D-10, -.1304D-09,
     #    -.2318D-09, -.4123D-09, -.7327D-09, -.1303D-08, -.2317D-08,
     #    -.4119D-08, -.7321D-08, -.1301D-07, -.2310D-07, -.4103D-07,
     #    -.7282D-07, -.1291D-06, -.2284D-06, -.4035D-06, -.7099D-06,
     #    -.1244D-05, -.2166D-05, -.3735D-05, -.6355D-05, -.1062D-04,
     #    -.1730D-04, -.2730D-04, -.4139D-04, -.5981D-04, -.8197D-04,
     #    -.1064D-03, -.1309D-03, -.1535D-03, -.1730D-03, -.1888D-03,
     #    -.2010D-03, -.2100D-03, -.2166D-03, -.2213D-03, -.2245D-03,
     #    -.2268D-03, -.2283D-03, -.2293D-03, -.2300D-03, -.2303D-03,
     #    -.2303D-03, -.2299D-03, -.2292D-03, -.2280D-03, -.2261D-03,
     #    -.2233D-03, -.2195D-03, -.2143D-03, -.2077D-03, -.1992D-03,
     #    -.1883D-03, -.1747D-03, -.1585D-03, -.1406D-03, -.1218D-03,
     #    -.1034D-03, -.8612D-04, -.7060D-04, -.5695D-04, -.4555D-04,
     #    -.3595D-04/

      data (calcpts(j,49), j = 1,neta) /-.1681D-12, -.2990D-12,
     #    -.5315D-12, -.9453D-12, -.1681D-11, -.2990D-11, -.5317D-11,
     #    -.9456D-11, -.1681D-10, -.2989D-10, -.5317D-10, -.9454D-10,
     #    -.1681D-09, -.2990D-09, -.5313D-09, -.9449D-09, -.1680D-08,
     #    -.2987D-08, -.5309D-08, -.9436D-08, -.1675D-07, -.2975D-07,
     #    -.5281D-07, -.9359D-07, -.1656D-06, -.2926D-06, -.5148D-06,
     #    -.9022D-06, -.1571D-05, -.2708D-05, -.4608D-05, -.7700D-05,
     #    -.1254D-04, -.1980D-04, -.3001D-04, -.4337D-04, -.5944D-04,
     #    -.7713D-04, -.9489D-04, -.1113D-03, -.1255D-03, -.1369D-03,
     #    -.1457D-03, -.1523D-03, -.1571D-03, -.1604D-03, -.1628D-03,
     #    -.1645D-03, -.1656D-03, -.1663D-03, -.1668D-03, -.1671D-03,
     #    -.1672D-03, -.1671D-03, -.1668D-03, -.1662D-03, -.1652D-03,
     #    -.1638D-03, -.1617D-03, -.1588D-03, -.1550D-03, -.1502D-03,
     #    -.1439D-03, -.1359D-03, -.1260D-03, -.1143D-03, -.1012D-03,
     #    -.8765D-04, -.7430D-04, -.6185D-04, -.5062D-04, -.4087D-04,
     #    -.3257D-04/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1_HTq = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     ===========================================
      double precision function h1bar_HTq(eta,xi)
c     ===========================================

c     eq (27) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subcqhtbar in the original code.
c     Called sqtbar in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /0.9803D-10, 0.1739D-09,
     #    0.3086D-09, 0.5482D-09, 0.9743D-09, 0.1731D-08, 0.3078D-08,
     #    0.5473D-08, 0.9724D-08, 0.1729D-07, 0.3076D-07, 0.5469D-07,
     #    0.9724D-07, 0.1729D-06, 0.3073D-06, 0.5465D-06, 0.9718D-06,
     #    0.1727D-05, 0.3070D-05, 0.5455D-05, 0.9683D-05, 0.1719D-04,
     #    0.3050D-04, 0.5401D-04, 0.9550D-04, 0.1684D-03, 0.2957D-03,
     #    0.5166D-03, 0.8955D-03, 0.1534D-02, 0.2586D-02, 0.4266D-02,
     #    0.6826D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2798D-01,
     #    0.3406D-01, 0.3874D-01, 0.4130D-01, 0.4150D-01, 0.3958D-01,
     #    0.3613D-01, 0.3180D-01, 0.2716D-01, 0.2264D-01, 0.1849D-01,
     #    0.1485D-01, 0.1178D-01, 0.9225D-02, 0.7162D-02, 0.5499D-02,
     #    0.4200D-02, 0.3187D-02, 0.2403D-02, 0.1803D-02, 0.1348D-02,
     #    0.1000D-02, 0.7489D-03, 0.5516D-03, 0.4103D-03, 0.2962D-03,
     #    0.2103D-03, 0.1530D-03, 0.1099D-03, 0.8117D-04, 0.6703D-04,
     #    0.3763D-04, 0.3803D-04, 0.2330D-04, 0.2349D-04, 0.8619D-05,
     #    0.8705D-05/

      data (calcpts(j, 2), j = 1,neta) /0.9804D-10, 0.1739D-09,
     #    0.3085D-09, 0.5481D-09, 0.9742D-09, 0.1731D-08, 0.3077D-08,
     #    0.5472D-08, 0.9723D-08, 0.1729D-07, 0.3076D-07, 0.5468D-07,
     #    0.9722D-07, 0.1729D-06, 0.3073D-06, 0.5464D-06, 0.9717D-06,
     #    0.1727D-05, 0.3069D-05, 0.5455D-05, 0.9682D-05, 0.1719D-04,
     #    0.3050D-04, 0.5401D-04, 0.9548D-04, 0.1684D-03, 0.2957D-03,
     #    0.5165D-03, 0.8953D-03, 0.1534D-02, 0.2586D-02, 0.4265D-02,
     #    0.6827D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2797D-01,
     #    0.3407D-01, 0.3875D-01, 0.4129D-01, 0.4150D-01, 0.3958D-01,
     #    0.3613D-01, 0.3180D-01, 0.2716D-01, 0.2264D-01, 0.1850D-01,
     #    0.1486D-01, 0.1177D-01, 0.9227D-02, 0.7149D-02, 0.5501D-02,
     #    0.4202D-02, 0.3189D-02, 0.2405D-02, 0.1804D-02, 0.1350D-02,
     #    0.1002D-02, 0.7507D-03, 0.5534D-03, 0.4121D-03, 0.2980D-03,
     #    0.2120D-03, 0.1548D-03, 0.1117D-03, 0.8293D-04, 0.5380D-04,
     #    0.3939D-04, 0.2480D-04, 0.2507D-04, 0.1026D-04, 0.1039D-04,
     #    0.1047D-04/

      data (calcpts(j, 3), j = 1,neta) /0.9802D-10, 0.1739D-09,
     #    0.3085D-09, 0.5481D-09, 0.9742D-09, 0.1731D-08, 0.3077D-08,
     #    0.5472D-08, 0.9722D-08, 0.1729D-07, 0.3076D-07, 0.5468D-07,
     #    0.9722D-07, 0.1729D-06, 0.3072D-06, 0.5464D-06, 0.9717D-06,
     #    0.1727D-05, 0.3069D-05, 0.5454D-05, 0.9682D-05, 0.1719D-04,
     #    0.3049D-04, 0.5400D-04, 0.9548D-04, 0.1684D-03, 0.2956D-03,
     #    0.5165D-03, 0.8953D-03, 0.1534D-02, 0.2585D-02, 0.4265D-02,
     #    0.6825D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2798D-01,
     #    0.3406D-01, 0.3873D-01, 0.4130D-01, 0.4150D-01, 0.3958D-01,
     #    0.3613D-01, 0.3180D-01, 0.2716D-01, 0.2264D-01, 0.1849D-01,
     #    0.1485D-01, 0.1178D-01, 0.9223D-02, 0.7160D-02, 0.5497D-02,
     #    0.4198D-02, 0.3184D-02, 0.2401D-02, 0.1800D-02, 0.1345D-02,
     #    0.9976D-03, 0.7463D-03, 0.5490D-03, 0.4077D-03, 0.2936D-03,
     #    0.2227D-03, 0.1654D-03, 0.1223D-03, 0.7854D-04, 0.6441D-04,
     #    0.5000D-04, 0.3540D-04, 0.2068D-04, 0.2087D-04, 0.5994D-05,
     #    0.6081D-05/

      data (calcpts(j, 4), j = 1,neta) /0.9800D-10, 0.1739D-09,
     #    0.3085D-09, 0.5480D-09, 0.9740D-09, 0.1731D-08, 0.3077D-08,
     #    0.5471D-08, 0.9721D-08, 0.1729D-07, 0.3075D-07, 0.5467D-07,
     #    0.9720D-07, 0.1729D-06, 0.3072D-06, 0.5463D-06, 0.9715D-06,
     #    0.1727D-05, 0.3069D-05, 0.5454D-05, 0.9680D-05, 0.1718D-04,
     #    0.3049D-04, 0.5399D-04, 0.9547D-04, 0.1684D-03, 0.2956D-03,
     #    0.5164D-03, 0.8952D-03, 0.1533D-02, 0.2585D-02, 0.4264D-02,
     #    0.6824D-02, 0.1052D-01, 0.1546D-01, 0.2147D-01, 0.2797D-01,
     #    0.3407D-01, 0.3873D-01, 0.4129D-01, 0.4149D-01, 0.3959D-01,
     #    0.3613D-01, 0.3181D-01, 0.2716D-01, 0.2264D-01, 0.1850D-01,
     #    0.1485D-01, 0.1178D-01, 0.9225D-02, 0.7161D-02, 0.5498D-02,
     #    0.4199D-02, 0.3186D-02, 0.2402D-02, 0.1801D-02, 0.1347D-02,
     #    0.9991D-03, 0.7478D-03, 0.5506D-03, 0.4092D-03, 0.2951D-03,
     #    0.2242D-03, 0.1519D-03, 0.1088D-03, 0.8006D-04, 0.6593D-04,
     #    0.5152D-04, 0.3692D-04, 0.2220D-04, 0.2239D-04, 0.7513D-05,
     #    0.7599D-05/

      data (calcpts(j, 5), j = 1,neta) /0.9798D-10, 0.1738D-09,
     #    0.3084D-09, 0.5479D-09, 0.9738D-09, 0.1730D-08, 0.3076D-08,
     #    0.5470D-08, 0.9718D-08, 0.1728D-07, 0.3074D-07, 0.5466D-07,
     #    0.9718D-07, 0.1728D-06, 0.3071D-06, 0.5462D-06, 0.9713D-06,
     #    0.1726D-05, 0.3068D-05, 0.5452D-05, 0.9678D-05, 0.1718D-04,
     #    0.3048D-04, 0.5398D-04, 0.9544D-04, 0.1683D-03, 0.2955D-03,
     #    0.5163D-03, 0.8950D-03, 0.1533D-02, 0.2584D-02, 0.4263D-02,
     #    0.6823D-02, 0.1052D-01, 0.1546D-01, 0.2146D-01, 0.2797D-01,
     #    0.3406D-01, 0.3872D-01, 0.4130D-01, 0.4149D-01, 0.3958D-01,
     #    0.3613D-01, 0.3180D-01, 0.2715D-01, 0.2263D-01, 0.1849D-01,
     #    0.1486D-01, 0.1177D-01, 0.9228D-02, 0.7150D-02, 0.5502D-02,
     #    0.4202D-02, 0.3189D-02, 0.2406D-02, 0.1805D-02, 0.1350D-02,
     #    0.1002D-02, 0.7510D-03, 0.5538D-03, 0.3974D-03, 0.2984D-03,
     #    0.2124D-03, 0.1551D-03, 0.1120D-03, 0.8327D-04, 0.5414D-04,
     #    0.3973D-04, 0.2513D-04, 0.2541D-04, 0.1059D-04, 0.1072D-04,
     #    0.1081D-04/

      data (calcpts(j, 6), j = 1,neta) /0.9794D-10, 0.1738D-09,
     #    0.3083D-09, 0.5477D-09, 0.9735D-09, 0.1730D-08, 0.3075D-08,
     #    0.5468D-08, 0.9715D-08, 0.1728D-07, 0.3073D-07, 0.5464D-07,
     #    0.9715D-07, 0.1728D-06, 0.3070D-06, 0.5460D-06, 0.9710D-06,
     #    0.1726D-05, 0.3067D-05, 0.5450D-05, 0.9674D-05, 0.1718D-04,
     #    0.3047D-04, 0.5396D-04, 0.9541D-04, 0.1683D-03, 0.2954D-03,
     #    0.5161D-03, 0.8947D-03, 0.1532D-02, 0.2584D-02, 0.4262D-02,
     #    0.6821D-02, 0.1052D-01, 0.1546D-01, 0.2146D-01, 0.2796D-01,
     #    0.3405D-01, 0.3872D-01, 0.4128D-01, 0.4148D-01, 0.3958D-01,
     #    0.3612D-01, 0.3180D-01, 0.2716D-01, 0.2263D-01, 0.1849D-01,
     #    0.1486D-01, 0.1177D-01, 0.9228D-02, 0.7149D-02, 0.5501D-02,
     #    0.4201D-02, 0.3188D-02, 0.2405D-02, 0.1804D-02, 0.1349D-02,
     #    0.1001D-02, 0.7498D-03, 0.5525D-03, 0.4112D-03, 0.2971D-03,
     #    0.2111D-03, 0.1539D-03, 0.1108D-03, 0.8203D-04, 0.6790D-04,
     #    0.3849D-04, 0.3889D-04, 0.2416D-04, 0.9350D-05, 0.9477D-05,
     #    0.9564D-05/

      data (calcpts(j, 7), j = 1,neta) /0.9790D-10, 0.1737D-09,
     #    0.3081D-09, 0.5474D-09, 0.9730D-09, 0.1729D-08, 0.3073D-08,
     #    0.5465D-08, 0.9711D-08, 0.1727D-07, 0.3072D-07, 0.5461D-07,
     #    0.9710D-07, 0.1727D-06, 0.3069D-06, 0.5457D-06, 0.9705D-06,
     #    0.1725D-05, 0.3065D-05, 0.5448D-05, 0.9670D-05, 0.1717D-04,
     #    0.3046D-04, 0.5394D-04, 0.9537D-04, 0.1682D-03, 0.2953D-03,
     #    0.5159D-03, 0.8943D-03, 0.1532D-02, 0.2582D-02, 0.4260D-02,
     #    0.6819D-02, 0.1051D-01, 0.1545D-01, 0.2145D-01, 0.2795D-01,
     #    0.3404D-01, 0.3871D-01, 0.4127D-01, 0.4147D-01, 0.3956D-01,
     #    0.3612D-01, 0.3180D-01, 0.2715D-01, 0.2263D-01, 0.1849D-01,
     #    0.1486D-01, 0.1177D-01, 0.9229D-02, 0.7150D-02, 0.5501D-02,
     #    0.4202D-02, 0.3189D-02, 0.2405D-02, 0.1804D-02, 0.1349D-02,
     #    0.1001D-02, 0.7501D-03, 0.5528D-03, 0.4114D-03, 0.2973D-03,
     #    0.2114D-03, 0.1541D-03, 0.1110D-03, 0.8225D-04, 0.6811D-04,
     #    0.3871D-04, 0.3911D-04, 0.2438D-04, 0.9568D-05, 0.9695D-05,
     #    0.9782D-05/

      data (calcpts(j, 8), j = 1,neta) /0.9783D-10, 0.1736D-09,
     #    0.3079D-09, 0.5470D-09, 0.9723D-09, 0.1728D-08, 0.3071D-08,
     #    0.5461D-08, 0.9704D-08, 0.1726D-07, 0.3069D-07, 0.5457D-07,
     #    0.9703D-07, 0.1726D-06, 0.3066D-06, 0.5453D-06, 0.9698D-06,
     #    0.1724D-05, 0.3063D-05, 0.5444D-05, 0.9663D-05, 0.1715D-04,
     #    0.3043D-04, 0.5390D-04, 0.9530D-04, 0.1681D-03, 0.2951D-03,
     #    0.5155D-03, 0.8937D-03, 0.1531D-02, 0.2581D-02, 0.4258D-02,
     #    0.6815D-02, 0.1051D-01, 0.1544D-01, 0.2144D-01, 0.2794D-01,
     #    0.3404D-01, 0.3870D-01, 0.4126D-01, 0.4146D-01, 0.3956D-01,
     #    0.3611D-01, 0.3178D-01, 0.2714D-01, 0.2263D-01, 0.1848D-01,
     #    0.1485D-01, 0.1178D-01, 0.9218D-02, 0.7154D-02, 0.5505D-02,
     #    0.4206D-02, 0.3192D-02, 0.2409D-02, 0.1807D-02, 0.1353D-02,
     #    0.1005D-02, 0.7385D-03, 0.5562D-03, 0.3999D-03, 0.3008D-03,
     #    0.2148D-03, 0.1575D-03, 0.1144D-03, 0.8568D-04, 0.5654D-04,
     #    0.4213D-04, 0.2753D-04, 0.2781D-04, 0.1299D-04, 0.1312D-04,
     #    0.1321D-04/

      data (calcpts(j, 9), j = 1,neta) /0.9773D-10, 0.1734D-09,
     #    0.3076D-09, 0.5464D-09, 0.9713D-09, 0.1726D-08, 0.3068D-08,
     #    0.5455D-08, 0.9693D-08, 0.1724D-07, 0.3066D-07, 0.5451D-07,
     #    0.9693D-07, 0.1724D-06, 0.3063D-06, 0.5447D-06, 0.9688D-06,
     #    0.1722D-05, 0.3060D-05, 0.5438D-05, 0.9653D-05, 0.1714D-04,
     #    0.3040D-04, 0.5384D-04, 0.9520D-04, 0.1679D-03, 0.2948D-03,
     #    0.5150D-03, 0.8928D-03, 0.1529D-02, 0.2578D-02, 0.4254D-02,
     #    0.6808D-02, 0.1050D-01, 0.1543D-01, 0.2143D-01, 0.2792D-01,
     #    0.3401D-01, 0.3868D-01, 0.4125D-01, 0.4145D-01, 0.3954D-01,
     #    0.3611D-01, 0.3177D-01, 0.2715D-01, 0.2263D-01, 0.1848D-01,
     #    0.1486D-01, 0.1177D-01, 0.9223D-02, 0.7158D-02, 0.5509D-02,
     #    0.4209D-02, 0.3195D-02, 0.2412D-02, 0.1810D-02, 0.1355D-02,
     #    0.1008D-02, 0.7413D-03, 0.5440D-03, 0.4026D-03, 0.3035D-03,
     #    0.2175D-03, 0.1603D-03, 0.1171D-03, 0.8839D-04, 0.5926D-04,
     #    0.4485D-04, 0.3025D-04, 0.3052D-04, 0.1571D-04, 0.1584D-04,
     #    0.1592D-04/

      data (calcpts(j,10), j = 1,neta) /0.9756D-10, 0.1731D-09,
     #    0.3071D-09, 0.5456D-09, 0.9697D-09, 0.1723D-08, 0.3063D-08,
     #    0.5447D-08, 0.9679D-08, 0.1721D-07, 0.3062D-07, 0.5443D-07,
     #    0.9678D-07, 0.1721D-06, 0.3058D-06, 0.5439D-06, 0.9673D-06,
     #    0.1719D-05, 0.3055D-05, 0.5430D-05, 0.9637D-05, 0.1711D-04,
     #    0.3035D-04, 0.5376D-04, 0.9505D-04, 0.1677D-03, 0.2943D-03,
     #    0.5142D-03, 0.8915D-03, 0.1527D-02, 0.2575D-02, 0.4248D-02,
     #    0.6801D-02, 0.1048D-01, 0.1541D-01, 0.2141D-01, 0.2790D-01,
     #    0.3398D-01, 0.3866D-01, 0.4121D-01, 0.4142D-01, 0.3952D-01,
     #    0.3609D-01, 0.3177D-01, 0.2714D-01, 0.2261D-01, 0.1847D-01,
     #    0.1485D-01, 0.1177D-01, 0.9215D-02, 0.7149D-02, 0.5499D-02,
     #    0.4199D-02, 0.3185D-02, 0.2401D-02, 0.1799D-02, 0.1344D-02,
     #    0.9965D-03, 0.7451D-03, 0.5477D-03, 0.4064D-03, 0.2922D-03,
     #    0.2212D-03, 0.1640D-03, 0.1208D-03, 0.9209D-04, 0.6295D-04,
     #    0.4854D-04, 0.3394D-04, 0.1922D-04, 0.1940D-04, 0.1953D-04,
     #    0.4614D-05/

      data (calcpts(j,11), j = 1,neta) /0.9733D-10, 0.1727D-09,
     #    0.3064D-09, 0.5443D-09, 0.9675D-09, 0.1719D-08, 0.3056D-08,
     #    0.5434D-08, 0.9656D-08, 0.1717D-07, 0.3055D-07, 0.5431D-07,
     #    0.9657D-07, 0.1717D-06, 0.3052D-06, 0.5427D-06, 0.9650D-06,
     #    0.1715D-05, 0.3048D-05, 0.5417D-05, 0.9615D-05, 0.1707D-04,
     #    0.3029D-04, 0.5364D-04, 0.9484D-04, 0.1673D-03, 0.2937D-03,
     #    0.5131D-03, 0.8895D-03, 0.1524D-02, 0.2570D-02, 0.4240D-02,
     #    0.6788D-02, 0.1047D-01, 0.1539D-01, 0.2138D-01, 0.2786D-01,
     #    0.3395D-01, 0.3862D-01, 0.4118D-01, 0.4139D-01, 0.3949D-01,
     #    0.3606D-01, 0.3175D-01, 0.2711D-01, 0.2261D-01, 0.1847D-01,
     #    0.1484D-01, 0.1176D-01, 0.9213D-02, 0.7146D-02, 0.5496D-02,
     #    0.4195D-02, 0.3180D-02, 0.2411D-02, 0.1809D-02, 0.1354D-02,
     #    0.1006D-02, 0.7398D-03, 0.5425D-03, 0.4010D-03, 0.3019D-03,
     #    0.2159D-03, 0.1586D-03, 0.1155D-03, 0.8672D-04, 0.5758D-04,
     #    0.4316D-04, 0.2856D-04, 0.2883D-04, 0.1402D-04, 0.1415D-04,
     #    0.1423D-04/

      data (calcpts(j,12), j = 1,neta) /0.9701D-10, 0.1721D-09,
     #    0.3054D-09, 0.5425D-09, 0.9642D-09, 0.1714D-08, 0.3046D-08,
     #    0.5416D-08, 0.9625D-08, 0.1712D-07, 0.3044D-07, 0.5412D-07,
     #    0.9624D-07, 0.1712D-06, 0.3041D-06, 0.5409D-06, 0.9619D-06,
     #    0.1710D-05, 0.3038D-05, 0.5400D-05, 0.9584D-05, 0.1702D-04,
     #    0.3019D-04, 0.5346D-04, 0.9453D-04, 0.1667D-03, 0.2927D-03,
     #    0.5115D-03, 0.8867D-03, 0.1519D-02, 0.2562D-02, 0.4228D-02,
     #    0.6769D-02, 0.1044D-01, 0.1535D-01, 0.2133D-01, 0.2781D-01,
     #    0.3388D-01, 0.3855D-01, 0.4112D-01, 0.4133D-01, 0.3945D-01,
     #    0.3602D-01, 0.3172D-01, 0.2710D-01, 0.2260D-01, 0.1846D-01,
     #    0.1484D-01, 0.1176D-01, 0.9208D-02, 0.7154D-02, 0.5502D-02,
     #    0.4200D-02, 0.3185D-02, 0.2400D-02, 0.1799D-02, 0.1343D-02,
     #    0.1010D-02, 0.7437D-03, 0.5463D-03, 0.4048D-03, 0.2906D-03,
     #    0.2196D-03, 0.1623D-03, 0.1191D-03, 0.9040D-04, 0.6126D-04,
     #    0.4684D-04, 0.3224D-04, 0.1751D-04, 0.1769D-04, 0.1782D-04,
     #    0.2904D-05/

      data (calcpts(j,13), j = 1,neta) /0.9653D-10, 0.1713D-09,
     #    0.3039D-09, 0.5399D-09, 0.9596D-09, 0.1705D-08, 0.3031D-08,
     #    0.5390D-08, 0.9577D-08, 0.1703D-07, 0.3030D-07, 0.5386D-07,
     #    0.9577D-07, 0.1703D-06, 0.3027D-06, 0.5382D-06, 0.9572D-06,
     #    0.1701D-05, 0.3023D-05, 0.5373D-05, 0.9537D-05, 0.1693D-04,
     #    0.3004D-04, 0.5321D-04, 0.9408D-04, 0.1659D-03, 0.2913D-03,
     #    0.5091D-03, 0.8826D-03, 0.1512D-02, 0.2551D-02, 0.4210D-02,
     #    0.6742D-02, 0.1040D-01, 0.1530D-01, 0.2126D-01, 0.2773D-01,
     #    0.3380D-01, 0.3846D-01, 0.4104D-01, 0.4126D-01, 0.3938D-01,
     #    0.3598D-01, 0.3168D-01, 0.2707D-01, 0.2257D-01, 0.1845D-01,
     #    0.1482D-01, 0.1175D-01, 0.9208D-02, 0.7152D-02, 0.5498D-02,
     #    0.4195D-02, 0.3179D-02, 0.2408D-02, 0.1806D-02, 0.1350D-02,
     #    0.1002D-02, 0.7506D-03, 0.5531D-03, 0.4116D-03, 0.2974D-03,
     #    0.2113D-03, 0.1540D-03, 0.1108D-03, 0.8206D-04, 0.6791D-04,
     #    0.3849D-04, 0.3888D-04, 0.2415D-04, 0.2433D-04, 0.9458D-05,
     #    0.9543D-05/

      data (calcpts(j,14), j = 1,neta) /0.9585D-10, 0.1701D-09,
     #    0.3017D-09, 0.5360D-09, 0.9528D-09, 0.1693D-08, 0.3010D-08,
     #    0.5352D-08, 0.9510D-08, 0.1691D-07, 0.3008D-07, 0.5348D-07,
     #    0.9509D-07, 0.1691D-06, 0.3005D-06, 0.5344D-06, 0.9504D-06,
     #    0.1689D-05, 0.3002D-05, 0.5335D-05, 0.9470D-05, 0.1681D-04,
     #    0.2983D-04, 0.5283D-04, 0.9341D-04, 0.1648D-03, 0.2893D-03,
     #    0.5056D-03, 0.8766D-03, 0.1502D-02, 0.2534D-02, 0.4184D-02,
     #    0.6704D-02, 0.1034D-01, 0.1522D-01, 0.2116D-01, 0.2761D-01,
     #    0.3367D-01, 0.3833D-01, 0.4091D-01, 0.4114D-01, 0.3930D-01,
     #    0.3591D-01, 0.3162D-01, 0.2703D-01, 0.2253D-01, 0.1843D-01,
     #    0.1481D-01, 0.1174D-01, 0.9207D-02, 0.7131D-02, 0.5490D-02,
     #    0.4200D-02, 0.3182D-02, 0.2396D-02, 0.1808D-02, 0.1352D-02,
     #    0.1004D-02, 0.7369D-03, 0.5542D-03, 0.3976D-03, 0.2983D-03,
     #    0.2122D-03, 0.1549D-03, 0.1117D-03, 0.8293D-04, 0.5377D-04,
     #    0.3935D-04, 0.2474D-04, 0.2500D-04, 0.1018D-04, 0.1031D-04,
     #    0.1039D-04/

      data (calcpts(j,15), j = 1,neta) /0.9484D-10, 0.1683D-09,
     #    0.2986D-09, 0.5305D-09, 0.9430D-09, 0.1676D-08, 0.2979D-08,
     #    0.5297D-08, 0.9412D-08, 0.1674D-07, 0.2977D-07, 0.5293D-07,
     #    0.9412D-07, 0.1674D-06, 0.2975D-06, 0.5290D-06, 0.9407D-06,
     #    0.1672D-05, 0.2971D-05, 0.5281D-05, 0.9373D-05, 0.1664D-04,
     #    0.2953D-04, 0.5229D-04, 0.9248D-04, 0.1631D-03, 0.2864D-03,
     #    0.5006D-03, 0.8680D-03, 0.1488D-02, 0.2511D-02, 0.4147D-02,
     #    0.6646D-02, 0.1026D-01, 0.1511D-01, 0.2102D-01, 0.2744D-01,
     #    0.3347D-01, 0.3814D-01, 0.4072D-01, 0.4099D-01, 0.3916D-01,
     #    0.3580D-01, 0.3155D-01, 0.2697D-01, 0.2249D-01, 0.1839D-01,
     #    0.1478D-01, 0.1173D-01, 0.9194D-02, 0.7127D-02, 0.5482D-02,
     #    0.4189D-02, 0.3185D-02, 0.2397D-02, 0.1809D-02, 0.1352D-02,
     #    0.1003D-02, 0.7511D-03, 0.5532D-03, 0.4115D-03, 0.2971D-03,
     #    0.2110D-03, 0.1536D-03, 0.1104D-03, 0.8161D-04, 0.6744D-04,
     #    0.3800D-04, 0.3839D-04, 0.2365D-04, 0.2383D-04, 0.8947D-05,
     #    0.9030D-05/

      data (calcpts(j,16), j = 1,neta) /0.9341D-10, 0.1658D-09,
     #    0.2941D-09, 0.5226D-09, 0.9290D-09, 0.1651D-08, 0.2935D-08,
     #    0.5219D-08, 0.9272D-08, 0.1649D-07, 0.2933D-07, 0.5215D-07,
     #    0.9273D-07, 0.1649D-06, 0.2930D-06, 0.5211D-06, 0.9268D-06,
     #    0.1647D-05, 0.2927D-05, 0.5203D-05, 0.9235D-05, 0.1640D-04,
     #    0.2909D-04, 0.5153D-04, 0.9111D-04, 0.1607D-03, 0.2823D-03,
     #    0.4934D-03, 0.8558D-03, 0.1467D-02, 0.2477D-02, 0.4092D-02,
     #    0.6564D-02, 0.1014D-01, 0.1494D-01, 0.2081D-01, 0.2718D-01,
     #    0.3319D-01, 0.3784D-01, 0.4044D-01, 0.4073D-01, 0.3894D-01,
     #    0.3563D-01, 0.3141D-01, 0.2687D-01, 0.2244D-01, 0.1834D-01,
     #    0.1475D-01, 0.1170D-01, 0.9181D-02, 0.7122D-02, 0.5486D-02,
     #    0.4189D-02, 0.3183D-02, 0.2393D-02, 0.1804D-02, 0.1346D-02,
     #    0.9968D-03, 0.7442D-03, 0.5461D-03, 0.4042D-03, 0.3047D-03,
     #    0.2185D-03, 0.1611D-03, 0.1178D-03, 0.8900D-04, 0.5981D-04,
     #    0.4536D-04, 0.3073D-04, 0.3099D-04, 0.1617D-04, 0.1628D-04,
     #    0.1637D-04/

      data (calcpts(j,17), j = 1,neta) /0.9140D-10, 0.1622D-09,
     #    0.2878D-09, 0.5114D-09, 0.9091D-09, 0.1616D-08, 0.2872D-08,
     #    0.5107D-08, 0.9075D-08, 0.1614D-07, 0.2871D-07, 0.5104D-07,
     #    0.9076D-07, 0.1614D-06, 0.2868D-06, 0.5100D-06, 0.9071D-06,
     #    0.1612D-05, 0.2865D-05, 0.5092D-05, 0.9038D-05, 0.1605D-04,
     #    0.2847D-04, 0.5044D-04, 0.8919D-04, 0.1574D-03, 0.2764D-03,
     #    0.4832D-03, 0.8382D-03, 0.1438D-02, 0.2428D-02, 0.4014D-02,
     #    0.6444D-02, 0.9965D-02, 0.1470D-01, 0.2049D-01, 0.2681D-01,
     #    0.3278D-01, 0.3741D-01, 0.4002D-01, 0.4037D-01, 0.3863D-01,
     #    0.3538D-01, 0.3122D-01, 0.2673D-01, 0.2233D-01, 0.1826D-01,
     #    0.1470D-01, 0.1167D-01, 0.9149D-02, 0.7108D-02, 0.5465D-02,
     #    0.4178D-02, 0.3168D-02, 0.2391D-02, 0.1800D-02, 0.1341D-02,
     #    0.1006D-02, 0.7379D-03, 0.5545D-03, 0.3973D-03, 0.2977D-03,
     #    0.2113D-03, 0.1538D-03, 0.1105D-03, 0.8168D-04, 0.6746D-04,
     #    0.3800D-04, 0.3836D-04, 0.2361D-04, 0.8782D-05, 0.8897D-05,
     #    0.8976D-05/

      data (calcpts(j,18), j = 1,neta) /0.8860D-10, 0.1573D-09,
     #    0.2791D-09, 0.4959D-09, 0.8816D-09, 0.1567D-08, 0.2785D-08,
     #    0.4953D-08, 0.8802D-08, 0.1565D-07, 0.2784D-07, 0.4950D-07,
     #    0.8801D-07, 0.1565D-06, 0.2782D-06, 0.4947D-06, 0.8797D-06,
     #    0.1564D-05, 0.2779D-05, 0.4939D-05, 0.8766D-05, 0.1557D-04,
     #    0.2762D-04, 0.4892D-04, 0.8653D-04, 0.1527D-03, 0.2682D-03,
     #    0.4689D-03, 0.8138D-03, 0.1396D-02, 0.2360D-02, 0.3904D-02,
     #    0.6272D-02, 0.9714D-02, 0.1435D-01, 0.2004D-01, 0.2626D-01,
     #    0.3217D-01, 0.3678D-01, 0.3942D-01, 0.3983D-01, 0.3817D-01,
     #    0.3502D-01, 0.3095D-01, 0.2653D-01, 0.2218D-01, 0.1817D-01,
     #    0.1462D-01, 0.1162D-01, 0.9119D-02, 0.7079D-02, 0.5455D-02,
     #    0.4161D-02, 0.3161D-02, 0.2381D-02, 0.1787D-02, 0.1342D-02,
     #    0.9912D-03, 0.7374D-03, 0.5534D-03, 0.3960D-03, 0.2961D-03,
     #    0.2096D-03, 0.1520D-03, 0.1086D-03, 0.7971D-04, 0.6547D-04,
     #    0.5098D-04, 0.3633D-04, 0.2157D-04, 0.2173D-04, 0.6842D-05,
     #    0.6917D-05/

      data (calcpts(j,19), j = 1,neta) /0.8482D-10, 0.1506D-09,
     #    0.2673D-09, 0.4749D-09, 0.8443D-09, 0.1501D-08, 0.2668D-08,
     #    0.4744D-08, 0.8430D-08, 0.1499D-07, 0.2667D-07, 0.4741D-07,
     #    0.8431D-07, 0.1499D-06, 0.2664D-06, 0.4738D-06, 0.8427D-06,
     #    0.1498D-05, 0.2662D-05, 0.4730D-05, 0.8397D-05, 0.1491D-04,
     #    0.2646D-04, 0.4687D-04, 0.8290D-04, 0.1463D-03, 0.2570D-03,
     #    0.4495D-03, 0.7805D-03, 0.1340D-02, 0.2266D-02, 0.3752D-02,
     #    0.6036D-02, 0.9363D-02, 0.1386D-01, 0.1939D-01, 0.2547D-01,
     #    0.3127D-01, 0.3585D-01, 0.3853D-01, 0.3902D-01, 0.3751D-01,
     #    0.3448D-01, 0.3054D-01, 0.2622D-01, 0.2195D-01, 0.1800D-01,
     #    0.1451D-01, 0.1154D-01, 0.9062D-02, 0.7047D-02, 0.5424D-02,
     #    0.4152D-02, 0.3145D-02, 0.2376D-02, 0.1795D-02, 0.1333D-02,
     #    0.9950D-03, 0.7403D-03, 0.5407D-03, 0.3978D-03, 0.2977D-03,
     #    0.2110D-03, 0.1532D-03, 0.1098D-03, 0.8080D-04, 0.6651D-04,
     #    0.3700D-04, 0.3733D-04, 0.2255D-04, 0.2271D-04, 0.7810D-05,
     #    0.7881D-05/

      data (calcpts(j,20), j = 1,neta) /0.7986D-10, 0.1418D-09,
     #    0.2517D-09, 0.4474D-09, 0.7953D-09, 0.1414D-08, 0.2513D-08,
     #    0.4469D-08, 0.7942D-08, 0.1413D-07, 0.2512D-07, 0.4467D-07,
     #    0.7942D-07, 0.1413D-06, 0.2510D-06, 0.4464D-06, 0.7938D-06,
     #    0.1411D-05, 0.2508D-05, 0.4457D-05, 0.7912D-05, 0.1405D-04,
     #    0.2493D-04, 0.4416D-04, 0.7812D-04, 0.1379D-03, 0.2423D-03,
     #    0.4239D-03, 0.7362D-03, 0.1265D-02, 0.2140D-02, 0.3548D-02,
     #    0.5716D-02, 0.8883D-02, 0.1318D-01, 0.1849D-01, 0.2436D-01,
     #    0.3002D-01, 0.3454D-01, 0.3727D-01, 0.3788D-01, 0.3654D-01,
     #    0.3370D-01, 0.2993D-01, 0.2577D-01, 0.2163D-01, 0.1777D-01,
     #    0.1435D-01, 0.1142D-01, 0.8980D-02, 0.6985D-02, 0.5391D-02,
     #    0.4121D-02, 0.3137D-02, 0.2363D-02, 0.1778D-02, 0.1328D-02,
     #    0.9888D-03, 0.7330D-03, 0.5476D-03, 0.4042D-03, 0.2886D-03,
     #    0.2167D-03, 0.1588D-03, 0.1152D-03, 0.8615D-04, 0.5680D-04,
     #    0.4225D-04, 0.2756D-04, 0.1276D-04, 0.1290D-04, 0.1300D-04,
     #    -.1933D-05/

      data (calcpts(j,21), j = 1,neta) /0.7364D-10, 0.1308D-09,
     #    0.2322D-09, 0.4128D-09, 0.7339D-09, 0.1304D-08, 0.2319D-08,
     #    0.4124D-08, 0.7329D-08, 0.1304D-07, 0.2318D-07, 0.4122D-07,
     #    0.7330D-07, 0.1304D-06, 0.2317D-06, 0.4120D-06, 0.7326D-06,
     #    0.1302D-05, 0.2314D-05, 0.4113D-05, 0.7302D-05, 0.1297D-04,
     #    0.2301D-04, 0.4076D-04, 0.7211D-04, 0.1273D-03, 0.2237D-03,
     #    0.3915D-03, 0.6803D-03, 0.1169D-02, 0.1980D-02, 0.3287D-02,
     #    0.5304D-02, 0.8258D-02, 0.1229D-01, 0.1729D-01, 0.2287D-01,
     #    0.2830D-01, 0.3273D-01, 0.3549D-01, 0.3628D-01, 0.3517D-01,
     #    0.3260D-01, 0.2908D-01, 0.2514D-01, 0.2116D-01, 0.1744D-01,
     #    0.1412D-01, 0.1126D-01, 0.8865D-02, 0.6916D-02, 0.5332D-02,
     #    0.4094D-02, 0.3115D-02, 0.2349D-02, 0.1775D-02, 0.1322D-02,
     #    0.9960D-03, 0.7388D-03, 0.5525D-03, 0.4084D-03, 0.2924D-03,
     #    0.2202D-03, 0.1621D-03, 0.1184D-03, 0.8922D-04, 0.5982D-04,
     #    0.4522D-04, 0.3049D-04, 0.3068D-04, 0.1581D-04, 0.1590D-04,
     #    0.1596D-04/

      data (calcpts(j,22), j = 1,neta) /0.6623D-10, 0.1177D-09,
     #    0.2090D-09, 0.3714D-09, 0.6605D-09, 0.1174D-08, 0.2087D-08,
     #    0.3712D-08, 0.6597D-08, 0.1173D-07, 0.2087D-07, 0.3711D-07,
     #    0.6598D-07, 0.1173D-06, 0.2085D-06, 0.3708D-06, 0.6595D-06,
     #    0.1172D-05, 0.2083D-05, 0.3703D-05, 0.6573D-05, 0.1167D-04,
     #    0.2071D-04, 0.3670D-04, 0.6493D-04, 0.1146D-03, 0.2015D-03,
     #    0.3527D-03, 0.6130D-03, 0.1054D-02, 0.1787D-02, 0.2969D-02,
     #    0.4798D-02, 0.7487D-02, 0.1117D-01, 0.1578D-01, 0.2096D-01,
     #    0.2608D-01, 0.3034D-01, 0.3312D-01, 0.3410D-01, 0.3330D-01,
     #    0.3108D-01, 0.2789D-01, 0.2425D-01, 0.2052D-01, 0.1698D-01,
     #    0.1379D-01, 0.1103D-01, 0.8707D-02, 0.6800D-02, 0.5253D-02,
     #    0.4030D-02, 0.3071D-02, 0.2328D-02, 0.1748D-02, 0.1307D-02,
     #    0.9787D-03, 0.7349D-03, 0.5475D-03, 0.4027D-03, 0.3013D-03,
     #    0.2137D-03, 0.1554D-03, 0.1115D-03, 0.8225D-04, 0.6777D-04,
     #    0.5312D-04, 0.3836D-04, 0.2353D-04, 0.2364D-04, 0.8718D-05,
     #    0.8771D-05/

      data (calcpts(j,23), j = 1,neta) /0.5794D-10, 0.1030D-09,
     #    0.1829D-09, 0.3251D-09, 0.5782D-09, 0.1028D-08, 0.1827D-08,
     #    0.3250D-08, 0.5776D-08, 0.1027D-07, 0.1827D-07, 0.3249D-07,
     #    0.5776D-07, 0.1027D-06, 0.1826D-06, 0.3247D-06, 0.5774D-06,
     #    0.1026D-05, 0.1824D-05, 0.3242D-05, 0.5756D-05, 0.1022D-04,
     #    0.1814D-04, 0.3214D-04, 0.5686D-04, 0.1004D-03, 0.1765D-03,
     #    0.3090D-03, 0.5373D-03, 0.9244D-03, 0.1568D-02, 0.2608D-02,
     #    0.4221D-02, 0.6599D-02, 0.9870D-02, 0.1399D-01, 0.1868D-01,
     #    0.2338D-01, 0.2740D-01, 0.3016D-01, 0.3134D-01, 0.3088D-01,
     #    0.2908D-01, 0.2633D-01, 0.2306D-01, 0.1963D-01, 0.1634D-01,
     #    0.1333D-01, 0.1071D-01, 0.8483D-02, 0.6647D-02, 0.5151D-02,
     #    0.3957D-02, 0.3017D-02, 0.2296D-02, 0.1726D-02, 0.1297D-02,
     #    0.9662D-03, 0.7208D-03, 0.5323D-03, 0.3868D-03, 0.2848D-03,
     #    0.2119D-03, 0.1533D-03, 0.1092D-03, 0.7987D-04, 0.5032D-04,
     #    0.3562D-04, 0.3583D-04, 0.2097D-04, 0.2107D-04, 0.6131D-05,
     #    0.6176D-05/

      data (calcpts(j,24), j = 1,neta) /0.4927D-10, 0.8757D-10,
     #    0.1556D-09, 0.2766D-09, 0.4919D-09, 0.8745D-09, 0.1555D-08,
     #    0.2765D-08, 0.4915D-08, 0.8741D-08, 0.1555D-07, 0.2764D-07,
     #    0.4915D-07, 0.8742D-07, 0.1554D-06, 0.2763D-06, 0.4913D-06,
     #    0.8733D-06, 0.1552D-05, 0.2759D-05, 0.4898D-05, 0.8697D-05,
     #    0.1543D-04, 0.2735D-04, 0.4839D-04, 0.8545D-04, 0.1503D-03,
     #    0.2631D-03, 0.4576D-03, 0.7877D-03, 0.1337D-02, 0.2226D-02,
     #    0.3607D-02, 0.5649D-02, 0.8470D-02, 0.1205D-01, 0.1616D-01,
     #    0.2035D-01, 0.2403D-01, 0.2670D-01, 0.2803D-01, 0.2794D-01,
     #    0.2662D-01, 0.2436D-01, 0.2154D-01, 0.1851D-01, 0.1552D-01,
     #    0.1275D-01, 0.1029D-01, 0.8201D-02, 0.6450D-02, 0.5021D-02,
     #    0.3871D-02, 0.2965D-02, 0.2252D-02, 0.1692D-02, 0.1274D-02,
     #    0.9557D-03, 0.7087D-03, 0.5191D-03, 0.3878D-03, 0.2854D-03,
     #    0.2121D-03, 0.1532D-03, 0.1090D-03, 0.7959D-04, 0.6496D-04,
     #    0.5021D-04, 0.3538D-04, 0.2050D-04, 0.2058D-04, 0.5633D-05,
     #    0.5670D-05/

      data (calcpts(j,25), j = 1,neta) /0.4076D-10, 0.7246D-10,
     #    0.1287D-09, 0.2289D-09, 0.4072D-09, 0.7238D-09, 0.1287D-08,
     #    0.2289D-08, 0.4068D-08, 0.7236D-08, 0.1287D-07, 0.2288D-07,
     #    0.4069D-07, 0.7237D-07, 0.1286D-06, 0.2287D-06, 0.4067D-06,
     #    0.7229D-06, 0.1285D-05, 0.2284D-05, 0.4055D-05, 0.7200D-05,
     #    0.1278D-04, 0.2264D-04, 0.4007D-04, 0.7075D-04, 0.1244D-03,
     #    0.2180D-03, 0.3791D-03, 0.6528D-03, 0.1109D-02, 0.1847D-02,
     #    0.2996D-02, 0.4701D-02, 0.7065D-02, 0.1008D-01, 0.1358D-01,
     #    0.1719D-01, 0.2045D-01, 0.2294D-01, 0.2435D-01, 0.2459D-01,
     #    0.2374D-01, 0.2201D-01, 0.1972D-01, 0.1713D-01, 0.1451D-01,
     #    0.1202D-01, 0.9781D-02, 0.7837D-02, 0.6189D-02, 0.4843D-02,
     #    0.3753D-02, 0.2882D-02, 0.2192D-02, 0.1657D-02, 0.1251D-02,
     #    0.9304D-03, 0.6969D-03, 0.5213D-03, 0.3893D-03, 0.2864D-03,
     #    0.2128D-03, 0.1537D-03, 0.1094D-03, 0.7983D-04, 0.6513D-04,
     #    0.3533D-04, 0.3547D-04, 0.2057D-04, 0.2063D-04, 0.5677D-05,
     #    0.5708D-05/

      data (calcpts(j,26), j = 1,neta) /0.3290D-10, 0.5849D-10,
     #    0.1039D-09, 0.1848D-09, 0.3287D-09, 0.5844D-09, 0.1039D-08,
     #    0.1848D-08, 0.3285D-08, 0.5843D-08, 0.1039D-07, 0.1848D-07,
     #    0.3285D-07, 0.5843D-07, 0.1038D-06, 0.1847D-06, 0.3284D-06,
     #    0.5837D-06, 0.1038D-05, 0.1844D-05, 0.3274D-05, 0.5814D-05,
     #    0.1032D-04, 0.1829D-04, 0.3236D-04, 0.5714D-04, 0.1005D-03,
     #    0.1761D-03, 0.3064D-03, 0.5277D-03, 0.8966D-03, 0.1495D-02,
     #    0.2427D-02, 0.3813D-02, 0.5742D-02, 0.8218D-02, 0.1111D-01,
     #    0.1414D-01, 0.1693D-01, 0.1915D-01, 0.2055D-01, 0.2102D-01,
     #    0.2059D-01, 0.1940D-01, 0.1763D-01, 0.1554D-01, 0.1332D-01,
     #    0.1115D-01, 0.9167D-02, 0.7406D-02, 0.5896D-02, 0.4635D-02,
     #    0.3607D-02, 0.2772D-02, 0.2120D-02, 0.1612D-02, 0.1218D-02,
     #    0.9103D-03, 0.6754D-03, 0.4990D-03, 0.3663D-03, 0.2780D-03,
     #    0.2041D-03, 0.1448D-03, 0.1004D-03, 0.7070D-04, 0.5594D-04,
     #    0.4110D-04, 0.2621D-04, 0.2629D-04, 0.1134D-04, 0.1138D-04,
     #    0.1140D-04/

      data (calcpts(j,27), j = 1,neta) /0.2600D-10, 0.4624D-10,
     #    0.8217D-10, 0.1461D-09, 0.2599D-09, 0.4621D-09, 0.8217D-09,
     #    0.1462D-08, 0.2598D-08, 0.4620D-08, 0.8218D-08, 0.1461D-07,
     #    0.2598D-07, 0.4621D-07, 0.8212D-07, 0.1460D-06, 0.2597D-06,
     #    0.4616D-06, 0.8204D-06, 0.1458D-05, 0.2589D-05, 0.4598D-05,
     #    0.8160D-05, 0.1446D-04, 0.2559D-04, 0.4520D-04, 0.7950D-04,
     #    0.1393D-03, 0.2424D-03, 0.4176D-03, 0.7099D-03, 0.1184D-02,
     #    0.1925D-02, 0.3027D-02, 0.4566D-02, 0.6551D-02, 0.8883D-02,
     #    0.1135D-01, 0.1367D-01, 0.1558D-01, 0.1688D-01, 0.1748D-01,
     #    0.1738D-01, 0.1664D-01, 0.1539D-01, 0.1378D-01, 0.1200D-01,
     #    0.1019D-01, 0.8465D-02, 0.6910D-02, 0.5540D-02, 0.4384D-02,
     #    0.3434D-02, 0.2666D-02, 0.2040D-02, 0.1558D-02, 0.1176D-02,
     #    0.8971D-03, 0.6761D-03, 0.4989D-03, 0.3657D-03, 0.2770D-03,
     #    0.2029D-03, 0.1435D-03, 0.1139D-03, 0.8413D-04, 0.5432D-04,
     #    0.3945D-04, 0.3954D-04, 0.2459D-04, 0.2463D-04, 0.9662D-05,
     #    0.9681D-05/

      data (calcpts(j,28), j = 1,neta) /0.2019D-10, 0.3591D-10,
     #    0.6382D-10, 0.1135D-09, 0.2019D-09, 0.3589D-09, 0.6383D-09,
     #    0.1135D-08, 0.2018D-08, 0.3589D-08, 0.6383D-08, 0.1135D-07,
     #    0.2018D-07, 0.3589D-07, 0.6378D-07, 0.1134D-06, 0.2017D-06,
     #    0.3586D-06, 0.6373D-06, 0.1133D-05, 0.2011D-05, 0.3571D-05,
     #    0.6339D-05, 0.1123D-04, 0.1988D-04, 0.3511D-04, 0.6177D-04,
     #    0.1082D-03, 0.1884D-03, 0.3246D-03, 0.5519D-03, 0.9212D-03,
     #    0.1498D-02, 0.2359D-02, 0.3563D-02, 0.5121D-02, 0.6964D-02,
     #    0.8933D-02, 0.1081D-01, 0.1240D-01, 0.1354D-01, 0.1417D-01,
     #    0.1427D-01, 0.1389D-01, 0.1307D-01, 0.1192D-01, 0.1056D-01,
     #    0.9108D-02, 0.7674D-02, 0.6336D-02, 0.5136D-02, 0.4101D-02,
     #    0.3232D-02, 0.2533D-02, 0.1947D-02, 0.1492D-02, 0.1139D-02,
     #    0.8581D-03, 0.6512D-03, 0.4883D-03, 0.3548D-03, 0.2657D-03,
     #    0.1914D-03, 0.1469D-03, 0.1022D-03, 0.7239D-04, 0.5754D-04,
     #    0.4263D-04, 0.2770D-04, 0.2775D-04, 0.1278D-04, 0.1280D-04,
     #    0.1281D-04/

      data (calcpts(j,29), j = 1,neta) /0.1546D-10, 0.2749D-10,
     #    0.4886D-10, 0.8690D-10, 0.1546D-09, 0.2748D-09, 0.4887D-09,
     #    0.8692D-09, 0.1545D-08, 0.2748D-08, 0.4887D-08, 0.8689D-08,
     #    0.1545D-07, 0.2748D-07, 0.4884D-07, 0.8685D-07, 0.1544D-06,
     #    0.2745D-06, 0.4879D-06, 0.8673D-06, 0.1540D-05, 0.2735D-05,
     #    0.4853D-05, 0.8601D-05, 0.1522D-04, 0.2689D-04, 0.4730D-04,
     #    0.8288D-04, 0.1443D-03, 0.2487D-03, 0.4229D-03, 0.7061D-03,
     #    0.1149D-02, 0.1810D-02, 0.2737D-02, 0.3941D-02, 0.5371D-02,
     #    0.6910D-02, 0.8397D-02, 0.9680D-02, 0.1065D-01, 0.1124D-01,
     #    0.1145D-01, 0.1129D-01, 0.1081D-01, 0.1005D-01, 0.9070D-02,
     #    0.7967D-02, 0.6826D-02, 0.5717D-02, 0.4696D-02, 0.3793D-02,
     #    0.3020D-02, 0.2373D-02, 0.1845D-02, 0.1422D-02, 0.1087D-02,
     #    0.8231D-03, 0.6214D-03, 0.4670D-03, 0.3481D-03, 0.2589D-03,
     #    0.1844D-03, 0.1397D-03, 0.1100D-03, 0.8011D-04, 0.5022D-04,
     #    0.3530D-04, 0.3535D-04, 0.2038D-04, 0.2041D-04, 0.5425D-05,
     #    0.5435D-05/

      data (calcpts(j,30), j = 1,neta) /0.1170D-10, 0.2081D-10,
     #    0.3698D-10, 0.6577D-10, 0.1170D-09, 0.2080D-09, 0.3699D-09,
     #    0.6579D-09, 0.1169D-08, 0.2080D-08, 0.3699D-08, 0.6577D-08,
     #    0.1169D-07, 0.2080D-07, 0.3696D-07, 0.6573D-07, 0.1169D-06,
     #    0.2078D-06, 0.3693D-06, 0.6564D-06, 0.1166D-05, 0.2070D-05,
     #    0.3673D-05, 0.6510D-05, 0.1152D-04, 0.2035D-04, 0.3581D-04,
     #    0.6274D-04, 0.1092D-03, 0.1883D-03, 0.3203D-03, 0.5349D-03,
     #    0.8706D-03, 0.1372D-02, 0.2077D-02, 0.2994D-02, 0.4087D-02,
     #    0.5271D-02, 0.6427D-02, 0.7443D-02, 0.8232D-02, 0.8751D-02,
     #    0.8997D-02, 0.8982D-02, 0.8728D-02, 0.8257D-02, 0.7602D-02,
     #    0.6810D-02, 0.5944D-02, 0.5065D-02, 0.4224D-02, 0.3456D-02,
     #    0.2782D-02, 0.2208D-02, 0.1731D-02, 0.1343D-02, 0.1033D-02,
     #    0.7865D-03, 0.5963D-03, 0.4490D-03, 0.3358D-03, 0.2494D-03,
     #    0.1853D-03, 0.1375D-03, 0.1002D-03, 0.7333D-04, 0.5391D-04,
     #    0.3897D-04, 0.2851D-04, 0.2103D-04, 0.1505D-04, 0.1056D-04,
     #    0.7572D-05/

      data (calcpts(j,31), j = 1,neta) /0.8769D-11, 0.1560D-10,
     #    0.2772D-10, 0.4930D-10, 0.8769D-10, 0.1559D-09, 0.2773D-09,
     #    0.4931D-09, 0.8765D-09, 0.1559D-08, 0.2773D-08, 0.4930D-08,
     #    0.8766D-08, 0.1559D-07, 0.2771D-07, 0.4927D-07, 0.8763D-07,
     #    0.1558D-06, 0.2768D-06, 0.4921D-06, 0.8737D-06, 0.1552D-05,
     #    0.2754D-05, 0.4880D-05, 0.8637D-05, 0.1526D-04, 0.2684D-04,
     #    0.4704D-04, 0.8189D-04, 0.1412D-03, 0.2402D-03, 0.4011D-03,
     #    0.6531D-03, 0.1030D-02, 0.1560D-02, 0.2250D-02, 0.3076D-02,
     #    0.3974D-02, 0.4858D-02, 0.5647D-02, 0.6275D-02, 0.6712D-02,
     #    0.6952D-02, 0.7007D-02, 0.6892D-02, 0.6622D-02, 0.6211D-02,
     #    0.5678D-02, 0.5058D-02, 0.4395D-02, 0.3728D-02, 0.3098D-02,
     #    0.2526D-02, 0.2029D-02, 0.1606D-02, 0.1256D-02, 0.9722D-03,
     #    0.7462D-03, 0.5675D-03, 0.4289D-03, 0.3231D-03, 0.2410D-03,
     #    0.1798D-03, 0.1335D-03, 0.9759D-04, 0.7218D-04, 0.5274D-04,
     #    0.3928D-04, 0.2881D-04, 0.1983D-04, 0.1535D-04, 0.1085D-04,
     #    0.7861D-05/

      data (calcpts(j,32), j = 1,neta) /0.6519D-11, 0.1160D-10,
     #    0.2061D-10, 0.3665D-10, 0.6520D-10, 0.1159D-09, 0.2061D-09,
     #    0.3666D-09, 0.6517D-09, 0.1159D-08, 0.2062D-08, 0.3665D-08,
     #    0.6518D-08, 0.1159D-07, 0.2060D-07, 0.3664D-07, 0.6515D-07,
     #    0.1158D-06, 0.2058D-06, 0.3658D-06, 0.6496D-06, 0.1154D-05,
     #    0.2047D-05, 0.3629D-05, 0.6422D-05, 0.1134D-04, 0.1996D-04,
     #    0.3498D-04, 0.6089D-04, 0.1050D-03, 0.1786D-03, 0.2984D-03,
     #    0.4859D-03, 0.7664D-03, 0.1161D-02, 0.1676D-02, 0.2293D-02,
     #    0.2967D-02, 0.3634D-02, 0.4235D-02, 0.4725D-02, 0.5080D-02,
     #    0.5296D-02, 0.5379D-02, 0.5342D-02, 0.5198D-02, 0.4954D-02,
     #    0.4617D-02, 0.4200D-02, 0.3725D-02, 0.3224D-02, 0.2727D-02,
     #    0.2258D-02, 0.1837D-02, 0.1471D-02, 0.1162D-02, 0.9064D-03,
     #    0.7009D-03, 0.5369D-03, 0.4070D-03, 0.3070D-03, 0.2308D-03,
     #    0.1725D-03, 0.1277D-03, 0.9475D-04, 0.6932D-04, 0.5137D-04,
     #    0.3640D-04, 0.2742D-04, 0.1993D-04, 0.1394D-04, 0.9449D-05,
     #    0.6453D-05/

      data (calcpts(j,33), j = 1,neta) /0.4816D-11, 0.8566D-11,
     #    0.1522D-10, 0.2708D-10, 0.4816D-10, 0.8564D-10, 0.1523D-09,
     #    0.2709D-09, 0.4814D-09, 0.8562D-09, 0.1523D-08, 0.2708D-08,
     #    0.4815D-08, 0.8564D-08, 0.1522D-07, 0.2706D-07, 0.4813D-07,
     #    0.8555D-07, 0.1521D-06, 0.2703D-06, 0.4799D-06, 0.8522D-06,
     #    0.1513D-05, 0.2681D-05, 0.4744D-05, 0.8380D-05, 0.1474D-04,
     #    0.2584D-04, 0.4499D-04, 0.7756D-04, 0.1320D-03, 0.2205D-03,
     #    0.3591D-03, 0.5665D-03, 0.8584D-03, 0.1239D-02, 0.1697D-02,
     #    0.2198D-02, 0.2696D-02, 0.3149D-02, 0.3523D-02, 0.3804D-02,
     #    0.3986D-02, 0.4076D-02, 0.4081D-02, 0.4010D-02, 0.3872D-02,
     #    0.3668D-02, 0.3403D-02, 0.3084D-02, 0.2726D-02, 0.2352D-02,
     #    0.1984D-02, 0.1640D-02, 0.1331D-02, 0.1065D-02, 0.8402D-03,
     #    0.6552D-03, 0.5045D-03, 0.3865D-03, 0.2938D-03, 0.2220D-03,
     #    0.1667D-03, 0.1248D-03, 0.9188D-04, 0.6793D-04, 0.4996D-04,
     #    0.3798D-04, 0.2750D-04, 0.2001D-04, 0.1552D-04, 0.1102D-04,
     #    0.8025D-05/

      data (calcpts(j,34), j = 1,neta) /0.3536D-11, 0.6289D-11,
     #    0.1118D-10, 0.1988D-10, 0.3536D-10, 0.6287D-10, 0.1118D-09,
     #    0.1989D-09, 0.3534D-09, 0.6286D-09, 0.1118D-08, 0.1988D-08,
     #    0.3535D-08, 0.6287D-08, 0.1117D-07, 0.1987D-07, 0.3534D-07,
     #    0.6281D-07, 0.1116D-06, 0.1984D-06, 0.3523D-06, 0.6257D-06,
     #    0.1110D-05, 0.1968D-05, 0.3483D-05, 0.6152D-05, 0.1083D-04,
     #    0.1897D-04, 0.3303D-04, 0.5695D-04, 0.9689D-04, 0.1619D-03,
     #    0.2637D-03, 0.4161D-03, 0.6305D-03, 0.9107D-03, 0.1247D-02,
     #    0.1616D-02, 0.1985D-02, 0.2322D-02, 0.2604D-02, 0.2820D-02,
     #    0.2968D-02, 0.3052D-02, 0.3076D-02, 0.3048D-02, 0.2973D-02,
     #    0.2854D-02, 0.2692D-02, 0.2489D-02, 0.2249D-02, 0.1983D-02,
     #    0.1707D-02, 0.1436D-02, 0.1185D-02, 0.9606D-03, 0.7668D-03,
     #    0.6041D-03, 0.4696D-03, 0.3620D-03, 0.2767D-03, 0.2094D-03,
     #    0.1585D-03, 0.1181D-03, 0.8813D-04, 0.6567D-04, 0.4769D-04,
     #    0.3571D-04, 0.2672D-04, 0.1923D-04, 0.1473D-04, 0.1024D-04,
     #    0.7239D-05/

      data (calcpts(j,35), j = 1,neta) /0.2583D-11, 0.4593D-11,
     #    0.8164D-11, 0.1452D-10, 0.2583D-10, 0.4592D-10, 0.8167D-10,
     #    0.1453D-09, 0.2582D-09, 0.4592D-09, 0.8167D-09, 0.1452D-08,
     #    0.2582D-08, 0.4592D-08, 0.8162D-08, 0.1451D-07, 0.2581D-07,
     #    0.4588D-07, 0.8154D-07, 0.1449D-06, 0.2573D-06, 0.4570D-06,
     #    0.8111D-06, 0.1438D-05, 0.2544D-05, 0.4494D-05, 0.7907D-05,
     #    0.1386D-04, 0.2413D-04, 0.4160D-04, 0.7078D-04, 0.1183D-03,
     #    0.1926D-03, 0.3040D-03, 0.4607D-03, 0.6655D-03, 0.9118D-03,
     #    0.1182D-02, 0.1452D-02, 0.1701D-02, 0.1910D-02, 0.2074D-02,
     #    0.2190D-02, 0.2262D-02, 0.2293D-02, 0.2288D-02, 0.2250D-02,
     #    0.2183D-02, 0.2087D-02, 0.1963D-02, 0.1810D-02, 0.1631D-02,
     #    0.1435D-02, 0.1233D-02, 0.1036D-02, 0.8523D-03, 0.6897D-03,
     #    0.5492D-03, 0.4326D-03, 0.3354D-03, 0.2591D-03, 0.1977D-03,
     #    0.1498D-03, 0.1123D-03, 0.8387D-04, 0.6289D-04, 0.4641D-04,
     #    0.3442D-04, 0.2543D-04, 0.1794D-04, 0.1344D-04, 0.8945D-05,
     #    0.7447D-05/

      data (calcpts(j,36), j = 1,neta) /0.1878D-11, 0.3341D-11,
     #    0.5938D-11, 0.1056D-10, 0.1879D-10, 0.3340D-10, 0.5940D-10,
     #    0.1056D-09, 0.1878D-09, 0.3340D-09, 0.5940D-09, 0.1056D-08,
     #    0.1878D-08, 0.3340D-08, 0.5936D-08, 0.1056D-07, 0.1877D-07,
     #    0.3337D-07, 0.5931D-07, 0.1054D-06, 0.1872D-06, 0.3324D-06,
     #    0.5900D-06, 0.1046D-05, 0.1851D-05, 0.3269D-05, 0.5751D-05,
     #    0.1008D-04, 0.1755D-04, 0.3026D-04, 0.5148D-04, 0.8602D-04,
     #    0.1401D-03, 0.2211D-03, 0.3352D-03, 0.4842D-03, 0.6635D-03,
     #    0.8605D-03, 0.1058D-02, 0.1239D-02, 0.1394D-02, 0.1516D-02,
     #    0.1604D-02, 0.1663D-02, 0.1694D-02, 0.1700D-02, 0.1684D-02,
     #    0.1647D-02, 0.1591D-02, 0.1517D-02, 0.1423D-02, 0.1310D-02,
     #    0.1178D-02, 0.1035D-02, 0.8878D-03, 0.7447D-03, 0.6124D-03,
     #    0.4948D-03, 0.3937D-03, 0.3099D-03, 0.2395D-03, 0.1841D-03,
     #    0.1407D-03, 0.1062D-03, 0.7922D-04, 0.5974D-04, 0.4476D-04,
     #    0.3277D-04, 0.2377D-04, 0.1778D-04, 0.1328D-04, 0.8780D-05,
     #    0.7282D-05/

      data (calcpts(j,37), j = 1,neta) /0.1361D-11, 0.2420D-11,
     #    0.4302D-11, 0.7651D-11, 0.1361D-10, 0.2420D-10, 0.4303D-10,
     #    0.7654D-10, 0.1360D-09, 0.2419D-09, 0.4304D-09, 0.7652D-09,
     #    0.1361D-08, 0.2420D-08, 0.4301D-08, 0.7648D-08, 0.1360D-07,
     #    0.2417D-07, 0.4297D-07, 0.7637D-07, 0.1356D-06, 0.2408D-06,
     #    0.4274D-06, 0.7575D-06, 0.1341D-05, 0.2368D-05, 0.4167D-05,
     #    0.7302D-05, 0.1271D-04, 0.2192D-04, 0.3730D-04, 0.6232D-04,
     #    0.1015D-03, 0.1602D-03, 0.2429D-03, 0.3509D-03, 0.4808D-03,
     #    0.6237D-03, 0.7669D-03, 0.8990D-03, 0.1012D-02, 0.1101D-02,
     #    0.1168D-02, 0.1214D-02, 0.1241D-02, 0.1252D-02, 0.1247D-02,
     #    0.1229D-02, 0.1197D-02, 0.1153D-02, 0.1097D-02, 0.1027D-02,
     #    0.9440D-03, 0.8481D-03, 0.7439D-03, 0.6371D-03, 0.5338D-03,
     #    0.4384D-03, 0.3538D-03, 0.2812D-03, 0.2206D-03, 0.1710D-03,
     #    0.1314D-03, 0.9996D-04, 0.7554D-04, 0.5680D-04, 0.4241D-04,
     #    0.3147D-04, 0.2322D-04, 0.1722D-04, 0.1258D-04, 0.9276D-05,
     #    0.6727D-05/

      data (calcpts(j,38), j = 1,neta) /0.9823D-12, 0.1747D-11,
     #    0.3105D-11, 0.5523D-11, 0.9824D-11, 0.1747D-10, 0.3106D-10,
     #    0.5525D-10, 0.9820D-10, 0.1746D-09, 0.3106D-09, 0.5523D-09,
     #    0.9821D-09, 0.1747D-08, 0.3104D-08, 0.5520D-08, 0.9817D-08,
     #    0.1745D-07, 0.3102D-07, 0.5513D-07, 0.9788D-07, 0.1738D-06,
     #    0.3085D-06, 0.5468D-06, 0.9677D-06, 0.1709D-05, 0.3008D-05,
     #    0.5271D-05, 0.9178D-05, 0.1582D-04, 0.2692D-04, 0.4499D-04,
     #    0.7328D-04, 0.1157D-03, 0.1753D-03, 0.2533D-03, 0.3472D-03,
     #    0.4503D-03, 0.5539D-03, 0.6495D-03, 0.7313D-03, 0.7967D-03,
     #    0.8460D-03, 0.8807D-03, 0.9029D-03, 0.9140D-03, 0.9153D-03,
     #    0.9074D-03, 0.8906D-03, 0.8654D-03, 0.8319D-03, 0.7900D-03,
     #    0.7389D-03, 0.6781D-03, 0.6084D-03, 0.5330D-03, 0.4559D-03,
     #    0.3816D-03, 0.3129D-03, 0.2522D-03, 0.2002D-03, 0.1569D-03,
     #    0.1216D-03, 0.9324D-04, 0.7090D-04, 0.5351D-04, 0.4017D-04,
     #    0.2997D-04, 0.2218D-04, 0.1633D-04, 0.1198D-04, 0.8832D-05,
     #    0.6432D-05/

      data (calcpts(j,39), j = 1,neta) /0.7071D-12, 0.1258D-11,
     #    0.2235D-11, 0.3976D-11, 0.7072D-11, 0.1257D-10, 0.2236D-10,
     #    0.3977D-10, 0.7069D-10, 0.1257D-09, 0.2236D-09, 0.3976D-09,
     #    0.7070D-09, 0.1257D-08, 0.2235D-08, 0.3974D-08, 0.7067D-08,
     #    0.1256D-07, 0.2233D-07, 0.3969D-07, 0.7046D-07, 0.1251D-06,
     #    0.2221D-06, 0.3936D-06, 0.6967D-06, 0.1231D-05, 0.2165D-05,
     #    0.3795D-05, 0.6607D-05, 0.1139D-04, 0.1938D-04, 0.3238D-04,
     #    0.5276D-04, 0.8326D-04, 0.1262D-03, 0.1824D-03, 0.2499D-03,
     #    0.3243D-03, 0.3988D-03, 0.4678D-03, 0.5269D-03, 0.5743D-03,
     #    0.6104D-03, 0.6362D-03, 0.6535D-03, 0.6634D-03, 0.6670D-03,
     #    0.6646D-03, 0.6564D-03, 0.6425D-03, 0.6230D-03, 0.5980D-03,
     #    0.5672D-03, 0.5300D-03, 0.4858D-03, 0.4354D-03, 0.3811D-03,
     #    0.3257D-03, 0.2723D-03, 0.2232D-03, 0.1797D-03, 0.1427D-03,
     #    0.1117D-03, 0.8649D-04, 0.6640D-04, 0.5051D-04, 0.3806D-04,
     #    0.2861D-04, 0.2142D-04, 0.1587D-04, 0.1182D-04, 0.8670D-05,
     #    0.6420D-05/

      data (calcpts(j,40), j = 1,neta) /0.5074D-12, 0.9025D-12,
     #    0.1604D-11, 0.2853D-11, 0.5075D-11, 0.9023D-11, 0.1605D-10,
     #    0.2854D-10, 0.5073D-10, 0.9022D-10, 0.1605D-09, 0.2853D-09,
     #    0.5073D-09, 0.9023D-09, 0.1604D-08, 0.2852D-08, 0.5071D-08,
     #    0.9014D-08, 0.1602D-07, 0.2848D-07, 0.5056D-07, 0.8980D-07,
     #    0.1594D-06, 0.2825D-06, 0.4999D-06, 0.8830D-06, 0.1554D-05,
     #    0.2723D-05, 0.4741D-05, 0.8174D-05, 0.1391D-04, 0.2324D-04,
     #    0.3786D-04, 0.5975D-04, 0.9057D-04, 0.1309D-03, 0.1794D-03,
     #    0.2327D-03, 0.2863D-03, 0.3358D-03, 0.3783D-03, 0.4125D-03,
     #    0.4386D-03, 0.4576D-03, 0.4706D-03, 0.4788D-03, 0.4827D-03,
     #    0.4829D-03, 0.4794D-03, 0.4723D-03, 0.4614D-03, 0.4467D-03,
     #    0.4283D-03, 0.4058D-03, 0.3789D-03, 0.3470D-03, 0.3108D-03,
     #    0.2717D-03, 0.2321D-03, 0.1939D-03, 0.1586D-03, 0.1276D-03,
     #    0.1012D-03, 0.7919D-04, 0.6120D-04, 0.4695D-04, 0.3571D-04,
     #    0.2686D-04, 0.2011D-04, 0.1501D-04, 0.1111D-04, 0.8263D-05,
     #    0.6013D-05/

      data (calcpts(j,41), j = 1,neta) /0.3632D-12, 0.6459D-12,
     #    0.1148D-11, 0.2042D-11, 0.3632D-11, 0.6458D-11, 0.1148D-10,
     #    0.2043D-10, 0.3630D-10, 0.6457D-10, 0.1149D-09, 0.2042D-09,
     #    0.3631D-09, 0.6458D-09, 0.1148D-08, 0.2041D-08, 0.3630D-08,
     #    0.6452D-08, 0.1147D-07, 0.2038D-07, 0.3619D-07, 0.6427D-07,
     #    0.1141D-06, 0.2022D-06, 0.3578D-06, 0.6320D-06, 0.1112D-05,
     #    0.1949D-05, 0.3393D-05, 0.5850D-05, 0.9954D-05, 0.1663D-04,
     #    0.2710D-04, 0.4276D-04, 0.6483D-04, 0.9367D-04, 0.1284D-03,
     #    0.1666D-03, 0.2049D-03, 0.2404D-03, 0.2708D-03, 0.2954D-03,
     #    0.3142D-03, 0.3280D-03, 0.3377D-03, 0.3440D-03, 0.3475D-03,
     #    0.3487D-03, 0.3476D-03, 0.3443D-03, 0.3385D-03, 0.3302D-03,
     #    0.3193D-03, 0.3059D-03, 0.2896D-03, 0.2702D-03, 0.2473D-03,
     #    0.2213D-03, 0.1933D-03, 0.1650D-03, 0.1377D-03, 0.1127D-03,
     #    0.9046D-04, 0.7172D-04, 0.5598D-04, 0.4323D-04, 0.3318D-04,
     #    0.2508D-04, 0.1894D-04, 0.1414D-04, 0.1054D-04, 0.7838D-05,
     #    0.5738D-05/

      data (calcpts(j,42), j = 1,neta) /0.2594D-12, 0.4613D-12,
     #    0.8200D-12, 0.1458D-11, 0.2594D-11, 0.4613D-11, 0.8202D-11,
     #    0.1459D-10, 0.2593D-10, 0.4612D-10, 0.8203D-10, 0.1458D-09,
     #    0.2593D-09, 0.4612D-09, 0.8197D-09, 0.1458D-08, 0.2592D-08,
     #    0.4608D-08, 0.8190D-08, 0.1456D-07, 0.2585D-07, 0.4590D-07,
     #    0.8147D-07, 0.1444D-06, 0.2555D-06, 0.4514D-06, 0.7942D-06,
     #    0.1392D-05, 0.2423D-05, 0.4178D-05, 0.7110D-05, 0.1188D-04,
     #    0.1935D-04, 0.3054D-04, 0.4630D-04, 0.6691D-04, 0.9170D-04,
     #    0.1190D-03, 0.1464D-03, 0.1717D-03, 0.1935D-03, 0.2111D-03,
     #    0.2246D-03, 0.2345D-03, 0.2416D-03, 0.2463D-03, 0.2492D-03,
     #    0.2506D-03, 0.2506D-03, 0.2492D-03, 0.2463D-03, 0.2418D-03,
     #    0.2356D-03, 0.2277D-03, 0.2179D-03, 0.2063D-03, 0.1923D-03,
     #    0.1759D-03, 0.1573D-03, 0.1373D-03, 0.1171D-03, 0.9766D-04,
     #    0.7982D-04, 0.6408D-04, 0.5073D-04, 0.3964D-04, 0.3064D-04,
     #    0.2344D-04, 0.1774D-04, 0.1339D-04, 0.1009D-04, 0.7391D-05,
     #    0.5591D-05/

      data (calcpts(j,43), j = 1,neta) /0.1849D-12, 0.3288D-12,
     #    0.5844D-12, 0.1039D-11, 0.1849D-11, 0.3287D-11, 0.5846D-11,
     #    0.1040D-10, 0.1848D-10, 0.3287D-10, 0.5846D-10, 0.1039D-09,
     #    0.1848D-09, 0.3287D-09, 0.5842D-09, 0.1039D-08, 0.1848D-08,
     #    0.3284D-08, 0.5837D-08, 0.1037D-07, 0.1842D-07, 0.3271D-07,
     #    0.5806D-07, 0.1029D-06, 0.1821D-06, 0.3217D-06, 0.5660D-06,
     #    0.9920D-06, 0.1727D-05, 0.2978D-05, 0.5067D-05, 0.8466D-05,
     #    0.1379D-04, 0.2177D-04, 0.3300D-04, 0.4768D-04, 0.6535D-04,
     #    0.8480D-04, 0.1043D-03, 0.1224D-03, 0.1379D-03, 0.1505D-03,
     #    0.1601D-03, 0.1672D-03, 0.1723D-03, 0.1758D-03, 0.1781D-03,
     #    0.1793D-03, 0.1797D-03, 0.1793D-03, 0.1780D-03, 0.1757D-03,
     #    0.1723D-03, 0.1678D-03, 0.1620D-03, 0.1550D-03, 0.1466D-03,
     #    0.1366D-03, 0.1249D-03, 0.1116D-03, 0.9738D-04, 0.8296D-04,
     #    0.6912D-04, 0.5646D-04, 0.4534D-04, 0.3586D-04, 0.2796D-04,
     #    0.2166D-04, 0.1656D-04, 0.1251D-04, 0.9358D-05, 0.7108D-05,
     #    0.5308D-05/

      data (calcpts(j,44), j = 1,neta) /0.1315D-12, 0.2338D-12,
     #    0.4156D-12, 0.7392D-12, 0.1315D-11, 0.2338D-11, 0.4157D-11,
     #    0.7394D-11, 0.1314D-10, 0.2337D-10, 0.4158D-10, 0.7392D-10,
     #    0.1314D-09, 0.2338D-09, 0.4155D-09, 0.7389D-09, 0.1314D-08,
     #    0.2336D-08, 0.4151D-08, 0.7378D-08, 0.1310D-07, 0.2327D-07,
     #    0.4129D-07, 0.7318D-07, 0.1295D-06, 0.2288D-06, 0.4025D-06,
     #    0.7055D-06, 0.1228D-05, 0.2118D-05, 0.3604D-05, 0.6021D-05,
     #    0.9809D-05, 0.1548D-04, 0.2347D-04, 0.3391D-04, 0.4648D-04,
     #    0.6031D-04, 0.7419D-04, 0.8705D-04, 0.9810D-04, 0.1070D-03,
     #    0.1139D-03, 0.1190D-03, 0.1227D-03, 0.1252D-03, 0.1269D-03,
     #    0.1279D-03, 0.1284D-03, 0.1284D-03, 0.1278D-03, 0.1267D-03,
     #    0.1250D-03, 0.1225D-03, 0.1192D-03, 0.1150D-03, 0.1100D-03,
     #    0.1040D-03, 0.9684D-04, 0.8850D-04, 0.7906D-04, 0.6892D-04,
     #    0.5868D-04, 0.4886D-04, 0.3989D-04, 0.3200D-04, 0.2530D-04,
     #    0.1973D-04, 0.1522D-04, 0.1162D-04, 0.8801D-05, 0.6626D-05,
     #    0.4946D-05/

      data (calcpts(j,45), j = 1,neta) /0.9338D-13, 0.1661D-12,
     #    0.2952D-12, 0.5250D-12, 0.9339D-12, 0.1660D-11, 0.2953D-11,
     #    0.5252D-11, 0.9334D-11, 0.1660D-10, 0.2953D-10, 0.5250D-10,
     #    0.9336D-10, 0.1660D-09, 0.2951D-09, 0.5248D-09, 0.9332D-09,
     #    0.1659D-08, 0.2948D-08, 0.5240D-08, 0.9305D-08, 0.1652D-07,
     #    0.2933D-07, 0.5198D-07, 0.9199D-07, 0.1625D-06, 0.2859D-06,
     #    0.5011D-06, 0.8724D-06, 0.1504D-05, 0.2559D-05, 0.4276D-05,
     #    0.6967D-05, 0.1099D-04, 0.1667D-04, 0.2409D-04, 0.3301D-04,
     #    0.4283D-04, 0.5270D-04, 0.6183D-04, 0.6968D-04, 0.7602D-04,
     #    0.8091D-04, 0.8454D-04, 0.8715D-04, 0.8899D-04, 0.9023D-04,
     #    0.9102D-04, 0.9146D-04, 0.9159D-04, 0.9142D-04, 0.9093D-04,
     #    0.9007D-04, 0.8875D-04, 0.8693D-04, 0.8453D-04, 0.8154D-04,
     #    0.7794D-04, 0.7367D-04, 0.6859D-04, 0.6266D-04, 0.5594D-04,
     #    0.4876D-04, 0.4149D-04, 0.3453D-04, 0.2818D-04, 0.2260D-04,
     #    0.1785D-04, 0.1394D-04, 0.1074D-04, 0.8206D-05, 0.6226D-05,
     #    0.4681D-05/

      data (calcpts(j,46), j = 1,neta) /0.6618D-13, 0.1177D-12,
     #    0.2092D-12, 0.3721D-12, 0.6619D-12, 0.1177D-11, 0.2093D-11,
     #    0.3722D-11, 0.6616D-11, 0.1177D-10, 0.2093D-10, 0.3721D-10,
     #    0.6617D-10, 0.1177D-09, 0.2092D-09, 0.3720D-09, 0.6615D-09,
     #    0.1176D-08, 0.2090D-08, 0.3714D-08, 0.6595D-08, 0.1171D-07,
     #    0.2079D-07, 0.3684D-07, 0.6520D-07, 0.1152D-06, 0.2026D-06,
     #    0.3552D-06, 0.6184D-06, 0.1066D-05, 0.1814D-05, 0.3031D-05,
     #    0.4938D-05, 0.7793D-05, 0.1181D-04, 0.1707D-04, 0.2340D-04,
     #    0.3036D-04, 0.3735D-04, 0.4382D-04, 0.4939D-04, 0.5389D-04,
     #    0.5735D-04, 0.5993D-04, 0.6179D-04, 0.6311D-04, 0.6400D-04,
     #    0.6460D-04, 0.6495D-04, 0.6512D-04, 0.6510D-04, 0.6491D-04,
     #    0.6451D-04, 0.6385D-04, 0.6288D-04, 0.6156D-04, 0.5983D-04,
     #    0.5770D-04, 0.5513D-04, 0.5209D-04, 0.4849D-04, 0.4426D-04,
     #    0.3951D-04, 0.3441D-04, 0.2927D-04, 0.2435D-04, 0.1985D-04,
     #    0.1592D-04, 0.1257D-04, 0.9799D-05, 0.7549D-05, 0.5764D-05,
     #    0.4369D-05/

      data (calcpts(j,47), j = 1,neta) /0.4684D-13, 0.8331D-13,
     #    0.1481D-12, 0.2634D-12, 0.4684D-12, 0.8329D-12, 0.1481D-11,
     #    0.2634D-11, 0.4682D-11, 0.8328D-11, 0.1481D-10, 0.2634D-10,
     #    0.4683D-10, 0.8329D-10, 0.1480D-09, 0.2632D-09, 0.4681D-09,
     #    0.8321D-09, 0.1479D-08, 0.2629D-08, 0.4667D-08, 0.8289D-08,
     #    0.1471D-07, 0.2607D-07, 0.4614D-07, 0.8151D-07, 0.1434D-06,
     #    0.2513D-06, 0.4376D-06, 0.7545D-06, 0.1284D-05, 0.2145D-05,
     #    0.3494D-05, 0.5515D-05, 0.8361D-05, 0.1208D-04, 0.1656D-04,
     #    0.2149D-04, 0.2643D-04, 0.3101D-04, 0.3495D-04, 0.3814D-04,
     #    0.4059D-04, 0.4242D-04, 0.4374D-04, 0.4467D-04, 0.4532D-04,
     #    0.4575D-04, 0.4603D-04, 0.4618D-04, 0.4622D-04, 0.4616D-04,
     #    0.4598D-04, 0.4567D-04, 0.4518D-04, 0.4448D-04, 0.4352D-04,
     #    0.4229D-04, 0.4076D-04, 0.3894D-04, 0.3678D-04, 0.3422D-04,
     #    0.3123D-04, 0.2786D-04, 0.2426D-04, 0.2062D-04, 0.1714D-04,
     #    0.1397D-04, 0.1120D-04, 0.8828D-05, 0.6878D-05, 0.5303D-05,
     #    0.4043D-05/

      data (calcpts(j,48), j = 1,neta) /0.3311D-13, 0.5889D-13,
     #    0.1047D-12, 0.1862D-12, 0.3311D-12, 0.5887D-12, 0.1047D-11,
     #    0.1862D-11, 0.3310D-11, 0.5886D-11, 0.1047D-10, 0.1862D-10,
     #    0.3310D-10, 0.5887D-10, 0.1046D-09, 0.1861D-09, 0.3309D-09,
     #    0.5882D-09, 0.1045D-08, 0.1858D-08, 0.3299D-08, 0.5859D-08,
     #    0.1040D-07, 0.1843D-07, 0.3262D-07, 0.5761D-07, 0.1014D-06,
     #    0.1777D-06, 0.3093D-06, 0.5333D-06, 0.9075D-06, 0.1516D-05,
     #    0.2470D-05, 0.3898D-05, 0.5910D-05, 0.8540D-05, 0.1171D-04,
     #    0.1519D-04, 0.1869D-04, 0.2192D-04, 0.2471D-04, 0.2696D-04,
     #    0.2869D-04, 0.2999D-04, 0.3092D-04, 0.3158D-04, 0.3204D-04,
     #    0.3236D-04, 0.3256D-04, 0.3268D-04, 0.3274D-04, 0.3274D-04,
     #    0.3267D-04, 0.3252D-04, 0.3228D-04, 0.3193D-04, 0.3142D-04,
     #    0.3073D-04, 0.2985D-04, 0.2877D-04, 0.2747D-04, 0.2594D-04,
     #    0.2413D-04, 0.2202D-04, 0.1964D-04, 0.1709D-04, 0.1452D-04,
     #    0.1206D-04, 0.9827D-05, 0.7877D-05, 0.6212D-05, 0.4832D-05,
     #    0.3722D-05/

      data (calcpts(j,49), j = 1,neta) /0.2337D-13, 0.4157D-13,
     #    0.7388D-13, 0.1314D-12, 0.2337D-12, 0.4156D-12, 0.7390D-12,
     #    0.1314D-11, 0.2336D-11, 0.4155D-11, 0.7391D-11, 0.1314D-10,
     #    0.2337D-10, 0.4156D-10, 0.7386D-10, 0.1313D-09, 0.2336D-09,
     #    0.4152D-09, 0.7379D-09, 0.1312D-08, 0.2329D-08, 0.4136D-08,
     #    0.7340D-08, 0.1301D-07, 0.2302D-07, 0.4067D-07, 0.7156D-07,
     #    0.1254D-06, 0.2184D-06, 0.3765D-06, 0.6406D-06, 0.1070D-05,
     #    0.1744D-05, 0.2752D-05, 0.4172D-05, 0.6028D-05, 0.8263D-05,
     #    0.1072D-04, 0.1319D-04, 0.1548D-04, 0.1744D-04, 0.1903D-04,
     #    0.2026D-04, 0.2117D-04, 0.2183D-04, 0.2230D-04, 0.2263D-04,
     #    0.2285D-04, 0.2300D-04, 0.2309D-04, 0.2314D-04, 0.2316D-04,
     #    0.2314D-04, 0.2308D-04, 0.2296D-04, 0.2279D-04, 0.2253D-04,
     #    0.2216D-04, 0.2167D-04, 0.2104D-04, 0.2028D-04, 0.1936D-04,
     #    0.1828D-04, 0.1700D-04, 0.1550D-04, 0.1382D-04, 0.1202D-04,
     #    0.1021D-04, 0.8483D-05, 0.6900D-05, 0.5535D-05, 0.4365D-05,
     #    0.3390D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1bar_HTq = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     =========================================
      double precision function h1f_LTq(eta,xi)
c     =========================================

c     eq (28) in PLB347 (1995) 143 - 151 for the transverse piece
c     This also takes into account the additional mass factorizations
c     necessary from a low Q^2 photon coupling to the light quark.
c     MSbar scheme
c     This routine is called subd1tqf in the original code.
c     Gives h1_LTq for Q2 < 1.5 GeV2 (use h1_LTq for Q2 > 1.5 GeV2)

      implicit none
      integer neta, nxi
      parameter (neta = 45, nxi = 15)
      double precision calcpts(neta,nxi), aeta(neta), axi(nxi)
      double precision eta, xi, huge, small
      double precision t, u, y1, y2, y3, y4
      parameter (small = 1.d-8, huge = 1.d10)
      integer j, ieta, ixi

      data (calcpts(j, 1), j=1,neta) /0.d0, 0.4019D-05, 0.1896D-04,
     #  0.3899D-04, 0.6269D-04, 0.8935D-04, 0.1037D-03, 0.4849D-03,
     #  0.9762D-03, 0.1525D-02, 0.2108D-02, 0.2406D-02, 0.5362D-02,
     #  0.7965D-02, 0.1012D-01, 0.1186D-01, 0.1328D-01, 0.1443D-01,
     #  0.1537D-01, 0.1616D-01, 0.1682D-01, 0.1986D-01, 0.2073D-01,
     #  0.2096D-01, 0.2088D-01, 0.2067D-01, 0.2037D-01, 0.2001D-01,
     #  0.1965D-01, 0.1929D-01, 0.1370D-01, 0.1084D-01, 0.9107D-02,
     #  0.7934D-02, 0.7464D-02, 0.4891D-02, 0.3756D-02, 0.2645D-02,
     #  0.2090D-02, 0.1746D-02, 0.1617D-02, 0.4779D-03, 0.2775D-03,
     #  0.4104D-04, 0.d0/
c
      data (calcpts(j, 2), j=1,neta) /0.d0, 0.2321D-05, 0.1077D-04,
     #  0.2190D-04, 0.3488D-04, 0.4935D-04, 0.5706D-04, 0.2585D-03,
     #  0.5173D-03, 0.8102D-03, 0.1125D-02, 0.1287D-02, 0.2955D-02,
     #  0.4511D-02, 0.5861D-02, 0.7013D-02, 0.7984D-02, 0.8813D-02,
     #  0.9516D-02, 0.1012D-01, 0.1065D-01, 0.1352D-01, 0.1463D-01,
     #  0.1512D-01, 0.1529D-01, 0.1529D-01, 0.1518D-01, 0.1502D-01,
     #  0.1482D-01, 0.1460D-01, 0.1073D-01, 0.8586D-02, 0.7261D-02,
     #  0.6349D-02, 0.5983D-02, 0.3966D-02, 0.3061D-02, 0.2178D-02,
     #  0.1718D-02, 0.1440D-02, 0.1337D-02, 0.3998D-03, 0.2339D-03,
     #  0.3529D-04, 0.d0/
c
      data (calcpts(j, 3), j=1,neta) /0.d0, 0.5064D-06, 0.2317D-05,
     #  0.4667D-05, 0.7383D-05, 0.1040D-04, 0.1200D-04, 0.5411D-04,
     #  0.1119D-03, 0.1832D-03, 0.2663D-03, 0.3119D-03, 0.8727D-03,
     #  0.1533D-02, 0.2214D-02, 0.2874D-02, 0.3495D-02, 0.4073D-02,
     #  0.4602D-02, 0.5091D-02, 0.5538D-02, 0.8424D-02, 0.9777D-02,
     #  0.1046D-01, 0.1080D-01, 0.1095D-01, 0.1098D-01, 0.1094D-01,
     #  0.1086D-01, 0.1075D-01, 0.8148D-02, 0.6592D-02, 0.5609D-02,
     #  0.4921D-02, 0.4650D-02, 0.3110D-02, 0.2411D-02, 0.1722D-02,
     #  0.1371D-02, 0.1150D-02, 0.1067D-02, 0.3261D-03, 0.1892D-03,
     #  0.2870D-04, 0.d0/
c
      data (calcpts(j, 4), j=1,neta) /0.d0, 0.5228D-08, 0.2381D-07,
     #  0.4875D-07, 0.7962D-07, 0.1172D-06, 0.1388D-06, 0.1292D-05,
     #  0.4892D-05, 0.1220D-04, 0.2403D-04, 0.3177D-04, 0.1790D-03,
     #  0.4347D-03, 0.7627D-03, 0.1131D-02, 0.1518D-02, 0.1906D-02,
     #  0.2291D-02, 0.2660D-02, 0.3014D-02, 0.5617D-02, 0.7014D-02,
     #  0.7787D-02, 0.8220D-02, 0.8455D-02, 0.8574D-02, 0.8612D-02,
     #  0.8603D-02, 0.8558D-02, 0.6753D-02, 0.5525D-02, 0.4737D-02,
     #  0.4176D-02, 0.3954D-02, 0.2678D-02, 0.2087D-02, 0.1502D-02,
     #  0.1196D-02, 0.1007D-02, 0.9338D-03, 0.2877D-03, 0.1692D-03,
     #  0.2625D-04, 0.d0/
c
      data (calcpts(j, 5), j=1,neta) /0.d0, 0.9101D-12, 0.4199D-10,
     #  0.2486D-09, 0.7987D-09, 0.1908D-08, 0.2745D-08, 0.1169D-06,
     #  0.6378D-06, 0.1896D-05, 0.4197D-05, 0.5822D-05, 0.4473D-04,
     #  0.1310D-03, 0.2623D-03, 0.4305D-03, 0.6257D-03, 0.8389D-03,
     #  0.1064D-02, 0.1294D-02, 0.1525D-02, 0.3522D-02, 0.4800D-02,
     #  0.5585D-02, 0.6078D-02, 0.6383D-02, 0.6571D-02, 0.6681D-02,
     #  0.6738D-02, 0.6764D-02, 0.5665D-02, 0.4725D-02, 0.4088D-02,
     #  0.3632D-02, 0.3446D-02, 0.2369D-02, 0.1861D-02, 0.1347D-02,
     #  0.1081D-02, 0.9132D-03, 0.8487D-03, 0.2657D-03, 0.1563D-03,
     #  0.2511D-04, 0.d0/
c
      data (calcpts(j, 6), j=1,neta) /0.d0, 0.2657D-12, 0.1234D-10,
     #  0.7333D-10, 0.2366D-09, 0.5664D-09, 0.8165D-09, 0.3585D-07,
     #  0.2016D-06, 0.6159D-06, 0.1399D-05, 0.1963D-05, 0.1675D-04,
     #  0.5327D-04, 0.1141D-03, 0.1979D-03, 0.3015D-03, 0.4212D-03,
     #  0.5532D-03, 0.6942D-03, 0.8411D-03, 0.2292D-02, 0.3371D-02,
     #  0.4096D-02, 0.4583D-02, 0.4909D-02, 0.5129D-02, 0.5277D-02,
     #  0.5371D-02, 0.5431D-02, 0.4823D-02, 0.4098D-02, 0.3584D-02,
     #  0.3204D-02, 0.3046D-02, 0.2125D-02, 0.1683D-02, 0.1229D-02,
     #  0.9890D-03, 0.8394D-03, 0.7798D-03, 0.2471D-03, 0.1470D-03,
     #  0.2343D-04, 0.d0/
c
      data (calcpts(j, 7), j=1,neta) /0.d0, 0.2199D-12, 0.1022D-10,
     #  0.6069D-10, 0.1959D-09, 0.4690D-09, 0.6762D-09, 0.2974D-07,
     #  0.1674D-06, 0.5122D-06, 0.1165D-05, 0.1637D-05, 0.1405D-04,
     #  0.4497D-04, 0.9692D-04, 0.1690D-03, 0.2589D-03, 0.3633D-03,
     #  0.4793D-03, 0.6040D-03, 0.7347D-03, 0.2058D-02, 0.3074D-02,
     #  0.3776D-02, 0.4248D-02, 0.4574D-02, 0.4796D-02, 0.4949D-02,
     #  0.5048D-02, 0.5115D-02, 0.4613D-02, 0.3939D-02, 0.3453D-02,
     #  0.3095D-02, 0.2944D-02, 0.2064D-02, 0.1636D-02, 0.1198D-02,
     #  0.9665D-03, 0.8193D-03, 0.7636D-03, 0.2445D-03, 0.1445D-03,
     #  0.2312D-04, 0.d0/
c
      data (calcpts(j, 8), j=1,neta) /0.d0, 0.1569D-12, 0.7293D-11,
     #  0.4330D-10, 0.1397D-09, 0.3345D-09, 0.4823D-09, 0.2118D-07,
     #  0.1189D-06, 0.3635D-06, 0.8253D-06, 0.1158D-05, 0.9902D-05,
     #  0.3158D-04, 0.6792D-04, 0.1184D-03, 0.1815D-03, 0.2548D-03,
     #  0.3369D-03, 0.4252D-03, 0.5186D-03, 0.1495D-02, 0.2288D-02,
     #  0.2862D-02, 0.3269D-02, 0.3558D-02, 0.3766D-02, 0.3914D-02,
     #  0.4020D-02, 0.4095D-02, 0.3882D-02, 0.3377D-02, 0.2991D-02,
     #  0.2703D-02, 0.2580D-02, 0.1839D-02, 0.1469D-02, 0.1086D-02,
     #  0.8801D-03, 0.7482D-03, 0.6992D-03, 0.2261D-03, 0.1353D-03,
     #  0.2217D-04, 0.d0/
c
      data (calcpts(j, 9), j=1,neta) /0.d0, 0.1509D-12, 0.7016D-11,
     #  0.4166D-10, 0.1344D-09, 0.3218D-09, 0.4636D-09, 0.2035D-07,
     #  0.1142D-06, 0.3489D-06, 0.7914D-06, 0.1111D-05, 0.9461D-05,
     #  0.3008D-04, 0.6453D-04, 0.1122D-03, 0.1716D-03, 0.2406D-03,
     #  0.3174D-03, 0.4000D-03, 0.4874D-03, 0.1394D-02, 0.2127D-02,
     #  0.2660D-02, 0.3038D-02, 0.3311D-02, 0.3506D-02, 0.3646D-02,
     #  0.3748D-02, 0.3820D-02, 0.3657D-02, 0.3196D-02, 0.2844D-02,
     #  0.2571D-02, 0.2460D-02, 0.1764D-02, 0.1415D-02, 0.1049D-02,
     #  0.8515D-03, 0.7264D-03, 0.6773D-03, 0.2231D-03, 0.1328D-03,
     #  0.2174D-04, 0.d0/
c
      data (calcpts(j,10), j=1,neta) /0.d0, 0.1441D-12, 0.6693D-11,
     #  0.3978D-10, 0.1282D-09, 0.3069D-09, 0.4423D-09, 0.1938D-07,
     #  0.1087D-06, 0.3317D-06, 0.7515D-06, 0.1054D-05, 0.8930D-05,
     #  0.2825D-04, 0.6027D-04, 0.1043D-03, 0.1588D-03, 0.2217D-03,
     #  0.2913D-03, 0.3657D-03, 0.4437D-03, 0.1233D-02, 0.1845D-02,
     #  0.2274D-02, 0.2570D-02, 0.2775D-02, 0.2918D-02, 0.3018D-02,
     #  0.3085D-02, 0.3134D-02, 0.2930D-02, 0.2574D-02, 0.2306D-02,
     #  0.2102D-02, 0.2018D-02, 0.1478D-02, 0.1200D-02, 0.9031D-03,
     #  0.7391D-03, 0.6339D-03, 0.5926D-03, 0.1992D-03, 0.1202D-03,
     #  0.2022D-04, 0.d0/
c
      data (calcpts(j,11), j=1,neta) /0.d0, 0.1434D-12, 0.6663D-11,
     #  0.3955D-10, 0.1276D-09, 0.3054D-09, 0.4402D-09, 0.1929D-07,
     #  0.1082D-06, 0.3299D-06, 0.7475D-06, 0.1048D-05, 0.8874D-05,
     #  0.2804D-04, 0.5983D-04, 0.1035D-03, 0.1574D-03, 0.2197D-03,
     #  0.2885D-03, 0.3621D-03, 0.4391D-03, 0.1215D-02, 0.1814D-02,
     #  0.2226D-02, 0.2508D-02, 0.2697D-02, 0.2825D-02, 0.2909D-02,
     #  0.2961D-02, 0.2994D-02, 0.2604D-02, 0.2208D-02, 0.1946D-02,
     #  0.1758D-02, 0.1681D-02, 0.1229D-02, 0.1005D-02, 0.7642D-03,
     #  0.6311D-03, 0.5433D-03, 0.5108D-03, 0.1779D-03, 0.1087D-03,
     #  0.1860D-04, 0.d0/
c
      data (calcpts(j,12), j=1,neta) /0.d0, 0.1433D-12, 0.6657D-11,
     #  0.3953D-10, 0.1275D-09, 0.3053D-09, 0.4401D-09, 0.1929D-07,
     #  0.1081D-06, 0.3297D-06, 0.7470D-06, 0.1048D-05, 0.8868D-05,
     #  0.2804D-04, 0.5979D-04, 0.1034D-03, 0.1574D-03, 0.2196D-03,
     #  0.2883D-03, 0.3619D-03, 0.4391D-03, 0.1216D-02, 0.1818D-02,
     #  0.2238D-02, 0.2525D-02, 0.2720D-02, 0.2855D-02, 0.2943D-02,
     #  0.3000D-02, 0.3036D-02, 0.2630D-02, 0.2171D-02, 0.1860D-02,
     #  0.1643D-02, 0.1555D-02, 0.1076D-02, 0.8619D-03, 0.6490D-03,
     #  0.5361D-03, 0.4630D-03, 0.4353D-03, 0.1560D-03, 0.9623D-04,
     #  0.1727D-04, 0.d0/
c
      data (calcpts(j,13), j=1,neta) /0.d0, 0.1401D-12, 0.6668D-11,
     #  0.3954D-10, 0.1275D-09, 0.3053D-09, 0.4398D-09, 0.1928D-07,
     #  0.1081D-06, 0.3296D-06, 0.7470D-06, 0.1048D-05, 0.8868D-05,
     #  0.2804D-04, 0.5979D-04, 0.1034D-03, 0.1574D-03, 0.2196D-03,
     #  0.2883D-03, 0.3621D-03, 0.4389D-03, 0.1217D-02, 0.1821D-02,
     #  0.2244D-02, 0.2535D-02, 0.2736D-02, 0.2876D-02, 0.2970D-02,
     #  0.3035D-02, 0.3074D-02, 0.2727D-02, 0.2277D-02, 0.1956D-02,
     #  0.1722D-02, 0.1625D-02, 0.1073D-02, 0.8265D-03, 0.5928D-03,
     #  0.4775D-03, 0.4067D-03, 0.3804D-03, 0.1358D-03, 0.8456D-04,
     #  0.1560D-04, 0.d0/
c
      data (calcpts(j,14), j=1,neta) /0.d0, 0.4279D-12, 0.7533D-11,
     #  0.4041D-10, 0.1273D-09, 0.3024D-09, 0.4428D-09, 0.1926D-07,
     #  0.1081D-06, 0.3296D-06, 0.7469D-06, 0.1048D-05, 0.8865D-05,
     #  0.2804D-04, 0.5978D-04, 0.1034D-03, 0.1574D-03, 0.2196D-03,
     #  0.2885D-03, 0.3621D-03, 0.4392D-03, 0.1218D-02, 0.1824D-02,
     #  0.2249D-02, 0.2541D-02, 0.2744D-02, 0.2886D-02, 0.2982D-02,
     #  0.3050D-02, 0.3091D-02, 0.2793D-02, 0.2369D-02, 0.2064D-02,
     #  0.1838D-02, 0.1744D-02, 0.1188D-02, 0.9171D-03, 0.6428D-03,
     #  0.5015D-03, 0.4140D-03, 0.3816D-03, 0.1146D-03, 0.7074D-04,
     #  0.1332D-04, 0.d0/
c
      data (calcpts(j,15), j=1,neta) /0.d0, 0.0000D+00, 0.8481D-11,
     #  0.1250D-10, 0.1173D-09, 0.3631D-09, 0.4731D-09, 0.1937D-07,
     #  0.1080D-06, 0.3296D-06, 0.7471D-06, 0.1048D-05, 0.8865D-05,
     #  0.2802D-04, 0.5976D-04, 0.1034D-03, 0.1574D-03, 0.2196D-03,
     #  0.2885D-03, 0.3619D-03, 0.4391D-03, 0.1218D-02, 0.1824D-02,
     #  0.2249D-02, 0.2543D-02, 0.2745D-02, 0.2888D-02, 0.2985D-02,
     #  0.3051D-02, 0.3095D-02, 0.2802D-02, 0.2385D-02, 0.2084D-02,
     #  0.1860D-02, 0.1769D-02, 0.1219D-02, 0.9522D-03, 0.6765D-03,
     #  0.5313D-03, 0.4398D-03, 0.4059D-03, 0.1124D-03, 0.6680D-04,
     #  0.1251D-04, 0.d0/
c
      data (aeta(j), j = 1,neta) /small, 0.1000d-02, 0.3000d-02,
     #  0.5000d-02, 0.7000d-02, 0.9000d-02, 0.1000d-01, 0.3000d-01, 
     #  0.5000d-01, 0.7000d-01, 0.9000d-01, 0.1000d+00, 0.2000d+00, 
     #  0.3000d+00, 0.4000d+00, 0.5000d+00, 0.6000d+00, 0.7000d+00, 
     #  0.8000d+00, 0.9000d+00, 0.1000d+01, 0.2000d+01, 0.3000d+01,
     #  0.4000d+01, 0.5000d+01, 0.6000d+01, 0.7000d+01, 0.8000d+01, 
     #  0.9000d+01, 0.1000d+02, 0.3000d+02, 0.5000d+02, 0.7000d+02,
     #  0.9000d+02, 0.1000d+03, 0.2000d+03, 0.3000d+03, 0.5000d+03,
     #  0.7000d+03, 0.9000d+03, 0.1000d+04, 0.5000d+04, 0.1000d+05,
     #  0.1000d+06, huge/
c
      data (axi(j), j = 1,nxi) /0.1000d-01, 0.3162d-01, 0.1000d+00,
     #  0.3162d+00, 0.1000d+01, 0.2500d+01, 0.3162d+01, 0.7500d+01, 
     #  0.1000d+02, 0.3162d+02, 0.1000d+03, 0.3162d+03, 0.1000d+04,
     #  0.5000d+04, 0.1000d+05/
c
c  here we have to choose the array elements that will go into the 
c  interpolation.
      call locate(aeta, neta, eta, ieta)
      call locate(axi, nxi, xi, ixi)
      if (ieta .le. 1) ieta = 1
      if (ieta .gt. (neta - 1)) ieta = neta - 1
      if (ixi .le. 1) ixi = 1
      if (ixi .gt. (nxi - 1)) ixi = nxi - 1
      y1 = calcpts(ieta,ixi)
      y2 = calcpts(ieta+1,ixi)
      y3 = calcpts(ieta+1,ixi+1)
      y4 = calcpts(ieta,ixi+1)
c interpolating between the points
      t = (eta - aeta(ieta))/(aeta(ieta + 1) - aeta(ieta))
      u = (xi - axi(ixi))/(axi(ixi + 1) - axi(ixi))
      h1f_LTq = (1.d0 - t)*(1.d0 - u)*y1 + t*(1.d0 - u)*y2 +
     #           t*u*y3 + (1.d0 - t)*u*y4

      return
      end

c     =========================================
      double precision function h1_LTq(eta,xi)
c     =========================================

c     eq (28) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subd1tq in the original code.
c     Gives h1_LTq for Q2 > 1.5 GeV2 (use h1f_LTq for Q2 < 1.5 GeV2)
c     Called sclqt in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /0.2418D-16, 0.9248D-16,
     #    0.3534D-15, 0.1349D-14, 0.5144D-14, 0.1956D-13, 0.7412D-13,
     #    0.2795D-12, 0.1046D-11, 0.3876D-11, 0.1417D-10, 0.5081D-10,
     #    0.1778D-09, 0.6021D-09, 0.1964D-08, 0.6116D-08, 0.1817D-07,
     #    0.5128D-07, 0.1377D-06, 0.3524D-06, 0.8631D-06, 0.2031D-05,
     #    0.4617D-05, 0.1017D-04, 0.2177D-04, 0.4545D-04, 0.9263D-04,
     #    0.1844D-03, 0.3577D-03, 0.6750D-03, 0.1232D-02, 0.2160D-02,
     #    0.3605D-02, 0.5666D-02, 0.8313D-02, 0.1131D-01, 0.1428D-01,
     #    0.1683D-01, 0.1868D-01, 0.1970D-01, 0.1988D-01, 0.1925D-01,
     #    0.1794D-01, 0.1616D-01, 0.1410D-01, 0.1198D-01, 0.9952D-02,
     #    0.8106D-02, 0.6494D-02, 0.5132D-02, 0.4007D-02, 0.3097D-02,
     #    0.2373D-02, 0.1806D-02, 0.1364D-02, 0.1025D-02, 0.7660D-03,
     #    0.5700D-03, 0.4222D-03, 0.3117D-03, 0.2294D-03, 0.1682D-03,
     #    0.1230D-03, 0.8970D-04, 0.6527D-04, 0.4739D-04, 0.3434D-04,
     #    0.2483D-04, 0.1791D-04, 0.1291D-04, 0.9285D-05, 0.6669D-05,
     #    0.4784D-05/

      data (calcpts(j, 2), j = 1,neta) /0.1123D-16, 0.4299D-16,
     #    0.1644D-15, 0.6287D-15, 0.2400D-14, 0.9147D-14, 0.3479D-13,
     #    0.1318D-12, 0.4970D-12, 0.1860D-11, 0.6894D-11, 0.2520D-10,
     #    0.9034D-10, 0.3161D-09, 0.1071D-08, 0.3488D-08, 0.1087D-07,
     #    0.3229D-07, 0.9114D-07, 0.2447D-06, 0.6258D-06, 0.1532D-05,
     #    0.3602D-05, 0.8169D-05, 0.1794D-04, 0.3830D-04, 0.7952D-04,
     #    0.1608D-03, 0.3164D-03, 0.6040D-03, 0.1114D-02, 0.1971D-02,
     #    0.3317D-02, 0.5253D-02, 0.7759D-02, 0.1063D-01, 0.1349D-01,
     #    0.1597D-01, 0.1781D-01, 0.1886D-01, 0.1908D-01, 0.1852D-01,
     #    0.1731D-01, 0.1561D-01, 0.1366D-01, 0.1163D-01, 0.9669D-02,
     #    0.7886D-02, 0.6324D-02, 0.5003D-02, 0.3910D-02, 0.3025D-02,
     #    0.2321D-02, 0.1767D-02, 0.1336D-02, 0.1004D-02, 0.7509D-03,
     #    0.5590D-03, 0.4145D-03, 0.3060D-03, 0.2253D-03, 0.1653D-03,
     #    0.1209D-03, 0.8825D-04, 0.6423D-04, 0.4665D-04, 0.3381D-04,
     #    0.2445D-04, 0.1765D-04, 0.1272D-04, 0.9156D-05, 0.6579D-05,
     #    0.4719D-05/

      data (calcpts(j, 3), j = 1,neta) /0.5218D-17, 0.1998D-16,
     #    0.7647D-16, 0.2925D-15, 0.1118D-14, 0.4268D-14, 0.1626D-13,
     #    0.6185D-13, 0.2343D-12, 0.8836D-12, 0.3308D-11, 0.1226D-10,
     #    0.4481D-10, 0.1607D-09, 0.5619D-09, 0.1904D-08, 0.6199D-08,
     #    0.1932D-07, 0.5739D-07, 0.1619D-06, 0.4344D-06, 0.1110D-05,
     #    0.2715D-05, 0.6374D-05, 0.1442D-04, 0.3158D-04, 0.6700D-04,
     #    0.1381D-03, 0.2762D-03, 0.5346D-03, 0.9981D-03, 0.1785D-02,
     #    0.3032D-02, 0.4842D-02, 0.7208D-02, 0.9939D-02, 0.1270D-01,
     #    0.1512D-01, 0.1694D-01, 0.1800D-01, 0.1828D-01, 0.1781D-01,
     #    0.1668D-01, 0.1509D-01, 0.1322D-01, 0.1127D-01, 0.9386D-02,
     #    0.7664D-02, 0.6155D-02, 0.4874D-02, 0.3813D-02, 0.2953D-02,
     #    0.2267D-02, 0.1726D-02, 0.1307D-02, 0.9832D-03, 0.7359D-03,
     #    0.5481D-03, 0.4065D-03, 0.3005D-03, 0.2212D-03, 0.1624D-03,
     #    0.1189D-03, 0.8678D-04, 0.6320D-04, 0.4592D-04, 0.3329D-04,
     #    0.2409D-04, 0.1740D-04, 0.1254D-04, 0.9027D-05, 0.6488D-05,
     #    0.4656D-05/

      data (calcpts(j, 4), j = 1,neta) /0.2424D-17, 0.9281D-17,
     #    0.3554D-16, 0.1360D-15, 0.5202D-15, 0.1988D-14, 0.7590D-14,
     #    0.2893D-13, 0.1100D-12, 0.4168D-12, 0.1572D-11, 0.5883D-11,
     #    0.2180D-10, 0.7967D-10, 0.2858D-09, 0.9992D-09, 0.3381D-08,
     #    0.1102D-07, 0.3435D-07, 0.1020D-06, 0.2876D-06, 0.7709D-06,
     #    0.1968D-05, 0.4806D-05, 0.1125D-04, 0.2538D-04, 0.5526D-04,
     #    0.1164D-03, 0.2373D-03, 0.4670D-03, 0.8841D-03, 0.1601D-02,
     #    0.2748D-02, 0.4434D-02, 0.6657D-02, 0.9254D-02, 0.1191D-01,
     #    0.1426D-01, 0.1607D-01, 0.1716D-01, 0.1749D-01, 0.1710D-01,
     #    0.1605D-01, 0.1455D-01, 0.1278D-01, 0.1091D-01, 0.9102D-02,
     #    0.7443D-02, 0.5985D-02, 0.4745D-02, 0.3717D-02, 0.2881D-02,
     #    0.2214D-02, 0.1688D-02, 0.1278D-02, 0.9624D-03, 0.7208D-03,
     #    0.5372D-03, 0.3987D-03, 0.2948D-03, 0.2172D-03, 0.1595D-03,
     #    0.1168D-03, 0.8532D-04, 0.6216D-04, 0.4518D-04, 0.3276D-04,
     #    0.2371D-04, 0.1713D-04, 0.1236D-04, 0.8898D-05, 0.6398D-05,
     #    0.4592D-05/

      data (calcpts(j, 5), j = 1,neta) /0.1125D-17, 0.4310D-17,
     #    0.1650D-16, 0.6320D-16, 0.2418D-15, 0.9251D-15, 0.3535D-14,
     #    0.1350D-13, 0.5145D-13, 0.1956D-12, 0.7412D-12, 0.2795D-11,
     #    0.1046D-10, 0.3878D-10, 0.1417D-09, 0.5081D-09, 0.1776D-08,
     #    0.6011D-08, 0.1959D-07, 0.6104D-07, 0.1810D-06, 0.5103D-06,
     #    0.1367D-05, 0.3486D-05, 0.8489D-05, 0.1981D-04, 0.4444D-04,
     #    0.9606D-04, 0.2001D-03, 0.4016D-03, 0.7731D-03, 0.1420D-02,
     #    0.2469D-02, 0.4028D-02, 0.6110D-02, 0.8570D-02, 0.1111D-01,
     #    0.1341D-01, 0.1520D-01, 0.1631D-01, 0.1670D-01, 0.1638D-01,
     #    0.1544D-01, 0.1402D-01, 0.1233D-01, 0.1055D-01, 0.8818D-02,
     #    0.7222D-02, 0.5816D-02, 0.4617D-02, 0.3619D-02, 0.2809D-02,
     #    0.2160D-02, 0.1649D-02, 0.1250D-02, 0.9416D-03, 0.7056D-03,
     #    0.5263D-03, 0.3909D-03, 0.2892D-03, 0.2132D-03, 0.1566D-03,
     #    0.1148D-03, 0.8385D-04, 0.6111D-04, 0.4444D-04, 0.3225D-04,
     #    0.2336D-04, 0.1688D-04, 0.1217D-04, 0.8769D-05, 0.6306D-05,
     #    0.4528D-05/

      data (calcpts(j, 6), j = 1,neta) /0.5224D-18, 0.2001D-17,
     #    0.7665D-17, 0.2936D-16, 0.1124D-15, 0.4301D-15, 0.1646D-14,
     #    0.6288D-14, 0.2400D-13, 0.9149D-13, 0.3479D-12, 0.1318D-11,
     #    0.4969D-11, 0.1860D-10, 0.6894D-10, 0.2519D-09, 0.9032D-09,
     #    0.3154D-08, 0.1068D-07, 0.3480D-07, 0.1084D-06, 0.3215D-06,
     #    0.9049D-06, 0.2420D-05, 0.6157D-05, 0.1495D-04, 0.3471D-04,
     #    0.7731D-04, 0.1653D-03, 0.3392D-03, 0.6657D-03, 0.1244D-02,
     #    0.2195D-02, 0.3627D-02, 0.5567D-02, 0.7890D-02, 0.1033D-01,
     #    0.1256D-01, 0.1432D-01, 0.1546D-01, 0.1592D-01, 0.1566D-01,
     #    0.1480D-01, 0.1348D-01, 0.1189D-01, 0.1020D-01, 0.8535D-02,
     #    0.7002D-02, 0.5646D-02, 0.4488D-02, 0.3524D-02, 0.2738D-02,
     #    0.2108D-02, 0.1610D-02, 0.1221D-02, 0.9207D-03, 0.6905D-03,
     #    0.5154D-03, 0.3830D-03, 0.2835D-03, 0.2091D-03, 0.1537D-03,
     #    0.1127D-03, 0.8240D-04, 0.6008D-04, 0.4371D-04, 0.3172D-04,
     #    0.2298D-04, 0.1662D-04, 0.1199D-04, 0.8640D-05, 0.6216D-05,
     #    0.4464D-05/

      data (calcpts(j, 7), j = 1,neta) /0.2426D-18, 0.9293D-18,
     #    0.3560D-17, 0.1363D-16, 0.5220D-16, 0.1998D-15, 0.7649D-15,
     #    0.2925D-14, 0.1118D-13, 0.4269D-13, 0.1628D-12, 0.6186D-12,
     #    0.2344D-11, 0.8837D-11, 0.3308D-10, 0.1226D-09, 0.4479D-09,
     #    0.1605D-08, 0.5606D-08, 0.1898D-07, 0.6182D-07, 0.1925D-06,
     #    0.5700D-06, 0.1602D-05, 0.4277D-05, 0.1085D-04, 0.2621D-04,
     #    0.6041D-04, 0.1331D-03, 0.2804D-03, 0.5631D-03, 0.1073D-02,
     #    0.1928D-02, 0.3234D-02, 0.5030D-02, 0.7214D-02, 0.9542D-02,
     #    0.1171D-01, 0.1346D-01, 0.1462D-01, 0.1512D-01, 0.1494D-01,
     #    0.1417D-01, 0.1295D-01, 0.1145D-01, 0.9839D-02, 0.8252D-02,
     #    0.6782D-02, 0.5476D-02, 0.4359D-02, 0.3428D-02, 0.2665D-02,
     #    0.2054D-02, 0.1571D-02, 0.1193D-02, 0.8998D-03, 0.6755D-03,
     #    0.5045D-03, 0.3752D-03, 0.2780D-03, 0.2050D-03, 0.1509D-03,
     #    0.1107D-03, 0.8093D-04, 0.5904D-04, 0.4298D-04, 0.3120D-04,
     #    0.2261D-04, 0.1635D-04, 0.1181D-04, 0.8511D-05, 0.6124D-05,
     #    0.4401D-05/

      data (calcpts(j, 8), j = 1,neta) /0.1126D-18, 0.4314D-18,
     #    0.1653D-17, 0.6330D-17, 0.2424D-16, 0.9284D-16, 0.3554D-15,
     #    0.1360D-14, 0.5202D-14, 0.1989D-13, 0.7591D-13, 0.2894D-12,
     #    0.1100D-11, 0.4169D-11, 0.1572D-10, 0.5882D-10, 0.2180D-09,
     #    0.7962D-09, 0.2850D-08, 0.9960D-08, 0.3371D-07, 0.1097D-06,
     #    0.3413D-06, 0.1010D-05, 0.2832D-05, 0.7536D-05, 0.1902D-04,
     #    0.4563D-04, 0.1041D-03, 0.2262D-03, 0.4664D-03, 0.9094D-03,
     #    0.1667D-02, 0.2847D-02, 0.4498D-02, 0.6543D-02, 0.8759D-02,
     #    0.1086D-01, 0.1259D-01, 0.1378D-01, 0.1432D-01, 0.1422D-01,
     #    0.1354D-01, 0.1241D-01, 0.1101D-01, 0.9482D-02, 0.7970D-02,
     #    0.6561D-02, 0.5307D-02, 0.4230D-02, 0.3330D-02, 0.2594D-02,
     #    0.2001D-02, 0.1532D-02, 0.1164D-02, 0.8790D-03, 0.6603D-03,
     #    0.4935D-03, 0.3674D-03, 0.2723D-03, 0.2010D-03, 0.1480D-03,
     #    0.1086D-03, 0.7947D-04, 0.5801D-04, 0.4224D-04, 0.3068D-04,
     #    0.2224D-04, 0.1610D-04, 0.1163D-04, 0.8382D-05, 0.6033D-05,
     #    0.4337D-05/

      data (calcpts(j, 9), j = 1,neta) /0.5227D-19, 0.2003D-18,
     #    0.7671D-18, 0.2938D-17, 0.1126D-16, 0.4311D-16, 0.1652D-15,
     #    0.6321D-15, 0.2419D-14, 0.9252D-14, 0.3537D-13, 0.1350D-12,
     #    0.5145D-12, 0.1956D-11, 0.7413D-11, 0.2794D-10, 0.1046D-09,
     #    0.3874D-09, 0.1415D-08, 0.5064D-08, 0.1770D-07, 0.5985D-07,
     #    0.1946D-06, 0.6045D-06, 0.1785D-05, 0.4993D-05, 0.1322D-04,
     #    0.3315D-04, 0.7875D-04, 0.1771D-03, 0.3768D-03, 0.7551D-03,
     #    0.1417D-02, 0.2472D-02, 0.3978D-02, 0.5880D-02, 0.7983D-02,
     #    0.1002D-01, 0.1173D-01, 0.1293D-01, 0.1353D-01, 0.1351D-01,
     #    0.1291D-01, 0.1188D-01, 0.1056D-01, 0.9123D-02, 0.7686D-02,
     #    0.6340D-02, 0.5138D-02, 0.4103D-02, 0.3234D-02, 0.2522D-02,
     #    0.1947D-02, 0.1492D-02, 0.1135D-02, 0.8582D-03, 0.6452D-03,
     #    0.4827D-03, 0.3594D-03, 0.2666D-03, 0.1969D-03, 0.1451D-03,
     #    0.1065D-03, 0.7800D-04, 0.5697D-04, 0.4149D-04, 0.3017D-04,
     #    0.2187D-04, 0.1584D-04, 0.1144D-04, 0.8253D-05, 0.5943D-05,
     #    0.4273D-05/

      data (calcpts(j,10), j = 1,neta) /0.2427D-19, 0.9297D-19,
     #    0.3561D-18, 0.1364D-17, 0.5227D-17, 0.2003D-16, 0.7668D-16,
     #    0.2937D-15, 0.1124D-14, 0.4302D-14, 0.1646D-13, 0.6290D-13,
     #    0.2401D-12, 0.9151D-12, 0.3479D-11, 0.1318D-10, 0.4970D-10,
     #    0.1860D-09, 0.6888D-09, 0.2511D-08, 0.8997D-08, 0.3141D-07,
     #    0.1062D-06, 0.3449D-06, 0.1069D-05, 0.3147D-05, 0.8768D-05,
     #    0.2307D-04, 0.5728D-04, 0.1342D-03, 0.2958D-03, 0.6119D-03,
     #    0.1181D-02, 0.2110D-02, 0.3471D-02, 0.5228D-02, 0.7215D-02,
     #    0.9179D-02, 0.1087D-01, 0.1209D-01, 0.1275D-01, 0.1279D-01,
     #    0.1229D-01, 0.1135D-01, 0.1012D-01, 0.8766D-02, 0.7403D-02,
     #    0.6120D-02, 0.4968D-02, 0.3974D-02, 0.3136D-02, 0.2449D-02,
     #    0.1895D-02, 0.1453D-02, 0.1107D-02, 0.8375D-03, 0.6302D-03,
     #    0.4718D-03, 0.3516D-03, 0.2610D-03, 0.1931D-03, 0.1422D-03,
     #    0.1045D-03, 0.7655D-04, 0.5592D-04, 0.4075D-04, 0.2964D-04,
     #    0.2151D-04, 0.1557D-04, 0.1126D-04, 0.8124D-05, 0.5852D-05,
     #    0.4209D-05/

      data (calcpts(j,11), j = 1,neta) /0.1127D-19, 0.4317D-19,
     #    0.1653D-18, 0.6334D-18, 0.2427D-17, 0.9297D-17, 0.3561D-16,
     #    0.1364D-15, 0.5223D-15, 0.2000D-14, 0.7653D-14, 0.2927D-13,
     #    0.1119D-12, 0.4270D-12, 0.1627D-11, 0.6187D-11, 0.2344D-10,
     #    0.8835D-10, 0.3306D-09, 0.1224D-08, 0.4463D-08, 0.1597D-07,
     #    0.5574D-07, 0.1881D-06, 0.6101D-06, 0.1885D-05, 0.5529D-05,
     #    0.1531D-04, 0.3992D-04, 0.9777D-04, 0.2246D-03, 0.4818D-03,
     #    0.9605D-03, 0.1767D-02, 0.2981D-02, 0.4590D-02, 0.6457D-02,
     #    0.8346D-02, 0.1001D-01, 0.1125D-01, 0.1196D-01, 0.1208D-01,
     #    0.1166D-01, 0.1081D-01, 0.9681D-02, 0.8409D-02, 0.7119D-02,
     #    0.5898D-02, 0.4799D-02, 0.3844D-02, 0.3040D-02, 0.2378D-02,
     #    0.1841D-02, 0.1414D-02, 0.1078D-02, 0.8166D-03, 0.6150D-03,
     #    0.4608D-03, 0.3438D-03, 0.2553D-03, 0.1890D-03, 0.1393D-03,
     #    0.1024D-03, 0.7509D-04, 0.5489D-04, 0.4002D-04, 0.2911D-04,
     #    0.2114D-04, 0.1531D-04, 0.1108D-04, 0.7995D-05, 0.5762D-05,
     #    0.4146D-05/

      data (calcpts(j,12), j = 1,neta) /0.5232D-20, 0.2004D-19,
     #    0.7680D-19, 0.2941D-18, 0.1127D-17, 0.4318D-17, 0.1654D-16,
     #    0.6336D-16, 0.2427D-15, 0.9293D-15, 0.3558D-14, 0.1361D-13,
     #    0.5208D-13, 0.1991D-12, 0.7597D-12, 0.2895D-11, 0.1101D-10,
     #    0.4170D-10, 0.1571D-09, 0.5877D-09, 0.2175D-08, 0.7928D-08,
     #    0.2835D-07, 0.9882D-07, 0.3330D-06, 0.1077D-05, 0.3317D-05,
     #    0.9666D-05, 0.2652D-04, 0.6827D-04, 0.1641D-03, 0.3672D-03,
     #    0.7601D-03, 0.1446D-02, 0.2514D-02, 0.3972D-02, 0.5714D-02,
     #    0.7524D-02, 0.9161D-02, 0.1042D-01, 0.1117D-01, 0.1137D-01,
     #    0.1104D-01, 0.1028D-01, 0.9240D-02, 0.8052D-02, 0.6837D-02,
     #    0.5678D-02, 0.4629D-02, 0.3716D-02, 0.2943D-02, 0.2306D-02,
     #    0.1788D-02, 0.1375D-02, 0.1049D-02, 0.7957D-03, 0.5998D-03,
     #    0.4500D-03, 0.3359D-03, 0.2498D-03, 0.1850D-03, 0.1365D-03,
     #    0.1004D-03, 0.7362D-04, 0.5385D-04, 0.3929D-04, 0.2861D-04,
     #    0.2078D-04, 0.1506D-04, 0.1089D-04, 0.7866D-05, 0.5670D-05,
     #    0.4082D-05/

      data (calcpts(j,13), j = 1,neta) /0.2432D-20, 0.9314D-20,
     #    0.3569D-19, 0.1367D-18, 0.5238D-18, 0.2007D-17, 0.7688D-17,
     #    0.2945D-16, 0.1128D-15, 0.4320D-15, 0.1654D-14, 0.6333D-14,
     #    0.2424D-13, 0.9270D-13, 0.3543D-12, 0.1352D-11, 0.5153D-11,
     #    0.1959D-10, 0.7419D-10, 0.2795D-09, 0.1045D-08, 0.3861D-08,
     #    0.1408D-07, 0.5031D-07, 0.1750D-06, 0.5883D-06, 0.1896D-05,
     #    0.5805D-05, 0.1678D-04, 0.4548D-04, 0.1150D-03, 0.2696D-03,
     #    0.5826D-03, 0.1153D-02, 0.2075D-02, 0.3379D-02, 0.4991D-02,
     #    0.6716D-02, 0.8320D-02, 0.9593D-02, 0.1039D-01, 0.1066D-01,
     #    0.1041D-01, 0.9750D-02, 0.8799D-02, 0.7695D-02, 0.6554D-02,
     #    0.5457D-02, 0.4459D-02, 0.3588D-02, 0.2847D-02, 0.2234D-02,
     #    0.1734D-02, 0.1336D-02, 0.1021D-02, 0.7749D-03, 0.5849D-03,
     #    0.4391D-03, 0.3281D-03, 0.2441D-03, 0.1809D-03, 0.1336D-03,
     #    0.9832D-04, 0.7217D-04, 0.5282D-04, 0.3855D-04, 0.2808D-04,
     #    0.2040D-04, 0.1480D-04, 0.1071D-04, 0.7737D-05, 0.5580D-05,
     #    0.4019D-05/

      data (calcpts(j,14), j = 1,neta) /0.1131D-20, 0.4332D-20,
     #    0.1661D-19, 0.6360D-19, 0.2436D-18, 0.9334D-18, 0.3576D-17,
     #    0.1370D-16, 0.5248D-16, 0.2010D-15, 0.7700D-15, 0.2948D-14,
     #    0.1129D-13, 0.4318D-13, 0.1652D-12, 0.6312D-12, 0.2409D-11,
     #    0.9181D-11, 0.3489D-10, 0.1321D-09, 0.4977D-09, 0.1860D-08,
     #    0.6866D-08, 0.2501D-07, 0.8922D-07, 0.3097D-06, 0.1037D-05,
     #    0.3326D-05, 0.1010D-04, 0.2886D-04, 0.7695D-04, 0.1899D-03,
     #    0.4307D-03, 0.8910D-03, 0.1670D-02, 0.2820D-02, 0.4293D-02,
     #    0.5926D-02, 0.7491D-02, 0.8774D-02, 0.9617D-02, 0.9952D-02,
     #    0.9792D-02, 0.9219D-02, 0.8360D-02, 0.7339D-02, 0.6272D-02,
     #    0.5238D-02, 0.4292D-02, 0.3459D-02, 0.2751D-02, 0.2162D-02,
     #    0.1682D-02, 0.1296D-02, 0.9921D-03, 0.7541D-03, 0.5697D-03,
     #    0.4281D-03, 0.3203D-03, 0.2384D-03, 0.1769D-03, 0.1307D-03,
     #    0.9627D-04, 0.7069D-04, 0.5178D-04, 0.3781D-04, 0.2755D-04,
     #    0.2004D-04, 0.1454D-04, 0.1053D-04, 0.7608D-05, 0.5489D-05,
     #    0.3954D-05/

      data (calcpts(j,15), j = 1,neta) /0.5274D-21, 0.2020D-20,
     #    0.7740D-20, 0.2965D-19, 0.1136D-18, 0.4353D-18, 0.1668D-17,
     #    0.6389D-17, 0.2448D-16, 0.9377D-16, 0.3591D-15, 0.1376D-14,
     #    0.5267D-14, 0.2016D-13, 0.7716D-13, 0.2951D-12, 0.1128D-11,
     #    0.4303D-11, 0.1640D-10, 0.6230D-10, 0.2358D-09, 0.8878D-09,
     #    0.3311D-08, 0.1223D-07, 0.4447D-07, 0.1583D-06, 0.5478D-06,
     #    0.1825D-05, 0.5810D-05, 0.1746D-04, 0.4913D-04, 0.1280D-03,
     #    0.3062D-03, 0.6659D-03, 0.1307D-02, 0.2299D-02, 0.3630D-02,
     #    0.5162D-02, 0.6679D-02, 0.7965D-02, 0.8849D-02, 0.9251D-02,
     #    0.9173D-02, 0.8691D-02, 0.7920D-02, 0.6984D-02, 0.5990D-02,
     #    0.5018D-02, 0.4122D-02, 0.3330D-02, 0.2654D-02, 0.2090D-02,
     #    0.1628D-02, 0.1257D-02, 0.9634D-03, 0.7332D-03, 0.5546D-03,
     #    0.4172D-03, 0.3123D-03, 0.2328D-03, 0.1728D-03, 0.1278D-03,
     #    0.9422D-04, 0.6924D-04, 0.5073D-04, 0.3708D-04, 0.2703D-04,
     #    0.1967D-04, 0.1428D-04, 0.1034D-04, 0.7479D-05, 0.5399D-05,
     #    0.3889D-05/

      data (calcpts(j,16), j = 1,neta) /0.2473D-21, 0.9471D-21,
     #    0.3629D-20, 0.1390D-19, 0.5327D-19, 0.2040D-18, 0.7818D-18,
     #    0.2995D-17, 0.1148D-16, 0.4397D-16, 0.1685D-15, 0.6450D-15,
     #    0.2471D-14, 0.9459D-14, 0.3621D-13, 0.1386D-12, 0.5300D-12,
     #    0.2025D-11, 0.7727D-11, 0.2943D-10, 0.1118D-09, 0.4230D-09,
     #    0.1591D-08, 0.5928D-08, 0.2187D-07, 0.7937D-07, 0.2817D-06,
     #    0.9701D-06, 0.3212D-05, 0.1012D-04, 0.2997D-04, 0.8255D-04,
     #    0.2088D-03, 0.4799D-03, 0.9918D-03, 0.1830D-02, 0.3011D-02,
     #    0.4431D-02, 0.5892D-02, 0.7172D-02, 0.8091D-02, 0.8556D-02,
     #    0.8559D-02, 0.8166D-02, 0.7484D-02, 0.6629D-02, 0.5708D-02,
     #    0.4797D-02, 0.3953D-02, 0.3202D-02, 0.2558D-02, 0.2018D-02,
     #    0.1575D-02, 0.1218D-02, 0.9348D-03, 0.7124D-03, 0.5396D-03,
     #    0.4063D-03, 0.3045D-03, 0.2271D-03, 0.1688D-03, 0.1249D-03,
     #    0.9216D-04, 0.6777D-04, 0.4969D-04, 0.3635D-04, 0.2652D-04,
     #    0.1931D-04, 0.1402D-04, 0.1016D-04, 0.7350D-05, 0.5307D-05,
     #    0.3826D-05/

      data (calcpts(j,17), j = 1,neta) /0.1173D-21, 0.4490D-21,
     #    0.1721D-20, 0.6589D-20, 0.2525D-19, 0.9674D-19, 0.3706D-18,
     #    0.1420D-17, 0.5441D-17, 0.2084D-16, 0.7985D-16, 0.3059D-15,
     #    0.1172D-14, 0.4486D-14, 0.1718D-13, 0.6576D-13, 0.2515D-12,
     #    0.9621D-12, 0.3677D-11, 0.1403D-10, 0.5340D-10, 0.2028D-09,
     #    0.7668D-09, 0.2877D-08, 0.1072D-07, 0.3948D-07, 0.1429D-06,
     #    0.5049D-06, 0.1728D-05, 0.5670D-05, 0.1761D-04, 0.5118D-04,
     #    0.1370D-03, 0.3338D-03, 0.7298D-03, 0.1420D-02, 0.2446D-02,
     #    0.3744D-02, 0.5136D-02, 0.6400D-02, 0.7347D-02, 0.7871D-02,
     #    0.7950D-02, 0.7644D-02, 0.7049D-02, 0.6275D-02, 0.5426D-02,
     #    0.4578D-02, 0.3783D-02, 0.3074D-02, 0.2460D-02, 0.1946D-02,
     #    0.1521D-02, 0.1179D-02, 0.9061D-03, 0.6915D-03, 0.5244D-03,
     #    0.3954D-03, 0.2965D-03, 0.2215D-03, 0.1647D-03, 0.1220D-03,
     #    0.9011D-04, 0.6632D-04, 0.4866D-04, 0.3561D-04, 0.2600D-04,
     #    0.1893D-04, 0.1376D-04, 0.9977D-05, 0.7221D-05, 0.5217D-05,
     #    0.3762D-05/

      data (calcpts(j,18), j = 1,neta) /0.5694D-22, 0.2178D-21,
     #    0.8340D-21, 0.3197D-20, 0.1224D-19, 0.4692D-19, 0.1797D-18,
     #    0.6886D-18, 0.2639D-17, 0.1011D-16, 0.3873D-16, 0.1484D-15,
     #    0.5682D-15, 0.2177D-14, 0.8335D-14, 0.3192D-13, 0.1222D-12,
     #    0.4674D-12, 0.1787D-11, 0.6827D-11, 0.2604D-10, 0.9911D-10,
     #    0.3760D-09, 0.1421D-08, 0.5325D-08, 0.1981D-07, 0.7272D-07,
     #    0.2622D-06, 0.9210D-06, 0.3125D-05, 0.1012D-04, 0.3086D-04,
     #    0.8726D-04, 0.2252D-03, 0.5222D-03, 0.1074D-02, 0.1948D-02,
     #    0.3114D-02, 0.4422D-02, 0.5658D-02, 0.6624D-02, 0.7197D-02,
     #    0.7350D-02, 0.7127D-02, 0.6615D-02, 0.5923D-02, 0.5145D-02,
     #    0.4359D-02, 0.3615D-02, 0.2946D-02, 0.2364D-02, 0.1873D-02,
     #    0.1468D-02, 0.1140D-02, 0.8775D-03, 0.6706D-03, 0.5093D-03,
     #    0.3844D-03, 0.2888D-03, 0.2159D-03, 0.1607D-03, 0.1192D-03,
     #    0.8805D-04, 0.6485D-04, 0.4762D-04, 0.3488D-04, 0.2547D-04,
     #    0.1857D-04, 0.1350D-04, 0.9792D-05, 0.7092D-05, 0.5126D-05,
     #    0.3699D-05/

      data (calcpts(j,19), j = 1,neta) /0.2892D-22, 0.1104D-21,
     #    0.4228D-21, 0.1620D-20, 0.6209D-20, 0.2379D-19, 0.9114D-19,
     #    0.3492D-18, 0.1338D-17, 0.5126D-17, 0.1964D-16, 0.7522D-16,
     #    0.2882D-15, 0.1104D-14, 0.4228D-14, 0.1618D-13, 0.6200D-13,
     #    0.2373D-12, 0.9077D-12, 0.3470D-11, 0.1325D-10, 0.5052D-10,
     #    0.1922D-09, 0.7287D-09, 0.2744D-08, 0.1028D-07, 0.3815D-07,
     #    0.1394D-06, 0.4995D-06, 0.1739D-05, 0.5822D-05, 0.1850D-04,
     #    0.5489D-04, 0.1494D-03, 0.3666D-03, 0.7981D-03, 0.1525D-02,
     #    0.2552D-02, 0.3762D-02, 0.4955D-02, 0.5926D-02, 0.6543D-02,
     #    0.6762D-02, 0.6616D-02, 0.6188D-02, 0.5574D-02, 0.4866D-02,
     #    0.4140D-02, 0.3447D-02, 0.2817D-02, 0.2268D-02, 0.1802D-02,
     #    0.1415D-02, 0.1101D-02, 0.8490D-03, 0.6498D-03, 0.4941D-03,
     #    0.3735D-03, 0.2810D-03, 0.2103D-03, 0.1566D-03, 0.1163D-03,
     #    0.8600D-04, 0.6339D-04, 0.4659D-04, 0.3414D-04, 0.2496D-04,
     #    0.1820D-04, 0.1324D-04, 0.9609D-05, 0.6963D-05, 0.5036D-05,
     #    0.3635D-05/

      data (calcpts(j,20), j = 1,neta) /0.1592D-22, 0.6060D-22,
     #    0.2321D-21, 0.8892D-21, 0.3408D-20, 0.1305D-19, 0.5001D-19,
     #    0.1916D-18, 0.7341D-18, 0.2813D-17, 0.1078D-16, 0.4128D-16,
     #    0.1581D-15, 0.6058D-15, 0.2321D-14, 0.8889D-14, 0.3404D-13,
     #    0.1303D-12, 0.4986D-12, 0.1907D-11, 0.7287D-11, 0.2781D-10,
     #    0.1060D-09, 0.4028D-09, 0.1524D-08, 0.5727D-08, 0.2139D-07,
     #    0.7892D-07, 0.2864D-06, 0.1015D-05, 0.3480D-05, 0.1140D-04,
     #    0.3512D-04, 0.9989D-04, 0.2573D-03, 0.5892D-03, 0.1183D-02,
     #    0.2070D-02, 0.3171D-02, 0.4304D-02, 0.5265D-02, 0.5913D-02,
     #    0.6189D-02, 0.6116D-02, 0.5766D-02, 0.5228D-02, 0.4590D-02,
     #    0.3923D-02, 0.3279D-02, 0.2690D-02, 0.2172D-02, 0.1729D-02,
     #    0.1362D-02, 0.1062D-02, 0.8204D-03, 0.6291D-03, 0.4791D-03,
     #    0.3627D-03, 0.2730D-03, 0.2046D-03, 0.1526D-03, 0.1134D-03,
     #    0.8394D-04, 0.6194D-04, 0.4556D-04, 0.3341D-04, 0.2443D-04,
     #    0.1782D-04, 0.1298D-04, 0.9426D-05, 0.6834D-05, 0.4944D-05,
     #    0.3572D-05/

      data (calcpts(j,21), j = 1,neta) /0.9878D-23, 0.3747D-22,
     #    0.1434D-21, 0.5498D-21, 0.2108D-20, 0.8071D-20, 0.3093D-19,
     #    0.1185D-18, 0.4539D-18, 0.1740D-17, 0.6663D-17, 0.2553D-16,
     #    0.9780D-16, 0.3747D-15, 0.1435D-14, 0.5498D-14, 0.2105D-13,
     #    0.8060D-13, 0.3086D-12, 0.1180D-11, 0.4512D-11, 0.1724D-10,
     #    0.6569D-10, 0.2499D-09, 0.9476D-09, 0.3569D-08, 0.1337D-07,
     #    0.4960D-07, 0.1814D-06, 0.6490D-06, 0.2256D-05, 0.7524D-05,
     #    0.2373D-04, 0.6951D-04, 0.1854D-03, 0.4410D-03, 0.9218D-03,
     #    0.1677D-02, 0.2660D-02, 0.3717D-02, 0.4652D-02, 0.5315D-02,
     #    0.5637D-02, 0.5630D-02, 0.5352D-02, 0.4886D-02, 0.4316D-02,
     #    0.3706D-02, 0.3113D-02, 0.2562D-02, 0.2076D-02, 0.1658D-02,
     #    0.1309D-02, 0.1023D-02, 0.7917D-03, 0.6083D-03, 0.4640D-03,
     #    0.3518D-03, 0.2652D-03, 0.1989D-03, 0.1486D-03, 0.1105D-03,
     #    0.8189D-04, 0.6046D-04, 0.4451D-04, 0.3267D-04, 0.2391D-04,
     #    0.1746D-04, 0.1272D-04, 0.9243D-05, 0.6705D-05, 0.4854D-05,
     #    0.3507D-05/

      data (calcpts(j,22), j = 1,neta) /0.7062D-23, 0.2674D-22,
     #    0.1023D-21, 0.3922D-21, 0.1503D-20, 0.5758D-20, 0.2206D-19,
     #    0.8454D-19, 0.3239D-18, 0.1241D-17, 0.4755D-17, 0.1821D-16,
     #    0.6978D-16, 0.2673D-15, 0.1024D-14, 0.3923D-14, 0.1501D-13,
     #    0.5751D-13, 0.2202D-12, 0.8422D-12, 0.3221D-11, 0.1230D-10,
     #    0.4690D-10, 0.1785D-09, 0.6773D-09, 0.2553D-08, 0.9576D-08,
     #    0.3558D-07, 0.1304D-06, 0.4683D-06, 0.1637D-05, 0.5496D-05,
     #    0.1751D-04, 0.5196D-04, 0.1410D-03, 0.3428D-03, 0.7349D-03,
     #    0.1374D-02, 0.2240D-02, 0.3207D-02, 0.4098D-02, 0.4761D-02,
     #    0.5115D-02, 0.5162D-02, 0.4949D-02, 0.4551D-02, 0.4044D-02,
     #    0.3494D-02, 0.2946D-02, 0.2436D-02, 0.1980D-02, 0.1587D-02,
     #    0.1256D-02, 0.9835D-03, 0.7632D-03, 0.5874D-03, 0.4490D-03,
     #    0.3408D-03, 0.2574D-03, 0.1933D-03, 0.1446D-03, 0.1076D-03,
     #    0.7983D-04, 0.5901D-04, 0.4347D-04, 0.3194D-04, 0.2339D-04,
     #    0.1708D-04, 0.1246D-04, 0.9060D-05, 0.6576D-05, 0.4763D-05,
     #    0.3444D-05/

      data (calcpts(j,23), j = 1,neta) /0.5736D-23, 0.2175D-22,
     #    0.8327D-22, 0.3192D-21, 0.1223D-20, 0.4686D-20, 0.1796D-19,
     #    0.6879D-19, 0.2635D-18, 0.1010D-17, 0.3869D-17, 0.1482D-16,
     #    0.5678D-16, 0.2175D-15, 0.8331D-15, 0.3191D-14, 0.1222D-13,
     #    0.4680D-13, 0.1791D-12, 0.6852D-12, 0.2620D-11, 0.1001D-10,
     #    0.3816D-10, 0.1452D-09, 0.5510D-09, 0.2081D-08, 0.7790D-08,
     #    0.2894D-07, 0.1060D-06, 0.3809D-06, 0.1330D-05, 0.4469D-05,
     #    0.1424D-04, 0.4233D-04, 0.1152D-03, 0.2819D-03, 0.6101D-03,
     #    0.1156D-02, 0.1914D-02, 0.2787D-02, 0.3618D-02, 0.4260D-02,
     #    0.4631D-02, 0.4718D-02, 0.4562D-02, 0.4226D-02, 0.3779D-02,
     #    0.3282D-02, 0.2781D-02, 0.2310D-02, 0.1884D-02, 0.1515D-02,
     #    0.1203D-02, 0.9446D-03, 0.7346D-03, 0.5665D-03, 0.4338D-03,
     #    0.3300D-03, 0.2495D-03, 0.1876D-03, 0.1405D-03, 0.1047D-03,
     #    0.7777D-04, 0.5754D-04, 0.4244D-04, 0.3120D-04, 0.2288D-04,
     #    0.1672D-04, 0.1220D-04, 0.8877D-05, 0.6446D-05, 0.4672D-05,
     #    0.3380D-05/

      data (calcpts(j,24), j = 1,neta) /0.5089D-23, 0.1944D-22,
     #    0.7445D-22, 0.2853D-21, 0.1093D-20, 0.4188D-20, 0.1605D-19,
     #    0.6147D-19, 0.2355D-18, 0.9023D-18, 0.3458D-17, 0.1325D-16,
     #    0.5074D-16, 0.1944D-15, 0.7446D-15, 0.2851D-14, 0.1092D-13,
     #    0.4182D-13, 0.1601D-12, 0.6123D-12, 0.2342D-11, 0.8940D-11,
     #    0.3409D-10, 0.1297D-09, 0.4920D-09, 0.1857D-08, 0.6951D-08,
     #    0.2581D-07, 0.9449D-07, 0.3390D-06, 0.1182D-05, 0.3962D-05,
     #    0.1259D-04, 0.3729D-04, 0.1011D-03, 0.2465D-03, 0.5325D-03,
     #    0.1010D-02, 0.1679D-02, 0.2462D-02, 0.3223D-02, 0.3828D-02,
     #    0.4196D-02, 0.4308D-02, 0.4196D-02, 0.3912D-02, 0.3521D-02,
     #    0.3075D-02, 0.2619D-02, 0.2184D-02, 0.1790D-02, 0.1444D-02,
     #    0.1150D-02, 0.9055D-03, 0.7061D-03, 0.5459D-03, 0.4188D-03,
     #    0.3191D-03, 0.2416D-03, 0.1821D-03, 0.1365D-03, 0.1019D-03,
     #    0.7572D-04, 0.5609D-04, 0.4140D-04, 0.3047D-04, 0.2235D-04,
     #    0.1635D-04, 0.1194D-04, 0.8694D-05, 0.6317D-05, 0.4581D-05,
     #    0.3317D-05/

      data (calcpts(j,25), j = 1,neta) /0.4752D-23, 0.1836D-22,
     #    0.7038D-22, 0.2695D-21, 0.1032D-20, 0.3957D-20, 0.1516D-19,
     #    0.5808D-19, 0.2225D-18, 0.8525D-18, 0.3266D-17, 0.1251D-16,
     #    0.4794D-16, 0.1836D-15, 0.7035D-15, 0.2694D-14, 0.1032D-13,
     #    0.3951D-13, 0.1512D-12, 0.5784D-12, 0.2211D-11, 0.8445D-11,
     #    0.3221D-10, 0.1225D-09, 0.4647D-09, 0.1753D-08, 0.6560D-08,
     #    0.2435D-07, 0.8906D-07, 0.3190D-06, 0.1111D-05, 0.3716D-05,
     #    0.1177D-04, 0.3473D-04, 0.9371D-04, 0.2271D-03, 0.4874D-03,
     #    0.9189D-03, 0.1521D-02, 0.2228D-02, 0.2918D-02, 0.3474D-02,
     #    0.3820D-02, 0.3941D-02, 0.3857D-02, 0.3616D-02, 0.3271D-02,
     #    0.2874D-02, 0.2460D-02, 0.2061D-02, 0.1697D-02, 0.1374D-02,
     #    0.1098D-02, 0.8669D-03, 0.6777D-03, 0.5250D-03, 0.4036D-03,
     #    0.3082D-03, 0.2339D-03, 0.1764D-03, 0.1325D-03, 0.9899D-04,
     #    0.7366D-04, 0.5461D-04, 0.4037D-04, 0.2973D-04, 0.2183D-04,
     #    0.1599D-04, 0.1168D-04, 0.8510D-05, 0.6187D-05, 0.4491D-05,
     #    0.3252D-05/

      data (calcpts(j,26), j = 1,neta) /0.4554D-23, 0.1785D-22,
     #    0.6852D-22, 0.2624D-21, 0.1004D-20, 0.3849D-20, 0.1475D-19,
     #    0.5651D-19, 0.2165D-18, 0.8293D-18, 0.3177D-17, 0.1217D-16,
     #    0.4664D-16, 0.1787D-15, 0.6843D-15, 0.2621D-14, 0.1004D-13,
     #    0.3843D-13, 0.1471D-12, 0.5628D-12, 0.2151D-11, 0.8216D-11,
     #    0.3132D-10, 0.1192D-09, 0.4520D-09, 0.1705D-08, 0.6378D-08,
     #    0.2366D-07, 0.8651D-07, 0.3097D-06, 0.1077D-05, 0.3598D-05,
     #    0.1137D-04, 0.3346D-04, 0.8996D-04, 0.2169D-03, 0.4628D-03,
     #    0.8664D-03, 0.1424D-02, 0.2072D-02, 0.2699D-02, 0.3202D-02,
     #    0.3516D-02, 0.3627D-02, 0.3555D-02, 0.3344D-02, 0.3038D-02,
     #    0.2681D-02, 0.2306D-02, 0.1941D-02, 0.1603D-02, 0.1304D-02,
     #    0.1045D-02, 0.8282D-03, 0.6494D-03, 0.5043D-03, 0.3887D-03,
     #    0.2973D-03, 0.2261D-03, 0.1709D-03, 0.1284D-03, 0.9611D-04,
     #    0.7161D-04, 0.5316D-04, 0.3932D-04, 0.2899D-04, 0.2132D-04,
     #    0.1562D-04, 0.1142D-04, 0.8327D-05, 0.6058D-05, 0.4400D-05,
     #    0.3189D-05/

      data (calcpts(j,27), j = 1,neta) /0.4428D-23, 0.1761D-22,
     #    0.6771D-22, 0.2590D-21, 0.9912D-21, 0.3800D-20, 0.1455D-19,
     #    0.5577D-19, 0.2136D-18, 0.8187D-18, 0.3136D-17, 0.1202D-16,
     #    0.4603D-16, 0.1764D-15, 0.6754D-15, 0.2587D-14, 0.9908D-14,
     #    0.3794D-13, 0.1452D-12, 0.5555D-12, 0.2124D-11, 0.8109D-11,
     #    0.3092D-10, 0.1176D-09, 0.4459D-09, 0.1683D-08, 0.6292D-08,
     #    0.2334D-07, 0.8531D-07, 0.3054D-06, 0.1062D-05, 0.3543D-05,
     #    0.1119D-04, 0.3286D-04, 0.8811D-04, 0.2118D-03, 0.4500D-03,
     #    0.8382D-03, 0.1369D-02, 0.1977D-02, 0.2558D-02, 0.3014D-02,
     #    0.3288D-02, 0.3373D-02, 0.3299D-02, 0.3102D-02, 0.2821D-02,
     #    0.2498D-02, 0.2157D-02, 0.1822D-02, 0.1512D-02, 0.1234D-02,
     #    0.9936D-03, 0.7897D-03, 0.6210D-03, 0.4838D-03, 0.3737D-03,
     #    0.2865D-03, 0.2181D-03, 0.1652D-03, 0.1244D-03, 0.9323D-04,
     #    0.6956D-04, 0.5171D-04, 0.3828D-04, 0.2826D-04, 0.2079D-04,
     #    0.1525D-04, 0.1116D-04, 0.8144D-05, 0.5930D-05, 0.4309D-05,
     #    0.3125D-05/

      data (calcpts(j,28), j = 1,neta) /0.4341D-23, 0.1749D-22,
     #    0.6735D-22, 0.2576D-21, 0.9849D-21, 0.3777D-20, 0.1447D-19,
     #    0.5542D-19, 0.2124D-18, 0.8136D-18, 0.3117D-17, 0.1194D-16,
     #    0.4575D-16, 0.1752D-15, 0.6714D-15, 0.2571D-14, 0.9848D-14,
     #    0.3771D-13, 0.1443D-12, 0.5520D-12, 0.2110D-11, 0.8059D-11,
     #    0.3072D-10, 0.1169D-09, 0.4432D-09, 0.1672D-08, 0.6254D-08,
     #    0.2319D-07, 0.8475D-07, 0.3033D-06, 0.1054D-05, 0.3516D-05,
     #    0.1110D-04, 0.3256D-04, 0.8724D-04, 0.2094D-03, 0.4437D-03,
     #    0.8241D-03, 0.1341D-02, 0.1926D-02, 0.2476D-02, 0.2895D-02,
     #    0.3132D-02, 0.3189D-02, 0.3096D-02, 0.2897D-02, 0.2631D-02,
     #    0.2329D-02, 0.2016D-02, 0.1710D-02, 0.1424D-02, 0.1167D-02,
     #    0.9424D-03, 0.7516D-03, 0.5929D-03, 0.4632D-03, 0.3587D-03,
     #    0.2756D-03, 0.2103D-03, 0.1596D-03, 0.1204D-03, 0.9035D-04,
     #    0.6752D-04, 0.5024D-04, 0.3725D-04, 0.2752D-04, 0.2026D-04,
     #    0.1488D-04, 0.1090D-04, 0.7960D-05, 0.5800D-05, 0.4218D-05,
     #    0.3062D-05/

      data (calcpts(j,29), j = 1,neta) /0.4268D-23, 0.1743D-22,
     #    0.6717D-22, 0.2568D-21, 0.9821D-21, 0.3767D-20, 0.1443D-19,
     #    0.5527D-19, 0.2118D-18, 0.8114D-18, 0.3108D-17, 0.1191D-16,
     #    0.4561D-16, 0.1748D-15, 0.6694D-15, 0.2563D-14, 0.9819D-14,
     #    0.3759D-13, 0.1439D-12, 0.5505D-12, 0.2105D-11, 0.8036D-11,
     #    0.3065D-10, 0.1166D-09, 0.4419D-09, 0.1668D-08, 0.6236D-08,
     #    0.2312D-07, 0.8450D-07, 0.3024D-06, 0.1051D-05, 0.3504D-05,
     #    0.1106D-04, 0.3243D-04, 0.8684D-04, 0.2082D-03, 0.4409D-03,
     #    0.8175D-03, 0.1328D-02, 0.1902D-02, 0.2436D-02, 0.2834D-02,
     #    0.3042D-02, 0.3069D-02, 0.2950D-02, 0.2738D-02, 0.2472D-02,
     #    0.2181D-02, 0.1887D-02, 0.1603D-02, 0.1339D-02, 0.1101D-02,
     #    0.8922D-03, 0.7140D-03, 0.5650D-03, 0.4426D-03, 0.3436D-03,
     #    0.2648D-03, 0.2025D-03, 0.1539D-03, 0.1163D-03, 0.8747D-04,
     #    0.6546D-04, 0.4878D-04, 0.3621D-04, 0.2678D-04, 0.1974D-04,
     #    0.1451D-04, 0.1064D-04, 0.7777D-05, 0.5671D-05, 0.4128D-05,
     #    0.2997D-05/

      data (calcpts(j,30), j = 1,neta) /0.4237D-23, 0.1740D-22,
     #    0.6711D-22, 0.2565D-21, 0.9807D-21, 0.3762D-20, 0.1441D-19,
     #    0.5520D-19, 0.2115D-18, 0.8103D-18, 0.3105D-17, 0.1189D-16,
     #    0.4556D-16, 0.1746D-15, 0.6686D-15, 0.2561D-14, 0.9807D-14,
     #    0.3755D-13, 0.1437D-12, 0.5498D-12, 0.2102D-11, 0.8025D-11,
     #    0.3060D-10, 0.1164D-09, 0.4413D-09, 0.1665D-08, 0.6227D-08,
     #    0.2309D-07, 0.8437D-07, 0.3020D-06, 0.1049D-05, 0.3498D-05,
     #    0.1104D-04, 0.3237D-04, 0.8664D-04, 0.2078D-03, 0.4397D-03,
     #    0.8148D-03, 0.1323D-02, 0.1893D-02, 0.2421D-02, 0.2808D-02,
     #    0.3002D-02, 0.3006D-02, 0.2862D-02, 0.2626D-02, 0.2349D-02,
     #    0.2058D-02, 0.1775D-02, 0.1506D-02, 0.1259D-02, 0.1037D-02,
     #    0.8433D-03, 0.6771D-03, 0.5374D-03, 0.4224D-03, 0.3289D-03,
     #    0.2540D-03, 0.1947D-03, 0.1483D-03, 0.1123D-03, 0.8458D-04,
     #    0.6341D-04, 0.4733D-04, 0.3518D-04, 0.2604D-04, 0.1923D-04,
     #    0.1414D-04, 0.1038D-04, 0.7594D-05, 0.5542D-05, 0.4037D-05,
     #    0.2932D-05/

      data (calcpts(j,31), j = 1,neta) /0.4208D-23, 0.1743D-22,
     #    0.6705D-22, 0.2565D-21, 0.9801D-21, 0.3759D-20, 0.1440D-19,
     #    0.5517D-19, 0.2113D-18, 0.8097D-18, 0.3102D-17, 0.1189D-16,
     #    0.4554D-16, 0.1745D-15, 0.6681D-15, 0.2559D-14, 0.9801D-14,
     #    0.3753D-13, 0.1436D-12, 0.5495D-12, 0.2100D-11, 0.8020D-11,
     #    0.3059D-10, 0.1163D-09, 0.4410D-09, 0.1664D-08, 0.6222D-08,
     #    0.2307D-07, 0.8433D-07, 0.3018D-06, 0.1048D-05, 0.3495D-05,
     #    0.1103D-04, 0.3234D-04, 0.8656D-04, 0.2075D-03, 0.4392D-03,
     #    0.8139D-03, 0.1321D-02, 0.1891D-02, 0.2420D-02, 0.2805D-02,
     #    0.2994D-02, 0.2985D-02, 0.2823D-02, 0.2565D-02, 0.2267D-02,
     #    0.1966D-02, 0.1682D-02, 0.1420D-02, 0.1185D-02, 0.9775D-03,
     #    0.7964D-03, 0.6411D-03, 0.5104D-03, 0.4023D-03, 0.3143D-03,
     #    0.2433D-03, 0.1870D-03, 0.1427D-03, 0.1083D-03, 0.8172D-04,
     #    0.6135D-04, 0.4586D-04, 0.3414D-04, 0.2530D-04, 0.1871D-04,
     #    0.1378D-04, 0.1012D-04, 0.7412D-05, 0.5414D-05, 0.3947D-05,
     #    0.2870D-05/

      data (calcpts(j,32), j = 1,neta) /0.4152D-23, 0.1735D-22,
     #    0.6717D-22, 0.2562D-21, 0.9799D-21, 0.3757D-20, 0.1439D-19,
     #    0.5514D-19, 0.2113D-18, 0.8095D-18, 0.3102D-17, 0.1188D-16,
     #    0.4552D-16, 0.1745D-15, 0.6679D-15, 0.2559D-14, 0.9798D-14,
     #    0.3751D-13, 0.1436D-12, 0.5493D-12, 0.2100D-11, 0.8017D-11,
     #    0.3057D-10, 0.1163D-09, 0.4410D-09, 0.1664D-08, 0.6221D-08,
     #    0.2307D-07, 0.8430D-07, 0.3017D-06, 0.1048D-05, 0.3495D-05,
     #    0.1102D-04, 0.3234D-04, 0.8652D-04, 0.2075D-03, 0.4389D-03,
     #    0.8138D-03, 0.1321D-02, 0.1893D-02, 0.2423D-02, 0.2812D-02,
     #    0.3003D-02, 0.2994D-02, 0.2821D-02, 0.2546D-02, 0.2226D-02,
     #    0.1906D-02, 0.1613D-02, 0.1350D-02, 0.1121D-02, 0.9229D-03,
     #    0.7521D-03, 0.6066D-03, 0.4842D-03, 0.3826D-03, 0.2997D-03,
     #    0.2326D-03, 0.1792D-03, 0.1372D-03, 0.1043D-03, 0.7885D-04,
     #    0.5931D-04, 0.4440D-04, 0.3311D-04, 0.2457D-04, 0.1818D-04,
     #    0.1341D-04, 0.9858D-05, 0.7227D-05, 0.5284D-05, 0.3855D-05,
     #    0.2805D-05/

      data (calcpts(j,33), j = 1,neta) /0.4175D-23, 0.1735D-22,
     #    0.6707D-22, 0.2565D-21, 0.9798D-21, 0.3757D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6679D-15, 0.2558D-14, 0.9797D-14,
     #    0.3751D-13, 0.1436D-12, 0.5492D-12, 0.2100D-11, 0.8017D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2307D-07, 0.8429D-07, 0.3017D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4389D-03,
     #    0.8139D-03, 0.1322D-02, 0.1895D-02, 0.2428D-02, 0.2823D-02,
     #    0.3020D-02, 0.3015D-02, 0.2841D-02, 0.2556D-02, 0.2220D-02,
     #    0.1881D-02, 0.1571D-02, 0.1300D-02, 0.1070D-02, 0.8756D-03,
     #    0.7119D-03, 0.5740D-03, 0.4589D-03, 0.3634D-03, 0.2853D-03,
     #    0.2222D-03, 0.1716D-03, 0.1316D-03, 0.1003D-03, 0.7599D-04,
     #    0.5727D-04, 0.4295D-04, 0.3207D-04, 0.2385D-04, 0.1767D-04,
     #    0.1304D-04, 0.9599D-05, 0.7044D-05, 0.5156D-05, 0.3764D-05,
     #    0.2742D-05/

      data (calcpts(j,34), j = 1,neta) /0.4158D-23, 0.1734D-22,
     #    0.6731D-22, 0.2564D-21, 0.9796D-21, 0.3757D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9797D-14,
     #    0.3750D-13, 0.1436D-12, 0.5492D-12, 0.2100D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2307D-07, 0.8429D-07, 0.3017D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     #    0.8140D-03, 0.1323D-02, 0.1898D-02, 0.2433D-02, 0.2834D-02,
     #    0.3038D-02, 0.3039D-02, 0.2871D-02, 0.2585D-02, 0.2240D-02,
     #    0.1886D-02, 0.1556D-02, 0.1271D-02, 0.1033D-02, 0.8375D-03,
     #    0.6769D-03, 0.5445D-03, 0.4352D-03, 0.3452D-03, 0.2715D-03,
     #    0.2118D-03, 0.1641D-03, 0.1261D-03, 0.9634D-04, 0.7314D-04,
     #    0.5523D-04, 0.4149D-04, 0.3104D-04, 0.2312D-04, 0.1715D-04,
     #    0.1267D-04, 0.9339D-05, 0.6861D-05, 0.5027D-05, 0.3674D-05,
     #    0.2677D-05/

      data (calcpts(j,35), j = 1,neta) /0.4069D-23, 0.1734D-22,
     #    0.6731D-22, 0.2564D-21, 0.9805D-21, 0.3757D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1436D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2307D-07, 0.8427D-07, 0.3017D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     #    0.8142D-03, 0.1323D-02, 0.1899D-02, 0.2438D-02, 0.2841D-02,
     #    0.3053D-02, 0.3063D-02, 0.2903D-02, 0.2620D-02, 0.2272D-02,
     #    0.1910D-02, 0.1565D-02, 0.1264D-02, 0.1013D-02, 0.8111D-03,
     #    0.6492D-03, 0.5190D-03, 0.4135D-03, 0.3278D-03, 0.2582D-03,
     #    0.2018D-03, 0.1566D-03, 0.1207D-03, 0.9242D-04, 0.7031D-04,
     #    0.5321D-04, 0.4004D-04, 0.3000D-04, 0.2238D-04, 0.1662D-04,
     #    0.1231D-04, 0.9080D-05, 0.6678D-05, 0.4898D-05, 0.3582D-05,
     #    0.2615D-05/

      data (calcpts(j,36), j = 1,neta) /0.4145D-23, 0.1776D-22,
     #    0.6732D-22, 0.2571D-21, 0.9791D-21, 0.3755D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     #    0.8144D-03, 0.1324D-02, 0.1901D-02, 0.2441D-02, 0.2849D-02,
     #    0.3065D-02, 0.3083D-02, 0.2930D-02, 0.2655D-02, 0.2311D-02,
     #    0.1944D-02, 0.1590D-02, 0.1275D-02, 0.1011D-02, 0.7981D-03,
     #    0.6305D-03, 0.4989D-03, 0.3950D-03, 0.3122D-03, 0.2456D-03,
     #    0.1922D-03, 0.1494D-03, 0.1154D-03, 0.8852D-04, 0.6750D-04,
     #    0.5118D-04, 0.3859D-04, 0.2897D-04, 0.2165D-04, 0.1611D-04,
     #    0.1194D-04, 0.8820D-05, 0.6495D-05, 0.4769D-05, 0.3492D-05,
     #    0.2550D-05/

      data (calcpts(j,37), j = 1,neta) /0.4138D-23, 0.1734D-22,
     #    0.6732D-22, 0.2570D-21, 0.9789D-21, 0.3757D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     #    0.8145D-03, 0.1324D-02, 0.1902D-02, 0.2443D-02, 0.2853D-02,
     #    0.3074D-02, 0.3097D-02, 0.2952D-02, 0.2685D-02, 0.2348D-02,
     #    0.1982D-02, 0.1625D-02, 0.1301D-02, 0.1024D-02, 0.7987D-03,
     #    0.6221D-03, 0.4856D-03, 0.3806D-03, 0.2987D-03, 0.2343D-03,
     #    0.1832D-03, 0.1425D-03, 0.1102D-03, 0.8471D-04, 0.6473D-04,
     #    0.4917D-04, 0.3716D-04, 0.2795D-04, 0.2091D-04, 0.1559D-04,
     #    0.1157D-04, 0.8561D-05, 0.6312D-05, 0.4640D-05, 0.3402D-05,
     #    0.2487D-05/

      data (calcpts(j,38), j = 1,neta) /0.3888D-23, 0.1774D-22,
     #    0.6732D-22, 0.2554D-21, 0.9805D-21, 0.3757D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     #    0.8145D-03, 0.1324D-02, 0.1902D-02, 0.2445D-02, 0.2858D-02,
     #    0.3081D-02, 0.3110D-02, 0.2970D-02, 0.2709D-02, 0.2378D-02,
     #    0.2016D-02, 0.1661D-02, 0.1332D-02, 0.1047D-02, 0.8111D-03,
     #    0.6242D-03, 0.4803D-03, 0.3712D-03, 0.2883D-03, 0.2246D-03,
     #    0.1749D-03, 0.1360D-03, 0.1052D-03, 0.8099D-04, 0.6200D-04,
     #    0.4719D-04, 0.3573D-04, 0.2693D-04, 0.2019D-04, 0.1508D-04,
     #    0.1121D-04, 0.8303D-05, 0.6129D-05, 0.4512D-05, 0.3311D-05,
     #    0.2423D-05/

      data (calcpts(j,39), j = 1,neta) /0.3883D-23, 0.1724D-22,
     #    0.6732D-22, 0.2544D-21, 0.9805D-21, 0.3756D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     #    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2446D-02, 0.2859D-02,
     #    0.3085D-02, 0.3117D-02, 0.2982D-02, 0.2729D-02, 0.2401D-02,
     #    0.2046D-02, 0.1694D-02, 0.1365D-02, 0.1075D-02, 0.8318D-03,
     #    0.6356D-03, 0.4832D-03, 0.3680D-03, 0.2819D-03, 0.2172D-03,
     #    0.1680D-03, 0.1301D-03, 0.1005D-03, 0.7742D-04, 0.5934D-04,
     #    0.4526D-04, 0.3432D-04, 0.2591D-04, 0.1947D-04, 0.1456D-04,
     #    0.1084D-04, 0.8043D-05, 0.5948D-05, 0.4383D-05, 0.3220D-05,
     #    0.2360D-05/

      data (calcpts(j,40), j = 1,neta) /0.4569D-23, 0.1774D-22,
     #    0.6616D-22, 0.2544D-21, 0.9809D-21, 0.3756D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4391D-03,
     #    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2862D-02,
     #    0.3089D-02, 0.3123D-02, 0.2993D-02, 0.2742D-02, 0.2420D-02,
     #    0.2069D-02, 0.1721D-02, 0.1394D-02, 0.1104D-02, 0.8562D-03,
     #    0.6533D-03, 0.4932D-03, 0.3709D-03, 0.2799D-03, 0.2127D-03,
     #    0.1627D-03, 0.1251D-03, 0.9633D-04, 0.7409D-04, 0.5679D-04,
     #    0.4335D-04, 0.3294D-04, 0.2491D-04, 0.1875D-04, 0.1404D-04,
     #    0.1048D-04, 0.7787D-05, 0.5764D-05, 0.4254D-05, 0.3129D-05,
     #    0.2295D-05/

      data (calcpts(j,41), j = 1,neta) /0.4535D-23, 0.1701D-22,
     #    0.6738D-22, 0.2558D-21, 0.9793D-21, 0.3755D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2862D-02,
     #    0.3092D-02, 0.3128D-02, 0.2998D-02, 0.2751D-02, 0.2433D-02,
     #    0.2087D-02, 0.1741D-02, 0.1418D-02, 0.1129D-02, 0.8806D-03,
     #    0.6739D-03, 0.5081D-03, 0.3795D-03, 0.2829D-03, 0.2117D-03,
     #    0.1596D-03, 0.1214D-03, 0.9278D-04, 0.7107D-04, 0.5441D-04,
     #    0.4154D-04, 0.3159D-04, 0.2393D-04, 0.1803D-04, 0.1354D-04,
     #    0.1011D-04, 0.7529D-05, 0.5583D-05, 0.4125D-05, 0.3039D-05,
     #    0.2232D-05/

      data (calcpts(j,42), j = 1,neta) /0.5008D-23, 0.1776D-22,
     #    0.6751D-22, 0.2558D-21, 0.9809D-21, 0.3755D-20, 0.1439D-19,
     #    0.5514D-19, 0.2112D-18, 0.8092D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2864D-02,
     #    0.3093D-02, 0.3131D-02, 0.3003D-02, 0.2757D-02, 0.2443D-02,
     #    0.2100D-02, 0.1758D-02, 0.1437D-02, 0.1151D-02, 0.9024D-03,
     #    0.6945D-03, 0.5253D-03, 0.3918D-03, 0.2900D-03, 0.2144D-03,
     #    0.1592D-03, 0.1193D-03, 0.9015D-04, 0.6855D-04, 0.5228D-04,
     #    0.3984D-04, 0.3030D-04, 0.2297D-04, 0.1734D-04, 0.1303D-04,
     #    0.9756D-05, 0.7273D-05, 0.5401D-05, 0.3998D-05, 0.2949D-05,
     #    0.2169D-05/

      data (calcpts(j,43), j = 1,neta) /0.4451D-23, 0.1773D-22,
     #    0.6620D-22, 0.2545D-21, 0.9812D-21, 0.3755D-20, 0.1439D-19,
     #    0.5513D-19, 0.2112D-18, 0.8094D-18, 0.3100D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8147D-03, 0.1325D-02, 0.1904D-02, 0.2448D-02, 0.2864D-02,
     #    0.3095D-02, 0.3132D-02, 0.3006D-02, 0.2763D-02, 0.2449D-02,
     #    0.2109D-02, 0.1769D-02, 0.1451D-02, 0.1167D-02, 0.9204D-03,
     #    0.7127D-03, 0.5421D-03, 0.4059D-03, 0.3000D-03, 0.2200D-03,
     #    0.1614D-03, 0.1191D-03, 0.8873D-04, 0.6671D-04, 0.5048D-04,
     #    0.3833D-04, 0.2910D-04, 0.2205D-04, 0.1667D-04, 0.1254D-04,
     #    0.9401D-05, 0.7020D-05, 0.5222D-05, 0.3870D-05, 0.2859D-05,
     #    0.2105D-05/

      data (calcpts(j,44), j = 1,neta) /0.4536D-23, 0.1766D-22,
     #    0.6613D-22, 0.2562D-21, 0.9802D-21, 0.3755D-20, 0.1439D-19,
     #    0.5513D-19, 0.2112D-18, 0.8095D-18, 0.3102D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6678D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     #    0.3095D-02, 0.3134D-02, 0.3008D-02, 0.2766D-02, 0.2454D-02,
     #    0.2115D-02, 0.1777D-02, 0.1462D-02, 0.1179D-02, 0.9344D-03,
     #    0.7277D-03, 0.5571D-03, 0.4196D-03, 0.3113D-03, 0.2282D-03,
     #    0.1661D-03, 0.1210D-03, 0.8875D-04, 0.6575D-04, 0.4919D-04,
     #    0.3705D-04, 0.2802D-04, 0.2120D-04, 0.1601D-04, 0.1206D-04,
     #    0.9053D-05, 0.6770D-05, 0.5043D-05, 0.3742D-05, 0.2769D-05,
     #    0.2042D-05/

      data (calcpts(j,45), j = 1,neta) /0.4531D-23, 0.1743D-22,
     #    0.6650D-22, 0.2545D-21, 0.9850D-21, 0.3771D-20, 0.1438D-19,
     #    0.5526D-19, 0.2116D-18, 0.8094D-18, 0.3104D-17, 0.1188D-16,
     #    0.4551D-16, 0.1743D-15, 0.6679D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     #    0.3096D-02, 0.3135D-02, 0.3009D-02, 0.2768D-02, 0.2457D-02,
     #    0.2120D-02, 0.1783D-02, 0.1469D-02, 0.1188D-02, 0.9449D-03,
     #    0.7394D-03, 0.5694D-03, 0.4317D-03, 0.3222D-03, 0.2370D-03,
     #    0.1725D-03, 0.1247D-03, 0.9030D-04, 0.6587D-04, 0.4854D-04,
     #    0.3615D-04, 0.2712D-04, 0.2043D-04, 0.1541D-04, 0.1160D-04,
     #    0.8714D-05, 0.6524D-05, 0.4866D-05, 0.3617D-05, 0.2679D-05,
     #    0.1979D-05/

      data (calcpts(j,46), j = 1,neta) /0.4427D-23, 0.1749D-22,
     #    0.6682D-22, 0.2549D-21, 0.9752D-21, 0.3768D-20, 0.1432D-19,
     #    0.5490D-19, 0.2113D-18, 0.8091D-18, 0.3100D-17, 0.1188D-16,
     #    0.4550D-16, 0.1743D-15, 0.6677D-15, 0.2558D-14, 0.9795D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     #    0.3096D-02, 0.3135D-02, 0.3011D-02, 0.2769D-02, 0.2460D-02,
     #    0.2122D-02, 0.1787D-02, 0.1474D-02, 0.1195D-02, 0.9525D-03,
     #    0.7480D-03, 0.5790D-03, 0.4416D-03, 0.3318D-03, 0.2457D-03,
     #    0.1794D-03, 0.1297D-03, 0.9321D-04, 0.6711D-04, 0.4869D-04,
     #    0.3573D-04, 0.2649D-04, 0.1980D-04, 0.1487D-04, 0.1117D-04,
     #    0.8388D-05, 0.6284D-05, 0.4692D-05, 0.3492D-05, 0.2591D-05,
     #    0.1916D-05/

      data (calcpts(j,47), j = 1,neta) /0.4376D-23, 0.1851D-22,
     #    0.6717D-22, 0.2583D-21, 0.1000D-20, 0.3750D-20, 0.1439D-19,
     #    0.5514D-19, 0.2121D-18, 0.8097D-18, 0.3111D-17, 0.1190D-16,
     #    0.4551D-16, 0.1743D-15, 0.6681D-15, 0.2559D-14, 0.9798D-14,
     #    0.3750D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     #    0.3096D-02, 0.3135D-02, 0.3012D-02, 0.2771D-02, 0.2462D-02,
     #    0.2124D-02, 0.1790D-02, 0.1478D-02, 0.1199D-02, 0.9579D-03,
     #    0.7544D-03, 0.5861D-03, 0.4492D-03, 0.3398D-03, 0.2534D-03,
     #    0.1863D-03, 0.1351D-03, 0.9705D-04, 0.6938D-04, 0.4968D-04,
     #    0.3588D-04, 0.2621D-04, 0.1937D-04, 0.1442D-04, 0.1079D-04,
     #    0.8087D-05, 0.6054D-05, 0.4524D-05, 0.3371D-05, 0.2504D-05,
     #    0.1854D-05/

      data (calcpts(j,48), j = 1,neta) /0.5678D-23, 0.1891D-22,
     #    0.7606D-22, 0.2568D-21, 0.9618D-21, 0.3826D-20, 0.1455D-19,
     #    0.5600D-19, 0.2135D-18, 0.8070D-18, 0.3093D-17, 0.1190D-16,
     #    0.4561D-16, 0.1745D-15, 0.6681D-15, 0.2561D-14, 0.9801D-14,
     #    0.3751D-13, 0.1436D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     #    0.3096D-02, 0.3135D-02, 0.3012D-02, 0.2772D-02, 0.2463D-02,
     #    0.2125D-02, 0.1792D-02, 0.1481D-02, 0.1202D-02, 0.9617D-03,
     #    0.7589D-03, 0.5913D-03, 0.4551D-03, 0.3459D-03, 0.2597D-03,
     #    0.1923D-03, 0.1404D-03, 0.1013D-03, 0.7233D-04, 0.5142D-04,
     #    0.3666D-04, 0.2636D-04, 0.1919D-04, 0.1412D-04, 0.1048D-04,
     #    0.7817D-05, 0.5841D-05, 0.4362D-05, 0.3252D-05, 0.2418D-05,
     #    0.1792D-05/

      data (calcpts(j,49), j = 1,neta) /0.3773D-23, 0.1720D-22,
     #    0.6603D-22, 0.2522D-21, 0.1040D-20, 0.3992D-20, 0.1503D-19,
     #    0.5605D-19, 0.2113D-18, 0.8140D-18, 0.3115D-17, 0.1187D-16,
     #    0.4551D-16, 0.1745D-15, 0.6692D-15, 0.2561D-14, 0.9800D-14,
     #    0.3749D-13, 0.1435D-12, 0.5492D-12, 0.2098D-11, 0.8016D-11,
     #    0.3057D-10, 0.1163D-09, 0.4408D-09, 0.1664D-08, 0.6219D-08,
     #    0.2306D-07, 0.8427D-07, 0.3015D-06, 0.1048D-05, 0.3494D-05,
     #    0.1102D-04, 0.3232D-04, 0.8651D-04, 0.2075D-03, 0.4392D-03,
     #    0.8148D-03, 0.1325D-02, 0.1904D-02, 0.2449D-02, 0.2865D-02,
     #    0.3096D-02, 0.3136D-02, 0.3012D-02, 0.2772D-02, 0.2463D-02,
     #    0.2127D-02, 0.1792D-02, 0.1482D-02, 0.1204D-02, 0.9644D-03,
     #    0.7620D-03, 0.5949D-03, 0.4593D-03, 0.3505D-03, 0.2645D-03,
     #    0.1971D-03, 0.1451D-03, 0.1054D-03, 0.7557D-04, 0.5369D-04,
     #    0.3800D-04, 0.2695D-04, 0.1931D-04, 0.1400D-04, 0.1027D-04,
     #    0.7599D-05, 0.5652D-05, 0.4212D-05, 0.3138D-05, 0.2334D-05,
     #    0.1731D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1_LTq = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     ===========================================
      double precision function h1bar_LTq(eta,xi)
c     ===========================================

c     eq (29) in PLB347 (1995) 143 - 151 only necessary for the 
c     transverse piece
c     MSbar scheme
c     This routine is called subd1bar in the original code.
c     Gives h1bar_LTq for Q2 < 1.5 GeV2 ( = 0 for  Q2 > 1.5 GeV2)
      
      implicit none
      integer neta, nxi
      parameter (neta = 45, nxi = 15)
      double precision calcpts(neta,nxi), aeta(neta), axi(nxi)
      double precision t, u, y1, y2, y3, y4
      double precision eta, xi, huge, small
      parameter (small = 1.d-8, huge = 1.d10)
      integer j, ieta, ixi

      data (calcpts(j, 1), j=1,neta) /0.d0, -.3403d-06, -.1758d-05,
     #  -.3760d-05, -.6194d-05, -.8975d-05, -.1049d-04, -.5149d-04,
     #  -.1049d-03, -.1646d-03, -.2276d-03, -.2598d-03, -.5753d-03,
     #  -.8478d-03, -.1068d-02, -.1242d-02, -.1380d-02, -.1488d-02,
     #  -.1572d-02, -.1640d-02, -.1694d-02, -.1856d-02, -.1816d-02,
     #  -.1742d-02, -.1662d-02, -.1589d-02, -.1518d-02, -.1453d-02,
     #  -.1395d-02, -.1342d-02, -.7865d-03, -.5766d-03, -.4622d-03,
     #  -.3897d-03, -.3617d-03, -.2181d-03, -.1602d-03, -.1070d-03,
     #  -.8177d-04, -.6665d-04, -.6109d-04, -.1574d-04, -.8655d-05,
     #  -.1086d-05, 0.d0/
c
      data (calcpts(j, 2), j=1,neta) /0.d0, -.2178d-06, -.1125d-05,
     #  -.2409d-05, -.3966d-05, -.5751d-05, -.6717d-05, -.3299d-04,
     #  -.6719d-04, -.1055d-03, -.1459d-03, -.1665d-03, -.3694d-03,
     #  -.5449d-03, -.6870d-03, -.8000d-03, -.8888d-03, -.9588d-03,
     #  -.1014d-02, -.1057d-02, -.1091d-02, -.1199d-02, -.1175d-02,
     #  -.1127d-02, -.1077d-02, -.1028d-02, -.9830d-03, -.9422d-03,
     #  -.9041d-03, -.8688d-03, -.5103d-03, -.3741d-03, -.3000d-03,
     #  -.2528d-03, -.2346d-03, -.1416d-03, -.1039d-03, -.6963d-04,
     #  -.5295d-04, -.4317d-04, -.3972d-04, -.1017d-04, -.5610d-05,
     #  -.7188d-06, 0.d0/
c
      data (calcpts(j, 3), j=1,neta) /0.d0, -.5322d-07, -.2750d-06,
     #  -.5883d-06, -.9690d-06, -.1405d-05, -.1641d-05, -.8070d-05,
     #  -.1646d-04, -.2586d-04, -.3580d-04, -.4088d-04, -.9104d-04,
     #  -.1346d-03, -.1703d-03, -.1986d-03, -.2209d-03, -.2388d-03,
     #  -.2528d-03, -.2639d-03, -.2727d-03, -.3014d-03, -.2961d-03,
     #  -.2847d-03, -.2724d-03, -.2604d-03, -.2490d-03, -.2386d-03,
     #  -.2292d-03, -.2205d-03, -.1297d-03, -.9522d-04, -.7638d-04,
     #  -.6429d-04, -.5973d-04, -.3603d-04, -.2641d-04, -.1768d-04,
     #  -.1350d-04, -.1100d-04, -.1009d-04, -.2613d-05, -.1420d-05,
     #  -.1778d-06, 0.d0/
c
      data (calcpts(j, 4), j=1,neta) /0.d0, -.6204d-09, -.3207d-08,
     #  -.6865d-08, -.1131d-07, -.1639d-07, -.1916d-07, -.9449d-07,
     #  -.1932d-06, -.3045d-06, -.4228d-06, -.4833d-06, -.1088d-05,
     #  -.1624d-05, -.2069d-05, -.2429d-05, -.2718d-05, -.2949d-05,
     #  -.3135d-05, -.3284d-05, -.3403d-05, -.3831d-05, -.3800d-05,
     #  -.3674d-05, -.3528d-05, -.3381d-05, -.3245d-05, -.3114d-05,
     #  -.2995d-05, -.2883d-05, -.1710d-05, -.1256d-05, -.1010d-05,
     #  -.8503d-06, -.7902d-06, -.4776d-06, -.3498d-06, -.2352d-06,
     #  -.1790d-06, -.1461d-06, -.1337d-06, -.3444d-07, -.1883d-07,
     #  -.2382d-08, 0.d0/
c
      data (calcpts(j, 5), j=1,neta) /0.d0, -.4968d-15, -.2571d-14,
     #  -.5505d-14, -.9076d-14, -.1318d-13, -.1541d-13, -.7657d-13,
     #  -.1578d-12, -.2505d-12, -.3500d-12, -.4016d-12, -.9316d-12,
     #  -.1425d-11, -.1853d-11, -.2212d-11, -.2511d-11, -.2759d-11,
     #  -.2965d-11, -.3137d-11, -.3279d-11, -.3888d-11, -.3960d-11,
     #  -.3893d-11, -.3784d-11, -.3660d-11, -.3535d-11, -.3412d-11,
     #  -.3296d-11, -.3187d-11, -.1940d-11, -.1433d-11, -.1153d-11,
     #  -.9740d-12, -.9041d-12, -.5475d-12, -.4023d-12, -.2694d-12,
     #  -.2056d-12, -.1677d-12, -.1536d-12, -.3957d-13, -.2160d-13,
     #  -.2823d-14, 0.d0/
c
      data (calcpts(j, 6), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j, 7), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j, 8), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j, 9), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j,10), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j,11), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j,12), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j,13), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j,14), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (calcpts(j,15), j=1,neta) /0.d0, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00, 0.0000d+00,
     #  0.0000d+00, 0.d0/
c
      data (aeta(j), j = 1,neta) /small, 0.1000d-02, 0.3000d-02,
     #  0.5000d-02, 0.7000d-02, 0.9000d-02, 0.1000d-01, 0.3000d-01, 
     #  0.5000d-01, 0.7000d-01, 0.9000d-01, 0.1000d+00, 0.2000d+00, 
     #  0.3000d+00, 0.4000d+00, 0.5000d+00, 0.6000d+00, 0.7000d+00, 
     #  0.8000d+00, 0.9000d+00, 0.1000d+01, 0.2000d+01, 0.3000d+01,
     #  0.4000d+01, 0.5000d+01, 0.6000d+01, 0.7000d+01, 0.8000d+01, 
     #  0.9000d+01, 0.1000d+02, 0.3000d+02, 0.5000d+02, 0.7000d+02,
     #  0.9000d+02, 0.1000d+03, 0.2000d+03, 0.3000d+03, 0.5000d+03,
     #  0.7000d+03, 0.9000d+03, 0.1000d+04, 0.5000d+04, 0.1000d+05,
     #  0.1000d+06, huge/
c
      data (axi(j), j = 1,nxi) /0.1000d-01, 0.3162d-01, 0.1000d+00,
     #  0.3162d+00, 0.1000d+01, 0.2500d+01, 0.3162d+01, 0.7500d+01, 
     #  0.1000d+02, 0.3162d+02, 0.1000d+03, 0.3162d+03, 0.1000d+04,
     #  0.5000d+04, 0.1000d+05/
c
c  here we have to choose the array elements that will go into the 
c  interpolation.
      call locate(aeta, neta, eta, ieta)
      call locate(axi, nxi, xi, ixi)
      if (ieta .le. 1) ieta = 1
      if (ieta .gt. (neta - 1)) ieta = neta - 1
      if (ixi .le. 1) ixi = 1
      if (ixi .gt. (nxi - 1)) ixi = nxi - 1
      y1 = calcpts(ieta,ixi)
      y2 = calcpts(ieta+1,ixi)
      y3 = calcpts(ieta+1,ixi+1)
      y4 = calcpts(ieta,ixi+1)
c interpolating between the points
      t = (eta - aeta(ieta))/(aeta(ieta + 1) - aeta(ieta))
      u = (xi - axi(ixi))/(axi(ixi + 1) - axi(ixi))
      h1bar_LTq = (1.d0 - t)*(1.d0 - u)*y1 + t*(1.d0 - u)*y2 +
     #             t*u*y3 + (1.d0 - t)*u*y4

      return
      end

CDECK  ID>, QCORRL.

c     ===========================================
      double precision function h1_HLq(eta,xi)
c     ===========================================

c     eq (26) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subcqhl in the original code.
c     Called schql in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /-.2062D-13, -.3668D-13,
     #    -.6520D-13, -.1160D-12, -.2063D-12, -.3668D-12, -.6522D-12,
     #    -.1160D-11, -.2062D-11, -.3668D-11, -.6525D-11, -.1160D-10,
     #    -.2064D-10, -.3672D-10, -.6530D-10, -.1162D-09, -.2069D-09,
     #    -.3684D-09, -.6561D-09, -.1170D-08, -.2085D-08, -.3723D-08,
     #    -.6657D-08, -.1192D-07, -.2137D-07, -.3838D-07, -.6900D-07,
     #    -.1242D-06, -.2233D-06, -.3993D-06, -.7067D-06, -.1227D-05,
     #    -.2066D-05, -.3329D-05, -.5057D-05, -.7154D-05, -.9369D-05,
     #    -.1137D-04, -.1288D-04, -.1379D-04, -.1414D-04, -.1402D-04,
     #    -.1358D-04, -.1296D-04, -.1228D-04, -.1162D-04, -.1103D-04,
     #    -.1052D-04, -.1012D-04, -.9794D-05, -.9545D-05, -.9356D-05,
     #    -.9215D-05, -.9111D-05, -.9034D-05, -.8980D-05, -.8938D-05,
     #    -.8910D-05, -.8889D-05, -.8873D-05, -.8863D-05, -.8856D-05,
     #    -.8851D-05, -.8847D-05, -.8844D-05, -.8841D-05, -.8840D-05,
     #    -.8840D-05, -.8839D-05, -.8839D-05, -.8837D-05, -.8837D-05,
     #    -.8837D-05/

      data (calcpts(j, 2), j = 1,neta) /-.3027D-13, -.5384D-13,
     #    -.9569D-13, -.1702D-12, -.3027D-12, -.5383D-12, -.9573D-12,
     #    -.1703D-11, -.3027D-11, -.5384D-11, -.9577D-11, -.1703D-10,
     #    -.3029D-10, -.5390D-10, -.9585D-10, -.1706D-09, -.3037D-09,
     #    -.5406D-09, -.9630D-09, -.1717D-08, -.3060D-08, -.5465D-08,
     #    -.9771D-08, -.1749D-07, -.3136D-07, -.5633D-07, -.1013D-06,
     #    -.1823D-06, -.3277D-06, -.5860D-06, -.1037D-05, -.1801D-05,
     #    -.3032D-05, -.4886D-05, -.7422D-05, -.1050D-04, -.1375D-04,
     #    -.1668D-04, -.1890D-04, -.2024D-04, -.2075D-04, -.2058D-04,
     #    -.1993D-04, -.1903D-04, -.1803D-04, -.1705D-04, -.1619D-04,
     #    -.1545D-04, -.1485D-04, -.1438D-04, -.1401D-04, -.1373D-04,
     #    -.1352D-04, -.1337D-04, -.1326D-04, -.1318D-04, -.1312D-04,
     #    -.1308D-04, -.1305D-04, -.1303D-04, -.1301D-04, -.1300D-04,
     #    -.1299D-04, -.1299D-04, -.1299D-04, -.1297D-04, -.1297D-04,
     #    -.1297D-04, -.1297D-04, -.1297D-04, -.1297D-04, -.1297D-04,
     #    -.1297D-04/

      data (calcpts(j, 3), j = 1,neta) /-.4440D-13, -.7897D-13,
     #    -.1404D-12, -.2497D-12, -.4441D-12, -.7896D-12, -.1404D-11,
     #    -.2498D-11, -.4440D-11, -.7897D-11, -.1405D-10, -.2498D-10,
     #    -.4444D-10, -.7907D-10, -.1406D-09, -.2502D-09, -.4455D-09,
     #    -.7931D-09, -.1413D-08, -.2518D-08, -.4489D-08, -.8016D-08,
     #    -.1433D-07, -.2565D-07, -.4600D-07, -.8263D-07, -.1486D-06,
     #    -.2674D-06, -.4807D-06, -.8596D-06, -.1521D-05, -.2642D-05,
     #    -.4448D-05, -.7166D-05, -.1089D-04, -.1540D-04, -.2017D-04,
     #    -.2447D-04, -.2772D-04, -.2970D-04, -.3044D-04, -.3018D-04,
     #    -.2924D-04, -.2791D-04, -.2643D-04, -.2500D-04, -.2373D-04,
     #    -.2265D-04, -.2177D-04, -.2108D-04, -.2054D-04, -.2013D-04,
     #    -.1984D-04, -.1961D-04, -.1945D-04, -.1932D-04, -.1923D-04,
     #    -.1918D-04, -.1913D-04, -.1910D-04, -.1907D-04, -.1906D-04,
     #    -.1905D-04, -.1903D-04, -.1903D-04, -.1903D-04, -.1902D-04,
     #    -.1902D-04, -.1902D-04, -.1902D-04, -.1902D-04, -.1902D-04,
     #    -.1902D-04/

      data (calcpts(j, 4), j = 1,neta) /-.6515D-13, -.1159D-12,
     #    -.2060D-12, -.3663D-12, -.6516D-12, -.1159D-11, -.2061D-11,
     #    -.3665D-11, -.6515D-11, -.1159D-10, -.2061D-10, -.3666D-10,
     #    -.6521D-10, -.1160D-09, -.2063D-09, -.3672D-09, -.6537D-09,
     #    -.1164D-08, -.2073D-08, -.3695D-08, -.6587D-08, -.1176D-07,
     #    -.2103D-07, -.3764D-07, -.6749D-07, -.1212D-06, -.2180D-06,
     #    -.3924D-06, -.7053D-06, -.1261D-05, -.2232D-05, -.3876D-05,
     #    -.6526D-05, -.1051D-04, -.1597D-04, -.2260D-04, -.2959D-04,
     #    -.3590D-04, -.4068D-04, -.4358D-04, -.4466D-04, -.4429D-04,
     #    -.4290D-04, -.4094D-04, -.3878D-04, -.3669D-04, -.3483D-04,
     #    -.3323D-04, -.3195D-04, -.3094D-04, -.3014D-04, -.2955D-04,
     #    -.2911D-04, -.2877D-04, -.2853D-04, -.2835D-04, -.2822D-04,
     #    -.2813D-04, -.2807D-04, -.2803D-04, -.2799D-04, -.2796D-04,
     #    -.2795D-04, -.2793D-04, -.2792D-04, -.2792D-04, -.2792D-04,
     #    -.2791D-04, -.2791D-04, -.2791D-04, -.2791D-04, -.2791D-04,
     #    -.2791D-04/

      data (calcpts(j, 5), j = 1,neta) /-.9559D-13, -.1700D-12,
     #    -.3022D-12, -.5375D-12, -.9561D-12, -.1700D-11, -.3023D-11,
     #    -.5377D-11, -.9558D-11, -.1700D-10, -.3024D-10, -.5379D-10,
     #    -.9567D-10, -.1702D-09, -.3027D-09, -.5387D-09, -.9591D-09,
     #    -.1707D-08, -.3041D-08, -.5421D-08, -.9664D-08, -.1726D-07,
     #    -.3085D-07, -.5523D-07, -.9902D-07, -.1779D-06, -.3198D-06,
     #    -.5756D-06, -.1035D-05, -.1850D-05, -.3274D-05, -.5686D-05,
     #    -.9572D-05, -.1542D-04, -.2343D-04, -.3315D-04, -.4341D-04,
     #    -.5267D-04, -.5968D-04, -.6393D-04, -.6553D-04, -.6498D-04,
     #    -.6295D-04, -.6007D-04, -.5691D-04, -.5385D-04, -.5111D-04,
     #    -.4878D-04, -.4688D-04, -.4538D-04, -.4423D-04, -.4336D-04,
     #    -.4271D-04, -.4222D-04, -.4187D-04, -.4160D-04, -.4142D-04,
     #    -.4127D-04, -.4118D-04, -.4112D-04, -.4106D-04, -.4102D-04,
     #    -.4100D-04, -.4098D-04, -.4097D-04, -.4097D-04, -.4096D-04,
     #    -.4096D-04, -.4096D-04, -.4094D-04, -.4094D-04, -.4094D-04,
     #    -.4094D-04/

      data (calcpts(j, 6), j = 1,neta) /-.1402D-12, -.2493D-12,
     #    -.4431D-12, -.7882D-12, -.1402D-11, -.2493D-11, -.4433D-11,
     #    -.7885D-11, -.1402D-10, -.2493D-10, -.4435D-10, -.7887D-10,
     #    -.1403D-09, -.2496D-09, -.4439D-09, -.7899D-09, -.1406D-08,
     #    -.2504D-08, -.4459D-08, -.7949D-08, -.1417D-07, -.2530D-07,
     #    -.4524D-07, -.8098D-07, -.1452D-06, -.2608D-06, -.4689D-06,
     #    -.8439D-06, -.1517D-05, -.2713D-05, -.4800D-05, -.8335D-05,
     #    -.1403D-04, -.2261D-04, -.3435D-04, -.4861D-04, -.6365D-04,
     #    -.7724D-04, -.8752D-04, -.9375D-04, -.9609D-04, -.9529D-04,
     #    -.9229D-04, -.8810D-04, -.8346D-04, -.7895D-04, -.7492D-04,
     #    -.7150D-04, -.6872D-04, -.6653D-04, -.6483D-04, -.6355D-04,
     #    -.6259D-04, -.6188D-04, -.6136D-04, -.6098D-04, -.6071D-04,
     #    -.6051D-04, -.6037D-04, -.6027D-04, -.6020D-04, -.6015D-04,
     #    -.6011D-04, -.6008D-04, -.6007D-04, -.6005D-04, -.6004D-04,
     #    -.6002D-04, -.6003D-04, -.6003D-04, -.6003D-04, -.6003D-04,
     #    -.6001D-04/

      data (calcpts(j, 7), j = 1,neta) /-.2055D-12, -.3655D-12,
     #    -.6496D-12, -.1155D-11, -.2055D-11, -.3654D-11, -.6498D-11,
     #    -.1156D-10, -.2055D-10, -.3655D-10, -.6501D-10, -.1156D-09,
     #    -.2056D-09, -.3659D-09, -.6506D-09, -.1158D-08, -.2062D-08,
     #    -.3670D-08, -.6537D-08, -.1165D-07, -.2077D-07, -.3709D-07,
     #    -.6632D-07, -.1187D-06, -.2128D-06, -.3823D-06, -.6872D-06,
     #    -.1237D-05, -.2223D-05, -.3975D-05, -.7034D-05, -.1222D-04,
     #    -.2056D-04, -.3313D-04, -.5034D-04, -.7123D-04, -.9329D-04,
     #    -.1132D-03, -.1283D-03, -.1374D-03, -.1409D-03, -.1397D-03,
     #    -.1353D-03, -.1291D-03, -.1223D-03, -.1157D-03, -.1098D-03,
     #    -.1048D-03, -.1007D-03, -.9748D-04, -.9500D-04, -.9311D-04,
     #    -.9171D-04, -.9068D-04, -.8991D-04, -.8936D-04, -.8895D-04,
     #    -.8866D-04, -.8845D-04, -.8829D-04, -.8819D-04, -.8812D-04,
     #    -.8807D-04, -.8803D-04, -.8800D-04, -.8797D-04, -.8796D-04,
     #    -.8796D-04, -.8795D-04, -.8795D-04, -.8795D-04, -.8793D-04,
     #    -.8793D-04/

      data (calcpts(j, 8), j = 1,neta) /-.3011D-12, -.5355D-12,
     #    -.9518D-12, -.1693D-11, -.3011D-11, -.5354D-11, -.9521D-11,
     #    -.1694D-10, -.3010D-10, -.5355D-10, -.9526D-10, -.1694D-09,
     #    -.3013D-09, -.5361D-09, -.9533D-09, -.1697D-08, -.3021D-08,
     #    -.5377D-08, -.9578D-08, -.1707D-07, -.3044D-07, -.5435D-07,
     #    -.9716D-07, -.1739D-06, -.3118D-06, -.5600D-06, -.1007D-05,
     #    -.1812D-05, -.3256D-05, -.5822D-05, -.1030D-04, -.1789D-04,
     #    -.3011D-04, -.4852D-04, -.7372D-04, -.1043D-03, -.1367D-03,
     #    -.1658D-03, -.1879D-03, -.2013D-03, -.2064D-03, -.2046D-03,
     #    -.1982D-03, -.1892D-03, -.1792D-03, -.1695D-03, -.1608D-03,
     #    -.1535D-03, -.1475D-03, -.1428D-03, -.1391D-03, -.1364D-03,
     #    -.1343D-03, -.1329D-03, -.1317D-03, -.1308D-03, -.1303D-03,
     #    -.1298D-03, -.1295D-03, -.1292D-03, -.1291D-03, -.1290D-03,
     #    -.1290D-03, -.1288D-03, -.1289D-03, -.1289D-03, -.1289D-03,
     #    -.1289D-03, -.1289D-03, -.1289D-03, -.1289D-03, -.1289D-03,
     #    -.1287D-03/

      data (calcpts(j, 9), j = 1,neta) /-.4405D-12, -.7835D-12,
     #    -.1393D-11, -.2477D-11, -.4406D-11, -.7834D-11, -.1393D-10,
     #    -.2478D-10, -.4405D-10, -.7835D-10, -.1394D-09, -.2479D-09,
     #    -.4409D-09, -.7844D-09, -.1395D-08, -.2483D-08, -.4420D-08,
     #    -.7868D-08, -.1401D-07, -.2498D-07, -.4453D-07, -.7951D-07,
     #    -.1422D-06, -.2544D-06, -.4561D-06, -.8192D-06, -.1473D-05,
     #    -.2650D-05, -.4762D-05, -.8514D-05, -.1506D-04, -.2615D-04,
     #    -.4403D-04, -.7095D-04, -.1078D-03, -.1526D-03, -.1999D-03,
     #    -.2426D-03, -.2750D-03, -.2946D-03, -.3020D-03, -.2994D-03,
     #    -.2900D-03, -.2767D-03, -.2621D-03, -.2479D-03, -.2351D-03,
     #    -.2244D-03, -.2156D-03, -.2087D-03, -.2033D-03, -.1993D-03,
     #    -.1963D-03, -.1940D-03, -.1924D-03, -.1912D-03, -.1903D-03,
     #    -.1897D-03, -.1893D-03, -.1890D-03, -.1888D-03, -.1886D-03,
     #    -.1885D-03, -.1884D-03, -.1884D-03, -.1882D-03, -.1882D-03,
     #    -.1882D-03, -.1882D-03, -.1882D-03, -.1882D-03, -.1882D-03,
     #    -.1882D-03/

      data (calcpts(j,10), j = 1,neta) /-.6440D-12, -.1146D-11,
     #    -.2036D-11, -.3621D-11, -.6442D-11, -.1145D-10, -.2037D-10,
     #    -.3623D-10, -.6440D-10, -.1145D-09, -.2038D-09, -.3624D-09,
     #    -.6446D-09, -.1147D-08, -.2039D-08, -.3629D-08, -.6461D-08,
     #    -.1150D-07, -.2049D-07, -.3652D-07, -.6510D-07, -.1162D-06,
     #    -.2078D-06, -.3719D-06, -.6666D-06, -.1197D-05, -.2152D-05,
     #    -.3872D-05, -.6957D-05, -.1244D-04, -.2200D-04, -.3819D-04,
     #    -.6430D-04, -.1036D-03, -.1575D-03, -.2229D-03, -.2921D-03,
     #    -.3546D-03, -.4019D-03, -.4306D-03, -.4414D-03, -.4377D-03,
     #    -.4239D-03, -.4045D-03, -.3831D-03, -.3622D-03, -.3436D-03,
     #    -.3279D-03, -.3150D-03, -.3048D-03, -.2970D-03, -.2910D-03,
     #    -.2866D-03, -.2834D-03, -.2810D-03, -.2792D-03, -.2779D-03,
     #    -.2770D-03, -.2763D-03, -.2759D-03, -.2755D-03, -.2753D-03,
     #    -.2751D-03, -.2750D-03, -.2750D-03, -.2749D-03, -.2749D-03,
     #    -.2749D-03, -.2747D-03, -.2747D-03, -.2747D-03, -.2747D-03,
     #    -.2747D-03/

      data (calcpts(j,11), j = 1,neta) /-.9398D-12, -.1672D-11,
     #    -.2971D-11, -.5285D-11, -.9400D-11, -.1671D-10, -.2972D-10,
     #    -.5287D-10, -.9397D-10, -.1672D-09, -.2974D-09, -.5288D-09,
     #    -.9406D-09, -.1674D-08, -.2976D-08, -.5296D-08, -.9429D-08,
     #    -.1678D-07, -.2989D-07, -.5329D-07, -.9499D-07, -.1696D-06,
     #    -.3032D-06, -.5425D-06, -.9724D-06, -.1746D-05, -.3138D-05,
     #    -.5645D-05, -.1014D-04, -.1812D-04, -.3205D-04, -.5564D-04,
     #    -.9365D-04, -.1509D-03, -.2294D-03, -.3249D-03, -.4258D-03,
     #    -.5171D-03, -.5863D-03, -.6283D-03, -.6441D-03, -.6386D-03,
     #    -.6184D-03, -.5901D-03, -.5586D-03, -.5282D-03, -.5009D-03,
     #    -.4779D-03, -.4591D-03, -.4442D-03, -.4328D-03, -.4240D-03,
     #    -.4177D-03, -.4128D-03, -.4092D-03, -.4067D-03, -.4049D-03,
     #    -.4034D-03, -.4025D-03, -.4019D-03, -.4013D-03, -.4009D-03,
     #    -.4008D-03, -.4005D-03, -.4004D-03, -.4004D-03, -.4003D-03,
     #    -.4003D-03, -.4003D-03, -.4003D-03, -.4001D-03, -.4001D-03,
     #    -.4001D-03/

      data (calcpts(j,12), j = 1,neta) /-.1367D-11, -.2432D-11,
     #    -.4323D-11, -.7688D-11, -.1368D-10, -.2432D-10, -.4324D-10,
     #    -.7692D-10, -.1367D-09, -.2432D-09, -.4326D-09, -.7694D-09,
     #    -.1368D-08, -.2435D-08, -.4329D-08, -.7705D-08, -.1372D-07,
     #    -.2442D-07, -.4349D-07, -.7752D-07, -.1382D-06, -.2467D-06,
     #    -.4409D-06, -.7889D-06, -.1414D-05, -.2539D-05, -.4561D-05,
     #    -.8202D-05, -.1473D-04, -.2632D-04, -.4653D-04, -.8076D-04,
     #    -.1359D-03, -.2191D-03, -.3331D-03, -.4719D-03, -.6188D-03,
     #    -.7518D-03, -.8527D-03, -.9139D-03, -.9369D-03, -.9289D-03,
     #    -.8994D-03, -.8579D-03, -.8121D-03, -.7676D-03, -.7278D-03,
     #    -.6940D-03, -.6664D-03, -.6447D-03, -.6280D-03, -.6152D-03,
     #    -.6057D-03, -.5987D-03, -.5935D-03, -.5898D-03, -.5871D-03,
     #    -.5852D-03, -.5837D-03, -.5828D-03, -.5820D-03, -.5815D-03,
     #    -.5812D-03, -.5810D-03, -.5807D-03, -.5806D-03, -.5806D-03,
     #    -.5804D-03, -.5804D-03, -.5804D-03, -.5803D-03, -.5803D-03,
     #    -.5803D-03/

      data (calcpts(j,13), j = 1,neta) /-.1981D-11, -.3524D-11,
     #    -.6264D-11, -.1114D-10, -.1982D-10, -.3524D-10, -.6266D-10,
     #    -.1115D-09, -.1981D-09, -.3524D-09, -.6269D-09, -.1115D-08,
     #    -.1983D-08, -.3528D-08, -.6273D-08, -.1116D-07, -.1988D-07,
     #    -.3538D-07, -.6301D-07, -.1123D-06, -.2002D-06, -.3573D-06,
     #    -.6386D-06, -.1142D-05, -.2047D-05, -.3674D-05, -.6599D-05,
     #    -.1186D-04, -.2130D-04, -.3803D-04, -.6722D-04, -.1166D-03,
     #    -.1963D-03, -.3164D-03, -.4812D-03, -.6821D-03, -.8951D-03,
     #    -.1088D-02, -.1235D-02, -.1324D-02, -.1357D-02, -.1346D-02,
     #    -.1303D-02, -.1242D-02, -.1175D-02, -.1110D-02, -.1052D-02,
     #    -.1003D-02, -.9628D-03, -.9311D-03, -.9066D-03, -.8881D-03,
     #    -.8742D-03, -.8640D-03, -.8564D-03, -.8509D-03, -.8471D-03,
     #    -.8442D-03, -.8421D-03, -.8406D-03, -.8396D-03, -.8388D-03,
     #    -.8382D-03, -.8378D-03, -.8376D-03, -.8374D-03, -.8373D-03,
     #    -.8372D-03, -.8372D-03, -.8372D-03, -.8370D-03, -.8370D-03,
     #    -.8370D-03/

      data (calcpts(j,14), j = 1,neta) /-.1657D-11, -.2947D-11,
     #    -.5239D-11, -.9317D-11, -.1657D-10, -.2947D-10, -.5241D-10,
     #    -.9322D-10, -.1657D-09, -.2948D-09, -.5244D-09, -.9328D-09,
     #    -.1659D-08, -.2953D-08, -.5253D-08, -.9353D-08, -.1666D-07,
     #    -.2969D-07, -.5295D-07, -.9455D-07, -.1689D-06, -.3026D-06,
     #    -.5433D-06, -.9779D-06, -.1766D-05, -.3201D-05, -.5821D-05,
     #    -.1062D-04, -.1939D-04, -.3528D-04, -.6357D-04, -.1123D-03,
     #    -.1920D-03, -.3125D-03, -.4764D-03, -.6703D-03, -.8629D-03,
     #    -.1016D-02, -.1102D-02, -.1114D-02, -.1061D-02, -.9629D-03,
     #    -.8376D-03, -.7028D-03, -.5715D-03, -.4530D-03, -.3513D-03,
     #    -.2678D-03, -.2010D-03, -.1494D-03, -.1096D-03, -.8020D-04,
     #    -.5869D-04, -.4239D-04, -.3005D-04, -.2184D-04, -.1487D-04,
     #    -.1074D-04, -.7992D-05, -.5163D-05, -.3779D-05, -.2358D-05,
     #    -.2412D-05, -.9490D-06, -.9740D-06, -.9911D-06, -.1003D-05,
     #    -.1011D-05, -.1016D-05, -.1020D-05, -.1022D-05, -.1024D-05,
     #    0.4749D-06/

      data (calcpts(j,15), j = 1,neta) /-.2383D-11, -.4239D-11,
     #    -.7535D-11, -.1340D-10, -.2384D-10, -.4239D-10, -.7538D-10,
     #    -.1341D-09, -.2383D-09, -.4240D-09, -.7543D-09, -.1342D-08,
     #    -.2387D-08, -.4247D-08, -.7555D-08, -.1345D-07, -.2396D-07,
     #    -.4269D-07, -.7612D-07, -.1359D-06, -.2428D-06, -.4347D-06,
     #    -.7800D-06, -.1403D-05, -.2531D-05, -.4584D-05, -.8325D-05,
     #    -.1517D-04, -.2765D-04, -.5023D-04, -.9038D-04, -.1595D-03,
     #    -.2725D-03, -.4437D-03, -.6773D-03, -.9547D-03, -.1232D-02,
     #    -.1454D-02, -.1580D-02, -.1600D-02, -.1527D-02, -.1387D-02,
     #    -.1208D-02, -.1014D-02, -.8254D-03, -.6546D-03, -.5069D-03,
     #    -.3863D-03, -.2900D-03, -.2157D-03, -.1589D-03, -.1161D-03,
     #    -.8367D-04, -.6062D-04, -.4279D-04, -.3042D-04, -.2220D-04,
     #    -.1523D-04, -.1109D-04, -.6831D-05, -.5498D-05, -.4112D-05,
     #    -.2690D-05, -.1243D-05, -.1279D-05, 0.1969D-06, 0.1801D-06,
     #    0.1688D-06, 0.1610D-06, 0.1557D-06, 0.1521D-06, 0.1496D-06,
     #    0.1480D-06/

      data (calcpts(j,16), j = 1,neta) /-.3399D-11, -.6046D-11,
     #    -.1075D-10, -.1911D-10, -.3400D-10, -.6045D-10, -.1075D-09,
     #    -.1912D-09, -.3399D-09, -.6046D-09, -.1076D-08, -.1913D-08,
     #    -.3403D-08, -.6056D-08, -.1077D-07, -.1918D-07, -.3416D-07,
     #    -.6085D-07, -.1085D-06, -.1936D-06, -.3457D-06, -.6187D-06,
     #    -.1110D-05, -.1994D-05, -.3594D-05, -.6499D-05, -.1178D-04,
     #    -.2142D-04, -.3897D-04, -.7064D-04, -.1268D-03, -.2235D-03,
     #    -.3815D-03, -.6215D-03, -.9500D-03, -.1343D-02, -.1738D-02,
     #    -.2058D-02, -.2244D-02, -.2278D-02, -.2180D-02, -.1984D-02,
     #    -.1730D-02, -.1455D-02, -.1185D-02, -.9400D-03, -.7301D-03,
     #    -.5566D-03, -.4177D-03, -.3106D-03, -.2286D-03, -.1670D-03,
     #    -.1211D-03, -.8712D-04, -.6249D-04, -.4462D-04, -.3222D-04,
     #    -.2247D-04, -.1549D-04, -.1134D-04, -.8576D-05, -.5738D-05,
     #    -.4349D-05, -.2924D-05, -.1475D-05, -.1510D-05, -.3433D-07,
     #    -.5058D-07, -.6164D-07, -.6919D-07, -.7433D-07, -.7783D-07,
     #    -.8021D-07/

      data (calcpts(j,17), j = 1,neta) /-.4787D-11, -.8515D-11,
     #    -.1513D-10, -.2692D-10, -.4788D-10, -.8514D-10, -.1514D-09,
     #    -.2693D-09, -.4787D-09, -.8515D-09, -.1515D-08, -.2694D-08,
     #    -.4793D-08, -.8528D-08, -.1517D-07, -.2700D-07, -.4808D-07,
     #    -.8564D-07, -.1526D-06, -.2723D-06, -.4860D-06, -.8692D-06,
     #    -.1557D-05, -.2796D-05, -.5031D-05, -.9081D-05, -.1642D-04,
     #    -.2978D-04, -.5401D-04, -.9761D-04, -.1747D-03, -.3072D-03,
     #    -.5238D-03, -.8536D-03, -.1307D-02, -.1854D-02, -.2411D-02,
     #    -.2869D-02, -.3142D-02, -.3202D-02, -.3074D-02, -.2805D-02,
     #    -.2451D-02, -.2066D-02, -.1687D-02, -.1339D-02, -.1041D-02,
     #    -.7941D-03, -.5972D-03, -.4441D-03, -.3274D-03, -.2390D-03,
     #    -.1742D-03, -.1251D-03, -.8941D-04, -.6469D-04, -.4675D-04,
     #    -.3281D-04, -.2303D-04, -.1752D-04, -.1186D-04, -.9089D-05,
     #    -.6244D-05, -.4851D-05, -.3423D-05, -.1972D-05, -.2006D-05,
     #    -.2029D-05, -.5445D-06, -.5551D-06, -.5624D-06, -.5673D-06,
     #    -.5706D-06/

      data (calcpts(j,18), j = 1,neta) /-.6623D-11, -.1178D-10,
     #    -.2094D-10, -.3724D-10, -.6624D-10, -.1178D-09, -.2095D-09,
     #    -.3726D-09, -.6622D-09, -.1178D-08, -.2096D-08, -.3727D-08,
     #    -.6629D-08, -.1180D-07, -.2098D-07, -.3734D-07, -.6648D-07,
     #    -.1184D-06, -.2109D-06, -.3761D-06, -.6709D-06, -.1199D-05,
     #    -.2146D-05, -.3845D-05, -.6907D-05, -.1244D-04, -.2243D-04,
     #    -.4053D-04, -.7321D-04, -.1317D-03, -.2350D-03, -.4118D-03,
     #    -.7008D-03, -.1142D-02, -.1754D-02, -.2498D-02, -.3268D-02,
     #    -.3914D-02, -.4313D-02, -.4420D-02, -.4261D-02, -.3903D-02,
     #    -.3423D-02, -.2891D-02, -.2365D-02, -.1883D-02, -.1466D-02,
     #    -.1120D-02, -.8425D-03, -.6260D-03, -.4613D-03, -.3363D-03,
     #    -.2443D-03, -.1761D-03, -.1267D-03, -.9088D-04, -.6453D-04,
     #    -.4650D-04, -.3250D-04, -.2268D-04, -.1715D-04, -.1147D-04,
     #    -.8681D-05, -.5828D-05, -.4428D-05, -.2996D-05, -.1543D-05,
     #    -.1574D-05, -.1596D-05, -.1106D-06, -.1206D-06, -.1274D-06,
     #    -.1321D-06/

      data (calcpts(j,19), j = 1,neta) /-.8945D-11, -.1591D-10,
     #    -.2828D-10, -.5030D-10, -.8947D-10, -.1591D-09, -.2829D-09,
     #    -.5032D-09, -.8944D-09, -.1591D-08, -.2830D-08, -.5033D-08,
     #    -.8952D-08, -.1593D-07, -.2832D-07, -.5040D-07, -.8973D-07,
     #    -.1597D-06, -.2845D-06, -.5070D-06, -.9037D-06, -.1613D-05,
     #    -.2883D-05, -.5159D-05, -.9244D-05, -.1660D-04, -.2982D-04,
     #    -.5365D-04, -.9645D-04, -.1727D-03, -.3063D-03, -.5346D-03,
     #    -.9074D-03, -.1478D-02, -.2276D-02, -.3259D-02, -.4296D-02,
     #    -.5189D-02, -.5766D-02, -.5952D-02, -.5774D-02, -.5317D-02,
     #    -.4683D-02, -.3972D-02, -.3259D-02, -.2601D-02, -.2029D-02,
     #    -.1552D-02, -.1170D-02, -.8699D-03, -.6406D-03, -.4682D-03,
     #    -.3407D-03, -.2463D-03, -.1761D-03, -.1264D-03, -.9026D-04,
     #    -.6374D-04, -.4560D-04, -.3302D-04, -.2314D-04, -.1607D-04,
     #    -.1186D-04, -.7561D-05, -.6196D-05, -.3288D-05, -.3351D-05,
     #    -.1894D-05, -.1923D-05, -.4426D-06, -.4561D-06, -.4653D-06,
     #    -.4716D-06/

      data (calcpts(j,20), j = 1,neta) /-.1170D-10, -.2082D-10,
     #    -.3700D-10, -.6581D-10, -.1171D-09, -.2082D-09, -.3702D-09,
     #    -.6584D-09, -.1170D-08, -.2082D-08, -.3703D-08, -.6585D-08,
     #    -.1171D-07, -.2083D-07, -.3704D-07, -.6591D-07, -.1173D-06,
     #    -.2088D-06, -.3717D-06, -.6620D-06, -.1179D-05, -.2102D-05,
     #    -.3752D-05, -.6700D-05, -.1198D-04, -.2143D-04, -.3835D-04,
     #    -.6864D-04, -.1227D-03, -.2182D-03, -.3847D-03, -.6677D-03,
     #    -.1129D-02, -.1837D-02, -.2835D-02, -.4084D-02, -.5432D-02,
     #    -.6633D-02, -.7450D-02, -.7765D-02, -.7596D-02, -.7044D-02,
     #    -.6242D-02, -.5321D-02, -.4385D-02, -.3514D-02, -.2749D-02,
     #    -.2108D-02, -.1592D-02, -.1186D-02, -.8758D-03, -.6405D-03,
     #    -.4661D-03, -.3371D-03, -.2418D-03, -.1739D-03, -.1252D-03,
     #    -.8880D-04, -.6357D-04, -.4528D-04, -.3260D-04, -.2266D-04,
     #    -.1704D-04, -.1280D-04, -.8476D-05, -.7097D-05, -.4179D-05,
     #    -.4235D-05, -.2773D-05, -.2799D-05, -.1316D-05, -.1328D-05,
     #    -.1337D-05/

      data (calcpts(j,21), j = 1,neta) /-.1470D-10, -.2615D-10,
     #    -.4648D-10, -.8267D-10, -.1470D-09, -.2615D-09, -.4650D-09,
     #    -.8270D-09, -.1470D-08, -.2615D-08, -.4651D-08, -.8270D-08,
     #    -.1471D-07, -.2616D-07, -.4651D-07, -.8275D-07, -.1472D-06,
     #    -.2620D-06, -.4661D-06, -.8298D-06, -.1477D-05, -.2630D-05,
     #    -.4687D-05, -.8353D-05, -.1489D-04, -.2656D-04, -.4732D-04,
     #    -.8427D-04, -.1497D-03, -.2644D-03, -.4628D-03, -.7976D-03,
     #    -.1341D-02, -.2177D-02, -.3364D-02, -.4877D-02, -.6552D-02,
     #    -.8101D-02, -.9219D-02, -.9729D-02, -.9619D-02, -.9002D-02,
     #    -.8041D-02, -.6903D-02, -.5723D-02, -.4607D-02, -.3618D-02,
     #    -.2783D-02, -.2107D-02, -.1572D-02, -.1161D-02, -.8494D-03,
     #    -.6165D-03, -.4455D-03, -.3193D-03, -.2288D-03, -.1631D-03,
     #    -.1154D-03, -.8159D-04, -.5760D-04, -.4064D-04, -.2784D-04,
     #    -.1932D-04, -.1364D-04, -.9365D-05, -.5017D-05, -.3620D-05,
     #    -.2190D-05, -.7378D-06, -.7705D-06, 0.7073D-06, 0.6922D-06,
     #    0.6819D-06/

      data (calcpts(j,22), j = 1,neta) /-.1759D-10, -.3128D-10,
     #    -.5560D-10, -.9889D-10, -.1759D-09, -.3128D-09, -.5562D-09,
     #    -.9892D-09, -.1758D-08, -.3127D-08, -.5563D-08, -.9892D-08,
     #    -.1759D-07, -.3129D-07, -.5562D-07, -.9894D-07, -.1760D-06,
     #    -.3130D-06, -.5568D-06, -.9908D-06, -.1762D-05, -.3135D-05,
     #    -.5579D-05, -.9925D-05, -.1765D-04, -.3139D-04, -.5570D-04,
     #    -.9871D-04, -.1743D-03, -.3058D-03, -.5311D-03, -.9085D-03,
     #    -.1518D-02, -.2454D-02, -.3791D-02, -.5520D-02, -.7489D-02,
     #    -.9386D-02, -.1085D-01, -.1162D-01, -.1164D-01, -.1102D-01,
     #    -.9949D-02, -.8618D-02, -.7203D-02, -.5839D-02, -.4611D-02,
     #    -.3563D-02, -.2706D-02, -.2019D-02, -.1505D-02, -.1094D-02,
     #    -.8054D-03, -.5835D-03, -.4158D-03, -.3041D-03, -.2199D-03,
     #    -.1488D-03, -.1064D-03, -.7823D-04, -.4947D-04, -.3531D-04,
     #    -.2088D-04, -.2127D-04, -.6535D-05, -.6716D-05, -.6839D-05,
     #    -.6923D-05, -.6980D-05, -.7019D-05, -.7046D-05, -.7064D-05,
     #    -.7077D-05/

      data (calcpts(j,23), j = 1,neta) /-.1989D-10, -.3537D-10,
     #    -.6287D-10, -.1118D-09, -.1989D-09, -.3536D-09, -.6289D-09,
     #    -.1119D-08, -.1988D-08, -.3536D-08, -.6290D-08, -.1118D-07,
     #    -.1989D-07, -.3537D-07, -.6287D-07, -.1118D-06, -.1989D-06,
     #    -.3537D-06, -.6290D-06, -.1119D-05, -.1988D-05, -.3535D-05,
     #    -.6285D-05, -.1116D-04, -.1982D-04, -.3515D-04, -.6218D-04,
     #    -.1097D-03, -.1928D-03, -.3362D-03, -.5800D-03, -.9849D-03,
     #    -.1634D-02, -.2628D-02, -.4050D-02, -.5913D-02, -.8084D-02,
     #    -.1026D-01, -.1205D-01, -.1313D-01, -.1336D-01, -.1284D-01,
     #    -.1174D-01, -.1028D-01, -.8684D-02, -.7102D-02, -.5651D-02,
     #    -.4397D-02, -.3347D-02, -.2525D-02, -.1869D-02, -.1373D-02,
     #    -.9974D-03, -.7178D-03, -.5217D-03, -.3812D-03, -.2677D-03,
     #    -.1971D-03, -.1401D-03, -.9716D-04, -.6856D-04, -.5451D-04,
     #    -.4015D-04, -.2559D-04, -.1090D-04, -.1110D-04, -.1124D-04,
     #    -.1133D-04, -.1140D-04, 0.3557D-05, 0.3526D-05, 0.3506D-05,
     #    0.3492D-05/

      data (calcpts(j,24), j = 1,neta) /-.2117D-10, -.3765D-10,
     #    -.6691D-10, -.1190D-09, -.2117D-09, -.3764D-09, -.6693D-09,
     #    -.1191D-08, -.2116D-08, -.3763D-08, -.6694D-08, -.1190D-07,
     #    -.2117D-07, -.3765D-07, -.6691D-07, -.1190D-06, -.2116D-06,
     #    -.3763D-06, -.6690D-06, -.1189D-05, -.2113D-05, -.3755D-05,
     #    -.6671D-05, -.1184D-04, -.2099D-04, -.3716D-04, -.6559D-04,
     #    -.1154D-03, -.2020D-03, -.3506D-03, -.6016D-03, -.1015D-02,
     #    -.1674D-02, -.2677D-02, -.4111D-02, -.6001D-02, -.8245D-02,
     #    -.1058D-01, -.1261D-01, -.1398D-01, -.1449D-01, -.1415D-01,
     #    -.1313D-01, -.1167D-01, -.9981D-02, -.8257D-02, -.6636D-02,
     #    -.5198D-02, -.3993D-02, -.3012D-02, -.2240D-02, -.1656D-02,
     #    -.1208D-02, -.8696D-03, -.6294D-03, -.4595D-03, -.3314D-03,
     #    -.2311D-03, -.1593D-03, -.1164D-03, -.8792D-04, -.5893D-04,
     #    -.4462D-04, -.3009D-04, -.1541D-04, -.1563D-04, -.1578D-04,
     #    -.8765D-06, -.9453D-06, -.9923D-06, -.1024D-05, -.1046D-05,
     #    -.1061D-05/

      data (calcpts(j,25), j = 1,neta) /-.2120D-10, -.3770D-10,
     #    -.6701D-10, -.1192D-09, -.2120D-09, -.3770D-09, -.6703D-09,
     #    -.1192D-08, -.2119D-08, -.3769D-08, -.6704D-08, -.1192D-07,
     #    -.2120D-07, -.3770D-07, -.6700D-07, -.1192D-06, -.2119D-06,
     #    -.3767D-06, -.6697D-06, -.1190D-05, -.2114D-05, -.3756D-05,
     #    -.6670D-05, -.1183D-04, -.2096D-04, -.3706D-04, -.6531D-04,
     #    -.1147D-03, -.2003D-03, -.3466D-03, -.5925D-03, -.9958D-03,
     #    -.1634D-02, -.2600D-02, -.3976D-02, -.5792D-02, -.7973D-02,
     #    -.1030D-01, -.1244D-01, -.1402D-01, -.1480D-01, -.1472D-01,
     #    -.1390D-01, -.1256D-01, -.1091D-01, -.9150D-02, -.7443D-02,
     #    -.5897D-02, -.4564D-02, -.3478D-02, -.2601D-02, -.1928D-02,
     #    -.1405D-02, -.1021D-02, -.7362D-03, -.5363D-03, -.3782D-03,
     #    -.2779D-03, -.1911D-03, -.1333D-03, -.8977D-04, -.7579D-04,
     #    -.4648D-04, -.3195D-04, -.1727D-04, -.1749D-04, -.1763D-04,
     #    -.2736D-05, -.2805D-05, -.2852D-05, -.2884D-05, -.2906D-05,
     #    -.2921D-05/

      data (calcpts(j,26), j = 1,neta) /-.2004D-10, -.3564D-10,
     #    -.6335D-10, -.1127D-09, -.2004D-09, -.3564D-09, -.6337D-09,
     #    -.1127D-08, -.2003D-08, -.3563D-08, -.6337D-08, -.1127D-07,
     #    -.2004D-07, -.3564D-07, -.6333D-07, -.1126D-06, -.2003D-06,
     #    -.3561D-06, -.6329D-06, -.1125D-05, -.1998D-05, -.3548D-05,
     #    -.6299D-05, -.1117D-04, -.1978D-04, -.3495D-04, -.6155D-04,
     #    -.1080D-03, -.1883D-03, -.3252D-03, -.5547D-03, -.9297D-03,
     #    -.1520D-02, -.2411D-02, -.3674D-02, -.5339D-02, -.7347D-02,
     #    -.9529D-02, -.1161D-01, -.1327D-01, -.1426D-01, -.1446D-01,
     #    -.1392D-01, -.1280D-01, -.1132D-01, -.9654D-02, -.7973D-02,
     #    -.6401D-02, -.5014D-02, -.3846D-02, -.2905D-02, -.2154D-02,
     #    -.1584D-02, -.1155D-02, -.8390D-03, -.6086D-03, -.4351D-03,
     #    -.3045D-03, -.2176D-03, -.1596D-03, -.1160D-03, -.7199D-04,
     #    -.5764D-04, -.4309D-04, -.2839D-04, -.1359D-04, -.1374D-04,
     #    -.1383D-04, 0.1103D-05, 0.1059D-05, 0.1029D-05, 0.1008D-05,
     #    0.9939D-06/

      data (calcpts(j,27), j = 1,neta) /-.1799D-10, -.3199D-10,
     #    -.5687D-10, -.1011D-09, -.1799D-09, -.3199D-09, -.5688D-09,
     #    -.1012D-08, -.1798D-08, -.3198D-08, -.5689D-08, -.1011D-07,
     #    -.1799D-07, -.3199D-07, -.5685D-07, -.1011D-06, -.1798D-06,
     #    -.3196D-06, -.5680D-06, -.1010D-05, -.1793D-05, -.3184D-05,
     #    -.5652D-05, -.1002D-04, -.1774D-04, -.3134D-04, -.5516D-04,
     #    -.9672D-04, -.1685D-03, -.2908D-03, -.4954D-03, -.8290D-03,
     #    -.1353D-02, -.2141D-02, -.3255D-02, -.4719D-02, -.6487D-02,
     #    -.8424D-02, -.1032D-01, -.1192D-01, -.1301D-01, -.1344D-01,
     #    -.1320D-01, -.1239D-01, -.1116D-01, -.9702D-02, -.8158D-02,
     #    -.6655D-02, -.5287D-02, -.4105D-02, -.3126D-02, -.2348D-02,
     #    -.1730D-02, -.1269D-02, -.9212D-03, -.6598D-03, -.4856D-03,
     #    -.3396D-03, -.2373D-03, -.1792D-03, -.1204D-03, -.9128D-04,
     #    -.6187D-04, -.4727D-04, -.3254D-04, -.1772D-04, -.1785D-04,
     #    -.1794D-04, -.2994D-05, -.3034D-05, -.3061D-05, -.3079D-05,
     #    -.3092D-05/

      data (calcpts(j,28), j = 1,neta) /-.1544D-10, -.2746D-10,
     #    -.4881D-10, -.8681D-10, -.1544D-09, -.2746D-09, -.4882D-09,
     #    -.8684D-09, -.1543D-08, -.2745D-08, -.4883D-08, -.8681D-08,
     #    -.1544D-07, -.2746D-07, -.4879D-07, -.8677D-07, -.1543D-06,
     #    -.2743D-06, -.4875D-06, -.8665D-06, -.1539D-05, -.2733D-05,
     #    -.4850D-05, -.8597D-05, -.1522D-04, -.2688D-04, -.4730D-04,
     #    -.8292D-04, -.1444D-03, -.2491D-03, -.4241D-03, -.7091D-03,
     #    -.1156D-02, -.1827D-02, -.2774D-02, -.4016D-02, -.5514D-02,
     #    -.7162D-02, -.8795D-02, -.1023D-01, -.1131D-01, -.1188D-01,
     #    -.1190D-01, -.1140D-01, -.1049D-01, -.9302D-02, -.7977D-02,
     #    -.6632D-02, -.5359D-02, -.4220D-02, -.3253D-02, -.2462D-02,
     #    -.1836D-02, -.1352D-02, -.9877D-03, -.7146D-03, -.5141D-03,
     #    -.3720D-03, -.2693D-03, -.1809D-03, -.1370D-03, -.9274D-04,
     #    -.6324D-04, -.4859D-04, -.3382D-04, -.1898D-04, -.1909D-04,
     #    -.1916D-04, -.4212D-05, -.4247D-05, -.4270D-05, -.4286D-05,
     #    -.4297D-05/

      data (calcpts(j,29), j = 1,neta) /-.1277D-10, -.2271D-10,
     #    -.4036D-10, -.7178D-10, -.1277D-09, -.2270D-09, -.4037D-09,
     #    -.7180D-09, -.1276D-08, -.2270D-08, -.4037D-08, -.7178D-08,
     #    -.1276D-07, -.2270D-07, -.4034D-07, -.7175D-07, -.1276D-06,
     #    -.2268D-06, -.4031D-06, -.7165D-06, -.1272D-05, -.2259D-05,
     #    -.4010D-05, -.7107D-05, -.1258D-04, -.2222D-04, -.3910D-04,
     #    -.6853D-04, -.1193D-03, -.2058D-03, -.3503D-03, -.5854D-03,
     #    -.9541D-03, -.1507D-02, -.2286D-02, -.3306D-02, -.4536D-02,
     #    -.5889D-02, -.7241D-02, -.8461D-02, -.9428D-02, -.1004D-01,
     #    -.1024D-01, -.1001D-01, -.9412D-02, -.8529D-02, -.7474D-02,
     #    -.6343D-02, -.5227D-02, -.4190D-02, -.3279D-02, -.2512D-02,
     #    -.1892D-02, -.1404D-02, -.1030D-02, -.7499D-03, -.5410D-03,
     #    -.3879D-03, -.2773D-03, -.1976D-03, -.1400D-03, -.9860D-04,
     #    -.6902D-04, -.4830D-04, -.3499D-04, -.2462D-04, -.1721D-04,
     #    -.1127D-04, -.8316D-05, -.5345D-05, -.3864D-05, -.2377D-05,
     #    -.8862D-06/

      data (calcpts(j,30), j = 1,neta) /-.1024D-10, -.1821D-10,
     #    -.3237D-10, -.5758D-10, -.1024D-09, -.1821D-09, -.3238D-09,
     #    -.5760D-09, -.1024D-08, -.1821D-08, -.3239D-08, -.5758D-08,
     #    -.1024D-07, -.1821D-07, -.3236D-07, -.5755D-07, -.1023D-06,
     #    -.1819D-06, -.3234D-06, -.5747D-06, -.1020D-05, -.1812D-05,
     #    -.3216D-05, -.5701D-05, -.1009D-04, -.1782D-04, -.3136D-04,
     #    -.5496D-04, -.9570D-04, -.1650D-03, -.2808D-03, -.4693D-03,
     #    -.7646D-03, -.1207D-02, -.1830D-02, -.2646D-02, -.3629D-02,
     #    -.4710D-02, -.5794D-02, -.6785D-02, -.7601D-02, -.8176D-02,
     #    -.8465D-02, -.8438D-02, -.8102D-02, -.7507D-02, -.6725D-02,
     #    -.5836D-02, -.4914D-02, -.4020D-02, -.3202D-02, -.2493D-02,
     #    -.1900D-02, -.1425D-02, -.1054D-02, -.7710D-03, -.5599D-03,
     #    -.4031D-03, -.2892D-03, -.2062D-03, -.1470D-03, -.1040D-03,
     #    -.7278D-04, -.5201D-04, -.3717D-04, -.2527D-04, -.1784D-04,
     #    -.1189D-04, -.8925D-05, -.5948D-05, -.4463D-05, -.2974D-05,
     #    -.1481D-05/

      data (calcpts(j,31), j = 1,neta) /-.8016D-11, -.1426D-10,
     #    -.2534D-10, -.4507D-10, -.8017D-10, -.1425D-09, -.2535D-09,
     #    -.4509D-09, -.8013D-09, -.1425D-08, -.2535D-08, -.4507D-08,
     #    -.8015D-08, -.1425D-07, -.2533D-07, -.4505D-07, -.8011D-07,
     #    -.1424D-06, -.2531D-06, -.4499D-06, -.7988D-06, -.1419D-05,
     #    -.2518D-05, -.4462D-05, -.7897D-05, -.1395D-04, -.2455D-04,
     #    -.4302D-04, -.7490D-04, -.1291D-03, -.2198D-03, -.3672D-03,
     #    -.5983D-03, -.9443D-03, -.1432D-02, -.2069D-02, -.2837D-02,
     #    -.3682D-02, -.4530D-02, -.5310D-02, -.5966D-02, -.6459D-02,
     #    -.6762D-02, -.6850D-02, -.6712D-02, -.6358D-02, -.5827D-02,
     #    -.5174D-02, -.4456D-02, -.3729D-02, -.3033D-02, -.2404D-02,
     #    -.1863D-02, -.1415D-02, -.1057D-02, -.7793D-03, -.5689D-03,
     #    -.4116D-03, -.2959D-03, -.2112D-03, -.1502D-03, -.1071D-03,
     #    -.7589D-04, -.5357D-04, -.3719D-04, -.2677D-04, -.1933D-04,
     #    -.1336D-04, -.8891D-05, -.5909D-05, -.4421D-05, -.2929D-05,
     #    -.2935D-05/

      data (calcpts(j,32), j = 1,neta) /-.6153D-11, -.1094D-10,
     #    -.1945D-10, -.3459D-10, -.6154D-10, -.1094D-09, -.1946D-09,
     #    -.3461D-09, -.6151D-09, -.1094D-08, -.1946D-08, -.3460D-08,
     #    -.6152D-08, -.1094D-07, -.1944D-07, -.3458D-07, -.6149D-07,
     #    -.1093D-06, -.1943D-06, -.3453D-06, -.6131D-06, -.1089D-05,
     #    -.1932D-05, -.3425D-05, -.6062D-05, -.1071D-04, -.1884D-04,
     #    -.3302D-04, -.5749D-04, -.9912D-04, -.1687D-03, -.2818D-03,
     #    -.4591D-03, -.7246D-03, -.1099D-02, -.1588D-02, -.2176D-02,
     #    -.2824D-02, -.3475D-02, -.4075D-02, -.4586D-02, -.4984D-02,
     #    -.5256D-02, -.5390D-02, -.5373D-02, -.5197D-02, -.4872D-02,
     #    -.4428D-02, -.3905D-02, -.3344D-02, -.2783D-02, -.2254D-02,
     #    -.1778D-02, -.1372D-02, -.1039D-02, -.7750D-03, -.5700D-03,
     #    -.4138D-03, -.2993D-03, -.2144D-03, -.1533D-03, -.1086D-03,
     #    -.7733D-04, -.5347D-04, -.3856D-04, -.2663D-04, -.1917D-04,
     #    -.1320D-04, -.8719D-05, -.5733D-05, -.4242D-05, -.2749D-05,
     #    -.1253D-05/

      data (calcpts(j,33), j = 1,neta) /-.4651D-11, -.8273D-11,
     #    -.1470D-10, -.2615D-10, -.4652D-10, -.8272D-10, -.1471D-09,
     #    -.2616D-09, -.4650D-09, -.8270D-09, -.1471D-08, -.2616D-08,
     #    -.4651D-08, -.8272D-08, -.1470D-07, -.2614D-07, -.4649D-07,
     #    -.8263D-07, -.1469D-06, -.2611D-06, -.4635D-06, -.8232D-06,
     #    -.1461D-05, -.2589D-05, -.4583D-05, -.8095D-05, -.1424D-04,
     #    -.2496D-04, -.4346D-04, -.7493D-04, -.1275D-03, -.2130D-03,
     #    -.3471D-03, -.5478D-03, -.8304D-03, -.1200D-02, -.1645D-02,
     #    -.2134D-02, -.2626D-02, -.3081D-02, -.3469D-02, -.3778D-02,
     #    -.4002D-02, -.4138D-02, -.4179D-02, -.4117D-02, -.3944D-02,
     #    -.3669D-02, -.3314D-02, -.2906D-02, -.2477D-02, -.2054D-02,
     #    -.1656D-02, -.1304D-02, -.1003D-02, -.7573D-03, -.5638D-03,
     #    -.4133D-03, -.3015D-03, -.2165D-03, -.1553D-03, -.1105D-03,
     #    -.7918D-04, -.5679D-04, -.4036D-04, -.2840D-04, -.1944D-04,
     #    -.1496D-04, -.1047D-04, -.7485D-05, -.5992D-05, -.4496D-05,
     #    -.3000D-05/

      data (calcpts(j,34), j = 1,neta) /-.3472D-11, -.6176D-11,
     #    -.1098D-10, -.1952D-10, -.3473D-10, -.6175D-10, -.1098D-09,
     #    -.1953D-09, -.3471D-09, -.6173D-09, -.1098D-08, -.1952D-08,
     #    -.3472D-08, -.6174D-08, -.1097D-07, -.1951D-07, -.3470D-07,
     #    -.6168D-07, -.1096D-06, -.1949D-06, -.3460D-06, -.6145D-06,
     #    -.1091D-05, -.1933D-05, -.3421D-05, -.6042D-05, -.1063D-04,
     #    -.1863D-04, -.3244D-04, -.5593D-04, -.9517D-04, -.1590D-03,
     #    -.2591D-03, -.4089D-03, -.6198D-03, -.8957D-03, -.1228D-02,
     #    -.1593D-02, -.1960D-02, -.2299D-02, -.2591D-02, -.2824D-02,
     #    -.2999D-02, -.3116D-02, -.3176D-02, -.3172D-02, -.3097D-02,
     #    -.2946D-02, -.2724D-02, -.2448D-02, -.2138D-02, -.1816D-02,
     #    -.1499D-02, -.1206D-02, -.9455D-03, -.7251D-03, -.5463D-03,
     #    -.4060D-03, -.2971D-03, -.2164D-03, -.1552D-03, -.1118D-03,
     #    -.7894D-04, -.5651D-04, -.4007D-04, -.2810D-04, -.2063D-04,
     #    -.1464D-04, -.1015D-04, -.7162D-05, -.5667D-05, -.4171D-05,
     #    -.2673D-05/

      data (calcpts(j,35), j = 1,neta) /-.2566D-11, -.4564D-11,
     #    -.8112D-11, -.1443D-10, -.2566D-10, -.4563D-10, -.8115D-10,
     #    -.1443D-09, -.2565D-09, -.4563D-09, -.8115D-09, -.1443D-08,
     #    -.2566D-08, -.4563D-08, -.8110D-08, -.1442D-07, -.2565D-07,
     #    -.4559D-07, -.8103D-07, -.1440D-06, -.2557D-06, -.4541D-06,
     #    -.8060D-06, -.1428D-05, -.2528D-05, -.4466D-05, -.7857D-05,
     #    -.1377D-04, -.2398D-04, -.4134D-04, -.7034D-04, -.1175D-03,
     #    -.1915D-03, -.3022D-03, -.4581D-03, -.6620D-03, -.9073D-03,
     #    -.1177D-02, -.1448D-02, -.1699D-02, -.1915D-02, -.2088D-02,
     #    -.2220D-02, -.2314D-02, -.2371D-02, -.2391D-02, -.2369D-02,
     #    -.2298D-02, -.2174D-02, -.2002D-02, -.1791D-02, -.1559D-02,
     #    -.1320D-02, -.1086D-02, -.8718D-03, -.6811D-03, -.5214D-03,
     #    -.3915D-03, -.2898D-03, -.2121D-03, -.1538D-03, -.1104D-03,
     #    -.7900D-04, -.5655D-04, -.4009D-04, -.2812D-04, -.1914D-04,
     #    -.1315D-04, -.1016D-04, -.7162D-05, -.4166D-05, -.2669D-05,
     #    -.2670D-05/

      data (calcpts(j,36), j = 1,neta) /-.1882D-11, -.3347D-11,
     #    -.5949D-11, -.1058D-10, -.1882D-10, -.3347D-10, -.5951D-10,
     #    -.1058D-09, -.1881D-09, -.3346D-09, -.5951D-09, -.1058D-08,
     #    -.1882D-08, -.3346D-08, -.5947D-08, -.1058D-07, -.1881D-07,
     #    -.3343D-07, -.5942D-07, -.1056D-06, -.1875D-06, -.3330D-06,
     #    -.5911D-06, -.1048D-05, -.1854D-05, -.3275D-05, -.5762D-05,
     #    -.1010D-04, -.1758D-04, -.3032D-04, -.5158D-04, -.8619D-04,
     #    -.1404D-03, -.2216D-03, -.3359D-03, -.4854D-03, -.6654D-03,
     #    -.8633D-03, -.1062D-02, -.1246D-02, -.1404D-02, -.1532D-02,
     #    -.1630D-02, -.1701D-02, -.1749D-02, -.1774D-02, -.1776D-02,
     #    -.1749D-02, -.1688D-02, -.1590D-02, -.1459D-02, -.1301D-02,
     #    -.1129D-02, -.9534D-03, -.7830D-03, -.6264D-03, -.4890D-03,
     #    -.3735D-03, -.2808D-03, -.2075D-03, -.1506D-03, -.1102D-03,
     #    -.7874D-04, -.5628D-04, -.3981D-04, -.2783D-04, -.2034D-04,
     #    -.1435D-04, -.9859D-05, -.6863D-05, -.5366D-05, -.3868D-05,
     #    -.2369D-05/

      data (calcpts(j,37), j = 1,neta) /-.1371D-11, -.2439D-11,
     #    -.4334D-11, -.7709D-11, -.1371D-10, -.2438D-10, -.4336D-10,
     #    -.7711D-10, -.1371D-09, -.2438D-09, -.4336D-09, -.7709D-09,
     #    -.1371D-08, -.2438D-08, -.4333D-08, -.7705D-08, -.1370D-07,
     #    -.2436D-07, -.4329D-07, -.7695D-07, -.1366D-06, -.2426D-06,
     #    -.4306D-06, -.7632D-06, -.1351D-05, -.2386D-05, -.4198D-05,
     #    -.7357D-05, -.1281D-04, -.2209D-04, -.3758D-04, -.6279D-04,
     #    -.1023D-03, -.1614D-03, -.2447D-03, -.3537D-03, -.4847D-03,
     #    -.6290D-03, -.7738D-03, -.9079D-03, -.1023D-02, -.1116D-02,
     #    -.1188D-02, -.1241D-02, -.1278D-02, -.1300D-02, -.1310D-02,
     #    -.1304D-02, -.1279D-02, -.1230D-02, -.1155D-02, -.1056D-02,
     #    -.9399D-03, -.8136D-03, -.6854D-03, -.5616D-03, -.4483D-03,
     #    -.3493D-03, -.2664D-03, -.1995D-03, -.1473D-03, -.1075D-03,
     #    -.7764D-04, -.5563D-04, -.3960D-04, -.2821D-04, -.1997D-04,
     #    -.1398D-04, -.9931D-05, -.6934D-05, -.4836D-05, -.3337D-05,
     #    -.2438D-05/

      data (calcpts(j,38), j = 1,neta) /-.9934D-12, -.1767D-11,
     #    -.3141D-11, -.5586D-11, -.9935D-11, -.1767D-10, -.3141D-10,
     #    -.5587D-10, -.9931D-10, -.1766D-09, -.3142D-09, -.5586D-09,
     #    -.9933D-09, -.1767D-08, -.3140D-08, -.5583D-08, -.9929D-08,
     #    -.1765D-07, -.3137D-07, -.5575D-07, -.9899D-07, -.1758D-06,
     #    -.3120D-06, -.5530D-06, -.9787D-06, -.1729D-05, -.3042D-05,
     #    -.5331D-05, -.9282D-05, -.1600D-04, -.2723D-04, -.4550D-04,
     #    -.7412D-04, -.1170D-03, -.1773D-03, -.2563D-03, -.3512D-03,
     #    -.4557D-03, -.5607D-03, -.6578D-03, -.7414D-03, -.8089D-03,
     #    -.8609D-03, -.8995D-03, -.9269D-03, -.9453D-03, -.9557D-03,
     #    -.9577D-03, -.9496D-03, -.9282D-03, -.8901D-03, -.8338D-03,
     #    -.7607D-03, -.6755D-03, -.5835D-03, -.4905D-03, -.4011D-03,
     #    -.3196D-03, -.2487D-03, -.1892D-03, -.1416D-03, -.1043D-03,
     #    -.7596D-04, -.5468D-04, -.3924D-04, -.2785D-04, -.1976D-04,
     #    -.1391D-04, -.9717D-05, -.6869D-05, -.4771D-05, -.3272D-05,
     #    -.2223D-05/

      data (calcpts(j,39), j = 1,neta) /-.7169D-12, -.1275D-11,
     #    -.2266D-11, -.4031D-11, -.7170D-11, -.1275D-10, -.2267D-10,
     #    -.4032D-10, -.7167D-10, -.1275D-09, -.2267D-09, -.4031D-09,
     #    -.7168D-09, -.1275D-08, -.2266D-08, -.4029D-08, -.7165D-08,
     #    -.1274D-07, -.2264D-07, -.4023D-07, -.7144D-07, -.1269D-06,
     #    -.2252D-06, -.3991D-06, -.7063D-06, -.1248D-05, -.2195D-05,
     #    -.3847D-05, -.6698D-05, -.1155D-04, -.1965D-04, -.3283D-04,
     #    -.5349D-04, -.8442D-04, -.1280D-03, -.1849D-03, -.2535D-03,
     #    -.3289D-03, -.4046D-03, -.4747D-03, -.5350D-03, -.5838D-03,
     #    -.6214D-03, -.6493D-03, -.6694D-03, -.6833D-03, -.6921D-03,
     #    -.6963D-03, -.6953D-03, -.6874D-03, -.6703D-03, -.6414D-03,
     #    -.5995D-03, -.5460D-03, -.4838D-03, -.4172D-03, -.3501D-03,
     #    -.2859D-03, -.2275D-03, -.1767D-03, -.1343D-03, -.1003D-03,
     #    -.7396D-04, -.5387D-04, -.3888D-04, -.2779D-04, -.1985D-04,
     #    -.1415D-04, -.9951D-05, -.7103D-05, -.5004D-05, -.3504D-05,
     #    -.2455D-05/

      data (calcpts(j,40), j = 1,neta) /-.5152D-12, -.9164D-12,
     #    -.1629D-11, -.2897D-11, -.5153D-11, -.9162D-11, -.1629D-10,
     #    -.2898D-10, -.5150D-10, -.9160D-10, -.1629D-09, -.2897D-09,
     #    -.5151D-09, -.9162D-09, -.1628D-08, -.2896D-08, -.5149D-08,
     #    -.9153D-08, -.1627D-07, -.2892D-07, -.5134D-07, -.9118D-07,
     #    -.1618D-06, -.2868D-06, -.5076D-06, -.8966D-06, -.1578D-05,
     #    -.2765D-05, -.4814D-05, -.8300D-05, -.1412D-04, -.2360D-04,
     #    -.3844D-04, -.6067D-04, -.9197D-04, -.1329D-03, -.1822D-03,
     #    -.2364D-03, -.2908D-03, -.3412D-03, -.3845D-03, -.4195D-03,
     #    -.4466D-03, -.4667D-03, -.4812D-03, -.4914D-03, -.4982D-03,
     #    -.5023D-03, -.5036D-03, -.5016D-03, -.4949D-03, -.4816D-03,
     #    -.4601D-03, -.4293D-03, -.3903D-03, -.3453D-03, -.2974D-03,
     #    -.2490D-03, -.2031D-03, -.1614D-03, -.1251D-03, -.9502D-04,
     #    -.7088D-04, -.5215D-04, -.3790D-04, -.2726D-04, -.1946D-04,
     #    -.1392D-04, -.9867D-05, -.7018D-05, -.4919D-05, -.3420D-05,
     #    -.2520D-05/

      data (calcpts(j,41), j = 1,neta) /-.3691D-12, -.6564D-12,
     #    -.1167D-11, -.2075D-11, -.3691D-11, -.6563D-11, -.1167D-10,
     #    -.2076D-10, -.3689D-10, -.6562D-10, -.1167D-09, -.2075D-09,
     #    -.3690D-09, -.6563D-09, -.1166D-08, -.2074D-08, -.3689D-08,
     #    -.6557D-08, -.1165D-07, -.2071D-07, -.3678D-07, -.6531D-07,
     #    -.1159D-06, -.2054D-06, -.3636D-06, -.6423D-06, -.1130D-05,
     #    -.1980D-05, -.3448D-05, -.5945D-05, -.1012D-04, -.1690D-04,
     #    -.2754D-04, -.4346D-04, -.6588D-04, -.9520D-04, -.1305D-03,
     #    -.1693D-03, -.2083D-03, -.2444D-03, -.2754D-03, -.3005D-03,
     #    -.3199D-03, -.3343D-03, -.3447D-03, -.3521D-03, -.3572D-03,
     #    -.3605D-03, -.3622D-03, -.3623D-03, -.3602D-03, -.3548D-03,
     #    -.3448D-03, -.3289D-03, -.3064D-03, -.2782D-03, -.2458D-03,
     #    -.2112D-03, -.1768D-03, -.1440D-03, -.1142D-03, -.8838D-04,
     #    -.6709D-04, -.5000D-04, -.3666D-04, -.2661D-04, -.1911D-04,
     #    -.1372D-04, -.9668D-05, -.6819D-05, -.4869D-05, -.3370D-05,
     #    -.2320D-05/

      data (calcpts(j,42), j = 1,neta) /-.2637D-12, -.4690D-12,
     #    -.8337D-12, -.1483D-11, -.2637D-11, -.4689D-11, -.8339D-11,
     #    -.1483D-10, -.2636D-10, -.4689D-10, -.8340D-10, -.1483D-09,
     #    -.2637D-09, -.4689D-09, -.8334D-09, -.1482D-08, -.2636D-08,
     #    -.4685D-08, -.8327D-08, -.1480D-07, -.2628D-07, -.4667D-07,
     #    -.8282D-07, -.1468D-06, -.2598D-06, -.4589D-06, -.8074D-06,
     #    -.1415D-05, -.2464D-05, -.4248D-05, -.7228D-05, -.1208D-04,
     #    -.1967D-04, -.3105D-04, -.4707D-04, -.6802D-04, -.9323D-04,
     #    -.1210D-03, -.1488D-03, -.1746D-03, -.1968D-03, -.2147D-03,
     #    -.2286D-03, -.2389D-03, -.2463D-03, -.2516D-03, -.2553D-03,
     #    -.2578D-03, -.2593D-03, -.2600D-03, -.2596D-03, -.2577D-03,
     #    -.2536D-03, -.2462D-03, -.2345D-03, -.2182D-03, -.1978D-03,
     #    -.1746D-03, -.1499D-03, -.1253D-03, -.1018D-03, -.8068D-04,
     #    -.6239D-04, -.4724D-04, -.3525D-04, -.2580D-04, -.1875D-04,
     #    -.1350D-04, -.9603D-05, -.6754D-05, -.4804D-05, -.3455D-05,
     #    -.2405D-05/

      data (calcpts(j,43), j = 1,neta) /-.1880D-12, -.3343D-12,
     #    -.5942D-12, -.1057D-11, -.1880D-11, -.3342D-11, -.5944D-11,
     #    -.1057D-10, -.1879D-10, -.3342D-10, -.5944D-10, -.1057D-09,
     #    -.1879D-09, -.3342D-09, -.5940D-09, -.1056D-08, -.1878D-08,
     #    -.3339D-08, -.5935D-08, -.1055D-07, -.1873D-07, -.3326D-07,
     #    -.5903D-07, -.1046D-06, -.1852D-06, -.3271D-06, -.5755D-06,
     #    -.1009D-05, -.1756D-05, -.3028D-05, -.5152D-05, -.8608D-05,
     #    -.1402D-04, -.2213D-04, -.3355D-04, -.4848D-04, -.6645D-04,
     #    -.8622D-04, -.1061D-03, -.1245D-03, -.1403D-03, -.1530D-03,
     #    -.1629D-03, -.1703D-03, -.1756D-03, -.1794D-03, -.1820D-03,
     #    -.1838D-03, -.1850D-03, -.1857D-03, -.1859D-03, -.1854D-03,
     #    -.1838D-03, -.1807D-03, -.1753D-03, -.1668D-03, -.1550D-03,
     #    -.1404D-03, -.1238D-03, -.1061D-03, -.8858D-04, -.7196D-04,
     #    -.5695D-04, -.4401D-04, -.3330D-04, -.2475D-04, -.1815D-04,
     #    -.1320D-04, -.9453D-05, -.6753D-05, -.4804D-05, -.3304D-05,
     #    -.2404D-05/

      data (calcpts(j,44), j = 1,neta) /-.1337D-12, -.2377D-12,
     #    -.4225D-12, -.7515D-12, -.1337D-11, -.2377D-11, -.4227D-11,
     #    -.7518D-11, -.1336D-10, -.2376D-10, -.4227D-10, -.7516D-10,
     #    -.1336D-09, -.2377D-09, -.4224D-09, -.7512D-09, -.1336D-08,
     #    -.2374D-08, -.4220D-08, -.7501D-08, -.1332D-07, -.2365D-07,
     #    -.4198D-07, -.7440D-07, -.1317D-06, -.2326D-06, -.4092D-06,
     #    -.7172D-06, -.1249D-05, -.2153D-05, -.3664D-05, -.6121D-05,
     #    -.9972D-05, -.1574D-04, -.2386D-04, -.3448D-04, -.4726D-04,
     #    -.6132D-04, -.7544D-04, -.8851D-04, -.9975D-04, -.1088D-03,
     #    -.1159D-03, -.1211D-03, -.1249D-03, -.1276D-03, -.1294D-03,
     #    -.1307D-03, -.1316D-03, -.1322D-03, -.1325D-03, -.1324D-03,
     #    -.1320D-03, -.1308D-03, -.1285D-03, -.1245D-03, -.1184D-03,
     #    -.1099D-03, -.9945D-04, -.8755D-04, -.7500D-04, -.6253D-04,
     #    -.5075D-04, -.4011D-04, -.3097D-04, -.2341D-04, -.1738D-04,
     #    -.1273D-04, -.9203D-05, -.6594D-05, -.4704D-05, -.3324D-05,
     #    -.2349D-05/

      data (calcpts(j,45), j = 1,neta) /-.9491D-13, -.1688D-12,
     #    -.3000D-12, -.5336D-12, -.9492D-12, -.1688D-11, -.3001D-11,
     #    -.5338D-11, -.9488D-11, -.1687D-10, -.3001D-10, -.5337D-10,
     #    -.9489D-10, -.1688D-09, -.2999D-09, -.5334D-09, -.9485D-09,
     #    -.1686D-08, -.2997D-08, -.5326D-08, -.9457D-08, -.1680D-07,
     #    -.2981D-07, -.5283D-07, -.9350D-07, -.1652D-06, -.2906D-06,
     #    -.5093D-06, -.8867D-06, -.1529D-05, -.2601D-05, -.4347D-05,
     #    -.7081D-05, -.1118D-04, -.1694D-04, -.2448D-04, -.3355D-04,
     #    -.4354D-04, -.5356D-04, -.6285D-04, -.7083D-04, -.7728D-04,
     #    -.8226D-04, -.8597D-04, -.8866D-04, -.9058D-04, -.9192D-04,
     #    -.9285D-04, -.9349D-04, -.9391D-04, -.9416D-04, -.9426D-04,
     #    -.9416D-04, -.9377D-04, -.9288D-04, -.9118D-04, -.8830D-04,
     #    -.8390D-04, -.7785D-04, -.7036D-04, -.6189D-04, -.5297D-04,
     #    -.4413D-04, -.3577D-04, -.2826D-04, -.2180D-04, -.1647D-04,
     #    -.1223D-04, -.8957D-05, -.6482D-05, -.4652D-05, -.3317D-05,
     #    -.2357D-05/

      data (calcpts(j,46), j = 1,neta) /-.6725D-13, -.1196D-12,
     #    -.2126D-12, -.3781D-12, -.6726D-12, -.1196D-11, -.2127D-11,
     #    -.3782D-11, -.6723D-11, -.1196D-10, -.2127D-10, -.3781D-10,
     #    -.6724D-10, -.1196D-09, -.2125D-09, -.3779D-09, -.6721D-09,
     #    -.1195D-08, -.2123D-08, -.3774D-08, -.6701D-08, -.1190D-07,
     #    -.2112D-07, -.3743D-07, -.6625D-07, -.1170D-06, -.2059D-06,
     #    -.3609D-06, -.6283D-06, -.1083D-05, -.1843D-05, -.3080D-05,
     #    -.5017D-05, -.7918D-05, -.1200D-04, -.1735D-04, -.2378D-04,
     #    -.3085D-04, -.3795D-04, -.4453D-04, -.5019D-04, -.5476D-04,
     #    -.5829D-04, -.6092D-04, -.6282D-04, -.6418D-04, -.6513D-04,
     #    -.6579D-04, -.6625D-04, -.6655D-04, -.6675D-04, -.6686D-04,
     #    -.6688D-04, -.6678D-04, -.6647D-04, -.6581D-04, -.6457D-04,
     #    -.6250D-04, -.5934D-04, -.5502D-04, -.4969D-04, -.4366D-04,
     #    -.3733D-04, -.3106D-04, -.2517D-04, -.1986D-04, -.1530D-04,
     #    -.1155D-04, -.8567D-05, -.6258D-05, -.4533D-05, -.3243D-05,
     #    -.2313D-05/

      data (calcpts(j,47), j = 1,neta) /-.4757D-13, -.8461D-13,
     #    -.1504D-12, -.2675D-12, -.4758D-12, -.8460D-12, -.1504D-11,
     #    -.2676D-11, -.4756D-11, -.8458D-11, -.1504D-10, -.2675D-10,
     #    -.4757D-10, -.8460D-10, -.1503D-09, -.2674D-09, -.4755D-09,
     #    -.8451D-09, -.1502D-08, -.2670D-08, -.4740D-08, -.8419D-08,
     #    -.1494D-07, -.2648D-07, -.4687D-07, -.8278D-07, -.1457D-06,
     #    -.2553D-06, -.4445D-06, -.7663D-06, -.1304D-05, -.2179D-05,
     #    -.3549D-05, -.5602D-05, -.8492D-05, -.1227D-04, -.1682D-04,
     #    -.2182D-04, -.2685D-04, -.3150D-04, -.3550D-04, -.3874D-04,
     #    -.4123D-04, -.4309D-04, -.4444D-04, -.4540D-04, -.4608D-04,
     #    -.4654D-04, -.4687D-04, -.4709D-04, -.4723D-04, -.4733D-04,
     #    -.4737D-04, -.4736D-04, -.4726D-04, -.4703D-04, -.4654D-04,
     #    -.4565D-04, -.4416D-04, -.4190D-04, -.3882D-04, -.3503D-04,
     #    -.3075D-04, -.2629D-04, -.2185D-04, -.1768D-04, -.1394D-04,
     #    -.1073D-04, -.8092D-05, -.5992D-05, -.4372D-05, -.3157D-05,
     #    -.2257D-05/

      data (calcpts(j,48), j = 1,neta) /-.3361D-13, -.5979D-13,
     #    -.1063D-12, -.1890D-12, -.3362D-12, -.5977D-12, -.1063D-11,
     #    -.1891D-11, -.3360D-11, -.5976D-11, -.1063D-10, -.1890D-10,
     #    -.3361D-10, -.5977D-10, -.1062D-09, -.1889D-09, -.3359D-09,
     #    -.5971D-09, -.1061D-08, -.1886D-08, -.3349D-08, -.5948D-08,
     #    -.1056D-07, -.1871D-07, -.3312D-07, -.5849D-07, -.1029D-06,
     #    -.1804D-06, -.3141D-06, -.5415D-06, -.9213D-06, -.1539D-05,
     #    -.2508D-05, -.3958D-05, -.6000D-05, -.8671D-05, -.1188D-04,
     #    -.1542D-04, -.1897D-04, -.2226D-04, -.2509D-04, -.2737D-04,
     #    -.2914D-04, -.3045D-04, -.3140D-04, -.3208D-04, -.3256D-04,
     #    -.3289D-04, -.3311D-04, -.3327D-04, -.3338D-04, -.3345D-04,
     #    -.3349D-04, -.3350D-04, -.3348D-04, -.3341D-04, -.3323D-04,
     #    -.3288D-04, -.3224D-04, -.3117D-04, -.2956D-04, -.2737D-04,
     #    -.2468D-04, -.2165D-04, -.1849D-04, -.1536D-04, -.1242D-04,
     #    -.9778D-05, -.7528D-05, -.5668D-05, -.4198D-05, -.3058D-05,
     #    -.2218D-05/

      data (calcpts(j,49), j = 1,neta) /-.2372D-13, -.4218D-13,
     #    -.7498D-13, -.1334D-12, -.2372D-12, -.4218D-12, -.7500D-12,
     #    -.1334D-11, -.2371D-11, -.4217D-11, -.7501D-11, -.1334D-10,
     #    -.2371D-10, -.4218D-10, -.7495D-10, -.1333D-09, -.2370D-09,
     #    -.4213D-09, -.7489D-09, -.1331D-08, -.2363D-08, -.4197D-08,
     #    -.7449D-08, -.1320D-07, -.2337D-07, -.4127D-07, -.7262D-07,
     #    -.1273D-06, -.2216D-06, -.3821D-06, -.6501D-06, -.1086D-05,
     #    -.1770D-05, -.2793D-05, -.4234D-05, -.6118D-05, -.8385D-05,
     #    -.1088D-04, -.1339D-04, -.1571D-04, -.1770D-04, -.1931D-04,
     #    -.2056D-04, -.2149D-04, -.2216D-04, -.2264D-04, -.2297D-04,
     #    -.2320D-04, -.2337D-04, -.2348D-04, -.2355D-04, -.2360D-04,
     #    -.2364D-04, -.2365D-04, -.2366D-04, -.2363D-04, -.2358D-04,
     #    -.2345D-04, -.2319D-04, -.2273D-04, -.2197D-04, -.2083D-04,
     #    -.1927D-04, -.1737D-04, -.1523D-04, -.1299D-04, -.1078D-04,
     #    -.8717D-05, -.6857D-05, -.5267D-05, -.3962D-05, -.2942D-05,
     #    -.2147D-05/

      data (dlaeta(j), j = 1,neta) /
     # -6d0, -5.83333333d0, -5.66666667d0, -5.5d0, -5.33333333d0,
     # -5.16666667d0, -5d0, -4.83333333d0, -4.66666667d0, -4.5d0, 
     # -4.33333333d0, -4.16666667d0, -4d0, -3.83333333d0, 
     # -3.66666667d0, -3.5d0, -3.33333333d0, -3.16666667d0, -3d0, 
     # -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0,
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0, 5.16666667d0, 
     #  5.33333333d0, 5.5d0, 5.66666667d0, 5.83333333d0, 6d0/

      data (dlaxi(j), j = 1,nxi) /
     # -3d0, -2.83333333d0, -2.66666667d0, -2.5d0, -2.33333333d0,
     # -2.16666667d0, -2d0, -1.83333333d0, -1.66666667d0, -1.5d0, 
     # -1.33333333d0, -1.16666667d0, -1d0, -0.83333333d0, -0.66666667d0, 
     # -0.5d0, -0.33333333d0, -0.16666667d0, 0d0, 0.16666667d0, 
     #  0.33333333d0, 0.5d0, 0.66666667d0, 0.83333333d0, 1d0, 
     #  1.16666667d0, 1.33333333d0, 1.5d0, 1.66666667d0, 1.83333333d0,
     #  2d0, 2.16666667d0, 2.33333333d0, 2.5d0, 2.66666667d0,
     #  2.83333333d0, 3d0, 3.16666667d0, 3.33333333d0, 3.5d0, 
     #  3.66666667d0, 3.83333333d0, 4d0, 4.16666667d0, 4.33333333d0, 
     #  4.5d0, 4.66666667d0, 4.83333333d0, 5d0/

      dleta = dlog10(eta)
      dlxi = dlog10(xi)
      if (dlxi .le. dlaxi(1)) dlxi = dlaxi(1)
      if (dlxi .ge. dlaxi(nxi)) dlxi = dlaxi(nxi)
      if (dleta .ge. dlaeta(neta)) dleta = dlaeta(neta)
      if (dleta .le. dlaeta(1)) dleta = dlaeta(1)
      call locate(dlaeta,neta, dleta, ieta)
      call locate(dlaxi, nxi, dlxi, ixi)
c     interpolating between the appropriate points
      delxi = 1d0/6d0
      deleta = 1d0/6d0
c  lagrange 3-pt.
      if (ixi .le. 2) ixi = 2
      if (ixi .ge. 48) ixi = 48
      if (ieta .le. 2) ieta = 2
      if (ieta .ge. 72) ieta = 72
      pxi = (dlxi - dlaxi(ixi))/delxi
      f(-1) = pxi*(pxi-1d0)/2d0*calcpts(ieta-1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta-1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta-1,ixi+1)
      f(0) = pxi*(pxi-1d0)/2d0*calcpts(ieta,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta,ixi+1)
      f(1) = pxi*(pxi-1d0)/2d0*calcpts(ieta+1,ixi-1) +
     #     (1d0 - pxi**2)*calcpts(ieta+1,ixi) +
     #     pxi*(pxi+1d0)/2d0*calcpts(ieta+1,ixi+1)
      peta = (dleta - dlaeta(ieta))/deleta
      h1_HLq = peta*(peta-1d0)/2d0*f(-1) +
     #     (1d0 - peta**2)*f(0) +
CMB  #     + peta*(peta+1d0)/2d0*f(1)
     #     peta*(peta+1d0)/2d0*f(1)
      return
      end

c     ===========================================
      double precision function h1bar_HLq(eta,xi)
c     ===========================================

c     eq (27) in PLB347 (1995) 143 - 151 for the transverse piece
c     MSbar scheme
c     This routine is called subcqhlbar in the original code.
c     Called sqlbar in updated code (03/06/96).

      implicit none
      integer neta, nxi
      parameter (neta = 73, nxi = 49)
      double precision calcpts(neta, nxi), dlaeta(neta), dlaxi(nxi)
      double precision eta, xi, dleta, dlxi
      double precision pxi, peta, f(-1:1), delxi, deleta
      integer j, ieta, ixi

      data (calcpts(j, 1), j = 1,neta) /0.7071D-14, 0.1258D-13,
     #    0.2235D-13, 0.3975D-13, 0.7071D-13, 0.1257D-12, 0.2236D-12,
     #    0.3977D-12, 0.7068D-12, 0.1257D-11, 0.2236D-11, 0.3975D-11,
     #    0.7068D-11, 0.1257D-10, 0.2234D-10, 0.3972D-10, 0.7062D-10,
     #    0.1255D-09, 0.2229D-09, 0.3959D-09, 0.7023D-09, 0.1245D-08,
     #    0.2205D-08, 0.3896D-08, 0.6863D-08, 0.1204D-07, 0.2097D-07,
     #    0.3623D-07, 0.6178D-07, 0.1034D-06, 0.1688D-06, 0.2662D-06,
     #    0.4012D-06, 0.5725D-06, 0.7658D-06, 0.9555D-06, 0.1113D-05,
     #    0.1217D-05, 0.1255D-05, 0.1223D-05, 0.1129D-05, 0.9890D-06,
     #    0.8246D-06, 0.6585D-06, 0.5077D-06, 0.3804D-06, 0.2780D-06,
     #    0.2007D-06, 0.1423D-06, 0.1004D-06, 0.6907D-07, 0.4861D-07,
     #    0.3374D-07, 0.2298D-07, 0.1593D-07, 0.1030D-07, 0.8102D-08,
     #    0.5170D-08, 0.3239D-08, 0.2466D-08, 0.1462D-08, 0.1800D-08,
     #    0.5305D-09, 0.6874D-09, 0.7944D-09, 0.8672D-09, 0.9168D-09,
     #    -.5494D-09, -.5264D-09, -.5107D-09, -.5000D-09, -.4927D-09,
     #    -.4878D-09/

      data (calcpts(j, 2), j = 1,neta) /0.1038D-13, 0.1846D-13,
     #    0.3281D-13, 0.5835D-13, 0.1038D-12, 0.1845D-12, 0.3282D-12,
     #    0.5837D-12, 0.1037D-11, 0.1845D-11, 0.3282D-11, 0.5835D-11,
     #    0.1037D-10, 0.1845D-10, 0.3279D-10, 0.5829D-10, 0.1036D-09,
     #    0.1842D-09, 0.3272D-09, 0.5811D-09, 0.1031D-08, 0.1828D-08,
     #    0.3237D-08, 0.5718D-08, 0.1007D-07, 0.1767D-07, 0.3078D-07,
     #    0.5317D-07, 0.9068D-07, 0.1518D-06, 0.2477D-06, 0.3907D-06,
     #    0.5888D-06, 0.8403D-06, 0.1124D-05, 0.1403D-05, 0.1635D-05,
     #    0.1788D-05, 0.1841D-05, 0.1796D-05, 0.1658D-05, 0.1451D-05,
     #    0.1210D-05, 0.9677D-06, 0.7471D-06, 0.5589D-06, 0.4104D-06,
     #    0.2951D-06, 0.2097D-06, 0.1473D-06, 0.1041D-06, 0.7141D-07,
     #    0.4950D-07, 0.3464D-07, 0.2390D-07, 0.1685D-07, 0.1272D-07,
     #    0.9026D-08, 0.6095D-08, 0.5663D-08, 0.3391D-08, 0.3887D-08,
     #    0.2724D-08, 0.2955D-08, 0.1612D-08, 0.1719D-08, 0.1791D-08,
     #    0.1841D-08, 0.1875D-08, 0.1898D-08, 0.1913D-08, 0.1924D-08,
     #    0.1931D-08/

      data (calcpts(j, 3), j = 1,neta) /0.1522D-13, 0.2708D-13,
     #    0.4812D-13, 0.8559D-13, 0.1522D-12, 0.2707D-12, 0.4814D-12,
     #    0.8562D-12, 0.1522D-11, 0.2706D-11, 0.4814D-11, 0.8559D-11,
     #    0.1522D-10, 0.2706D-10, 0.4809D-10, 0.8551D-10, 0.1520D-09,
     #    0.2701D-09, 0.4799D-09, 0.8524D-09, 0.1512D-08, 0.2681D-08,
     #    0.4748D-08, 0.8388D-08, 0.1478D-07, 0.2592D-07, 0.4515D-07,
     #    0.7800D-07, 0.1330D-06, 0.2226D-06, 0.3633D-06, 0.5731D-06,
     #    0.8638D-06, 0.1233D-05, 0.1649D-05, 0.2058D-05, 0.2397D-05,
     #    0.2621D-05, 0.2701D-05, 0.2633D-05, 0.2429D-05, 0.2126D-05,
     #    0.1772D-05, 0.1416D-05, 0.1091D-05, 0.8163D-06, 0.5969D-06,
     #    0.4288D-06, 0.3029D-06, 0.2122D-06, 0.1470D-06, 0.1055D-06,
     #    0.6832D-07, 0.3893D-07, 0.3458D-07, 0.2684D-07, 0.1679D-07,
     #    0.5163D-08, 0.7463D-08, 0.9030D-08, -.4902D-08, -.4174D-08,
     #    -.3679D-08, -.3341D-08, -.3111D-08, -.2954D-08, -.2847D-08,
     #    -.2774D-08, -.2725D-08, -.2691D-08, -.2668D-08, -.2652D-08,
     #    -.2642D-08/

      data (calcpts(j, 4), j = 1,neta) /0.2234D-13, 0.3973D-13,
     #    0.7061D-13, 0.1256D-12, 0.2234D-12, 0.3972D-12, 0.7063D-12,
     #    0.1256D-11, 0.2233D-11, 0.3971D-11, 0.7063D-11, 0.1256D-10,
     #    0.2233D-10, 0.3971D-10, 0.7057D-10, 0.1255D-09, 0.2231D-09,
     #    0.3964D-09, 0.7042D-09, 0.1251D-08, 0.2219D-08, 0.3934D-08,
     #    0.6967D-08, 0.1231D-07, 0.2168D-07, 0.3803D-07, 0.6626D-07,
     #    0.1145D-06, 0.1952D-06, 0.3267D-06, 0.5332D-06, 0.8410D-06,
     #    0.1268D-05, 0.1809D-05, 0.2420D-05, 0.3020D-05, 0.3519D-05,
     #    0.3848D-05, 0.3965D-05, 0.3865D-05, 0.3568D-05, 0.3128D-05,
     #    0.2606D-05, 0.2084D-05, 0.1606D-05, 0.1202D-05, 0.8735D-06,
     #    0.6284D-06, 0.4504D-06, 0.3150D-06, 0.2217D-06, 0.1508D-06,
     #    0.1093D-06, 0.7222D-07, 0.4284D-07, 0.3850D-07, 0.1576D-07,
     #    0.2071D-07, 0.9091D-08, 0.1139D-07, -.2043D-08, -.9755D-09,
     #    -.2487D-09, 0.2471D-09, 0.5849D-09, 0.8149D-09, 0.9716D-09,
     #    0.1078D-08, 0.1151D-08, 0.1201D-08, 0.1234D-08, 0.1257D-08,
     #    0.1273D-08/

      data (calcpts(j, 5), j = 1,neta) /0.3277D-13, 0.5829D-13,
     #    0.1036D-12, 0.1843D-12, 0.3277D-12, 0.5827D-12, 0.1036D-11,
     #    0.1843D-11, 0.3276D-11, 0.5826D-11, 0.1036D-10, 0.1842D-10,
     #    0.3276D-10, 0.5826D-10, 0.1035D-09, 0.1841D-09, 0.3273D-09,
     #    0.5816D-09, 0.1033D-08, 0.1835D-08, 0.3255D-08, 0.5772D-08,
     #    0.1022D-07, 0.1806D-07, 0.3181D-07, 0.5580D-07, 0.9721D-07,
     #    0.1679D-06, 0.2864D-06, 0.4793D-