.\"
.\" $Id: rfio_fseek.man,v 1.1 2005/03/31 13:13:02 baud Exp $
.\"
.\" @(#)$RCSfile: rfio_fseek.man,v $ $Revision: 1.1 $ $Date: 2005/03/31 13:13:02 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2002 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH RFIO_FSEEK 3 "$Date: 2005/03/31 13:13:02 $" CASTOR "Rfio Library Functions"
.SH NAME
rfio_fseek \- positions/repositions a file
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "int rfio_fseek (FILE *" fp ", long " offset ", int " whence ");"
.sp
Under Linux, for large files:
.br
.B #define _LARGEFILE64_SOURCE
.br
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "int rfio_fseeko64 (FILE *" fp ", off64_t " offset ", int " whence ");"
.br
.sp
For large files, under other systems:
.br
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "int rfio_fseeko64 (FILE *" fp ", off64_t " offset ", int " whence ");"
.SH DESCRIPTION
.B rfio_fseek
positions/repositions to
.I offset
the file associated with the descriptor
.I fp
generated by a previous
.BR rfio_fopen .
.I whence
indicates how to interpret the
.I offset
value:
.RS
.TP 1.3i
.B SEEK_SET
The offset is set from beginning of file.
.TP
.B SEEK_CUR
The offset is added to current position.
.TP
.B SEEK_END
The offset is added to current file size.
.RE
.B rfio_fseeko64
can be used with large files and allows to use a 64 bit offset rather than a long.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
.I fp
is not a valid descriptor.
.TP
.B EINVAL
incorrect value for
.IR whence .
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SETIMEDOUT
Timed out.
.TP
.B SEBADVERSION
Version ID mismatch.
.TP
.B SEINTERNAL
Internal error.
.TP
.B SECONNDROP
Connection closed by remote end.
.TP
.B SECOMERR
Communication error.
.SH SEE ALSO
.BR rfio_fopen(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
