<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.DBInit.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.Authentication.php");

if (!$user->isAdmin()) {
	UI::exitError(getMLText("admin_tools"),getMLText("access_denied"));
}

$action = $_GET["action"];

//Neue Kategorie anlegen -----------------------------------------------------------------------------
if ($action == "addcategory") {

	$name = $_GET["name"];
	if (is_object($dms->getKeywordCategoryByName($name, $user->getID()))) {
		UI::exitError(getMLText("admin_tools"),getMLText("keyword_exists"));
	}
	$newCategory = $dms->addKeywordCategory($user->getID(), $name);
	if (!$newCategory) {
		UI::exitError(getMLText("admin_tools"),getMLText("error_occured"));
	}
	$categoryid=$newCategory->getID();
}

//Kategorie lschen ----------------------------------------------------------------------------------
else if ($action == "removecategory") {

	if (!isset($_GET["categoryid"]) || !is_numeric($_GET["categoryid"]) || intval($_GET["categoryid"])<1) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));
	}
	$categoryid = $_GET["categoryid"];
	$category = $dms->getKeywordCategory($categoryid);
	if (!is_object($category)) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));
	}

	$owner = $category->getOwner();
	if (!$owner->isAdmin()) {
		UI::exitError(getMLText("admin_tools"),getMLText("access_denied"));
	}
	if (!$category->remove()) {
		UI::exitError(getMLText("admin_tools"),getMLText("error_occured"));
	}
	$categoryid=-1;
}

//Kategorie bearbeiten: Neuer Name --------------------------------------------------------------------
else if ($action == "editcategory") {

	if (!isset($_GET["categoryid"]) || !is_numeric($_GET["categoryid"]) || intval($_GET["categoryid"])<1) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));
	}
	$categoryid = $_GET["categoryid"];
	$category = $dms->getKeywordCategory($categoryid);
	if (!is_object($category)) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));
	}

	$owner    = $category->getOwner();
	if (!$owner->isAdmin()) {
		UI::exitError(getMLText("admin_tools"),getMLText("access_denied"));
	}

	$name = $_GET["name"];
	if (!$category->setName($name)) {
		UI::exitError(getMLText("admin_tools"),getMLText("error_occured"));
	}
}

//Kategorie bearbeiten: Neue Stichwortliste  ----------------------------------------------------------
else if ($action == "newkeywords") {
	
	$categoryid = (int) $_GET["categoryid"];
	$category = $dms->getKeywordCategory($categoryid);
	$owner    = $category->getOwner();
	if (!$owner->isAdmin()) {
		UI::exitError(getMLText("admin_tools"),getMLText("access_denied"));
	}

	$keywords = $_GET["keywords"];
	
	if (!$category->addKeywordList($keywords)) {
		UI::exitError(getMLText("admin_tools"),getMLText("error_occured"));
	}
}

//Kategorie bearbeiten: Stichwortliste bearbeiten ----------------------------------------------------------
else if ($action == "editkeywords")
{
	if (!isset($_GET["categoryid"]) || !is_numeric($_GET["categoryid"]) || intval($_GET["categoryid"])<1) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));
	}
	$categoryid = $_GET["categoryid"];
	$category = $dms->getKeywordCategory($categoryid);
	if (!is_object($category)) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));

	}

	$owner    = $category->getOwner();
	if (!$owner->isAdmin()) {
		UI::exitError(getMLText("admin_tools"),getMLText("access_denied"));
	}

	if (!isset($_GET["keywordsid"]) || !is_numeric($_GET["keywordsid"]) || intval($_GET["keywordsid"])<1) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_id"));
	}
	$keywordsid = $_GET["keywordsid"];

	$keywords = $_GET["keywords"];
	if (!$category->editKeywordList($keywordsid, $keywords)) {
		UI::exitError(getMLText("admin_tools"),getMLText("error_occured"));
	}
}

//Kategorie bearbeiten: Neue Stichwortliste lschen ----------------------------------------------------------
else if ($action == "removekeywords") {
	
	if (!isset($_GET["categoryid"]) || !is_numeric($_GET["categoryid"]) || intval($_GET["categoryid"])<1) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));
	}
	$categoryid = $_GET["categoryid"];
	$category = $dms->getKeywordCategory($categoryid);
	if (!is_object($category)) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_keyword_category"));
	}

	$owner    = $category->getOwner();
	if (!$owner->isAdmin()) {
		UI::exitError(getMLText("admin_tools"),getMLText("access_denied"));
	}

	if (!isset($_GET["keywordsid"]) || !is_numeric($_GET["keywordsid"]) || intval($_GET["keywordsid"])<1) {
		UI::exitError(getMLText("admin_tools"),getMLText("unknown_id"));
	}
	$keywordsid = $_GET["keywordsid"];

	if (!$category->removeKeywordList($keywordsid)) {
		UI::exitError(getMLText("admin_tools"),getMLText("error_occured"));
	}
}
else {
	UI::exitError(getMLText("admin_tools"),getMLText("unknown_command"));
}

header("Location:../out/out.DefaultKeywords.php?categoryid=".$categoryid);

?>
