#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gtk
import gobject
import gtkmozembed

from lernid.widgets.Widget import Widget

class Chatroom(Widget):

    __gtype_name__ = 'LernidWebChatroom'

    __gsignals__ = {
        'members-changed': (
            gobject.SIGNAL_RUN_LAST, None, (object,)
        ),
    }

    def __init__(self):
        Widget.__init__(self, 'chatroom')
        scroll = gtk.ScrolledWindow()
        scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self._chat = gtkmozembed.MozEmbed()
        scroll.add_with_viewport(self._chat)
        self.add(scroll)

        self._chat.add_events(gtk.gdk.ENTER_NOTIFY_MASK)
        self._chat.props.can_focus = True
        def get_focus(chat, event):
            chat.grab_focus()
        self._chat.connect('enter-notify-event', get_focus)

    def do_event_connect(self, event_man, event):
        chatirc = 'http://webchat.freenode.net/?nick={nick}&channels={chans}'.format(
                nick=event.nick, chans=event.chat)
        self._chat.load_url(chatirc)
        self._chat.show()

    def do_event_disconnect(self, event_man, event):
        self._chat.load_url('about:blank')
        self._chat.hide()

    def get_input_widget(self):
        return self._chat
