/***************************************************************************
 *   Copyright (C) 2007 by Miguel Chavez Gamboa                            *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *   SHA code from kde kwallet                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include "hash.h"

#include "sha1.h"
#include <assert.h>

#include <QString>
#include <QByteArray>
#include <QFile>
#include <QTextStream>
#include <QRegExp>

QByteArray Hash::getSalt()
{
  QString result="";
  QFile file("/dev/random");
  //FIXME: Still some problems when obtaining the salt. some strage chars appearing... fix this regexp
  QRegExp rx("([\\w+]|[\\s*&*%*\\$*#*!*=*¡*\\(*\\)*\\?*\\¿*\\[*\\]*\\{*\\}*\\/*])");
  int cont=0;
  rx.setCaseSensitivity(Qt::CaseInsensitive);
  if (file.open(QIODevice::ReadOnly | QIODevice::Text))
  {
    QTextStream in(&file);
    while (cont<5) {
      QString data = in.readLine(1);
      if (!data.isNull()) {
        //if ( rx.indexIn(data) !=-1 )
        if (data.contains(rx))
        {
          result+=data;
          cont++;
        }
      }
    }
    file.close();
  }
  result.resize(5);
  return result.toLocal8Bit();
}


//from Kwalletbackend.
// this should be SHA-512 for release probably
QString Hash::password2hash(const QByteArray& password) {
  SHA1 sha;
  QByteArray hash;
  hash.resize(20);
  hash.fill(0);
  int shasz = sha.size() / 8;

  assert(shasz >= 20);

  QByteArray block1(shasz, 0);

  sha.process(password.data(), qMin(password.size(), 16));

  // To make brute force take longer
  for (int i = 0; i < 2000; i++) {
    memcpy(block1.data(), sha.hash(), shasz);
    sha.reset();
    sha.process(block1.data(), shasz);
  }

  sha.reset();

  if (password.size() > 16) {
    sha.process(password.data() + 16, qMin(password.size() - 16, 16));
    QByteArray block2(shasz, 0);
    // To make brute force take longer
    for (int i = 0; i < 2000; i++) {
      memcpy(block2.data(), sha.hash(), shasz);
      sha.reset();
      sha.process(block2.data(), shasz);
    }

    sha.reset();

    if (password.size() > 32) {
      sha.process(password.data() + 32, qMin(password.size() - 32, 16));

      QByteArray block3(shasz, 0);
      // To make brute force take longer
      for (int i = 0; i < 2000; i++) {
        memcpy(block3.data(), sha.hash(), shasz);
        sha.reset();
        sha.process(block3.data(), shasz);
      }

      sha.reset();

      if (password.size() > 48) {
        sha.process(password.data() + 48, password.size() - 48);

        QByteArray block4(shasz, 0);
        // To make brute force take longer
        for (int i = 0; i < 2000; i++) {
          memcpy(block4.data(), sha.hash(), shasz);
          sha.reset();
          sha.process(block4.data(), shasz);
        }

        sha.reset();
        // split 14/14/14/14
        hash.resize(56);
        memcpy(hash.data(),      block1.data(), 14);
        memcpy(hash.data() + 14, block2.data(), 14);
        memcpy(hash.data() + 28, block3.data(), 14);
        memcpy(hash.data() + 42, block4.data(), 14);
        block4.fill(0);
      } else {
        // split 20/20/16
        hash.resize(56);
        memcpy(hash.data(),      block1.data(), 20);
        memcpy(hash.data() + 20, block2.data(), 20);
        memcpy(hash.data() + 40, block3.data(), 16);
      }
      block3.fill(0);
    } else {
      // split 20/20
      hash.resize(40);
      memcpy(hash.data(),      block1.data(), 20);
      memcpy(hash.data() + 20, block2.data(), 20);
    }
    block2.fill(0);
  } else {
    // entirely block1
    hash.resize(20);
    memcpy(hash.data(), block1.data(), 20);
  }

  block1.fill(0);
  //MCH: to store hash as a String...
  QString output, tmp;
  unsigned char *digest;
  digest = (unsigned char*) hash.data();
  for (int i = 0; i < 20; ++i)
    output += tmp.sprintf("%02x", digest[i]);
  output = output.toUpper();

  return output;
}
