/***************************************************************************
 *   Copyright (C) 2007 by Miguel Chavez Gamboa                            *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include <KLocale>
#include <KMessageBox>
#include <KFileDialog>

#include <QByteArray>

#include "promoeditor.h"

PromoEditorUI::PromoEditorUI( QWidget *parent )
: QFrame( parent )
{
    setupUi( this );
}

PromoEditor::PromoEditor( QWidget *parent )
: KDialog( parent )
{
    ui = new PromoEditorUI( this );
    setMainWidget( ui );
    setCaption( i18n("Discounts Editor") );
    setButtons( KDialog::Ok|KDialog::Cancel );

    connect( ui->spinboxDiscount, SIGNAL(valueChanged(const QString &)),this, SLOT(checkValid()) );

    QTimer::singleShot(750, this, SLOT(checkValid()));
}

PromoEditor::~PromoEditor()
{
    delete ui;
}

void PromoEditor::setDb(QSqlDatabase database)
{
  db = database;
  if (!db.isOpen()) db.open();
  populateProductsCombo();
}

void PromoEditor::populateProductsCombo()
{
  QSqlQuery query(db);
  if (query.exec("select code,name from products;")) {
    while (query.next()) {
      int fieldId   = query.record().indexOf("code");
      int fieldText = query.record().indexOf("name");
      qulonglong id = query.value(fieldId).toULongLong();
      QString text = query.value(fieldText).toString();
      ui->comboAffectProduct->addItem(text);
      qDebug()<<text<<":"<<id;
    }
  }
  else {
    qDebug()<<"ERROR: "<<query.lastError();
  }
}


//FIXME: How to detect when a product does not exists? code=-1, but here codes are unsigned, to allow a broader range.
qulonglong PromoEditor::getSelectedProductCode()
{
  QSqlQuery query(db);
  qulonglong code=0;
  QString currentText = ui->comboAffectProduct->currentText();
  if (query.exec("select code,name from products;")) {
    while (query.next() && (code == 0)) { //NOTE: We assume there are no products with number 0.
      int fieldId   = query.record().indexOf("code");
      int fieldText = query.record().indexOf("name");
      qulonglong id = query.value(fieldId).toULongLong();
      QString text = query.value(fieldText).toString();
      if (text == currentText) {
        code = id;
        qDebug()<<"Found!";
      } else qDebug()<<"still searching | "<<text;
    }
  }
  else {
    qDebug()<<"ERROR: "<<query.lastError();
  }
  return code;
}


void PromoEditor::checkValid()
{
  if (ui->spinboxDiscount->value() > 0.0 ) enableButtonOk(true);
  else enableButtonOk(false);
}

#include "promoeditor.moc"
