# Miguel Chavez Gamboa, 2007
# run this as: cat lemon_mysql.sql | mysql -u root -p

CREATE DATABASE lemondb;
USE lemondb;

#itemlist must be bigger...
CREATE TABLE `transactions` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `clientid` int(10) unsigned NOT NULL,
  `type` smallint(5) unsigned default NULL,
  `amount` double unsigned NOT NULL default '0',
  `day` int(10) NOT NULL default '0',
  `month` int(10) NOT NULL default '0',
  `year` int(10) NOT NULL default '0',
  `hour` int(10) NOT NULL default '0',
  `minute` int(10) NOT NULL default '0',
  `paidwith` double unsigned NOT NULL default '0.0',
  `changegiven` double unsigned NOT NULL default '0.0',
  `paymethod` int(10) NOT NULL default '0',
  `state` int(10) NOT NULL default '0',
  `userid` int(10) NOT NULL default '0',
  `cardnumber` varchar(20) character set utf8 collate utf8_spanish_ci,
  `itemcount` int(10) unsigned NOT NULL default '0',
  `itemslist` varchar(250) character set utf8 collate utf8_spanish_ci NOT NULL,
  `points` bigint(20) unsigned NOT NULL default '0',
  `discmoney` double NOT NULL default '0',
  `disc` double NOT NULL default '0',
  `cardauthnumber` varchar(50) character set utf8 collate utf8_spanish_ci NOT NULL,
  `utility` double NOT NULL default '0',
  `terminalnum` int(10) unsigned NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;


CREATE TABLE `products` (
  `code` bigint(20) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL collate utf8_spanish_ci default 'unknown',
  `price` double unsigned NOT NULL default '0.0',
  `stockqty` double unsigned NOT NULL default '0',
  `cost` double unsigned NOT NULL default '0',
  `soldunits` double unsigned NOT NULL default '0',
  `datelastsold` varchar(10) collate utf8_spanish_ci NOT NULL default '--NA--',
  `units` int(10) unsigned collate utf8_spanish_ci NOT NULL default '0',
  `taxpercentage` double unsigned NOT NULL default '15',
  `extrataxes` double unsigned NOT NULL default '0',
  `photo` blob default NULL,
  `category` int(10) unsigned NOT NULL default 0,
  `points` INT(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY  (`code`),
  KEY `SEC` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

CREATE TABLE `offers` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `discount` double NOT NULL,
  `validuntilday` int(10) unsigned NOT NULL,
  `validuntilmonth` int(10) unsigned NOT NULL,
  `validuntilyear` int(10) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

CREATE TABLE `measures` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `text` varchar(50) character set utf8 collate utf8_spanish2_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

CREATE TABLE `balances` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `datetime_start` varchar(50) collate utf8_spanish_ci NOT NULL,
  `datetime_end` varchar(50) collate utf8_spanish_ci NOT NULL,
  `userid` bigint(20) unsigned NOT NULL,
  `usern` varchar(50) collate utf8_spanish_ci NOT NULL,
  `initamount` double NOT NULL,
  `in` double NOT NULL,
  `out` double NOT NULL,
  `cash` double NOT NULL,
  `card` double NOT NULL,
  `transactions` varchar(250) collate utf8_spanish_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

CREATE TABLE `categories` (
  `catid` int(10) unsigned NOT NULL auto_increment,
  `text` varchar(50) character set utf8 collate utf8_spanish2_ci NOT NULL,
  PRIMARY KEY  (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `username` varchar(50) collate utf8_spanish_ci NOT NULL default '',
  `password` varchar(50) collate utf8_spanish_ci default NULL,
  `salt` varchar(5) collate utf8_spanish_ci default NULL,
  `name` varchar(100) collate utf8_spanish_ci default NULL,
  `address` varchar(255) collate utf8_spanish_ci default NULL,
  `phone` varchar(50) character set utf8 collate utf8_spanish2_ci default NULL,
  `phone_movil` varchar(50) collate utf8_spanish_ci default NULL,
  `role` int(10) unsigned default '0',
  `photo` blob default NULL,
  PRIMARY KEY  USING BTREE (`id`,`username`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

CREATE TABLE `clients` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `name` varchar(100) collate utf8_spanish_ci default NULL,
  `address` varchar(255) collate utf8_spanish_ci default NULL,
  `phone` varchar(50) character set utf8 collate utf8_spanish2_ci default NULL,
  `phone_movil` varchar(50) collate utf8_spanish_ci default NULL,
  `points` bigint(20) unsigned default '0',
  `discount` double NOT NULL,
  `photo` blob default NULL,
  PRIMARY KEY  USING BTREE (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

# ---------------------------------------------
# -- Create the database user for lemon...   --

# This user is for connecting to mysql... which makes queries to mysql.
#If setting up a network of POS add each host (@box1, @box2, @box3)
#Here are only 'localhost' to ensure nobody else can do any changes from other host.

# Note: if you change the password to the lemonclient user (which is a must),
# also re-grant it again with the new password. see the grant below.

CREATE USER 'lemonclient'@'localhost' IDENTIFIED BY 'xarwit0721';
GRANT ALL ON lemondb.* TO 'lemonclient'@'localhost' IDENTIFIED BY 'xarwit0721';


# CREATE lemon users (users using lemon, cashiers... )
#With password 'linux'. Note that this password is salt-hashed (SHA56).

INSERT INTO lemondb.users (id, username, password, salt, name, role) VALUES (1, 'admin', 'C07B1E799DC80B95060391DDF92B3C7EF6EECDCB', 'h60VK', 'Administrator', 0);

#Insert a default measure (very important to keep this id)
INSERT INTO lemondb.measures (id, text) VALUES(1, 'Pc');
#Insert a default client
INSERT INTO lemondb.clients (id, name, points, discount) VALUES (1, 'General', 0, 0);
#Insert a default category
INSERT INTO lemondb.categories (catid, text) VALUES (1, 'General');
