package latexDraw.ui.components;

import java.awt.Color;
import java.awt.Insets;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;


/** 
 * This class define a new kind of button : a button with an coloured icon.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 03/15/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ColorButton extends JButton
{
	private static final long serialVersionUID = 1L;

	public static final Insets INSET_BUTTON = new Insets(1,1,1,1);
	
	
	public ColorButton()
	{
		super();
	}


	public ColorButton(Action a)
	{
		super(a);
	}


	public ColorButton(Icon icon)
	{
		super(icon);
	}

	
	public ColorButton(String text, Icon icon)
	{
		super(text, icon);
	}


	public ColorButton(String text)
	{
		super(text);
	}



	/**
	 * Set a new colour to the button.
	 * @param c The new colour.
	 * @since 1.9.1
	 */
	public void setColor(Color c)
	{
		((ButtonIcon)getIcon()).setColor(c);		
		repaint();
	}
	
	
	
	/**
	 * @return The colour of the icon of the button.
	 * @since 1.9.1
	 */
	public Color getColor()
	{
		if(((ButtonIcon)getIcon())==null)
			return null;
		
		return ((ButtonIcon)getIcon()).getColor();
	}
}
