package junit.test.svg;

import java.text.ParseException;

import junit.framework.TestCase;
import latexDraw.parsers.svg.elements.path.SVGPathSeg;
import latexDraw.parsers.svg.elements.path.SVGPathSegCurvetoQuadratic;
import latexDraw.parsers.svg.elements.path.SVGPathSegMoveto;
import latexDraw.parsers.svg.elements.path.SVGPathSeg.PathSeg;
import latexDraw.parsers.svg.parsers.SVGPathHandler;
import latexDraw.parsers.svg.parsers.SVGPathParser;

import org.junit.Test;

/** 
 * This class contains tests for the SVGPathSegCurvetoQuadratic class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/23/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGPathSegCurvetoQuadratic extends TestCase implements SVGPathHandler
{
	protected final SVGPathSegCurvetoQuadratic seg = new SVGPathSegCurvetoQuadratic(3e1, 4e-1, -5e1, 6.5, true);
	protected int cpt = 0;
	
	@Test
	public void testGetters()
	{
		assertEquals(seg.getX1(), -5e1);
		assertEquals(seg.getY1(), 6.5);
		assertEquals(seg.getX(), 3e1);
		assertEquals(seg.getY(), 4e-1);
		assertTrue(seg.isRelative());
		assertEquals(seg.getType(), PathSeg.CURVETO_QUADRATIC_REL);
	}
	
	
	@Test
	public void testToString()
	{
		SVGPathSegMoveto m = new SVGPathSegMoveto(0, 0, false);
		SVGPathParser parser = new SVGPathParser(m.toString() + " " + seg.toString(), this);
		
		try { parser.parse(); }
		catch(ParseException e) { fail(); }
	}


	
	public void onPathSeg(SVGPathSeg pathSeg)
	{
		if((pathSeg instanceof SVGPathSegMoveto) && cpt==0)
		{
			cpt++;
			return ;
		}
		
		assertTrue(pathSeg instanceof SVGPathSegCurvetoQuadratic);
		
		SVGPathSegCurvetoQuadratic seg2 = (SVGPathSegCurvetoQuadratic)pathSeg;		
		
		assertEquals(seg.getX(), seg2.getX());
		assertEquals(seg.getX1(), seg2.getX1());
		assertEquals(seg.getY(), seg2.getY());
		assertEquals(seg.getY1(), seg2.getY1());
		assertEquals(seg.isRelative(), seg2.isRelative());
	}
}
