/* $Id: lib_idp_list.c 3237 2007-05-30 17:17:45Z dlaniel $
 *
 * Lasso - A free implementation of the Liberty Alliance specifications.
 *
 * Copyright (C) 2004-2007 Entr'ouvert
 * http://lasso.entrouvert.org
 * 
 * Authors: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <lasso/xml/lib_idp_list.h>

/*
 * Schema fragment (liberty-idff-protocols-schema-v1.2.xsd):
 * 
 * <xs:element name="IDPList" type="IDPListType"/>
 * <xs:complexType name="IDPListType">
 *   <xs:sequence>
 *     <xs:element ref="IDPEntries"/>
 *     <xs:element ref="GetComplete" minOccurs="0"/>
 *   </xs:sequence>
 * </xs:complexType>
 * 
 * <xs:element name="GetComplete" type="xs:anyURI"/>
 */

/*****************************************************************************/
/* private methods                                                           */
/*****************************************************************************/

static struct XmlSnippet schema_snippets[] = {
	{ "IDPEntries", SNIPPET_NODE, G_STRUCT_OFFSET(LassoLibIDPList, IDPEntries) },
	{ "GetComplete", SNIPPET_CONTENT, G_STRUCT_OFFSET(LassoLibIDPList, GetComplete) },
	{ NULL, 0, 0}
};

/*****************************************************************************/
/* instance and class init functions                                         */
/*****************************************************************************/

static void
instance_init(LassoLibIDPList *node)
{
	node->IDPEntries = NULL;
	node->GetComplete = NULL;
}

static void
class_init(LassoLibIDPListClass *klass)
{
	LassoNodeClass *nclass = LASSO_NODE_CLASS(klass);

	nclass->node_data = g_new0(LassoNodeClassData, 1);
	lasso_node_class_set_nodename(nclass, "IDPList");
	lasso_node_class_set_ns(nclass, LASSO_LIB_HREF, LASSO_LIB_PREFIX);
	lasso_node_class_add_snippets(nclass, schema_snippets);
}

GType
lasso_lib_idp_list_get_type()
{
	static GType this_type = 0;

	if (!this_type) {
		static const GTypeInfo this_info = {
			sizeof (LassoLibIDPListClass),
			NULL,
			NULL,
			(GClassInitFunc) class_init,
			NULL,
			NULL,
			sizeof(LassoLibIDPList),
			0,
			(GInstanceInitFunc) instance_init,
		};

		this_type = g_type_register_static(LASSO_TYPE_NODE,
				"LassoLibIDPList", &this_info, 0);
	}
	return this_type;
}

/**
 * lasso_lib_idp_list_new:
 * 
 * Creates a new #LassoLibIDPList object.
 *
 * Return value: a newly created #LassoLibIDPList object
 **/
LassoNode*
lasso_lib_idp_list_new()
{
	return g_object_new(LASSO_TYPE_LIB_IDP_LIST, NULL);
}

