/*
 *   LADCCA
 *    
 *   Copyright (C) 2003 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_CONNECT_PARAMS_H__
#define __LADCCA_CONNECT_PARAMS_H__

#include <uuid/uuid.h>

#include <ladcca/internal_headers.h>

typedef struct _cca_connect_params cca_connect_params_t;

struct _cca_connect_params
{
  cca_protocol_t protocol_version;
  int            flags;
  char          *project;
  char          *working_dir;
  char          *class;
  uuid_t         id;
  int            argc;
  char         **argv;
};

cca_connect_params_t * cca_connect_params_new ();
void                   cca_connect_params_destroy (cca_connect_params_t *);

void cca_connect_params_set_project     (cca_connect_params_t *, const char *project);
void cca_connect_params_set_working_dir (cca_connect_params_t *, const char *working_dir);
void cca_connect_params_set_class       (cca_connect_params_t *, const char *class);

#endif /* __LADCCA_CONNECT_PARAMS_H__ */
