#
# spec file for LabPlot
#
# Copyright (c) 2006 Stefan Gerlach.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments to gerlach@mbi-berlin.de
#
# supports :
#	* SUSE 9.1, 9.2, 9.3, 10.0, 10.1
#	* SLES 9
#	* Fedora Core 1, 2, 3, 4, 5, 6
#	* RedHat 9
#	* Enterprise Linux 3,4
#	* Mandriva 2006,2007
#	* Mandrake 10.0, 10.1

%define version 1.5.1.6
%define release 1

################################################################################
# Distribution
# RedHat 9 doesn't like nested if statements :-(

%define is_suse		%(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora	%(test -e /etc/fedora-release && echo 1 || echo 0)
%define is_redhat	%(test -e /etc/redhat-release && echo 1 || echo 0)
%define is_mandrake	%(test -e /etc/mandrake-release  && echo 1 || echo 0)

%if %is_suse
%define is_sles   %(grep -q "Enterprise Server" /etc/SuSE-release && echo 1 || echo 0)
%else
%define is_sles 0
%endif

# Many redhat based distro's still have /etc/redhat-release arround
%if %is_redhat
%define is_redhat   %(grep -q "Red Hat" /etc/redhat-release && echo 1 || echo 0)
%endif

%define suse_version 0
%define sles_version 0
%define redhat_version 0
%define fedora_version 0
%define mandrake_version 0

%if %is_redhat
%define redhat_version	%(cat /etc/redhat-release |cut -f5 -d ' ')
%define distro		%(cat /etc/redhat-release)
%endif
%if "%{redhat_version}" == "AS"
%define redhat_version	%(cat /etc/redhat-release |cut -f7 -d ' ')
%endif

%if %is_fedora
%define fedora_release	%(rpm -q --queryformat '%{VERSION}' fedora-release)
%define fedora_version	%(echo "%fedora_release" | tr -d '.')
%define distro		Fedora Core %{fedora_release}
%endif

%if %is_mandrake
%define mandrake_release	%(cat /etc/mandrake-release | cut -f4 -d" ")
%define mandrake_version	%(echo "%mandrake_release" | tr -d '.')
%define distro			%(cat /etc/mandrake-release)
%endif
# Mandrake 10.1
%if "%{mandrake_version}" == "(Community)"
%define mandrake_release	%(cat /etc/mandrake-release | cut -f3 -d" ")
%define mandrake_version	%(echo "%mandrake_release" | tr -d '.')
%endif

%if %is_suse
%define suse_release	%(grep VERSION /etc/SuSE-release | cut -f3 -d" ")
%define suse_version	%(echo "%suse_release" | tr -d '.')
%define distro		SUSE Linux %{suse_release}
%endif
%if %is_sles
%define sles_version	%(grep VERSION /etc/SuSE-release | cut -f3 -d" ")
%define distro		SUSE LINUX Enterprise Server %{sles_version}
%endif

################################################################################
# Requirements

%if %{suse_version} >= 100
BuildRequires:	qt3-devel kdelibs3-devel libjasper libjpeg-devel ImageMagick-devel ImageMagick-Magick++-devel fftw3-devel fftw3-threads-devel audiofile-devel gsl qsa-devel suse-release
Requires:	qt3 kdelibs3 libjasper ImageMagick ImageMagick-Magick++ fftw3 fftw3-threads audiofile gsl qsa
%endif
%if %{suse_version} == 93
BuildRequires:	qt3-devel kdelibs3-devel libjpeg-devel ImageMagick-devel ImageMagick-Magick++-devel fftw3-devel fftw3-threads-devel qsa-devel audiofile-devel gsl
Requires:	qt3 kdelibs3 libjasper ImageMagick ImageMagick-Magick++ fftw3 qsa audiofile gsl ghostscript-library
%endif
%if %{suse_version} == 92
BuildRequires:	qt3-devel kdelibs3-devel libjpeg-devel ImageMagick-devel ImageMagick-Magick++-devel gsl qsa-devel netcdf fftw3-devel fftw3-threads-devel audiofile-devel
Requires:	qt3 kdelibs3 libjasper ImageMagick ImageMagick-Magick++ gsl fftw3 fftw3-threads qsa audiofile netcdf
%endif
%if %{sles_version} == 9
BuildRequires:	qt3-devel kdelibs3-devel libjpeg-devel audiofile gsl qsa-devel
Requires:	qt3 kdelibs3 libjasper audiofile gsl qsa
%else
%if %{suse_version} == 91
BuildRequires:	qt3-devel kdelibs3-devel libjpeg-devel ImageMagick-devel ImageMagick-Magick++ gsl fftw3-devel fftw3-threads-devel qsa-devel audiofile-devel netcdf
Requires:	qt3 kdelibs3 libjasper pstoedit ImageMagick ImageMagick-Magick++ gsl fftw3 fftw3-threads qsa audiofile netcdf
%endif
%endif

%if %{fedora_version} >= 5
BuildRequires:	qt-devel kdelibs-devel libexif-devel ImageMagick-devel ImageMagick-c++-devel gsl-devel libart_lgpl-devel audiofile-devel qt-qsa-devel libselinux-devel fedora-release
Requires:	qt kdelibs libart_lgpl ImageMagick ImageMagick-c++ gsl audiofile qt-qsa libselinux
%endif
%if %{fedora_version} > 1 && %{fedora_version} < 5
BuildRequires:	qt-devel kdelibs-devel libexif-devel ImageMagick-devel ImageMagick-c++-devel gsl-devel libart_lgpl-devel audiofile-devel qsa-devel libselinux-devel fedora-release
Requires:	qt kdelibs libart_lgpl ImageMagick ImageMagick-c++ gsl audiofile qsa libselinux
%endif
%if %{fedora_version} == 1
BuildRequires:	qt-devel kdelibs-devel ImageMagick-devel ImageMagick-c++-devel gsl-devel libart_lgpl-devel audiofile-devel qsa-devel fedorea-releaser
Requires:	qt kdelibs libart_lgpl ImageMagick ImageMagick-c++ gsl audiofile qsa
%endif

%if %is_redhat
BuildRequires:	qt-devel kdelibs-devel ImageMagick-devel ImageMagick-c++-devel gsl-devel libart_lgpl-devel audiofile-devel qsa-devel
Requires:	qt kdelibs libart_lgpl ImageMagick ImageMagick-c++ gsl audiofile qsa
%endif

%if %{mandrake_version} >= 20060
BuildRequires:	libaudiofile0-devel ImageMagick libjasper1.701_1-devel netcdf-devel libtiff3-devel libgsl0-devel
Requires:	libaudiofile0 ImageMagick jasper libjasper1.701_1 libtiff3 libgsl0
%endif
%if %{mandrake_version} == 100
BuildRequires:	ImageMagick, netcdf-devel, libaudiofile0-devel, libjasper1.701_1-devel, libgsl0-devel, libfftw3-devel
Requires:	libaudiofile0, ImageMagick, libjasper1.701_1, libgsl0, libfftw3
%endif
%if %{mandrake_version} == 101
BuildRequires:	libaudiofile0-devel, ImageMagick, netcdf-devel, libfftw3-devel, libgsl0-devel
Requires:	libaudiofile0, ImageMagick, netcdf-devel, libfftw3, libgsl0
%endif

################################################################################
# misc stuff

%define numprocs %(egrep -c ^cpu[0-9]+ /proc/stat)
%define gsl_version	%(gsl-config --version)

################################################################################
################################################################################

Name: 		LabPlot
URL:		http://labplot.sourceforge.net/
Version:	%{version}
Release:	%{release}
Distribution:	%distro
Summary:	Function and Data Plotter
Source:		%{name}-%{version}.tar.bz2
Group:		Applications/Engineering	
License:	GPL
Packager:	Stefan Gerlach <gerlach@mbi-berlin.de>
Vendor:		http://labplot.sourceforge.net/
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
LabPlot is a scientific 2D and 3D data and function plotting program. The
various display and analysis functions are explained in the handbook
(KDE help center).
%if %is_redhat || %is_fedora || %is_mandrake
Compiled for %distro
%endif

Authors:
--------
	%{packager}

%prep
%setup

%build
export CFLAGS="-O2 -Wall"
export CXXFLAGS="-O2 -Wall"
%ifarch x86_64 sparc64 ppc64 amd64
export CFLAGS="$CFLAGS -fPIC"
export CXXFLAGS="$CXXFLAGS -fPIC"
%endif

# libtoolize breaks everything on Mandrake 10.X
%if %{mandrake_version} <= 102
./configure \
%else
%configure \
%endif
--disable-static \
%ifarch x86_64 sparc64 ppc64 amd64
--enable-libsuffix=64 \
--with-qt-libraries=$QTDIR/lib64 \
%endif
%if "%gsl_version" != "1.6"
--enable-final
%endif

%{__make} -j%{numprocs}

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -f ../file.list.%{name}

%install
%{__make} DESTDIR="$RPM_BUILD_ROOT" install
cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(755\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.%{name}
find . -type f -o -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.%{name}
# fix manpage names
sed 's/\/labplot.1$/\/labplot.1\*/' $RPM_BUILD_DIR/file.list.%{name} > $RPM_BUILD_DIR/file.list.%{name}.tmp
sed 's/\/LabPlot.1$/\/LabPlot.1\*/' $RPM_BUILD_DIR/file.list.%{name}.tmp > $RPM_BUILD_DIR/file.list.%{name}

%post
/sbin/ldconfig -n %(kde-config --prefix)/%_lib

%postun
/sbin/ldconfig -n %(kde-config --prefix)/%_lib

%files -f ../file.list.%{name}
%doc README TODO BUGS WISHLIST INSTALL ChangeLog CHANGES FEATURES AUTHORS CREDITS LabPlot.lsm

%changelog
* Sat Oct 28 2006 - stefan.gerlach@uni-konstanz.de
- added support for Mandriva 2007, Fedora Core 6
* Tue Apr 11 2006 - gerlach@mbi-berlin.de
- fixed manpage in file list
- use BuildRequires insted of BuildPrereq
* Sat Apr 08 2006 - gerlach@mbi-berlin.de
- update for 1.5.1.1
* Sat Apr 02 2006 - gerlach@mbi-berlin.de
- fix manpage names
* Sat Mar 25 2006 - gerlach@mbi-berlin.de
- added support for EL 3,4, Mandrake 10.0, 10.1
* Wed Mar 22 2006 - gerlach@mbi-berlin.de
- added support for FC-5
* Sat Mar 18 2006 - gerlach@mbi-berlin.de
- added support for FC1-4, RH 9, Mandriva 2006.0
* Thu Mar 16 2006 - gerlach@mbi-berlin.de
- added support for SLES 9
* Wed Mar 15 2006 - gerlach@mbi-berlin.de
- created from SUSE 10.0 spec file
