/***************************************************************************
 *
 *  $Id: kzensmartplaylistdialog.cpp,v 1.5 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <kcombobox.h>
#include <klineedit.h>
#include <kpushbutton.h>

#include <qradiobutton.h>
#include <qvgroupbox.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qhbuttongroup.h>
#include <klocale.h>

#include "kzensmartplaylist.h"
#include "kzensearch.h"
#include "kzensearchwidget.h"

#include "kzensmartplaylistdialog.h"

KZenSmartPlayListDialog::KZenSmartPlayListDialog(QWidget *parent,
						 const char *name)
  :KDialogBase(parent, name, true, i18n("Smart Playlist - KZenExplorer"), Ok|Cancel)
{
  fPlayList = 0;

  QVBox * page = makeVBoxMainWidget();

  QHBox * box = new QHBox(mainWidget());
  box->setSpacing(5);

  new QLabel(i18n("Playlist name:"), box);
  fNameEdit = new KLineEdit(i18n("New Smart Playlist"), box);
  connect(fNameEdit, SIGNAL(textChanged(const QString &)),
	  this, SLOT(slotNameChanged(const QString &)));
  page->setStretchFactor(box,0);

  fSearchWidget = new KZenSearchWidget(mainWidget(),"search");
  page->setStretchFactor(fSearchWidget,1);

  actionButton(Ok)->setAutoDefault(FALSE);
  actionButton(Ok)->setDefault(FALSE);

  actionButton(Cancel)->setAutoDefault(FALSE);
  actionButton(Cancel)->setDefault(FALSE);
}

KZenSmartPlayListDialog::~KZenSmartPlayListDialog()
{

}
 
void KZenSmartPlayListDialog::setPlayList(KZenSmartPlayList * pl)
{
  fPlayList = pl;
  fNameEdit->setText(fPlayList->getName());
  
  fSearchWidget->setSearch(pl->getSearch());
}

void KZenSmartPlayListDialog::slotNameChanged(const QString & t)
{
  fPlayList->setName(t);
}

#include "kzensmartplaylistdialog.moc"
