/***************************************************************************
 *
 *  $Id: kzensmartplaylist.cpp,v 1.9 2005/06/02 07:09:01 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <kglobal.h>
#include <kstandarddirs.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <knuminput.h>
#include <kdebug.h>
#include <kiconloader.h>

#include <qlistbox.h>

#include "kzensearch.h"
#include "kzenratingwidget.h"

#include "kzensmartplaylist.h"

KZenSmartPlayList::KZenSmartPlayList(const char * name)
  :KZenPlayList(name)
{
  fSearch = new KZenSearch();
}

KZenSmartPlayList::KZenSmartPlayList(KZenSmartPlayList * pl)
{
  setName(pl->getName());

  fSearch = new KZenSearch(pl->getSearch());
}

KZenSmartPlayList::~KZenSmartPlayList()
{
  delete fSearch;
}

void KZenSmartPlayList::init(njb_playlist_t * pl, QPtrList<KZenTrack> * tracks)
{
  njb_playlist_track_t * track;
  
  setID(pl->plid);
  
  KZenTrack * temp;
  NJB_Playlist_Reset_Gettrack(pl);
  while ((track = NJB_Playlist_Gettrack(pl)) ) {
    temp = 0;
    for (uint tr=0;tr<tracks->count();tr++) {
      temp = tracks->at(tr);
      if (temp->getTrackID()==track->trackid) break;
      temp = 0;
    }
    if (temp) {
      fTracks->append(temp);
    } else {
      setModified(true);
    }
  }
  
  NJB_Playlist_Destroy(pl);
  
  for (int i=0;i<(int)fTracks->count();i++) {
    temp = fTracks->at(i);
    if (!checkTrack(temp)) {
      if (fTracks->remove(temp)) {
	i--;
      }
    }
  }
}

void KZenSmartPlayList::refresh(KZenTrack * track)
{
  kdDebug() << "KZenSmartPlayList::refresh track -> " << getName() << endl;

  if (!checkTrack(track)) {
    if (fTracks->remove(track)) {
      setModified(true);
    }
  } else {
    if (fTracks->findRef(track)==-1) {
      addTrack(track);
    }
  }
}

void KZenSmartPlayList::refresh(QPtrList<KZenTrack> * tracks)
{
  kdDebug() << "KZenSmartPlayList::refresh tracklist -> " << getName() << endl;

  KZenTrack * track;
  for (int i=0;i<(int)fTracks->count();i++) {
    track = fTracks->at(i);
    if (!checkTrack(track)) {
      if (fTracks->remove(track)) {
	i--;
	setModified(true);
      }
    }
  }
  
  for (uint i=0;i<tracks->count();i++) {
    track = tracks->at(i);
    if (fTracks->findRef(track)==-1) {
      addTrack(track);
    }
  }
}

bool KZenSmartPlayList::checkTrack(KZenTrack * track)
{
  return fSearch->checkTrack(track);
}

void KZenSmartPlayList::addTrack(KZenTrack * track)
{
  if (checkTrack(track)) {
    std::cout  << "add " << track->getTitle() << std::endl;
    fTracks->append(track);
    setModified(true);
  }
}

void KZenSmartPlayList::assign(KZenSmartPlayList * pl)
{
  setName(pl->getName());

  fSearch->assign(pl->getSearch());
}

KZenSmartPlayListItem::KZenSmartPlayListItem(QListView * parent, 
					     KZenSmartPlayList * PlayList)
  :KZenPlayListItem(parent,PlayList)
{
  fItemType = KZenItem::ItemTypeSmartPlayList;
  setPixmap(0, UserIcon("smartplaylist.png", 16));

  fSortColumn = KZen::FieldUnknown;
  fSortOrder = Qt::Ascending;
}

KZenSmartPlayListItem::~KZenSmartPlayListItem()
{
  
}

QDataStream & operator<<(QDataStream & s, 
			 KZenSmartPlayList & spl)
{
  s << *(spl.getSearch());

  return s;
}

QDataStream & operator>>(QDataStream & s, 
			 KZenSmartPlayList & spl)
{
  s >> *(spl.getSearch());

  return s;
}
