/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _TAGLIBINTERFACE_H_
#define _TAGLIBINTERFACE_H_

//QT-Libs used
#include <qstring.h>
#include <qpixmap.h>
#include <qfileinfo.h>
#include <qbuffer.h>

//taglib-library-includes
#include <taglib/audioproperties.h>
#include <taglib/mpegfile.h>
#include <taglib/id3v2tag.h>
#include <taglib/id3v1tag.h>
#include <taglib/attachedpictureframe.h>
#include <taglib/id3v2frame.h>
#include <taglib/textidentificationframe.h>
#include <taglib/fileref.h>

//own includes from kyamo
#include "mediatag.h"
#include "genrehelper.h"

//We need the Prototype of mediatag here, cause we need it for taglibfile
class mediatag;

//Our motherclass for id3tags is the taglibfile

/*Class for handling taglib-related files
 *only constructor save and set functions are reachable from not members of the class
 *all the other stuff is handled by this 3 functions
 *also the tags themself are reachable from outside
 *so the class is easy to handle from outside*/
class taglibfile
{
public:
  taglibfile(QString);
  ~taglibfile();
  bool saveFile(int);
  void setTags(mediatag);
  void readTags();
  void readPicture();
  bool containsV1Tag;
  bool containsV2Tag;
  bool readsuccess;
  int bitrate;
  long songlength;
  mediatag v1tag;
  mediatag v2tag;
private:
  TagLib::MPEG::File *workingfile;
  QString filename;
  //helperfunctions needed top get taglib running
  QString stripTextv2(QString);
  QPixmap stripPicture();
  void setPicture(QPixmap);
  void removePicture();
  void putText(QString,QString);
  void setTagContentv1();
  void setTagContentv2();
  void getTagContentv1();
  void getTagContentv2();
};

#endif //_TAGLIBINTERFACE_H_
