/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#define APPNAME  "K-YAMO"


#include "tableiste.h"

extern rcdatei settingsfile;
extern bool cdparanoia_exists;

tableiste::tableiste()
{
    this->setAcceptDrops(TRUE);
    loader=new KIconLoader("KYamo");
    QPixmap pixmap;
    QString bildname="edit.png";
    this->setCaption(APPNAME);
    tagger=new QVBox(this);
    tagmask=new tagdialog(tagger);
    tagger->setMargin(5);
    pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
    if (!pixmap.isNull())
    {
        QIconSet taggerset(pixmap);
        addTab(tagger,taggerset,i18n("tagger"));
    }
    else
        addTab(tagger,i18n("tagger"));

    if (cdparanoia_exists)
    {
        ripper=new QVBox(this);
        rippermask=new ripperdialog(ripper);
        bildname="cdaudio_unmount.png";
        pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
        if (!pixmap.isNull())
        {
            QIconSet ripperset(pixmap);
            addTab(ripper,ripperset,i18n("ripper"));
        }
        else
            addTab(ripper,i18n("ripper"));
    }

    settings=new QVBox(this);
    settingsmask=new settingsmaindialog(settings);
    settings->setMargin(5);
    settings->setSpacing(5);
    bildname="configure.png";
    pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
    if (!pixmap.isNull())
    {
        QIconSet settingsset(pixmap);
        addTab(settings,settingsset,i18n("settings"));
    }
    else
        addTab(settings,i18n("settings"));

    about=new QVBox(this);
    bildname="kyamo.png";
    pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
    aboutmask=new aboutdialog(about);
    about->setMargin(5);
    about->setSpacing(5);
    if (!pixmap.isNull())
    {
        QIconSet aboutset(pixmap);
        addTab(about,aboutset,i18n("about"));
    }
    else
        addTab(about,i18n("about"));
    this->setOkButton(QString::null);
    this->showPage(tagger);
    connect (settingsmask,SIGNAL(directorychange()),tagmask,SLOT(listboxholen()));
    connect (settingsmask,SIGNAL(autocompletesignal(bool)), tagmask,SLOT(setvervollstaendigen(bool)));
    if (cdparanoia_exists)
        connect (settingsmask,SIGNAL(autocompletesignal(bool)),rippermask,SLOT(setAutocomplete(bool)));
    connect (settingsmask,SIGNAL(databasechangesignal()),tagmask,SLOT(databasechangeslot()));
    connect (settingsmask,SIGNAL(databasechangesignal()),rippermask,SLOT(databasechangeslot()));
    delete loader;
}

tableiste::~tableiste()
{
    cerr<<"Mainwindow destructor"<<endl;
    delete tagmask;
    delete tagger;
    if (cdparanoia_exists)
    {
        delete rippermask;
        delete ripper;
    }
    delete settingsmask;
    delete settings;
    delete aboutmask;
    delete about;
}

//####################################################################
//#              Drag and Drop routine                               #
//####################################################################
void tableiste::dragEnterEvent(QDragEnterEvent *ev)
{
    //Only accept single files or directories as drops
    ev->accept(QUriDrag::canDecode(ev)||QImageDrag::canDecode(ev));
    //ev->accept(QImageDrag::canDecode(ev));
}

void tableiste::dropEvent(QDropEvent *ev)
{
    //set readingdir_path to dropped files directory
    QString dir;
    QImage image;
    if ( QImageDrag::decode(ev,image) )
    {
        //send Imagesignal to listening slots;
        emit gotImage(image);
    }
    else  if (QTextDrag::decode(ev,dir))
    {
        QUrl url(dir);
        if (url.hasPath())
        {
            dir=url.path();
            QFileInfo filecheck(dir);
            if (filecheck.isDir())
            {
                //append an / to the end of the string and reread the listview
                settingsfile.reading_dir=QString("%1/").arg(dir);
                //settingsmask->readingpathledit->setText(settingsfile.reading_dir);
                this->showPage(tagger);
                tagmask->listboxholen();
            }
            else if(filecheck.isFile())
            {
                //Check if file is audiofile or picture
                if (dir.contains("jpg")||dir.contains(".jpeg"))
                {
                    QImage image;
                    if(image.load(dir))
                    {
                        QWidget *currentinfront=this->currentPage();
                        if (currentinfront==tagger)
                        {
                            connect(this,SIGNAL(gotImage(QImage)),tagmask,SLOT(imageDropped(QImage)));
                            emit gotImage(image);
                            kapp->processEvents();
                            //wait till transferring is read than disconnect slot
                            disconnect(this,SIGNAL(gotImage(QImage)),tagmask,SLOT(imageDropped(QImage)));
                        }
                        else if(currentinfront==ripper)
                        {
                            connect(this,SIGNAL(gotImage(QImage)),rippermask,SLOT(imageDropped(QImage)));
                            emit gotImage(image);
                            kapp->processEvents();
                            //wait till transferring is read than disconnec slot
                            disconnect(this,SIGNAL(gotImage(QImage)),rippermask,SLOT(imageDropped(QImage)));
                        }
                    }
                }
                else if(dir.contains(".mp3")||dir.contains(".ogg"))
                {
                    //strip out the directory of the file
                    dir=dir.left(dir.findRev("/")+1);
                    settingsfile.reading_dir=dir;
                    //settingsmask->readingpathledit->setText(settingsfile.reading_dir);
                    this->showPage(tagger);
                    tagmask->listboxholen();
                    //bring tagger to front
                }
                else
                {
                    //Check if we can load file as image
                    QImage image;
                    if(image.load(dir))
                    {
                        QWidget *currentinfront=this->currentPage();
                        if (currentinfront==tagger)
                        {
                            connect(this,SIGNAL(gotImage(QImage)),tagmask,SLOT(imageDropped(QImage)));
                            emit gotImage(image);
                            kapp->processEvents();
                            //wait till transferring is read than disconnect slot
                            disconnect(this,SIGNAL(gotImage(QImage)),tagmask,SLOT(imageDropped(QImage)));
                        }
                        else if(currentinfront==ripper)
                        {
                            connect(this,SIGNAL(gotImage(QImage)),rippermask,SLOT(imageDropped(QImage)));
                            emit gotImage(image);
                            kapp->processEvents();
                            //wait till transferring is read than disconnect slot
                            disconnect(this,SIGNAL(gotImage(QImage)),rippermask,SLOT(imageDropped(QImage)));
                        }
                    }
                }
            }
        }
    }
}

void tableiste::closeEvent(QCloseEvent *ce)
{
    //Check if some tags have changed since last select
    if (!tagmask->tagschanged)
    {
        //save settings
        settingsfile.save();
        ce->accept();
        return;
    }
    else
    {
        while(tagmask->tagschanged)
        {
            int result=0;
            if (!(result=QMessageBox::warning(0,i18n("Save files"),i18n("Some of the selected files have edited tags. Do want to save your files first?"),"Save first",i18n("Quit"),i18n("Chancel"),1)))
                tagmask->savemodified();
            else if (result==1)
            {
                settingsfile.save();
                ce->accept();
                return;
            }
            else if (result==2)
            {
                ce->ignore();
                return;
            }
        }
    }
    settingsfile.save();
    ce->accept();
    return;
}

void tableiste::initapplication()
{
    //settingsmask->start();
    tagmask->listboxholen();
}
