/**************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
using namespace std;

#include "passwordbox.h"

passwordbox::passwordbox()
{
    this->setCaption(i18n("password-inquiry"));
    vertikal=new QVBoxLayout(this);
    vertikal->setMargin(10);
    vertikal->setSpacing(10);
    QBoxLayout *userlayout=new QHBoxLayout(this);
    QBoxLayout *passwordlayout=new QHBoxLayout(this);
    QBoxLayout *buttonslayout=new QHBoxLayout(this);
  keylabel=new QLabel(this);
  keylabel->setAlignment(Qt::AlignCenter);
  KIconLoader *loader=new KIconLoader();
  QString picname;
  picname=QString("password.png");
  keyicon=loader->loadIcon(picname,KIcon::NoGroup);
  keylabel->setPixmap(keyicon);
  delete loader;
    infolabel=new QLabel (i18n("<center>please insert username, and password for MySQL-access<br>so that helper-database can be built!</center>"),this);
    infolabel->setMinimumSize(500,70);
    vertikal->addWidget(keylabel);
    vertikal->addWidget(infolabel);
    userlabel=new QLabel(i18n("username"),this);
    userledit=new QLineEdit(this);
    userledit->setMinimumSize(200,30);
    userlayout->addWidget(userlabel,5);
    userlayout->addWidget(userledit,10);
    passlabel=new QLabel(i18n("password"),this);
    passledit=new QLineEdit(this);
    passledit->setMinimumSize(200,30);
    passledit->setEchoMode(QLineEdit::Password);
    passwordlayout->addWidget(passlabel,5);
    passwordlayout->addWidget(passledit,10);
    okknopf=new QPushButton(i18n("&OK"),this);
    okknopf->setEnabled(FALSE);
    abbruchknopf=new QPushButton(i18n("&cancel"),this);
    buttonslayout->addWidget(okknopf);
    buttonslayout->addWidget(abbruchknopf);
    vertikal->addLayout(userlayout);
    vertikal->addLayout(passwordlayout);
    vertikal->addLayout(buttonslayout);
    connect(abbruchknopf,SIGNAL(clicked()),this,SLOT(abbrechenpressed()));
    connect(okknopf,SIGNAL(clicked()),this,SLOT(okpressed()));
    connect(userledit,SIGNAL(textChanged(const QString &)),this,SLOT(okfreigeben()));
}

passwordbox::~ passwordbox()
{
    delete keylabel;
    delete infolabel;
    delete userlabel;
    delete passlabel;
    delete vertikal;
    delete userlayout;
    delete passwordlayout;
    delete buttonslayout;
    delete userledit;
    delete passledit;
    delete okknopf;
    delete abbruchknopf;

}

void passwordbox::okfreigeben()
{
    if(!(userledit->text().isEmpty()))
        okknopf->setEnabled(TRUE);
    else
        okknopf->setEnabled(FALSE);
}

void passwordbox::abbrechenpressed()
{
    emit abort();
   this->close();
}
void passwordbox::okpressed()
{
    username=userledit->text();
    password=passledit->text();
    emit success(username,password);
    this->close();
}
